/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.config.IRuntimeConfiguration;
import prompto.config.TempDirectories;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Mode;
import prompto.runtime.Standalone;
import prompto.server.AppServer;
import prompto.store.Family;
import prompto.store.IStore;
import prompto.store.mongo.BaseMongoTest;

public class TestMongoBootstrap
extends BaseMongoTest {
    @Before
    public void before() throws Exception {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
        this.createStore("APPS");
        Standalone.bootstrapCodeStore((IStore)this.store, (IRuntimeConfiguration)this.newRuntimeConfig());
    }

    private IRuntimeConfiguration newRuntimeConfig() {
        return new IRuntimeConfiguration.Inline().withRuntimeLibs(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class})).withApplicationVersion(PromptoVersion.parse((String)"1.0.0")).withApplicationName("test").withLoadRuntime(false).withRuntimeMode(Mode.UNITTEST);
    }

    @Test
    public void testCodeStoreColumns() throws Throwable {
        Assert.assertEquals((Object)Family.UUID, (Object)this.store.getAttributeInfo("dbId").getFamily());
        Assert.assertEquals((Object)Family.DATETIME, (Object)this.store.getAttributeInfo("timeStamp").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("category").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("name").getFamily());
        Assert.assertEquals((Object)Family.BOOLEAN, (Object)this.store.getAttributeInfo("storable").getFamily());
        Assert.assertEquals((Object)Family.VERSION, (Object)this.store.getAttributeInfo("version").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("prototype").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("dialect").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("body").getFamily());
    }

    @Test
    public void testCodeStoreIsolation() throws Throwable {
        Assert.assertEquals((Object)Family.UUID, (Object)this.store.getAttributeInfo("dbId").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("name").getFamily());
        Assert.assertEquals((Object)Family.VERSION, (Object)this.store.getAttributeInfo("version").getFamily());
        Assert.assertNull((Object)ApplicationContext.get().findAttribute("prototype"));
    }
}

