/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import prompto.config.IRuntimeConfiguration;
import prompto.config.TempDirectories;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Mode;
import prompto.runtime.Standalone;
import prompto.server.AppServer;
import prompto.store.Family;
import prompto.store.IStore;
import prompto.store.solr.EmbeddedSOLRStore;

@Ignore(value="Until we need it")
public class TestSOLRBootstrap {
    EmbeddedSOLRStore store;

    @Before
    public void before() throws Exception {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
        this.store = this.newEmbeddedStore();
        this.store.startContainer();
        this.store.startServerWithEmptyCore();
        Standalone.bootstrapCodeStore((IStore)this.store, (IRuntimeConfiguration)this.newRuntimeConfig());
    }

    private IRuntimeConfiguration newRuntimeConfig() {
        return new IRuntimeConfiguration.Inline().withRuntimeLibs(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class})).withApplicationVersion(PromptoVersion.parse((String)"1.0.0")).withApplicationName("test").withLoadRuntime(false);
    }

    private EmbeddedSOLRStore newEmbeddedStore() {
        return new EmbeddedSOLRStore(new File("target/test-classes/solr-test"), "APPS");
    }

    @After
    public void after() throws IOException {
        this.store.shutdownServer();
        this.store.shutdownCore();
        this.store.shutdownContainer();
    }

    @Test
    public void testCodeStoreColumns() throws Throwable {
        Assert.assertEquals((Object)Family.UUID, (Object)this.store.getAttributeInfo("dbId").getFamily());
        Assert.assertEquals((Object)Family.DATETIME, (Object)this.store.getAttributeInfo("timeStamp").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("category").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("name").getFamily());
        Assert.assertEquals((Object)Family.BOOLEAN, (Object)this.store.getAttributeInfo("storable").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("version").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("prototype").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("dialect").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("body").getFamily());
    }

    @Test
    public void testCodeStoreIsolation() throws Throwable {
        Assert.assertEquals((Object)Family.UUID, (Object)this.store.getAttributeInfo("dbId").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("name").getFamily());
        Assert.assertEquals((Object)Family.TEXT, (Object)this.store.getAttributeInfo("version").getFamily());
        Assert.assertNull((Object)ApplicationContext.get().findAttribute("prototype"));
    }
}

