/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import prompto.debug.IDebugEvent;
import prompto.debug.Serializer;
import prompto.debug.WebSocketDebugEventAdapter;
import prompto.utils.Logger;

public class DebugEventServlet
extends WebSocketServlet {
    static Logger logger = new Logger();
    DebuggerWebSocketCreator creator = new DebuggerWebSocketCreator();

    public void setAdapter(WebSocketDebugEventAdapter adapter) {
        this.creator.setAdapter(adapter);
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)this.creator);
    }

    static class DebuggerWebSocketListener
    implements WebSocketListener {
        WebSocketDebugEventAdapter adapter;
        Session session;

        public DebuggerWebSocketListener(WebSocketDebugEventAdapter adapter) {
            this.adapter = adapter;
        }

        private void send(IDebugEvent event) {
            logger.debug(() -> "Server sending " + event.getType().name());
            try {
                String message = Serializer.writeDebugEvent((IDebugEvent)event);
                this.session.getRemote().sendString(message);
            }
            catch (Throwable t) {
                logger.error(() -> "While sending: " + event, t);
            }
        }

        public void onWebSocketConnect(Session session) {
            logger.debug(() -> "Server socket connecting");
            if (session == this.session) {
                return;
            }
            if (this.session != null) {
                this.adapter.setSession(null);
                this.send((IDebugEvent)new IDebugEvent.Terminated());
            }
            this.session = session;
            this.adapter.setSession(session);
            this.send((IDebugEvent)new IDebugEvent.Connected());
        }

        public void onWebSocketText(String message) {
            logger.debug(() -> "Server received: " + message);
        }

        public void onWebSocketBinary(byte[] payload, int offset, int len) {
        }

        public void onWebSocketClose(int statusCode, String reason) {
            logger.debug(() -> "Server socket closing");
            this.adapter.setSession(null);
            this.session = null;
        }

        public void onWebSocketError(Throwable cause) {
            logger.error(() -> "Server socket error", cause);
        }
    }

    static class DebuggerWebSocketCreator
    implements WebSocketCreator {
        WebSocketDebugEventAdapter adapter;

        DebuggerWebSocketCreator() {
        }

        public void setAdapter(WebSocketDebugEventAdapter adapter) {
            this.adapter = adapter;
        }

        public DebuggerWebSocketListener createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            return new DebuggerWebSocketListener(this.adapter);
        }
    }
}

