/*
 * Decompiled with CFR 0.152.
 */
package prompto.security.auth.method;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.B64Code;
import prompto.utils.Logger;

final class BasicAuthenticatorWithXAuthorization
extends BasicAuthenticator {
    static final Logger logger = new Logger();

    BasicAuthenticatorWithXAuthorization() {
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String credentials = request.getHeader(HttpHeader.AUTHORIZATION.asString());
        if (credentials == null && request.getHeader("X-Authorization") != null) {
            logger.debug(() -> "Using X-Authorization for Authorization");
            credentials = request.getHeader("X-Authorization");
        }
        try {
            String method;
            int space;
            if (!mandatory) {
                return new DeferredAuthentication((LoginAuthenticator)this);
            }
            if (credentials != null && (space = credentials.indexOf(32)) > 0 && "basic".equalsIgnoreCase(method = credentials.substring(0, space))) {
                String password;
                String username;
                UserIdentity user;
                credentials = credentials.substring(space + 1);
                int i = (credentials = B64Code.decode((String)credentials, (Charset)StandardCharsets.ISO_8859_1)).indexOf(58);
                if (i > 0 && (user = this.login(username = credentials.substring(0, i), password = credentials.substring(i + 1), (ServletRequest)request)) != null) {
                    return new UserAuthentication(this.getAuthMethod(), user);
                }
            }
            if (DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                return Authentication.UNAUTHENTICATED;
            }
            response.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), "basic realm=\"" + this._loginService.getName() + '\"');
            response.sendError(401);
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }
}

