/*
 * Decompiled with CFR 0.152.
 */
package prompto.security.auth.source;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import prompto.config.IConfigurationReader;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;
import prompto.security.auth.source.IAuthenticationSource;

public interface IAuthenticationSourceFactory {
    public static IAuthenticationSourceFactory newFactory(String factoryName) throws Throwable {
        Class<?> klass = Class.forName(factoryName, true, Thread.currentThread().getContextClassLoader());
        if (!IAuthenticationSourceFactory.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Not an authentication source factory: " + factoryName);
        }
        return (IAuthenticationSourceFactory)klass.newInstance();
    }

    public IAuthenticationSourceConfiguration newConfiguration(IConfigurationReader var1);

    public void setConfiguration(IAuthenticationSourceConfiguration var1);

    public String installJettyLoginModule();

    public String getJettyLoginModuleName();

    public YamlMapping toYaml() throws YamlException;

    public IAuthenticationSource newAuthenticationSource();
}

