/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import prompto.cloud.Cloud;
import prompto.config.IConfigurationReader;
import prompto.config.IDebugConfiguration;
import prompto.config.IRuntimeConfiguration;
import prompto.config.IServerConfiguration;
import prompto.config.ServerConfiguration;
import prompto.config.YamlConfigurationReader;
import prompto.debug.DebugEventServlet;
import prompto.debug.DebugRequestServlet;
import prompto.debug.HttpServletDebugRequestListener;
import prompto.debug.IDebugEventAdapter;
import prompto.debug.WebSocketDebugEventAdapter;
import prompto.declaration.IMethodDeclaration;
import prompto.error.ReadWriteError;
import prompto.error.TerminatedError;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.libraries.Libraries;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.runtime.Interpreter;
import prompto.runtime.Standalone;
import prompto.security.auth.source.IAuthenticationSource;
import prompto.server.CleverServlet;
import prompto.server.JettyServer;
import prompto.server.ServerIdentifierProcessor;
import prompto.server.UserServlet;
import prompto.utils.CmdLineParser;
import prompto.utils.Logger;
import prompto.value.DocumentValue;

public class AppServer {
    static final Logger logger = new Logger();
    public static final String WEB_SERVER_SUCCESSFULLY_STARTED = "Web server successfully started on port ";
    static JettyServer jettyServer;
    static ThreadLocal<String> httpUser;
    static ThreadLocal<DocumentValue> httpSession;

    public static void main(String[] args) throws Throwable {
        AppServer.main(args, null);
    }

    public static void main(String[] args, Consumer<IServerConfiguration> afterStart) throws Throwable {
        IServerConfiguration config = AppServer.loadConfiguration(args);
        AppServer.main(config, afterStart);
    }

    public static <T extends IServerConfiguration> void main(T config, Consumer<T> afterStart) throws Throwable {
        AppServer.installCloudJARs();
        AppServer.initialize(config);
        AppServer.run(config);
        if (afterStart != null) {
            afterStart.accept(config);
        }
    }

    private static void installCloudJARs() throws Exception {
        Cloud cloud = Cloud.current();
        if (cloud == null) {
            return;
        }
        Collection<URL> jars = cloud.getJarURsL();
        if (jars == null) {
            return;
        }
        jars = AppServer.filterOutAlreadyLoadedJars(jars);
        AppServer.addJarsToSystemClassLoader(jars);
    }

    private static Collection<URL> filterOutAlreadyLoadedJars(Collection<URL> jars) {
        URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        HashSet<URL> alreadyLoaded = new HashSet<URL>(Arrays.asList(loader.getURLs()));
        return jars.stream().filter(u -> !alreadyLoaded.contains(u)).collect(Collectors.toList());
    }

    private static void addJarsToSystemClassLoader(Collection<URL> jars) throws Exception {
        URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        for (URL url : jars) {
            logger.debug(() -> "Adding JAR " + url.toString() + " to system class loader...");
            method.invoke((Object)loader, url);
        }
    }

    public static void initialize(IServerConfiguration config) throws Throwable {
        ServerIdentifierProcessor.register();
        Standalone.initialize((IRuntimeConfiguration)config);
    }

    public static IServerConfiguration loadConfiguration(String[] args) throws Exception {
        Map argsMap = CmdLineParser.read((String[])args);
        IConfigurationReader reader = Standalone.readerFromArgs((Map)argsMap);
        ServerConfiguration config = new ServerConfiguration(reader, argsMap);
        return (IServerConfiguration)config.withRuntimeLibs(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class}));
    }

    private static void run(IServerConfiguration config) throws Throwable {
        AppServer.startServer(config, (jetty, list) -> AppServer.prepareWebHandlers(jetty, list), () -> ApplicationContext.get().notifyCompleted());
    }

    static int startServer(IServerConfiguration config, BiConsumer<JettyServer, HandlerList> handler, Runnable serverStopped) throws Throwable {
        IDebugConfiguration debug = config.getDebugConfiguration();
        if (debug == null) {
            return AppServer.doStartServer(config, handler, ApplicationContext.get(), null, null, serverStopped);
        }
        Context context = Standalone.startProcessDebugger((IDebugConfiguration)debug);
        return AppServer.doStartServer(config, handler, context, AppServer::serverPrepared, () -> AppServer.serverStarted(context), () -> AppServer.serverStopped(serverStopped));
    }

    static void serverPrepared() {
        if (Standalone.getDebugRequestListener() instanceof HttpServletDebugRequestListener) {
            ((HttpServletDebugRequestListener)Standalone.getDebugRequestListener()).wire();
        }
        if (Standalone.getDebugEventAdapter() instanceof WebSocketDebugEventAdapter) {
            ((WebSocketDebugEventAdapter)Standalone.getDebugEventAdapter()).wire();
        }
    }

    static void serverStarted(Context context) {
        context.notifyCompleted();
    }

    static void serverStopped(Runnable runnable) {
        ApplicationContext.get().notifyCompleted();
        Standalone.stopProcessDebugger();
        if (runnable != null) {
            runnable.run();
        }
    }

    static int doStartServer(IServerConfiguration config, BiConsumer<JettyServer, HandlerList> handler, Context context, Runnable serverPrepared, Runnable serverStarted, Runnable serverStopped) throws Throwable {
        logger.info(() -> "Starting web server on port " + config.getHttpConfiguration().getPort() + "...");
        jettyServer = new JettyServer(config);
        jettyServer.prepare(handler);
        if (serverPrepared != null) {
            serverPrepared.run();
        }
        AppServer.start(serverStopped);
        int port = jettyServer.getHttpPort();
        logger.info(() -> WEB_SERVER_SUCCESSFULLY_STARTED + port);
        IDebugEventAdapter adapter = Standalone.getDebugEventAdapter();
        if (adapter instanceof WebSocketDebugEventAdapter) {
            ((WebSocketDebugEventAdapter)adapter).waitSession();
        }
        AppServer.callServerAboutToStart(config, context);
        if (serverStarted != null) {
            serverStarted.run();
        }
        if (adapter != null) {
            adapter.handleReadyEvent();
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callServerAboutToStart(IServerConfiguration config, Context context) {
        String serverAboutToStartMethod = config.getServerAboutToStartMethod();
        if (serverAboutToStartMethod != null) {
            try {
                logger.info(() -> "Calling startUp method '" + serverAboutToStartMethod + "'");
                Interpreter.interpretMethod((Context)context, (Identifier)new Identifier(serverAboutToStartMethod), (IExpression)Standalone.argsToArgValue((Map)config.getArguments()));
            }
            catch (TerminatedError terminatedError) {
            }
            finally {
                context.notifyCompleted();
            }
        }
    }

    static void prepareWebHandlers(JettyServer jetty, HandlerList list) {
        try {
            list.addHandler((Handler)jetty.newWebAppHandler());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int start(Runnable serverStopped) throws Throwable {
        if (jettyServer.isStarted()) {
            throw new RuntimeException("Server is already started!");
        }
        jettyServer.jettyStart(serverStopped);
        return jettyServer.getHttpPort();
    }

    public static void stop() throws Exception {
        if (jettyServer == null || !jettyServer.isStarted()) {
            throw new RuntimeException("Server is not started!");
        }
        jettyServer.jettyStop();
    }

    public static boolean isStarted() {
        return jettyServer != null && jettyServer.isStarted();
    }

    public static DebugRequestServlet getDebugRequestServlet() {
        return jettyServer == null ? null : AppServer.jettyServer.debugRequestServlet;
    }

    public static DebugEventServlet getDebugEventServlet() {
        return jettyServer == null ? null : AppServer.jettyServer.debugEventServlet;
    }

    public static long getHttpPort() {
        return jettyServer.getHttpPort();
    }

    public static void installHandler(String path, IMethodDeclaration method) {
        logger.info(() -> "Installing web service '" + method.getName() + "' at path '" + path + "'");
        WebAppContext handler = (WebAppContext)jettyServer.getChildHandlerByClass(WebAppContext.class);
        UserServlet servlet = new UserServlet(method);
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        servlet.setHolder(holder);
        handler.addServlet(holder, path);
    }

    public static IAuthenticationSource getLoginFactory(String config) throws IOException {
        if (config == null) {
            return (IAuthenticationSource)IAuthenticationSource.instance.get();
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream(config.getBytes());){
            IAuthenticationSource iAuthenticationSource = AppServer.getLoginFactory((IConfigurationReader)new YamlConfigurationReader((InputStream)input));
            return iAuthenticationSource;
        }
    }

    public static IAuthenticationSource getLoginFactory(IConfigurationReader reader) {
        return new ServerConfiguration(reader, Collections.emptyMap()).getHttpConfiguration().getAuthenticationConfiguration().getAuthenticationSourceConfiguration().getAuthenticationSourceFactory().newAuthenticationSource();
    }

    public static String getHttpUser() {
        return httpUser.get();
    }

    public static void setHttpUser(String user) {
        httpUser.set(user);
    }

    public static DocumentValue getHttpSession() {
        return httpSession.get();
    }

    public static void setHttpSession(DocumentValue session) {
        httpSession.set(session);
    }

    public static String getHttpQueryParameter(String name) {
        HttpServletRequest request = CleverServlet.CURRENT_REQUEST.get();
        if (request == null) {
            throw new ReadWriteError("Not invoked during server request!");
        }
        return request.getParameter(name);
    }

    public static void httpRedirect(String path) throws IOException {
        HttpServletResponse response = CleverServlet.CURRENT_RESPONSE.get();
        if (response == null) {
            throw new ReadWriteError("Not invoked during server request!");
        }
        response.sendRedirect(path);
    }

    public static void httpLogout(String path) throws IOException {
        HttpServletRequest request = CleverServlet.CURRENT_REQUEST.get();
        if (request == null) {
            throw new ReadWriteError("Not invoked during server request!");
        }
        request.getSession().invalidate();
        AppServer.httpRedirect(path);
    }

    static {
        httpUser = new ThreadLocal();
        httpSession = new ThreadLocal();
    }
}

