/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ServerSocketFactory;

public abstract class SocketUtils {
    public static int findAvailablePortInRange(int min, int max) throws IOException {
        int port;
        HashSet<Integer> alreadyTried = new HashSet<Integer>();
        while (true) {
            if (!alreadyTried.add(port = ThreadLocalRandom.current().nextInt(min, max + 1))) {
                continue;
            }
            if (alreadyTried.size() >= 1 + max - min) {
                throw new IOException("No available port!");
            }
            if (SocketUtils.isAvailablePort(port)) break;
        }
        return port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAvailablePort(int port) {
        try (ServerSocket s = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));){
            s.setReuseAddress(false);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

