/*
 * Decompiled with CFR 0.152.
 */
package prompto.graphql;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import prompto.declaration.IMethodDeclaration;
import prompto.grammar.INamed;
import prompto.java.JavaClassType;
import prompto.param.IParameter;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.type.IType;
import prompto.value.IValue;
import prompto.value.NullValue;

public class GraphQLMethodFetcher
implements DataFetcher<Object> {
    IMethodDeclaration method;

    public GraphQLMethodFetcher(IMethodDeclaration method) {
        this.method = method;
    }

    public Object get(DataFetchingEnvironment environment) throws Exception {
        Context context = ApplicationContext.get().newLocalContext();
        this.method.getParameters().forEach(param -> this.populateArgument(context, (IParameter)param, environment));
        return this.method.interpret(context);
    }

    private void populateArgument(Context context, IParameter param, DataFetchingEnvironment environment) {
        context.registerValue((INamed)param);
        Object data = environment.getArgument(param.getName());
        IValue value = this.convert(context, data, param.getType(context));
        context.setValue(param.getId(), value);
    }

    private IValue convert(Context context, Object data, IType type) {
        if (data == null) {
            return NullValue.instance();
        }
        return JavaClassType.convertJavaValueToPromptoValue((Context)context, (Object)data, data.getClass(), (IType)type);
    }
}

