/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.login.LoginContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import prompto.config.IDebugConfiguration;
import prompto.config.IDebugEventAdapterConfiguration;
import prompto.config.IDebugRequestListenerConfiguration;
import prompto.config.IHttpConfiguration;
import prompto.config.IKeyStoreConfiguration;
import prompto.config.IKeyStoreFactoryConfiguration;
import prompto.config.ISecretKeyConfiguration;
import prompto.config.IServerConfiguration;
import prompto.config.auth.IAuthenticationConfiguration;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;
import prompto.debug.DebugEventServlet;
import prompto.debug.DebugRequestServlet;
import prompto.debug.HttpServletDebugRequestListenerFactory;
import prompto.debug.WebSocketDebugEventAdapterFactory;
import prompto.graphql.GraphQLServlet;
import prompto.runtime.Mode;
import prompto.security.IKeyStoreFactory;
import prompto.security.ISecretKeyFactory;
import prompto.security.auth.method.IAuthenticationMethodFactory;
import prompto.security.auth.source.IAuthenticationSource;
import prompto.server.AppServer;
import prompto.server.BinaryServlet;
import prompto.server.CleverServlet;
import prompto.server.CodeStoreServlet;
import prompto.server.ConstraintSecurityHandler;
import prompto.server.ConstraintSecurityHandlerWithXAuthorization;
import prompto.server.ControlServlet;
import prompto.server.DataServlet;
import prompto.server.LoggingCrossOriginFilter;
import prompto.server.PromptoServlet;
import prompto.server.SessionManager;
import prompto.server.StoreServlet;
import prompto.server.TranspilerServlet;
import prompto.server.WebSiteServlet;
import prompto.utils.Logger;

class JettyServer
extends Server {
    static final Logger logger = new Logger();
    static final String USER_AGENT = "Mozilla/5.0 (X11; Ubuntu; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36 RuxitSynthetic/1.0 v5282078223 t55095";
    IServerConfiguration config;
    Supplier<IAuthenticationConfiguration> auth = null;
    ServerConnector mainConnector;
    ServerConnector redirectConnector;
    ConstraintSecurityHandler securityHandler;
    HandlerList contentHandler;
    DebugRequestServlet debugRequestServlet;
    DebugEventServlet debugEventServlet;
    boolean startComplete = false;
    Thread serverThread = null;
    Throwable serverThrowable = null;

    public JettyServer(IServerConfiguration config) {
        this.config = config;
        this.setStopAtShutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jettyStart(final Runnable onServerStopped) throws Throwable {
        this.serverThrowable = null;
        this.startComplete = false;
        final Object startFlag = new Object();
        this.serverThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.info(() -> "Web server about to start...");
                try {
                    try {
                        JettyServer.this.start();
                        logger.info(() -> "Web server started.");
                    }
                    finally {
                        logger.info(() -> "Signaling start completion...");
                        Object object = startFlag;
                        synchronized (object) {
                            JettyServer.this.startComplete = true;
                            startFlag.notify();
                        }
                    }
                    logger.info(() -> "Web server waiting ready...");
                    JettyServer.this.join();
                    logger.info(() -> "Web server stop complete.");
                    if (onServerStopped != null) {
                        onServerStopped.run();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    JettyServer.this.serverThrowable = t;
                }
                finally {
                    JettyServer.this.serverThread = null;
                }
            }
        }, "HTTP Server");
        this.serverThread.start();
        logger.info(() -> "Waiting for start completion signal...");
        Object object = startFlag;
        synchronized (object) {
            while (!this.startComplete) {
                startFlag.wait();
            }
        }
        logger.info(() -> "Start completion signalled.");
        this.forceLoginModuleInitialization();
        if (this.serverThrowable != null) {
            Throwable t = this.serverThrowable;
            this.serverThrowable = null;
            throw t;
        }
    }

    private void forceLoginModuleInitialization() {
        IHttpConfiguration http = this.config.getHttpConfiguration();
        IAuthenticationConfiguration auth = http.getAuthenticationConfiguration();
        if (auth == null) {
            logger.info(() -> "No auth required, no need to force LoginModule initialization");
            return;
        }
        this.doForceLoginModuleInitialization(auth);
        if (IAuthenticationSource.instance.get() == null) {
            logger.warn(() -> "No authentication source configured!");
        } else {
            logger.info(() -> "Authentication source successfully initialized");
        }
    }

    private void doForceLoginModuleInitialization(IAuthenticationConfiguration auth) {
        try {
            String serviceName = auth.getAuthenticationSourceConfiguration().getAuthenticationSourceFactory().getJettyLoginModuleName();
            LoginContext lc = new LoginContext(serviceName);
            lc.login();
        }
        catch (Throwable t) {
            logger.debug(() -> "During force LoginModule initialization", t);
        }
    }

    void jettyStop() throws Exception {
        logger.info(() -> "Stopping web server...");
        this.stop();
    }

    public void prepare(BiConsumer<JettyServer, HandlerList> handler) throws Exception {
        this.prepareConnectors();
        this.prepareHandlers(handler);
    }

    private void prepareHandlers(BiConsumer<JettyServer, HandlerList> handler) {
        this.prepareSecurityHandler();
        this.prepareContentHandler(handler);
        this.setHandler((Handler)this.contentHandler);
    }

    private void prepareConnectors() throws Exception {
        this.mainConnector = this.prepareMainConnector();
        this.redirectConnector = this.prepareRedirectConnector();
        if (this.redirectConnector == null) {
            this.setConnectors(new Connector[]{this.mainConnector});
        } else {
            this.setConnectors(new Connector[]{this.mainConnector, this.redirectConnector});
        }
    }

    private ServerConnector prepareMainConnector() throws Exception {
        ServerConnector sc;
        ServerConnector serverConnector = sc = "http".equalsIgnoreCase(this.config.getHttpConfiguration().getProtocol()) ? this.prepareHttpConnector() : this.prepareHttpsConnector();
        if (this.config.getHttpConfiguration().getPort() != -1) {
            sc.setPort(this.config.getHttpConfiguration().getPort());
        }
        return sc;
    }

    private ServerConnector prepareRedirectConnector() {
        if (this.config.getHttpConfiguration().getRedirectFrom() == null) {
            return null;
        }
        logger.info(() -> "Preparing redirection from port " + this.config.getHttpConfiguration().getRedirectFrom() + " to port " + this.config.getHttpConfiguration().getPort());
        HttpConfiguration http = new HttpConfiguration();
        http.setSecurePort(this.config.getHttpConfiguration().getPort());
        http.setSecureScheme("https");
        http.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector sc = new ServerConnector((Server)this, new ConnectionFactory[]{new HttpConnectionFactory(http)});
        sc.setPort(this.config.getHttpConfiguration().getRedirectFrom().intValue());
        return sc;
    }

    private ServerConnector prepareHttpConnector() {
        return new ServerConnector((Server)this);
    }

    private ServerConnector prepareHttpsConnector() throws Exception {
        SslConnectionFactory ssl = this.createSSLFactory();
        HttpConnectionFactory https = this.createHttpsFactory();
        return new ServerConnector((Server)this, new ConnectionFactory[]{ssl, https});
    }

    private SslConnectionFactory createSSLFactory() throws Exception {
        SslContextFactory context = new SslContextFactory();
        context.setSslSessionTimeout(180000);
        IKeyStoreConfiguration ksc = this.config.getHttpConfiguration().getKeyStoreConfiguration();
        IKeyStoreFactoryConfiguration ksfc = ksc.getKeyStoreFactoryConfiguration();
        IKeyStoreFactory factory = ksfc.getKeyStoreFactory();
        context.setKeyStore(factory.newInstance(ksfc));
        ISecretKeyConfiguration secret = ksc.getSecretKeyConfiguration();
        context.setKeyStorePassword(ISecretKeyFactory.plainPasswordFromConfig((ISecretKeyConfiguration)secret));
        ksc = this.config.getHttpConfiguration().getTrustStoreConfiguration();
        if (ksc != null) {
            ksfc = ksc.getKeyStoreFactoryConfiguration();
            factory = ksfc.getKeyStoreFactory();
            context.setTrustStore(factory.newInstance(ksfc));
            secret = ksc.getSecretKeyConfiguration();
            context.setTrustStorePassword(ISecretKeyFactory.plainPasswordFromConfig((ISecretKeyConfiguration)secret));
        }
        return new SslConnectionFactory(context, "http/1.1");
    }

    private HttpConnectionFactory createHttpsFactory() {
        HttpConfiguration https = new HttpConfiguration();
        https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return new HttpConnectionFactory(https);
    }

    public int getHttpPort() {
        return this.mainConnector.getLocalPort();
    }

    private void prepareSecurityHandler() {
        logger.info(() -> "Preparing security handler...");
        ConstraintSecurityHandler constraintSecurityHandler = this.securityHandler = this.config.getHttpConfiguration().getAllowsXAuthorization() && this.config.getHttpConfiguration().getAllowedOrigins() != null ? new ConstraintSecurityHandlerWithXAuthorization() : new ConstraintSecurityHandler();
        if (this.getAuthenticationConfiguration() != null) {
            this.configureSecurityHandler();
        } else {
            logger.info(() -> "Not using authentication!");
        }
        logger.info(() -> "Security handler successfully prepared.");
    }

    private IAuthenticationConfiguration getAuthenticationConfiguration() {
        if (this.auth == null) {
            IAuthenticationConfiguration instance = this.config.getHttpConfiguration().getAuthenticationConfiguration();
            this.auth = () -> instance;
        }
        return this.auth.get();
    }

    private void configureSecurityHandler() {
        try {
            this.securityHandler.setLoginService(this.prepareJettyLoginService());
            this.securityHandler.setAuthenticator(this.prepareAuthenticator());
            this.securityHandler.setConstraintMappings(this.prepareAuthConstraintMappings());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void prepareContentHandler(BiConsumer<JettyServer, HandlerList> handler) {
        logger.info(() -> "Preparing web handlers...");
        HandlerList list = new HandlerList();
        if (this.config.getHttpConfiguration().getRedirectFrom() != null) {
            list.addHandler((Handler)new SecuredRedirectHandler());
        }
        handler.accept(this, list);
        this.contentHandler = list;
        logger.info(() -> "Web handlers successfully prepared.");
    }

    private Authenticator prepareAuthenticator() {
        boolean xauth = this.config.getHttpConfiguration().getAllowsXAuthorization();
        IAuthenticationMethodFactory factory = this.getAuthenticationConfiguration().getAuthenticationMethodConfiguration().getAuthenticationMethodFactory();
        return factory.newAuthenticator(xauth);
    }

    private LoginService prepareJettyLoginService() throws Exception {
        IAuthenticationSourceConfiguration login = this.getAuthenticationConfiguration().getAuthenticationSourceConfiguration();
        String loginModuleName = login.getAuthenticationSourceFactory().installJettyLoginModule();
        JAASLoginService loginService = new JAASLoginService("prompto.login.service");
        loginService.setIdentityService(this.prepareIdentityService());
        loginService.setLoginModuleName(loginModuleName);
        this.addBean(loginService);
        return loginService;
    }

    private IdentityService prepareIdentityService() {
        return new DefaultIdentityService();
    }

    private List<ConstraintMapping> prepareAuthConstraintMappings() {
        Stream<ConstraintMapping> allowed = this.prepareAllowedConstraintMappings();
        ConstraintMapping protect = new ConstraintMapping();
        protect.setPathSpec("/");
        protect.setConstraint(this.prepareAuthenticationConstraint());
        return Stream.concat(allowed, Stream.of(protect)).collect(Collectors.toList());
    }

    private Stream<ConstraintMapping> prepareAllowedConstraintMappings() {
        Constraint allow = this.prepareNoAuthenticationConstraint();
        Stream<String> whiteList = this.getAuthenticationConfiguration().getWhiteList().stream();
        if (this.config.getRuntimeMode() == Mode.DEVELOPMENT) {
            whiteList = Stream.concat(whiteList, Collections.singletonList("/ws/control/*").stream());
        }
        return whiteList.map(path -> {
            logger.info(() -> "Allowing free access to '" + path + "'");
            ConstraintMapping cm = new ConstraintMapping();
            cm.setPathSpec(path);
            cm.setConstraint(allow);
            return cm;
        });
    }

    private Constraint prepareNoAuthenticationConstraint() {
        Constraint constraint = new Constraint();
        constraint.setName("no-authentication");
        constraint.setAuthenticate(false);
        constraint.setRoles(new String[]{"*"});
        return constraint;
    }

    private Constraint prepareAuthenticationConstraint() {
        Constraint constraint = new Constraint();
        constraint.setName("authentication");
        constraint.setAuthenticate(true);
        constraint.setRoles(new String[]{"**"});
        return constraint;
    }

    public WebApiContext newWebApiHandler() throws Exception {
        WebApiContext handler = new WebApiContext();
        handler.setContextPath("/api");
        handler.setResourceBase(this.getResourceBase());
        if (GraphQLServlet.isEnabled()) {
            logger.info(() -> "Starting GraphQL server...");
            handler.addServlet(new GraphQLServlet(), "/graphql");
        } else {
            logger.info(() -> "No GraphQL method");
        }
        return handler;
    }

    public WebSiteContext newWebSiteHandler() throws Exception {
        WebSiteContext handler = new WebSiteContext();
        handler.setContextPath("/");
        handler.setResourceBase(this.getResourceBase());
        handler.setSecurityHandler((SecurityHandler)this.securityHandler);
        String welcomePage = this.config.getHttpConfiguration().getWelcomePage();
        if (this.config.getWebSiteRoot() != null) {
            handler.addServlet(new WebSiteServlet(this.config.getWebSiteRoot(), welcomePage), "/");
        } else {
            handler.addServlet(new CodeStoreServlet(welcomePage), "/");
        }
        handler.addServlet(new TranspilerServlet(), "*.page");
        handler.addServlet(new ControlServlet(), "/ws/control/*");
        handler.addServlet(new BinaryServlet(), "/ws/bin/*");
        handler.addServlet(new DataServlet(), "/ws/data/*");
        handler.addServlet(new StoreServlet(), "/ws/store/*");
        this.newDebuggerServlets(handler);
        boolean sendsXAutorization = this.config.getHttpConfiguration().getSendsXAuthorization();
        handler.addServlet(new PromptoServlet(sendsXAutorization), "/ws/run/*");
        FilterHolder filterHolder = this.newCrossOriginHandler();
        if (filterHolder != null) {
            handler.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        SessionManager manager = new SessionManager(this.config.getHttpConfiguration());
        handler.getSessionHandler().setSessionManager((org.eclipse.jetty.server.SessionManager)manager);
        return handler;
    }

    private void newDebuggerServlets(WebSiteContext handler) throws Exception {
        IDebugEventAdapterConfiguration adapter;
        IDebugConfiguration debug = this.config.getDebugConfiguration();
        if (debug == null) {
            return;
        }
        IDebugRequestListenerConfiguration listener = debug.getRequestListenerConfiguration();
        if (listener != null) {
            String factoryName = listener.getFactory();
            if (HttpServletDebugRequestListenerFactory.class.getName().equals(factoryName)) {
                this.debugRequestServlet = new DebugRequestServlet();
                handler.addServlet(this.debugRequestServlet, "/ws/debug-request/*");
            }
        }
        if ((adapter = debug.getEventAdapterConfiguration()) != null) {
            String factoryName = adapter.getFactory();
            if (WebSocketDebugEventAdapterFactory.class.getName().equals(factoryName)) {
                this.debugEventServlet = new DebugEventServlet();
                ServletHolder servletHolder = new ServletHolder((Servlet)this.debugEventServlet);
                handler.addServlet(servletHolder, "/ws/debug-event/*");
            }
        }
    }

    private FilterHolder newCrossOriginHandler() {
        String allowedOrigins = this.config.getHttpConfiguration().getAllowedOrigins();
        if (allowedOrigins == null) {
            return null;
        }
        logger.info(() -> "Setting allowed origins to: " + allowedOrigins);
        FilterHolder holder = new FilterHolder();
        holder.setInitParameter("allowCredentials", "true");
        holder.setInitParameter("allowedOrigins", allowedOrigins);
        holder.setInitParameter("allowedMethods", "GET,POST,HEAD,OPTIONS");
        holder.setInitParameter("allowedHeaders", "X-Requested-With,X-Authorization,Content-Type,Accept,Origin,Access-Control-Allow-Origin");
        holder.setFilter((Filter)new LoggingCrossOriginFilter());
        return holder;
    }

    private String getResourceBase() throws IOException {
        return this.getRootURL().toExternalForm();
    }

    private URL getRootURL() throws IOException {
        URL url = AppServer.class.getResource("/js/lib/require.js");
        if ((url = new URL(url.toExternalForm().replace("/js/lib/require.js", "/"))).toExternalForm().contains("/test-classes/")) {
            url = new URL(url.toExternalForm().replace("/test-classes/", "/classes/"));
        }
        return url;
    }

    public DefaultHandler newDefaultHandler() {
        return new DefaultHandler();
    }

    public static class WebApiContext
    extends WebAppContextBase {
    }

    public static class WebSiteContext
    extends WebAppContextBase {
    }

    static abstract class WebAppContextBase
    extends WebAppContext {
        WebAppContextBase() {
        }

        public ServletHolder addServlet(CleverServlet servlet, String pathSpec) {
            ServletHolder holder = new ServletHolder((Servlet)servlet);
            this.addServlet(holder, pathSpec);
            servlet.setHolder(holder);
            return holder;
        }
    }
}

