/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidParameterException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import prompto.compiler.PromptoClassLoader;
import prompto.debug.ProcessDebugger;
import prompto.error.PromptoError;
import prompto.error.TerminatedError;
import prompto.expression.MethodSelector;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDict;
import prompto.remoting.RemoteArgumentList;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.runtime.Executor;
import prompto.runtime.Interpreter;
import prompto.runtime.Standalone;
import prompto.server.ExecutionMode;
import prompto.statement.MethodCall;
import prompto.store.DataStore;
import prompto.store.IStore;
import prompto.store.memory.MemStore;
import prompto.value.BinaryValue;
import prompto.value.IValue;
import prompto.value.TextValue;

public class RequestRouter {
    public void route(ExecutionMode mode, Identifier methodName, String jsonParams, Map<String, byte[]> parts, boolean main, HttpServletResponse response) throws Exception {
        boolean isTest = methodName.toString().startsWith("\"") && methodName.toString().endsWith("\"");
        switch (mode) {
            case INTERPRET: {
                if (isTest) {
                    this.interpretTest(methodName, response);
                    break;
                }
                this.interpretMethod(methodName, jsonParams, parts, main, response);
                break;
            }
            case EXECUTE: {
                if (isTest) {
                    this.executeTest(methodName, response);
                    break;
                }
                this.executeMethod(methodName, jsonParams, parts, main, response);
                break;
            }
            default: {
                throw new InvalidParameterException(mode.name());
            }
        }
    }

    private Context prepareContext(String name) {
        Context context = ApplicationContext.get().newLocalContext();
        ProcessDebugger processDebugger = ProcessDebugger.getInstance();
        if (processDebugger != null) {
            Standalone.startWorkerDebugger((Thread)Thread.currentThread(), (Context)context);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTest(Identifier testName, HttpServletResponse response) throws Exception {
        PrintStream oldOut = System.out;
        IStore oldStore = DataStore.getInstance();
        DataStore.setInstance((IStore)new MemStore());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        System.setOut(new PrintStream(bytes));
        Context context = this.prepareContext("Test: " + testName);
        try {
            Executor.executeTest((PromptoClassLoader)Standalone.getClassLoader(), (String)testName.toString());
            bytes.flush();
            String[] lines = new String(bytes.toByteArray()).split("\n");
            this.writeJsonResponse(lines, response);
        }
        catch (TerminatedError terminatedError) {
        }
        finally {
            context.notifyCompleted();
            DataStore.setInstance((IStore)oldStore);
            System.setOut(oldOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interpretTest(Identifier testName, HttpServletResponse response) throws IOException {
        PrintStream oldOut = System.out;
        IStore oldStore = DataStore.getInstance();
        DataStore.setInstance((IStore)new MemStore());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        System.setOut(new PrintStream(bytes));
        Context context = this.prepareContext("Test: " + testName);
        try {
            Interpreter.interpretTest((Context)context, (Identifier)testName, (boolean)true);
            bytes.flush();
            String[] lines = new String(bytes.toByteArray()).split("\n");
            this.writeJsonResponse(lines, response);
        }
        catch (TerminatedError terminatedError) {
        }
        finally {
            context.notifyCompleted();
            DataStore.setInstance((IStore)oldStore);
            System.setOut(oldOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMethod(Identifier methodName, String jsonParams, Map<String, byte[]> parts, boolean main, HttpServletResponse response) throws Exception {
        Context context = this.prepareContext("Method: " + methodName);
        try {
            Object result;
            RemoteArgumentList params = RemoteArgumentList.read((Context)context, (String)jsonParams, parts);
            Class[] argTypes = params.toJavaTypes(context, (ClassLoader)Standalone.getClassLoader());
            Object[] args = params.toJavaValues(context);
            if (params.isEmpty() && main) {
                argTypes = new Class[]{PromptoDict.class};
                args = new Object[]{null};
            }
            TextValue text = new TextValue((result = Executor.executeGlobalMethod((PromptoClassLoader)Standalone.getClassLoader(), (Identifier)methodName, (Class[])argTypes, (Object[])args)) == null ? "success!" : result.toString());
            this.writeJsonResponse(context, (IValue)text, response);
        }
        catch (TerminatedError terminatedError) {
        }
        finally {
            context.notifyCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpretMethod(Identifier methodName, String jsonParams, Map<String, byte[]> parts, boolean main, HttpServletResponse response) throws Exception {
        Context context = this.prepareContext("Method: " + methodName);
        try {
            RemoteArgumentList params = RemoteArgumentList.read((Context)context, (String)jsonParams, parts);
            ArgumentList arguments = params.toArguments(context);
            IValue value = this.interpretMethod(context, methodName, arguments, main);
            if (value == null) {
                value = new TextValue("Success!");
            }
            if (value instanceof BinaryValue) {
                this.writeBinaryResponse((BinaryValue)value, response);
            } else {
                this.writeJsonResponse(context, value, response);
            }
        }
        catch (TerminatedError terminatedError) {
        }
        finally {
            context.notifyCompleted();
        }
    }

    private IValue interpretMethod(Context context, Identifier methodName, ArgumentList arguments, boolean main) {
        if (arguments.isEmpty() && main) {
            Interpreter.interpretMainNoArgs((Context)context, (Identifier)methodName);
            return null;
        }
        MethodCall methodCall = new MethodCall(new MethodSelector(methodName), arguments);
        return methodCall.interpret(context);
    }

    private void writeBinaryResponse(BinaryValue value, HttpServletResponse response) throws IOException {
        response.setContentType(value.getMimeType());
        response.setStatus(200);
        response.getOutputStream().write(value.getBytes());
    }

    private void writeJsonResponse(Context context, IValue value, HttpServletResponse response) throws IOException, PromptoError {
        response.setContentType("text/json");
        response.setStatus(200);
        JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)response.getOutputStream());
        generator.writeStartObject();
        generator.writeNullField("error");
        if (value == null) {
            generator.writeNullField("data");
        } else {
            generator.writeFieldName("data");
            value.toJsonStream(context, generator, true, null);
        }
        generator.writeEndObject();
        generator.flush();
        generator.close();
    }

    private void writeJsonResponse(String[] lines, HttpServletResponse response) throws IOException, PromptoError {
        response.setContentType("text/json");
        response.setStatus(200);
        JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)response.getOutputStream());
        generator.writeStartObject();
        generator.writeNullField("error");
        generator.writeArrayFieldStart("data");
        for (String line : lines) {
            generator.writeString(line);
        }
        generator.writeEndArray();
        generator.writeEndObject();
        generator.flush();
        generator.close();
    }
}

