/*
 * Decompiled with CFR 0.152.
 */
package prompto.security.auth.source;

import com.esotericsoftware.yamlbeans.document.YamlMapping;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.ModuleType;
import prompto.config.IHttpConfiguration;
import prompto.config.IStoreConfiguration;
import prompto.config.auth.IAuthenticationConfiguration;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;
import prompto.config.auth.source.IStoredAuthenticationSourceConfiguration;
import prompto.intrinsic.PromptoVersion;
import prompto.security.auth.StoredUserInfoCache;
import prompto.security.auth.method.BasicAuthenticationMethodFactory;
import prompto.security.auth.source.IAuthenticationSourceFactory;
import prompto.security.auth.source.StoredPasswordDigestAuthenticationSourceFactory;
import prompto.server.BaseServerTest;
import prompto.store.IStore;
import prompto.store.IStoreFactory;
import prompto.store.memory.MemStore;
import prompto.utils.JsonUtils;
import prompto.utils.ResourceUtils;

public class TestStoredLoginSource
extends BaseServerTest {
    static IStore store = new MemStore();
    static final String HTTP_CODE_PREFIX = "Server returned HTTP response code: ";

    @Override
    protected IHttpConfiguration getHttpConfiguration() {
        return new IHttpConfiguration.Inline().withProtocol("http").withPort(this.port).withAuthenticationConfiguration(new IAuthenticationConfiguration.Inline().withAuthenticationMethodConfiguration(() -> new BasicAuthenticationMethodFactory()).withAuthenticationSourceConfiguration((IAuthenticationSourceConfiguration)new IStoredAuthenticationSourceConfiguration(){

            public IAuthenticationSourceFactory getAuthenticationSourceFactory() {
                StoredPasswordDigestAuthenticationSourceFactory factory = new StoredPasswordDigestAuthenticationSourceFactory();
                factory.setConfiguration((IAuthenticationSourceConfiguration)this);
                return factory;
            }

            public IStoreConfiguration getStoreConfiguration() {
                return new IStoreConfiguration.Inline(){

                    public String getFactory() {
                        return StoreFactoryTest.class.getName();
                    }
                };
            }

            public YamlMapping toYaml() {
                throw new RuntimeException("Should never get there!");
            }
        }));
    }

    @Before
    public void before() throws Exception {
        Field field = StoredUserInfoCache.class.getDeclaredField("KEEP_ALIVE_DELAY");
        field.setAccessible(true);
        field.set(null, 10L);
        store.deleteAll();
        StoredUserInfoCache.createLogin((IStore)store, (String)"john", (String)"password");
    }

    @Test
    public void unknownUserIsRejected() throws Exception {
        int code = this.loadResource("eric", "password");
        Assert.assertEquals((long)401L, (long)code);
    }

    @Test
    public void knownUserIsAllowedWhenUsingCorrectPassword() throws Exception {
        int code = this.loadResource("john", "password");
        Assert.assertEquals((long)200L, (long)code);
    }

    @Test
    public void knownUserIsRejectedAfterDelay() throws Exception {
        int code = this.loadResource("john", "password");
        Assert.assertEquals((long)200L, (long)code);
        store.deleteAll();
        Thread.sleep(20L);
        code = this.loadResource("john", "password");
        Assert.assertEquals((long)401L, (long)code);
    }

    @Test
    public void knownUserIsRejectedWhenUsingIncorrectPassword() throws Exception {
        int code = this.loadResource("john", "wrong");
        Assert.assertEquals((long)401L, (long)code);
    }

    @Test
    public void hasLoginReturnsTrueOrFalse() throws Exception {
        URL codeResourceURL = Thread.currentThread().getContextClassLoader().getResource("login-factory-tests/default-login-factory.poc");
        ImmutableCodeStore codeResource = new ImmutableCodeStore(null, ModuleType.LIBRARY, codeResourceURL, PromptoVersion.LATEST);
        this.tail.setNext((ICodeStore)codeResource);
        JsonNode node = this.runRemotely("checkHasLogin", this.param("login", "login", "john"));
        Assert.assertTrue((boolean)node.get("data").asBoolean());
        node = this.runRemotely("checkHasLogin", this.param("login", "login", "Eric"));
        Assert.assertFalse((boolean)node.get("data").asBoolean());
    }

    @Test
    public void checkLoginReturnsTrueOrFalse() throws Exception {
        URL codeResourceURL = Thread.currentThread().getContextClassLoader().getResource("login-factory-tests/default-login-factory.poc");
        ImmutableCodeStore codeResource = new ImmutableCodeStore(null, ModuleType.LIBRARY, codeResourceURL, PromptoVersion.LATEST);
        this.tail.setNext((ICodeStore)codeResource);
        JsonNode node = this.runRemotely("checkUserLogin", this.param("login", "login", "john"), this.param("password", "password", "password"));
        Assert.assertTrue((boolean)node.get("data").asBoolean());
        node = this.runRemotely("checkUserLogin", this.param("login", "login", "john"), this.param("password", "password", "wrong"));
        Assert.assertFalse((boolean)node.get("data").asBoolean());
    }

    @Test
    public void createsLogin() throws Exception {
        URL codeResourceURL = Thread.currentThread().getContextClassLoader().getResource("login-factory-tests/default-login-factory.poc");
        ImmutableCodeStore codeResource = new ImmutableCodeStore(null, ModuleType.LIBRARY, codeResourceURL, PromptoVersion.LATEST);
        this.tail.setNext((ICodeStore)codeResource);
        JsonNode node = this.runRemotely("checkHasLogin", this.param("login", "login", "eric"));
        Assert.assertFalse((boolean)node.get("data").asBoolean());
        node = this.runRemotely("createUserLogin", this.param("login", "login", "eric"), this.param("password", "password", "password"));
        Assert.assertTrue((boolean)node.get("error").isNull());
        node = this.runRemotely("checkUserLogin", this.param("login", "login", "eric"), this.param("password", "password", "password"));
        Assert.assertTrue((boolean)node.get("data").asBoolean());
    }

    @Test
    public void updatesLogin() throws Exception {
        URL codeResourceURL = Thread.currentThread().getContextClassLoader().getResource("login-factory-tests/default-login-factory.poc");
        ImmutableCodeStore codeResource = new ImmutableCodeStore(null, ModuleType.LIBRARY, codeResourceURL, PromptoVersion.LATEST);
        this.tail.setNext((ICodeStore)codeResource);
        JsonNode node = this.runRemotely("createUserLogin", this.param("login", "login", "eric"), this.param("password", "password", "password"));
        Assert.assertTrue((boolean)node.get("error").isNull());
        node = this.runRemotely("checkUserLogin", this.param("login", "login", "eric"), this.param("password", "password", "password"));
        Assert.assertTrue((boolean)node.get("data").asBoolean());
        node = this.runRemotely("updateUserLogin", this.param("login", "login", "eric"), this.param("password", "password", "password2"));
        Assert.assertTrue((boolean)node.get("error").isNull());
        node = this.runRemotely("checkUserLogin", this.param("login", "login", "eric"), this.param("password", "password", "password"));
        Assert.assertFalse((boolean)node.get("data").asBoolean());
        node = this.runRemotely("checkUserLogin", this.param("login", "login", "eric"), this.param("password", "password", "password2"));
        Assert.assertTrue((boolean)node.get("data").asBoolean());
    }

    @Test
    public void loadsAuthenticationSourceFromConfig() throws Exception {
        URL codeResourceURL = Thread.currentThread().getContextClassLoader().getResource("login-factory-tests/config-login-factory.poc");
        ImmutableCodeStore codeResource = new ImmutableCodeStore(null, ModuleType.LIBRARY, codeResourceURL, PromptoVersion.LATEST);
        this.tail.setNext((ICodeStore)codeResource);
        String config = ResourceUtils.getResourceAsString((String)"config/auth-config.yml");
        JsonNode node = this.runRemotely("checkHasLogin", this.param("config", "Text", config), this.param("login", "login", "john"));
        Assert.assertFalse((boolean)node.get("data").asBoolean());
        node = this.runRemotely("createAndCheckUserLogin", this.param("config", "Text", config), this.param("login", "login", "john"), this.param("password", "password", "password"));
        Assert.assertTrue((boolean)node.get("data").asBoolean());
    }

    @SafeVarargs
    private final JsonNode runRemotely(String method, Map<String, Object> ... params) throws Exception {
        return this.runRemotely(method, Arrays.asList(params));
    }

    private final JsonNode runRemotely(String method, List<Map<String, Object>> params) throws Exception {
        String paramsString = JsonUtils.objectToJson(params);
        URL url = new URL("http://localhost:" + this.port + "/ws/run/" + method + "?params=" + URLEncoder.encode(paramsString, "UTF-8"));
        URLConnection cnx = url.openConnection();
        String authorization = Base64.getEncoder().encodeToString("john:password".getBytes());
        cnx.setRequestProperty("Authorization", "Basic " + authorization);
        try (InputStream input = cnx.getInputStream();){
            JsonNode jsonNode = new ObjectMapper().readTree(input);
            return jsonNode;
        }
    }

    private Map<String, Object> param(String name, String type, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", name);
        map.put("type", type);
        map.put("value", value);
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadResource(String login, String password) throws Exception {
        URL url = new URL("http://localhost:" + this.port + "/ws/run/getAllAttributes");
        URLConnection cnx = url.openConnection();
        String authorization = Base64.getEncoder().encodeToString((login + ":" + password).getBytes());
        cnx.setRequestProperty("Authorization", "Basic " + authorization);
        try (InputStream input = cnx.getInputStream();){
            int throwable3 = 200;
            return throwable3;
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (!msg.startsWith(HTTP_CODE_PREFIX)) throw e;
            msg = msg.substring(HTTP_CODE_PREFIX.length());
            return Integer.parseInt(msg.substring(0, 3));
        }
    }

    public static class StoreFactoryTest
    implements IStoreFactory {
        public IStore newStore(IStoreConfiguration config) throws Exception {
            return store;
        }
    }
}

