/*
 * Decompiled with CFR 0.152.
 */
package prompto.selenium;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Properties;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import prompto.selenium.WebDriverFactory;
import prompto.utils.ResourceUtils;

public class ChromeWebDriverFactory
implements WebDriverFactory {
    static final String CHROME_DRIVER_PROPERTY = "webdriver.chrome.driver";

    private static void setChromeDriverLocationProperty() {
        if (System.getProperty(CHROME_DRIVER_PROPERTY) != null) {
            return;
        }
        File file = ChromeWebDriverFactory.locateChromeDriver();
        System.setProperty(CHROME_DRIVER_PROPERTY, file.getAbsolutePath());
    }

    private static File locateChromeDriver() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("mac")) {
            return ChromeWebDriverFactory.locateChromeDriver("macos");
        }
        if (osName.startsWith("linux")) {
            return ChromeWebDriverFactory.locateChromeDriver("linux");
        }
        throw new UnsupportedOperationException("Unsupported OS: " + osName);
    }

    private static File locateChromeDriver(String osName) {
        String resourceName = "selenium/drivers/" + osName + "/chromedriver";
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            throw new UnsupportedOperationException("Driver not found: " + resourceName);
        }
        if ("file".equals(url.getProtocol())) {
            return ChromeWebDriverFactory.driverFile(url);
        }
        if ("jar".equals(url.getProtocol())) {
            try {
                Path temp = Files.createTempFile("chromedriver_", "", new FileAttribute[0]);
                ResourceUtils.copyResourceToFile((URL)url, (Path)temp);
                return ChromeWebDriverFactory.driverFile(temp.toUri().toURL());
            }
            catch (IOException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
        throw new UnsupportedOperationException("Unsupported protocol: " + url.getProtocol());
    }

    private static File driverFile(URL url) {
        try {
            File file = new File(url.toURI());
            Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString("rwxr-xr-x"));
            return file;
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WebDriver newDriver(Properties props) {
        ChromeOptions chromeOptions = new ChromeOptions();
        if (this.isRunningInCI()) {
            chromeOptions.addArguments(new String[]{"--headless"});
            chromeOptions.addArguments(new String[]{"--no-sandbox"});
        }
        return new ChromeDriver(chromeOptions);
    }

    static {
        ChromeWebDriverFactory.setChromeDriverLocationProperty();
    }
}

