/*
 * Decompiled with CFR 0.152.
 */
package prompto.store;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.esotericsoftware.yamlbeans.document.YamlDocument;
import com.esotericsoftware.yamlbeans.document.YamlDocumentReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import prompto.code.BaseCodeStore;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.ModuleType;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoTime;
import prompto.intrinsic.PromptoVersion;
import prompto.parser.Dialect;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Standalone;
import prompto.server.BaseUITest;
import prompto.store.DataStore;
import prompto.store.IStore;
import prompto.store.IStored;

public abstract class TestRemoteStoreBase
extends BaseUITest {
    Path tempDir;

    @Override
    @Before
    public void __before__() throws Throwable {
        ApplicationContext.reset();
        DataStore.setGlobal((IStore)this.getDataStore());
        DataStore.useGlobal();
        Standalone.synchronizeSchema((ICodeStore)ICodeStore.getInstance(), (IStore)DataStore.getInstance());
        this.tail = this.getCodeStoreTail();
    }

    protected abstract IStore getDataStore();

    @Override
    @After
    public void __after__() {
        if (this.tail != null) {
            this.tail.setNext(null);
        }
    }

    private BaseCodeStore getCodeStoreTail() {
        ICodeStore store = ICodeStore.getInstance();
        while (store instanceof BaseCodeStore) {
            ICodeStore next = ((BaseCodeStore)store).getNext();
            if (next == null) {
                return (BaseCodeStore)store;
            }
            store = next;
        }
        return null;
    }

    protected void linkResourcesAndLoadPage(String resourceName, Dialect dialect) throws Exception {
        URL codeResourceURL = Thread.currentThread().getContextClassLoader().getResource("remote-store-tests/" + resourceName + ".p" + dialect.name().toLowerCase() + "c");
        ImmutableCodeStore codeResource = new ImmutableCodeStore(null, ModuleType.LIBRARY, codeResourceURL, PromptoVersion.LATEST);
        URL pageResourceURL = Thread.currentThread().getContextClassLoader().getResource("remote-store-tests/" + resourceName + ".page");
        if (pageResourceURL == null) {
            pageResourceURL = this.createTempPage(resourceName);
        }
        ImmutableCodeStore pageResource = new ImmutableCodeStore((ICodeStore)codeResource, ModuleType.LIBRARY, pageResourceURL, PromptoVersion.LATEST);
        this.tail.setNext((ICodeStore)pageResource);
        Standalone.synchronizeSchema((ICodeStore)ICodeStore.getInstance(), (IStore)DataStore.getInstance());
        String url = "http://localhost:" + HTTP_PORT + "/" + resourceName + ".page";
        webDriver.get(url);
    }

    private URL createTempPage(String resourceName) throws Exception {
        YamlDocument template;
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("remote-store-tests/generic.page");){
            template = new YamlDocumentReader((Reader)new InputStreamReader(input)).read();
        }
        YamlDocument body = (YamlDocument)template.getEntry("body").getValue();
        body.getEntry("widget").setValue(resourceName + "Page");
        if (this.tempDir == null) {
            this.tempDir = Files.createTempDirectory("prompto_pages_", new FileAttribute[0]);
        }
        File pageFile = new File(this.tempDir.toFile(), resourceName + ".page");
        try (FileWriter writer = new FileWriter(pageFile);){
            YamlConfig config = new YamlConfig();
            config.writeConfig.setWriteClassname(YamlConfig.WriteClassName.NEVER);
            config.writeConfig.setAutoAnchor(false);
            new YamlWriter((Writer)writer, config).write((Object)template);
        }
        return pageFile.toURI().toURL();
    }

    @Test
    public void nullIsStored() throws Exception {
        this.linkResourcesAndLoadPage("NullIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Assert.assertTrue((boolean)stored.hasData("value"));
        Assert.assertEquals(null, (Object)stored.getRawData("value"));
    }

    @Test
    public void nullIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("NullIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"null", (Object)elem.getText());
    }

    @Test
    public void booleanIsStored() throws Exception {
        this.linkResourcesAndLoadPage("BooleanIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)true, (Object)stored.getRawData("value"));
    }

    @Test
    public void booleanIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("BooleanIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"true", (Object)elem.getText());
    }

    @Test
    public void textIsStored() throws Exception {
        this.linkResourcesAndLoadPage("TextIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)"John", (Object)stored.getRawData("value"));
    }

    @Test
    public void textIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("TextIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
    }

    @Test
    public void integerIsStored() throws Exception {
        this.linkResourcesAndLoadPage("IntegerIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)123L, (Object)stored.getRawData("value"));
    }

    @Test
    public void integerIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("IntegerIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"123", (Object)elem.getText());
    }

    @Test
    public void decimalIsStored() throws Exception {
        this.linkResourcesAndLoadPage("DecimalIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)123.2, (Object)stored.getRawData("value"));
    }

    @Test
    public void decimalIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("DecimalIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"123.4", (Object)elem.getText());
    }

    @Test
    public void uuidIsStored() throws Exception {
        this.linkResourcesAndLoadPage("UuidIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)UUID.fromString("d5622e5d-9232-48de-bb47-77fc41005f5a"), (Object)stored.getRawData("value"));
    }

    @Test
    public void uuidIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("UuidIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"d5622e5d-9232-48de-bb47-77fc41005f5a", (Object)elem.getText());
    }

    @Test
    public void dateIsStored() throws Exception {
        this.linkResourcesAndLoadPage("DateIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)PromptoDate.parse((String)"2016-02-25"), (Object)stored.getRawData("value"));
    }

    @Test
    public void dateIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("DateIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"2016-02-25", (Object)elem.getText());
    }

    @Test
    public void timeIsStored() throws Exception {
        this.linkResourcesAndLoadPage("TimeIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)PromptoTime.parse((String)"18:15:03"), (Object)stored.getRawData("value"));
    }

    @Test
    public void timeIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("TimeIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"18:15:03.000", (Object)elem.getText());
    }

    @Test
    public void dateTimeIsStored() throws Exception {
        this.linkResourcesAndLoadPage("DateTimeIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)PromptoDateTime.parse((String)"2016-02-25T18:15:03.000Z"), (Object)stored.getRawData("value"));
    }

    @Test
    public void dateTimeIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("DateTimeIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"2016-02-25T18:15:03.000Z", (Object)elem.getText());
    }

    @Test
    public void listIsStored() throws Exception {
        this.linkResourcesAndLoadPage("ListIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals(Arrays.asList("John", "Gielgud"), (Object)stored.getRawData("value"));
    }

    @Test
    public void listIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("ListIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"[John, Gielgud]", (Object)elem.getText());
    }

    @Test
    public void childIsStored() throws Exception {
        this.linkResourcesAndLoadPage("ChildIsStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Object child = stored.getRawData("child");
        Assert.assertNotNull((Object)child);
        stored = DataStore.getInstance().fetchUnique(child);
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)"John", (Object)stored.getRawData("value"));
    }

    @Test
    public void childrenAreStored() throws Exception {
        this.linkResourcesAndLoadPage("ChildrenAreStored", Dialect.O);
        this.waitElement(By.id((String)"root"), 3);
        IStored stored = (IStored)DataStore.getInstance().fetchMany(null).iterator().next();
        Assert.assertNotNull((Object)stored);
        Object children = stored.getRawData("children");
        Assert.assertTrue((boolean)(children instanceof List));
        stored = DataStore.getInstance().fetchUnique(((List)children).get(0));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)"John", (Object)stored.getRawData("value"));
        stored = DataStore.getInstance().fetchUnique(((List)children).get(1));
        Assert.assertNotNull((Object)stored);
        Assert.assertEquals((Object)"Jane", (Object)stored.getRawData("value"));
    }

    @Test
    public void childIsFetched() throws Exception {
        this.linkResourcesAndLoadPage("ChildIsFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
    }

    @Test
    public void childrenAreFetched() throws Exception {
        this.linkResourcesAndLoadPage("ChildrenAreFetched", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John, Jane", (Object)elem.getText());
    }

    @Test
    public void dbIdIsPopulated() throws Exception {
        this.linkResourcesAndLoadPage("DbIdIsPopulated", Dialect.O);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"Gielgud", (Object)elem.getText());
    }

    @Test
    public void recordIsStoredAsync() throws Exception {
        this.linkResourcesAndLoadPage("RecordIsStoredAsync", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
    }

    @Test
    public void recordIsFetchedAsync() throws Exception {
        this.linkResourcesAndLoadPage("RecordIsFetchedAsync", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
    }

    @Test
    public void recordsAreFetched() throws Exception {
        this.linkResourcesAndLoadPage("RecordsAreFetched", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John, Gielgud", (Object)elem.getText());
    }

    @Test
    public void recordsAreFetchedAsync() throws Exception {
        this.linkResourcesAndLoadPage("RecordsAreFetchedAsync", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John, Gielgud", (Object)elem.getText());
    }

    @Test
    public void recordIsUpdated() throws Exception {
        this.linkResourcesAndLoadPage("RecordIsUpdated", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"Gielgud", (Object)elem.getText());
    }

    @Test
    public void equalsIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("EqualsIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
    }

    @Test
    public void notEqualsIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("NotEqualsIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"Lucy", (Object)elem.getText());
    }

    @Test
    public void greaterIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("GreaterIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"Lucy", (Object)elem.getText());
    }

    @Test
    public void greaterEqualsIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("GreaterEqualsIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"JohnLucy", (Object)elem.getText());
    }

    @Test
    public void lesserIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("LesserIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
    }

    @Test
    public void lesserEqualsIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("LesserEqualsIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"LucyJohn", (Object)elem.getText());
    }

    @Test
    public void inIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("InIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"BrianJohn", (Object)elem.getText());
    }

    @Test
    public void notInIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("NotInIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"Lucy", (Object)elem.getText());
    }

    @Test
    public void isIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("IsIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
    }

    @Test
    public void isNotIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("IsNotIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"Lucy", (Object)elem.getText());
    }

    @Test
    public void hasIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("HasIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"Gielgud", (Object)elem.getText());
    }

    @Test
    public void notHasIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("NotHasIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"Lucy", (Object)elem.getText());
    }

    @Test
    public void containsIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("ContainsIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"JohnJohnny", (Object)elem.getText());
    }

    @Test
    public void notContainsIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("NotContainsIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"Lucy", (Object)elem.getText());
    }

    @Test
    public void roughlyIsSupported() throws Exception {
        this.linkResourcesAndLoadPage("RoughlyIsSupported", Dialect.O);
        Thread.sleep(100L);
        WebElement elem = this.waitElement(By.id((String)"root"), 3);
        Assert.assertEquals((Object)"John", (Object)elem.getText());
    }
}

