/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ServerSocketFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.config.TempDirectories;
import prompto.runtime.Mode;
import prompto.utils.SocketUtils;

public class TestSocketUtils {
    @Before
    public void __before__() throws Throwable {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
    }

    @Test
    public void testThatAValidPortIsReturned() throws IOException {
        int port = SocketUtils.findAvailablePortInRange((int)8080, (int)9090);
        Assert.assertTrue((port >= 8080 && port <= 9090 ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThatInvalidRangeThrows() throws IOException {
        int port = SocketUtils.findAvailablePortInRange((int)8080, (int)8079);
        Assert.assertTrue((port >= 8080 && port <= 9090 ? 1 : 0) != 0);
    }

    @Test(expected=IOException.class)
    public void testThatTrulyNoPortThrows() throws IOException {
        int port = 8000;
        try (final ServerSocket s = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));){
            s.setReuseAddress(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        System.out.println("accepting");
                        s.accept();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }).start();
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        System.out.println("closing");
                        s.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, 100L);
            System.out.println("grabbing");
            SocketUtils.findAvailablePortInRange((int)port, (int)port);
        }
    }

    @Test
    public void testThatReturnedPortIsStillValid() throws IOException {
        int port = SocketUtils.findAvailablePortInRange((int)8080, (int)9090);
        try (ServerSocket s = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));){
            s.setReuseAddress(false);
        }
    }
}

