/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import prompto.config.IConfigurationReader;
import prompto.config.IHttpConfiguration;
import prompto.config.IKeyStoreConfiguration;
import prompto.config.KeyStoreConfiguration;
import prompto.config.auth.AuthenticationConfiguration;
import prompto.config.auth.IAuthenticationConfiguration;
import prompto.config.auth.IAuthenticationConfigurationFactory;

public class HttpConfiguration
extends IHttpConfiguration.Inline {
    IConfigurationReader reader;

    public HttpConfiguration(IConfigurationReader reader) {
        this.reader = reader;
        this.protocol = () -> reader.getStringOrDefault("protocol", "http");
        this.port = () -> reader.getIntegerOrDefault("port", -1);
        this.welcomePage = () -> reader.getString("welcomePage");
        this.redirectFrom = () -> reader.getInteger("redirectFrom");
        this.allowedOrigins = () -> reader.getString("allowedOrigins");
        this.allowsXAuthorization = () -> reader.getBooleanOrDefault("allowsXAuthorization", false);
        this.sendsXAuthorization = () -> reader.getBooleanOrDefault("sendsXAuthorization", false);
        this.keyStoreConfiguration = () -> this.readKeyStoreConfiguration();
        this.trustStoreConfiguration = () -> this.readTrustStoreConfiguration();
        this.authenticationConfiguration = () -> this.readAuthenticationConfiguration();
        this.publicAddress = () -> reader.getString("publicAddress");
    }

    private IKeyStoreConfiguration readKeyStoreConfiguration() {
        IConfigurationReader child = this.reader.getObject("keyStore");
        return child == null ? null : new KeyStoreConfiguration(child);
    }

    private IKeyStoreConfiguration readTrustStoreConfiguration() {
        IConfigurationReader child = this.reader.getObject("trustStore");
        return child == null ? null : new KeyStoreConfiguration(child);
    }

    private IAuthenticationConfiguration readAuthenticationConfiguration() {
        IConfigurationReader child = this.reader.getObject("authentication");
        if (child == null) {
            return null;
        }
        String factoryName = child.getString("factory");
        if (factoryName == null) {
            return new AuthenticationConfiguration(child);
        }
        try {
            IAuthenticationConfigurationFactory factory = IAuthenticationConfigurationFactory.newFactory(factoryName);
            return factory.newConfiguration(child);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public YamlMapping toYaml() throws YamlException {
        IAuthenticationConfiguration auth;
        IKeyStoreConfiguration config;
        YamlMapping yaml = new YamlMapping();
        String value = (String)this.protocol.get();
        if (value != null) {
            yaml.setEntry("protocol", value);
        }
        if ((Integer)this.port.get() != -1) {
            yaml.setEntry("port", (Number)this.port.get());
        }
        if ((value = (String)this.welcomePage.get()) != null) {
            yaml.setEntry("welcomePage", value);
        }
        if (this.redirectFrom.get() != null) {
            yaml.setEntry("redirectFrom", (Number)this.redirectFrom.get());
        }
        if ((value = (String)this.allowedOrigins.get()) != null) {
            yaml.setEntry("allowedOrigins", value);
        }
        if ((config = (IKeyStoreConfiguration)this.keyStoreConfiguration.get()) != null) {
            yaml.setEntry("keyStore", (YamlElement)config.toYaml());
        }
        if ((config = (IKeyStoreConfiguration)this.trustStoreConfiguration.get()) != null) {
            yaml.setEntry("trustStore", (YamlElement)config.toYaml());
        }
        if ((auth = (IAuthenticationConfiguration)this.authenticationConfiguration.get()) != null) {
            yaml.setEntry("authentication", (YamlElement)auth.toYaml());
        }
        if ((value = (String)this.publicAddress.get()) != null) {
            yaml.setEntry("publicAddress", value);
        }
        return yaml;
    }
}

