/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.util.resource.Resource;
import prompto.code.ICodeStore;
import prompto.code.ResourceReader;
import prompto.server.CodeStoreResource;
import prompto.server.ResourceServlet;
import prompto.store.AttributeInfo;
import prompto.store.DataStore;
import prompto.store.Family;
import prompto.store.IQueryBuilder;
import prompto.store.IStore;
import prompto.store.IStored;

public class CodeStoreServlet
extends ResourceServlet {
    public CodeStoreServlet(String welcomePage) {
        super(welcomePage);
    }

    @Override
    protected Resource getResource(HttpServletRequest request, String path) {
        if (path.equals("/stub")) {
            return this.getStubResource(request, path);
        }
        return this.getCodeResource(request, path);
    }

    protected Resource getStubResource(HttpServletRequest request, String path) {
        try {
            String moduleId = request.getParameter("moduleId");
            String resourceName = request.getParameter("resourceName");
            IStore store = DataStore.getInstance();
            IQueryBuilder builder = store.newQueryBuilder().verify(new AttributeInfo("module", Family.CATEGORY, false, null), IQueryBuilder.MatchOp.EQUALS, store.convertToDbId((Object)moduleId)).verify(new AttributeInfo("name", Family.TEXT, false, null), IQueryBuilder.MatchOp.EQUALS, (Object)resourceName).and();
            IStored stored = store.fetchOne(builder.build());
            prompto.code.Resource res = ResourceReader.readResource((IStored)stored);
            return res == null ? null : new CodeStoreResource(res);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    protected Resource getCodeResource(HttpServletRequest request, String path) {
        try {
            ICodeStore store;
            prompto.code.Resource res;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return (res = (store = ICodeStore.getInstance()).fetchLatestResource(path)) == null ? null : new CodeStoreResource(res);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

