/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.IOException;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import prompto.grammar.Identifier;
import prompto.server.CleverServlet;
import prompto.server.ExecutionMode;
import prompto.server.RequestRouter;
import prompto.utils.Logger;

public class PromptoServlet
extends CleverServlet {
    static final Logger logger = new Logger();
    boolean sendsXAutorization;

    public PromptoServlet(boolean sendsXAutorization) {
        this.sendsXAutorization = sendsXAutorization;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setMultipartConfig(new MultipartConfigElement(System.getProperty("java.io.tmpdir")));
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.sendsXAutorization) {
            logger.debug(() -> "PromptoServlet, Authorization: " + req.getHeader("Authorization"));
            if (req.getHeader("Authorization") != null) {
                resp.addHeader("X-Authorization", req.getHeader("Authorization"));
            }
        }
        super.service(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            ExecutionMode mode = this.readMode(req);
            Identifier methodName = this.readMethod(req);
            boolean main = this.readMain(req);
            String[] httpParams = (String[])req.getParameterMap().get("params");
            String jsonParams = httpParams == null || httpParams.length == 0 ? null : httpParams[0];
            RequestRouter handler = new RequestRouter();
            handler.route(mode, methodName, jsonParams, null, main, resp);
            resp.getOutputStream().close();
            resp.flushBuffer();
        }
        catch (Throwable t) {
            t.printStackTrace();
            resp.setStatus(500);
            this.writeJSONError(t.getMessage(), resp.getOutputStream());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String contentType = req.getContentType();
            if (contentType.startsWith("application/json")) {
                this.doPostJson(req, resp);
            } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
                this.doPostUrlEncoded(req, resp);
            } else if (contentType.startsWith("multipart/form-data")) {
                this.doPostMultipart(req, resp);
            } else {
                resp.sendError(415);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            resp.setStatus(500);
            this.writeJSONError(t.getMessage(), resp.getOutputStream());
        }
    }

    private void doPostMultipart(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Identifier methodName = this.readMethod(req);
        ExecutionMode mode = this.readMode(req);
        boolean main = this.readMain(req);
        Map<String, byte[]> parts = this.readPartsAsBytes(req);
        String jsonParams = new String(parts.get("params"));
        RequestRouter handler = new RequestRouter();
        handler.route(mode, methodName, jsonParams, parts, main, resp);
        resp.flushBuffer();
        resp.getOutputStream().close();
    }

    private void doPostJson(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(415);
    }

    private void doPostUrlEncoded(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(415);
    }

    private boolean readMain(HttpServletRequest req) {
        String main = req.getParameter("main");
        if (main != null) {
            return Boolean.valueOf(main);
        }
        return false;
    }

    protected Identifier readMethod(HttpServletRequest req) {
        String method = req.getPathInfo();
        logger.debug(() -> "Executing Prompto method: " + method);
        return new Identifier(method.substring(1));
    }

    protected ExecutionMode readMode(HttpServletRequest req) {
        String mode = req.getParameter("mode");
        if (mode != null) {
            if (mode.endsWith("I")) {
                return ExecutionMode.INTERPRET;
            }
            if (mode.endsWith("E")) {
                return ExecutionMode.EXECUTE;
            }
            return ExecutionMode.valueOf(mode.toUpperCase());
        }
        return ExecutionMode.INTERPRET;
    }
}

