/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ServerSocketFactory;

public abstract class SocketUtils {
    public static int findAvailablePortInRange(int min, int max) throws IOException {
        HashSet<Integer> alreadyTried = new HashSet<Integer>();
        while (true) {
            int port;
            if (!alreadyTried.add(port = ThreadLocalRandom.current().nextInt(min, max + 1))) {
                continue;
            }
            if (SocketUtils.isAvailablePort(port)) {
                return port;
            }
            if (alreadyTried.size() >= 1 + max - min) break;
        }
        throw new IOException("No available port!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAvailablePort(int port) {
        try (ServerSocket s = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));){
            s.setReuseAddress(false);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

