/*
 * Decompiled with CFR 0.152.
 */
package prompto.security.auth.source;

import com.esotericsoftware.yamlbeans.document.YamlMapping;
import prompto.config.IConfigurationReader;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;

public interface IAuthenticationSourceFactory {
    public static IAuthenticationSourceFactory newFactory(String factoryName) throws Throwable {
        Class<?> klass = Class.forName(factoryName, true, Thread.currentThread().getContextClassLoader());
        if (!IAuthenticationSourceFactory.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Not an authentication source factory: " + factoryName);
        }
        return (IAuthenticationSourceFactory)klass.newInstance();
    }

    public IAuthenticationSourceConfiguration newConfiguration(IConfigurationReader var1);

    public void setConfiguration(IAuthenticationSourceConfiguration var1);

    public String installJettyLoginModule();

    default public YamlMapping toYaml() throws Throwable {
        YamlMapping yaml = new YamlMapping();
        yaml.setEntry("factory", this.getClass().getName());
        return yaml;
    }
}

