/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import prompto.cloud.Cloud;
import prompto.config.IConfigurationReader;
import prompto.config.IDebugConfiguration;
import prompto.config.IHttpConfiguration;
import prompto.config.IRuntimeConfiguration;
import prompto.config.IServerConfiguration;
import prompto.config.ServerConfiguration;
import prompto.debug.DebugRequestServer;
import prompto.declaration.IMethodDeclaration;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.libraries.Libraries;
import prompto.runtime.Context;
import prompto.runtime.Interpreter;
import prompto.runtime.Standalone;
import prompto.security.auth.source.IAuthenticationSource;
import prompto.server.JettyServer;
import prompto.server.ServerIdentifierProcessor;
import prompto.server.UserServlet;
import prompto.utils.CmdLineParser;
import prompto.utils.Logger;
import prompto.value.Document;

public class AppServer {
    static final Logger logger = new Logger();
    public static final String WEB_SERVER_SUCCESSFULLY_STARTED = "Web server successfully started on port ";
    static JettyServer jettyServer;
    static ThreadLocal<String> httpUser;
    static ThreadLocal<Document> httpSession;

    public static void main(String[] args) throws Throwable {
        AppServer.main(args, null);
    }

    public static void main(String[] args, Consumer<IServerConfiguration> afterStart) throws Throwable {
        IServerConfiguration config = AppServer.loadConfiguration(args);
        AppServer.main(config, afterStart);
    }

    public static <T extends IServerConfiguration> void main(T config, Consumer<T> afterStart) throws Throwable {
        AppServer.installCloudJARs();
        AppServer.initialize(config);
        AppServer.run(config);
        if (afterStart != null) {
            afterStart.accept(config);
        }
    }

    private static void installCloudJARs() throws Exception {
        Cloud cloud = Cloud.current();
        if (cloud == null) {
            return;
        }
        Collection<URL> jars = cloud.getJarURsL();
        if (jars == null) {
            return;
        }
        jars = AppServer.filterOutAlreadyLoadedJars(jars);
        AppServer.addJarsToSystemClassLoader(jars);
    }

    private static Collection<URL> filterOutAlreadyLoadedJars(Collection<URL> jars) {
        URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        HashSet<URL> alreadyLoaded = new HashSet<URL>(Arrays.asList(loader.getURLs()));
        return jars.stream().filter(u -> !alreadyLoaded.contains(u)).collect(Collectors.toList());
    }

    private static void addJarsToSystemClassLoader(Collection<URL> jars) throws Exception {
        URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        for (URL url : jars) {
            logger.debug(() -> "Adding JAR " + url.toString() + " to system class loader...");
            method.invoke((Object)loader, url);
        }
    }

    public static void initialize(IServerConfiguration config) throws Throwable {
        ServerIdentifierProcessor.register();
        Standalone.initialize((IRuntimeConfiguration)config);
    }

    public static IServerConfiguration loadConfiguration(String[] args) throws Exception {
        Map argsMap = CmdLineParser.read((String[])args);
        IConfigurationReader reader = Standalone.readerFromArgs((Map)argsMap);
        ServerConfiguration config = new ServerConfiguration(reader, argsMap);
        return (IServerConfiguration)config.withRuntimeLibs(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class}));
    }

    private static void run(IServerConfiguration config) throws Throwable {
        IHttpConfiguration http = config.getHttpConfiguration();
        if (http == null) {
            logger.error(() -> "Missing http configuration!");
            throw new RuntimeException();
        }
        IDebugConfiguration debug = config.getDebugConfiguration();
        if (debug != null) {
            AppServer.debugServer(debug, config, (jetty, list) -> AppServer.prepareWebHandlers(jetty, list));
        } else {
            AppServer.startServer(config, (jetty, list) -> AppServer.prepareWebHandlers(jetty, list), () -> Standalone.getGlobalContext().notifyTerminated());
        }
    }

    static int debugServer(IDebugConfiguration debug, IServerConfiguration config, BiConsumer<JettyServer, HandlerList> handler) throws Throwable {
        DebugRequestServer server = Standalone.startDebugging((String)debug.getHost(), (Integer)debug.getPort());
        return AppServer.startServer(config, handler, () -> {
            Standalone.getGlobalContext().notifyTerminated();
            server.stopListening();
        });
    }

    static int startServer(IServerConfiguration config, BiConsumer<JettyServer, HandlerList> handler, Runnable serverStopped) throws Throwable {
        logger.info(() -> "Starting web server on port " + config.getHttpConfiguration().getPort() + "...");
        jettyServer = new JettyServer(config);
        jettyServer.prepare(handler);
        AppServer.callServerAboutToStart(config);
        AppServer.start(serverStopped);
        int port = jettyServer.getHttpPort();
        logger.info(() -> WEB_SERVER_SUCCESSFULLY_STARTED + port);
        return port;
    }

    public static void callServerAboutToStart(IServerConfiguration config) {
        String serverAboutToStartMethod = config.getServerAboutToStartMethod();
        if (serverAboutToStartMethod != null) {
            logger.info(() -> "Calling startUp method '" + serverAboutToStartMethod + "'");
            Interpreter.interpretMethod((Context)Standalone.getGlobalContext(), (Identifier)new Identifier(serverAboutToStartMethod), (IExpression)Standalone.argsToArgValue((Map)config.getArguments()));
        }
    }

    static void prepareWebHandlers(JettyServer jetty, HandlerList list) {
        try {
            list.addHandler((Handler)jetty.newWebAppHandler());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int start(Runnable serverStopped) throws Throwable {
        if (jettyServer.isStarted()) {
            throw new RuntimeException("Server is already started!");
        }
        jettyServer.jettyStart(serverStopped);
        return jettyServer.getHttpPort();
    }

    public static void stop() throws Exception {
        if (jettyServer == null || !jettyServer.isStarted()) {
            throw new RuntimeException("Server is not started!");
        }
        jettyServer.jettyStop();
    }

    public static boolean isStarted() {
        return jettyServer != null && jettyServer.isStarted();
    }

    public static long getHttpPort() {
        return jettyServer.getHttpPort();
    }

    public static void installHandler(String path, IMethodDeclaration method) {
        logger.info(() -> "Installing web service '" + method.getName() + "' at path '" + path + "'");
        WebAppContext handler = (WebAppContext)jettyServer.getChildHandlerByClass(WebAppContext.class);
        UserServlet servlet = new UserServlet(method);
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        servlet.setHolder(holder);
        handler.addServlet(holder, path);
    }

    public static void createLogin(String login, String password) {
        IAuthenticationSource source = (IAuthenticationSource)IAuthenticationSource.instance.get();
        if (source != null) {
            source.createLogin(login, password);
        }
    }

    public static String getHttpUser() {
        return httpUser.get();
    }

    public static void setHttpUser(String user) {
        httpUser.set(user);
    }

    public static Document getHttpSession() {
        return httpSession.get();
    }

    public static void setHttpSession(Document session) {
        httpSession.set(session);
    }

    static {
        httpUser = new ThreadLocal();
        httpSession = new ThreadLocal();
    }
}

