/*
 * Decompiled with CFR 0.152.
 */
package prompto.transpiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import prompto.code.ICodeStore;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IWidgetDeclaration;
import prompto.declaration.WrappingWidgetDeclaration;
import prompto.error.SyntaxError;
import prompto.runtime.Context;
import prompto.runtime.Standalone;
import prompto.store.DataStore;
import prompto.transpiler.IJSEngine;
import prompto.transpiler.Transpiler;
import prompto.utils.Logger;
import prompto.utils.YamlUtils;

public class HtmlGenerator {
    static final Logger logger = new Logger();
    String userAgent;
    Map<String, Object> pageConfig;

    public HtmlGenerator(String userAgent, Map<String, Object> pageConfig) {
        this.userAgent = userAgent;
        this.pageConfig = pageConfig;
    }

    public void generate(Context context, File htmlFile) throws IOException {
        try (FileOutputStream output = new FileOutputStream(htmlFile);
             OutputStreamWriter writer = new OutputStreamWriter(output);
             PrintWriter printer = new PrintWriter(writer);){
            this.generate(context, printer);
        }
    }

    private void generate(Context context, PrintWriter printer) throws IOException {
        this.generateProlog(printer);
        Consumer<PrintWriter> bodyWriter = this.generateHeader(context, printer);
        bodyWriter.accept(printer);
        this.generateEpilog(printer);
    }

    private void generateRenderScript(PrintWriter printer, String widgetName) {
        printer.println("<script>");
        printer.println("function renderBody() {");
        printer.print("var pageWidget = React.createElement( ");
        printer.print(widgetName);
        printer.println(");");
        printer.print("ReactDOM.render(pageWidget, document.getElementById('body'));");
        printer.println("}");
        printer.println("</script>");
    }

    private void generateProlog(PrintWriter printer) {
        printer.println("<!DOCTYPE html>");
        printer.println("<html>");
    }

    private Consumer<PrintWriter> generateHeader(Context context, PrintWriter printer) throws IOException {
        printer.println("<head>");
        this.generateTitle(printer);
        this.generateIcon(printer);
        this.generatePromptoScripts(printer);
        this.generateLibraries(printer);
        Consumer<PrintWriter> bodyWriter = this.generateWidgetScript(context, printer);
        printer.println("</head>");
        return bodyWriter;
    }

    private Consumer<PrintWriter> generateWidgetScript(Context context, PrintWriter printer) {
        try {
            String widgetName = this.getWidgetName();
            this.generateWidgetScript(context, printer, widgetName);
            return this::generateBody;
        }
        catch (SyntaxError e) {
            return p -> this.generateSyntaxError((PrintWriter)p, e);
        }
        catch (Exception e) {
            return p -> this.generateException((PrintWriter)p, e);
        }
    }

    private void generateException(PrintWriter printer, Exception e) {
        printer.println("<body>");
        e.printStackTrace(printer);
        printer.println("</body>");
    }

    private void generateSyntaxError(PrintWriter printer, SyntaxError e) {
        printer.println("<body>");
        printer.println("Syntax error '" + e.getMessage() + "'");
        printer.println("</body>");
    }

    private String getWidgetName() {
        Map<String, Object> body = this.getBodyConfig();
        if (body == null) {
            throw new SyntaxError("Missing 'body' section in page descriptor");
        }
        Object value = body.get("widget");
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            throw new SyntaxError("Missing 'widget' entry in 'body' section of page descriptor");
        }
        throw new SyntaxError("Expected a String for 'widget', got " + value.getClass().getName());
    }

    private void generateWidgetScript(Context context, PrintWriter printer, String widgetName) {
        IWidgetDeclaration widget = this.fetchWidgetDeclaration(context, widgetName);
        if (widget == null) {
            throw new SyntaxError("No such widget '" + widgetName + "'");
        }
        this.generateWidgetScript(printer, widget);
        this.generateRenderScript(printer, widgetName);
    }

    private IWidgetDeclaration fetchWidgetDeclaration(Context context, String widgetName) {
        Iterable decls = ICodeStore.getInstance().fetchLatestDeclarations(widgetName);
        if (decls == null) {
            return null;
        }
        Iterator iter = decls.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        IDeclaration decl = (IDeclaration)iter.next();
        if (!(decl instanceof CategoryDeclaration)) {
            return null;
        }
        if (!((CategoryDeclaration)decl).isAWidget(context)) {
            return null;
        }
        return decl instanceof IWidgetDeclaration ? (IWidgetDeclaration)decl : new WrappingWidgetDeclaration((CategoryDeclaration)decl);
    }

    private void generateWidgetScript(PrintWriter printer, IWidgetDeclaration declaration) {
        IJSEngine engine = IJSEngine.forUserAgent((String)this.userAgent);
        Context context = Standalone.getGlobalContext();
        Transpiler transpiler = new Transpiler(engine, context);
        declaration.declare(transpiler);
        if (transpiler.requires("DataStore")) {
            transpiler.require("RemoteStore");
            if (DataStore.getInstance().getDbIdClass() == UUID.class) {
                transpiler.require("UUID");
            }
        }
        printer.println("<script id='transpiled'>");
        transpiler.print(printer);
        printer.println("</script>");
    }

    private void generatePromptoScripts(PrintWriter printer) {
        printer.println("<script src='https://cdnjs.cloudflare.com/ajax/libs/axios/0.17.1/axios.js'></script>");
        printer.println("<script src='/js/lib/require.js'></script>");
    }

    private void generateLibraries(PrintWriter printer) throws IOException {
        Map<String, Object> header = this.getHeaderConfig();
        if (header == null) {
            return;
        }
        if (!this.generateWidgetLibrary(printer, header)) {
            this.generateHtmlEngine(printer, header);
            this.generateUiFramework(printer, header);
        }
        this.generateStyleSheets(printer, header);
        this.generateJavascripts(printer, header);
    }

    private void generateStyleSheets(PrintWriter printer, Map<String, Object> config) {
        Object value = config.get("styleSheets");
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            ((Collection)value).forEach(item -> {
                if (item instanceof String) {
                    printer.print("<link href=\"");
                    printer.print((String)item);
                    printer.println("\" rel=\"stylesheet\"/>");
                } else {
                    logger.warn(() -> "Expected a String, got " + value.getClass().getName());
                }
            });
        } else {
            logger.warn(() -> "Expected a Collection, got " + value.getClass().getName());
        }
    }

    private void generateJavascripts(PrintWriter printer, Map<String, Object> config) {
        Object value = config.get("javaScripts");
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            ((Collection)value).forEach(item -> {
                if (item instanceof String) {
                    printer.print("<script crossorigin src=\"");
                    printer.print((String)item);
                    printer.println("\"></script>");
                } else {
                    logger.warn(() -> "Expected a String, got " + value.getClass().getName());
                }
            });
        } else {
            logger.warn(() -> "Expected a Collection, got " + value.getClass().getName());
        }
    }

    private void generateUiFramework(PrintWriter printer, Map<String, Object> config) throws IOException {
        Object value = config.get("uiFramework");
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            config = YamlUtils.readResource((String)("uiFrameworks/" + value + ".yaml"));
            this.generateStyleSheets(printer, config);
            this.generateJavascripts(printer, config);
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
    }

    private void generateHtmlEngine(PrintWriter printer, Map<String, Object> config) throws IOException {
        Object value = config.get("htmlEngine");
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            config = YamlUtils.readResource((String)("htmlEngines/" + value + ".yaml"));
            this.generateStyleSheets(printer, config);
            this.generateJavascripts(printer, config);
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
    }

    private boolean generateWidgetLibrary(PrintWriter printer, Map<String, Object> config) throws IOException {
        Object value = config.get("widgetLibrary");
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            config = YamlUtils.readResource((String)("widgetLibraries/" + value + ".yaml"));
            this.generateHtmlEngine(printer, config);
            this.generateUiFramework(printer, config);
            this.generateStyleSheets(printer, config);
            this.generateJavascripts(printer, config);
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
        return true;
    }

    private void generateIcon(PrintWriter printer) {
        Map<String, Object> header = this.getHeaderConfig();
        if (header == null) {
            return;
        }
        Object value = header.get("icon");
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            printer.print("<link href=\"");
            printer.print(value);
            printer.println("\" rel=\"icon\" type=\"image/ico\"/>");
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
    }

    private void generateTitle(PrintWriter printer) {
        Map<String, Object> header = this.getHeaderConfig();
        if (header == null) {
            return;
        }
        Object value = header.get("title");
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            printer.print("<title>");
            printer.print(value);
            printer.println("</title>");
        } else {
            logger.warn(() -> "Expected a String, got " + value.getClass().getName());
        }
    }

    private Map<String, Object> getHeaderConfig() {
        return this.getConfig(this.pageConfig, "header");
    }

    private Map<String, Object> getBodyConfig() {
        return this.getConfig(this.pageConfig, "body");
    }

    private Map<String, Object> getConfig(Map<String, Object> source, String key) {
        Object value = source.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        logger.warn(() -> "Expected a Map<String, Object>, got " + value.getClass().getName());
        return null;
    }

    private void generateBody(PrintWriter printer) {
        printer.println("<body onLoad='renderBody()'>");
        printer.println("<div id=\"body\"></div>");
        printer.println("</body>");
    }

    private void generateEpilog(PrintWriter printer) {
        printer.println("</html>");
    }
}

