/*
 * Decompiled with CFR 0.152.
 */
package prompto.config.auth;

import java.util.Collection;
import prompto.config.IConfigurationReader;
import prompto.config.auth.IAuthenticationConfiguration;
import prompto.config.auth.method.AuthenticationMethodConfiguration;
import prompto.config.auth.method.IAuthenticationMethodConfiguration;
import prompto.config.auth.source.AuthenticationSourceConfiguration;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;
import prompto.security.auth.method.BasicAuthenticationMethodFactory;

public class AuthenticationConfiguration
extends IAuthenticationConfiguration.Inline {
    IConfigurationReader reader;

    public AuthenticationConfiguration(IConfigurationReader reader) {
        this.reader = reader;
        this.authenticationSourceConfiguration = () -> this.readAuthenticationSourceConfiguration();
        this.authenticationMethodConfiguration = () -> this.readAuthenticationMethodConfiguration();
        this.whiteList = () -> this.readWhiteList();
    }

    private Collection<String> readWhiteList() {
        Collection list = this.reader.getArray("whiteList");
        return list != null ? list : DEFAULT_WHITE_LIST;
    }

    private IAuthenticationSourceConfiguration readAuthenticationSourceConfiguration() {
        IConfigurationReader child = this.reader.getObject("source");
        return child == null ? null : new AuthenticationSourceConfiguration(child);
    }

    private IAuthenticationMethodConfiguration readAuthenticationMethodConfiguration() {
        IConfigurationReader child = this.reader.getObject("method");
        if (child == null) {
            return () -> new BasicAuthenticationMethodFactory();
        }
        return new AuthenticationMethodConfiguration(child);
    }
}

