/*
 * Decompiled with CFR 0.152.
 */
package prompto.security.auth.method;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

@FunctionalInterface
public interface DigestMethod
extends BiFunction<String, String, String> {
    public static final Map<String, DigestMethod> digestMethods = Collections.singletonMap("PBKDF2", new PBKDF2());

    default public String digest(String credentials, String saltString) {
        return (String)this.apply(credentials, saltString);
    }

    public static DigestMethod forName(String name) {
        return digestMethods.get(name);
    }

    public static String newSalt() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[16];
        sr.nextBytes(salt);
        return Base64.getEncoder().encodeToString(salt);
    }

    public static class PBKDF2
    implements DigestMethod {
        @Override
        public String apply(String credentials, String saltString) {
            try {
                int iterations = 1000;
                int keyLength = 512;
                char[] password = credentials.toCharArray();
                byte[] salt = Base64.getDecoder().decode(saltString);
                PBEKeySpec spec = new PBEKeySpec(password, salt, 1000, 512);
                SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                byte[] hash = skf.generateSecret(spec).getEncoded();
                return Base64.getEncoder().encodeToString(hash);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
    }
}

