/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidParameterException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import prompto.compiler.PromptoClassLoader;
import prompto.error.PromptoError;
import prompto.expression.MethodSelector;
import prompto.grammar.ArgumentAssignmentList;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDict;
import prompto.remoting.ParameterList;
import prompto.runtime.Context;
import prompto.runtime.Executor;
import prompto.runtime.Interpreter;
import prompto.server.ExecutionMode;
import prompto.statement.MethodCall;
import prompto.store.DataStore;
import prompto.store.IStore;
import prompto.store.memory.MemStore;
import prompto.value.BinaryValue;
import prompto.value.IValue;
import prompto.value.Text;

public class RequestRouter {
    PromptoClassLoader classLoader;
    Context context;

    public RequestRouter(PromptoClassLoader classLoader, Context context) {
        this.classLoader = classLoader;
        this.context = context.newLocalContext();
    }

    public void route(ExecutionMode mode, Identifier methodName, String jsonParams, Map<String, byte[]> parts, boolean main, HttpServletResponse response) throws Exception {
        boolean isTest = methodName.toString().startsWith("\"") && methodName.toString().endsWith("\"");
        switch (mode) {
            case INTERPRET: {
                if (isTest) {
                    this.interpretTest(methodName, response);
                    break;
                }
                this.interpretMethod(methodName, jsonParams, parts, main, response);
                break;
            }
            case EXECUTE: {
                if (isTest) {
                    this.executeTest(methodName, response);
                    break;
                }
                this.executeMethod(methodName, jsonParams, parts, main, response);
                break;
            }
            default: {
                throw new InvalidParameterException(mode.name());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTest(Identifier testName, HttpServletResponse response) throws Exception {
        PrintStream oldOut = System.out;
        IStore oldStore = DataStore.getInstance();
        DataStore.setInstance((IStore)new MemStore());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        System.setOut(new PrintStream(bytes));
        try {
            Executor.executeTest((PromptoClassLoader)this.classLoader, (String)testName.toString());
            bytes.flush();
            String[] lines = new String(bytes.toByteArray()).split("\n");
            this.writeJsonResponse(lines, response);
        }
        finally {
            DataStore.setInstance((IStore)oldStore);
            System.setOut(oldOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interpretTest(Identifier testName, HttpServletResponse response) throws IOException {
        PrintStream oldOut = System.out;
        IStore oldStore = DataStore.getInstance();
        DataStore.setInstance((IStore)new MemStore());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        System.setOut(new PrintStream(bytes));
        try {
            Interpreter.interpretTest((Context)this.context, (Identifier)testName, (boolean)true);
            bytes.flush();
            String[] lines = new String(bytes.toByteArray()).split("\n");
            this.writeJsonResponse(lines, response);
        }
        finally {
            DataStore.setInstance((IStore)oldStore);
            System.setOut(oldOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMethod(Identifier methodName, String jsonParams, Map<String, byte[]> parts, boolean main, HttpServletResponse response) throws Exception {
        try {
            Object result;
            ParameterList params = ParameterList.read((Context)this.context, (String)jsonParams, parts);
            Class[] argTypes = params.toJavaTypes(this.context, (ClassLoader)this.classLoader);
            Object[] args = params.toJavaValues(this.context);
            if (params.isEmpty() && main) {
                argTypes = new Class[]{PromptoDict.class};
                args = new Object[]{null};
            }
            Text text = new Text((result = Executor.executeGlobalMethod((PromptoClassLoader)this.classLoader, (Identifier)methodName, (Class[])argTypes, (Object[])args)) == null ? "success!" : result.toString());
            this.writeJsonResponse((IValue)text, response);
        }
        finally {
            this.context.notifyTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpretMethod(Identifier methodName, String jsonParams, Map<String, byte[]> parts, boolean main, HttpServletResponse response) throws Exception {
        try {
            ParameterList params = ParameterList.read((Context)this.context, (String)jsonParams, parts);
            ArgumentAssignmentList assignments = params.toAssignments(this.context);
            IValue value = this.interpretMethod(this.context, methodName, assignments, main);
            if (value == null) {
                value = new Text("Success!");
            }
            if (value instanceof BinaryValue) {
                this.writeBinaryResponse((BinaryValue)value, response);
            } else {
                this.writeJsonResponse(value, response);
            }
        }
        finally {
            this.context.notifyTerminated();
        }
    }

    private IValue interpretMethod(Context context, Identifier methodName, ArgumentAssignmentList assignments, boolean main) {
        if (assignments.isEmpty() && main) {
            Interpreter.interpretMainNoArgs((Context)context, (Identifier)methodName);
            return null;
        }
        MethodCall methodCall = new MethodCall(new MethodSelector(methodName), assignments);
        return methodCall.interpret(context);
    }

    private void writeBinaryResponse(BinaryValue value, HttpServletResponse response) throws IOException {
        response.setContentType(value.getMimeType());
        response.setStatus(200);
        response.getOutputStream().write(value.getBytes());
    }

    private void writeJsonResponse(IValue value, HttpServletResponse response) throws IOException, PromptoError {
        response.setContentType("text/json");
        response.setStatus(200);
        JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)response.getOutputStream());
        generator.writeStartObject();
        generator.writeNullField("error");
        if (value == null) {
            generator.writeNullField("data");
        } else {
            generator.writeFieldName("data");
            value.toJson(this.context, generator, null, null, true, null);
        }
        generator.writeEndObject();
        generator.flush();
        generator.close();
    }

    private void writeJsonResponse(String[] lines, HttpServletResponse response) throws IOException, PromptoError {
        response.setContentType("text/json");
        response.setStatus(200);
        JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)response.getOutputStream());
        generator.writeStartObject();
        generator.writeNullField("error");
        generator.writeArrayFieldStart("data");
        for (String line : lines) {
            generator.writeString(line);
        }
        generator.writeEndArray();
        generator.writeEndObject();
        generator.flush();
        generator.close();
    }
}

