/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoTime;
import prompto.server.CleverServlet;
import prompto.server.JsonRecordsWriter;
import prompto.store.AttributeInfo;
import prompto.store.DataStore;
import prompto.store.IQueryBuilder;
import prompto.store.IStorable;
import prompto.store.IStored;
import prompto.store.IStoredIterable;
import prompto.utils.Logger;

public class StoreServlet
extends CleverServlet {
    static Logger logger = new Logger();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doStuff(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doStuff(req, resp);
    }

    protected void doStuff(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path != null) {
            switch (path) {
                case "/fetchOne": {
                    this.fetchOne(req, resp);
                    break;
                }
                case "/fetchMany": {
                    this.fetchMany(req, resp);
                    break;
                }
                case "/deleteAndStore": {
                    this.store(req, resp);
                }
                default: {
                    resp.sendError(404);
                }
            }
        }
    }

    protected void store(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String contentType = req.getContentType();
            if (contentType.startsWith("application/json")) {
                this.storeJson(req, resp);
            } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
                this.storeUrlEncoded(req, resp);
            } else if (contentType.startsWith("multipart/form-data")) {
                this.storeMultipart(req, resp);
            } else {
                resp.sendError(415);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            resp.setStatus(500);
            this.writeJSONError(t.getMessage(), resp.getOutputStream());
        }
    }

    private void storeJson(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<Object, Object> updatedDbIds = new HashMap();
        JsonNode json = this.readJsonStream(req);
        if (json.has("toDelete")) {
            this.deleteJson(json.get("toDelete"));
        }
        if (json.has("toStore")) {
            updatedDbIds = this.storeJson(json.get("toStore"));
        }
        this.writeJSONResult(updatedDbIds, resp.getOutputStream());
    }

    private Map<Long, Object> storeJson(JsonNode toStore) {
        HashMap<Long, Object> updatedDbIds = new HashMap<Long, Object>();
        if (toStore.isArray()) {
            List storables = StreamSupport.stream(toStore.spliterator(), false).map(node -> this.jsonToStorable((JsonNode)node, (Map<Long, Object>)updatedDbIds)).collect(Collectors.toList());
            DataStore.getInstance().store(storables);
        } else {
            logger.error(() -> "Could not delete: " + toStore.toString());
        }
        return updatedDbIds;
    }

    private IStorable jsonToStorable(JsonNode node, Map<Long, Object> updatedDbIds) {
        List<String> categories = this.readJsonCategories(node);
        IStorable storable = DataStore.getInstance().newStorable(categories, null);
        this.populateStorable(node, storable, updatedDbIds);
        return storable;
    }

    private void populateStorable(JsonNode record, IStorable storable, Map<Long, Object> updatedDbIds) {
        if (this.isRecordUpdate(record)) {
            this.populateExistingStorable(record, storable, updatedDbIds);
        } else {
            this.populateNewStorable(record, storable, updatedDbIds);
        }
    }

    private boolean isRecordUpdate(JsonNode record) {
        JsonNode dbIdField = record.get("dbId");
        return dbIdField != null && !dbIdField.has("tempDbId");
    }

    private void populateExistingStorable(JsonNode record, IStorable storable, Map<Long, Object> updatedDbIds) {
        Object rawDbId = this.readJsonValue(record.get("dbId"), updatedDbIds);
        Object dbId = DataStore.getInstance().convertToDbId(rawDbId);
        Iterator fieldNames = record.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            if ("dbId".equals(fieldName)) continue;
            Object value = this.readJsonValue(record.get(fieldName), updatedDbIds);
            storable.setData(fieldName, value, () -> dbId);
        }
    }

    private void populateNewStorable(JsonNode record, IStorable storable, Map<Long, Object> updatedDbIds) {
        Iterator fieldNames = record.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            Object value = this.readJsonValue(record.get(fieldName), updatedDbIds);
            if ("dbId".equals(fieldName)) {
                storable.setDbId(DataStore.getInstance().convertToDbId(value));
                continue;
            }
            storable.setData(fieldName, value);
        }
    }

    private Object readJsonValue(JsonNode fieldValue, Map<Long, Object> updatedDbIds) {
        if (fieldValue.has("tempDbId")) {
            return updatedDbIds.computeIfAbsent(fieldValue.get("tempDbId").asLong(), k -> DataStore.getInstance().newDbId());
        }
        if (fieldValue.isDouble() || fieldValue.isFloat()) {
            return fieldValue.asDouble();
        }
        if (fieldValue.isLong() || fieldValue.isInt()) {
            return fieldValue.asLong();
        }
        if (fieldValue.isBoolean()) {
            return fieldValue.asBoolean();
        }
        if (fieldValue.isTextual()) {
            return fieldValue.asText();
        }
        if (fieldValue.isNull()) {
            return null;
        }
        if (fieldValue.isObject()) {
            return this.readJsonValue(fieldValue.get("type").asText(), fieldValue.get("value"), updatedDbIds);
        }
        if (fieldValue.isArray()) {
            return StreamSupport.stream(fieldValue.spliterator(), false).map(node -> this.readJsonValue((JsonNode)node, updatedDbIds)).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException(fieldValue.getNodeType().name());
    }

    private Object readJsonValue(String type, JsonNode fieldValue, Map<Long, Object> updatedDbIds) {
        switch (type) {
            case "Uuid": {
                return UUID.fromString(fieldValue.asText());
            }
            case "Date": {
                return PromptoDate.parse((String)fieldValue.asText());
            }
            case "Time": {
                return PromptoTime.parse((String)fieldValue.asText());
            }
            case "DateTime": {
                return PromptoDateTime.parse((String)fieldValue.asText());
            }
            case "%dbRef%": {
                return DataStore.getInstance().convertToDbId(this.readJsonValue(fieldValue, updatedDbIds));
            }
        }
        throw new UnsupportedOperationException(type);
    }

    private List<String> readJsonCategories(JsonNode node) {
        return StreamSupport.stream(node.get("category").spliterator(), false).map(JsonNode::asText).collect(Collectors.toList());
    }

    private void deleteJson(JsonNode toDelete) {
        if (toDelete.isNumber()) {
            DataStore.getInstance().delete((Object)toDelete.asLong());
        } else if (toDelete.isTextual()) {
            DataStore.getInstance().delete((Object)toDelete.asText());
        } else {
            logger.error(() -> "Could not delete: " + toDelete.toString());
        }
    }

    private void storeMultipart(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(415);
    }

    private void storeUrlEncoded(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(415);
    }

    protected void fetchMany(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String contentType = req.getContentType();
            if (contentType.startsWith("application/json")) {
                this.fetchManyJson(req, resp);
            } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
                this.fetchManyUrlEncoded(req, resp);
            } else if (contentType.startsWith("multipart/form-data")) {
                this.fetchManyMultipart(req, resp);
            } else {
                resp.sendError(415);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            resp.setStatus(500);
            this.writeJSONError(t.getMessage(), resp.getOutputStream());
        }
    }

    private void fetchManyMultipart(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(415);
    }

    private void fetchManyUrlEncoded(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(415);
    }

    private void fetchManyJson(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JsonNode json = this.readJsonStream(req);
        IQueryBuilder builder = DataStore.getInstance().newQueryBuilder();
        if (json.has("predicate") && !json.get("predicate").isNull()) {
            this.readPredicateJson(builder, json.get("predicate"));
        }
        if (json.has("first") && !json.get("first").isNull()) {
            builder = builder.first(Long.valueOf(json.get("first").asLong()));
        }
        if (json.has("last") && !json.get("last").isNull()) {
            builder = builder.last(Long.valueOf(json.get("last").asLong()));
        }
        if (json.has("orderBys") && !json.get("orderBys").isNull()) {
            this.readOrderBysJson(builder, json.get("orderBys"));
        }
        resp.setContentType("application/json");
        IStoredIterable fetched = DataStore.getInstance().fetchMany(builder.build());
        JsonRecordsWriter writer = new JsonRecordsWriter((OutputStream)resp.getOutputStream(), this::fetchAttributeInfo, DataStore.getInstance(), true);
        writer.writeRecords(fetched);
    }

    protected void fetchOne(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String contentType = req.getContentType();
            if (contentType.startsWith("application/json")) {
                this.fetchOneJson(req, resp);
            } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
                this.fetchOneUrlEncoded(req, resp);
            } else if (contentType.startsWith("multipart/form-data")) {
                this.fetchOneMultipart(req, resp);
            } else {
                resp.sendError(415);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            resp.setStatus(500);
            this.writeJSONError(t.getMessage(), resp.getOutputStream());
        }
    }

    private void fetchOneMultipart(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(415);
    }

    private void fetchOneUrlEncoded(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(415);
    }

    private void fetchOneJson(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JsonNode json = this.readJsonStream(req);
        IQueryBuilder builder = DataStore.getInstance().newQueryBuilder();
        if (json.has("predicate") && !json.get("predicate").isNull()) {
            this.readPredicateJson(builder, json.get("predicate"));
        }
        resp.setContentType("application/json");
        IStored fetched = DataStore.getInstance().fetchOne(builder.build());
        JsonRecordsWriter writer = new JsonRecordsWriter((OutputStream)resp.getOutputStream(), this::fetchAttributeInfo, DataStore.getInstance(), true);
        writer.writeRecord(fetched);
    }

    private void readOrderBysJson(IQueryBuilder builder, JsonNode orderBys) {
        for (JsonNode orderBy : orderBys) {
            AttributeInfo info = DataStore.getInstance().getAttributeInfo(orderBy.get("info").get("name").asText());
            builder.orderBy(info, orderBy.get("descending").asBoolean());
        }
    }

    private void readPredicateJson(IQueryBuilder builder, JsonNode jsonNode) {
        String type;
        switch (type = jsonNode.get("type").asText()) {
            case "MatchPredicate": {
                this.readMatchPredicateJson(builder, jsonNode);
                break;
            }
            case "AndPredicate": {
                this.readAndPredicateJson(builder, jsonNode);
                break;
            }
            case "OrPredicate": {
                this.readOrPredicateJson(builder, jsonNode);
                break;
            }
            case "NotPredicate": {
                this.readNotPredicateJson(builder, jsonNode);
                break;
            }
            default: {
                throw new UnsupportedOperationException(type);
            }
        }
    }

    private void readMatchPredicateJson(IQueryBuilder builder, JsonNode jsonNode) {
        String name = jsonNode.get("info").get("name").asText();
        AttributeInfo info = this.fetchAttributeInfo(name);
        IQueryBuilder.MatchOp matchOp = IQueryBuilder.MatchOp.valueOf((String)jsonNode.get("matchOp").get("name").asText());
        Object value = this.readJsonValue(jsonNode.get("value"), new HashMap<Long, Object>());
        builder.verify(info, matchOp, value);
    }

    private AttributeInfo fetchAttributeInfo(String name) {
        return DataStore.getInstance().getAttributeInfo(name);
    }

    private void readAndPredicateJson(IQueryBuilder builder, JsonNode jsonNode) {
        this.readPredicateJson(builder, jsonNode.get("left"));
        this.readPredicateJson(builder, jsonNode.get("right"));
        builder.and();
    }

    private void readOrPredicateJson(IQueryBuilder builder, JsonNode jsonNode) {
        this.readPredicateJson(builder, jsonNode.get("left"));
        this.readPredicateJson(builder, jsonNode.get("right"));
        builder.or();
    }

    private void readNotPredicateJson(IQueryBuilder builder, JsonNode jsonNode) {
        this.readPredicateJson(builder, jsonNode.get("predicate"));
        builder.not();
    }

    private JsonNode readJsonStream(HttpServletRequest req) throws IOException {
        try (ServletInputStream input = req.getInputStream();){
            JsonNode jsonNode = new ObjectMapper().readTree((InputStream)input);
            return jsonNode;
        }
    }
}

