/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 339);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

var Section = __webpack_require__(19).Section;

function Identifier(name) {
    Section.call(this);
    this.name = name;
    return this;
}

Identifier.prototype = Object.create(Section.prototype);
Identifier.prototype.constructor = Identifier;

Identifier.prototype.toString = function() {
    return this.name;
};

Identifier.prototype.equals = function(other) {
    if(!other || !(other instanceof Identifier))
        return false;
    else
        return this.name==other.name;
};

exports.Identifier = Identifier;


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

var TextValue = null;

exports.resolve = function() {
    TextValue = __webpack_require__(17).TextValue;
};

var id = 0;

function Value (type) {
    this.id = ++id;
    this.type = type;
    this.mutable = false;
	return this;
}

Value.prototype.collectStorables = function(list) {
    // do nothing
};

Value.prototype.And = function(context, value) {
	throw new SyntaxError("Logical and not supported by " + this.constructor.name);
};

Value.prototype.Or = function(context, value) {
	throw new SyntaxError("Logical or not supported by " + this.constructor.name);
};

Value.prototype.Not = function(context) {
	throw new SyntaxError("Logical negation not supported by " + this.constructor.name);
};

Value.prototype.Add = function(context, value) {
	throw new SyntaxError("Add not supported by " + this.constructor.name);
};

Value.prototype.transpile = function(transpiler) {
    throw new Error("Transpile not implemented by " + this.constructor.name);
};


Value.prototype.Subtract = function(context, value) {
	throw new SyntaxError("Subtract not supported by " + this.constructor.name);
};

Value.prototype.Multiply = function(context, value) {
	throw new SyntaxError("Multiply not supported by " + this.constructor.name);
};

Value.prototype.Divide = function(context, value) {
	throw new SyntaxError("Divide not supported by " + this.constructor.name);
};

Value.prototype.IntDivide = function(context, value) {
	throw new SyntaxError("Integer divide not supported by " + this.constructor.name);
};

Value.prototype.Modulo = function(context, value) {
	throw new SyntaxError("Modulo not supported by " + this.constructor.name);
};

Value.prototype.Minus = function(context) {
	throw new SyntaxError("Minus not supported by " + this.constructor.name);
};

Value.prototype.CompareTo = function(context, value) {
	throw new SyntaxError("Compare not supported by " + this.constructor.name);
};

Value.prototype.getMemberValue = function(context, name) {
    if("text" == name) {
        return new TextValue(this.toString());
    }
    else
	    throw new SyntaxError("No member support for " + name + " in " + this.constructor.name);
};

Value.prototype.ConvertTo = function(type) {
	return this;
};

Value.prototype.Roughly = function(context, value) {
    return this.equals(value);
};


Value.prototype.Contains = function(context, value) {
    throw new SyntaxError("Contains not supported by " + this.constructor.name);
};

function Instance(type) {
    Value.call(this, type);
    return this;
}

Instance.prototype = Object.create(Value.prototype);
Instance.prototype.constructor = Instance;


function Container(type) {
    Value.call(this, type);
    return this;
}

Container.prototype = Object.create(Value.prototype);
Container.prototype.constructor = Container;


exports.Value = Value;
exports.Instance = Instance;
exports.Container = Container;


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

var CategoryArgument = null;
var NativeType = __webpack_require__(12).NativeType;
var BooleanType = __webpack_require__(5).BooleanType;
var DecimalType = __webpack_require__(23).DecimalType;
var CharacterType = null;
var ListType = __webpack_require__(26).ListType;
var RangeType = __webpack_require__(71).RangeType;
var TextType = null;
var AnyType = __webpack_require__(14).AnyType;
var TextValue = null;
var IntegerValue = __webpack_require__(3).IntegerValue;
var IntegerRange = __webpack_require__(248).IntegerRange;
var Identifier = __webpack_require__(0).Identifier;
var PeriodType = null;

exports.resolve = function() {
    CategoryArgument = __webpack_require__(95).CategoryArgument;
	CharacterType = __webpack_require__(31).CharacterType;
	TextType = __webpack_require__(6).TextType;
	PeriodType = __webpack_require__(86).PeriodType;
	TextValue = __webpack_require__(17).TextValue;
    resolveBuiltInMethodDeclaration();
}

function IntegerType()  {
	NativeType.call(this, new Identifier("Integer"));
	return this;
}

IntegerType.prototype = Object.create(NativeType.prototype);
IntegerType.prototype.constructor = IntegerType;

IntegerType.instance = new IntegerType();


IntegerType.prototype.isAssignableFrom = function(context, other) {
    return NativeType.prototype.isAssignableFrom.call(this, context, other)
        || (other == DecimalType.instance);
};


IntegerType.prototype.declare = function(transpiler) {
    var isAnInteger = __webpack_require__(16).isAnInteger;
    transpiler.require(isAnInteger);
};


IntegerType.prototype.transpile = function(transpiler) {
    transpiler.append('"Integer"');
};

IntegerType.prototype.checkAdd = function(context, other, tryReverse) {
	if(other === IntegerType.instance || other === DecimalType.instance) {
		return other;
	} else {
		return NativeType.prototype.checkAdd.call(this, context, other, tryReverse);
	}
};

IntegerType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if (other === IntegerType.instance || other === DecimalType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareAdd.call(this, transpiler, other, tryReverse, left, right);
}


IntegerType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if (other === IntegerType.instance || other === DecimalType.instance) {
        left.transpile(transpiler);
        transpiler.append(" + ");
        right.transpile(transpiler);
    } else
        return NativeType.prototype.transpileAdd.call(this, transpiler, other, tryReverse, left, right);
};

IntegerType.prototype.checkSubtract = function(context, other) {
	if(other === IntegerType.instance) {
		return this;
	} else if(other === DecimalType.instance) {
		return other;
	} else {
		return NativeType.prototype.checkSubtract.call(this, context, other);
	}
};

IntegerType.prototype.declareSubtract = function(transpiler, other, left, right) {
    if (other === IntegerType.instance || other === DecimalType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareSubtract.call(this, transpiler, other, left, right);
};

IntegerType.prototype.transpileSubtract = function(transpiler, other, left, right) {
    if (other === IntegerType.instance || other === DecimalType.instance) {
        left.transpile(transpiler);
        transpiler.append(" - ");
        right.transpile(transpiler);
    } else
        return NativeType.prototype.transpileSubtract.call(this, transpiler, other, left, right);
};


IntegerType.prototype.checkMultiply = function(context, other, tryReverse) {
	if(other === IntegerType.instance) {
		return this;
	} else if(other === DecimalType.instance) {
		return other;
	} else if(other === CharacterType.instance) {
		return TextType.instance;
	} else if(other === TextType.instance) {
		return other;
	} else if(other === PeriodType.instance) {
		return other;
	} else if(other instanceof ListType) {
		return other;
	} else {
		return NativeType.prototype.checkMultiply.call(this, context, other, tryReverse);
	}
};


IntegerType.prototype.declareMultiply = function(transpiler, other, tryReverse, left, right) {
    if (other === IntegerType.instance || other === DecimalType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareMultiply.call(this, transpiler, other, tryReverse, left, right);
};


IntegerType.prototype.transpileMultiply = function(transpiler, other, tryReverse, left, right) {
    if (other === IntegerType.instance || other === DecimalType.instance) {
        left.transpile(transpiler);
        transpiler.append(" * ");
        right.transpile(transpiler);
    } else
        return NativeType.prototype.transpileMultiply.call(this, transpiler, other, tryReverse, left, right);
};


IntegerType.prototype.checkDivide = function(context, other) {
	if(other === IntegerType.instance || other === DecimalType.instance) {
		return DecimalType.instance;
	} else {
		return NativeType.prototype.checkDivide.call(this, context, other);
	}
};


IntegerType.prototype.declareDivide = function(transpiler, other, left, right) {
    if (other === IntegerType.instance || other === DecimalType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareDivide.call(this, transpiler, other, left, right);
};


IntegerType.prototype.transpileDivide = function(transpiler, other, left, right) {
    if (other === IntegerType.instance || other === DecimalType.instance) {
        transpiler.append("divide(");
        left.transpile(transpiler);
        transpiler.append(", ");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileDivide.call(this, transpiler, other, left, right);
};


IntegerType.prototype.checkIntDivide = function(context, other) {
	if(other === IntegerType.instance) {
		return this;
	} else {
		return NativeType.prototype.checkIntDivide.call(this, context, other);
	}
};


IntegerType.prototype.declareIntDivide = function(transpiler, other, left, right) {
    if (other === IntegerType.instance ) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareIntDivide.call(this, transpiler, other, left, right);
};


IntegerType.prototype.transpileIntDivide = function(transpiler, other, left, right) {
    if (other === IntegerType.instance ) {
        // TODO check negative values
        transpiler.append("Math.floor(divide(");
        left.transpile(transpiler);
        transpiler.append(", ");
        right.transpile(transpiler);
        transpiler.append("))");
    } else
        return NativeType.prototype.transpileIntDivide.call(this, transpiler, other, left, right);
};



IntegerType.prototype.checkModulo = function(context, other) {
	if(other === IntegerType.instance) {
		return this;
	} else {
		return NativeType.prototype.checkModulo.call(this, context, other);
	}
};


IntegerType.prototype.declareModulo = function(transpiler, other, left, right) {
    if (other === IntegerType.instance ) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareModulo.call(this, transpiler, other, left, right);
};



IntegerType.prototype.transpileModulo = function(transpiler, other, left, right) {
    if (other === IntegerType.instance ) {
        // TODO check negative values
        left.transpile(transpiler);
        transpiler.append(" % ");
        right.transpile(transpiler);
    } else
        return NativeType.prototype.transpileModulo.call(this, transpiler, other, left, right);
};

IntegerType.prototype.checkMinus = function(context) {
	return this;
};


IntegerType.prototype.declareMinus = function(transpiler, value) {
    // nothing to do
};


IntegerType.prototype.transpileMinus = function(transpiler, value) {
    transpiler.append(" -");
    value.transpile(transpiler);
};

IntegerType.prototype.checkCompare = function(context, other) {
	if(other === IntegerType.instance || other === DecimalType.instance) {
		return BooleanType.instance;
	} else {
		return NativeType.prototype.checkCompare.call(this, context, other);
	}
};



IntegerType.prototype.declareCompare = function(context, other) {
    // nothing to do
};

IntegerType.prototype.transpileCompare = function(transpiler, other, operator, left, right) {
    left.transpile(transpiler);
    transpiler.append(" ").append(operator.toString()).append(" ");
    right.transpile(transpiler);
};



IntegerType.prototype.checkRange = function(context, other) {
	if(other === IntegerType.instance) {
		return new RangeType(this);
	} else {
		return NativeType.prototype.checkRange.call(this, context, other);
	}
};



IntegerType.prototype.declareRange = function(transpiler, other) {
    if(other === IntegerType.instance) {
        var module = __webpack_require__(117);
        transpiler.require(module.Range);
        transpiler.require(module.IntegerRange);
    } else {
        return NativeType.prototype.declareRange.call(this, transpiler, other);
    }
};


IntegerType.prototype.transpileRange = function(transpiler, first, last) {
    transpiler.append("new IntegerRange(");
    first.transpile(transpiler);
    transpiler.append(",");
    last.transpile(transpiler);
    transpiler.append(")");
};


IntegerType.prototype.newRange = function(left, right) {
	if(left instanceof IntegerValue && right instanceof IntegerValue) {
		return new IntegerRange(left, right);
	} else {
		return NativeType.prototype.newRange.call(this, left, right);
	}
};

IntegerType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
	if (typeof(value)=='number') {
		return new IntegerValue(value);
	} else {
		return value; // TODO for now
	}
};

IntegerType.prototype.getMemberMethods = function(context, name) {
    switch (name) {
        case "format":
            return [new FormatMethodDeclaration()];
		default:
            return NativeType.prototype.getMemberMethods.call(context, name);
    }
};

exports.IntegerType = IntegerType;

function FormatMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "format",
        new CategoryArgument(TextType.instance, new Identifier("format")));
    return this;
}

function resolveBuiltInMethodDeclaration() {
    BuiltInMethodDeclaration = __webpack_require__(187).BuiltInMethodDeclaration;

    FormatMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    FormatMethodDeclaration.prototype.constructor = FormatMethodDeclaration;

    FormatMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        var format = context.getValue(new Identifier("format")).getStorableData();
        value = this.format(value, format);
        return new TextValue(value);
    };

    FormatMethodDeclaration.prototype.check = function(context) {
        return TextType.instance;
    };

    FormatMethodDeclaration.prototype.format = function(value, format) {
        // TODO support more than leading 0's
        value = "000000000000" + value;
        return value.substr(value.length - format.length);
    };

    FormatMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("formatInteger(");
        assignments[0].transpile(transpiler);
        transpiler.append(")");
    };
}

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var DecimalValue = __webpack_require__(33).DecimalValue;
var IntegerType = null;
var DivideByZeroError = __webpack_require__(593).DivideByZeroError;

exports.resolve = function() {
    IntegerType = __webpack_require__(2).IntegerType;
};

function IntegerValue(value) {
	Value.call(this, IntegerType.instance);
	this.value = value>0 ? Math.floor(value) : Math.ceil(value);
	return this;
}

IntegerValue.prototype = Object.create(Value.prototype);
IntegerValue.prototype.constructor = IntegerValue;

IntegerValue.Parse = function(text) {
	return new IntegerValue(parseInt(text));
};


IntegerValue.prototype.toString = function() {
	return this.value.toString();
};

IntegerValue.prototype.getStorableData = function() {
    return this.value;
};

IntegerValue.prototype.IntegerValue = function() {
	return this.value;
};

IntegerValue.prototype.DecimalValue = function() {
	return this.value * 1.0;
};

IntegerValue.prototype.Add = function(context, value) {
	if (value instanceof IntegerValue) {
		return new IntegerValue(this.value + value.value);
	} else if (value instanceof DecimalValue) {
		return new DecimalValue(value.DecimalValue() + this.value);
	} else {
		throw new SyntaxError("Illegal: IntegerValue + " + typeof(value));
	}
};

IntegerValue.prototype.Subtract = function(context, value) {
	if (value instanceof IntegerValue) {
		return new IntegerValue(this.value - value.value);
	} else if (value instanceof DecimalValue) {
		return new DecimalValue(this.value - value.DecimalValue());
	} else {
		throw new SyntaxError("Illegal: IntegerValue - " + typeof(value));
	}
};

IntegerValue.prototype.Multiply = function(context, value) {
	if (value instanceof IntegerValue) {
		return new IntegerValue(this.value * value.value);
	} else if (value instanceof DecimalValue) {
		return new DecimalValue(value.value * this.value);
	} else if (value.Multiply) {
		return value.Multiply(context, this);
	} else {
		throw new SyntaxError("Illegal: IntegerValue * " + typeof(value));
	}
};


IntegerValue.prototype.Divide = function(context, value) {
	if (value instanceof IntegerValue || value instanceof DecimalValue) {
		if (value.DecimalValue() == 0.0) {
			throw new DivideByZeroError();
		} else {
			return new DecimalValue(this.DecimalValue() / value.DecimalValue());
		}
	} else {
		throw new SyntaxError("Illegal: IntegerValue / " + typeof(value));
	}
};

IntegerValue.prototype.IntDivide = function(context, value) {
	if (value instanceof IntegerValue) {
		if (value.IntegerValue() == 0) {
			throw new DivideByZeroError();
		} else {
			return new IntegerValue(this.IntegerValue() / value.IntegerValue());
		}
	} else {
		throw new SyntaxError("Illegal: IntegerValue \\ " + typeof(value));
	}
};

IntegerValue.prototype.Modulo = function(context, value) {
	if (value instanceof IntegerValue) {
		if (value.IntegerValue() == 0) {
			throw new DivideByZeroError();
		} else {
			return new IntegerValue(this.IntegerValue() % value.IntegerValue());
		}
	} else {
		throw new SyntaxError("Illegal: IntegerValue \\ " + typeof(value));
	}
};

IntegerValue.prototype.Minus = function(context) {
	return new IntegerValue(-this.value);
};

IntegerValue.prototype.cmp = function(obj) {
	return this.value > obj.IntegerValue() ? 1 : this.value == obj.IntegerValue() ? 0 : -1 ;
};

IntegerValue.prototype.CompareTo = function(context, value) {
	if (value instanceof IntegerValue || value instanceof DecimalValue) {
		return this.value > value.value ? 1 : this.value == value.value ? 0 : -1;
	} else {
		throw new SyntaxError("Illegal comparison: IntegerValue and " + typeof(value));
	}
};


IntegerValue.prototype.equals = function(obj) {
	if (obj instanceof IntegerValue) {
		return this.value == obj.value;
	} else if (obj instanceof DecimalValue) {
		return this.value == obj.value;
	} else {
		return false;
	}
};

IntegerValue.prototype.toJson = function(context, json, instanceId, fieldName, withType, binaries) {
    if(Array.isArray(json))
        json.push(this.value);
    else
        json[fieldName] = this.value;
};

exports.IntegerValue = IntegerValue;


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var Identifier = __webpack_require__(0).Identifier;

function VoidType() {
	NativeType.call(this, new Identifier("Void"));
	return this;
}

VoidType.prototype = Object.create(NativeType.prototype);
VoidType.prototype.constructor = VoidType;

VoidType.prototype.isAssignableFrom = function(context, other) {
    throw new Error("Should never get there!");
};

VoidType.instance = new VoidType();


exports.VoidType = VoidType;


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var Identifier = __webpack_require__(0).Identifier;
var AnyType = __webpack_require__(14).AnyType;
var BooleanValue = null;

exports.resolve = function() {
    BooleanValue = __webpack_require__(20).BooleanValue;
}

function BooleanType()  {
	NativeType.call(this, new Identifier("Boolean"));
	return this;
}

BooleanType.prototype = Object.create(NativeType.prototype);
BooleanType.prototype.constructor = BooleanType;

BooleanType.instance = new BooleanType();

BooleanType.prototype.checkAnd = function(context, other) {
	if(other instanceof BooleanType) {
		return BooleanType.instance;
	} else {
		return NativeType.prototype.checkAnd.call(this, context, other);
	}
};

BooleanType.prototype.checkOr = function(context, other) {
	if(other instanceof BooleanType) {
		return BooleanType.instance;
	} else {
		return NativeType.prototype.checkOr.call(this, context, other);
	}
};

BooleanType.prototype.checkNot = function(context) {
	return BooleanType.instance;
};


BooleanType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
	if (typeof(value)=='boolean') {
		return BooleanValue.ValueOf(value);
	} else {
		return value; // TODO for now
	}
};

BooleanType.prototype.declare = function(transpiler) {
    var isABoolean = __webpack_require__(16).isABoolean;
    transpiler.require(isABoolean);
};


BooleanType.prototype.transpile = function(transpiler) {
    transpiler.append('"Boolean"');
};

BooleanType.prototype.transpileSorted = function(transpiler, desc, key) {
    if(desc)
        transpiler.append("function(o1, o2) { return o1 === o2 ? 0 : o1 > o2 ? -1 : 1; }");
    else
        transpiler.append("function(o1, o2) { return o1 === o2 ? 0 : o1 > o2 ? 1 : -1; }");
};


exports.BooleanType = BooleanType;

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

var BuiltInMethodDeclaration = null;
var NativeType = __webpack_require__(12).NativeType;
var Identifier = __webpack_require__(0).Identifier;
var CharacterType = null;
var ListType = null;
var IntegerType = __webpack_require__(2).IntegerType;
var BooleanType = __webpack_require__(5).BooleanType;
var AnyType = __webpack_require__(14).AnyType;
var Identifier = __webpack_require__(0).Identifier;
var TextValue = null; // circular dependency
var IntegerValue = __webpack_require__(3).IntegerValue;
var BooleanValue = __webpack_require__(20).BooleanValue;
var CategoryArgument = __webpack_require__(95).CategoryArgument;
var TextLiteral = null;
var ListValue = null;
var List = __webpack_require__(29).List;
var TypeFamily = __webpack_require__(146).TypeFamily;

exports.resolve = function() {
	CharacterType = __webpack_require__(31).CharacterType;
    ListType = __webpack_require__(26).ListType;
    TextLiteral = __webpack_require__(74).TextLiteral;
    ListValue = __webpack_require__(36).ListValue;
	TextValue = __webpack_require__(17).TextValue;
    resolveBuiltInMethodDeclaration();
}

function TextType()  {
	NativeType.call(this, new Identifier("Text"));
	this.family = TypeFamily.TEXT;
	return this;
}

TextType.prototype = Object.create(NativeType.prototype);
TextType.prototype.constructor = TextType;

TextType.instance = new TextType();

TextType.prototype.isAssignableFrom = function(context, other) {
	return NativeType.prototype.isAssignableFrom.call(this, context, other)
        || (other == CharacterType.instance);
};

TextType.prototype.declare = function(transpiler) {
    var isAText = __webpack_require__(16).isAText;
    transpiler.require(isAText);
};



TextType.prototype.transpile = function(transpiler) {
    transpiler.append('"Text"');
};



TextType.prototype.checkAdd = function(context, other, tryReverse) {
	// can add anything to text
	return this;
};


TextType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    left.declare(transpiler);
    right.declare(transpiler);
};


TextType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    var DecimalType = __webpack_require__(23).DecimalType;
    // can add anything to text
    left.transpile(transpiler);
    transpiler.append(" + ");
    right.transpile(transpiler);
    if(other === DecimalType.instance)
        transpiler.append(".toDecimalString()");
};

TextType.prototype.checkMultiply = function(context, other, tryReverse) {
	if(other instanceof IntegerType) {
		return TextType.instance;
	}
	return NativeType.prototype.checkMultiply.call(this, context, other, tryReverse);
};


TextType.prototype.declareMultiply = function(transpiler, other, tryReverse, left, right) {
    if (other === IntegerType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareMultiply.call(this, transpiler, other, tryReverse, left, right);
};


TextType.prototype.transpileMultiply = function(transpiler, other, tryReverse, left, right) {
    if (other === IntegerType.instance) {
        left.transpile(transpiler);
        transpiler.append(".repeat(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileMultiply.call(this, transpiler, other, tryReverse, left, right);
};



TextType.prototype.checkCompare = function(context, other) {
	if(other instanceof TextType || other instanceof CharacterType) {
		return BooleanType.instance;
	}
	return NativeType.prototype.checkCompare.call(this, context, other);
};


TextType.prototype.declareCompare = function(context, other) {
    // nothing to do
};


TextType.prototype.transpileCompare = function(transpiler, other, operator, left, right) {
    left.transpile(transpiler);
    transpiler.append(" ").append(operator.toString()).append(" ");
    right.transpile(transpiler);
};


TextType.prototype.checkItem = function(context, other) {
	if(other==IntegerType.instance) {
		return CharacterType.instance;
	} else {
		return NativeType.prototype.checkItem.call(this, context, other);
	}
};

TextType.prototype.declareItem = function(transpiler, itemType, item) {
    // nothing to do
};


TextType.prototype.transpileItem = function(transpiler, itemType, item) {
    transpiler.append("[");
    item.transpile(transpiler);
    transpiler.append("-1]");
};


TextType.prototype.checkMember = function(context, section, name) {
   if ("count"==name) {
	   return IntegerType.instance;
   } else {
	   return NativeType.prototype.checkMember.call(this, context, section, name);
   }
};


TextType.prototype.declareMember = function(transpiler, name) {
    if ("count"!==name) {
        NativeType.prototype.declareMember.call(this, transpiler, name);
    }
};


TextType.prototype.transpileMember = function(transpiler, name) {
    if ("count"==name) {
        transpiler.append("length");
    } else {
        NativeType.prototype.transpileMember.call(this, transpiler, name);
    }
};

TextType.prototype.checkContains = function(context, other) {
	if(other instanceof TextType || other instanceof CharacterType) {
		return BooleanType.instance;
	}
	return NativeType.prototype.checkContains.call(this, context, other);
};


TextType.prototype.declareContains = function(transpiler, other, container, item) {
    container.declare(transpiler);
    item.declare(transpiler);
};


TextType.prototype.transpileContains = function(transpiler, other, container, item) {
    container.transpile(transpiler);
    transpiler.append(".includes(");
    item.transpile(transpiler);
    transpiler.append(")");
};


TextType.prototype.checkContainsAllOrAny = function(context, other) {
	return BooleanType.instance;
};


TextType.prototype.declareContainsAllOrAny = function(transpiler, other, container, items) {
    container.declare(transpiler);
    items.declare(transpiler);
};


TextType.prototype.transpileContainsAll = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAll(");
    items.transpile(transpiler);
    transpiler.append(")");
};


TextType.prototype.transpileContainsAny = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAny(");
    items.transpile(transpiler);
    transpiler.append(")");
};


TextType.prototype.checkSlice = function(context) {
	return this;
};


TextType.prototype.declareSlice = function(transpiler, first, last) {
    if(first) {
        first.declare(transpiler);
    }
    if(last) {
        last.declare(transpiler);
    }
};


TextType.prototype.transpileSlice = function(transpiler, first, last) {
    transpiler.append(".slice1Based(");
    if(first) {
        first.transpile(transpiler);
    } else
        transpiler.append("null");
    if(last) {
        transpiler.append(",");
        last.transpile(transpiler);
    }
    transpiler.append(")");
};

TextType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
	if (typeof(value) == 'string') {
		return new TextValue(value);
	} else {
		return value; // TODO for now
	}
}

TextType.prototype.getMemberMethods = function(context, name) {
    switch (name) {
        case "startsWith":
            return [new StartsWithMethodDeclaration()];
        case "endsWith":
            return [new EndsWithMethodDeclaration()];
        case "toLowerCase":
            return [new ToLowerCaseMethodDeclaration()];
        case "toUpperCase":
            return [new ToUpperCaseMethodDeclaration()];
        case "toCapitalized":
            return [new ToCapitalizedMethodDeclaration()];
        case "trim":
            return [new TrimMethodDeclaration()];
        case "replace":
            return [new ReplaceMethodDeclaration()];
        case "replaceAll":
            return [new ReplaceAllMethodDeclaration()];
        case "split":
            return [new SplitMethodDeclaration()];
        case "indexOf":
            return [new IndexOfMethodDeclaration()];
        default:
            return NativeType.prototype.getMemberMethods.call(context, name);
    }
};

function ToLowerCaseMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "toLowerCase");
    return this;
}

function ToUpperCaseMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "toUpperCase");
    return this;
}

function TrimMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "trim");
    return this;
}

function ToCapitalizedMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "toCapitalized");
    return this;
}

function SplitMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "split", new CategoryArgument(TextType.instance, new Identifier("separator"), new TextLiteral('" "')));
    return this;
}

function StartsWithMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "startsWith", new CategoryArgument(TextType.instance, new Identifier("value")));
    return this;
}

function EndsWithMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "endsWith", new CategoryArgument(TextType.instance, new Identifier("value")));
    return this;
}

function ReplaceMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "replace",
        new CategoryArgument(TextType.instance, new Identifier("toReplace")),
        new CategoryArgument(TextType.instance, new Identifier("replaceWith")));
    return this;
}

function ReplaceAllMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "replaceAll",
        new CategoryArgument(TextType.instance, new Identifier("toReplace")),
        new CategoryArgument(TextType.instance, new Identifier("replaceWith")));
    return this;
}

function IndexOfMethodDeclaration() {
    BuiltInMethodDeclaration.call(this, "indexOf", new CategoryArgument(TextType.instance, new Identifier("value")));
    return this;
}

function resolveBuiltInMethodDeclaration() {
    BuiltInMethodDeclaration = __webpack_require__(187).BuiltInMethodDeclaration;

    ToLowerCaseMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    ToLowerCaseMethodDeclaration.prototype.constructor = ToLowerCaseMethodDeclaration;

    ToLowerCaseMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        return new TextValue(value.toLowerCase());
    };

    ToLowerCaseMethodDeclaration.prototype.check = function(context) {
        return TextType.instance;
    };

    ToLowerCaseMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("toLowerCase()");
    };

    ToUpperCaseMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    ToUpperCaseMethodDeclaration.prototype.constructor = ToUpperCaseMethodDeclaration;

    ToUpperCaseMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        return new TextValue(value.toUpperCase());
    };

    ToUpperCaseMethodDeclaration.prototype.check = function(context) {
        return TextType.instance;
    };

    ToUpperCaseMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("toUpperCase()");
    };

    ToCapitalizedMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    ToCapitalizedMethodDeclaration.prototype.constructor = ToCapitalizedMethodDeclaration;

    ToCapitalizedMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        value = value.replace( /(^|\s)([a-z])/g , function(m, p1, p2){ return p1 + p2.toUpperCase(); } );
        return new TextValue(value);
    };

    ToCapitalizedMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("replace( /(^|\\s)([a-z])/g , function(m, p1, p2){ return p1 + p2.toUpperCase(); } )");
    };

    ToCapitalizedMethodDeclaration.prototype.check = function(context) {
        return TextType.instance;
    };

    TrimMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    TrimMethodDeclaration.prototype.constructor = TrimMethodDeclaration;

    TrimMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        value = value.trim();
        return new TextValue(value);
    };

    TrimMethodDeclaration.prototype.check = function(context) {
        return TextType.instance;
    };

    TrimMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("trim()");
    };


    ReplaceMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    ReplaceMethodDeclaration.prototype.constructor = ReplaceMethodDeclaration;

    ReplaceMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        var toReplace = context.getValue(new Identifier("toReplace")).getStorableData();
        var replaceWith = context.getValue(new Identifier("replaceWith")).getStorableData();
        value = value.replace(toReplace, replaceWith);
        return new TextValue(value);
    };

    ReplaceMethodDeclaration.prototype.check = function(context) {
        return TextType.instance;
    };

    ReplaceMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("replace(");
        assignments.find("toReplace").transpile(transpiler);
        transpiler.append(",");
        assignments.find("replaceWith").transpile(transpiler);
        transpiler.append(")");
    };


    ReplaceAllMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    ReplaceAllMethodDeclaration.prototype.constructor = ReplaceAllMethodDeclaration;

    ReplaceAllMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        var toReplace = context.getValue(new Identifier("toReplace")).getStorableData();
        var replaceWith = context.getValue(new Identifier("replaceWith")).getStorableData();
        value = value.replace(new RegExp(toReplace, 'g'), replaceWith);
        return new TextValue(value);
    };

    ReplaceAllMethodDeclaration.prototype.check = function(context) {
        return TextType.instance;
    };

    ReplaceAllMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("replace(new RegExp(");
        assignments.find("toReplace").transpile(transpiler);
        transpiler.append(", 'g'),");
        assignments.find("replaceWith").transpile(transpiler);
        transpiler.append(")");
    };


    SplitMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    SplitMethodDeclaration.prototype.constructor = SplitMethodDeclaration;

    SplitMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        var sep = context.getValue(new Identifier("separator")).getStorableData();
        var list = value.split(sep);
        var texts = list.map(function(s) { return new TextValue(s); });
        return new ListValue(TextType.instance, texts);
    };

    SplitMethodDeclaration.prototype.check = function(context) {
        return new ListType(TextType.instance);
    };

    SplitMethodDeclaration.prototype.declareCall = function(transpiler) {
        transpiler.require(List);
    };

    SplitMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("splitToList(");
        if(assignments)
            assignments[0].transpile(transpiler);
        else
            transpiler.append("' '"); // default
        transpiler.append(")");
    };


    StartsWithMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    StartsWithMethodDeclaration.prototype.constructor = StartsWithMethodDeclaration;

    StartsWithMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        var find = context.getValue(new Identifier("value")).getStorableData();
        var startsWith = value.indexOf(find)===0;
        return BooleanValue.ValueOf(startsWith);
    };

    StartsWithMethodDeclaration.prototype.check = function(context) {
        return BooleanType.instance;
    };

    StartsWithMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("startsWith(");
        assignments[0].transpile(transpiler);
        transpiler.append(")");
    };

    EndsWithMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    EndsWithMethodDeclaration.prototype.constructor = EndsWithMethodDeclaration;

    EndsWithMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        var find = context.getValue(new Identifier("value")).getStorableData();
        var endsWith = value.indexOf(find)===value.length-find.length;
        return BooleanValue.ValueOf(endsWith);
    };

    EndsWithMethodDeclaration.prototype.check = function(context) {
        return BooleanType.instance;
    };

    EndsWithMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("endsWith(");
        assignments[0].transpile(transpiler);
        transpiler.append(")");
    };

    IndexOfMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
    IndexOfMethodDeclaration.prototype.constructor = IndexOfMethodDeclaration;

    IndexOfMethodDeclaration.prototype.interpret = function(context) {
        var value = this.getValue(context).getStorableData();
        var find = context.getValue(new Identifier("value")).getStorableData();
        var index = value.indexOf(find);
        return new IntegerValue(index + 1);
    };

    IndexOfMethodDeclaration.prototype.check = function(context) {
        return IntegerType.instance;
    };

    IndexOfMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
        transpiler.append("indexOf1Based(");
        assignments[0].transpile(transpiler);
        transpiler.append(")");
    };
}

exports.TextType = TextType;


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

var UnresolvedIdentifier = __webpack_require__(27).UnresolvedIdentifier;
var Identifier = __webpack_require__(0).Identifier;
var ArgumentAssignmentList = null;
var ArgumentAssignment = null;
var CategoryDeclaration = null;
var ConcreteCategoryDeclaration = null;
var SingletonCategoryDeclaration = null;
var EnumeratedNativeDeclaration = null;
var EnumeratedCategoryDeclaration = null;
var ExpressionValue = __webpack_require__(76).ExpressionValue;
var Operator = __webpack_require__(226).Operator;
var BaseType = __webpack_require__(47).BaseType;
var NullType = __webpack_require__(113).NullType;
var TextType = __webpack_require__(6).TextType;
var AnyType = __webpack_require__(14).AnyType;
var MissingType = __webpack_require__(56).MissingType;
var MethodType = __webpack_require__(38).MethodType;
var PromptoError = __webpack_require__(30).PromptoError;
var SyntaxError = __webpack_require__(32).SyntaxError;
var MethodCall = __webpack_require__(62).MethodCall;
var MethodSelector = __webpack_require__(53).MethodSelector;
var MethodFinder = __webpack_require__(181).MethodFinder;
var DataStore = __webpack_require__(50).DataStore;
var InstanceExpression = __webpack_require__(41).InstanceExpression;
var Score = __webpack_require__(249).Score;
var compareValues = __webpack_require__(16).compareValues;

exports.resolve = function() {
	ArgumentAssignmentList = __webpack_require__(39).ArgumentAssignmentList;
	ArgumentAssignment = __webpack_require__(40).ArgumentAssignment;
    CategoryDeclaration = __webpack_require__(45).CategoryDeclaration;
    ConcreteCategoryDeclaration = __webpack_require__(52).ConcreteCategoryDeclaration;
    SingletonCategoryDeclaration = __webpack_require__(205).SingletonCategoryDeclaration;
    EnumeratedNativeDeclaration = __webpack_require__(77).EnumeratedNativeDeclaration;
    EnumeratedCategoryDeclaration = __webpack_require__(92).EnumeratedCategoryDeclaration;
};


function CategoryType(id) {
	BaseType.call(this, id);
    this.mutable = false;
	return this;
}

CategoryType.prototype = Object.create(BaseType.prototype);
CategoryType.prototype.constructor =  CategoryType;

CategoryType.prototype.toDialect = function(writer) {
    if (this.mutable)
        writer.append("mutable ");
    writer.append(this.name);
};


CategoryType.prototype.declare = function(transpiler) {
    if(this.name==="Any") {
        var Any = __webpack_require__(140).Any;
        transpiler.require(Any);
    } else  {
        var decl = this.getDeclaration(transpiler.context);
        decl.declare(transpiler);
    }
};

CategoryType.prototype.transpile = function(transpiler) {
    transpiler.append(this.name);
};


CategoryType.prototype.transpileInstance = function(transpiler) {
    var decl = this.getDeclaration(transpiler.context);
    if(decl instanceof SingletonCategoryDeclaration)
        transpiler.append(this.name).append(".instance");
    else
        transpiler.append("this");
};

CategoryType.prototype.newInstanceFromStored = function(context, stored) {
    var decl = this.getDeclaration(context);
    var inst = decl.newInstanceFromStored(context, stored);
    inst.mutable = this.mutable;
    return inst;
};

CategoryType.prototype.equals = function(obj) {
	if(obj===this) {
		return true;
	}
	if(obj===null) {
		return false;
	}
	if(!(obj instanceof CategoryType)) {
		return false;
	}
	return this.name===obj.name;
};

CategoryType.prototype.checkUnique = function(context) {
	var actual = context.getRegisteredDeclaration(this.name) || null;
	if(actual!=null) {
		throw new SyntaxError("Duplicate name: \"" + this.name + "\"");
	}
};

CategoryType.prototype.getDeclaration = function(context) {
	var decl = context.getRegisteredDeclaration(this.name) || null;
	if(decl==null) {
        if(context.problemListener)
            context.problemListener.reportUnknownCategory(this.id);
        else
		    throw new SyntaxError("Unknown category: \"" + this.name + "\"");
	}
	return decl;
};


CategoryType.prototype.checkMultiply = function(context, other, tryReverse) {
    var type = this.checkOperator(context, other, tryReverse, Operator.MULTIPLY);
    if(type!=null)
        return type;
    else
        return BaseType.prototype.checkMultiply.call(this, context, other, tryReverse);
}


CategoryType.prototype.declareMultiply = function(transpiler, other, tryReverse, left, right) {
    var type = this.checkOperator(transpiler.context, other, tryReverse, Operator.MULTIPLY);
    if(type!=null) {
        left.declare(transpiler);
        right.declare(transpiler);
        type.declare(transpiler);
    } else
        return NativeType.prototype.declareMultiply.call(this, transpiler, other, tryReverse, left, right);
};


CategoryType.prototype.transpileMultiply = function(transpiler, other, tryReverse, left, right) {
    var type = this.checkOperator(transpiler.context, other, tryReverse, Operator.MULTIPLY);
    if(type!=null) {
        left.transpile(transpiler);
        transpiler.append(".operator_MULTIPLY").append("$").append(other.getTranspiledName(transpiler.context)).append("(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileMultiply.call(this, context, other, tryReverse, left, right);

};


CategoryType.prototype.checkDivide = function(context, other) {
    var type = this.checkOperator(context, other, false, Operator.DIVIDE);
    if(type!=null)
        return type;
    else
        return BaseType.prototype.checkDivide.call(this, context, other);
}


CategoryType.prototype.declareDivide = function(transpiler, other, left, right) {
    var type = this.checkOperator(transpiler.context, other, false, Operator.DIVIDE);
    if(type!=null) {
        left.declare(transpiler);
        right.declare(transpiler);
        type.declare(transpiler);
    } else
        return NativeType.prototype.declareDivide.call(this, context, other, left, right);
};


CategoryType.prototype.transpileDivide = function(transpiler, other, left, right) {
    left.transpile(transpiler);
    transpiler.append(".operator_DIVIDE").append("$").append(other.getTranspiledName(transpiler.context)).append("(");
    right.transpile(transpiler);
    transpiler.append(")");
};



CategoryType.prototype.checkIntDivide = function(context, other) {
    var type = this.checkOperator(context, other, false, Operator.IDIVIDE);
    if(type!=null)
        return type;
    else
        return BaseType.prototype.checkIntDivide.call(this, context, other);
}

CategoryType.prototype.declareIntDivide = function(transpiler, other, left, right) {
    var type = this.checkOperator(transpiler.context, other, false, Operator.IDIVIDE);
    if(type!=null) {
        left.declare(transpiler);
        right.declare(transpiler);
        type.declare(transpiler);
    } else
        return NativeType.prototype.declareDivide.call(this, context, other, left, right);
};


CategoryType.prototype.transpileIntDivide = function(transpiler, other, left, right) {
    left.transpile(transpiler);
    transpiler.append(".operator_IDIVIDE").append("$").append(other.getTranspiledName(transpiler.context)).append("(");
    right.transpile(transpiler);
    transpiler.append(")");
};


CategoryType.prototype.checkModulo = function(context, other) {
    var type = this.checkOperator(context, other, false, Operator.MODULO);
    if(type!=null)
        return type;
    else
        return BaseType.prototype.checkModulo.call(this, context, other);
}


CategoryType.prototype.declareModulo = function(transpiler, other, left, right) {
    var type = this.checkOperator(transpiler.context, other, false, Operator.MODULO);
    if(type!=null) {
        left.declare(transpiler);
        right.declare(transpiler);
        type.declare(transpiler);
    } else
        return NativeType.prototype.declareModulo.call(this, context, other, left, right);
};


CategoryType.prototype.transpileModulo = function(transpiler, other, left, right) {
    left.transpile(transpiler);
    transpiler.append(".operator_MODULO").append("$").append(other.getTranspiledName(transpiler.context)).append("(");
    right.transpile(transpiler);
    transpiler.append(")");
};


CategoryType.prototype.checkAdd = function(context, other, tryReverse) {
    var type = this.checkOperator(context, other, tryReverse, Operator.PLUS);
    if(type!=null)
        return type;
    else
        return BaseType.prototype.checkAdd.call(this, context, other, tryReverse);
}


CategoryType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    var type = this.checkOperator(transpiler.context, other, tryReverse, Operator.PLUS);
    if(type!=null) {
        left.declare(transpiler);
        right.declare(transpiler);
        type.declare(transpiler);
    } else
        return BaseType.prototype.declareAdd.call(this, transpiler, other, tryReverse, left, right);
};

CategoryType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    left.transpile(transpiler);
    transpiler.append(".operator_PLUS").append("$").append(other.getTranspiledName(transpiler.context)).append("(");
    right.transpile(transpiler);
    transpiler.append(")");
};


CategoryType.prototype.checkSubtract = function(context, other) {
    var type = this.checkOperator(context, other, false, Operator.MINUS);
    if(type!=null)
        return type;
    else
        return BaseType.prototype.checkSubtract.call(this, context, other);
}


CategoryType.prototype.declareSubtract = function(transpiler, other, left, right) {
    var type = this.checkOperator(transpiler.context, other, false, Operator.MINUS);
    if(type!=null) {
        left.declare(transpiler);
        right.declare(transpiler);
        type.declare(transpiler);
    } else
        return NativeType.prototype.declareDivide.call(this, context, other, left, right);
};


CategoryType.prototype.transpileSubtract = function(transpiler, other, left, right) {
    left.transpile(transpiler);
    transpiler.append(".operator_MINUS").append("$").append(other.getTranspiledName(transpiler.context)).append("(");
    right.transpile(transpiler);
    transpiler.append(")");
};



CategoryType.prototype.checkOperator = function(context, other, tryReverse, operator) {
    var actual = this.getDeclaration(context);
    if(actual instanceof ConcreteCategoryDeclaration) try {
        var method = actual.getOperatorMethod(context, operator, other);
        if(method==null)
            return null;
        context = context.newInstanceContext(null, this);
        var local = context.newLocalContext();
        method.registerArguments(local);
        return method.check(local);
    } catch(e) {
        // ok to pass, will try reverse
    }
    if(tryReverse)
        return null;
    else
        throw new SyntaxError("Unsupported operation: " + this.name + " " + operator.token + " " + other.name);
};



CategoryType.prototype.checkExists = function(context) {
	this.getDeclaration(context);
};

CategoryType.prototype.checkMember = function(context, section, name) {
    var cd = context.getRegisteredDeclaration(this.name);
    if (cd == null) {
        throw new SyntaxError("Unknown category:" + this.name);
    }
    if (cd instanceof EnumeratedNativeDeclaration) {
        cd.getType(context).checkMember(context, section, name);
    } else if (cd instanceof CategoryDeclaration) {
        if(cd.storable && "dbId" === name.toString())
            return AnyType.instance;
        else if (cd.hasAttribute(context, name)) {
            var ad = context.getRegisteredDeclaration(name);
            if (ad == null) {
                throw new SyntaxError("Unknown attribute:" + name);
            }
            return ad.getType(context);
        } else if ("text" == name.toString()) {
            return TextType.instance
        } else if (cd.hasMethod(context, name)) {
            var method = cd.getMemberMethodsMap(context, name).getFirst();
            return new MethodType(method);
        } else {
            context.problemListener.reportUnknownAttribute(section);
        }
	} else {
        throw new SyntaxError("Not a category:" + this.name);
    }
};

CategoryType.prototype.declareMember = function(transpiler, name) {
    // TODO visit attributes
};


CategoryType.prototype.transpileMember = function(transpiler, name) {
    if ("text" == name)
        transpiler.append("getText()");
    else
        transpiler.append(name);
};

CategoryType.prototype.isAssignableFrom = function(context, other) {
    return BaseType.prototype.isAssignableFrom.call(this, context, other)
        || ((other instanceof CategoryType) && this.isAssignableFromCategory(context, other));
};



CategoryType.prototype.isAssignableFromCategory = function(context, other) {
    return "Any"===this.name
            || other.isDerivedFrom(context, this)
            || other.isDerivedFromAnonymous(context, this);
};



CategoryType.prototype.isDerivedFrom = function(context, other) {
    try {
        var thisDecl = this.getDeclaration(context);
        if (thisDecl instanceof CategoryDeclaration)
            return this.isDerivedFromCategory(context, thisDecl, other);
    } catch (e) {
    }
    return false; // TODO
};



CategoryType.prototype.isDerivedFromCategory = function(context, decl, other) {
    if(decl.derivedFrom==null) {
        return false;
    }
    for(var i=0;i<decl.derivedFrom.length; i++) {
        var ct = new CategoryType(decl.derivedFrom[i]);
        if (ct.equals(other) || ct.isDerivedFrom(context, other)) {
            return true;
        }
    }
    return false;
};


CategoryType.prototype.isDerivedFromAnonymous = function(context, other) {
    if (!(other instanceof CategoryType) || !other.isAnonymous())
        return false;
    try {
        var thisDecl = this.getDeclaration(context);
        if (thisDecl instanceof CategoryDeclaration) {
            var otherDecl = other.getDeclaration(context);
            if (otherDecl instanceof CategoryDeclaration)
                return this.isDerivedFromAnonymousCategory(context, thisDecl, otherDecl);
        }
    } catch (e) {
        if (e instanceof SyntaxError) {
            return false;
        } else {
            throw e;
        }
    }
};

CategoryType.prototype.isDerivedFromAnonymousCategory = function(context, thisDecl, otherDecl) {
    // an anonymous category extends 1 and only 1 category
    var baseId = otherDecl.derivedFrom[0];
    // check we derive from root category (if not extending 'Any')
    if("any"!=baseId.name && !thisDecl.isDerivedFrom(context,new CategoryType(baseId)))
        return false;
    var allAttributes = otherDecl.getAllAttributes(context);
    for(var attr of allAttributes) {
        if(!thisDecl.hasAttribute(context, attr.name)) {
            return false;
        }
    }
    return true;
};

CategoryType.prototype.isAnonymous = function() {
	return this.name[0]==this.name[0].toLowerCase(); // since it's the name of the argument
}

CategoryType.prototype.isMoreSpecificThan = function(context, other) {
    if(other instanceof NullType || other instanceof AnyType || other instanceof MissingType)
        return true;
	if(!(other instanceof CategoryType)) {
		return false;
	}
	if(other.isAnonymous()) {
		return true;
	}
	var thisDecl = context.getRegisteredDeclaration(this.name);
	if(thisDecl.isDerivedFrom(context, other)) {
		return true;
	} else {
		return false;
	}
};

CategoryType.prototype.scoreMostSpecific = function(context, t1, t2) {
	if(t1.equals(t2)) {
		return Score.SIMILAR;
	} else if(this.equals(t1)) {
		return Score.BETTER;
	} else  if(this.equals(t2)) {
		return Score.WORSE;
	}
	// since this derives from both t1 and t2, return the most specific of t1 and t2
	if(t1.isMoreSpecificThan(context,t2)) {
		return Score.BETTER;
	} else if(t2.isMoreSpecificThan(context,t1)) {
		return Score.WORSE;
	} else {
		return Score.SIMILAR;
	} // should never happen
};


CategoryType.prototype.newInstance = function(context) {
	var decl = context.getRegisteredDeclaration(this.name);
	return decl.newInstance(context);
};


CategoryType.prototype.sort = function(context, list, desc, key) {
	if (list.size() <= 1) {
		return list;
	}
	key = key || null;
	if (key == null) {
		key = new UnresolvedIdentifier(new Identifier("key"));
	}
	var keyname = key.toString();
	var decl = this.getDeclaration(context);
	if (decl.hasAttribute(context, keyname)) {
		return this.sortByAttribute(context, list, desc, keyname);
	} else if (decl.hasMethod(context, keyname)) {
		return this.sortByMemberMethod(context, list, desc, keyname);
	} else {
		var method = this.findGlobalMethod(context, keyname);
		if(method!=null) {
			return this.sortByGlobalMethod(context, list, desc, method);
		} else {
			return this.sortByExpression(context, list, desc, key);
		}
	}
};

CategoryType.prototype.sortByExpression = function(context, list, desc, key) {

	function cmp(o1, o2) {
		var co = context.newInstanceContext(o1, null);
		var value1 = key.interpret(co);
		co = context.newInstanceContext(o2, null);
		var value2 = key.interpret(co);
		return compareValues(value1, value2);
	}
	return BaseType.prototype.doSort(context, list, cmp, desc);
};

CategoryType.prototype.sortByAttribute = function(context, list, desc, name) {

	function cmp(o1, o2) {
		var value1 = o1.getMemberValue(context, name);
		var value2 = o2.getMemberValue(context, name);
		return compareValues(value1, value2);
	}

	return BaseType.prototype.doSort(context, list, cmp, desc);
};



CategoryType.prototype.getMemberMethods = function(context, name) {
    var cd = this.getDeclaration(context);
    if (!(cd instanceof ConcreteCategoryDeclaration))
        throw new SyntaxError("Unknown category:" + this.name);
    else {
        var methods = cd.getMemberMethodsMap(context, name);
        return methods.getAll();
    }
};



/* look for a method which takes this category as sole parameter */
CategoryType.prototype.findGlobalMethod = function(context, name, returnDecl) {
	try {
		var exp = new ExpressionValue(this, this.newInstance(context));
		var arg = new ArgumentAssignment(null, exp);
		var args = new ArgumentAssignmentList([arg]);
		var call = new MethodCall(new MethodSelector(null, new Identifier(name)), args);
		var finder = new MethodFinder(context, call);
		var decl = finder.findMethod(true);
		return decl==null ? null : returnDecl ? decl : call;
	} catch (e) {
		if(e instanceof PromptoError) {
			return null;
		} else {
			throw e;
		}
	}
};

CategoryType.prototype.sortByGlobalMethod = function(context, list, desc, method) {
	var self = this;
	function cmp(o1, o2) {
		var assignment = method.assignments[0];
		assignment._expression = new ExpressionValue(self, o1);
		var value1 = method.interpret(context);
		assignment._expression = new ExpressionValue(self, o2);
		var value2 = method.interpret(context);
		return compareValues(value1, value2);
	}

	return BaseType.prototype.doSort(context, list, cmp, desc);
};


CategoryType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
    var decl = this.getDeclaration(context)
    if (decl == null)
        return BaseType.prototype.convertPythonValueToPromptoValue(context, value, returnType);
    if(decl instanceof EnumeratedNativeDeclaration || decl instanceof EnumeratedCategoryDeclaration)
        return this.loadEnumValue(context, decl, value);
    if (DataStore.instance.isDbIdType(typeof(value)))
        value = DataStore.instance.fetchUnique(value);
    return decl.newInstanceFromStored(context, value);
};


CategoryType.prototype.loadEnumValue = function(context, value, name) {
    return context.getRegisteredValue(name);
};


CategoryType.prototype.declareSorted = function(transpiler, key) {
    var keyname = key ? key.toString() : "key";
    var decl = this.getDeclaration(transpiler.context);
    if (decl.hasAttribute(transpiler.context, keyname) || decl.hasMethod(transpiler.context, keyname, null)) {
        return;
    } else {
        var decl = this.findGlobalMethod(transpiler.context, keyname, true);
        if (decl != null) {
            decl.declare(transpiler);
        } else {
            key.declare(transpiler);
        }
    }
};

CategoryType.prototype.transpileSorted = function(transpiler, desc, key) {
    var keyname = key ? key.toString() : "key";
    var decl = this.getDeclaration(transpiler.context);
    if (decl.hasAttribute(transpiler.context, keyname)) {
        this.transpileSortedByAttribute(transpiler, desc, key);
    } else if (decl.hasMethod(transpiler.context, keyname, null)) {
        this.transpileSortedByClassMethod(transpiler, desc, key);
    } else {
        decl = this.findGlobalMethod(transpiler.context, keyname, true);
        if (decl != null) {
            this.transpileSortedByGlobalMethod(transpiler, desc, decl.getTranspiledName(transpiler.context));
        } else {
            this.transpileSortedByExpression(transpiler, desc, key);
        }
    }
};


CategoryType.prototype.transpileSortedByExpression = function(transpiler, desc, key) {
    this.transpileSortedByAttribute(transpiler, desc, key);
};


CategoryType.prototype.transpileSortedByAttribute = function(transpiler, desc, key) {
    key = key || new InstanceExpression(new Identifier("key"));
    transpiler.append("function(o1, o2) { return ");
    this.transpileEqualKeys(transpiler, key);
    transpiler.append(" ? 0 : ");
    this.transpileGreaterKeys(transpiler, key);
    transpiler.append(" ? ");
    if(desc)
        transpiler.append("-1 : 1; }");
    else
        transpiler.append("1 : -1; }");
};


CategoryType.prototype.transpileEqualKeys = function(transpiler, key) {
    transpiler.append("o1.");
    key.transpile(transpiler);
    transpiler.append(" === o2.");
    key.transpile(transpiler);
};


CategoryType.prototype.transpileGreaterKeys = function(transpiler, key) {
    transpiler.append("o1.");
    key.transpile(transpiler);
    transpiler.append(" > o2.");
    key.transpile(transpiler);
};


CategoryType.prototype.transpileSortedByGlobalMethod = function(transpiler, desc, name) {
    transpiler.append("function(o1, o2) { return ")
        .append(name).append("(o1) === ").append(name).append("(o2)").append(" ? 0 : ")
        .append(name).append("(o1) > ").append(name).append("(o2)").append(" ? ");
    if(desc)
        transpiler.append("-1 : 1; }");
    else
        transpiler.append("1 : -1; }");
};

CategoryType.prototype.transpileAssignMemberValue = function(transpiler, name, expression) {
    transpiler.append(".setMember('").append(name).append("', ");
    expression.transpile(transpiler);
    transpiler.append(")");
};


exports.CategoryType = CategoryType;

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

var EParserFactory = null;
var OParserFactory = null;
var MParserFactory = null;

exports.resolve = function() {
    EParserFactory = __webpack_require__(359).EParserFactory;
    OParserFactory = __webpack_require__(590).OParserFactory;
    MParserFactory = __webpack_require__(591).MParserFactory;
}

function Dialect() {
	return this;
}

Dialect.E = new Dialect();
Dialect.E.getParserFactory = function() {
	return new EParserFactory();
};
Dialect.E.toDialect = function(w, o) {
    o.toEDialect(w);
};
Dialect.E.toString = function(o) {
    return o.toEString();
};


Dialect.O = new Dialect();
Dialect.O.getParserFactory = function() {
	return new OParserFactory();
};
Dialect.O.toDialect = function(w, o) {
    o.toODialect(w);
};
Dialect.O.toString = function(o) {
    return o.toOString();
};

Dialect.M = new Dialect();
Dialect.M.getParserFactory = function() {
    return new MParserFactory();
};
Dialect.M.toDialect = function(w, o) {
    o.toMDialect(w);
};
Dialect.M.toString = function(o) {
    return o.toMString();
};

exports.Dialect = Dialect;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
exports.atn = __webpack_require__(340);
exports.codepointat = __webpack_require__(244);
exports.dfa = __webpack_require__(347);
exports.fromcodepoint = __webpack_require__(245);
exports.tree = __webpack_require__(349);
exports.error = __webpack_require__(350);
exports.Token = __webpack_require__(18).Token;
exports.CharStreams = __webpack_require__(352).CharStreams;
exports.CommonToken = __webpack_require__(18).CommonToken;
exports.InputStream = __webpack_require__(178).InputStream;
exports.FileStream = __webpack_require__(353).FileStream;
exports.CommonTokenStream = __webpack_require__(354).CommonTokenStream;
exports.Lexer = __webpack_require__(136).Lexer;
exports.Parser = __webpack_require__(356).Parser;
var pc = __webpack_require__(51);
exports.PredictionContextCache = pc.PredictionContextCache;
exports.ParserRuleContext = __webpack_require__(177).ParserRuleContext;
exports.Interval = __webpack_require__(25).Interval;
exports.Utils = __webpack_require__(13);


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

var BaseType = __webpack_require__(47).BaseType;

function Variable (id, type) {
    this.id = id;
	this.type = type;
	return this;
}

Object.defineProperty(Variable.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});

Variable.prototype.toString = function() {
	return this.name;
}

Variable.prototype.transpile = function(transpiler) {
    transpiler.append(this.name);
}

Variable.prototype.getType = function(context) {
    return this.type;
};

exports.Variable = Variable;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

var EnumeratedCategoryDeclaration = __webpack_require__(92).EnumeratedCategoryDeclaration;
var EnumeratedNativeDeclaration = __webpack_require__(77).EnumeratedNativeDeclaration;
var ConcreteCategoryDeclaration = __webpack_require__(52).ConcreteCategoryDeclaration;
var ConcreteWidgetDeclaration = __webpack_require__(189).ConcreteWidgetDeclaration;
var NativeWidgetDeclaration = __webpack_require__(206).NativeWidgetDeclaration;
var BaseMethodDeclaration = __webpack_require__(75).BaseMethodDeclaration;
var CategoryDeclaration = __webpack_require__(45).CategoryDeclaration;
var AttributeDeclaration = __webpack_require__(70).AttributeDeclaration;
var MethodExpression = __webpack_require__(161).MethodExpression;
var ConcreteInstance = __webpack_require__(172).ConcreteInstance;
var ExpressionValue = __webpack_require__(76).ExpressionValue;
var ClosureValue = __webpack_require__(97).ClosureValue;
var ProblemListener = __webpack_require__(73).ProblemListener;
var MethodType = __webpack_require__(38).MethodType;
var DecimalType = __webpack_require__(23).DecimalType;
var DecimalValue = __webpack_require__(33).DecimalValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var Variable = __webpack_require__(10).Variable;
var LinkedValue = __webpack_require__(299).LinkedValue;

function Context() {
	this.globals = null;
	this.calling = null;
	this.parent = null; // for inner methods
	this.debugger = null;
	this.declarations = {};
    this.tests = {};
	this.instances = {};
	this.values = {};
    this.nativeBindings = {};
    this.problemListener = new ProblemListener();
	return this;
}

Context.newGlobalContext = function() {
	var context = new Context();
	context.globals = context;
	context.calling = null;
	context.parent = null;
	context.debugger = null;
	return context;
};


Context.prototype.isGlobalContext = function() {
	return this===this.globals;
};


Context.prototype.getCallingContext = function() {
	return this.calling;
};

Context.prototype.getParentMostContext = function() {
	if(this.parent === null) {
		return this;
	} else {
		return this.parent.getParentMostContext();
	}
};

Context.prototype.getClosestInstanceContext = function() {
    if(this.parent === null) {
        return null;
    } else if(this.parent instanceof InstanceContext) {
        return this.parent;
    } else {
        return this.parent.getClosestInstanceContext();
    }
};

Context.prototype.getParentContext = function() {
	return this.parent;
}

Context.prototype.setParentContext = function(parent) {
	this.parent = parent;
}

Context.prototype.newResourceContext = function() {
	var context = new ResourceContext();
	context.globals = this.globals;
	context.calling = this.calling;
	context.parent = this;
	context.debugger = this.debugger;
    context.problemListener = this.problemListener;
    return context;
};

Context.prototype.newLocalContext = function() {
	var context = new Context();
	context.globals = this.globals;
	context.calling = this;
	context.parent = null;
	context.debugger = this.debugger;
    context.problemListener = this.problemListener;
	return context;
};

Context.prototype.newDocumentContext = function(doc, isChild) {
	var context = new DocumentContext(doc);
	context.globals = this.globals;
	context.calling = isChild ? this.calling : this;
	context.parent = isChild ? this : null;
	context.debugger = this.debugger;
    context.problemListener = this.problemListener;
	return context;
};


Context.prototype.newBuiltInContext = function(value) {
    var context = new BuiltInContext(value);
    context.globals = this.globals;
    context.calling = this;
    context.parent = null;
    context.debugger = this.debugger;
    context.problemListener = this.problemListener;
    return context;
};


Context.prototype.newInstanceContext = function(instance, type, isChild) {
    var context = new InstanceContext(instance, type);
    context.globals = this.globals;
    context.calling = isChild ? this.calling : this;
    context.parent = isChild ? this : null;
    context.debugger = this.debugger;
    context.problemListener = this.problemListener;
    return context;
};

Context.prototype.newChildContext = function() {
	var context = new Context();
	context.globals = this.globals;
	context.calling = this.calling;
	context.parent = this;
	context.debugger = this.debugger;
    context.problemListener = this.problemListener;
	return context;
};

Context.prototype.newMemberContext = function(type) {
    return this.newInstanceContext(null, type, false);
};


Context.prototype.clone = function() {
    var context = new Context();
    context.globals = context;
    context.calling = null;
    context.parent = null;
    context.debugger = null;
    // copy from
    context.declarations = Object.create(this.declarations);
    context.tests = Object.create(this.tests);
    context.instances = Object.create(this.instances);
    context.values = Object.create(this.values);
    context.nativeBindings = Object.create(this.nativeBindings);
    return context;
};

Context.prototype.getCatalog = function() {
    if (this != this.globals)
        return this.globals.getCatalog();
    else
        return this.getLocalCatalog();
};

Context.prototype.getLocalCatalog = function() {
    var catalog = { attributes : [], methods : [], categories : [], enumerations : [], tests : [], widgets: []};
    for(var name in this.declarations) {
        var decl = this.declarations[name];
        if(decl instanceof AttributeDeclaration)
            catalog.attributes.push(name);
        else if(decl instanceof EnumeratedCategoryDeclaration || decl instanceof EnumeratedNativeDeclaration) {
            var info = {};
            info.name = decl.name;
            info.symbols = decl.symbols.map(function (s) {
                return s.name;
            });
            catalog.enumerations.push(info);
        } else if(decl instanceof CategoryDeclaration) {
            if(decl.isWidget(this))
                catalog.widgets.push(name);
            else
                catalog.categories.push(name);
        } else if(decl instanceof MethodDeclarationMap) {
            var method = {};
            method.name = decl.name;
            method.protos = [];
            for (var proto in decl.protos) {
                var main = decl.protos[proto].isEligibleAsMain();
                method.protos.push({proto: proto, main: main});
            }
            catalog.methods.push(method);
        }
    }
    for(var name in this.tests)
        catalog.tests.push(name);
    // minimize for UI optimization
    if(catalog.attributes.length <= 0)
        delete catalog.attributes;
    if(catalog.categories.length  <= 0)
        delete catalog.categories;
    if(catalog.widgets.length  <= 0)
        delete catalog.widgets;
    if(catalog.enumerations.length  <= 0)
        delete catalog.enumerations;
    if(catalog.methods.length  <= 0)
        delete catalog.methods;
    if(catalog.tests.length <= 0)
        delete catalog.tests;
    return catalog;
};

Context.prototype.findAttribute = function(name) {
    if(this===this.globals)
        return this.declarations[name] || (this.parent ? this.parent.findAttribute(name) : null);
    else
        return this.globals.findAttribute(name);
};

Context.prototype.getAllAttributes = function() {
    if(this===this.globals) {
        var list = [];
        for(var name in this.declarations) {
            if(this.declarations[name] instanceof AttributeDeclaration)
                list.push(this.declarations[name]);
        }
        if(this.parent)
            list = list.concat(this.parent.getAllAttributes());
        return list;
    } else
        return this.globals.getAllAttributes();
};

Context.prototype.getRegistered = function(name) {
	// resolve upwards, since local names override global ones
	var actual = this.declarations[name] || null;
	if(actual!==null) {
		return actual;
	}
	actual = this.instances[name] || null;
	if(actual!==null) {
		return actual;
	} else if(this.parent!==null) {
		return this.parent.getRegistered(name);
	} else if(this.globals!==this) {
		return this.globals.getRegistered(name);
	} else {
		return null;
	}
};

Context.prototype.getRegisteredDeclaration = function(name) {
	// resolve upwards, since local names override global ones
	var actual = this.declarations[name] || null;
	if(actual!==null) {
		return actual;
	} else if(this.parent!==null) {
		return this.parent.getRegisteredDeclaration(name);
	} else if(this.globals!==this) {
		return this.globals.getRegisteredDeclaration(name);
	} else {
		return null;
	}
};


Context.prototype.getLocalDeclaration = function(name) {
    var actual = this.declarations[name] || null;
    if (actual !== null) {
        return actual;
    } else if (this.parent !== null) {
        return this.parent.getLocalDeclaration(name);
    } else {
        return null;
    }
};



Context.prototype.registerDeclaration = function(declaration) {
    if(this.checkDuplicate(declaration))
    	this.declarations[declaration.name] = declaration;
};

Context.prototype.checkDuplicate = function(declaration) {
    var actual = this.getRegistered(declaration.name) || null;
    if (actual !== null && actual !== declaration)
        this.problemListener.reportDuplicate(declaration.name, declaration);
    return actual === null;
};


Context.prototype.unregisterTestDeclaration = function(declaration) {
    delete this.tests[declaration.name];
};

Context.prototype.unregisterMethodDeclaration = function(declaration, proto) {
    var map = this.declarations[declaration.name];
    if(map && map.unregister(proto))
        delete this.declarations[declaration.name];
};

Context.prototype.unregisterDeclaration = function(declaration) {
    delete this.declarations[declaration.name];
};

Context.prototype.registerMethodDeclaration = function(declaration) {
    var actual = this.checkDuplicateMethod(declaration);
    if (actual === null) {
        actual = new MethodDeclarationMap(declaration.name);
        this.declarations[declaration.name] = actual;
    }
    actual.register(declaration, this.problemListener);
};

Context.prototype.checkDuplicateMethod = function(declaration) {
    var actual = this.getRegistered(declaration.name) || null;
    if (actual !== null && !(actual instanceof MethodDeclarationMap))
        this.problemListener.reportDuplicate(declaration.name, declaration);
    return actual;
};

Context.prototype.registerTestDeclaration = function(declaration) {
    var actual = this.tests[declaration.name] || null;
    if(actual!==null)
        this.problemListener.reportDuplicate(declaration.name, declaration);
    this.tests[declaration.name] = declaration;
};

Context.prototype.getRegisteredTest = function(name) {
    // resolve upwards, since local names override global ones
    var actual = this.tests[name] || null;
    if(actual!==null) {
        return actual;
    } else if(this.parent!==null) {
        return this.parent.getRegisteredTest(name);
    } else if(this.globals!==this) {
        return this.globals.getRegisteredTest(name);
    } else {
        return null;
    }
};


Context.prototype.hasTests = function() {
    for(var test in this.tests)
        return true;
    return false;
};


Context.prototype.getTestDeclaration = function(testName) {
    return this.tests[testName];
};

Context.prototype.registerNativeBinding = function(type, declaration) {
    if(this === this.globals)
        this.nativeBindings[type] = declaration;
    else
        this.globals.registerNativeBinding(type, declaration);
};

Context.prototype.getNativeBinding = function(type) {
    if(this===this.globals) {
        var binding = this.nativeBindings[type] || null;
        if (binding !== null)
            return binding;
        else if (this.parent !== null)
            return this.parent.getNativeBinding(type);
        else
            return null;
    } else
        return this.globals.getNativeBinding(type);
};

function MethodDeclarationMap(name) {
	this.name = name;
	this.protos = {};
	return this;
}

MethodDeclarationMap.prototype.register = function(declaration, problemListener) {
	var proto = declaration.getProto();
	var current = this.protos[proto] || null;
	if(current!==null)
        problemListener.reportDuplicate(declaration.name, declaration);
	this.protos[proto] = declaration;
};

MethodDeclarationMap.prototype.unregister = function(proto) {
    delete this.protos[proto];
    return Object.getOwnPropertyNames(this.protos).length === 0;
};

MethodDeclarationMap.prototype.registerIfMissing = function(declaration) {
	var proto = declaration.getProto();
	if(!(proto in this.protos)) {
		this.protos[proto] = declaration;
	}
};

MethodDeclarationMap.prototype.getFirst = function() {
    for(var proto in this.protos) {
        return this.protos[proto];
    }
};


MethodDeclarationMap.prototype.getAll = function() {
    return Object.getOwnPropertyNames(this.protos).map(function(proto) { return this.protos[proto]; }, this);
};


MethodDeclarationMap.prototype.isEmpty = function() {
    return this.size()===0;
};


MethodDeclarationMap.prototype.size = function() {
    return Object.getOwnPropertyNames(this.protos).length;
};


Context.prototype.getRegisteredValue = function(name) {
    var context = this.contextForValue(name);
    if (context === null)
        return null;
    else
        return context.readRegisteredValue(name);
};



Context.prototype.readRegisteredValue = function(name) {
	return this.instances[name] || null;
};


Context.prototype.registerValue = function(value, checkDuplicate) {
    if(checkDuplicate === undefined)
        checkDuplicate = true;
	if(checkDuplicate) {
        // only explore current context
        var actual = this.instances[value.name] || null;
        if(actual!==null)
            this.problemListener.reportDuplicate(value.id);
    }
	this.instances[value.name] = value;
};


Context.prototype.unregisterValue = function(value) {
    delete this.instances[value.name];
};



Context.prototype.hasValue = function(id) {
    return this.contextForValue(id.name) !== null;
};



Context.prototype.getValue = function(id) {
	var context = this.contextForValue(id.name);
	if(context===null)
        this.problemListener.reportUnknownVariable(id);
	return context.readValue(id);
};



Context.prototype.readValue = function(id) {
	var value = this.values[id.name] || null;
	if(value===null)
        this.problemListener.reportEmptyVariable(id);
    if(value instanceof LinkedValue)
        return value.context.getValue(id);
    else
        return value;
};



Context.prototype.setValue = function(id, value) {
	var context = this.contextForValue(id.name);
	if(context===null)
        this.problemListener.reportUnknownVariable(id);
	context.writeValue(id, value);
};


Context.prototype.writeValue = function(id, value) {
    value = this.autocast(id.name, value);
    var current = this.values[id.name];
    if(current instanceof LinkedValue)
        current.context.setValue(id, value);
    else
    	this.values[id.name] = value;
};

Context.prototype.autocast = function(name, value) {
    if(value !== null && value instanceof IntegerValue) {
        var actual = this.instances[name];
        if(actual.getType(this) === DecimalType.instance)
            value = new DecimalValue(value.DecimalValue());
    }
    return value;
};

Context.prototype.contextForValue = function(name) {
	// resolve upwards, since local names override global ones
	var actual = this.instances[name] || null;
	if(actual!==null) {
		return this;
	} else if(this.parent!==null) {
		return this.parent.contextForValue(name);
	} else if(this.globals!==this) {
		return this.globals.contextForValue(name);
	} else {
		return null;
	}
};

Context.prototype.contextForDeclaration = function(name) {
    // resolve upwards, since local names override global ones
    var actual = this.declarations[name] || null;
    if(actual!==null) {
        return this;
    } else if(this.parent!==null) {
        return this.parent.contextForDeclaration(name);
    } else if(this.globals!==this) {
        return this.globals.contextForDeclaration(name);
    } else {
        return null;
    }
};

function ResourceContext() {
	Context.call(this);
	return this;
}

ResourceContext.prototype = Object.create(Context.prototype);
ResourceContext.prototype.constructor = ResourceContext;

function InstanceContext(instance, type) {
	Context.call(this);
	this.instance = instance || null;
    this.instanceType = type !== null ? type : instance.type;
	return this;
}

InstanceContext.prototype = Object.create(Context.prototype);
InstanceContext.prototype.constructor = InstanceContext;


InstanceContext.prototype.getRegistered = function(name) {
    var actual = Context.prototype.getRegistered.call(this, name);
    if (actual)
        return actual;
    var decl = this.getDeclaration();
    if (decl==null)
        return null;
    var methods = decl.getMemberMethodsMap(this, name);
    if(methods && !methods.isEmpty())
        return methods;
    else if(decl.hasAttribute(this, name))
        return this.getRegisteredDeclaration(typeof(AttributeDeclaration), name);
    else
        return null;
};


InstanceContext.prototype.getRegisteredDeclaration = function(klass, name) {
    if (klass === MethodDeclarationMap) {
        var decl = this.getDeclaration();
        if (decl) {
            var methods = decl.getMemberMethodsMap(this, name);
            if (methods && !methods.isEmpty())
                return methods;
        }
    }
    return Context.prototype.getRegisteredDeclaration.call(this, klass, name)
};


InstanceContext.prototype.readRegisteredValue = function(name) {
    var actual = this.instances[name] || null;
    // not very pure, but avoids a lot of complexity when registering a value
    if(actual === null) {
        var attr = this.getRegisteredDeclaration(name);
        if(attr instanceof AttributeDeclaration) {
            var type = attr.getType();
            actual = new Variable(name, type);
            this.instances[name] = actual;
        }
    }
    return actual;
};


InstanceContext.prototype.contextForValue = function(name) {
	// params and variables have precedence over members
	// so first look in context values
	var context = Context.prototype.contextForValue.call(this, name);
	if(context !== null) {
		return context;
	}
	var decl = this.getDeclaration();
    if(decl.hasAttribute(this, name) || decl.hasMethod(this, name)) {
		return this;
	} else {
		return null;
	}
};

InstanceContext.prototype.getDeclaration = function() {
    if(this.instance !== null)
        return this.instance.declaration;
    else
        return this.getRegisteredDeclaration(this.instanceType.name);
};

InstanceContext.prototype.readValue = function(id) {
    var decl = this.getDeclaration();
    if(decl.hasAttribute(this, id.name)) {
        return this.instance.getMemberValue(this.calling, id.name);
    } else if(decl.hasMethod(this, id.name)) {
        var method = decl.getMemberMethodsMap(this, id.name).getFirst()
        return new ClosureValue(this, new MethodType(method));
    } else
        return null;
};

InstanceContext.prototype.writeValue = function(id, value) {
	this.instance.setMember(this.calling, id.name, value);
};


function BuiltInContext(value) {
    Context.call(this);
    this.value = value;
    return this;
}


BuiltInContext.prototype = Object.create(Context.prototype);
BuiltInContext.prototype.constructor = BuiltInContext;



function DocumentContext(document) {
    Context.call(this);
    this.document = document;
    return this;
}

DocumentContext.prototype = Object.create(Context.prototype);
DocumentContext.prototype.constructor = DocumentContext;


DocumentContext.prototype.contextForValue = function(name) {
    // params and variables have precedence over members
    // so first look in context values
    var context = Context.prototype.contextForValue.call(this, name);
    if (context !== null)
        return context;
    // since any name is valid in the context of a document
    // simply return this document context
    else
        return this;
};

DocumentContext.prototype.readValue = function(name) {
    return this.document.getMemberValue(this.calling, name);
};


DocumentContext.prototype.writeValue = function(name) {
    this.document.setMember(this.calling, name, value);
};


Context.prototype.enterMethod = function(method) {
	if(this.debugger !== null) {
		this.debugger.enterMethod(this, method);
	}
};

Context.prototype.leaveMethod = function(method) {
	if(this.debugger !== null) {
		this.debugger.leaveMethod(this, method);
	}
};

Context.prototype.enterStatement = function(statement) {
	if(this.debugger !== null) {
		this.debugger.enterStatement(this, statement);
	}
};

Context.prototype.leaveStatement = function(statement) {
	if(this.debugger !== null) {
		this.debugger.leaveStatement(this, statement);
	}
};

Context.prototype.terminated = function() {
	if (this.debugger !== null) {
		this.debugger.terminated();
	}
};

Context.prototype.loadSingleton = function(type) {
    if(this === this.globals) {
        var value = this.values[type.name] || null;
        if(value === null) {
            var decl = this.declarations[type.name] || null;
            if(!(decl instanceof ConcreteCategoryDeclaration))
                throw new InternalError("No such singleton:" + type.name);
            value = new ConcreteInstance(this, decl);
            value.mutable = true; // a singleton is protected by "with x do", so always mutable in that context
            this.values[type.name] = value;
        }
        if(value instanceof ConcreteInstance)
            return value;
        else
            throw new InternalError("Not a concrete instance:" + value);
    } else
        return this.globals.loadSingleton(type);
};


exports.Context = Context;
exports.BuiltInContext = BuiltInContext;
exports.InstanceContext = InstanceContext;
exports.DocumentContext = DocumentContext;
exports.ResourceContext = ResourceContext;
exports.MethodDeclarationMap = MethodDeclarationMap;

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

var BaseType = __webpack_require__(47).BaseType;

function NativeType(id) {
	BaseType.call(this, id);
	return this;
}

NativeType.prototype = Object.create(BaseType.prototype);
NativeType.prototype.constructor = NativeType;

NativeType.prototype.checkUnique = function(context) {
	// nothing to do
};

NativeType.prototype.checkExists = function(context) {
	// nothing to do
};

NativeType.prototype.isMoreSpecificThan = function(context, other) {
	return false;
};

NativeType.prototype.equals = function(obj) {
	return obj===this;
};

NativeType.prototype.sort = function(context, list, desc) {

    function cmp(o1, o2) {
        o1 = o1.value;
        o2 = o2.value;
        return o1 > o2 ? 1 : o1 === o2 ? 0 : -1;
    }
    return this.doSort(context, list, cmp, desc);
};

NativeType.prototype.declareSorted = function(transpiler, key) {
    // nothing to do
};

NativeType.prototype.transpileSorted = function(transpiler, desc, key) {
    if(desc)
        transpiler.append("function(o1, o2) { return o1 === o2 ? 0 : o1 > o2 ? -1 : 1; }");
};


exports.NativeType = NativeType;




/***/ }),
/* 13 */
/***/ (function(module, exports) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

function arrayToString(a) {
    return "[" + a.join(", ") + "]";
}

String.prototype.seed = String.prototype.seed || Math.round(Math.random() * Math.pow(2, 32));

String.prototype.hashCode = function () {
    var remainder, bytes, h1, h1b, c1, c1b, c2, c2b, k1, i,
        key = this.toString();

    remainder = key.length & 3; // key.length % 4
    bytes = key.length - remainder;
    h1 = String.prototype.seed;
    c1 = 0xcc9e2d51;
    c2 = 0x1b873593;
    i = 0;

    while (i < bytes) {
        k1 =
            ((key.charCodeAt(i) & 0xff)) |
            ((key.charCodeAt(++i) & 0xff) << 8) |
            ((key.charCodeAt(++i) & 0xff) << 16) |
            ((key.charCodeAt(++i) & 0xff) << 24);
        ++i;

        k1 = ((((k1 & 0xffff) * c1) + ((((k1 >>> 16) * c1) & 0xffff) << 16))) & 0xffffffff;
        k1 = (k1 << 15) | (k1 >>> 17);
        k1 = ((((k1 & 0xffff) * c2) + ((((k1 >>> 16) * c2) & 0xffff) << 16))) & 0xffffffff;

        h1 ^= k1;
        h1 = (h1 << 13) | (h1 >>> 19);
        h1b = ((((h1 & 0xffff) * 5) + ((((h1 >>> 16) * 5) & 0xffff) << 16))) & 0xffffffff;
        h1 = (((h1b & 0xffff) + 0x6b64) + ((((h1b >>> 16) + 0xe654) & 0xffff) << 16));
    }

    k1 = 0;

    switch (remainder) {
        case 3:
            k1 ^= (key.charCodeAt(i + 2) & 0xff) << 16;
        case 2:
            k1 ^= (key.charCodeAt(i + 1) & 0xff) << 8;
        case 1:
            k1 ^= (key.charCodeAt(i) & 0xff);

            k1 = (((k1 & 0xffff) * c1) + ((((k1 >>> 16) * c1) & 0xffff) << 16)) & 0xffffffff;
            k1 = (k1 << 15) | (k1 >>> 17);
            k1 = (((k1 & 0xffff) * c2) + ((((k1 >>> 16) * c2) & 0xffff) << 16)) & 0xffffffff;
            h1 ^= k1;
    }

    h1 ^= key.length;

    h1 ^= h1 >>> 16;
    h1 = (((h1 & 0xffff) * 0x85ebca6b) + ((((h1 >>> 16) * 0x85ebca6b) & 0xffff) << 16)) & 0xffffffff;
    h1 ^= h1 >>> 13;
    h1 = ((((h1 & 0xffff) * 0xc2b2ae35) + ((((h1 >>> 16) * 0xc2b2ae35) & 0xffff) << 16))) & 0xffffffff;
    h1 ^= h1 >>> 16;

    return h1 >>> 0;
};

function standardEqualsFunction(a, b) {
    return a.equals(b);
}

function standardHashCodeFunction(a) {
    return a.hashCode();
}

function Set(hashFunction, equalsFunction) {
    this.data = {};
    this.hashFunction = hashFunction || standardHashCodeFunction;
    this.equalsFunction = equalsFunction || standardEqualsFunction;
    return this;
}

Object.defineProperty(Set.prototype, "length", {
    get: function () {
        var l = 0;
        for (var key in this.data) {
            if (key.indexOf("hash_") === 0) {
                l = l + this.data[key].length;
            }
        }
        return l;
    }
});

Set.prototype.add = function (value) {
    var hash = this.hashFunction(value);
    var key = "hash_" + hash;
    if (key in this.data) {
        var values = this.data[key];
        for (var i = 0; i < values.length; i++) {
            if (this.equalsFunction(value, values[i])) {
                return values[i];
            }
        }
        values.push(value);
        return value;
    } else {
        this.data[key] = [value];
        return value;
    }
};

Set.prototype.contains = function (value) {
    return this.get(value) != null;
};

Set.prototype.get = function (value) {
    var hash = this.hashFunction(value);
    var key = "hash_" + hash;
    if (key in this.data) {
        var values = this.data[key];
        for (var i = 0; i < values.length; i++) {
            if (this.equalsFunction(value, values[i])) {
                return values[i];
            }
        }
    }
    return null;
};

Set.prototype.values = function () {
    var l = [];
    for (var key in this.data) {
        if (key.indexOf("hash_") === 0) {
            l = l.concat(this.data[key]);
        }
    }
    return l;
};

Set.prototype.toString = function () {
    return arrayToString(this.values());
};

function BitSet() {
    this.data = [];
    return this;
}

BitSet.prototype.add = function (value) {
    this.data[value] = true;
};

BitSet.prototype.or = function (set) {
    var bits = this;
    Object.keys(set.data).map(function (alt) {
        bits.add(alt);
    });
};

BitSet.prototype.remove = function (value) {
    delete this.data[value];
};

BitSet.prototype.contains = function (value) {
    return this.data[value] === true;
};

BitSet.prototype.values = function () {
    return Object.keys(this.data);
};

BitSet.prototype.minValue = function () {
    return Math.min.apply(null, this.values());
};

BitSet.prototype.hashCode = function () {
    var hash = new Hash();
    hash.update(this.values());
    return hash.finish();
};

BitSet.prototype.equals = function (other) {
    if (!(other instanceof BitSet)) {
        return false;
    }
    return this.hashCode() === other.hashCode();
};

Object.defineProperty(BitSet.prototype, "length", {
    get: function () {
        return this.values().length;
    }
});

BitSet.prototype.toString = function () {
    return "{" + this.values().join(", ") + "}";
};

function Map(hashFunction, equalsFunction) {
    this.data = {};
    this.hashFunction = hashFunction || standardHashCodeFunction;
    this.equalsFunction = equalsFunction || standardEqualsFunction;
    return this;
}

Object.defineProperty(Map.prototype, "length", {
    get: function () {
        var l = 0;
        for (var hashKey in this.data) {
            if (hashKey.indexOf("hash_") === 0) {
                l = l + this.data[hashKey].length;
            }
        }
        return l;
    }
});

Map.prototype.put = function (key, value) {
    var hashKey = "hash_" + this.hashFunction(key);
    if (hashKey in this.data) {
        var entries = this.data[hashKey];
        for (var i = 0; i < entries.length; i++) {
            var entry = entries[i];
            if (this.equalsFunction(key, entry.key)) {
                var oldValue = entry.value;
                entry.value = value;
                return oldValue;
            }
        }
        entries.push({key:key, value:value});
        return value;
    } else {
        this.data[hashKey] = [{key:key, value:value}];
        return value;
    }
};

Map.prototype.containsKey = function (key) {
    var hashKey = "hash_" + this.hashFunction(key);
    if(hashKey in this.data) {
        var entries = this.data[hashKey];
        for (var i = 0; i < entries.length; i++) {
            var entry = entries[i];
            if (this.equalsFunction(key, entry.key))
                return true;
        }
    }
    return false;
};

Map.prototype.get = function (key) {
    var hashKey = "hash_" + this.hashFunction(key);
    if(hashKey in this.data) {
        var entries = this.data[hashKey];
        for (var i = 0; i < entries.length; i++) {
            var entry = entries[i];
            if (this.equalsFunction(key, entry.key))
                return entry.value;
        }
    }
    return null;
};

Map.prototype.entries = function () {
    var l = [];
    for (var key in this.data) {
        if (key.indexOf("hash_") === 0) {
            l = l.concat(this.data[key]);
        }
    }
    return l;
};


Map.prototype.getKeys = function () {
    return this.entries().map(function(e) {
        return e.key;
    });
};


Map.prototype.getValues = function () {
    return this.entries().map(function(e) {
            return e.value;
    });
};


Map.prototype.toString = function () {
    var ss = this.entries().map(function(entry) {
        return '{' + entry.key + ':' + entry.value + '}';
    });
    return '[' + ss.join(", ") + ']';
};


function AltDict() {
    this.data = {};
    return this;
}


AltDict.prototype.get = function (key) {
    key = "k-" + key;
    if (key in this.data) {
        return this.data[key];
    } else {
        return null;
    }
};

AltDict.prototype.put = function (key, value) {
    key = "k-" + key;
    this.data[key] = value;
};

AltDict.prototype.values = function () {
    var data = this.data;
    var keys = Object.keys(this.data);
    return keys.map(function (key) {
        return data[key];
    });
};

function DoubleDict() {
    return this;
}

function Hash() {
    this.count = 0;
    this.hash = 0;
    return this;
}

Hash.prototype.update = function () {
    for(var i=0;i<arguments.length;i++) {
        var value = arguments[i];
        if (value == null)
            continue;
        if(Array.isArray(value))
            this.update.apply(value);
        else {
            var k = 0;
            switch (typeof(value)) {
                case 'undefined':
                case 'function':
                    continue;
                case 'number':
                case 'boolean':
                    k = value;
                    break;
                case 'string':
                    k = value.hashCode();
                    break;
                default:
                    value.updateHashCode(this);
                    continue;
            }
            k = k * 0xCC9E2D51;
            k = (k << 15) | (k >>> (32 - 15));
            k = k * 0x1B873593;
            this.count = this.count + 1;
            var hash = this.hash ^ k;
            hash = (hash << 13) | (hash >>> (32 - 13));
            hash = hash * 5 + 0xE6546B64;
            this.hash = hash;
        }
    }
}

Hash.prototype.finish = function () {
    var hash = this.hash ^ (this.count * 4);
    hash = hash ^ (hash >>> 16);
    hash = hash * 0x85EBCA6B;
    hash = hash ^ (hash >>> 13);
    hash = hash * 0xC2B2AE35;
    hash = hash ^ (hash >>> 16);
    return hash;
}

function hashStuff() {
    var hash = new Hash();
    hash.update.apply(arguments);
    return hash.finish();
}

DoubleDict.prototype.get = function (a, b) {
    var d = this[a] || null;
    return d === null ? null : (d[b] || null);
};

DoubleDict.prototype.set = function (a, b, o) {
    var d = this[a] || null;
    if (d === null) {
        d = {};
        this[a] = d;
    }
    d[b] = o;
};


function escapeWhitespace(s, escapeSpaces) {
    s = s.replace(/\t/g, "\\t")
         .replace(/\n/g, "\\n")
         .replace(/\r/g, "\\r");
    if (escapeSpaces) {
        s = s.replace(/ /g, "\u00B7");
    }
    return s;
}

function titleCase(str) {
    return str.replace(/\w\S*/g, function (txt) {
        return txt.charAt(0).toUpperCase() + txt.substr(1);
    });
};

function equalArrays(a, b)
{
    if (!Array.isArray(a) || !Array.isArray(b))
        return false;
    if (a == b)
        return true;
    if (a.length != b.length)
        return false;
    for (var i = 0; i < a.length; i++) {
        if (a[i] == b[i])
            continue;
        if (!a[i].equals(b[i]))
            return false;
    }
    return true;
};

exports.Hash = Hash;
exports.Set = Set;
exports.Map = Map;
exports.BitSet = BitSet;
exports.AltDict = AltDict;
exports.DoubleDict = DoubleDict;
exports.hashStuff = hashStuff;
exports.escapeWhitespace = escapeWhitespace;
exports.arrayToString = arrayToString;
exports.titleCase = titleCase;
exports.equalArrays = equalArrays;


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var Identifier = __webpack_require__(0).Identifier;
var Any = __webpack_require__(140).Any;

function AnyType() {
 	NativeType.call(this, new Identifier("any"));
 	return this;
 }

AnyType.prototype = Object.create(NativeType.prototype);
AnyType.prototype.constructor = AnyType;

AnyType.instance = new AnyType();
	


AnyType.prototype.checkItem = function(context, item) {
	return AnyType.instance; // required to support Document items
};


AnyType.prototype.declare = function(transpiler) {
    transpiler.register(Any);
};


AnyType.prototype.transpile = function(transpiler) {
    transpiler.append('Any');
};


AnyType.prototype.declareItem = function(transpiler, type, item) {
    // required to support Document items
    type.declare(transpiler);
    item.declare(transpiler);
};


AnyType.prototype.transpileItem = function(transpiler, type, item) {
    // required to support Document items
    transpiler.append(".item(");
    item.transpile(transpiler);
    transpiler.append(")");
};


AnyType.prototype.checkMember = function(context, section, name) {
	// required to support Document members
    return AnyType.instance;
};


AnyType.prototype.transpileAssignMemberValue = function(transpiler, name, expression) {
    // required to support Document members
    transpiler.append(".setMember('").append(name).append("', ");
    expression.transpile(transpiler);
    transpiler.append(")");
};


AnyType.prototype.transpileAssignItemValue = function(transpiler, item, expression) {
    // required to support Document members
    transpiler.append(".setItem(");
    item.transpile(transpiler);
    transpiler.append(", ");
    expression.transpile(transpiler);
    transpiler.append(")");
};

AnyType.prototype.declare = function(transpiler) {
    // nothing to do
};

AnyType.prototype.isAssignableFrom = function(context, other) {
	return true;
};

exports.AnyType = AnyType;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var support = __webpack_require__(67);
var base64 = __webpack_require__(272);
var nodejsUtils = __webpack_require__(152);
var setImmediate = __webpack_require__(385);
var external = __webpack_require__(81);


/**
 * Convert a string that pass as a "binary string": it should represent a byte
 * array but may have > 255 char codes. Be sure to take only the first byte
 * and returns the byte array.
 * @param {String} str the string to transform.
 * @return {Array|Uint8Array} the string in a binary format.
 */
function string2binary(str) {
    var result = null;
    if (support.uint8array) {
      result = new Uint8Array(str.length);
    } else {
      result = new Array(str.length);
    }
    return stringToArrayLike(str, result);
}

/**
 * Create a new blob with the given content and the given type.
 * @param {Array[String|ArrayBuffer]} parts the content to put in the blob. DO NOT use
 * an Uint8Array because the stock browser of android 4 won't accept it (it
 * will be silently converted to a string, "[object Uint8Array]").
 * @param {String} type the mime type of the blob.
 * @return {Blob} the created blob.
 */
exports.newBlob = function(parts, type) {
    exports.checkSupport("blob");

    try {
        // Blob constructor
        return new Blob(parts, {
            type: type
        });
    }
    catch (e) {

        try {
            // deprecated, browser only, old way
            var Builder = window.BlobBuilder || window.WebKitBlobBuilder || window.MozBlobBuilder || window.MSBlobBuilder;
            var builder = new Builder();
            for (var i = 0; i < parts.length; i++) {
                builder.append(parts[i]);
            }
            return builder.getBlob(type);
        }
        catch (e) {

            // well, fuck ?!
            throw new Error("Bug : can't construct the Blob.");
        }
    }


};
/**
 * The identity function.
 * @param {Object} input the input.
 * @return {Object} the same input.
 */
function identity(input) {
    return input;
}

/**
 * Fill in an array with a string.
 * @param {String} str the string to use.
 * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to fill in (will be mutated).
 * @return {Array|ArrayBuffer|Uint8Array|Buffer} the updated array.
 */
function stringToArrayLike(str, array) {
    for (var i = 0; i < str.length; ++i) {
        array[i] = str.charCodeAt(i) & 0xFF;
    }
    return array;
}

/**
 * An helper for the function arrayLikeToString.
 * This contains static informations and functions that
 * can be optimized by the browser JIT compiler.
 */
var arrayToStringHelper = {
    /**
     * Transform an array of int into a string, chunk by chunk.
     * See the performances notes on arrayLikeToString.
     * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to transform.
     * @param {String} type the type of the array.
     * @param {Integer} chunk the chunk size.
     * @return {String} the resulting string.
     * @throws Error if the chunk is too big for the stack.
     */
    stringifyByChunk: function(array, type, chunk) {
        var result = [], k = 0, len = array.length;
        // shortcut
        if (len <= chunk) {
            return String.fromCharCode.apply(null, array);
        }
        while (k < len) {
            if (type === "array" || type === "nodebuffer") {
                result.push(String.fromCharCode.apply(null, array.slice(k, Math.min(k + chunk, len))));
            }
            else {
                result.push(String.fromCharCode.apply(null, array.subarray(k, Math.min(k + chunk, len))));
            }
            k += chunk;
        }
        return result.join("");
    },
    /**
     * Call String.fromCharCode on every item in the array.
     * This is the naive implementation, which generate A LOT of intermediate string.
     * This should be used when everything else fail.
     * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to transform.
     * @return {String} the result.
     */
    stringifyByChar: function(array){
        var resultStr = "";
        for(var i = 0; i < array.length; i++) {
            resultStr += String.fromCharCode(array[i]);
        }
        return resultStr;
    },
    applyCanBeUsed : {
        /**
         * true if the browser accepts to use String.fromCharCode on Uint8Array
         */
        uint8array : (function () {
            try {
                return support.uint8array && String.fromCharCode.apply(null, new Uint8Array(1)).length === 1;
            } catch (e) {
                return false;
            }
        })(),
        /**
         * true if the browser accepts to use String.fromCharCode on nodejs Buffer.
         */
        nodebuffer : (function () {
            try {
                return support.nodebuffer && String.fromCharCode.apply(null, nodejsUtils.newBuffer(1)).length === 1;
            } catch (e) {
                return false;
            }
        })()
    }
};

/**
 * Transform an array-like object to a string.
 * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to transform.
 * @return {String} the result.
 */
function arrayLikeToString(array) {
    // Performances notes :
    // --------------------
    // String.fromCharCode.apply(null, array) is the fastest, see
    // see http://jsperf.com/converting-a-uint8array-to-a-string/2
    // but the stack is limited (and we can get huge arrays !).
    //
    // result += String.fromCharCode(array[i]); generate too many strings !
    //
    // This code is inspired by http://jsperf.com/arraybuffer-to-string-apply-performance/2
    // TODO : we now have workers that split the work. Do we still need that ?
    var chunk = 65536,
        type = exports.getTypeOf(array),
        canUseApply = true;
    if (type === "uint8array") {
        canUseApply = arrayToStringHelper.applyCanBeUsed.uint8array;
    } else if (type === "nodebuffer") {
        canUseApply = arrayToStringHelper.applyCanBeUsed.nodebuffer;
    }

    if (canUseApply) {
        while (chunk > 1) {
            try {
                return arrayToStringHelper.stringifyByChunk(array, type, chunk);
            } catch (e) {
                chunk = Math.floor(chunk / 2);
            }
        }
    }

    // no apply or chunk error : slow and painful algorithm
    // default browser on android 4.*
    return arrayToStringHelper.stringifyByChar(array);
}

exports.applyFromCharCode = arrayLikeToString;


/**
 * Copy the data from an array-like to an other array-like.
 * @param {Array|ArrayBuffer|Uint8Array|Buffer} arrayFrom the origin array.
 * @param {Array|ArrayBuffer|Uint8Array|Buffer} arrayTo the destination array which will be mutated.
 * @return {Array|ArrayBuffer|Uint8Array|Buffer} the updated destination array.
 */
function arrayLikeToArrayLike(arrayFrom, arrayTo) {
    for (var i = 0; i < arrayFrom.length; i++) {
        arrayTo[i] = arrayFrom[i];
    }
    return arrayTo;
}

// a matrix containing functions to transform everything into everything.
var transform = {};

// string to ?
transform["string"] = {
    "string": identity,
    "array": function(input) {
        return stringToArrayLike(input, new Array(input.length));
    },
    "arraybuffer": function(input) {
        return transform["string"]["uint8array"](input).buffer;
    },
    "uint8array": function(input) {
        return stringToArrayLike(input, new Uint8Array(input.length));
    },
    "nodebuffer": function(input) {
        return stringToArrayLike(input, nodejsUtils.newBuffer(input.length));
    }
};

// array to ?
transform["array"] = {
    "string": arrayLikeToString,
    "array": identity,
    "arraybuffer": function(input) {
        return (new Uint8Array(input)).buffer;
    },
    "uint8array": function(input) {
        return new Uint8Array(input);
    },
    "nodebuffer": function(input) {
        return nodejsUtils.newBuffer(input);
    }
};

// arraybuffer to ?
transform["arraybuffer"] = {
    "string": function(input) {
        return arrayLikeToString(new Uint8Array(input));
    },
    "array": function(input) {
        return arrayLikeToArrayLike(new Uint8Array(input), new Array(input.byteLength));
    },
    "arraybuffer": identity,
    "uint8array": function(input) {
        return new Uint8Array(input);
    },
    "nodebuffer": function(input) {
        return nodejsUtils.newBuffer(new Uint8Array(input));
    }
};

// uint8array to ?
transform["uint8array"] = {
    "string": arrayLikeToString,
    "array": function(input) {
        return arrayLikeToArrayLike(input, new Array(input.length));
    },
    "arraybuffer": function(input) {
        // copy the uint8array: DO NOT propagate the original ArrayBuffer, it
        // can be way larger (the whole zip file for example).
        var copy = new Uint8Array(input.length);
        if (input.length) {
            copy.set(input, 0);
        }
        return copy.buffer;
    },
    "uint8array": identity,
    "nodebuffer": function(input) {
        return nodejsUtils.newBuffer(input);
    }
};

// nodebuffer to ?
transform["nodebuffer"] = {
    "string": arrayLikeToString,
    "array": function(input) {
        return arrayLikeToArrayLike(input, new Array(input.length));
    },
    "arraybuffer": function(input) {
        return transform["nodebuffer"]["uint8array"](input).buffer;
    },
    "uint8array": function(input) {
        return arrayLikeToArrayLike(input, new Uint8Array(input.length));
    },
    "nodebuffer": identity
};

/**
 * Transform an input into any type.
 * The supported output type are : string, array, uint8array, arraybuffer, nodebuffer.
 * If no output type is specified, the unmodified input will be returned.
 * @param {String} outputType the output type.
 * @param {String|Array|ArrayBuffer|Uint8Array|Buffer} input the input to convert.
 * @throws {Error} an Error if the browser doesn't support the requested output type.
 */
exports.transformTo = function(outputType, input) {
    if (!input) {
        // undefined, null, etc
        // an empty string won't harm.
        input = "";
    }
    if (!outputType) {
        return input;
    }
    exports.checkSupport(outputType);
    var inputType = exports.getTypeOf(input);
    var result = transform[inputType][outputType](input);
    return result;
};

/**
 * Return the type of the input.
 * The type will be in a format valid for JSZip.utils.transformTo : string, array, uint8array, arraybuffer.
 * @param {Object} input the input to identify.
 * @return {String} the (lowercase) type of the input.
 */
exports.getTypeOf = function(input) {
    if (typeof input === "string") {
        return "string";
    }
    if (Object.prototype.toString.call(input) === "[object Array]") {
        return "array";
    }
    if (support.nodebuffer && nodejsUtils.isBuffer(input)) {
        return "nodebuffer";
    }
    if (support.uint8array && input instanceof Uint8Array) {
        return "uint8array";
    }
    if (support.arraybuffer && input instanceof ArrayBuffer) {
        return "arraybuffer";
    }
};

/**
 * Throw an exception if the type is not supported.
 * @param {String} type the type to check.
 * @throws {Error} an Error if the browser doesn't support the requested type.
 */
exports.checkSupport = function(type) {
    var supported = support[type.toLowerCase()];
    if (!supported) {
        throw new Error(type + " is not supported by this platform");
    }
};

exports.MAX_VALUE_16BITS = 65535;
exports.MAX_VALUE_32BITS = -1; // well, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF" is parsed as -1

/**
 * Prettify a string read as binary.
 * @param {string} str the string to prettify.
 * @return {string} a pretty string.
 */
exports.pretty = function(str) {
    var res = '',
        code, i;
    for (i = 0; i < (str || "").length; i++) {
        code = str.charCodeAt(i);
        res += '\\x' + (code < 16 ? "0" : "") + code.toString(16).toUpperCase();
    }
    return res;
};

/**
 * Defer the call of a function.
 * @param {Function} callback the function to call asynchronously.
 * @param {Array} args the arguments to give to the callback.
 */
exports.delay = function(callback, args, self) {
    setImmediate(function () {
        callback.apply(self || null, args || []);
    });
};

/**
 * Extends a prototype with an other, without calling a constructor with
 * side effects. Inspired by nodejs' `utils.inherits`
 * @param {Function} ctor the constructor to augment
 * @param {Function} superCtor the parent constructor to use
 */
exports.inherits = function (ctor, superCtor) {
    var Obj = function() {};
    Obj.prototype = superCtor.prototype;
    ctor.prototype = new Obj();
};

/**
 * Merge the objects passed as parameters into a new one.
 * @private
 * @param {...Object} var_args All objects to merge.
 * @return {Object} a new object with the data of the others.
 */
exports.extend = function() {
    var result = {}, i, attr;
    for (i = 0; i < arguments.length; i++) { // arguments is not enumerable in some browsers
        for (attr in arguments[i]) {
            if (arguments[i].hasOwnProperty(attr) && typeof result[attr] === "undefined") {
                result[attr] = arguments[i][attr];
            }
        }
    }
    return result;
};

/**
 * Transform arbitrary content into a Promise.
 * @param {String} name a name for the content being processed.
 * @param {Object} inputData the content to process.
 * @param {Boolean} isBinary true if the content is not an unicode string
 * @param {Boolean} isOptimizedBinaryString true if the string content only has one byte per character.
 * @param {Boolean} isBase64 true if the string content is encoded with base64.
 * @return {Promise} a promise in a format usable by JSZip.
 */
exports.prepareContent = function(name, inputData, isBinary, isOptimizedBinaryString, isBase64) {

    // if inputData is already a promise, this flatten it.
    var promise = external.Promise.resolve(inputData).then(function(data) {
        
        
        var isBlob = support.blob && (data instanceof Blob || ['[object File]', '[object Blob]'].indexOf(Object.prototype.toString.call(data)) !== -1);

        if (isBlob && typeof FileReader !== "undefined") {
            return new external.Promise(function (resolve, reject) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    resolve(e.target.result);
                };
                reader.onerror = function(e) {
                    reject(e.target.error);
                };
                reader.readAsArrayBuffer(data);
            });
        } else {
            return data;
        }
    });

    return promise.then(function(data) {
        var dataType = exports.getTypeOf(data);

        if (!dataType) {
            return external.Promise.reject(
                new Error("The data of '" + name + "' is in an unsupported format !")
            );
        }
        // special case : it's way easier to work with Uint8Array than with ArrayBuffer
        if (dataType === "arraybuffer") {
            data = exports.transformTo("uint8array", data);
        } else if (dataType === "string") {
            if (isBase64) {
                data = base64.decode(data);
            }
            else if (isBinary) {
                // optimizedBinaryString === true means that the file has already been filtered with a 0xFF mask
                if (isOptimizedBinaryString !== true) {
                    // this is a string, not in a base64 format.
                    // Be sure that this is a correct "binary string"
                    data = string2binary(data);
                }
            }
        }
        return data;
    });
};


/***/ }),
/* 16 */
/***/ (function(module, exports) {

function equalObjects(o1, o2) {
    if(Object.is(o1, o2))
        return true;
    else
        return o1.equals ? o1.equals(o2) : false;

}

function equalArrays(o1, o2) {
	o1 = o1 || null;
	o2 = o2 || null;
	if(o1===o2) {
		return true;
	}
	if(o1===null || o2===null) {
		return false;
	}
	if(o1.length !== o2.length) {
		return false;
	}
	for(var i=0;i<o1.length;i++) {
		if(!equalObjects(o1[i], o2[i])) {
			return false;
		}
	}
	return true;
}

function arrayContains(a, o) {
	for(var i=0;i<a.length;i++) {
		if(equalObjects(a[i], o)) {
			return true;
		}
	}
	return false;
}

function removeAccents(s) {
    return s.replace(/[ÁÀÃÂÄ]/gi,"A")
        .replace(/[áàãâä]/gi,"a")
        .replace(/[ÉÈËÊ]/gi,"E")
        .replace(/[éèëê]/gi,"e")
        .replace(/[ÍÌÏÎ]/gi,"I")
        .replace(/[íìïî]/gi,"i")
        .replace(/[ÓÒÖÔÕ]/gi,"O")
        .replace(/[óòöôõ]/gi,"o")
        .replace(/[ÚÙÜÛ]/gi, "U")
        .replace(/[úùüû]/gi, "u")
        .replace(/[Ç]/gi, "C")
        .replace(/[ç]/gi, "c")
        .replace(/[Ñ]/gi, "N")
        .replace(/[ñ]/gi, "n");
}

function getUtf8StringLength(s) {
    return s.split('')
        .map(function (c) {
            return c.charCodeAt(0);
        })
        .map(getUtf8CharLength)
        .reduce(function(prev, cur) {
            return prev + cur;
        }, 0);
}

/* the below inspired by MDN StringView.js */

function getUtf8CharLength(c) {
    return c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : c < 0x200000 ? 4 : c < 0x4000000 ? 5 : 6;
}

function stringToUtf8Buffer(s) {
    var codes = s.split('')
        .map(function (c) {
            return c.charCodeAt(0);
        });
    var size = codes.map(getUtf8CharLength)
        .reduce(function(prev, cur) {
            return prev + cur;
        }, 0);
    var buffer = new ArrayBuffer(size);
    var view = new Uint8Array(buffer);
    var idx = 0;
    codes.forEach(function(c) {
        if (c < 0x80 /* 128 */) {
            /* one byte */
            view[idx++] = c;
        } else if (c < 0x800 /* 2048 */) {
            /* two bytes */
            view[idx++] = 0xc0 /* 192 */ + (c >>> 6);
            view[idx++] = 0x80 /* 128 */ + (c & 0x3f /* 63 */);
        } else if (c < 0x10000 /* 65536 */) {
            /* three bytes */
            view[idx++] = 0xe0 /* 224 */ + (c >>> 12);
            view[idx++] = 0x80 /* 128 */ + ((c >>> 6) & 0x3f /* 63 */);
            view[idx++] = 0x80 /* 128 */ + (c & 0x3f /* 63 */);
        } else if (c < 0x200000 /* 2097152 */) {
            /* four bytes */
            view[idx++] = 0xf0 /* 240 */ + (c >>> 18);
            view[idx++] = 0x80 /* 128 */ + ((c >>> 12) & 0x3f /* 63 */);
            view[idx++] = 0x80 /* 128 */ + ((c >>> 6) & 0x3f /* 63 */);
            view[idx++] = 0x80 /* 128 */ + (c & 0x3f /* 63 */);
        } else if (c < 0x4000000 /* 67108864 */) {
            /* five bytes */
            view[idx++] = 0xf8 /* 248 */ + (c >>> 24);
            view[idx++] = 0x80 /* 128 */ + ((c >>> 18) & 0x3f /* 63 */);
            view[idx++] = 0x80 /* 128 */ + ((c >>> 12) & 0x3f /* 63 */);
            view[idx++] = 0x80 /* 128 */ + ((c >>> 6) & 0x3f /* 63 */);
            view[idx++] = 0x80 /* 128 */ + (c & 0x3f /* 63 */);
        } else /* if (c <= 0x7fffffff) */ { /* 2147483647 */
            /* six bytes */
            view[idx++] = 0xfc /* 252 */ + /* (c >>> 30) may be not safe in ECMAScript! So...: */ (c / 1073741824);
            view[idx++] = 0x80 /* 128 */ + ((c >>> 24) & 0x3f /* 63 */);
            view[idx++] = 0x80 /* 128 */ + ((c >>> 18) & 0x3f /* 63 */);
            view[idx++] = 0x80 /* 128 */ + ((c >>> 12) & 0x3f /* 63 */);
            view[idx++] = 0x80 /* 128 */ + ((c >>> 6) & 0x3f /* 63 */);
            view[idx++] = 0x80 /* 128 */ + (c & 0x3f /* 63 */);
        }
    });
    return buffer;
}

function utf8BufferToString(buffer) {
    if(buffer instanceof ArrayBuffer)
        buffer = new Uint8Array(buffer);
    var chars = [];
    var idx = 0;
    while(idx<buffer.length) {
        var byte = buffer[idx];
        var code = 0;
        if (byte > 251 && byte < 254 && idx + 5 < buffer.length) {
            /* (byte - 252 << 30) may be not safe in ECMAScript! So...: */
            /* six bytes */
            code = (byte - 252) * 1073741824 + (buffer[idx + 1] - 128 << 24) + (buffer[idx + 2] - 128 << 18)
            + (buffer[idx + 3] - 128 << 12) + (buffer[idx + 4] - 128 << 6) + buffer[idx + 5] - 128;
            idx += 6;
        } else if (byte > 247 && byte < 252 && idx + 4 < buffer.length) {
            /* five bytes */
            code = (byte - 248 << 24) + (buffer[idx + 1] - 128 << 18) + (buffer[idx + 2] - 128 << 12)
            + (buffer[idx + 3] - 128 << 6) + buffer[idx + 4] - 128;
            idx += 5;
        } else if (byte > 239 && byte < 248 && idx + 3 < buffer.length) {
            /* four bytes */
            code = (byte - 240 << 18) + (buffer[idx + 1] - 128 << 12) + (buffer[idx + 2] - 128 << 6)
            + buffer[idx + 3] - 128;
            idx += 4;
        } else if (byte > 223 && byte < 240 && idx + 2 < buffer.length) {
            /* three bytes */
            code = (byte - 224 << 12) + (buffer[idx + 1] - 128 << 6) + buffer[idx + 2] - 128;
            idx += 3;
        } else if (byte > 191 && byte < 224 && idx + 1 < buffer.length) {
            /* two bytes */
            code = (byte - 192 << 6) + buffer[idx + 1] - 128;
            idx += 2;
        } else {
            /* one byte */
            code = byte;
            idx += 1;
        }
        chars.push(String.fromCharCode(code));
    }
    return chars.join("");
};


function multiplyArray(items, count) {
    var result = [];
    while(--count>=0) {
        result = result.concat(items);
    }
    return result;
}

function decimalToString(d) {
    // mimic 0.0######
    var s = d.toString();
    var i = s.indexOf('.');
    if(i>=0) {
        // fix IEEE issue
        i = s.indexOf('000000', i);
        if( i < 0)
            return s;
        else
            return s.substr(0, i);
    } else
        return s + ".0";
}

function isABoolean(o) {
    return typeof(o) === "boolean";
}

function isAnInteger(o) {
    return typeof(o) === "number" && Number.isInteger(o);
}

function isADecimal(o) {
    return typeof(o) === "number" && !Number.isInteger(o);
}

function isAText(o) {
    return typeof(o) === 'string' || o instanceof String;
}

function isACharacter(o) {
    return isAText(o) && o.length===1;
}

function isCharacterUpperCase(char) {
    return !!/[A-Z]/.exec(char[0]);
}

function compareValues(value1, value2) {
    if(value1==null && value2==null) {
        return 0;
    } else if(value1==null) {
        return -1;
    } else if(value2==null) {
        return 1;
    } else if(value1.compareTo) {
        return value1.compareTo(value2);
    } else if(value2.compareTo) {
        return -value2.compareTo(value1);
    } else {
        var s1 = value1.toString();
        var s2 = value2.toString();
        return s1 > s2 ? 1 : s1 == s2 ? 0 : -1;
    }
};

exports.multiplyArray = multiplyArray;
exports.equalObjects = equalObjects;
exports.equalArrays = equalArrays;
exports.arrayContains = arrayContains;
exports.removeAccents = removeAccents;
exports.getUtf8StringLength = getUtf8StringLength;
exports.getUtf8CharLength = getUtf8CharLength;
exports.stringToUtf8Buffer = stringToUtf8Buffer;
exports.utf8BufferToString = utf8BufferToString;
exports.decimalToString = decimalToString;
exports.isABoolean = isABoolean;
exports.isAnInteger = isAnInteger;
exports.isADecimal = isADecimal;
exports.isAText = isAText;
exports.isACharacter = isACharacter;
exports.isCharacterUpperCase = isCharacterUpperCase;
exports.compareValues = compareValues;

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var CharacterValue = __webpack_require__(93).CharacterValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var TextType = __webpack_require__(6).TextType;
var IndexOutOfRangeError = __webpack_require__(179).IndexOutOfRangeError;
var removeAccents = __webpack_require__(16).removeAccents;

function TextValue(value) {
	Value.call(this, TextType.instance);
	this.value = value;
	return this;
}

TextValue.prototype = Object.create(Value.prototype);
TextValue.prototype.constructor = TextValue;

TextValue.prototype.getStorableData = function() {
    return this.value;
};

TextValue.prototype.getValue = function() {
	return this.value;
};

TextValue.prototype.toString = function() {
	return this.value;
};

TextValue.prototype.Add = function(context, value) {
	return new TextValue(this.value + value.toString());
};

TextValue.prototype.Multiply = function(context, value) {
    if (value instanceof IntegerValue) {
        try {
            var text = this.value.repeat(value.value);
            return new TextValue(text);
        } catch(error) {
            throw new SyntaxError("Negative repeat count:" + count);
        }
	} else {
		throw new SyntaxError("Illegal: Chararacter * " + typeof(value));
	}
};

TextValue.prototype.CompareTo = function(context, value) {
	if(value instanceof TextValue || value instanceof CharacterValue) {
		return this.value > value.value ? 1 : this.value == value.value ? 0 : -1;
	} else {
		throw new SyntaxError("Illegal: Compare TextValue with " + typeof(value));
	}
};

TextValue.prototype.hasItem = function(context, value) {
	if (value instanceof CharacterValue || value instanceof TextValue) {
		return this.value.indexOf(value.value) >= 0;
	} else {
		throw new SyntaxError("Illegal contains: TextValue + " + typeof(value));
	}
};


TextValue.prototype.getMemberValue = function(context, name) {
	if ("count"==name) {
		return new IntegerValue(this.value.length);
	} else {
        return Value.prototype.getMemberValue.call(this, context, name);
	}
};

TextValue.prototype.getItemInContext = function(context, index) {
	try {
		if (index instanceof IntegerValue) {
			return new CharacterValue(this.value[index.IntegerValue() - 1]);
		} else {
			throw new InvalidDataError("No such item:" + index.toString());
		}
	} catch (e) {
		if(e instanceof IndexOutOfBoundsException) {
			throw new IndexOutOfRangeError();
		} else {
			throw e;
		}
	}

}

TextValue.prototype.getIterator = function(context) {
	return new TextIterator(this.value);
};

function TextIterator(value) {
	this.index = -1;
	this.value = value;
	return this;
}

TextIterator.prototype.hasNext = function() {
	return this.index < this.value.length - 1;
};

TextIterator.prototype.next = function() {
	return new CharacterValue(this.value[++this.index]);
};


TextValue.prototype.convertToJavaScript = function() {
	return this.value;
};

TextValue.prototype.slice = function(fi, li) {
	var first = this.checkFirst(fi);
	var last = this.checkLast(li);
	return new TextValue(this.value.slice(first - 1, last));
};

TextValue.prototype.checkFirst = function(fi) {
	var value = (fi == null) ? 1 : fi.IntegerValue();
	if (value < 1 || value > this.value.length) {
		throw new IndexOutOfRangeError();
	}
	return value;
};

TextValue.prototype.checkLast = function(li) {
	var value = (li == null) ? this.value.length : li.IntegerValue();
	if (value < 0) {
		value = this.value.length + 1 + li.IntegerValue();
	}
	if (value < 1 || value > this.value.length) {
		throw new IndexOutOfRangeError();
	}
	return value;
};

TextValue.prototype.equals = function(obj) {
	if (obj instanceof TextValue) {
		return this.value == obj.value;
	} else {
		return false;
	}
};

TextValue.prototype.Roughly = function(context, obj) {
    if (obj instanceof TextValue || obj instanceof CharacterValue) {
        return removeAccents(this.value.toLowerCase()) == removeAccents(obj.value.toLowerCase());
    } else {
        return false;
    }
};


TextValue.prototype.Contains = function(context, obj) {
    if (obj instanceof TextValue || obj instanceof CharacterValue) {
        return this.value.indexOf(obj.value) >= 0;
    } else {
        return false;
    }
};


TextValue.prototype.toJson = function(context, json, instanceId, fieldName, withType, binaries) {
    if(Array.isArray(json))
        json.push(this.value);
    else
        json[fieldName] = this.value;
};

exports.TextValue = TextValue;




/***/ }),
/* 18 */
/***/ (function(module, exports) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
//

// A token has properties: text, type, line, character position in the line
// (so we can ignore tabs), token channel, index, and source from which
// we obtained this token.

function Token() {
	this.source = null;
	this.type = null; // token type of the token
	this.channel = null; // The parser ignores everything not on DEFAULT_CHANNEL
	this.start = null; // optional; return -1 if not implemented.
	this.stop = null; // optional; return -1 if not implemented.
	this.tokenIndex = null; // from 0..n-1 of the token object in the input stream
	this.line = null; // line=1..n of the 1st character
	this.column = null; // beginning of the line at which it occurs, 0..n-1
	this._text = null; // text of the token.
	return this;
}

Token.INVALID_TYPE = 0;

// During lookahead operations, this "token" signifies we hit rule end ATN state
// and did not follow it despite needing to.
Token.EPSILON = -2;

Token.MIN_USER_TOKEN_TYPE = 1;

Token.EOF = -1;

// All tokens go to the parser (unless skip() is called in that rule)
// on a particular "channel". The parser tunes to a particular channel
// so that whitespace etc... can go to the parser on a "hidden" channel.

Token.DEFAULT_CHANNEL = 0;

// Anything on different channel than DEFAULT_CHANNEL is not parsed
// by parser.

Token.HIDDEN_CHANNEL = 1;

// Explicitly set the text for this token. If {code text} is not
// {@code null}, then {@link //getText} will return this value rather than
// extracting the text from the input.
//
// @param text The explicit text of the token, or {@code null} if the text
// should be obtained from the input along with the start and stop indexes
// of the token.

Object.defineProperty(Token.prototype, "text", {
	get : function() {
		return this._text;
	},
	set : function(text) {
		this._text = text;
	}
});

Token.prototype.getTokenSource = function() {
	return this.source[0];
};

Token.prototype.getInputStream = function() {
	return this.source[1];
};

function CommonToken(source, type, channel, start, stop) {
	Token.call(this);
	this.source = source !== undefined ? source : CommonToken.EMPTY_SOURCE;
	this.type = type !== undefined ? type : null;
	this.channel = channel !== undefined ? channel : Token.DEFAULT_CHANNEL;
	this.start = start !== undefined ? start : -1;
	this.stop = stop !== undefined ? stop : -1;
	this.tokenIndex = -1;
	if (this.source[0] !== null) {
		this.line = source[0].line;
		this.column = source[0].column;
	} else {
		this.column = -1;
	}
	return this;
}

CommonToken.prototype = Object.create(Token.prototype);
CommonToken.prototype.constructor = CommonToken;

// An empty {@link Pair} which is used as the default value of
// {@link //source} for tokens that do not have a source.
CommonToken.EMPTY_SOURCE = [ null, null ];

// Constructs a new {@link CommonToken} as a copy of another {@link Token}.
//
// <p>
// If {@code oldToken} is also a {@link CommonToken} instance, the newly
// constructed token will share a reference to the {@link //text} field and
// the {@link Pair} stored in {@link //source}. Otherwise, {@link //text} will
// be assigned the result of calling {@link //getText}, and {@link //source}
// will be constructed from the result of {@link Token//getTokenSource} and
// {@link Token//getInputStream}.</p>
//
// @param oldToken The token to copy.
//
CommonToken.prototype.clone = function() {
	var t = new CommonToken(this.source, this.type, this.channel, this.start,
			this.stop);
	t.tokenIndex = this.tokenIndex;
	t.line = this.line;
	t.column = this.column;
	t.text = this.text;
	return t;
};

Object.defineProperty(CommonToken.prototype, "text", {
	get : function() {
		if (this._text !== null) {
			return this._text;
		}
		var input = this.getInputStream();
		if (input === null) {
			return null;
		}
		var n = input.size;
		if (this.start < n && this.stop < n) {
			return input.getText(this.start, this.stop);
		} else {
			return "<EOF>";
		}
	},
	set : function(text) {
		this._text = text;
	}
});

CommonToken.prototype.toString = function() {
	var txt = this.text;
	if (txt !== null) {
		txt = txt.replace(/\n/g, "\\n").replace(/\r/g, "\\r").replace(/\t/g, "\\t");
	} else {
		txt = "<no text>";
	}
	return "[@" + this.tokenIndex + "," + this.start + ":" + this.stop + "='" +
			txt + "',<" + this.type + ">" +
			(this.channel > 0 ? ",channel=" + this.channel : "") + "," +
			this.line + ":" + this.column + "]";
};

exports.Token = Token;
exports.CommonToken = CommonToken;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

var Location = __webpack_require__(358).Location;

function Section(section) {
    if(!section)
        section = { path : "", start : null, end : null, dialect : null, breakpoint : null };
    this.copySectionFrom(section);
	return this;
}

Section.prototype.copySectionFrom = function(section) {
    this.path = section.path;
    this.start = section.start;
    this.end = section.end;
    this.dialect = section.dialect;
    this.breakpoint = section.breakpoint;
};

Section.prototype.setSectionFrom = function(path, start, end, dialect) {
	this.path = path;
	this.start = new Location(start);
	this.end = new Location(end, true);
    this.dialect = dialect;
	this.breakpoint = false;
};
	
exports.Section = Section;

/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

var BooleanType = __webpack_require__(5).BooleanType;
var Value = __webpack_require__(1).Value;

function BooleanValue(value) {
	Value.call(this, BooleanType.instance);
	this.value = value;
	return this;
}

BooleanValue.prototype = Object.create(Value.prototype);
BooleanValue.prototype.constructor = BooleanValue;

BooleanValue.TRUE = new BooleanValue(true);
BooleanValue.FALSE = new BooleanValue(false);
BooleanValue.TRUE.not = BooleanValue.FALSE;
BooleanValue.FALSE.not = BooleanValue.TRUE;

BooleanValue.ValueOf = function(value) {
	return value ? BooleanValue.TRUE : BooleanValue.FALSE;
};

BooleanValue.Parse = function(text) {
	var bool = text==="true";
	return BooleanValue.ValueOf(bool);
};

BooleanValue.prototype.getValue = function() {
	return this.value;
};

BooleanValue.prototype.And = function(value) {
	if(value instanceof BooleanValue) {
		return BooleanValue.ValueOf(this.value && value.value);
	} else {
		throw new SyntaxError("Illegal: Boolean and " + typeof(value));
	}
	return this.value;
};

BooleanValue.prototype.Or = function(value) {
	if(value instanceof BooleanValue) {
		return BooleanValue.ValueOf(this.value || value.value);
	} else {
		throw new SyntaxError("Illegal: Boolean or " + typeof(value));
	}
	return this.value;
};

BooleanValue.prototype.Not = function() {
	return this.not;
};

/*
public Boolean getNot() {
	return not;
}

public int CompareTo(Context context, IValue value) throws SyntaxError {
	if (value instanceof Boolean)
		return compareTo((Boolean) value);
	else
		throw new SyntaxError("Illegal comparison: Boolean + " + value.getClass().getSimpleName());
}

public int compareTo(Boolean other) {
	return java.lang.Boolean.compare(this.value, other.value);
}

public Object ConvertTo(Class<?> type) {
	return value;
}
*/

BooleanValue.prototype.toString = function() {
	return this.value.toString();
};

BooleanValue.prototype.equals = function(obj) {
	if (obj instanceof BooleanValue) {
		return this.value == obj.value;
	} else {
		return false;
	}
};

exports.BooleanValue = BooleanValue;


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var NullType = __webpack_require__(113).NullType;

function NullValue() {
    Value.call(this, NullType.instance);
    return this;
}

NullValue.prototype = Object.create(Value.prototype);
NullValue.prototype.constructor = NullValue;

NullValue.prototype.toString = function() {
    return "null";
};

NullValue.prototype.getStorableData = function() {
    return null; // <- YES!
};

NullValue.prototype.convertToJavaScript = function() {
    return null; // <- YES!
};

NullValue.instance = new NullValue();

exports.NullValue = NullValue;


/***/ }),
/* 22 */
/***/ (function(module, exports) {

function ObjectList(items, item) {
	Array.call(this);
	items = items || null;
	if(items!==null) {
		this.addAll(items);
	}
    item = item || null;
    if(item!==null) {
        this.add(item);
    }
	return this;
}

ObjectList.prototype = Object.create(Array.prototype);
ObjectList.prototype.constructor = ObjectList;

ObjectList.prototype.addAll = function(items) {
	this.push.apply(this, items);
};

ObjectList.prototype.add = function(item) {
	if(item)
        this.push(item);
};

ObjectList.prototype.insert = function(before, item) {
	this.splice(0, 0, item);
};

ObjectList.prototype.remove = function(index) {
	this.splice(index, 1);
};

ObjectList.prototype.toString = function() {
	return this.join(", ");
};


exports.ObjectList = ObjectList;


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var BooleanType = __webpack_require__(5).BooleanType;
var IntegerType = null; // circular dependency
var AnyType = __webpack_require__(14).AnyType;
var DecimalValue = __webpack_require__(33).DecimalValue;
var Identifier = __webpack_require__(0).Identifier;

exports.resolve = function() {
	IntegerType = __webpack_require__(2).IntegerType;
}

function DecimalType()  {
	NativeType.call(this, new Identifier("Decimal"));
	return this;
}

DecimalType.prototype = Object.create(NativeType.prototype);
DecimalType.prototype.constructor = DecimalType;

DecimalType.instance = new DecimalType();


DecimalType.prototype.declare = function(transpiler) {
    var isADecimal = __webpack_require__(16).isADecimal;
    transpiler.require(isADecimal);
};


DecimalType.prototype.transpile = function(transpiler) {
    transpiler.append('"Decimal"')
};


DecimalType.prototype.isAssignableFrom = function(context, other) {
    return NativeType.prototype.isAssignableFrom.call(this, context, other)
        || (other == IntegerType.instance);
};


DecimalType.prototype.checkAdd = function(context, other, tryReverse) {
	if(other === IntegerType.instance || other === DecimalType.instance) {
		return this;
	} else {
		return NativeType.prototype.checkAdd.call(this, context, other, tryReverse);
	}
};


DecimalType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareAdd.call(this, context, other, tryReverse, left, right);
};


DecimalType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        left.transpile(transpiler);
        transpiler.append(" + ");
        right.transpile(transpiler);
    } else
        return NativeType.prototype.transpileAdd.call(this, context, other, tryReverse, left, right);
};


DecimalType.prototype.checkSubtract = function(context, other) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
		return this;
	} else {
		return NativeType.prototype.checkSubtract.call(this, context, other);
	}
};


DecimalType.prototype.declareSubtract = function(transpiler, other, left, right) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareSubtract.call(this, transpiler, other, left, right);
};


DecimalType.prototype.transpileSubtract = function(transpiler, other, left, right) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        left.transpile(transpiler);
        transpiler.append(" - ");
        right.transpile(transpiler);
    } else
        return NativeType.prototype.transpileSubtract.call(this, transpiler, other, left, right);
};


DecimalType.prototype.checkMultiply = function(context, other, tryReverse) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
		return this;
	} else {
		return NativeType.prototype.checkMultiply.call(this, context, other, tryReverse);
	}
};


DecimalType.prototype.declareMultiply = function(transpiler, other, tryReverse, left, right) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareMultiply.call(this, transpiler, other, tryReverse, left, right);
};


DecimalType.prototype.transpileMultiply = function(transpiler, other, tryReverse, left, right) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        left.transpile(transpiler);
        transpiler.append(" * ");
        right.transpile(transpiler);
    } else
        return NativeType.prototype.transpileMultiply.call(this, transpiler, other, tryReverse, left, right);
};


DecimalType.prototype.checkDivide = function(context, other) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
		return this;
	} else {
		return NativeType.prototype.checkDivide.call(this, context, other);
	}
};

DecimalType.prototype.declareDivide = function(transpiler, other, left, right) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareDivide.call(this, transpiler, other, left, right);
};


DecimalType.prototype.transpileDivide = function(transpiler, other, left, right) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        transpiler.append("divide(");
        left.transpile(transpiler);
        transpiler.append(", ");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileDivide.call(this, transpiler, other, left, right);
};


DecimalType.prototype.checkIntDivide = function(context, other) {
    if(other === IntegerType.instance) {
        return IntegerType.instance;
    } else {
        return NativeType.prototype.checkIntDivide.call(this, context, other);
    }
};


DecimalType.prototype.declareIntDivide = function(transpiler, other, left, right) {
    if(other === IntegerType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareIntDivide.call(this, transpiler, other, left, right);
};


DecimalType.prototype.transpileIntDivide = function(transpiler, other, left, right) {
    if (other === IntegerType.instance ) {
        transpiler.append("Math.floor(divide(");
        left.transpile(transpiler);
        transpiler.append(", ");
        right.transpile(transpiler);
        transpiler.append("))");
    } else
        return NativeType.prototype.transpileIntDivide.call(this, transpiler, other, left, right);
};


DecimalType.prototype.checkModulo = function(context, other) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        return this;
    } else {
        return NativeType.prototype.checkModulo.call(this, context, other);
    }
};


DecimalType.prototype.declareModulo = function(transpiler, other, left, right) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        return;
    } else {
        return NativeType.prototype.declareModulo.call(this, transpiler, other, left, right);
    }
};


DecimalType.prototype.transpileModulo = function(transpiler, other, left, right) {
    if(other === IntegerType.instance || other === DecimalType.instance) {
        left.transpile(transpiler);
        transpiler.append(" % ");
        right.transpile(transpiler);
    } else
        return NativeType.prototype.transpileModulo.call(this, transpiler, other, left, right);
};

DecimalType.prototype.checkMinus = function(context) {
	return this;
};


DecimalType.prototype.declareMinus = function(transpiler, value) {
    // nothing to do
};


DecimalType.prototype.transpileMinus = function(transpiler, value) {
    transpiler.append(" -");
    value.transpile(transpiler);
};


DecimalType.prototype.transpileMember = function(transpiler, name) {
    if("text" == name)
        transpiler.append("toDecimalString()");
    else
        NativeType.prototype.transpileMember.call(this, transpiler, name);
};


DecimalType.prototype.checkCompare = function(context, other) {
	if(other instanceof IntegerType || other instanceof DecimalType) {
		return BooleanType.instance;
	} else {
		return NativeType.prototype.checkCompare.call(this, context, other);
	}
};


DecimalType.prototype.declareCompare = function(context, other) {
    // nothing to do
};

DecimalType.prototype.transpileCompare = function(transpiler, other, operator, left, right) {
    left.transpile(transpiler);
    transpiler.append(" ").append(operator.toString()).append(" ");
    right.transpile(transpiler);
};


DecimalType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
    if (typeof(value)=='number') {
        return new DecimalValue(value);
    } else {
        return value; // TODO for now
    }
};

exports.DecimalType = DecimalType;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

var Section = __webpack_require__(19).Section;

function Literal(text, value) {
    Section.call(this);
	this.text = text;
	this.value = value;
	return this;
}

Literal.prototype = Object.create(Section.prototype);
Literal.prototype.constructor = Section;

Literal.prototype.toDialect = function(writer) {
    writer.append(this.escapedText(writer.escapeMode));
};

Literal.prototype.escapedText = function(escapeMode) {
    if(escapeMode)
        return this.text.replace(/\'/g, "\\'");
    else
        return this.text;
};

Literal.prototype.toString = function() {
	return this.text;
};

Literal.prototype.transpile = function(transpiler) {
    throw new Error("Transpile not implemented by " + this.constructor.name);
};

Literal.prototype.getValue = function() {
	return this.value;
};

Literal.prototype.interpret = function(context) {
	return this.value;
};

exports.Literal = Literal;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

/*jslint smarttabs:true */

var Token = __webpack_require__(18).Token;

/* stop is not included! */
function Interval(start, stop) {
	this.start = start;
	this.stop = stop;
	return this;
}

Interval.prototype.contains = function(item) {
	return item >= this.start && item < this.stop;
};

Interval.prototype.toString = function() {
	if(this.start===this.stop-1) {
		return this.start.toString();
	} else {
		return this.start.toString() + ".." + (this.stop-1).toString();
	}
};


Object.defineProperty(Interval.prototype, "length", {
	get : function() {
		return this.stop - this.start;
	}
});

function IntervalSet() {
	this.intervals = null;
	this.readOnly = false;
}

IntervalSet.prototype.first = function(v) {
	if (this.intervals === null || this.intervals.length===0) {
		return Token.INVALID_TYPE;
	} else {
		return this.intervals[0].start;
	}
};

IntervalSet.prototype.addOne = function(v) {
	this.addInterval(new Interval(v, v + 1));
};

IntervalSet.prototype.addRange = function(l, h) {
	this.addInterval(new Interval(l, h + 1));
};

IntervalSet.prototype.addInterval = function(v) {
	if (this.intervals === null) {
		this.intervals = [];
		this.intervals.push(v);
	} else {
		// find insert pos
		for (var k = 0; k < this.intervals.length; k++) {
			var i = this.intervals[k];
			// distinct range -> insert
			if (v.stop < i.start) {
				this.intervals.splice(k, 0, v);
				return;
			}
			// contiguous range -> adjust
			else if (v.stop === i.start) {
				this.intervals[k].start = v.start;
				return;
			}
			// overlapping range -> adjust and reduce
			else if (v.start <= i.stop) {
				this.intervals[k] = new Interval(Math.min(i.start, v.start), Math.max(i.stop, v.stop));
				this.reduce(k);
				return;
			}
		}
		// greater than any existing
		this.intervals.push(v);
	}
};

IntervalSet.prototype.addSet = function(other) {
	if (other.intervals !== null) {
		for (var k = 0; k < other.intervals.length; k++) {
			var i = other.intervals[k];
			this.addInterval(new Interval(i.start, i.stop));
		}
	}
	return this;
};

IntervalSet.prototype.reduce = function(k) {
	// only need to reduce if k is not the last
	if (k < this.intervalslength - 1) {
		var l = this.intervals[k];
		var r = this.intervals[k + 1];
		// if r contained in l
		if (l.stop >= r.stop) {
			this.intervals.pop(k + 1);
			this.reduce(k);
		} else if (l.stop >= r.start) {
			this.intervals[k] = new Interval(l.start, r.stop);
			this.intervals.pop(k + 1);
		}
	}
};

IntervalSet.prototype.complement = function(start, stop) {
    var result = new IntervalSet();
    result.addInterval(new Interval(start,stop+1));
    for(var i=0; i<this.intervals.length; i++) {
        result.removeRange(this.intervals[i]);
    }
    return result;
};

IntervalSet.prototype.contains = function(item) {
	if (this.intervals === null) {
		return false;
	} else {
		for (var k = 0; k < this.intervals.length; k++) {
			if(this.intervals[k].contains(item)) {
				return true;
			}
		}
		return false;
	}
};

Object.defineProperty(IntervalSet.prototype, "length", {
	get : function() {
		var len = 0;
		this.intervals.map(function(i) {len += i.length;});
		return len;
	}
});

IntervalSet.prototype.removeRange = function(v) {
    if(v.start===v.stop-1) {
        this.removeOne(v.start);
    } else if (this.intervals!==null) {
        var k = 0;
        for(var n=0; n<this.intervals.length; n++) {
            var i = this.intervals[k];
            // intervals are ordered
            if (v.stop<=i.start) {
                return;
            }
            // check for including range, split it
            else if(v.start>i.start && v.stop<i.stop) {
                this.intervals[k] = new Interval(i.start, v.start);
                var x = new Interval(v.stop, i.stop);
                this.intervals.splice(k, 0, x);
                return;
            }
            // check for included range, remove it
            else if(v.start<=i.start && v.stop>=i.stop) {
                this.intervals.splice(k, 1);
                k = k - 1; // need another pass
            }
            // check for lower boundary
            else if(v.start<i.stop) {
                this.intervals[k] = new Interval(i.start, v.start);
            }
            // check for upper boundary
            else if(v.stop<i.stop) {
                this.intervals[k] = new Interval(v.stop, i.stop);
            }
            k += 1;
        }
    }
};

IntervalSet.prototype.removeOne = function(v) {
	if (this.intervals !== null) {
		for (var k = 0; k < this.intervals.length; k++) {
			var i = this.intervals[k];
			// intervals is ordered
			if (v < i.start) {
				return;
			}
			// check for single value range
			else if (v === i.start && v === i.stop - 1) {
				this.intervals.splice(k, 1);
				return;
			}
			// check for lower boundary
			else if (v === i.start) {
				this.intervals[k] = new Interval(i.start + 1, i.stop);
				return;
			}
			// check for upper boundary
			else if (v === i.stop - 1) {
				this.intervals[k] = new Interval(i.start, i.stop - 1);
				return;
			}
			// split existing range
			else if (v < i.stop - 1) {
				var x = new Interval(i.start, v);
				i.start = v + 1;
				this.intervals.splice(k, 0, x);
				return;
			}
		}
	}
};

IntervalSet.prototype.toString = function(literalNames, symbolicNames, elemsAreChar) {
	literalNames = literalNames || null;
	symbolicNames = symbolicNames || null;
	elemsAreChar = elemsAreChar || false;
	if (this.intervals === null) {
		return "{}";
	} else if(literalNames!==null || symbolicNames!==null) {
		return this.toTokenString(literalNames, symbolicNames);
	} else if(elemsAreChar) {
		return this.toCharString();
	} else {
		return this.toIndexString();
	}
};

IntervalSet.prototype.toCharString = function() {
	var names = [];
	for (var i = 0; i < this.intervals.length; i++) {
		var v = this.intervals[i];
		if(v.stop===v.start+1) {
			if ( v.start===Token.EOF ) {
				names.push("<EOF>");
			} else {
				names.push("'" + String.fromCharCode(v.start) + "'");
			}
		} else {
			names.push("'" + String.fromCharCode(v.start) + "'..'" + String.fromCharCode(v.stop-1) + "'");
		}
	}
	if (names.length > 1) {
		return "{" + names.join(", ") + "}";
	} else {
		return names[0];
	}
};


IntervalSet.prototype.toIndexString = function() {
	var names = [];
	for (var i = 0; i < this.intervals.length; i++) {
		var v = this.intervals[i];
		if(v.stop===v.start+1) {
			if ( v.start===Token.EOF ) {
				names.push("<EOF>");
			} else {
				names.push(v.start.toString());
			}
		} else {
			names.push(v.start.toString() + ".." + (v.stop-1).toString());
		}
	}
	if (names.length > 1) {
		return "{" + names.join(", ") + "}";
	} else {
		return names[0];
	}
};


IntervalSet.prototype.toTokenString = function(literalNames, symbolicNames) {
	var names = [];
	for (var i = 0; i < this.intervals.length; i++) {
		var v = this.intervals[i];
		for (var j = v.start; j < v.stop; j++) {
			names.push(this.elementName(literalNames, symbolicNames, j));
		}
	}
	if (names.length > 1) {
		return "{" + names.join(", ") + "}";
	} else {
		return names[0];
	}
};

IntervalSet.prototype.elementName = function(literalNames, symbolicNames, a) {
	if (a === Token.EOF) {
		return "<EOF>";
	} else if (a === Token.EPSILON) {
		return "<EPSILON>";
	} else {
		return literalNames[a] || symbolicNames[a];
	}
};

exports.Interval = Interval;
exports.IntervalSet = IntervalSet;


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

var ContainerType = __webpack_require__(61).ContainerType;
var SetType = null;
var IntegerType = null;
var BooleanType = __webpack_require__(5).BooleanType;
var Identifier = __webpack_require__(0).Identifier;
var ListValue = __webpack_require__(36).ListValue;
var Variable = __webpack_require__(10).Variable;
var List = __webpack_require__(29).List;

exports.resolve = function() {
    IntegerType = __webpack_require__(2).IntegerType;
    SetType = __webpack_require__(65).SetType;
};

function ListType(itemType) {
    ContainerType.call(this, new Identifier(itemType.name+"[]"), itemType);
	return this;
}
	
ListType.prototype = Object.create(ContainerType.prototype);
ListType.prototype.constructor = ListType;


ListType.prototype.withItemType = function(itemType) {
    return new ListType(itemType);
};


ListType.prototype.declare = function(transpiler) {
    transpiler.register(List);
    this.itemType.declare(transpiler);
};


ListType.prototype.transpile = function(transpiler) {
    transpiler.append('List')
};


ListType.prototype.getTranspiledName = function(context) {
    return this.itemType.getTranspiledName(context) + "_list";
};


ListType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
    var values = value.map(function(item) {
        return this.itemType.convertJavaScriptValueToPromptoValue(context, item, null);
    }, this);
    return new ListValue(this.itemType, values);
};

ListType.prototype.isAssignableFrom = function(context, other) {
    return ContainerType.prototype.isAssignableFrom.call(this, context, other)
        || ((other instanceof ListType) && this.itemType.isAssignableFrom(context, other.itemType));
};

ListType.prototype.equals = function(obj) {
	if(obj===this) {
		return true;
	}
	if(obj===null) {
		return false;
	}
	if(!(obj instanceof ListType)) {
		return false;
	}
	return this.itemType.equals(obj.itemType);
};

ListType.prototype.checkAdd = function(context, other, tryReverse) {
	if((other instanceof ListType || other instanceof SetType) && this.itemType.equals(other.itemType)) {
		return this;
	} else {
		return ContainerType.prototype.checkAdd.call(this, context, other, tryReverse);
	}
};


ListType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if((other instanceof ListType || other instanceof SetType) && this.itemType.equals(other.itemType)) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else {
        return ContainerType.prototype.declareAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};


ListType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if((other instanceof ListType || other instanceof SetType) && this.itemType.equals(other.itemType)) {
        left.transpile(transpiler);
        transpiler.append(".add(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else {
        return ContainerType.prototype.transpileAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};


ListType.prototype.checkSubtract= function(context, other) {
    if((other instanceof ListType || other instanceof SetType) && this.itemType.equals(other.itemType)) {
        return this;
    } else {
        return ContainerType.prototype.checkSubtract.call(this, context, other);
    }
};


ListType.prototype.declareSubtract = function(transpiler, other, left, right) {
    if((other instanceof ListType || other instanceof SetType) && this.itemType.equals(other.itemType)) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else {
        return ContainerType.prototype.declareSubtract.call(this, transpiler, other, left, right);
    }
};


ListType.prototype.transpileSubtract = function(transpiler, other, left, right) {
    if((other instanceof ListType || other instanceof SetType) && this.itemType.equals(other.itemType)) {
        left.transpile(transpiler);
        transpiler.append(".remove(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else {
        return ContainerType.prototype.transpileSubtract.call(this, transpiler, other, tryReverse, left, right);
    }
};


ListType.prototype.checkItem = function(context, itemType) {
	if(itemType==IntegerType.instance) {
		return this.itemType;
	} else {
		return ContainerType.prototype.checkItem.call(this, context, itemType);
	}
};

ListType.prototype.declareItem = function(transpiler, itemType, item) {
    if(itemType===IntegerType.instance) {
        item.declare(transpiler);
    } else {
        return ContainerType.prototype.declareItem.call(this, transpiler, itemType, item);
    }
};


ListType.prototype.transpileItem = function(transpiler, itemType, item) {
    if(itemType===IntegerType.instance) {
        transpiler.append(".item(");
        item.transpile(transpiler);
        transpiler.append(")");
    } else {
        return ContainerType.prototype.transpileItem.call(this, transpiler, itemType, item);
    }
};


ListType.prototype.transpileAssignItemValue = function(transpiler, item, expression) {
    transpiler.append(".setItem(");
    item.transpile(transpiler);
    transpiler.append(", ");
    expression.transpile(transpiler);
    transpiler.append(")");
};


ListType.prototype.checkMultiply = function(context, other, tryReverse) {
	if(other === IntegerType.instance) {
		return this;
	} else {
		return ContainerType.prototype.checkMultiply.call(this, context, other, tryReverse);
	}
};


ListType.prototype.declareMultiply = function(transpiler, other, tryReverse, left, right) {
    if(other === IntegerType.instance) {
        var multiplyArray = __webpack_require__(16).multiplyArray;
        transpiler.require(multiplyArray);
        left.declare(transpiler);
        right.declare(transpiler);
    } else {
        return ContainerType.prototype.declareMultiply.call(this, transpiler, other, tryReverse, left, right);
    }
};


ListType.prototype.transpileMultiply = function(transpiler, other, tryReverse, left, right) {
    if(other === IntegerType.instance) {
        transpiler.append("multiplyArray(");
        left.transpile(transpiler);
        transpiler.append(",");
        right.transpile(transpiler);
        transpiler.append(")");
    } else {
        return ContainerType.prototype.transpileMultiply.call(this, transpiler, other, tryReverse, left, right);
    }
};

ListType.prototype.checkSlice = function(context) {
	return this;
};


ListType.prototype.declareSlice = function(transpiler, first, last) {
    // nothing to do
};


ListType.prototype.transpileSlice = function(transpiler, first, last) {
    transpiler.append(".slice1Based(");
    if(first) {
        first.transpile(transpiler);
    } else
        transpiler.append("null");
    if(last) {
        transpiler.append(",");
        last.transpile(transpiler);
    }
    transpiler.append(")");
};


ListType.prototype.declareContains = function(transpiler, other, container, item) {
    container.declare(transpiler);
    item.declare(transpiler);
};


ListType.prototype.transpileContains = function(transpiler, other, container, item) {
    container.transpile(transpiler);
    transpiler.append(".includes(");
    item.transpile(transpiler);
    transpiler.append(")");
};


ListType.prototype.checkContainsAllOrAny = function(context, other) {
	return BooleanType.instance;
};

ListType.prototype.declareContainsAllOrAny = function(transpiler, other, container, items) {
    var StrictSet = __webpack_require__(34).StrictSet;
    transpiler.require(StrictSet);
    container.declare(transpiler);
    items.declare(transpiler);
};


ListType.prototype.transpileContainsAll = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAll(");
    items.transpile(transpiler);
    transpiler.append(")");
};


ListType.prototype.transpileContainsAny = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAny(");
    items.transpile(transpiler);
    transpiler.append(")");
};

ListType.prototype.checkIterator = function(context, source) {
	return this.itemType;
};





exports.ListType = ListType;


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

var MethodCall = __webpack_require__(62).MethodCall;
var EnumeratedCategoryDeclaration = null;
var CategoryDeclaration = null;
var EnumeratedNativeDeclaration = __webpack_require__(77).EnumeratedNativeDeclaration;
var ConstructorExpression = null;
var InstanceExpression = __webpack_require__(41).InstanceExpression;
var SymbolExpression = __webpack_require__(182).SymbolExpression;
var TypeExpression = __webpack_require__(183).TypeExpression;
var ProblemListener = __webpack_require__(73).ProblemListener;
var PromptoError = __webpack_require__(30).PromptoError;
var Section = __webpack_require__(19).Section;
var Dialect = __webpack_require__(8).Dialect;
var VoidType = __webpack_require__(4).VoidType;
var EnumeratedCategoryType = null;
var CategoryType = null;
var MethodSelector = null;

exports.resolve = function() {
    EnumeratedCategoryDeclaration = __webpack_require__(92).EnumeratedCategoryDeclaration;
    EnumeratedCategoryType = __webpack_require__(112).EnumeratedCategoryType;
	MethodSelector = __webpack_require__(53).MethodSelector;
    CategoryType = __webpack_require__(7).CategoryType;
	CategoryDeclaration = __webpack_require__(45).CategoryDeclaration;
	ConstructorExpression = __webpack_require__(106).ConstructorExpression;
}

function UnresolvedIdentifier(id) {
    Section.call(this);
	this.id = id;
	this.resolved = null;
	return this;
}

UnresolvedIdentifier.prototype = Object.create(Section.prototype);
UnresolvedIdentifier.prototype.constructor = UnresolvedIdentifier;

Object.defineProperty(UnresolvedIdentifier.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});

UnresolvedIdentifier.prototype.toString = function() {
	return this.id.name;
};


UnresolvedIdentifier.prototype.toDialect = function(writer) {
    try {
        this.resolve(writer.context, false, false);
    } catch(e) {
    }
    if(this.resolved!=null)
        this.resolved.toDialect(writer);
    else
        writer.append(this.id.name);
};

UnresolvedIdentifier.prototype.check = function(context) {
	return this.resolveAndCheck(context, false);
};

UnresolvedIdentifier.prototype.checkMember = function(context) {
	return this.resolveAndCheck(context, true);
};


UnresolvedIdentifier.prototype.interpret = function(context) {
	if(this.resolved==null) {
		this.resolveAndCheck(context, false);
	}
	return this.resolved.interpret(context);
};

UnresolvedIdentifier.prototype.resolveAndCheck = function(context, forMember) {
    this.resolve(context, forMember);
    return this.resolved ? this.resolved.check(context) : VoidType.instance;
};

UnresolvedIdentifier.prototype.resolve = function(context, forMember, updateSelectorParent) {
	if(updateSelectorParent)
        this.resolved = null;
    if(this.resolved==null) {
        // ignore resolution problems during resolution
        var listener = context.problemListener;
        try {
            context.problemListener = new ProblemListener();
            this.resolved = this.doResolve(context, forMember, updateSelectorParent);
        } finally {
            // restore listener
            context.problemListener = listener;
        }
    }
	if(this.resolved==null)
        context.problemListener.reportUnknownIdentifier(this.id);
    return this.resolved;
};


UnresolvedIdentifier.prototype.doResolve = function(context, forMember, updateSelectorParent) {
    var resolved = this.resolveSymbol(context);
    if(resolved)
    	return resolved;
    resolved = this.resolveTypeOrConstructor(context, forMember);
    if(resolved)
        return resolved;
	resolved = this.resolveMethodCall(context, updateSelectorParent);
    if(resolved)
        return resolved;
	resolved = this.resolveInstance(context);
    return resolved;
};


UnresolvedIdentifier.prototype.resolveTypeOrConstructor = function(context, forMember) {
    // is first char uppercase?
    if (this.id.name[0].toUpperCase() != this.id.name[0])
    	return null;
	if (forMember) {
		return this.resolveType(context);
	} else {
		return this.resolveConstructor(context);
	}
};


UnresolvedIdentifier.prototype.resolveInstance = function(context) {
	try {
		var id = new InstanceExpression(this.id);
		id.check(context);
		return id;
	} catch(e) {
		if(e instanceof PromptoError) {
			return null;
		} else {
			throw e;
		}
	}
};

UnresolvedIdentifier.prototype.resolveMethodCall = function(context, updateSelectorParent) {
	if(this.id.dialect!=Dialect.E)
		return null;
	try {
	    var selector = new MethodSelector(null, this.id);
		var call = new MethodCall(selector);
        call.check(context, updateSelectorParent);
		return call;
	} catch(e) {
		if(e instanceof PromptoError) {
			return null;
		} else {
			throw e;
		}
	}
};

UnresolvedIdentifier.prototype.resolveConstructor = function(context) {
	try {
		var method = new ConstructorExpression(new CategoryType(this.id), null, null, true);
		method.check(context);
		return method;
	} catch(e) {
		if(e instanceof PromptoError) {
			return null;
		} else {
			throw e;
		}
	}
};

UnresolvedIdentifier.prototype.resolveType = function(context) {
	var decl = context.getRegisteredDeclaration(this.name);
    if(decl instanceof EnumeratedCategoryDeclaration) {
        return new TypeExpression(new EnumeratedCategoryType(this.id));
    } else if(decl instanceof CategoryDeclaration) {
		return new TypeExpression(new CategoryType(this.id));
	} else if(decl instanceof EnumeratedNativeDeclaration) {
		return new TypeExpression(decl.getType(context));
	} else {
		var allTypes = NativeType.getAll();
		for(var i=0;i<allTypes.length;i++) {
			if (this.name == allTypes[i].name) {
				return new TypeExpression(allTypes[i]);
			}
		}
	}
	return null;
};

UnresolvedIdentifier.prototype.resolveSymbol = function(context) {
	if(this.id.name==this.id.name.toUpperCase()) {
		return new SymbolExpression(this.id);
	} else {
		return null;
	}
};

UnresolvedIdentifier.prototype.declare = function(transpiler) {
    this.resolve(transpiler.context, false, true);
    this.resolved.declare(transpiler);
};

UnresolvedIdentifier.prototype.transpile = function(transpiler) {
    this.resolve(transpiler.context, false, true);
    this.resolved.transpile(transpiler);
};


exports.UnresolvedIdentifier = UnresolvedIdentifier;



/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

var BaseStatement = __webpack_require__(35).BaseStatement;

function SimpleStatement() {
    BaseStatement.call(this);
    return this;
}

SimpleStatement.prototype = Object.create(BaseStatement.prototype);
SimpleStatement.prototype.constructor = SimpleStatement;

SimpleStatement.prototype.isSimple = function() {
    return true;
};

exports.SimpleStatement = SimpleStatement;


/***/ }),
/* 29 */
/***/ (function(module, exports) {

function List(mutable, items) {
    Array.call(this);
    if(items)
        this.addItems(items);
	this.mutable = mutable;
	return this;
}

List.prototype = Object.create(Array.prototype);
List.prototype.constructor = List;

List.prototype.addItems = function(items) {
    if(typeof(StrictSet) !== 'undefined' && items instanceof StrictSet)
    	items = Array.from(items.set.values());
	this.push.apply(this, items);
	return this; // enable fluid API
};


List.prototype.add = function(items) {
    if(typeof(StrictSet) !== 'undefined' && items instanceof StrictSet)
        items = Array.from(items.set.values());
    var concat = new List(false);
    concat.addItems(this);
    concat.addItems(items);
    return concat;
};


List.prototype.remove = function(items) {
    var excluded = (typeof(StrictSet) !== 'undefined' && items instanceof StrictSet) ? items : new Set(items);
    var remaining = this.filter(function(item) { return !excluded.has(item); });
    var concat = new List(false);
    concat.addItems(remaining);
    return concat;
};


List.prototype.sorted = function(sortFunction) {
    var sorted = Array.from(this).sort(sortFunction);
    return new List(false, sorted);
};

List.prototype.filtered = function(filterFunction) {
    var filtered = this.filter(filterFunction);
    return new List(false, filtered);
};


List.prototype.item = function(idx) {
    if(idx==null)
        throw new ReferenceError();
    else if(idx<1 || idx>this.length)
        throw new RangeError();
    else
        return this[idx-1];
};

List.prototype.getItem = function (idx, create) {
    if(idx==null)
        throw new ReferenceError();
    else if(idx<1 || idx>this.length)
        throw new RangeError();
    else {
        if(!this[idx - 1] && create)
            this[idx - 1] = new Document();
        return this[idx - 1] || null;
    }
};

List.prototype.setItem = function (idx, value) {
    if(!this.mutable)
        throw new NotMutableError();
    else if(idx==null)
        throw new ReferenceError();
    else if(idx<1 || idx>this.length)
        throw new RangeError();
    else
        this[idx-1] = value;
};


List.prototype.has = function(item, noCheckEquals) {
    var set = new StrictSet(this);
    return set.has(item, noCheckEquals);
};


List.prototype.hasAll = function(items, noCheckEquals) {
    var set = new StrictSet(this);
    return set.hasAll(items, noCheckEquals);
};


List.prototype.hasAny = function(items, noCheckEquals) {
    var set = new StrictSet(this);
    return set.hasAny(items, noCheckEquals);
};


List.prototype.slice1Based = function(start, last) {
    if(start) {
        if (start < 0 || start >= this.length)
            throw new RangeError();
        start = start - 1;
    } else
        start = 0;
    if(!last)
        return new List(false, this.slice(start));
    if(last >= 0) {
        if(last<=start || last>= this.length - 1)
            throw new RangeError();
        return new List(false, this.slice(start, last));
    } else {
        // TODO check Range
        return new List(false, this.slice(start, 1 + last));
    }
};


List.prototype.iterate = function (fn) {
    var self = this;
    return {
        length: self.length,
        iterator: function() {
            var idx = 0;
            return {
                hasNext: function() { return idx < self.length; },
                next: function() { return fn(self[idx++]); }
            };
        },
        toArray: function() {
            var array = [];
            var iterator = this.iterator();
            while(iterator.hasNext())
                array.push(iterator.next());
            return array;
        },
        getText: function() {
            return this.toArray().join(", ");
        }
    }
};

List.prototype.collectStorables = function(storablesToAdd) {
    this.forEach(function(item) {
        if(item && item.collectStorables)
            item.collectStorables(storablesToAdd);
    });
};

List.prototype.equals = function(o) {
    o = o || null;
    if(this===o) {
        return true;
    }
    if(!(o instanceof List) || this.length !== o.length) {
        return false;
    }
    for(var i=0;i<this.length;i++) {
        if(!equalObjects(this[i], o[i])) {
            return false;
        }
    }
    return true;
};

List.prototype.toString = function() {
	return "[" + this.join(", ") + "]";
};

List.prototype.getText = List.prototype.toString;

exports.List = List;

/***/ }),
/* 30 */
/***/ (function(module, exports) {

function PromptoError() {
    var tmp = Error.apply(this, arguments);
    this.message = tmp.message
    tmp.name = this.name = 'PromptoError'
    Object.defineProperty(this, "stack", {
        get: function () {
            return tmp.stack
        }
    });
    return this;
}


exports.PromptoError = PromptoError;

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var BooleanType = __webpack_require__(5).BooleanType;
var IntegerType = __webpack_require__(2).IntegerType;
var TextType = __webpack_require__(6).TextType;
var AnyType = __webpack_require__(14).AnyType;
var CharacterValue = null;
var RangeType = __webpack_require__(71).RangeType;
var CharacterRange = __webpack_require__(257).CharacterRange;
var Identifier = __webpack_require__(0).Identifier;

exports.resolve = function() {
    CharacterValue = __webpack_require__(93).CharacterValue;
};

function CharacterType()  {
	NativeType.call(this, new Identifier("Character"));
	return this;
}

CharacterType.prototype = Object.create(NativeType.prototype);
CharacterType.prototype.constructor = CharacterType;

CharacterType.instance = new CharacterType();


CharacterType.prototype.declare = function(transpiler) {
    // nothing to do
};

CharacterType.prototype.nativeCast = function(context, value) {
    if(value.type instanceof TextType && value.value.length>=1)
        return new CharacterValue(value.value.substring(0, 1));
    else
        throw new InvalidDataError("Cannot convert " + value.toString() + " to CharacterValue");
};


CharacterType.prototype.checkMember = function(context, section, name) {
    if ("codePoint"==name) {
        return IntegerType.instance;
    } else {
        return NativeType.prototype.checkMember.call(this, context, section, name);
    }
};


CharacterType.prototype.declareMember = function(transpiler, name) {
    if ("codePoint"!==name) {
        NativeType.prototype.declareMember.call(this, transpiler, name);
    }
};



CharacterType.prototype.transpileMember = function(transpiler, name) {
    if ("codePoint"==name) {
        transpiler.append("charCodeAt(0)");
    } else {
        NativeType.prototype.transpileMember.call(this, transpiler, name);
    }
};


CharacterType.prototype.checkAdd = function(context, other, tryReverse) {
	return TextType.instance;
};


CharacterType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    left.declare(transpiler);
    right.declare(transpiler);
};


CharacterType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    // can add anything to text
    left.transpile(transpiler);
    transpiler.append(" + ");
    right.transpile(transpiler);
};


CharacterType.prototype.checkMultiply = function(context, other, tryReverse) {
	if(other === IntegerType.instance) {
		return TextType.instance;
	}
	return NativeType.prototype.checkMultiply.apply(this, context, other, tryReverse);
};


CharacterType.prototype.declareMultiply = function(transpiler, other, tryReverse, left, right) {
    if (other === IntegerType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareMultiply.call(this, transpiler, other, tryReverse, left, right);
};

CharacterType.prototype.transpileMultiply = function(transpiler, other, tryReverse, left, right) {
    if (other === IntegerType.instance) {
        left.transpile(transpiler);
        transpiler.append(".repeat(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileMultiply.call(this, transpiler, other, tryReverse, left, right);
};


CharacterType.prototype.checkCompare = function(context, other) {
	if(other instanceof CharacterType || other instanceof TextType) {
		return BooleanType.instance;
	}
	return NativeType.prototype.checkCompare.apply(this, context, other);
};

CharacterType.prototype.declareCompare = function(context, other) {
    // nothing to do
};

CharacterType.prototype.transpileCompare = function(transpiler, other, operator, left, right) {
    left.transpile(transpiler);
    transpiler.append(" ").append(operator.toString()).append(" ");
    right.transpile(transpiler);
};

CharacterType.prototype.checkRange = function(context, other) {
	if(other instanceof CharacterType) {
		return new RangeType(this);
	} else {
		return NativeType.prototype.checkRange.call(this, context, other);
	}
};


CharacterType.prototype.declareRange = function(transpiler, other) {
    if(other === CharacterType.instance) {
        var module = __webpack_require__(117);
        transpiler.require(module.Range);
        transpiler.require(module.IntegerRange);
        transpiler.require(module.CharacterRange);
    } else {
        return NativeType.prototype.declareRange.call(this, transpiler, other);
    }
};


CharacterType.prototype.transpileRange = function(transpiler, first, last) {
    transpiler.append("new CharacterRange(");
    first.transpile(transpiler);
    transpiler.append(",");
    last.transpile(transpiler);
    transpiler.append(")");
};


CharacterType.prototype.newRange = function(left, right) {
	if(left instanceof CharacterValue && right instanceof CharacterValue) {
		return new CharacterRange(left, right);
	} else {
		return CharacterType.prototype.newRange.call(this, left, right);
	}
};


exports.CharacterType = CharacterType;

/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

var PromptoError = __webpack_require__(30).PromptoError;

function SyntaxError(message) {
	PromptoError.call(this, message);
	return this;
}

SyntaxError.prototype = Object.create(PromptoError.prototype);
SyntaxError.prototype.constructor = SyntaxError;

exports.SyntaxError = SyntaxError;



/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var IntegerValue = null; // circular dependency
var DecimalType = null;
var decimalTostring = __webpack_require__(16).decimalToString;

exports.resolve = function() {
	IntegerValue = __webpack_require__(3).IntegerValue;
    DecimalType = __webpack_require__(23).DecimalType;
};

function DecimalValue(value) {
	Value.call(this, DecimalType.instance);
	this.value = value;
	return this;
}

DecimalValue.prototype = Object.create(Value.prototype);
DecimalValue.prototype.constructor = DecimalValue;

DecimalValue.Parse = function(text) {
	return new DecimalValue(parseFloat(text));
};

DecimalValue.prototype.toString = function() {
    return decimalTostring(this.value);
};

/*jshint bitwise:false*/
DecimalValue.prototype.IntegerValue = function() {
	return Math.floor(this.value);
};

DecimalValue.prototype.DecimalValue = function() {
	return this.value;
};


DecimalValue.prototype.getStorableData = function() {
    return this.value;
};

DecimalValue.prototype.Add = function(context, value) {
	if (value instanceof IntegerValue) {
		return new DecimalValue(this.value + value.IntegerValue());
	} else if (value instanceof DecimalValue) {
		return new DecimalValue(this.value + value.DecimalValue());
	} else {
		throw new SyntaxError("Illegal: DecimalValue + " + typeof(value));
	}
};

DecimalValue.prototype.Subtract = function(context, value) {
	if (value instanceof IntegerValue) {
		return new DecimalValue(this.value - value.IntegerValue());
	} else if (value instanceof DecimalValue) {
		return new DecimalValue(this.value - value.DecimalValue());
	} else {
		throw new SyntaxError("Illegal: DecimalValue - " + typeof(value));
	}
};

DecimalValue.prototype.Multiply = function(context, value) {
	if (value instanceof IntegerValue) {
		return new DecimalValue(this.value * value.IntegerValue());
	} else if (value instanceof DecimalValue) {
		return new DecimalValue(this.value * value.DecimalValue());
	} else {
		throw new SyntaxError("Illegal: DecimalValue * " + typeof(value));
	}
};

DecimalValue.prototype.Divide = function(context, value) {
	if (value instanceof IntegerValue || value instanceof DecimalValue) {
		if (value.DecimalValue() == 0.0) {
			throw new DivideByZeroError();
		} else {
			return new DecimalValue(this.DecimalValue() / value.DecimalValue());
		}
	} else {
		throw new SyntaxError("Illegal: DecimalValue / " + typeof(value));
	}
};

DecimalValue.prototype.IntDivide = function(context, value) {
    if (value instanceof IntegerValue) {
        if (value.IntegerValue() == 0) {
            throw new DivideByZeroError();
        } else {
            return new IntegerValue(this.DecimalValue() / value.IntegerValue());
        }
    } else {
        throw new SyntaxError("Illegal: DecimalValue \\ " + typeof(value));
    }
};

DecimalValue.prototype.Modulo = function(context, value) {
    if (value instanceof IntegerValue || value instanceof DecimalValue) {
        if (value.DecimalValue() == 0.0) {
            throw new DivideByZeroError();
        } else {
            return new DecimalValue(this.DecimalValue() % value.DecimalValue());
        }
    } else {
        throw new SyntaxError("Illegal: DecimalValue % " + typeof(value));
    }
};

DecimalValue.prototype.Minus = function(context) {
	return new DecimalValue(-this.value);
};

DecimalValue.prototype.CompareTo = function(context, value) {
	if (value instanceof IntegerValue || value instanceof DecimalValue) {
		return this.value > value.value ? 1 : this.value == value.value ? 0 : -1;
	} else {
		throw new SyntaxError("Illegal comparison: IntegerValue and " + typeof(value));
	}
};
/*


@Override
public Object ConvertTo(Class<?> type) {
	return value;
}

*/

DecimalValue.prototype.equals = function(obj) {
	if (obj instanceof IntegerValue || obj instanceof DecimalValue) {
		return this.value == obj.value;
	} else {
		return false;
	}
};

exports.DecimalValue = DecimalValue;



/***/ }),
/* 34 */
/***/ (function(module, exports) {

function StrictSet(values) {
    this.set = new Set(values);
    return this;
}

Object.defineProperty(StrictSet.prototype, "length", {
    get : function() {
        return this.set.size;
    }
});

StrictSet.prototype.toString = function() {
    return "<" + Array.from(this.set.values()).join(", ") + ">";
};


StrictSet.prototype.getText = StrictSet.prototype.toString;


StrictSet.prototype.iterator = function() {
    var iter = this.set.values();
    var item = iter.next();
    return {
        hasNext: function() { return !item.done; },
        next: function() { var value = item.value; item = iter.next(); return value; }
    };
};

StrictSet.prototype.item = function(idx) {
    var iter = this.set.values();
    var item = iter.next();
    while(--idx>=0 && !item.done)
        item = iter.next();
    if(item.done)
        return null;
    else
        return item.value;
};


StrictSet.prototype.addItems = function(items) {
    if(items instanceof StrictSet)
        items = Array.from(items.set.values());
    items.forEach(function(item){
        this.add(item);
    }, this);
    return this; // enable fluid API
};


StrictSet.prototype.addAll = function(items) {
    var result = new StrictSet(this.set);
    result.addItems(items);
    return result;
};


StrictSet.prototype.remove = function(items) {
    var excluded = (items instanceof StrictSet) ? items : new Set(items);
    var items = Array.from(this.set.values());
    var remaining = items.filter(function(item) { return !excluded.has(item); });
    return new StrictSet(remaining);
};


StrictSet.prototype.add = function(value) {
    if(this.has(value))
        return false;
    else {
        this.set.add(value);
        return true;
    }
};

StrictSet.prototype.has = function(value, noCheckEquals) {
    if(this.set.has(value))
        return true;
    if(noCheckEquals)
        return false;
    var iter = this.set.values();
    var item = iter.next();
    while(!item.done) {
        if(value.equals && value.equals(item.value))
            return true;
        item = iter.next();
    }
    return false;
};


StrictSet.prototype.hasAll = function(items, noCheckEquals) {
    if(items instanceof StrictSet)
        items = Array.from(items.set.values());
    for (var i = 0; i < items.length; i++) {
        if (!this.has(items[i], noCheckEquals))
            return false;
    }
    return true;
};


StrictSet.prototype.hasAny = function(items, noCheckEquals) {
    if(items instanceof StrictSet)
        items = Array.from(items.set.values());
    if(noCheckEquals) {
        for (var i = 0; i < items.length; i++) {
            if (this.set.has(items[i]))
                return true;
        }
        return false;
    } else {
        for (var i = 0; i < items.length; i++) {
            if (this.has(items[i]))
                return true;
        }
        return false;
    }
};


StrictSet.prototype.equals = function(other) {
    if(!(other instanceof StrictSet))
        return false;
    else if(this.length!=other.length)
        return false;
    else {
        var iter = this.set.values();
        var item = iter.next();
        while(!item.done) {
            if(!other.has(item.value))
                return false;
            item = iter.next();
        }
        return true;
    }
};

StrictSet.prototype.intersect = function(other) {
    var items = [];
    this.set.forEach( function(item) {
        if(other.has(item))
            items.push(item);
    });
    return new StrictSet(items);
};

StrictSet.prototype.sorted = function(sortFunction) {
    var sorted = Array.from(this.set).sort(sortFunction);
    return new List(false, sorted);
};


StrictSet.prototype.filtered = function(filterFunction) {
    var filtered = Array.from(this.set).filter(filterFunction);
    return new StrictSet(filtered);
};




exports.StrictSet = StrictSet;

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

var Section = __webpack_require__(19).Section;

function BaseStatement() {
	Section.call(this);
	return this;
}

BaseStatement.prototype  = Object.create(Section.prototype);
BaseStatement.prototype.constructor = BaseStatement;

BaseStatement.prototype.canReturn = function() {
	return false;
};

BaseStatement.prototype.isSimple = function() {
    return false;
};

BaseStatement.prototype.transpile = function(transpiler) {
    throw new Error("Transpile not implemented by " + this.constructor.name);
};


BaseStatement.prototype.declare = function(transpiler) {
    throw new Error("Declare not implemented by " + this.constructor.name);
};

exports.BaseStatement = BaseStatement;


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

var BaseValueList = __webpack_require__(186).BaseValueList;
var BooleanValue = __webpack_require__(20).BooleanValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var multiplyArray = __webpack_require__(16).multiplyArray;
var ListType = null;
var SetValue = null;

exports.resolve = function() {
    ListType = __webpack_require__(26).ListType;
    SetValue = __webpack_require__(54).SetValue;
};

function ListValue(itemType, items, item, mutable) {
	BaseValueList.call(this, new ListType(itemType), items, item, mutable);
    this.storables = null;
	return this;
}

ListValue.prototype = Object.create(BaseValueList.prototype);
ListValue.prototype.constructor = ListValue;

ListValue.prototype.newInstance = function(items) {
	return new ListValue(this.type.itemType, items);
};

ListValue.prototype.getStorableData = function() {
    if(this.storables == null)
        this.storables = this.items.map(function(item) {
            return item.getStorableData();
        });
    return this.storables;
};

ListValue.prototype.collectStorables = function(list) {
    this.items.map(function(item) {
        item.collectStorables(list);
    });
};


ListValue.prototype.Add = function(context, value) {
	if (value instanceof ListValue) {
        var items = this.items.concat(value.items);
        return new ListValue(this.type.itemType, items);
    } else if(value instanceof SetValue) {
	    var items1 = Array.from(value.items.set.values());
        var items2 = this.items.concat(items1);
        return new ListValue(this.type.itemType, items2);
    } else {
		return BaseValueList.prototype.Add.apply(this, context, value);
	}
};


ListValue.prototype.Subtract = function(context, value) {
    if (value instanceof ListValue) {
        var setValue = new SetValue(this.type.itemType);
        value = setValue.Add(context, value);
    }
    if(value instanceof SetValue) {
        var items = this.items.filter(function(item) { return !value.items.has(item); });
        return new ListValue(this.type.itemType, items);
    } else {
        return BaseValueList.prototype.Subtract.apply(this, context, value);
    }
};


ListValue.prototype.Multiply = function(context, value) {
	if (value instanceof IntegerValue) {
	    var count = value.value;
		if (count < 0) {
			throw new SyntaxError("Negative repeat count:" + count);
		} else {
		    var items = multiplyArray(this.items, count);
            return new ListValue(this.type.itemType, items);
        }
	} else {
		return BaseValueList.prototype.Multiply.apply(this, context, value);
	}
};

ListValue.prototype.toDialect = function(writer) {
    writer.append('[');
    BaseValueList.prototype.toDialect.call(this, writer);
    writer.append(']');
};

ListValue.prototype.filter = function(context, itemId, filter) {
    var result = new ListValue(this.type.itemType);
    var iter = this.getIterator(context);
    while(iter.hasNext()) {
        var o = iter.next();
        context.setValue(itemId, o);
        var test = filter.interpret(context);
        if(!(test instanceof BooleanValue)) {
            throw new InternalError("Illegal test result: " + test);
        }
        if(test.value) {
            result.add(o);
        }
    }
    return result;
}

exports.ListValue = ListValue;



/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * A worker that does nothing but passing chunks to the next one. This is like
 * a nodejs stream but with some differences. On the good side :
 * - it works on IE 6-9 without any issue / polyfill
 * - it weights less than the full dependencies bundled with browserify
 * - it forwards errors (no need to declare an error handler EVERYWHERE)
 *
 * A chunk is an object with 2 attributes : `meta` and `data`. The former is an
 * object containing anything (`percent` for example), see each worker for more
 * details. The latter is the real data (String, Uint8Array, etc).
 *
 * @constructor
 * @param {String} name the name of the stream (mainly used for debugging purposes)
 */
function GenericWorker(name) {
    // the name of the worker
    this.name = name || "default";
    // an object containing metadata about the workers chain
    this.streamInfo = {};
    // an error which happened when the worker was paused
    this.generatedError = null;
    // an object containing metadata to be merged by this worker into the general metadata
    this.extraStreamInfo = {};
    // true if the stream is paused (and should not do anything), false otherwise
    this.isPaused = true;
    // true if the stream is finished (and should not do anything), false otherwise
    this.isFinished = false;
    // true if the stream is locked to prevent further structure updates (pipe), false otherwise
    this.isLocked = false;
    // the event listeners
    this._listeners = {
        'data':[],
        'end':[],
        'error':[]
    };
    // the previous worker, if any
    this.previous = null;
}

GenericWorker.prototype = {
    /**
     * Push a chunk to the next workers.
     * @param {Object} chunk the chunk to push
     */
    push : function (chunk) {
        this.emit("data", chunk);
    },
    /**
     * End the stream.
     * @return {Boolean} true if this call ended the worker, false otherwise.
     */
    end : function () {
        if (this.isFinished) {
            return false;
        }

        this.flush();
        try {
            this.emit("end");
            this.cleanUp();
            this.isFinished = true;
        } catch (e) {
            this.emit("error", e);
        }
        return true;
    },
    /**
     * End the stream with an error.
     * @param {Error} e the error which caused the premature end.
     * @return {Boolean} true if this call ended the worker with an error, false otherwise.
     */
    error : function (e) {
        if (this.isFinished) {
            return false;
        }

        if(this.isPaused) {
            this.generatedError = e;
        } else {
            this.isFinished = true;

            this.emit("error", e);

            // in the workers chain exploded in the middle of the chain,
            // the error event will go downward but we also need to notify
            // workers upward that there has been an error.
            if(this.previous) {
                this.previous.error(e);
            }

            this.cleanUp();
        }
        return true;
    },
    /**
     * Add a callback on an event.
     * @param {String} name the name of the event (data, end, error)
     * @param {Function} listener the function to call when the event is triggered
     * @return {GenericWorker} the current object for chainability
     */
    on : function (name, listener) {
        this._listeners[name].push(listener);
        return this;
    },
    /**
     * Clean any references when a worker is ending.
     */
    cleanUp : function () {
        this.streamInfo = this.generatedError = this.extraStreamInfo = null;
        this._listeners = [];
    },
    /**
     * Trigger an event. This will call registered callback with the provided arg.
     * @param {String} name the name of the event (data, end, error)
     * @param {Object} arg the argument to call the callback with.
     */
    emit : function (name, arg) {
        if (this._listeners[name]) {
            for(var i = 0; i < this._listeners[name].length; i++) {
                this._listeners[name][i].call(this, arg);
            }
        }
    },
    /**
     * Chain a worker with an other.
     * @param {Worker} next the worker receiving events from the current one.
     * @return {worker} the next worker for chainability
     */
    pipe : function (next) {
        return next.registerPrevious(this);
    },
    /**
     * Same as `pipe` in the other direction.
     * Using an API with `pipe(next)` is very easy.
     * Implementing the API with the point of view of the next one registering
     * a source is easier, see the ZipFileWorker.
     * @param {Worker} previous the previous worker, sending events to this one
     * @return {Worker} the current worker for chainability
     */
    registerPrevious : function (previous) {
        if (this.isLocked) {
            throw new Error("The stream '" + this + "' has already been used.");
        }

        // sharing the streamInfo...
        this.streamInfo = previous.streamInfo;
        // ... and adding our own bits
        this.mergeStreamInfo();
        this.previous =  previous;
        var self = this;
        previous.on('data', function (chunk) {
            self.processChunk(chunk);
        });
        previous.on('end', function () {
            self.end();
        });
        previous.on('error', function (e) {
            self.error(e);
        });
        return this;
    },
    /**
     * Pause the stream so it doesn't send events anymore.
     * @return {Boolean} true if this call paused the worker, false otherwise.
     */
    pause : function () {
        if(this.isPaused || this.isFinished) {
            return false;
        }
        this.isPaused = true;

        if(this.previous) {
            this.previous.pause();
        }
        return true;
    },
    /**
     * Resume a paused stream.
     * @return {Boolean} true if this call resumed the worker, false otherwise.
     */
    resume : function () {
        if(!this.isPaused || this.isFinished) {
            return false;
        }
        this.isPaused = false;

        // if true, the worker tried to resume but failed
        var withError = false;
        if(this.generatedError) {
            this.error(this.generatedError);
            withError = true;
        }
        if(this.previous) {
            this.previous.resume();
        }

        return !withError;
    },
    /**
     * Flush any remaining bytes as the stream is ending.
     */
    flush : function () {},
    /**
     * Process a chunk. This is usually the method overridden.
     * @param {Object} chunk the chunk to process.
     */
    processChunk : function(chunk) {
        this.push(chunk);
    },
    /**
     * Add a key/value to be added in the workers chain streamInfo once activated.
     * @param {String} key the key to use
     * @param {Object} value the associated value
     * @return {Worker} the current worker for chainability
     */
    withStreamInfo : function (key, value) {
        this.extraStreamInfo[key] = value;
        this.mergeStreamInfo();
        return this;
    },
    /**
     * Merge this worker's streamInfo into the chain's streamInfo.
     */
    mergeStreamInfo : function () {
        for(var key in this.extraStreamInfo) {
            if (!this.extraStreamInfo.hasOwnProperty(key)) {
                continue;
            }
            this.streamInfo[key] = this.extraStreamInfo[key];
        }
    },

    /**
     * Lock the stream to prevent further updates on the workers chain.
     * After calling this method, all calls to pipe will fail.
     */
    lock: function () {
        if (this.isLocked) {
            throw new Error("The stream '" + this + "' has already been used.");
        }
        this.isLocked = true;
        if (this.previous) {
            this.previous.lock();
        }
    },

    /**
     *
     * Pretty print the workers chain.
     */
    toString : function () {
        var me = "Worker " + this.name;
        if (this.previous) {
            return this.previous + " -> " + me;
        } else {
            return me;
        }
    }
};

module.exports = GenericWorker;


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

var BaseType = __webpack_require__(47).BaseType;

function MethodType(method) {
	BaseType.call(this, method.id);
    this.method = method;
	return this;
}

MethodType.prototype = Object.create(BaseType.prototype);
MethodType.prototype.constructor = MethodType;


MethodType.prototype.equals = function(other) {
	return (other==this) ||
        ((other instanceof MethodType) && (this.method.getProto()==other.method.getProto()));
};

MethodType.prototype.checkUnique = function(context) {
	var actual = context.getRegisteredDeclaration(this.name);
	if (actual != null) {
		throw new SyntaxError("Duplicate name: \"" + this.name + "\"");
	}
};


MethodType.prototype.isMoreSpecificThan = function(context, other) {
    return false;
};

MethodType.prototype.declare = function(transpiler) {
    // nothing to do
};

exports.MethodType = MethodType;


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

var ObjectList = __webpack_require__(22).ObjectList;
var Dialect = __webpack_require__(8).Dialect;
var ContextualExpression = __webpack_require__(188).ContextualExpression;
var AttributeArgument = __webpack_require__(72).AttributeArgument;
var ArgumentAssignment = __webpack_require__(40).ArgumentAssignment;
var AndExpression = null;
var UnresolvedIdentifier = null;

exports.resolve = function() {
    AndExpression = __webpack_require__(259).AndExpression;
    UnresolvedIdentifier = __webpack_require__(27).UnresolvedIdentifier;
}

function ArgumentAssignmentList(items) {
	ObjectList.call(this, items || []);
	return this;
}

ArgumentAssignmentList.prototype = Object.create(ObjectList.prototype);
ArgumentAssignmentList.prototype.constructor = ArgumentAssignmentList;


/* post-fix expression priority for final assignment in E dialect */
/* 'xyz with a and b as c' should read 'xyz with a, b as c' NOT 'xyz with (a and b) as c' */
ArgumentAssignmentList.prototype.checkLastAnd = function() {
    var assignment = this.slice(-1).pop();
    if(assignment!=null && assignment.argument!=null && assignment.expression instanceof AndExpression) {
        var and = assignment.expression;
        if(and.left instanceof UnresolvedIdentifier) {
            var id = and.left.id;
            var leading = id.name.charAt(0);
            if(leading !== leading.toUpperCase()) {
                this.pop();
                // add AttributeArgument
                var argument = new AttributeArgument(id);
                var attribute = new ArgumentAssignment(argument, null);
                this.add(attribute);
                // fix last assignment
                assignment.expression = and.right;
                this.add(assignment);
            }
        }
    }
};

ArgumentAssignmentList.prototype.findIndex = function(name) {
	for(var i=0;i<this.length;i++) {
		if(name==this[i].name) {
			return i;
		}
	}
	return -1;
};

ArgumentAssignmentList.prototype.find = function(name) {
	for(var i=0;i<this.length;i++) {
		if(name==this[i].name) {
			return this[i];
		}
	}
	return null;
};

ArgumentAssignmentList.prototype.makeAssignments = function(context, declaration) {
    var local = new ArgumentAssignmentList(this);
	var assignments = new ArgumentAssignmentList();
	for(var i=0;i<declaration.args.length;i++) {
	    var argument = declaration.args[i];
        var assignment = null;
        var index = local.findIndex(argument.name);
	    if(index<0 && i==0 && this.length>0 && this[0].argument==null)
	        index = 0;
	    if(index>=0) {
            assignment = local[index];
            local.splice(index, 1);
        }
        if(assignment==null) {
            if (argument.defaultExpression != null)
                assignments.push(new ArgumentAssignment(argument, argument.defaultExpression));
            else
                throw new SyntaxError("Missing argument:" + argument.name);
        } else {
            var expression = new ContextualExpression(context, assignment.expression);
            assignments.push(new ArgumentAssignment(argument, expression));
        }
    }
    if(local.length > 0)
        throw new SyntaxError("Method has no argument:" + local[0].name);
	return assignments;
};



ArgumentAssignmentList.prototype.toDialect = function(writer) {
    writer.toDialect(this);
};

ArgumentAssignmentList.prototype.toEDialect = function(writer) {
    var idx = 0;
    // anonymous argument before 'with'
    if(this.length>0 && this[0].argument==null) {
        writer.append(' ');
        this[idx++].toDialect(writer);
    }
    if(idx<this.length) {
        writer.append(" with ");
        this[idx++].toDialect(writer);
        writer.append(", ");
        while(idx<this.length-1) {
            this[idx++].toDialect(writer);
            writer.append(", ");
        }
        writer.trimLast(2);
        if(idx<this.length) {
            writer.append(" and ");
            this[idx++].toDialect(writer);
        }
    }
};

ArgumentAssignmentList.prototype.toODialect = function(writer) {
    writer.append("(");
    this.forEach(function(arg) {
        arg.toDialect(writer);
        writer.append(", ");
    });
    if(this.length>0)
        writer.trimLast(2);
    writer.append(")");
};

ArgumentAssignmentList.prototype.toMDialect = function(writer) {
    this.toODialect(writer);
};


ArgumentAssignmentList.prototype.declare = function(transpiler) {
    this.forEach(function(arg) {
        arg.declare(transpiler);
    });
};


ArgumentAssignmentList.prototype.transpile = function(transpiler) {
    transpiler.append("(");
    this.forEach(function(arg) {
        arg.transpile(transpiler);
        transpiler.append(", ");
    });
    if(this.length>0)
        transpiler.trimLast(2);
    transpiler.append(")");
};

exports.ArgumentAssignmentList = ArgumentAssignmentList;



/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

var CategoryType = null;
var InstanceExpression = __webpack_require__(41).InstanceExpression;
var MemberSelector = __webpack_require__(63).MemberSelector;
var Variable = __webpack_require__(10).Variable;
var VoidType = __webpack_require__(4).VoidType;
var PromptoError = __webpack_require__(30).PromptoError;
var Specificity = __webpack_require__(362).Specificity;

exports.resolve = function() {
    CategoryType = __webpack_require__(7).CategoryType;
}

function ArgumentAssignment(argument, expression) {
	this.argument = argument;
	this._expression = expression;
	return this;
}

Object.defineProperty(ArgumentAssignment.prototype, "id", {
    get : function() {
        return this.argument.id;
    }
});

Object.defineProperty(ArgumentAssignment.prototype, "name", {
	get : function() {
		return this.argument ? this.argument.name : null;
	}
});

Object.defineProperty(ArgumentAssignment.prototype, "expression", {
    get : function() {
        return this._expression ? this._expression : new InstanceExpression(this.id);
    },
    set : function(expression) {
        this._expression = expression;
    }
});

// needed for error reporting
Object.defineProperty(ArgumentAssignment.prototype, "end", {
    get : function() {
        return this.expression.end;
    }
});

ArgumentAssignment.prototype.toDialect = function(writer) {
    writer.toDialect(this);
};

ArgumentAssignment.prototype.toODialect = function(writer) {
	if(!this._expression) {
        writer.append(this.argument.name);
	} else {
        if (this.argument != null) {
            writer.append(this.argument.name);
            writer.append(" = ");
        }
        this._expression.toDialect(writer);
    }
};

ArgumentAssignment.prototype.toMDialect = function(writer) {
    if(!this._expression) {
        writer.append(this.argument.name);
    } else {
        if (this.argument != null) {
            writer.append(this.argument.name);
            writer.append(" = ");
        }
        this._expression.toDialect(writer);
    }
};

ArgumentAssignment.prototype.toEDialect = function(writer) {
    if(!this._expression) {
        writer.append(this.argument.name);
    } else {
        this._expression.toDialect(writer);
        if (this.argument != null) {
            writer.append(" as ");
            writer.append(this.argument.name);
        }
    }
};


ArgumentAssignment.prototype.declare = function(transpiler) {
    if(this._expression)
    	this._expression.declare(transpiler);
};

ArgumentAssignment.prototype.transpile = function(transpiler) {
    this._expression.transpile(transpiler);
};


ArgumentAssignment.prototype.toString = function() {
    if(!this._expression) {
        return this.argument.name;
    } else {
        if (this.argument === null) {
            return this._expression.toString();
        } else {
            return this.name + " = " + this._expression.toString();
        }
    }
};

ArgumentAssignment.prototype.equals = function(obj) {
	if(obj==this) {
		return true;
	} else if(obj==null) {
		return false;
	} else if(!(obj instanceof ArgumentAssignment)) {
		return false;
	} else {
		return this.argument.equals(obj.argument) &&
			this.expression.equals(other.expression);
	}
};

ArgumentAssignment.prototype.check = function(context) {
	var actual = context.getRegisteredValue(this.argument.name);
	if(actual==null) {
        var actualType = this.expression.check(context);
		context.registerValue(new Variable(this.argument.id, actualType));
	} else {
		// need to check type compatibility
		var actualType = actual.getType(context);
		var newType = this.expression.check(context);
        actualType.checkAssignableFrom(context, newType, this);
	}
	return VoidType.instance;
};

ArgumentAssignment.prototype.resolve = function(context, methodDeclaration, checkInstance, allowDerived) {
	// since we support implicit members, it's time to resolve them
	var name = this.argument.name;
	var expression = this.expression;
	var argument = methodDeclaration.args.find(name);
	var required = argument.getType(context);
	var actual = expression.check(context.getCallingContext());
	if(checkInstance && actual instanceof CategoryType) {
		var value = expression.interpret(context.getCallingContext());
		if(value && value.getType) {
			actual = value.getType();
		}
	}
	var assignable = required.isAssignableFrom(context, actual);
	// when in dispatch, allow derived
	if(!assignable && allowDerived)
        assignable = actual.isAssignableFrom(context, required);
	// try passing member
	if(!assignable && (actual instanceof CategoryType)) {
		expression = new MemberSelector(expression, this.argument.id);
	}
	return expression;
};

ArgumentAssignment.prototype.makeAssignment = function(context, declaration) {
	var argument = this.argument;
	// when 1st argument, can be unnamed
	if(argument===null) {
		if(declaration.args.length==0) {
			throw new SyntaxError("Method has no argument");
		}
		argument = declaration.args[0];
	} else {
		argument = declaration.args.find(this.name);
	}
	if(argument==null) {
		throw new SyntaxError("Method has no argument:" + this.name);
	}
};

ArgumentAssignment.prototype.isAssignableToArgument = function(context, argument, declaration, checkInstance, allowDerived) {
    return this.computeSpecificity(context, argument, declaration, checkInstance, allowDerived)!==Specificity.INCOMPATIBLE;
};

ArgumentAssignment.prototype.computeSpecificity = function(context, argument, declaration, checkInstance, allowDerived) {
    try {
        var required = argument.getType(context);
        var actual = this.expression.check(context);
        // retrieve actual runtime type
        if(checkInstance && (actual instanceof CategoryType)) {
            var value = this.expression.interpret(context.getCallingContext());
            if(value && value.getType) {
                actual = value.getType();
            }
        }
        if(actual.equals(required)) {
            return Specificity.EXACT;
        } else if(required.isAssignableFrom(context, actual)) {
            return Specificity.INHERITED;
        } else if(allowDerived && actual.isAssignableFrom(context, required)) {
            return Specificity.DERIVED;
        }
        actual = this.resolve(context, declaration, checkInstance).check(context);
        if(required.isAssignableFrom(context, actual)) {
            return Specificity.IMPLICIT;
        } else if(allowDerived && actual.isAssignableFrom(context, required)) {
            return Specificity.IMPLICIT;
        }
    } catch(error) {
        if(!(error instanceof PromptoError )) {
            throw error;
        }
    }
    return Specificity.INCOMPATIBLE;
};

exports.ArgumentAssignment = ArgumentAssignment;



/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

var Variable = __webpack_require__(10).Variable;
var LinkedVariable = __webpack_require__(258).LinkedVariable;
var Identifier = __webpack_require__(0).Identifier;
var Argument = __webpack_require__(114).Argument;
var Dialect = __webpack_require__(8).Dialect;
var CategoryDeclaration = null;
var VoidType = __webpack_require__(4).VoidType;
var MethodType = __webpack_require__(38).MethodType;
var ClosureValue = __webpack_require__(97).ClosureValue;
var Section = __webpack_require__(19).Section;
var AttributeDeclaration = __webpack_require__(70).AttributeDeclaration;
var MethodDeclarationMap = null;
var InstanceContext = null;

exports.resolve = function() {
	CategoryDeclaration = __webpack_require__(45).CategoryDeclaration;
    MethodDeclarationMap = __webpack_require__(11).MethodDeclarationMap;
    InstanceContext = __webpack_require__(11).InstanceContext;
}

function InstanceExpression(id) {
    Section.prototype.copySectionFrom.call(this, id);
    this.id = id;
	return this;
}

Object.defineProperty(InstanceExpression.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});


InstanceExpression.prototype.toString = function() {
	return this.name;
};

InstanceExpression.prototype.declare = function(transpiler) {
    var named = transpiler.context.getRegistered(this.name);
    if(named instanceof MethodDeclarationMap) {
        var decl = named.getFirst();
        // don't declare member methods
        if(decl.memberOf!=null)
            return;
        // don't declare closures
        if(decl.declarationStatement)
            return;
        decl.declare(transpiler);
    }
};


InstanceExpression.prototype.transpile = function(transpiler) {
    var context = transpiler.context.contextForValue(this.name);
    if(context instanceof InstanceContext) {
        context.instanceType.transpileInstance(transpiler);
        transpiler.append(".");
    }
    var named = transpiler.context.getRegistered(this.name);
    if(named instanceof MethodDeclarationMap) {
        transpiler.append(named.getFirst().getTranspiledName());
        // need to bind instance methods
        if(context instanceof InstanceContext) {
            transpiler.append(".bind(");
            context.instanceType.transpileInstance(transpiler);
            transpiler.append(")");
        }
    } else {
        if (transpiler.getterName === this.name)
            transpiler.append("$");
        transpiler.append(this.name);
    }
};


InstanceExpression.prototype.toDialect = function(writer, requireMethod) {
    if(requireMethod === undefined)
        requireMethod = true;
    if(requireMethod && this.requiresMethod(writer))
        writer.append("Method: ");
    writer.append(this.name);
};

InstanceExpression.prototype.requiresMethod = function(writer) {
    if(writer.dialect!=Dialect.E)
        return false;
    var o = writer.context.getRegistered(this.name);
    if(o instanceof MethodDeclarationMap)
        return true;
    return false;
};

InstanceExpression.prototype.check = function(context) {
	var named = context.getRegistered(this.id.name);
	if(named==null) {
	    named = context.getRegisteredDeclaration(this.id.name);
    }
	if (named instanceof Variable) { // local variable
        return named.getType(context);
    } else if(named instanceof LinkedVariable) { // local variable
        return named.getType(context);
	} else if (named instanceof Argument) { // named argument
		return named.getType(context);
	} else if(named instanceof CategoryDeclaration) { // any p with x
		return named.getType(context);
	} else if(named instanceof AttributeDeclaration) { // in category method
		return named.getType(context);
	} else if(named instanceof MethodDeclarationMap) { // global method or closure
		return new MethodType(named.getFirst());
	} else {
        context.problemListener.reportUnknownVariable(this.id);
        return VoidType.instance;
    }
};

InstanceExpression.prototype.interpret = function(context) {
    if(context.hasValue(this.id)) {
        return context.getValue(this.id);
    } else {
        var named = context.getRegistered(this.id);
        if (named instanceof MethodDeclarationMap) {
            var decl = named.getFirst();
            return new ClosureValue(context, new MethodType(decl))
        } else {
            throw new SyntaxError("No method with name:" + this.name);
        }
    }
};

exports.InstanceExpression = InstanceExpression;


/***/ }),
/* 42 */
/***/ (function(module, exports) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
//

// The following images show the relation of states and
// {@link ATNState//transitions} for various grammar constructs.
//
// <ul>
//
// <li>Solid edges marked with an &//0949; indicate a required
// {@link EpsilonTransition}.</li>
//
// <li>Dashed edges indicate locations where any transition derived from
// {@link Transition} might appear.</li>
//
// <li>Dashed nodes are place holders for either a sequence of linked
// {@link BasicState} states or the inclusion of a block representing a nested
// construct in one of the forms below.</li>
//
// <li>Nodes showing multiple outgoing alternatives with a {@code ...} support
// any number of alternatives (one or more). Nodes without the {@code ...} only
// support the exact number of alternatives shown in the diagram.</li>
//
// </ul>
//
// <h2>Basic Blocks</h2>
//
// <h3>Rule</h3>
//
// <embed src="images/Rule.svg" type="image/svg+xml"/>
//
// <h3>Block of 1 or more alternatives</h3>
//
// <embed src="images/Block.svg" type="image/svg+xml"/>
//
// <h2>Greedy Loops</h2>
//
// <h3>Greedy Closure: {@code (...)*}</h3>
//
// <embed src="images/ClosureGreedy.svg" type="image/svg+xml"/>
//
// <h3>Greedy Positive Closure: {@code (...)+}</h3>
//
// <embed src="images/PositiveClosureGreedy.svg" type="image/svg+xml"/>
//
// <h3>Greedy Optional: {@code (...)?}</h3>
//
// <embed src="images/OptionalGreedy.svg" type="image/svg+xml"/>
//
// <h2>Non-Greedy Loops</h2>
//
// <h3>Non-Greedy Closure: {@code (...)*?}</h3>
//
// <embed src="images/ClosureNonGreedy.svg" type="image/svg+xml"/>
//
// <h3>Non-Greedy Positive Closure: {@code (...)+?}</h3>
//
// <embed src="images/PositiveClosureNonGreedy.svg" type="image/svg+xml"/>
//
// <h3>Non-Greedy Optional: {@code (...)??}</h3>
//
// <embed src="images/OptionalNonGreedy.svg" type="image/svg+xml"/>
//

var INITIAL_NUM_TRANSITIONS = 4;

function ATNState() {
    // Which ATN are we in?
    this.atn = null;
    this.stateNumber = ATNState.INVALID_STATE_NUMBER;
    this.stateType = null;
    this.ruleIndex = 0; // at runtime, we don't have Rule objects
    this.epsilonOnlyTransitions = false;
    // Track the transitions emanating from this ATN state.
    this.transitions = [];
    // Used to cache lookahead during parsing, not used during construction
    this.nextTokenWithinRule = null;
    return this;
}

// constants for serialization
ATNState.INVALID_TYPE = 0;
ATNState.BASIC = 1;
ATNState.RULE_START = 2;
ATNState.BLOCK_START = 3;
ATNState.PLUS_BLOCK_START = 4;
ATNState.STAR_BLOCK_START = 5;
ATNState.TOKEN_START = 6;
ATNState.RULE_STOP = 7;
ATNState.BLOCK_END = 8;
ATNState.STAR_LOOP_BACK = 9;
ATNState.STAR_LOOP_ENTRY = 10;
ATNState.PLUS_LOOP_BACK = 11;
ATNState.LOOP_END = 12;

ATNState.serializationNames = [
            "INVALID",
            "BASIC",
            "RULE_START",
            "BLOCK_START",
            "PLUS_BLOCK_START",
            "STAR_BLOCK_START",
            "TOKEN_START",
            "RULE_STOP",
            "BLOCK_END",
            "STAR_LOOP_BACK",
            "STAR_LOOP_ENTRY",
            "PLUS_LOOP_BACK",
            "LOOP_END" ];

ATNState.INVALID_STATE_NUMBER = -1;

ATNState.prototype.toString = function() {
	return this.stateNumber;
};

ATNState.prototype.equals = function(other) {
    if (other instanceof ATNState) {
        return this.stateNumber===other.stateNumber;
    } else {
        return false;
    }
};

ATNState.prototype.isNonGreedyExitState = function() {
    return false;
};


ATNState.prototype.addTransition = function(trans, index) {
	if(index===undefined) {
		index = -1;
	}
    if (this.transitions.length===0) {
        this.epsilonOnlyTransitions = trans.isEpsilon;
    } else if(this.epsilonOnlyTransitions !== trans.isEpsilon) {
        this.epsilonOnlyTransitions = false;
    }
    if (index===-1) {
        this.transitions.push(trans);
    } else {
        this.transitions.splice(index, 1, trans);
    }
};

function BasicState() {
	ATNState.call(this);
    this.stateType = ATNState.BASIC;
    return this;
}

BasicState.prototype = Object.create(ATNState.prototype);
BasicState.prototype.constructor = BasicState;


function DecisionState() {
	ATNState.call(this);
    this.decision = -1;
    this.nonGreedy = false;
    return this;
}

DecisionState.prototype = Object.create(ATNState.prototype);
DecisionState.prototype.constructor = DecisionState;


//  The start of a regular {@code (...)} block.
function BlockStartState() {
	DecisionState.call(this);
	this.endState = null;
	return this;
}

BlockStartState.prototype = Object.create(DecisionState.prototype);
BlockStartState.prototype.constructor = BlockStartState;


function BasicBlockStartState() {
	BlockStartState.call(this);
	this.stateType = ATNState.BLOCK_START;
	return this;
}

BasicBlockStartState.prototype = Object.create(BlockStartState.prototype);
BasicBlockStartState.prototype.constructor = BasicBlockStartState;


// Terminal node of a simple {@code (a|b|c)} block.
function BlockEndState() {
	ATNState.call(this);
	this.stateType = ATNState.BLOCK_END;
    this.startState = null;
    return this;
}

BlockEndState.prototype = Object.create(ATNState.prototype);
BlockEndState.prototype.constructor = BlockEndState;


// The last node in the ATN for a rule, unless that rule is the start symbol.
//  In that case, there is one transition to EOF. Later, we might encode
//  references to all calls to this rule to compute FOLLOW sets for
//  error handling.
//
function RuleStopState() {
	ATNState.call(this);
    this.stateType = ATNState.RULE_STOP;
    return this;
}

RuleStopState.prototype = Object.create(ATNState.prototype);
RuleStopState.prototype.constructor = RuleStopState;

function RuleStartState() {
	ATNState.call(this);
	this.stateType = ATNState.RULE_START;
	this.stopState = null;
	this.isPrecedenceRule = false;
	return this;
}

RuleStartState.prototype = Object.create(ATNState.prototype);
RuleStartState.prototype.constructor = RuleStartState;

// Decision state for {@code A+} and {@code (A|B)+}.  It has two transitions:
//  one to the loop back to start of the block and one to exit.
//
function PlusLoopbackState() {
	DecisionState.call(this);
	this.stateType = ATNState.PLUS_LOOP_BACK;
	return this;
}

PlusLoopbackState.prototype = Object.create(DecisionState.prototype);
PlusLoopbackState.prototype.constructor = PlusLoopbackState;


// Start of {@code (A|B|...)+} loop. Technically a decision state, but
//  we don't use for code generation; somebody might need it, so I'm defining
//  it for completeness. In reality, the {@link PlusLoopbackState} node is the
//  real decision-making note for {@code A+}.
//
function PlusBlockStartState() {
	BlockStartState.call(this);
	this.stateType = ATNState.PLUS_BLOCK_START;
    this.loopBackState = null;
    return this;
}

PlusBlockStartState.prototype = Object.create(BlockStartState.prototype);
PlusBlockStartState.prototype.constructor = PlusBlockStartState;

// The block that begins a closure loop.
function StarBlockStartState() {
	BlockStartState.call(this);
	this.stateType = ATNState.STAR_BLOCK_START;
	return this;
}

StarBlockStartState.prototype = Object.create(BlockStartState.prototype);
StarBlockStartState.prototype.constructor = StarBlockStartState;


function StarLoopbackState() {
	ATNState.call(this);
	this.stateType = ATNState.STAR_LOOP_BACK;
	return this;
}

StarLoopbackState.prototype = Object.create(ATNState.prototype);
StarLoopbackState.prototype.constructor = StarLoopbackState;


function StarLoopEntryState() {
	DecisionState.call(this);
	this.stateType = ATNState.STAR_LOOP_ENTRY;
    this.loopBackState = null;
    // Indicates whether this state can benefit from a precedence DFA during SLL decision making.
    this.isPrecedenceDecision = null;
    return this;
}

StarLoopEntryState.prototype = Object.create(DecisionState.prototype);
StarLoopEntryState.prototype.constructor = StarLoopEntryState;


// Mark the end of a * or + loop.
function LoopEndState() {
	ATNState.call(this);
	this.stateType = ATNState.LOOP_END;
	this.loopBackState = null;
	return this;
}

LoopEndState.prototype = Object.create(ATNState.prototype);
LoopEndState.prototype.constructor = LoopEndState;


// The Tokens rule start state linking to each lexer rule start state */
function TokensStartState() {
	DecisionState.call(this);
	this.stateType = ATNState.TOKEN_START;
	return this;
}

TokensStartState.prototype = Object.create(DecisionState.prototype);
TokensStartState.prototype.constructor = TokensStartState;

exports.ATNState = ATNState;
exports.BasicState = BasicState;
exports.DecisionState = DecisionState;
exports.BlockStartState = BlockStartState;
exports.BlockEndState = BlockEndState;
exports.LoopEndState = LoopEndState;
exports.RuleStartState = RuleStartState;
exports.RuleStopState = RuleStopState;
exports.TokensStartState = TokensStartState;
exports.PlusLoopbackState = PlusLoopbackState;
exports.StarLoopbackState = StarLoopbackState;
exports.StarLoopEntryState = StarLoopEntryState;
exports.PlusBlockStartState = PlusBlockStartState;
exports.StarBlockStartState = StarBlockStartState;
exports.BasicBlockStartState = BasicBlockStartState;


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
///

// The basic notion of a tree has a parent, a payload, and a list of children.
//  It is the most abstract interface for all the trees used by ANTLR.
///

var Token = __webpack_require__(18).Token;
var Interval = __webpack_require__(25).Interval;
var INVALID_INTERVAL = new Interval(-1, -2);
var Utils = __webpack_require__(13);


function Tree() {
	return this;
}

function SyntaxTree() {
	Tree.call(this);
	return this;
}

SyntaxTree.prototype = Object.create(Tree.prototype);
SyntaxTree.prototype.constructor = SyntaxTree;

function ParseTree() {
	SyntaxTree.call(this);
	return this;
}

ParseTree.prototype = Object.create(SyntaxTree.prototype);
ParseTree.prototype.constructor = ParseTree;

function RuleNode() {
	ParseTree.call(this);
	return this;
}

RuleNode.prototype = Object.create(ParseTree.prototype);
RuleNode.prototype.constructor = RuleNode;

function TerminalNode() {
	ParseTree.call(this);
	return this;
}

TerminalNode.prototype = Object.create(ParseTree.prototype);
TerminalNode.prototype.constructor = TerminalNode;

function ErrorNode() {
	TerminalNode.call(this);
	return this;
}

ErrorNode.prototype = Object.create(TerminalNode.prototype);
ErrorNode.prototype.constructor = ErrorNode;

function ParseTreeVisitor() {
	return this;
}

ParseTreeVisitor.prototype.visit = function(ctx) {
 	if (Array.isArray(ctx)) {
		return ctx.map(function(child) {
            return child.accept(this);
        }, this);
	} else {
		return ctx.accept(this);
	}
};

ParseTreeVisitor.prototype.visitChildren = function(ctx) {
  return this.visit(ctx.children);
}

ParseTreeVisitor.prototype.visitTerminal = function(node) {
};

ParseTreeVisitor.prototype.visitErrorNode = function(node) {
};


function ParseTreeListener() {
	return this;
}

ParseTreeListener.prototype.visitTerminal = function(node) {
};

ParseTreeListener.prototype.visitErrorNode = function(node) {
};

ParseTreeListener.prototype.enterEveryRule = function(node) {
};

ParseTreeListener.prototype.exitEveryRule = function(node) {
};

function TerminalNodeImpl(symbol) {
	TerminalNode.call(this);
	this.parentCtx = null;
	this.symbol = symbol;
	return this;
}

TerminalNodeImpl.prototype = Object.create(TerminalNode.prototype);
TerminalNodeImpl.prototype.constructor = TerminalNodeImpl;

TerminalNodeImpl.prototype.getChild = function(i) {
	return null;
};

TerminalNodeImpl.prototype.getSymbol = function() {
	return this.symbol;
};

TerminalNodeImpl.prototype.getParent = function() {
	return this.parentCtx;
};

TerminalNodeImpl.prototype.getPayload = function() {
	return this.symbol;
};

TerminalNodeImpl.prototype.getSourceInterval = function() {
	if (this.symbol === null) {
		return INVALID_INTERVAL;
	}
	var tokenIndex = this.symbol.tokenIndex;
	return new Interval(tokenIndex, tokenIndex);
};

TerminalNodeImpl.prototype.getChildCount = function() {
	return 0;
};

TerminalNodeImpl.prototype.accept = function(visitor) {
	return visitor.visitTerminal(this);
};

TerminalNodeImpl.prototype.getText = function() {
	return this.symbol.text;
};

TerminalNodeImpl.prototype.toString = function() {
	if (this.symbol.type === Token.EOF) {
		return "<EOF>";
	} else {
		return this.symbol.text;
	}
};

// Represents a token that was consumed during resynchronization
// rather than during a valid match operation. For example,
// we will create this kind of a node during single token insertion
// and deletion as well as during "consume until error recovery set"
// upon no viable alternative exceptions.

function ErrorNodeImpl(token) {
	TerminalNodeImpl.call(this, token);
	return this;
}

ErrorNodeImpl.prototype = Object.create(TerminalNodeImpl.prototype);
ErrorNodeImpl.prototype.constructor = ErrorNodeImpl;

ErrorNodeImpl.prototype.isErrorNode = function() {
	return true;
};

ErrorNodeImpl.prototype.accept = function(visitor) {
	return visitor.visitErrorNode(this);
};

function ParseTreeWalker() {
	return this;
}

ParseTreeWalker.prototype.walk = function(listener, t) {
	var errorNode = t instanceof ErrorNode ||
			(t.isErrorNode !== undefined && t.isErrorNode());
	if (errorNode) {
		listener.visitErrorNode(t);
	} else if (t instanceof TerminalNode) {
		listener.visitTerminal(t);
	} else {
		this.enterRule(listener, t);
		for (var i = 0; i < t.getChildCount(); i++) {
			var child = t.getChild(i);
			this.walk(listener, child);
		}
		this.exitRule(listener, t);
	}
};
//
// The discovery of a rule node, involves sending two events: the generic
// {@link ParseTreeListener//enterEveryRule} and a
// {@link RuleContext}-specific event. First we trigger the generic and then
// the rule specific. We to them in reverse order upon finishing the node.
//
ParseTreeWalker.prototype.enterRule = function(listener, r) {
	var ctx = r.getRuleContext();
	listener.enterEveryRule(ctx);
	ctx.enterRule(listener);
};

ParseTreeWalker.prototype.exitRule = function(listener, r) {
	var ctx = r.getRuleContext();
	ctx.exitRule(listener);
	listener.exitEveryRule(ctx);
};

ParseTreeWalker.DEFAULT = new ParseTreeWalker();

exports.RuleNode = RuleNode;
exports.ErrorNode = ErrorNode;
exports.TerminalNode = TerminalNode;
exports.ErrorNodeImpl = ErrorNodeImpl;
exports.TerminalNodeImpl = TerminalNodeImpl;
exports.ParseTreeListener = ParseTreeListener;
exports.ParseTreeVisitor = ParseTreeVisitor;
exports.ParseTreeWalker = ParseTreeWalker;
exports.INVALID_INTERVAL = INVALID_INTERVAL;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

// The root of the ANTLR exception hierarchy. In general, ANTLR tracks just
//  3 kinds of errors: prediction errors, failed predicate errors, and
//  mismatched input errors. In each case, the parser knows where it is
//  in the input, where it is in the ATN, the rule invocation stack,
//  and what kind of problem occurred.

var PredicateTransition = __webpack_require__(59).PredicateTransition;

function RecognitionException(params) {
	Error.call(this);
	if (!!Error.captureStackTrace) {
        Error.captureStackTrace(this, RecognitionException);
	} else {
		var stack = new Error().stack;
	}
	this.message = params.message;
    this.recognizer = params.recognizer;
    this.input = params.input;
    this.ctx = params.ctx;
    // The current {@link Token} when an error occurred. Since not all streams
    // support accessing symbols by index, we have to track the {@link Token}
    // instance itself.
    this.offendingToken = null;
    // Get the ATN state number the parser was in at the time the error
    // occurred. For {@link NoViableAltException} and
    // {@link LexerNoViableAltException} exceptions, this is the
    // {@link DecisionState} number. For others, it is the state whose outgoing
    // edge we couldn't match.
    this.offendingState = -1;
    if (this.recognizer!==null) {
        this.offendingState = this.recognizer.state;
    }
    return this;
}

RecognitionException.prototype = Object.create(Error.prototype);
RecognitionException.prototype.constructor = RecognitionException;

// <p>If the state number is not known, this method returns -1.</p>

//
// Gets the set of input symbols which could potentially follow the
// previously matched symbol at the time this exception was thrown.
//
// <p>If the set of expected tokens is not known and could not be computed,
// this method returns {@code null}.</p>
//
// @return The set of token types that could potentially follow the current
// state in the ATN, or {@code null} if the information is not available.
// /
RecognitionException.prototype.getExpectedTokens = function() {
    if (this.recognizer!==null) {
        return this.recognizer.atn.getExpectedTokens(this.offendingState, this.ctx);
    } else {
        return null;
    }
};

RecognitionException.prototype.toString = function() {
    return this.message;
};

function LexerNoViableAltException(lexer, input, startIndex, deadEndConfigs) {
	RecognitionException.call(this, {message:"", recognizer:lexer, input:input, ctx:null});
    this.startIndex = startIndex;
    this.deadEndConfigs = deadEndConfigs;
    return this;
}

LexerNoViableAltException.prototype = Object.create(RecognitionException.prototype);
LexerNoViableAltException.prototype.constructor = LexerNoViableAltException;

LexerNoViableAltException.prototype.toString = function() {
    var symbol = "";
    if (this.startIndex >= 0 && this.startIndex < this.input.size) {
        symbol = this.input.getText((this.startIndex,this.startIndex));
    }
    return "LexerNoViableAltException" + symbol;
};

// Indicates that the parser could not decide which of two or more paths
// to take based upon the remaining input. It tracks the starting token
// of the offending input and also knows where the parser was
// in the various paths when the error. Reported by reportNoViableAlternative()
//
function NoViableAltException(recognizer, input, startToken, offendingToken, deadEndConfigs, ctx) {
	ctx = ctx || recognizer._ctx;
	offendingToken = offendingToken || recognizer.getCurrentToken();
	startToken = startToken || recognizer.getCurrentToken();
	input = input || recognizer.getInputStream();
	RecognitionException.call(this, {message:"", recognizer:recognizer, input:input, ctx:ctx});
    // Which configurations did we try at input.index() that couldn't match
	// input.LT(1)?//
    this.deadEndConfigs = deadEndConfigs;
    // The token object at the start index; the input stream might
    // not be buffering tokens so get a reference to it. (At the
    // time the error occurred, of course the stream needs to keep a
    // buffer all of the tokens but later we might not have access to those.)
    this.startToken = startToken;
    this.offendingToken = offendingToken;
}

NoViableAltException.prototype = Object.create(RecognitionException.prototype);
NoViableAltException.prototype.constructor = NoViableAltException;

// This signifies any kind of mismatched input exceptions such as
// when the current input does not match the expected token.
//
function InputMismatchException(recognizer) {
	RecognitionException.call(this, {message:"", recognizer:recognizer, input:recognizer.getInputStream(), ctx:recognizer._ctx});
    this.offendingToken = recognizer.getCurrentToken();
}

InputMismatchException.prototype = Object.create(RecognitionException.prototype);
InputMismatchException.prototype.constructor = InputMismatchException;

// A semantic predicate failed during validation. Validation of predicates
// occurs when normally parsing the alternative just like matching a token.
// Disambiguating predicate evaluation occurs when we test a predicate during
// prediction.

function FailedPredicateException(recognizer, predicate, message) {
	RecognitionException.call(this, {message:this.formatMessage(predicate,message || null), recognizer:recognizer,
                         input:recognizer.getInputStream(), ctx:recognizer._ctx});
    var s = recognizer._interp.atn.states[recognizer.state];
    var trans = s.transitions[0];
    if (trans instanceof PredicateTransition) {
        this.ruleIndex = trans.ruleIndex;
        this.predicateIndex = trans.predIndex;
    } else {
        this.ruleIndex = 0;
        this.predicateIndex = 0;
    }
    this.predicate = predicate;
    this.offendingToken = recognizer.getCurrentToken();
    return this;
}

FailedPredicateException.prototype = Object.create(RecognitionException.prototype);
FailedPredicateException.prototype.constructor = FailedPredicateException;

FailedPredicateException.prototype.formatMessage = function(predicate, message) {
    if (message !==null) {
        return message;
    } else {
        return "failed predicate: {" + predicate + "}?";
    }
};

function ParseCancellationException() {
	Error.call(this);
	Error.captureStackTrace(this, ParseCancellationException);
	return this;
}

ParseCancellationException.prototype = Object.create(Error.prototype);
ParseCancellationException.prototype.constructor = ParseCancellationException;

exports.RecognitionException = RecognitionException;
exports.NoViableAltException = NoViableAltException;
exports.LexerNoViableAltException = LexerNoViableAltException;
exports.InputMismatchException = InputMismatchException;
exports.FailedPredicateException = FailedPredicateException;
exports.ParseCancellationException = ParseCancellationException;


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

var AttributeDeclaration = __webpack_require__(70).AttributeDeclaration;
var BaseDeclaration = __webpack_require__(110).BaseDeclaration;
var CategoryType = __webpack_require__(7).CategoryType;
var TypeUtils = __webpack_require__(83);
var Identifier = __webpack_require__(0).Identifier;
var DocumentValue = __webpack_require__(66).DocumentValue;
var NullValue = __webpack_require__(21).NullValue;

function CategoryDeclaration(id, attributes) {
	BaseDeclaration.call(this, id);
	this.attributes = attributes || null;
	this.derivedFrom = null;
    this.storable = false;
    return this;
}

CategoryDeclaration.prototype = Object.create(BaseDeclaration.prototype);
CategoryDeclaration.prototype.constructor = CategoryDeclaration;

CategoryDeclaration.prototype.getDeclarationType = function() {
    return "Category";
};

CategoryDeclaration.prototype.isWidget = function(context) {
    return false;
};

CategoryDeclaration.prototype.newInstanceFromStored = function(context, stored) {
    var instance = this.newInstance(context);
    instance.mutable = true;
    try {
        var dbId = stored.dbId;
        var value = TypeUtils.convertFromJavaScript(dbId);
        instance.setMember(context, "dbId", value);
        var allAttributes = this.getAllAttributes(context);
        allAttributes.forEach(function(name) {
            var decl = context.getRegisteredDeclaration(name);
            if (decl.storable) {
                var data = stored.getData(name);
                var value = data==null ? NullValue.instance : decl.getType(context).convertJavaScriptValueToPromptoValue(context, data, null)
                instance.setMember(context, name, value);
            }
        }, this);
    } finally {
        instance.mutable = false;
    }
    return instance;
};

CategoryDeclaration.prototype.getLocalAttributes = function() {
    return this.attributes;
};

CategoryDeclaration.prototype.getAllAttributes = function(context) {
    var attributes = this.getLocalAttributes();
    if(attributes)
        return new Set(attributes);
    else
        return null;
};


CategoryDeclaration.prototype.register = function(context) {
	context.registerDeclaration(this);
    this.registerMethods(context);
};

CategoryDeclaration.prototype.check = function(context, isStart) {
	if(this.attributes!=null) {
		this.attributes.forEach(function(id) {
			var ad = context.getRegisteredDeclaration(id.name);
			if (ad == null)
                context.problemListener.reportUnknownAttribute(id)
		});
	}
	return new CategoryType(this.id);
}

CategoryDeclaration.prototype.getType = function(context) {
	return new CategoryType(this.id);
};

CategoryDeclaration.prototype.hasAttribute = function(context, name) {
    if (name === "dbId")
        return this.storable;
    else if (this.attributes == null)
        return false;
    else {
        for (var i = 0; i < this.attributes.length; i++ ) {
            if (name === this.attributes[i].name)
                return true;
        }
        return false;
    }
};

CategoryDeclaration.prototype.hasMethod = function(context, key) {
	return false;
};

CategoryDeclaration.prototype.isDerivedFrom = function(context, categoryType) {
	return false;
};


CategoryDeclaration.prototype.checkConstructorContext = function(context) {
	// nothing to do
};

CategoryDeclaration.prototype.toDialect = function(writer) {
    var type = this.getType(writer.context);
    writer = writer.newInstanceWriter(type);
    writer.toDialect(this);
};


CategoryDeclaration.prototype.protoToEDialect = function(writer, hasMethods, hasBindings) {
    var hasAttributes = this.attributes!=null && this.attributes.length>0;
    writer.append("define ");
    writer.append(this.name);
    writer.append(" as ");
    if(this.storable)
        writer.append("storable ");
    this.categoryTypeToEDialect(writer);
    if(hasAttributes) {
        if(this.attributes.length==1)
            writer.append(" with attribute ");
        else
            writer.append(" with attributes ");
        this.attributes.toDialect(writer, true);
    }
    if(hasMethods) {
        if(hasAttributes)
            writer.append(", and methods:");
        else
            writer.append(" with methods:");
    } else if (hasBindings) {
        if(hasAttributes)
            writer.append(", and bindings:");
        else
            writer.append(" with bindings:");
    }
    writer.newLine();
};


CategoryDeclaration.prototype.methodsToEDialect = function(writer, methods) {
    writer.indent();
    methods.forEach(function(method) {
        writer.newLine();
        if(method.comments) {
            method.comments.forEach(function (cmt) {
                cmt.toDialect(writer);
            });
        }
        if(method.annotations) {
            method.annotations.forEach(function (ann) {
                ann.toDialect(writer);
            });
        }
        var w = writer.newMemberWriter();
        method.toDialect(w);
    });
    writer.dedent();
};

CategoryDeclaration.prototype.methodsToODialect = function(writer, methods) {
    methods.forEach(function(method) {
        if(method.comments) {
            method.comments.forEach(function (cmt) {
                cmt.toDialect(writer);
            });
        }
        if(method.annotations) {
            method.annotations.forEach(function (ann) {
                ann.toDialect(writer);
            });
        }
        var w = writer.newMemberWriter();
        method.toDialect(w);
        w.newLine();
    });
}


CategoryDeclaration.prototype.allToODialect = function(writer, hasBody) {
    if(this.storable)
        writer.append("storable ");
    this.categoryTypeToODialect(writer);
    writer.append(" ");
    writer.append(this.name);
    if(this.attributes!=null) {
        writer.append('(');
        this.attributes.toDialect(writer, true);
        writer.append(')');
    }
    this.categoryExtensionToODialect(writer);
    if(hasBody) {
        writer.append(" {\n");
        writer.newLine();
        writer.indent();
        this.bodyToODialect(writer);
        writer.dedent();
        writer.append('}');
        writer.newLine();
    } else
        writer.append(';');
};

CategoryDeclaration.prototype.categoryExtensionToODialect = function(writer) {
    // by default no extension
};


CategoryDeclaration.prototype.protoToMDialect = function(writer, derivedFrom) {
    if(this.storable)
        writer.append("storable ");
    this.categoryTypeToMDialect(writer);
    writer.append(" ");
    writer.append(this.name);
    writer.append("(");
    if(this.derivedFrom!=null) {
        this.derivedFrom.toDialect(writer, false);
        if(this.attributes!=null)
            writer.append(", ");
    }
    if(this.attributes!=null)
        this.attributes.toDialect(writer, false);
    writer.append("):\n");
};


exports.CategoryDeclaration = CategoryDeclaration;



/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

var PromptoError = __webpack_require__(30).PromptoError;

function InternalError(message) {
	PromptoError.call(this, message);
	return this;
}

InternalError.prototype = Object.create(InternalError.prototype);
InternalError.prototype.constructor = InternalError;

exports.InternalError = InternalError;


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

var SyntaxError = __webpack_require__(32).SyntaxError;
var EnumeratedNativeType = null;
var VoidType = null;
var TextType = null;
var NullType = null;
var TupleValue = null;
var SetValue = null;
var ListValue = null;

exports.resolve = function() {
    EnumeratedNativeType = __webpack_require__(247).EnumeratedNativeType;
    VoidType = __webpack_require__(4).VoidType;
    TextType = __webpack_require__(6).TextType;
    NullType = __webpack_require__(113).NullType;
    TupleValue = __webpack_require__(85).TupleValue;
    SetValue = __webpack_require__(54).SetValue;
    ListValue = __webpack_require__(36).ListValue;
};

function BaseType(id) {
	this.id = id;
	return this;
};

Object.defineProperty(BaseType.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});


BaseType.prototype.getTranspiledName = function() {
    return this.name;
};


BaseType.prototype.toString = function() {
	return this.name;
};


BaseType.prototype.equals = function(other) {
    return (other instanceof BaseType) && this.name==other.name;
};


BaseType.prototype.isAssignableFrom = function(context, other) {
    return this==other || this.equals(other) || other.equals(NullType.instance);
};


BaseType.prototype.getMemberMethods = function(context, name) {
    return [];
};


BaseType.prototype.transpile = function(transpiler) {
    throw new Error("Transpile not implemented by " + this.constructor.name);
};


BaseType.prototype.transpileAssignMemberValue = function(transpiler, name, expression) {
    throw new SyntaxError("Cannot transpile assign member value from " + this.name);
};


BaseType.prototype.transpileAssignItemValue = function(transpiler, item, expression) {
    throw new SyntaxError("Cannot transpile assign item value from " + this.name);
};


BaseType.prototype.checkAdd = function(context, other, tryReverse) {
    if(other instanceof EnumeratedNativeType)
        return this.checkAdd(context, other.derivedFrom, tryReverse);
    else if(tryReverse)
        return other.checkAdd(context, this, false);
    else
	    throw new SyntaxError("Cannot add " + this.name + " to " + other.name);
};


BaseType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.declareAdd(transpiler, other.derivedFrom, tryReverse, left, right);
    else if(tryReverse)
        return other.declareAdd(transpiler, this, false, right, left);
    else
        throw new SyntaxError("Cannot declare add " + this.name + " to " + other.name);
};


BaseType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.transpileAdd(transpiler, other.derivedFrom, tryReverse, left, right);
    else if(tryReverse)
        return other.transpileAdd(transpiler, this, false, right, left);
    else
        throw new SyntaxError("Cannot transpile add " + this.name + " to " + other.name);
};


BaseType.prototype.checkSubtract = function(context, other) {
    if(other instanceof EnumeratedNativeType)
        return this.checkSubtract(context, other.derivedFrom);
    else
        throw new SyntaxError("Cannot substract " + this.name + " from " + other.name);
};


BaseType.prototype.declareSubtract = function(transpiler, other, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.declareSubtract(transpiler, other.derivedFrom, left, right);
    else
        throw new SyntaxError("Cannot declare substract " + this.name + " to " + other.name);
};


BaseType.prototype.transpileSubtract = function(transpiler, other, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.transpileSubtract(transpiler, other.derivedFrom, left, right);
    else
        throw new SyntaxError("Cannot transpile substract " + this.name + " to " + other.name);
};


BaseType.prototype.checkDivide = function(context, other) {
    if(other instanceof EnumeratedNativeType)
        return this.checkDivide(context, other.derivedFrom);
    else
        throw new SyntaxError("Cannot divide " + this.name + " with " + other.name);
};


BaseType.prototype.declareDivide = function(transpiler, other, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.declareDivide(transpiler, other.derivedFrom, left, right);
    else
        throw new SyntaxError("Cannot declare divide " + this.name + " to " + other.name);
};


BaseType.prototype.transpileDivide = function(transpiler, other, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.transpileDivide(transpiler, other.derivedFrom, left, right);
    else
        throw new SyntaxError("Cannot transpile divide " + this.name + " to " + other.name);
};


BaseType.prototype.checkIntDivide = function(context, other) {
    if(other instanceof EnumeratedNativeType)
        return this.checkIntDivide(context, other.derivedFrom);
    else
    	throw new SyntaxError("Cannot divide " + this.name + " with " + other.name);
};


BaseType.prototype.declareIntDivide = function(transpiler, other, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.declareIntDivide(transpiler, other.derivedFrom, left, right);
    else
        throw new SyntaxError("Cannot declare int divide " + this.name + " to " + other.name);
};


BaseType.prototype.transpileIntDivide = function(transpiler, other, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.transpileIntDivide(transpiler, other.derivedFrom, left, right);
    else
        throw new SyntaxError("Cannot transpile int divide " + this.name + " to " + other.name);
};


BaseType.prototype.checkModulo = function(context, other) {
    if(other instanceof EnumeratedNativeType)
        return this.checkModulo(context, other.derivedFrom);
    else
    	throw new SyntaxError("Cannot modulo " + this.name + " with " + other.name);
};


BaseType.prototype.declareModulo = function(transpiler, other, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.declareModulo(transpiler, other.derivedFrom, left, right);
    else
        throw new SyntaxError("Cannot declare modulo " + this.name + " to " + other.name);
};

BaseType.prototype.transpileModulo = function(transpiler, other, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.transpileModulo(transpiler, other.derivedFrom, left, right);
    else
        throw new SyntaxError("Cannot transpile modulo " + this.name + " to " + other.name);
};


BaseType.prototype.checkMultiply = function(context, other, tryReverse) {
    if(other instanceof EnumeratedNativeType)
        return this.checkMultiply(context, other.derivedFrom, tryReverse);
    else if(tryReverse)
        return other.checkMultiply(context, this, false);
    else
	    throw new SyntaxError("Cannot multiply " + this.name + " with " + other.name);
};

BaseType.prototype.declareMultiply = function(transpiler, other, tryReverse, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.declareMultiply(transpiler, other.derivedFrom, tryReverse, left, right);
    else if(tryReverse)
        return other.declareMultiply(transpiler, this, false, right, left);
    else
        throw new SyntaxError("Cannot declare multiply " + this.name + " to " + other.name);
};


BaseType.prototype.transpileMultiply = function(transpiler, other, tryReverse, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.transpileMultiply(transpiler, other.derivedFrom, tryReverse, left, right);
    else if(tryReverse)
        return other.transpileMultiply(transpiler, this, false, right, left);
    else
        throw new SyntaxError("Cannot transpile multiply " + this.name + " to " + other.name);
};


BaseType.prototype.checkMinus = function(context) {
    if(this instanceof EnumeratedNativeType)
        return this.derivedFrom.checkMinus(context);
    else
	    throw new SyntaxError("Cannot negate " + this.name);
};


BaseType.prototype.declareMinus = function(transpiler, value) {
    if(this instanceof EnumeratedNativeType)
        return this.derivedFrom.declareMinus(transpiler, value);
    else
        throw new SyntaxError("Cannot declare negate " + this.name);
};


BaseType.prototype.transpileMinus = function(transpiler, value) {
    if(this instanceof EnumeratedNativeType)
        return this.derivedFrom.transpileMinus(transpiler, value);
    else
        throw new SyntaxError("Cannot transpile negate of " + this.name );
};


BaseType.prototype.checkCompare = function(context, other) {
    if(other instanceof EnumeratedNativeType)
        return this.checkCompare(context, other.derivedFrom);
    else
    	throw new SyntaxError("Cannot compare " + this.name + " to " + other.name);
};


BaseType.prototype.declareCompare = function(transpiler, other) {
    if(other instanceof EnumeratedNativeType)
        return this.declareCompare(transpiler, other.derivedFrom);
    else
        throw new SyntaxError(this.name + " cannot declare compare " + other.name);
};


BaseType.prototype.transpileCompare = function(transpiler, other, operator, left, right) {
    if(other instanceof EnumeratedNativeType)
        return this.transpileCompare(transpiler, other.derivedFrom, operator, left, right);
    else
        throw new SyntaxError(this.name + " cannot transpile compare " + other.name);
};


BaseType.prototype.checkContains = function(context, other) {
    if(other instanceof EnumeratedNativeType)
        return this.checkContains(context, other.derivedFrom);
    else
    	throw new SyntaxError(this.name + " cannot contain " + other.name);
};


BaseType.prototype.declareContains = function(transpiler, other, container, item) {
    if(other instanceof EnumeratedNativeType)
        return this.declareContains(transpiler, other.derivedFrom, container, item);
    else
        throw new SyntaxError(this.name + " cannot declare contain " + other.name);
};

BaseType.prototype.transpileContains = function(transpiler, other, container, item) {
    if(other instanceof EnumeratedNativeType)
        return this.transpileContains(transpiler, other.derivedFrom, container, item);
    else
        throw new SyntaxError(this.name + " cannot transpile contain " + other.name);
};


BaseType.prototype.checkContainsAllOrAny = function(context, other) {
    if(other instanceof EnumeratedNativeType)
        return this.checkContainsAllOrAny(context, other.derivedFrom);
    else
    	throw new SyntaxError(this.name + " cannot contain all or any " + other.name);
};

BaseType.prototype.declareContainsAllOrAny = function(transpiler, other, container, item) {
    if(other instanceof EnumeratedNativeType)
        return this.declareContainsAllOrAny(transpiler, other.derivedFrom, container, item);
    else
        throw new SyntaxError(this.name + " cannot declare contain all or any " + other.name);
};


BaseType.prototype.transpileContainsAll = function(transpiler, other, container, item) {
    if(other instanceof EnumeratedNativeType)
        return this.transpileContainsAll(transpiler, other.derivedFrom, container, item);
    else
        throw new SyntaxError(this.name + " cannot transpile contain all " + other.name);
};

BaseType.prototype.transpileContainsAny = function(transpiler, other, container, item) {
    if(other instanceof EnumeratedNativeType)
        return this.transpileContainsAny(transpiler, other.derivedFrom, container, item);
    else
        throw new SyntaxError(this.name + " cannot transpile contain any " + other.name);
};



BaseType.prototype.checkItem = function(context, itemType) {
    if(itemType instanceof EnumeratedNativeType)
        return this.checkItem(context, itemType.derivedFrom);
    else
    	throw new SyntaxError("Cannot read item from " + this.name);
};


BaseType.prototype.declareItem = function(transpiler, itemType, item) {
    if(itemType instanceof EnumeratedNativeType)
        return this.declareItem(transpiler, itemType.derivedFrom, item);
    else
        throw new SyntaxError("Cannot declare item from: " + this.name);
};

BaseType.prototype.transpileItem = function(transpiler, itemType, item) {
    if(itemType instanceof EnumeratedNativeType)
        return this.transpileItem(transpiler, itemType.derivedFrom);
    else
        throw new SyntaxError("Cannot transpile item from: " + this.name);
};



BaseType.prototype.checkMember = function(context, section, name) {
    if("text" == name)
        return TextType.instance;
    else
        context.problemListener.reportInvalidMember(section, name);
};


BaseType.prototype.declareMember = function(transpiler, name) {
    if("text" !== name)
        throw new SyntaxError("Cannot declare member: " + name + " from " + this.name);
};

BaseType.prototype.transpileMember = function(transpiler, name) {
    if("text" == name)
        transpiler.append("getText()");
    else
        throw new SyntaxError("Cannot transpile member: " + name + " from " + this.name);
};


BaseType.prototype.checkSlice = function(context) {
	throw new SyntaxError("Cannot slice " + this.name);
};


BaseType.prototype.declareSlice = function(transpiler, first, last) {
    throw new SyntaxError("Cannot declare slice for " + this.name);
};


BaseType.prototype.transpileSlice = function(transpiler, first, last) {
    throw new SyntaxError("Cannot transpile slice for " + this.name);
};

BaseType.prototype.checkIterator = function(context, source) {
    context.problemListener.reportCannotIterate(source);
    return VoidType.instance;
};


BaseType.prototype.declareIterator = function(transpiler, name, expression) {
    throw new SyntaxError("Cannot declare iterate over " + this.name);
};

BaseType.prototype.transpileIterator = function(transpiler, name, expression) {
    throw new SyntaxError("Cannot transpile iterate over " + this.name);
};


BaseType.prototype.checkAssignableFrom = function(context, other, section) {
	if (!this.isAssignableFrom(context, other))
	    context.problemListener.reportIncompatibleTypes(section, this, other);
};

BaseType.prototype.checkRange = function(context, other) {
	throw new SyntaxError("Cannot create range of " + this.name + " and " + other.name);
};

BaseType.prototype.declareRange = function(context, other) {
    throw new SyntaxError("Cannot declare range of " + this.name + " and " + other.name);
};


BaseType.prototype.transpileRange = function(transpiler, first, last) {
    throw new SyntaxError("Cannot transpile range of " + this.name);
};


BaseType.prototype.checkAnd = function(context, other) {
	throw new SyntaxError("Cannot logically combine " + this.name + " and " + other.name);
};

BaseType.prototype.checkOr = function(context, other) {
	throw new SyntaxError("Cannot logically combine " + this.name + " or " + other.name);
};

BaseType.prototype.checkNot = function(context) {
	throw new SyntaxError("Cannot logically negate " + this.name);
};

BaseType.prototype.getMember = function(context, name) {
    throw new SyntaxError("Cannot read member from " + this.name);
};


BaseType.prototype.readJSONValue = function(context, node, parts) {
    throw new Error("Unsupported!")
};


BaseType.prototype.declareSorted = function(transpiler, key) {
    throw new Error("Cannot declare sorted from " + this.name);
};

BaseType.prototype.sort = function(context, list, desc) {
    throw new Error("Unsupported!")
};


BaseType.prototype.doSort = function(context, list, cmp, desc) {
	// only sort if required
	if(list.size()<=1) {
		return list;
	}
    // create result list we can sort in place
    var items = null;
    if( list instanceof ListValue || list instanceof TupleValue) {
        items = [].concat(list.items);
    } else if ( list instanceof SetValue) {
        items = Array.from(list.items.set.values());
    }
    items.sort(cmp);
    if(desc)
        items.reverse(); // TODO optimize
	return new ListValue(list.type.itemType, items);
};

BaseType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
	return value; // TODO for now
};

BaseType.prototype.toDialect = function(writer) {
    writer.append(this.name);
};

exports.BaseType = BaseType;


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

var PromptoError = __webpack_require__(30).PromptoError;
var ErrorVariable = __webpack_require__(180).ErrorVariable;

function ExecutionError(message) {
	PromptoError.call(this, message);
	return this;
}

ExecutionError.prototype = Object.create(PromptoError.prototype);
ExecutionError.prototype.constructor = ExecutionError;

ExecutionError.prototype.interpret = function(context, errorName) {
    var exp = this.getExpression(context);
    if(exp==null) {
        var ArgumentAssignmentList = __webpack_require__(39).ArgumentAssignmentList;
        var ArgumentAssignment = __webpack_require__(40).ArgumentAssignment;
        var UnresolvedArgument = __webpack_require__(144).UnresolvedArgument;
        var TextLiteral = __webpack_require__(74).TextLiteral;
        var ConstructorExpression = __webpack_require__(106).ConstructorExpression;
        var CategoryType = __webpack_require__(7).CategoryType;
        var args = new ArgumentAssignmentList();
        args.add(new ArgumentAssignment(new UnresolvedArgument("name"), new TextLiteral('"' + this.name + '"')));
        args.add(new ArgumentAssignment(new UnresolvedArgument("text"), new TextLiteral('"' + this.message + '"')));
        exp = new ConstructorExpression(new CategoryType("Error"), args);
    }
    if(context.getRegisteredValue(errorName)==null)
        context.registerValue(new ErrorVariable(errorName));
    var error = exp.interpret(context);
    context.setValue(errorName, error);
    return error;
};

exports.ExecutionError = ExecutionError;


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

var ExecutionError = __webpack_require__(48).ExecutionError;

function NullReferenceError() {
	ExecutionError.call(this);
	return this;
}

NullReferenceError.prototype = Object.create(ExecutionError.prototype);
NullReferenceError.prototype.constructor = NullReferenceError;

NullReferenceError.prototype.getExpression = function(context) {
	return context.getRegisteredValue("NULL_REFERENCE");
};

exports.NullReferenceError = NullReferenceError;


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

var MemStore = __webpack_require__(295).MemStore;

function DataStore() {

}

DataStore.instance = new MemStore();

exports.DataStore = DataStore;


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
///

var RuleContext = __webpack_require__(135).RuleContext;
var Hash = __webpack_require__(13).Hash;

function PredictionContext(cachedHashCode) {
	this.cachedHashCode = cachedHashCode;
}

// Represents {@code $} in local context prediction, which means wildcard.
// {@code//+x =//}.
// /
PredictionContext.EMPTY = null;

// Represents {@code $} in an array in full context mode, when {@code $}
// doesn't mean wildcard: {@code $ + x = [$,x]}. Here,
// {@code $} = {@link //EMPTY_RETURN_STATE}.
// /
PredictionContext.EMPTY_RETURN_STATE = 0x7FFFFFFF;

PredictionContext.globalNodeCount = 1;
PredictionContext.id = PredictionContext.globalNodeCount;

// Stores the computed hash code of this {@link PredictionContext}. The hash
// code is computed in parts to match the following reference algorithm.
//
// <pre>
// private int referenceHashCode() {
// int hash = {@link MurmurHash//initialize MurmurHash.initialize}({@link
// //INITIAL_HASH});
//
// for (int i = 0; i &lt; {@link //size()}; i++) {
// hash = {@link MurmurHash//update MurmurHash.update}(hash, {@link //getParent
// getParent}(i));
// }
//
// for (int i = 0; i &lt; {@link //size()}; i++) {
// hash = {@link MurmurHash//update MurmurHash.update}(hash, {@link
// //getReturnState getReturnState}(i));
// }
//
// hash = {@link MurmurHash//finish MurmurHash.finish}(hash, 2// {@link
// //size()});
// return hash;
// }
// </pre>
// /

// This means only the {@link //EMPTY} context is in set.
PredictionContext.prototype.isEmpty = function() {
	return this === PredictionContext.EMPTY;
};

PredictionContext.prototype.hasEmptyPath = function() {
	return this.getReturnState(this.length - 1) === PredictionContext.EMPTY_RETURN_STATE;
};

PredictionContext.prototype.hashCode = function() {
	return this.cachedHashCode;
};


PredictionContext.prototype.updateHashCode = function(hash) {
    hash.update(this.cachedHashCode);
};
/*
function calculateHashString(parent, returnState) {
	return "" + parent + returnState;
}
*/

// Used to cache {@link PredictionContext} objects. Its used for the shared
// context cash associated with contexts in DFA states. This cache
// can be used for both lexers and parsers.

function PredictionContextCache() {
	this.cache = {};
	return this;
}

// Add a context to the cache and return it. If the context already exists,
// return that one instead and do not add a new context to the cache.
// Protect shared cache from unsafe thread access.
//
PredictionContextCache.prototype.add = function(ctx) {
	if (ctx === PredictionContext.EMPTY) {
		return PredictionContext.EMPTY;
	}
	var existing = this.cache[ctx] || null;
	if (existing !== null) {
		return existing;
	}
	this.cache[ctx] = ctx;
	return ctx;
};

PredictionContextCache.prototype.get = function(ctx) {
	return this.cache[ctx] || null;
};

Object.defineProperty(PredictionContextCache.prototype, "length", {
	get : function() {
		return this.cache.length;
	}
});

function SingletonPredictionContext(parent, returnState) {
	var hashCode = 0;
	if(parent !== null) {
		var hash = new Hash();
		hash.update(parent, returnState);
        hashCode = hash.finish();
	}
	PredictionContext.call(this, hashCode);
	this.parentCtx = parent;
	this.returnState = returnState;
}

SingletonPredictionContext.prototype = Object.create(PredictionContext.prototype);
SingletonPredictionContext.prototype.contructor = SingletonPredictionContext;

SingletonPredictionContext.create = function(parent, returnState) {
	if (returnState === PredictionContext.EMPTY_RETURN_STATE && parent === null) {
		// someone can pass in the bits of an array ctx that mean $
		return PredictionContext.EMPTY;
	} else {
		return new SingletonPredictionContext(parent, returnState);
	}
};

Object.defineProperty(SingletonPredictionContext.prototype, "length", {
	get : function() {
		return 1;
	}
});

SingletonPredictionContext.prototype.getParent = function(index) {
	return this.parentCtx;
};

SingletonPredictionContext.prototype.getReturnState = function(index) {
	return this.returnState;
};

SingletonPredictionContext.prototype.equals = function(other) {
	if (this === other) {
		return true;
	} else if (!(other instanceof SingletonPredictionContext)) {
		return false;
	} else if (this.hashCode() !== other.hashCode()) {
		return false; // can't be same if hash is different
	} else {
		if(this.returnState !== other.returnState)
            return false;
        else if(this.parentCtx==null)
            return other.parentCtx==null
		else
            return this.parentCtx.equals(other.parentCtx);
	}
};

SingletonPredictionContext.prototype.toString = function() {
	var up = this.parentCtx === null ? "" : this.parentCtx.toString();
	if (up.length === 0) {
		if (this.returnState === PredictionContext.EMPTY_RETURN_STATE) {
			return "$";
		} else {
			return "" + this.returnState;
		}
	} else {
		return "" + this.returnState + " " + up;
	}
};

function EmptyPredictionContext() {
	SingletonPredictionContext.call(this, null, PredictionContext.EMPTY_RETURN_STATE);
	return this;
}

EmptyPredictionContext.prototype = Object.create(SingletonPredictionContext.prototype);
EmptyPredictionContext.prototype.constructor = EmptyPredictionContext;

EmptyPredictionContext.prototype.isEmpty = function() {
	return true;
};

EmptyPredictionContext.prototype.getParent = function(index) {
	return null;
};

EmptyPredictionContext.prototype.getReturnState = function(index) {
	return this.returnState;
};

EmptyPredictionContext.prototype.equals = function(other) {
	return this === other;
};

EmptyPredictionContext.prototype.toString = function() {
	return "$";
};

PredictionContext.EMPTY = new EmptyPredictionContext();

function ArrayPredictionContext(parents, returnStates) {
	// Parent can be null only if full ctx mode and we make an array
	// from {@link //EMPTY} and non-empty. We merge {@link //EMPTY} by using
	// null parent and
	// returnState == {@link //EMPTY_RETURN_STATE}.
	var h = new Hash();
	h.update(parents, returnStates);
	var hashCode = h.finish();
	PredictionContext.call(this, hashCode);
	this.parents = parents;
	this.returnStates = returnStates;
	return this;
}

ArrayPredictionContext.prototype = Object.create(PredictionContext.prototype);
ArrayPredictionContext.prototype.constructor = ArrayPredictionContext;

ArrayPredictionContext.prototype.isEmpty = function() {
	// since EMPTY_RETURN_STATE can only appear in the last position, we
	// don't need to verify that size==1
	return this.returnStates[0] === PredictionContext.EMPTY_RETURN_STATE;
};

Object.defineProperty(ArrayPredictionContext.prototype, "length", {
	get : function() {
		return this.returnStates.length;
	}
});

ArrayPredictionContext.prototype.getParent = function(index) {
	return this.parents[index];
};

ArrayPredictionContext.prototype.getReturnState = function(index) {
	return this.returnStates[index];
};

ArrayPredictionContext.prototype.equals = function(other) {
	if (this === other) {
		return true;
	} else if (!(other instanceof ArrayPredictionContext)) {
		return false;
	} else if (this.hashCode() !== other.hashCode()) {
		return false; // can't be same if hash is different
	} else {
		return this.returnStates === other.returnStates &&
				this.parents === other.parents;
	}
};

ArrayPredictionContext.prototype.toString = function() {
	if (this.isEmpty()) {
		return "[]";
	} else {
		var s = "[";
		for (var i = 0; i < this.returnStates.length; i++) {
			if (i > 0) {
				s = s + ", ";
			}
			if (this.returnStates[i] === PredictionContext.EMPTY_RETURN_STATE) {
				s = s + "$";
				continue;
			}
			s = s + this.returnStates[i];
			if (this.parents[i] !== null) {
				s = s + " " + this.parents[i];
			} else {
				s = s + "null";
			}
		}
		return s + "]";
	}
};

// Convert a {@link RuleContext} tree to a {@link PredictionContext} graph.
// Return {@link //EMPTY} if {@code outerContext} is empty or null.
// /
function predictionContextFromRuleContext(atn, outerContext) {
	if (outerContext === undefined || outerContext === null) {
		outerContext = RuleContext.EMPTY;
	}
	// if we are in RuleContext of start rule, s, then PredictionContext
	// is EMPTY. Nobody called us. (if we are empty, return empty)
	if (outerContext.parentCtx === null || outerContext === RuleContext.EMPTY) {
		return PredictionContext.EMPTY;
	}
	// If we have a parent, convert it to a PredictionContext graph
	var parent = predictionContextFromRuleContext(atn, outerContext.parentCtx);
	var state = atn.states[outerContext.invokingState];
	var transition = state.transitions[0];
	return SingletonPredictionContext.create(parent, transition.followState.stateNumber);
}
/*
function calculateListsHashString(parents, returnStates) {
	var s = "";
	parents.map(function(p) {
		s = s + p;
	});
	returnStates.map(function(r) {
		s = s + r;
	});
	return s;
}
*/
function merge(a, b, rootIsWildcard, mergeCache) {
	// share same graph if both same
	if (a === b) {
		return a;
	}
	if (a instanceof SingletonPredictionContext && b instanceof SingletonPredictionContext) {
		return mergeSingletons(a, b, rootIsWildcard, mergeCache);
	}
	// At least one of a or b is array
	// If one is $ and rootIsWildcard, return $ as// wildcard
	if (rootIsWildcard) {
		if (a instanceof EmptyPredictionContext) {
			return a;
		}
		if (b instanceof EmptyPredictionContext) {
			return b;
		}
	}
	// convert singleton so both are arrays to normalize
	if (a instanceof SingletonPredictionContext) {
		a = new ArrayPredictionContext([a.getParent()], [a.returnState]);
	}
	if (b instanceof SingletonPredictionContext) {
		b = new ArrayPredictionContext([b.getParent()], [b.returnState]);
	}
	return mergeArrays(a, b, rootIsWildcard, mergeCache);
}

//
// Merge two {@link SingletonPredictionContext} instances.
//
// <p>Stack tops equal, parents merge is same; return left graph.<br>
// <embed src="images/SingletonMerge_SameRootSamePar.svg"
// type="image/svg+xml"/></p>
//
// <p>Same stack top, parents differ; merge parents giving array node, then
// remainders of those graphs. A new root node is created to point to the
// merged parents.<br>
// <embed src="images/SingletonMerge_SameRootDiffPar.svg"
// type="image/svg+xml"/></p>
//
// <p>Different stack tops pointing to same parent. Make array node for the
// root where both element in the root point to the same (original)
// parent.<br>
// <embed src="images/SingletonMerge_DiffRootSamePar.svg"
// type="image/svg+xml"/></p>
//
// <p>Different stack tops pointing to different parents. Make array node for
// the root where each element points to the corresponding original
// parent.<br>
// <embed src="images/SingletonMerge_DiffRootDiffPar.svg"
// type="image/svg+xml"/></p>
//
// @param a the first {@link SingletonPredictionContext}
// @param b the second {@link SingletonPredictionContext}
// @param rootIsWildcard {@code true} if this is a local-context merge,
// otherwise false to indicate a full-context merge
// @param mergeCache
// /
function mergeSingletons(a, b, rootIsWildcard, mergeCache) {
	if (mergeCache !== null) {
		var previous = mergeCache.get(a, b);
		if (previous !== null) {
			return previous;
		}
		previous = mergeCache.get(b, a);
		if (previous !== null) {
			return previous;
		}
	}

	var rootMerge = mergeRoot(a, b, rootIsWildcard);
	if (rootMerge !== null) {
		if (mergeCache !== null) {
			mergeCache.set(a, b, rootMerge);
		}
		return rootMerge;
	}
	if (a.returnState === b.returnState) {
		var parent = merge(a.parentCtx, b.parentCtx, rootIsWildcard, mergeCache);
		// if parent is same as existing a or b parent or reduced to a parent,
		// return it
		if (parent === a.parentCtx) {
			return a; // ax + bx = ax, if a=b
		}
		if (parent === b.parentCtx) {
			return b; // ax + bx = bx, if a=b
		}
		// else: ax + ay = a'[x,y]
		// merge parents x and y, giving array node with x,y then remainders
		// of those graphs. dup a, a' points at merged array
		// new joined parent so create new singleton pointing to it, a'
		var spc = SingletonPredictionContext.create(parent, a.returnState);
		if (mergeCache !== null) {
			mergeCache.set(a, b, spc);
		}
		return spc;
	} else { // a != b payloads differ
		// see if we can collapse parents due to $+x parents if local ctx
		var singleParent = null;
		if (a === b || (a.parentCtx !== null && a.parentCtx === b.parentCtx)) { // ax +
																				// bx =
																				// [a,b]x
			singleParent = a.parentCtx;
		}
		if (singleParent !== null) { // parents are same
			// sort payloads and use same parent
			var payloads = [ a.returnState, b.returnState ];
			if (a.returnState > b.returnState) {
				payloads[0] = b.returnState;
				payloads[1] = a.returnState;
			}
			var parents = [ singleParent, singleParent ];
			var apc = new ArrayPredictionContext(parents, payloads);
			if (mergeCache !== null) {
				mergeCache.set(a, b, apc);
			}
			return apc;
		}
		// parents differ and can't merge them. Just pack together
		// into array; can't merge.
		// ax + by = [ax,by]
		var payloads = [ a.returnState, b.returnState ];
		var parents = [ a.parentCtx, b.parentCtx ];
		if (a.returnState > b.returnState) { // sort by payload
			payloads[0] = b.returnState;
			payloads[1] = a.returnState;
			parents = [ b.parentCtx, a.parentCtx ];
		}
		var a_ = new ArrayPredictionContext(parents, payloads);
		if (mergeCache !== null) {
			mergeCache.set(a, b, a_);
		}
		return a_;
	}
}

//
// Handle case where at least one of {@code a} or {@code b} is
// {@link //EMPTY}. In the following diagrams, the symbol {@code $} is used
// to represent {@link //EMPTY}.
//
// <h2>Local-Context Merges</h2>
//
// <p>These local-context merge operations are used when {@code rootIsWildcard}
// is true.</p>
//
// <p>{@link //EMPTY} is superset of any graph; return {@link //EMPTY}.<br>
// <embed src="images/LocalMerge_EmptyRoot.svg" type="image/svg+xml"/></p>
//
// <p>{@link //EMPTY} and anything is {@code //EMPTY}, so merged parent is
// {@code //EMPTY}; return left graph.<br>
// <embed src="images/LocalMerge_EmptyParent.svg" type="image/svg+xml"/></p>
//
// <p>Special case of last merge if local context.<br>
// <embed src="images/LocalMerge_DiffRoots.svg" type="image/svg+xml"/></p>
//
// <h2>Full-Context Merges</h2>
//
// <p>These full-context merge operations are used when {@code rootIsWildcard}
// is false.</p>
//
// <p><embed src="images/FullMerge_EmptyRoots.svg" type="image/svg+xml"/></p>
//
// <p>Must keep all contexts; {@link //EMPTY} in array is a special value (and
// null parent).<br>
// <embed src="images/FullMerge_EmptyRoot.svg" type="image/svg+xml"/></p>
//
// <p><embed src="images/FullMerge_SameRoot.svg" type="image/svg+xml"/></p>
//
// @param a the first {@link SingletonPredictionContext}
// @param b the second {@link SingletonPredictionContext}
// @param rootIsWildcard {@code true} if this is a local-context merge,
// otherwise false to indicate a full-context merge
// /
function mergeRoot(a, b, rootIsWildcard) {
	if (rootIsWildcard) {
		if (a === PredictionContext.EMPTY) {
			return PredictionContext.EMPTY; // // + b =//
		}
		if (b === PredictionContext.EMPTY) {
			return PredictionContext.EMPTY; // a +// =//
		}
	} else {
		if (a === PredictionContext.EMPTY && b === PredictionContext.EMPTY) {
			return PredictionContext.EMPTY; // $ + $ = $
		} else if (a === PredictionContext.EMPTY) { // $ + x = [$,x]
			var payloads = [ b.returnState,
					PredictionContext.EMPTY_RETURN_STATE ];
			var parents = [ b.parentCtx, null ];
			return new ArrayPredictionContext(parents, payloads);
		} else if (b === PredictionContext.EMPTY) { // x + $ = [$,x] ($ is always first if present)
			var payloads = [ a.returnState, PredictionContext.EMPTY_RETURN_STATE ];
			var parents = [ a.parentCtx, null ];
			return new ArrayPredictionContext(parents, payloads);
		}
	}
	return null;
}

//
// Merge two {@link ArrayPredictionContext} instances.
//
// <p>Different tops, different parents.<br>
// <embed src="images/ArrayMerge_DiffTopDiffPar.svg" type="image/svg+xml"/></p>
//
// <p>Shared top, same parents.<br>
// <embed src="images/ArrayMerge_ShareTopSamePar.svg" type="image/svg+xml"/></p>
//
// <p>Shared top, different parents.<br>
// <embed src="images/ArrayMerge_ShareTopDiffPar.svg" type="image/svg+xml"/></p>
//
// <p>Shared top, all shared parents.<br>
// <embed src="images/ArrayMerge_ShareTopSharePar.svg"
// type="image/svg+xml"/></p>
//
// <p>Equal tops, merge parents and reduce top to
// {@link SingletonPredictionContext}.<br>
// <embed src="images/ArrayMerge_EqualTop.svg" type="image/svg+xml"/></p>
// /
function mergeArrays(a, b, rootIsWildcard, mergeCache) {
	if (mergeCache !== null) {
		var previous = mergeCache.get(a, b);
		if (previous !== null) {
			return previous;
		}
		previous = mergeCache.get(b, a);
		if (previous !== null) {
			return previous;
		}
	}
	// merge sorted payloads a + b => M
	var i = 0; // walks a
	var j = 0; // walks b
	var k = 0; // walks target M array

	var mergedReturnStates = [];
	var mergedParents = [];
	// walk and merge to yield mergedParents, mergedReturnStates
	while (i < a.returnStates.length && j < b.returnStates.length) {
		var a_parent = a.parents[i];
		var b_parent = b.parents[j];
		if (a.returnStates[i] === b.returnStates[j]) {
			// same payload (stack tops are equal), must yield merged singleton
			var payload = a.returnStates[i];
			// $+$ = $
			var bothDollars = payload === PredictionContext.EMPTY_RETURN_STATE &&
					a_parent === null && b_parent === null;
			var ax_ax = (a_parent !== null && b_parent !== null && a_parent === b_parent); // ax+ax
																							// ->
																							// ax
			if (bothDollars || ax_ax) {
				mergedParents[k] = a_parent; // choose left
				mergedReturnStates[k] = payload;
			} else { // ax+ay -> a'[x,y]
				var mergedParent = merge(a_parent, b_parent, rootIsWildcard, mergeCache);
				mergedParents[k] = mergedParent;
				mergedReturnStates[k] = payload;
			}
			i += 1; // hop over left one as usual
			j += 1; // but also skip one in right side since we merge
		} else if (a.returnStates[i] < b.returnStates[j]) { // copy a[i] to M
			mergedParents[k] = a_parent;
			mergedReturnStates[k] = a.returnStates[i];
			i += 1;
		} else { // b > a, copy b[j] to M
			mergedParents[k] = b_parent;
			mergedReturnStates[k] = b.returnStates[j];
			j += 1;
		}
		k += 1;
	}
	// copy over any payloads remaining in either array
	if (i < a.returnStates.length) {
		for (var p = i; p < a.returnStates.length; p++) {
			mergedParents[k] = a.parents[p];
			mergedReturnStates[k] = a.returnStates[p];
			k += 1;
		}
	} else {
		for (var p = j; p < b.returnStates.length; p++) {
			mergedParents[k] = b.parents[p];
			mergedReturnStates[k] = b.returnStates[p];
			k += 1;
		}
	}
	// trim merged if we combined a few that had same stack tops
	if (k < mergedParents.length) { // write index < last position; trim
		if (k === 1) { // for just one merged element, return singleton top
			var a_ = SingletonPredictionContext.create(mergedParents[0],
					mergedReturnStates[0]);
			if (mergeCache !== null) {
				mergeCache.set(a, b, a_);
			}
			return a_;
		}
		mergedParents = mergedParents.slice(0, k);
		mergedReturnStates = mergedReturnStates.slice(0, k);
	}

	var M = new ArrayPredictionContext(mergedParents, mergedReturnStates);

	// if we created same array as a or b, return that instead
	// TODO: track whether this is possible above during merge sort for speed
	if (M === a) {
		if (mergeCache !== null) {
			mergeCache.set(a, b, a);
		}
		return a;
	}
	if (M === b) {
		if (mergeCache !== null) {
			mergeCache.set(a, b, b);
		}
		return b;
	}
	combineCommonParents(mergedParents);

	if (mergeCache !== null) {
		mergeCache.set(a, b, M);
	}
	return M;
}

//
// Make pass over all <em>M</em> {@code parents}; merge any {@code equals()}
// ones.
// /
function combineCommonParents(parents) {
	var uniqueParents = {};

	for (var p = 0; p < parents.length; p++) {
		var parent = parents[p];
		if (!(parent in uniqueParents)) {
			uniqueParents[parent] = parent;
		}
	}
	for (var q = 0; q < parents.length; q++) {
		parents[q] = uniqueParents[parents[q]];
	}
}

function getCachedPredictionContext(context, contextCache, visited) {
	if (context.isEmpty()) {
		return context;
	}
	var existing = visited[context] || null;
	if (existing !== null) {
		return existing;
	}
	existing = contextCache.get(context);
	if (existing !== null) {
		visited[context] = existing;
		return existing;
	}
	var changed = false;
	var parents = [];
	for (var i = 0; i < parents.length; i++) {
		var parent = getCachedPredictionContext(context.getParent(i), contextCache, visited);
		if (changed || parent !== context.getParent(i)) {
			if (!changed) {
				parents = [];
				for (var j = 0; j < context.length; j++) {
					parents[j] = context.getParent(j);
				}
				changed = true;
			}
			parents[i] = parent;
		}
	}
	if (!changed) {
		contextCache.add(context);
		visited[context] = context;
		return context;
	}
	var updated = null;
	if (parents.length === 0) {
		updated = PredictionContext.EMPTY;
	} else if (parents.length === 1) {
		updated = SingletonPredictionContext.create(parents[0], context
				.getReturnState(0));
	} else {
		updated = new ArrayPredictionContext(parents, context.returnStates);
	}
	contextCache.add(updated);
	visited[updated] = updated;
	visited[context] = updated;

	return updated;
}

// ter's recursive version of Sam's getAllNodes()
function getAllContextNodes(context, nodes, visited) {
	if (nodes === null) {
		nodes = [];
		return getAllContextNodes(context, nodes, visited);
	} else if (visited === null) {
		visited = {};
		return getAllContextNodes(context, nodes, visited);
	} else {
		if (context === null || visited[context] !== null) {
			return nodes;
		}
		visited[context] = context;
		nodes.push(context);
		for (var i = 0; i < context.length; i++) {
			getAllContextNodes(context.getParent(i), nodes, visited);
		}
		return nodes;
	}
}

exports.merge = merge;
exports.PredictionContext = PredictionContext;
exports.PredictionContextCache = PredictionContextCache;
exports.SingletonPredictionContext = SingletonPredictionContext;
exports.predictionContextFromRuleContext = predictionContextFromRuleContext;
exports.getCachedPredictionContext = getCachedPredictionContext;


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

var CategoryDeclaration = __webpack_require__(45).CategoryDeclaration;
var SetterMethodDeclaration = __webpack_require__(208).SetterMethodDeclaration;
var GetterMethodDeclaration = __webpack_require__(207).GetterMethodDeclaration;
var MethodDeclarationMap = null;
var ConcreteInstance = __webpack_require__(172).ConcreteInstance;
var CategoryType = __webpack_require__(7).CategoryType;
var DataStore = __webpack_require__(50).DataStore;
var $Root = __webpack_require__(594).$Root;
var EnumeratedCategoryDeclaration = null;
var EnumeratedNativeDeclaration = null;

exports.resolve = function() {
    MethodDeclarationMap = __webpack_require__(11).MethodDeclarationMap;
    EnumeratedCategoryDeclaration = __webpack_require__(92).EnumeratedCategoryDeclaration;
    EnumeratedNativeDeclaration = __webpack_require__(77).EnumeratedNativeDeclaration;
}

function ConcreteCategoryDeclaration(id, attributes, derivedFrom, methods) {
	CategoryDeclaration.call(this, id, attributes);
	this.derivedFrom = derivedFrom || null;
	this.methodsMap = null;
	this.methods = methods || [];
	return this;
}

ConcreteCategoryDeclaration.prototype = Object.create(CategoryDeclaration.prototype);
ConcreteCategoryDeclaration.prototype.constructor = ConcreteCategoryDeclaration;


ConcreteCategoryDeclaration.prototype.isWidget = function(context) {
    if(this.derivedFrom==null || this.derivedFrom.length!=1)
        return false;
    var derived = context.getRegisteredDeclaration(this.derivedFrom[0]);
    return derived.isWidget(context);
};

ConcreteCategoryDeclaration.prototype.toEDialect = function(writer) {
    var hasMethods = this.methods!=null && this.methods.length>0;
    this.protoToEDialect(writer, hasMethods, false); // no bindings
    if(hasMethods)
        this.methodsToEDialect(writer, this.methods);
}

ConcreteCategoryDeclaration.prototype.categoryTypeToEDialect = function(writer) {
    if(this.derivedFrom==null)
        writer.append("category");
    else
        this.derivedFrom.toDialect(writer, true);
};


ConcreteCategoryDeclaration.prototype.toODialect = function(writer) {
    var hasMethods = this.methods!=null && this.methods.length>0;
    this.allToODialect(writer, hasMethods);
};

ConcreteCategoryDeclaration.prototype.categoryTypeToODialect = function(writer) {
    writer.append("category");
};


ConcreteCategoryDeclaration.prototype.categoryExtensionToODialect = function(writer) {
    if(this.derivedFrom!=null) {
        writer.append(" extends ");
        this.derivedFrom.toDialect(writer, true);
    }
};


ConcreteCategoryDeclaration.prototype.bodyToODialect = function(writer) {
    this.methodsToODialect (writer, this.methods);
};


ConcreteCategoryDeclaration.prototype.toMDialect = function(writer) {
    this.protoToMDialect(writer, this.derivedFrom);
    this.methodsToMDialect(writer);
};


ConcreteCategoryDeclaration.prototype.categoryTypeToMDialect = function(writer) {
    writer.append("class");
};


ConcreteCategoryDeclaration.prototype.methodsToMDialect = function(writer) {
    writer.indent();
    if(this.methods==null || this.methods.length==0)
        writer.append("pass\n");
    else {
        writer.newLine();
        this.methods.forEach(function(method) {
            if(method.comments) {
                method.comments.forEach(function (cmt) {
                    cmt.toDialect(writer);
                });
            }
            if(method.annotations) {
                method.annotations.forEach(function (ann) {
                    ann.toDialect(writer);
                });
            }
            var w = writer.newMemberWriter();
            method.toDialect(w);
            writer.newLine();
        });
    }
    writer.dedent();
};

ConcreteCategoryDeclaration.prototype.hasAttribute = function(context, name) {
	if (CategoryDeclaration.prototype.hasAttribute.call(this, context, name)) {
		return true;
	} else {
		return this.hasDerivedAttribute(context, name);
	}
};

ConcreteCategoryDeclaration.prototype.hasDerivedAttribute = function(context, name) {
	if(this.derivedFrom==null) {
		return false;
	}
	for(var i=0;i<this.derivedFrom.length;i++) {
        var ancestor = this.derivedFrom[i].name;
		if(ConcreteCategoryDeclaration.ancestorHasAttribute(ancestor, context, name)) {
			return true;
		}
	}
	return false;
};

ConcreteCategoryDeclaration.ancestorHasAttribute = function(ancestor, context, name) {
	var actual = context.getRegisteredDeclaration(ancestor);
	if(!(actual instanceof CategoryDeclaration)) {
		return false;
	}
	return actual.hasAttribute(context, name);
};


ConcreteCategoryDeclaration.prototype.hasMethod = function(context, name) {
    this.registerMethods(context);
    if(this.methodsMap[name])
        return true;
    if(this.hasDerivedMethod(context, name))
        return true;
    return false;
};

ConcreteCategoryDeclaration.prototype.hasDerivedMethod = function(context, name) {
    if(this.derivedFrom==null) {
        return false;
    }
    for(var i=0;i<this.derivedFrom.length;i++) {
        var ancestor = this.derivedFrom[i].name;
        if(ConcreteCategoryDeclaration.ancestorHasMethod(ancestor, context, name)) {
            return true;
        }
    }
    return false;
};

ConcreteCategoryDeclaration.ancestorHasMethod = function(ancestor, context, name) {
    var actual = context.getRegisteredDeclaration(ancestor);
    if(!(actual instanceof CategoryDeclaration)) {
        return false;
    }
    return actual.hasMethod(context, name);
};

ConcreteCategoryDeclaration.prototype.check = function(context, isStart) {
	this.checkDerived(context);
	this.checkMethods(context);
	return CategoryDeclaration.prototype.check.call(this, context, isStart);
}

ConcreteCategoryDeclaration.prototype.checkMethods = function(context) {
    this.registerMethods(context);
    for (var i = 0; i < this.methods.length; i++) {
        this.methods[i].checkMember(this, context);
    }
};

ConcreteCategoryDeclaration.prototype.registerMethods = function(context) {
	if(this.methodsMap==null) {
        this.methodsMap = {};
		this.methods.forEach(function(method) {
            method.memberOf = this;
			this.registerMethod(method, context);
		}, this);
	}
};


ConcreteCategoryDeclaration.prototype.registerMethod = function(method, context) {
	var actual;
	if(method instanceof SetterMethodDeclaration) {
		var key = "setter:" + method.name;
		actual = this.methodsMap[key] || null;
		if(actual!=null)
            context.problemListener.reportDuplicateSetter(method.id);
		this.methodsMap[key] = method;
	} else if(method instanceof GetterMethodDeclaration) {
		var key = "getter:"+method.name;
		actual = this.methodsMap[key] || null;
		if(actual!=null)
            context.problemListener.reportDuplicateGetter(method.id);
		this.methodsMap[key] = method;
	} else {
		var key = method.name;
		actual = this.methodsMap[key] || null;
		if(actual==null) {
			actual = new MethodDeclarationMap(method.name);
			this.methodsMap[key] = actual;
		}
		actual.register(method, context.problemListener);
	}
};

ConcreteCategoryDeclaration.prototype.checkDerived = function(context) {
	if(this.derivedFrom!=null) {
        this.derivedFrom.map( function(id) {
            var cd = context.getRegisteredDeclaration(id.name) || null;
			if (cd == null)
                context.problemListener.reportUnknownCategory(id);
		});
	}
};

ConcreteCategoryDeclaration.prototype.isDerivedFrom = function(context, categoryType) {
	if(this.derivedFrom==null) {
		return false;
	}
	for(var i=0;i<this.derivedFrom.length;i++) {
		var ancestor = this.derivedFrom[i].name;
		if(ancestor==categoryType.name) {
			return true;
		}
		if(ConcreteCategoryDeclaration.isAncestorDerivedFrom(ancestor,context,categoryType)) {
			return true;
		}
	}
	return false;
};

ConcreteCategoryDeclaration.isAncestorDerivedFrom = function(ancestor, context, categoryType) {
	var actual = context.getRegisteredDeclaration(ancestor);
	if(!(actual instanceof CategoryDeclaration)) {
		return false;
	}
	return actual.isDerivedFrom(context, categoryType);
};

ConcreteCategoryDeclaration.prototype.newInstance = function(context) {
	return new ConcreteInstance(context, this);
};

ConcreteCategoryDeclaration.prototype.getAllAttributes = function(context) {
    var local = CategoryDeclaration.prototype.getAllAttributes.call(this, context) || new Set();
    if(this.derivedFrom!=null) {
        this.derivedFrom.forEach(function (id) {
            var derived = this.getAncestorAttributes(context, id);
            if (derived != null)
                derived.forEach(function(attr) { local.add(attr); }, this);
        }, this);
    }
    return local.size > 0  ? local : null;
};

ConcreteCategoryDeclaration.prototype.getAncestorAttributes = function(context, id) {
    var decl = context.getRegisteredDeclaration(id.name);
    if(decl==null)
        return null;
    else
        return decl.getAllAttributes(context);
};


ConcreteCategoryDeclaration.prototype.findGetter = function(context, attrName) {
	if(this.methodsMap==null) {
		return null;
	}
	var method = this.methodsMap["getter:" + attrName] || null;
	if(method instanceof GetterMethodDeclaration) {
		return method;
	}
	if(method!=null)
        context.problemListener.reportBadGetter(method.id);
	return this.findDerivedGetter(context, attrName);
};

ConcreteCategoryDeclaration.prototype.findDerivedGetter = function(context, attrName) {
	if(this.derivedFrom==null) {
		return null;
	}
	for(var i=0;i<this.derivedFrom;i++) {
		var method = ConcreteCategoryDeclaration.findAncestorGetter(this.derivedFrom[i],context,attrName);
		if(method!=null) {
			return method;
		}
	}
	return null;
}

ConcreteCategoryDeclaration.findAncestorGetter = function(ancestor, context, attrName) {
	var actual = context.getRegisteredDeclaration(ancestor);
	if(!(actual instanceof ConcreteCategoryDeclaration)) {
		return null;
	}
	return actual.findGetter(context, attrName);
};

ConcreteCategoryDeclaration.prototype.findSetter = function(context, attrName) {
	if(this.methodsMap==null) {
		return null;
	}
	var method = this.methodsMap["setter:" + attrName] || null;
	if(method instanceof SetterMethodDeclaration) {
		return method;
	}
	if(method!=null)
        context.problemListener.reportBadSetter(method.id);
	return this.findDerivedSetter(context,attrName);
};

ConcreteCategoryDeclaration.prototype.findDerivedSetter = function(context, attrName) {
	if(this.derivedFrom==null) {
		return null;
	}
	for(var i=0;i<this.derivedFrom;i++) {
		var method = ConcreteCategoryDeclaration.findAncestorSetter(this.derivedFrom[i],context,attrName);
		if(method!=null) {
			return method;
		}
	}
	return null;
};

ConcreteCategoryDeclaration.findAncestorSetter = function(ancestor, context, attrName) {
	var actual = context.getRegisteredDeclaration(ancestor);
	if(!(actual instanceof ConcreteCategoryDeclaration)) {
		return null;
	}
	return actual.findSetter(context, attrName);
};


ConcreteCategoryDeclaration.prototype.getMemberMethodsMap = function(context, name) {
	var methodsMap = new MethodDeclarationMap(name);
	this.registerMemberMethods(context, methodsMap);
	return methodsMap;
};


ConcreteCategoryDeclaration.prototype.registerMemberMethods = function(context, result) {
    this.registerMethods(context);
	this.registerThisMemberMethods(context,result);
	this.registerDerivedMemberMethods(context,result);
};


ConcreteCategoryDeclaration.prototype.registerThisMemberMethods = function(context, result) {
	if(this.methodsMap==null) {
		return;
	}
	var actual = this.methodsMap[result.name] || null;
	if(actual==null) {
		return;
	}
	if(!(actual instanceof MethodDeclarationMap))
        context.problemListener.reportBadMember(actual.id);
	var protos = Object.getOwnPropertyNames(actual.protos);
    protos.forEach(function(proto) {
        var method = actual.protos[proto];
		result.registerIfMissing(method);
	});
};

ConcreteCategoryDeclaration.prototype.registerDerivedMemberMethods = function(context, result) {
	if(this.derivedFrom!=null)
        this.derivedFrom.forEach(function(ancestor) {
		    this.registerAncestorMemberMethods(ancestor, context, result);
	    }, this);
};

ConcreteCategoryDeclaration.prototype.registerAncestorMemberMethods = function(ancestor, context, result) {
	var actual = context.getRegisteredDeclaration(ancestor);
	if(!(actual instanceof ConcreteCategoryDeclaration)) {
		return;
	}
	actual.registerMemberMethods(context, result);
};


ConcreteCategoryDeclaration.prototype.getOperatorMethod = function(context, operator, type) {
    var methodName = "operator_" + operator.name;
    var methods = this.getMemberMethodsMap(context, methodName);
    if(methods==null)
        return null;
    // find best candidate
    var candidate = null;
    methods.getAll().forEach(function(method) {
        var potential = method.args[0].getType(context);
        if(!potential.isAssignableFrom(context, type))
            return;
        if(candidate==null)
            candidate = method;
        else {
            var currentBest = candidate.args[0].getType(context);
            if(potential.isAssignableFrom(context, currentBest))
                candidate = method;
        }
    });
    return candidate;
};

ConcreteCategoryDeclaration.prototype.collectCategories = function(context) {
    var cat_set = {};
    var cat_list = [];
    this.doCollectCategories(context, cat_set, cat_list);
    return cat_list;
};

ConcreteCategoryDeclaration.prototype.doCollectCategories = function(context, cat_set, cat_list) {
    if (this.derivedFrom != null) {
        this.derivedFrom.forEach(function (cat) {
            var decl = context.getRegisteredDeclaration(cat);
            decl.doCollectCategories(context, cat_set, cat_list);
        });
    }
    if(!(this.name in cat_set)) {
        cat_set[this.name] = this.name;
        cat_list.push(this.name);
    }
};

ConcreteCategoryDeclaration.prototype.declare = function(transpiler) {
    transpiler.declare(this);
    if (this.derivedFrom != null) {
        this.derivedFrom.forEach(function (cat) {
            var decl = transpiler.context.getRegisteredDeclaration(cat);
            decl.declare(transpiler);
        });
    } else
        this.declareRoot(transpiler);
    if(this.storable)
        transpiler.require(DataStore);
    this.declareMethods(transpiler);
};


ConcreteCategoryDeclaration.prototype.declareMethods = function(transpiler) {
    this.methods.filter(function (decl) {
        return !(decl instanceof SetterMethodDeclaration || decl instanceof GetterMethodDeclaration);
    }).forEach(function (method) {
        var t = transpiler.newMemberTranspiler(this.getType(transpiler.context));
        method.declare(t);
        t.flush();
    }, this);
};

ConcreteCategoryDeclaration.prototype.declareRoot = function(transpiler) {
    transpiler.require($Root);
};


ConcreteCategoryDeclaration.prototype.ensureDeclarationOrder = function(context, list, set) {
    if(set.has(this))
        return;
    if (this.derivedFrom != null) {
        this.derivedFrom.forEach(function (cat) {
            var decl = context.getRegisteredDeclaration(cat);
            decl.ensureDeclarationOrder(context, list, set);
        });
    }
    list.push(this);
    set.add(this);
};

ConcreteCategoryDeclaration.prototype.transpile = function(transpiler) {
    var parent = this.derivedFrom && this.derivedFrom.length ? this.derivedFrom[0] : null;
    transpiler.append("function ").append(this.name).append("(copyFrom, values, mutable) {");
    transpiler.indent();
    var categories = this.collectCategories(transpiler.context);
    if(this.storable)
        transpiler.append("this.storable = DataStore.instance.newStorableDocument(['").append(categories.join("', '")).append("'],  this.dbIdListener.bind(this));").newLine();
    this.transpileGetterSetterAttributes(transpiler);
    this.transpileSuperConstructor(transpiler);
    transpiler.append("this.category = [").append(categories.join(', ')).append("];").newLine();
    this.transpileLocalAttributes(transpiler);
    transpiler.append("this.mutable = mutable;").newLine();
    transpiler.append("return this;");
    transpiler.dedent();
    transpiler.append("}");
    transpiler.newLine();
    if(parent)
        transpiler.append(this.name).append(".prototype = Object.create(").append(parent).append(".prototype);").newLine();
    else
        transpiler.append(this.name).append(".prototype = Object.create($Root.prototype);").newLine();
    transpiler.append(this.name).append(".prototype.constructor = ").append(this.name).append(";").newLine();
    transpiler = transpiler.newInstanceTranspiler(new CategoryType(this.id));
    this.transpileLoaders(transpiler);
    this.transpileMethods(transpiler);
    this.transpileGetterSetters(transpiler);
    transpiler.flush();
};

ConcreteCategoryDeclaration.prototype.transpileLoaders = function(transpiler) {
    var attributes = this.getLocalAttributes();
    if (attributes) {
        attributes
            .filter(function (attr) {
                return this.isEnumeratedAttribute(transpiler.context, attr);
                }, this)
            .forEach(function (attr) {
                    transpiler.append(this.name).append(".prototype.load$").append(attr.name).append(" = function(name) {").indent();
                    transpiler.append("return eval(name);").dedent();
                    transpiler.append("};").newLine();
                }, this);
        }
};

ConcreteCategoryDeclaration.prototype.isEnumeratedAttribute = function(context, attr) {
    var decl = context.getRegisteredDeclaration(attr.name);
    decl = context.getRegisteredDeclaration(decl.type.name);
    return  decl instanceof EnumeratedCategoryDeclaration || decl instanceof EnumeratedNativeDeclaration;
};

ConcreteCategoryDeclaration.prototype.transpileLocalAttributes = function(transpiler) {
    var attributes = this.getLocalAttributes();
    if (attributes) {
        transpiler.append("this.mutable = true;").newLine();
        transpiler.append("values = Object.assign({}, copyFrom, values);").newLine();
        attributes.forEach(function (attr) {
            var isEnum =  this.isEnumeratedAttribute(transpiler.context, attr);
            transpiler.append("this.setMember('").append(attr.name).append("', values.").append(attr.name).append(" || null, mutable, ").append(isEnum).append(");").newLine();
        }, this);
    }
};

ConcreteCategoryDeclaration.prototype.transpileSuperConstructor = function(transpiler) {
    if (this.derivedFrom && this.derivedFrom.length) {
        this.derivedFrom.forEach(function(derived) {
            transpiler.append(derived).append(".call(this, copyFrom, values, mutable);").newLine();
        });
    } else
        this.transpileRootConstructor(transpiler).newLine();
};


ConcreteCategoryDeclaration.prototype.transpileRootConstructor = function(transpiler) {
    return transpiler.append("$Root.call(this);").newLine();
};


ConcreteCategoryDeclaration.prototype.transpileGetterSetterAttributes = function(transpiler) {
    var allAttributes = this.getAllAttributes(transpiler.context);
    if(allAttributes) {
        allAttributes.forEach(function (attr) {
            if (this.findGetter(transpiler.context, attr.name) || this.findSetter(transpiler.context, attr.name))
                transpiler.append("this.$").append(attr.name).append(" = null;").newLine();
        }, this);
    }
};

ConcreteCategoryDeclaration.prototype.transpileMethods = function(transpiler) {
    this.methods.filter(function (decl) {
        return !(decl instanceof SetterMethodDeclaration || decl instanceof GetterMethodDeclaration);
    }).forEach(function (method) {
        var t = transpiler.newMemberTranspiler(this.getType(transpiler.context));
        method.transpile(t);
        t.flush();
    }, this);
};

ConcreteCategoryDeclaration.prototype.transpileGetterSetters = function(transpiler) {
    var getterSetters = this.methods.filter(function (decl) {
        return (decl instanceof SetterMethodDeclaration || decl instanceof GetterMethodDeclaration);
    }, this);
    var names = new Set(getterSetters.map(function(decl) { return decl.id.name; }));
    names.forEach(function(name) { this.transpileGetterSetter(transpiler, name); }, this);
};

ConcreteCategoryDeclaration.prototype.transpileGetterSetter = function(transpiler, name) {
    var getter = this.findGetter(transpiler.context, name);
    var setter = this.findSetter(transpiler.context, name);
    transpiler.append("Object.defineProperty(").append(this.name).append(".prototype, '").append(name).append("', {").indent();
    transpiler.append("get: function() {").indent();
    if(getter) {
        var t = transpiler.newGetterTranspiler(this.getType(transpiler.context), name);
        getter.transpile(t);
        t.flush();
    } else
        transpiler.append("return this.$").append(name).append(";").newLine();
    transpiler.dedent().append("}");
    transpiler.append(",").newLine();
    transpiler.append("set: function(").append(name).append(") {").indent();
    if(setter) {
        var t = transpiler.newSetterTranspiler(this.getType(transpiler.context), name);
        t.append(name).append(" = (function(").append(name).append(") {").indent();
        setter.transpile(t);
        t.append(";").dedent().append("})(name);").newLine();
        t.flush();
    }
    transpiler.append("this.$").append(name).append(" = ").append(name).append(";").newLine();
    transpiler.dedent().append("}");
    transpiler.dedent().append("});").newLine();
};



exports.ConcreteCategoryDeclaration = ConcreteCategoryDeclaration;


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

var SingletonCategoryDeclaration = null;
var MethodType = __webpack_require__(38).MethodType;
var SyntaxError = __webpack_require__(32).SyntaxError;
var MemberSelector = __webpack_require__(63).MemberSelector;
var InvalidDataError = __webpack_require__(64).InvalidDataError;
var NullReferenceError = __webpack_require__(49).NullReferenceError;
var Identifier = __webpack_require__(0).Identifier;
var UnresolvedIdentifier = null;
var InstanceExpression = __webpack_require__(41).InstanceExpression;
var NullValue = __webpack_require__(21).NullValue;
var TypeValue = __webpack_require__(142).TypeValue;
var Variable = __webpack_require__(10).Variable;
var InstanceContext = null;
var ConcreteInstance = __webpack_require__(172).ConcreteInstance;
var NativeInstance = null;
var CategoryType = null;
var MethodDeclarationMap = null;


exports.resolve = function() {
	CategoryType = __webpack_require__(7).CategoryType;
    InstanceContext = __webpack_require__(11).InstanceContext;
    NativeInstance = __webpack_require__(123).NativeInstance;
    UnresolvedIdentifier = __webpack_require__(27).UnresolvedIdentifier;
    SingletonCategoryDeclaration = __webpack_require__(205).SingletonCategoryDeclaration;
    MethodDeclarationMap = __webpack_require__(11).MethodDeclarationMap;
};

function MethodSelector(parent, id) {
	MemberSelector.call(this, parent, id);
	return this;
}

MethodSelector.prototype = Object.create(MemberSelector.prototype);
MethodSelector.prototype.constructor = MethodSelector;

MethodSelector.prototype.toDialect = function(writer) {
    if(this.parent==null)
        writer.append(this.name);
    else
        MemberSelector.prototype.parentAndMemberToDialect.call(this, writer);
};

MethodSelector.prototype.newFullSelector = function(counter){
    var name = this.id.name + "$" + counter;
    return new MethodSelector(this.parent, new Identifier(name));
};

MethodSelector.prototype.transpile = function(transpiler) {
    if(this.parent!=null)
        MemberSelector.prototype.transpile.call(this, transpiler);
    else
        transpiler.append(this.name);
};


MethodSelector.prototype.toString = function() {
	if(this.parent==null) {
		return this.name;
	} else {
		return MemberSelector.prototype.toString.call(this) + "." + this.name;
	}
};


MethodSelector.prototype.getCandidates = function(context, checkInstance) {
    var named = context.getRegistered(this.id);
    if (named instanceof Variable && named.getType(context) instanceof MethodType)
        return new Set([named.getType(context).method]);
	else if(this.parent===null)
		return this.getGlobalCandidates(context);
	else
		return this.getMemberCandidates(context, checkInstance);
};


MethodSelector.prototype.getGlobalCandidates = function(context) {
    var result = new Set();
    // if called from a member method, could be a member method called without this/self
    var instance = context.getClosestInstanceContext();
    if(instance!=null) {
        var type = instance.instanceType;
        var cd = context.getRegisteredDeclaration(type.name);
        if(cd!=null) {
            var members = cd.getMemberMethodsMap(context, this.name);
            if(members!=null) {
                members.getAll().forEach(function(method) {
                    result.add(method);
                });
            }
        }
    }
    var methods = context.getRegisteredDeclaration(this.name);
    if(methods instanceof MethodDeclarationMap) {
        methods.getAll().forEach(function(method) {
            result.add(method);
        });
    }
    return result;
};


MethodSelector.prototype.getMemberCandidates = function(context, checkInstance) {
    var parentType = this.checkParentType(context, checkInstance);
    var methods = parentType.getMemberMethods(context, this.name);
    return new Set(methods);
};



MethodSelector.prototype.checkParentType = function(context, checkInstance) {
    if(checkInstance)
        return this.checkParentInstance(context);
    else
        return this.checkParent(context);
};



MethodSelector.prototype.checkParentInstance = function(context) {
    var id = null;
    if(this.parent instanceof UnresolvedIdentifier)
        id = this.parent.id;
    else if(this.parent instanceof InstanceExpression)
        id = this.parent.id;
    if(id!=null) {
        // don't get Singleton values
        var first = id.name.substring(0, 1);
        if(first.toLowerCase()==first) {
            var value = context.getValue(id);
            if(value!=null && value!=NullValue.instance)
                return value.type;
        }
    }
    // TODO check result instance
    return this.checkParent(context);
};


MethodSelector.prototype.getCategoryCandidates = function(context) {
	var parentType = this.checkParent(context);
	if(!(parentType instanceof CategoryType)) {
		throw new SyntaxError(parent.toString() + " is not a category");
	}
	var cd = context.getRegisteredDeclaration(parentType.name);
	if(cd===null) {
		throw new SyntaxError("Unknown category:" + parentType.name);
	}
	return cd.getMemberMethods(context, this.name);
};

MethodSelector.prototype.newLocalContext = function(context, decl) {
	if(this.parent!=null) {
        return this.newInstanceContext(context);
    } else if(decl.memberOf!=null) {
        return this.newLocalInstanceContext(context);
    } else {
        return context.newLocalContext();
	}
};

MethodSelector.prototype.newLocalInstanceContext = function(context) {
    var instance = context.getClosestInstanceContext();
    if(instance==null)
        throw new SyntaxError("Not in instance context !");
    context = instance.newLocalContext();
    context.parent = instance; // make local context child of the existing instance
    return context;
};


MethodSelector.prototype.newLocalCheckContext = function(context, decl) {
    if (this.parent != null) {
        return this.newInstanceCheckContext(context);
    } else if(decl.memberOf!=null) {
        return this.newLocalInstanceContext(context);
    } else {
        return context.newLocalContext();
    }
};

MethodSelector.prototype.newInstanceCheckContext = function(context) {
    var type = this.parent.check (context);
    if (type instanceof CategoryType) {
        var decl = context.getRegisteredDeclaration(type.name);
        context = context.newInstanceContext(null, type, decl instanceof SingletonCategoryDeclaration);
        return context.newChildContext();
    } else
        return context.newChildContext();
};


MethodSelector.prototype.newInstanceContext = function(context) {
	var value = this.parent.interpret(context);
	if(value==null || value==NullValue.instance) {
		throw new NullReferenceError();
	}
    if(value instanceof TypeValue && value.value instanceof CategoryType)
        value = context.loadSingleton(value.value);
	if(value instanceof ConcreteInstance || value instanceof NativeInstance) {
        context = context.newInstanceContext(value, null);
        return context.newChildContext();
    } else {
        context = context.newBuiltInContext(value);
        return context.newChildContext();

    }
};



exports.MethodSelector = MethodSelector;



/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

var BooleanValue = __webpack_require__(20).BooleanValue;
var Value = __webpack_require__(1).Value;
var IntegerValue = __webpack_require__(3).IntegerValue;
var SetType = __webpack_require__(65).SetType;
var StrictSet = __webpack_require__(34).StrictSet;
var ListValue = null;

exports.resolve = function() {
    SetType = __webpack_require__(65).SetType;
    ListValue = __webpack_require__(36).ListValue;
};

function SetValue(itemType, items) {
    Value.call(this, new SetType(itemType));
    this.itemType = null;
    this.items = items || new StrictSet();
    return this;
}

SetValue.prototype = Object.create(Value.prototype);
SetValue.prototype.constructor = SetValue;


SetValue.prototype.add = function(item) {
    this.items.add(item);
};


SetValue.prototype.toString = function() {
    return this.items.toString();
};


SetValue.prototype.size = function() {
    return this.items.length;
};

SetValue.prototype.getMemberValue = function(context, name) {
    if ("count"==name) {
        return new IntegerValue(this.items.length);
    } else {
        return Value.prototype.getMemberValue.call(this, context, name);
    }
};

SetValue.prototype.isEmpty = function() {
    return this.items.length === 0;
};

SetValue.prototype.hasItem = function(context, item) {
    return this.items.has(item);
};


SetValue.prototype.getItemInContext = function(context, index) {
    if (index instanceof IntegerValue) {
        var idx = index.IntegerValue();
        var items = Array.from(this.items.set.values());
        if(idx<1 || idx>items.length)
            throw new IndexOutOfRangeError();
        return items[idx-1];
    } else
        throw new SyntaxError("No such item:" + index.toString());
};


SetValue.prototype.Add = function(context, value) {
    if (value instanceof SetValue || value instanceof ListValue) {
        var set = new StrictSet();
        set.addItems(this.items);
        set.addItems(value.items);
        return new SetValue(this.type.itemType, set);
    } else {
        return Value.prototype.Add.apply(this, context, value);
    }
};


SetValue.prototype.Subtract = function(context, value) {
    if (value instanceof ListValue) {
        var setValue = new SetValue(this.type.itemType);
        value = setValue.Add(context, value);
    }
    if (value instanceof SetValue) {
        var set = new StrictSet();
        var iter = this.items.iterator();
        while(iter.hasNext()) {
            var item = iter.next();
            if(!value.items.has(item))
                set.set.add(item);
        }
        return new SetValue(this.type.itemType, set);
    } else {
        return Value.prototype.Subtract.apply(this, context, value);
    }
};


SetValue.prototype.filter = function(context, itemId, filter) {
    var result = new SetValue(this.type.itemType);
    var iter = this.getIterator(context);
    while(iter.hasNext()) {
        var o = iter.next();
        context.setValue(itemId, o);
        var test = filter.interpret(context);
        if(!(test instanceof BooleanValue)) {
            throw new InternalError("Illegal test result: " + test);
        }
        if(test.value) {
            result.add(o);
        }
    }
    return result;
}

SetValue.prototype.getIterator = function(context) {
    return this.items.iterator();
};


SetValue.prototype.equals = function(obj) {
    if(obj instanceof SetValue) {
        return this.items.equals(obj.items);
    } else {
        return false;
    }
};



exports.SetValue = SetValue;

/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

var MissingType = __webpack_require__(56).MissingType;
var NativeType = __webpack_require__(12).NativeType;
var TextType = __webpack_require__(6).TextType;
var NullType = __webpack_require__(113).NullType;
var AnyType = __webpack_require__(14).AnyType;
var Identifier = __webpack_require__(0).Identifier;
var TextLiteral = __webpack_require__(74).TextLiteral;
var TextValue = __webpack_require__(17).TextValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var MethodDeclarationMap = null;
var ExpressionValue = __webpack_require__(76).ExpressionValue;
var DocumentValue = null;
var Document = __webpack_require__(98).Document;
var List = __webpack_require__(29).List;
var ArgumentAssignmentList = null;
var ArgumentAssignment = null;
var MethodCall = __webpack_require__(62).MethodCall;
var MethodSelector = __webpack_require__(53).MethodSelector;
var compareValues = __webpack_require__(16).compareValues;

exports.resolve = function() {
    MethodDeclarationMap = __webpack_require__(11).MethodDeclarationMap;
    ArgumentAssignmentList = __webpack_require__(39).ArgumentAssignmentList;
    ArgumentAssignment = __webpack_require__(40).ArgumentAssignment;
    DocumentValue = __webpack_require__(66).DocumentValue;
};


function DocumentType() {
	NativeType.call(this, new Identifier("Document"));
	return this;
}

DocumentType.prototype = Object.create(NativeType.prototype);
DocumentType.prototype.constructor = DocumentType;



DocumentType.prototype.withItemType = function(itemType) {
    return this;
};



DocumentType.prototype.isMoreSpecificThan = function(context, other) {
    if ((other instanceof NullType) || (other instanceof AnyType) || (other instanceof MissingType))
        return true;
    else
        return NativeType.prototype.isMoreSpecificThan.call(this, context, other);
};


DocumentType.prototype.checkMember = function(context, section, name) {
	return AnyType.instance;
};

DocumentType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
    if(value instanceof Document)
        return new DocumentValue(value);
    else
        return NativeType.prototype.convertJavaScriptValueToPromptoValue.call(this, context, value, returnType);
};


DocumentType.prototype.declare = function(transpiler) {
    transpiler.register(Document);
    transpiler.register(List);
};


DocumentType.prototype.transpile = function(transpiler) {
    transpiler.append('Document')
};


DocumentType.prototype.declareMember = function(transpiler, name) {
    // nothing to do
};


DocumentType.prototype.transpileMember = function(transpiler, name) {
    if ("text"!==name) {
        transpiler.append(name);
    } else {
        transpiler.append("getText()");
    }
};



DocumentType.prototype.transpileAssignMember = function(transpiler, name) {
    transpiler.append(".getMember('").append(name).append("', true)");
};


DocumentType.prototype.transpileAssignMemberValue = function(transpiler, name, expression) {
    transpiler.append(".setMember('").append(name).append("', ");
    expression.transpile(transpiler);
    transpiler.append(")");
};

DocumentType.prototype.transpileAssignItemValue = function(transpiler, item, expression) {
    transpiler.append(".setItem(");
    item.transpile(transpiler);
    transpiler.append(", ");
    expression.transpile(transpiler);
    transpiler.append(")");
};


DocumentType.prototype.declareSorted = function(transpiler, key) {
    if(key==null)
        key = new TextLiteral('"key"');
    var keyname = key.toString();
    var decl = this.findGlobalMethod(transpiler.context, keyname, true);
    if (decl != null) {
        decl.declare(transpiler);
    } else {
        transpiler = transpiler.newDocumentTranspiler();
        key.declare(transpiler);
    }
};


DocumentType.prototype.transpileSorted = function(transpiler, desc, key) {
    if(key==null)
        key = new TextLiteral('"key"');
    var keyname = key.toString();
    var decl = this.findGlobalMethod(transpiler.context, keyname, false);
    if (decl != null) {
        this.transpileSortedByGlobalMethod(transpiler, desc, decl.getTranspiledName(transpiler.context));
    } else if(key instanceof TextLiteral) {
        this.transpileSortedByEntry(transpiler, desc, key);
    } else {
        this.transpileSortedByExpression(transpiler, desc, key);
    }
};

DocumentType.prototype.transpileSortedByGlobalMethod = function(transpiler, desc, name) {
    transpiler.append("function(o1, o2) { return ")
        .append(name).append("(o1) === ").append(name).append("(o2)").append(" ? 0 : ")
        .append(name).append("(o1) > ").append(name).append("(o2)").append(" ? ");
    if(desc)
        transpiler.append("-1 : 1; }");
    else
        transpiler.append("1 : -1; }");
};


DocumentType.prototype.transpileSortedByEntry = function(transpiler, descending, key) {
    transpiler.append("function(o1, o2) { return ");
    this.transpileEqualEntries(transpiler, key);
    transpiler.append(" ? 0 : ");
    this.transpileGreaterEntries(transpiler, key);
    transpiler.append(" ? ");
    if(descending)
        transpiler.append("-1 : 1; }");
    else
        transpiler.append("1 : -1; }");
};


DocumentType.prototype.transpileEqualEntries = function(transpiler, key) {
    transpiler.append("o1[");
    key.transpile(transpiler);
    transpiler.append("] === o2[");
    key.transpile(transpiler);
    transpiler.append("]");
};


DocumentType.prototype.transpileGreaterEntries = function(transpiler, key) {
    transpiler.append("o1[");
    key.transpile(transpiler);
    transpiler.append("] > o2[");
    key.transpile(transpiler);
    transpiler.append("]");
};


DocumentType.prototype.transpileSortedByExpression = function(transpiler, descending, key) {
    transpiler = transpiler.newDocumentTranspiler();
    transpiler.append("function(o1, o2) { var v1 = (function() { return ");
    key.transpile(transpiler);
    transpiler.append("; }).bind(o1)(); var v2 = (function() { return ");
    key.transpile(transpiler);
    transpiler.append("; }).bind(o2)(); return v1===v2 ? 0 : v1 > v2 ? ");
    if(descending)
        transpiler.append("-1 : 1; }");
    else
        transpiler.append("1 : -1; }");
    transpiler.flush();
};





DocumentType.prototype.checkItem = function(context, itemType) {
    if(itemType===TextType.instance)
        return AnyType.instance;
    else
        throw ("text");
};


DocumentType.prototype.transpileItem = function(transpiler, type, item) {
    transpiler.append(".item(");
    item.transpile(transpiler);
    transpiler.append(")");
};

DocumentType.prototype.readJSONValue = function(context, node, parts) {
    var instance = new DocumentValue();
    for(key in node) {
        var value = this.readJSONField(context, node[key], parts);
        instance.setMember(context, key, value);
    }
    return instance;
};

DocumentType.prototype.readJSONField = function(context, node, parts) {
    if(!node)
        return NullValue.instance;
    else if(typeof(node)===typeof(true))
        return Boolean.ValueOf(node);
    else if(typeof(node)===typeof(1))
        return new IntegerValue(node);
    else if(typeof(node)===typeof(1.0))
        return new Decimal(node)
    else if(typeof(node)===typeof(""))
        return new TextValue(node)
    else if(typeof(node)===typeof([]))
        throw new Error("list");
    else if(typeof(node)===typeof({}))
        throw new Error("dict/object");
    else
        throw new Error(typeof(node).toString());
};

DocumentType.prototype.sort = function(context, list, desc, key) {
    if (list.size() <= 1) {
        return list;
    }
    key = key || null;
    if (key == null) {
        key = new TextLiteral('"key"');
    }
    var keyname = key.toString();
    var call = this.findGlobalMethod(context, keyname, true);
    if(call!=null) {
        return this.sortByGlobalMethod(context, list, desc, call);
    } else if(key instanceof TextLiteral) {
        return this.sortByEntry(context, list, desc, key);
    } else {
        return this.sortByExpression(context, list, desc, key);
    }
};


/* look for a method which takes Document as sole parameter */
DocumentType.prototype.findGlobalMethod = function(context, name, returnCall) {
    var methods = context.getRegisteredDeclaration(name);
    if(!(methods instanceof MethodDeclarationMap))
        return null;
    else if(!methods.protos[DocumentType.instance.name])
        return null;
    else if(returnCall) {
        var exp = new ExpressionValue(this, new DocumentValue());
        var arg = new ArgumentAssignment(null, exp);
        var args = new ArgumentAssignmentList([arg]);
        return new MethodCall(new MethodSelector(null, new Identifier(name)), args);
    } else
        return methods.protos[DocumentType.instance.name];
};


DocumentType.prototype.sortByGlobalMethod = function(context, list, desc, call) {
    var self = this;
    function cmp(o1, o2) {
        var assignment = call.assignments[0];
        assignment._expression = new ExpressionValue(self, o1);
        var value1 = call.interpret(context);
        assignment._expression = new ExpressionValue(self, o2);
        var value2 = call.interpret(context);
        return compareValues(value1, value2);
    }

    return NativeType.prototype.doSort(context, list, cmp, desc);
};


DocumentType.prototype.sortByEntry = function(context, list, desc, key) {
    var name = key.value.getStorableData();
    function cmp(o1, o2) {
        var value1 = o1.getMemberValue(context, name);
        var value2 = o2.getMemberValue(context, name);
        return compareValues(value1, value2);
    }

    return NativeType.prototype.doSort(context, list, cmp, desc);
};


DocumentType.prototype.sortByExpression = function(context, list, desc, expression) {

    function cmp(o1, o2) {
        var co = context.newDocumentContext(o1, false);
        var value1 = expression.interpret(co);
        co = context.newDocumentContext(o2, false);
        var value2 = expression.interpret(co);
        return compareValues(value1, value2);
    }
    return NativeType.prototype.doSort(context, list, cmp, desc);
};

DocumentType.instance = new DocumentType();


exports.DocumentType = DocumentType;


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var Identifier = __webpack_require__(0).Identifier;

function MissingType() {
	NativeType.call(this, new Identifier("*"));
	return this;
}

MissingType.prototype = Object.create(NativeType.prototype);
MissingType.prototype.constructor = MissingType;

MissingType.instance = new MissingType();
	
MissingType.prototype.isAssignableFrom = function(context, other) {
	return true;
};

exports.MissingType = MissingType;

/***/ }),
/* 57 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

var LL1Analyzer = __webpack_require__(341).LL1Analyzer;
var IntervalSet = __webpack_require__(25).IntervalSet;

function ATN(grammarType , maxTokenType) {

    // Used for runtime deserialization of ATNs from strings///
    // The type of the ATN.
    this.grammarType = grammarType;
    // The maximum value for any symbol recognized by a transition in the ATN.
    this.maxTokenType = maxTokenType;
    this.states = [];
    // Each subrule/rule is a decision point and we must track them so we
    //  can go back later and build DFA predictors for them.  This includes
    //  all the rules, subrules, optional blocks, ()+, ()* etc...
    this.decisionToState = [];
    // Maps from rule index to starting state number.
    this.ruleToStartState = [];
    // Maps from rule index to stop state number.
    this.ruleToStopState = null;
    this.modeNameToStartState = {};
    // For lexer ATNs, this maps the rule index to the resulting token type.
    // For parser ATNs, this maps the rule index to the generated bypass token
    // type if the
    // {@link ATNDeserializationOptions//isGenerateRuleBypassTransitions}
    // deserialization option was specified; otherwise, this is {@code null}.
    this.ruleToTokenType = null;
    // For lexer ATNs, this is an array of {@link LexerAction} objects which may
    // be referenced by action transitions in the ATN.
    this.lexerActions = null;
    this.modeToStartState = [];

    return this;
}

// Compute the set of valid tokens that can occur starting in state {@code s}.
//  If {@code ctx} is null, the set of tokens will not include what can follow
//  the rule surrounding {@code s}. In other words, the set will be
//  restricted to tokens reachable staying within {@code s}'s rule.
ATN.prototype.nextTokensInContext = function(s, ctx) {
    var anal = new LL1Analyzer(this);
    return anal.LOOK(s, null, ctx);
};

// Compute the set of valid tokens that can occur starting in {@code s} and
// staying in same rule. {@link Token//EPSILON} is in set if we reach end of
// rule.
ATN.prototype.nextTokensNoContext = function(s) {
    if (s.nextTokenWithinRule !== null ) {
        return s.nextTokenWithinRule;
    }
    s.nextTokenWithinRule = this.nextTokensInContext(s, null);
    s.nextTokenWithinRule.readOnly = true;
    return s.nextTokenWithinRule;
};

ATN.prototype.nextTokens = function(s, ctx) {
    if ( ctx===undefined ) {
        return this.nextTokensNoContext(s);
    } else {
        return this.nextTokensInContext(s, ctx);
    }
};

ATN.prototype.addState = function( state) {
    if ( state !== null ) {
        state.atn = this;
        state.stateNumber = this.states.length;
    }
    this.states.push(state);
};

ATN.prototype.removeState = function( state) {
    this.states[state.stateNumber] = null; // just free mem, don't shift states in list
};

ATN.prototype.defineDecisionState = function( s) {
    this.decisionToState.push(s);
    s.decision = this.decisionToState.length-1;
    return s.decision;
};

ATN.prototype.getDecisionState = function( decision) {
    if (this.decisionToState.length===0) {
        return null;
    } else {
        return this.decisionToState[decision];
    }
};

// Computes the set of input symbols which could follow ATN state number
// {@code stateNumber} in the specified full {@code context}. This method
// considers the complete parser context, but does not evaluate semantic
// predicates (i.e. all predicates encountered during the calculation are
// assumed true). If a path in the ATN exists from the starting state to the
// {@link RuleStopState} of the outermost context without matching any
// symbols, {@link Token//EOF} is added to the returned set.
//
// <p>If {@code context} is {@code null}, it is treated as
// {@link ParserRuleContext//EMPTY}.</p>
//
// @param stateNumber the ATN state number
// @param context the full parse context
// @return The set of potentially valid input symbols which could follow the
// specified state in the specified context.
// @throws IllegalArgumentException if the ATN does not contain a state with
// number {@code stateNumber}
var Token = __webpack_require__(18).Token;

ATN.prototype.getExpectedTokens = function( stateNumber, ctx ) {
    if ( stateNumber < 0 || stateNumber >= this.states.length ) {
        throw("Invalid state number.");
    }
    var s = this.states[stateNumber];
    var following = this.nextTokens(s);
    if (!following.contains(Token.EPSILON)) {
        return following;
    }
    var expected = new IntervalSet();
    expected.addSet(following);
    expected.removeOne(Token.EPSILON);
    while (ctx !== null && ctx.invokingState >= 0 && following.contains(Token.EPSILON)) {
        var invokingState = this.states[ctx.invokingState];
        var rt = invokingState.transitions[0];
        following = this.nextTokens(rt.followState);
        expected.addSet(following);
        expected.removeOne(Token.EPSILON);
        ctx = ctx.parentCtx;
    }
    if (following.contains(Token.EPSILON)) {
        expected.addOne(Token.EOF);
    }
    return expected;
};

ATN.INVALID_ALT_NUMBER = 0;

exports.ATN = ATN;

/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
//

//  An ATN transition between any two ATN states.  Subclasses define
//  atom, set, epsilon, action, predicate, rule transitions.
//
//  <p>This is a one way link.  It emanates from a state (usually via a list of
//  transitions) and has a target state.</p>
//
//  <p>Since we never have to change the ATN transitions once we construct it,
//  we can fix these transitions as specific classes. The DFA transitions
//  on the other hand need to update the labels as it adds transitions to
//  the states. We'll use the term Edge for the DFA to distinguish them from
//  ATN transitions.</p>

var Token = __webpack_require__(18).Token;
var Interval = __webpack_require__(25).Interval;
var IntervalSet = __webpack_require__(25).IntervalSet;
var Predicate = __webpack_require__(88).Predicate;
var PrecedencePredicate = __webpack_require__(88).PrecedencePredicate;

function Transition (target) {
    // The target of this transition.
    if (target===undefined || target===null) {
        throw "target cannot be null.";
    }
    this.target = target;
    // Are we epsilon, action, sempred?
    this.isEpsilon = false;
    this.label = null;
    return this;
}
    // constants for serialization
Transition.EPSILON = 1;
Transition.RANGE = 2;
Transition.RULE = 3;
Transition.PREDICATE = 4; // e.g., {isType(input.LT(1))}?
Transition.ATOM = 5;
Transition.ACTION = 6;
Transition.SET = 7; // ~(A|B) or ~atom, wildcard, which convert to next 2
Transition.NOT_SET = 8;
Transition.WILDCARD = 9;
Transition.PRECEDENCE = 10;

Transition.serializationNames = [
            "INVALID",
            "EPSILON",
            "RANGE",
            "RULE",
            "PREDICATE",
            "ATOM",
            "ACTION",
            "SET",
            "NOT_SET",
            "WILDCARD",
            "PRECEDENCE"
        ];

Transition.serializationTypes = {
        EpsilonTransition: Transition.EPSILON,
        RangeTransition: Transition.RANGE,
        RuleTransition: Transition.RULE,
        PredicateTransition: Transition.PREDICATE,
        AtomTransition: Transition.ATOM,
        ActionTransition: Transition.ACTION,
        SetTransition: Transition.SET,
        NotSetTransition: Transition.NOT_SET,
        WildcardTransition: Transition.WILDCARD,
        PrecedencePredicateTransition: Transition.PRECEDENCE
    };


// TODO: make all transitions sets? no, should remove set edges
function AtomTransition(target, label) {
	Transition.call(this, target);
	this.label_ = label; // The token type or character value; or, signifies special label.
    this.label = this.makeLabel();
    this.serializationType = Transition.ATOM;
    return this;
}

AtomTransition.prototype = Object.create(Transition.prototype);
AtomTransition.prototype.constructor = AtomTransition;

AtomTransition.prototype.makeLabel = function() {
	var s = new IntervalSet();
    s.addOne(this.label_);
    return s;
};

AtomTransition.prototype.matches = function( symbol, minVocabSymbol,  maxVocabSymbol) {
    return this.label_ === symbol;
};

AtomTransition.prototype.toString = function() {
	return this.label_;
};

function RuleTransition(ruleStart, ruleIndex, precedence, followState) {
	Transition.call(this, ruleStart);
    this.ruleIndex = ruleIndex; // ptr to the rule definition object for this rule ref
    this.precedence = precedence;
    this.followState = followState; // what node to begin computations following ref to rule
    this.serializationType = Transition.RULE;
    this.isEpsilon = true;
    return this;
}

RuleTransition.prototype = Object.create(Transition.prototype);
RuleTransition.prototype.constructor = RuleTransition;

RuleTransition.prototype.matches = function(symbol, minVocabSymbol,  maxVocabSymbol) {
	return false;
};


function EpsilonTransition(target, outermostPrecedenceReturn) {
	Transition.call(this, target);
    this.serializationType = Transition.EPSILON;
    this.isEpsilon = true;
    this.outermostPrecedenceReturn = outermostPrecedenceReturn;
    return this;
}

EpsilonTransition.prototype = Object.create(Transition.prototype);
EpsilonTransition.prototype.constructor = EpsilonTransition;

EpsilonTransition.prototype.matches = function( symbol, minVocabSymbol,  maxVocabSymbol) {
	return false;
};

EpsilonTransition.prototype.toString = function() {
	return "epsilon";
};

function RangeTransition(target, start, stop) {
	Transition.call(this, target);
	this.serializationType = Transition.RANGE;
    this.start = start;
    this.stop = stop;
    this.label = this.makeLabel();
    return this;
}

RangeTransition.prototype = Object.create(Transition.prototype);
RangeTransition.prototype.constructor = RangeTransition;

RangeTransition.prototype.makeLabel = function() {
    var s = new IntervalSet();
    s.addRange(this.start, this.stop);
    return s;
};

RangeTransition.prototype.matches = function(symbol, minVocabSymbol,  maxVocabSymbol) {
	return symbol >= this.start && symbol <= this.stop;
};

RangeTransition.prototype.toString = function() {
	return "'" + String.fromCharCode(this.start) + "'..'" + String.fromCharCode(this.stop) + "'";
};

function AbstractPredicateTransition(target) {
	Transition.call(this, target);
	return this;
}

AbstractPredicateTransition.prototype = Object.create(Transition.prototype);
AbstractPredicateTransition.prototype.constructor = AbstractPredicateTransition;

function PredicateTransition(target, ruleIndex, predIndex, isCtxDependent) {
	AbstractPredicateTransition.call(this, target);
    this.serializationType = Transition.PREDICATE;
    this.ruleIndex = ruleIndex;
    this.predIndex = predIndex;
    this.isCtxDependent = isCtxDependent; // e.g., $i ref in pred
    this.isEpsilon = true;
    return this;
}

PredicateTransition.prototype = Object.create(AbstractPredicateTransition.prototype);
PredicateTransition.prototype.constructor = PredicateTransition;

PredicateTransition.prototype.matches = function(symbol, minVocabSymbol,  maxVocabSymbol) {
	return false;
};

PredicateTransition.prototype.getPredicate = function() {
	return new Predicate(this.ruleIndex, this.predIndex, this.isCtxDependent);
};

PredicateTransition.prototype.toString = function() {
	return "pred_" + this.ruleIndex + ":" + this.predIndex;
};

function ActionTransition(target, ruleIndex, actionIndex, isCtxDependent) {
	Transition.call(this, target);
    this.serializationType = Transition.ACTION;
    this.ruleIndex = ruleIndex;
    this.actionIndex = actionIndex===undefined ? -1 : actionIndex;
    this.isCtxDependent = isCtxDependent===undefined ? false : isCtxDependent; // e.g., $i ref in pred
    this.isEpsilon = true;
    return this;
}

ActionTransition.prototype = Object.create(Transition.prototype);
ActionTransition.prototype.constructor = ActionTransition;


ActionTransition.prototype.matches = function(symbol, minVocabSymbol,  maxVocabSymbol) {
	return false;
};

ActionTransition.prototype.toString = function() {
	return "action_" + this.ruleIndex + ":" + this.actionIndex;
};


// A transition containing a set of values.
function SetTransition(target, set) {
	Transition.call(this, target);
	this.serializationType = Transition.SET;
    if (set !==undefined && set !==null) {
        this.label = set;
    } else {
        this.label = new IntervalSet();
        this.label.addOne(Token.INVALID_TYPE);
    }
    return this;
}

SetTransition.prototype = Object.create(Transition.prototype);
SetTransition.prototype.constructor = SetTransition;

SetTransition.prototype.matches = function(symbol, minVocabSymbol,  maxVocabSymbol) {
	return this.label.contains(symbol);
};


SetTransition.prototype.toString = function() {
	return this.label.toString();
};

function NotSetTransition(target, set) {
	SetTransition.call(this, target, set);
	this.serializationType = Transition.NOT_SET;
	return this;
}

NotSetTransition.prototype = Object.create(SetTransition.prototype);
NotSetTransition.prototype.constructor = NotSetTransition;

NotSetTransition.prototype.matches = function(symbol, minVocabSymbol,  maxVocabSymbol) {
	return symbol >= minVocabSymbol && symbol <= maxVocabSymbol &&
			!SetTransition.prototype.matches.call(this, symbol, minVocabSymbol, maxVocabSymbol);
};

NotSetTransition.prototype.toString = function() {
	return '~' + SetTransition.prototype.toString.call(this);
};

function WildcardTransition(target) {
	Transition.call(this, target);
	this.serializationType = Transition.WILDCARD;
	return this;
}

WildcardTransition.prototype = Object.create(Transition.prototype);
WildcardTransition.prototype.constructor = WildcardTransition;


WildcardTransition.prototype.matches = function(symbol, minVocabSymbol,  maxVocabSymbol) {
	return symbol >= minVocabSymbol && symbol <= maxVocabSymbol;
};

WildcardTransition.prototype.toString = function() {
	return ".";
};

function PrecedencePredicateTransition(target, precedence) {
	AbstractPredicateTransition.call(this, target);
    this.serializationType = Transition.PRECEDENCE;
    this.precedence = precedence;
    this.isEpsilon = true;
    return this;
}

PrecedencePredicateTransition.prototype = Object.create(AbstractPredicateTransition.prototype);
PrecedencePredicateTransition.prototype.constructor = PrecedencePredicateTransition;

PrecedencePredicateTransition.prototype.matches = function(symbol, minVocabSymbol,  maxVocabSymbol) {
	return false;
};

PrecedencePredicateTransition.prototype.getPredicate = function() {
	return new PrecedencePredicate(this.precedence);
};

PrecedencePredicateTransition.prototype.toString = function() {
	return this.precedence + " >= _p";
};

exports.Transition = Transition;
exports.AtomTransition = AtomTransition;
exports.SetTransition = SetTransition;
exports.NotSetTransition = NotSetTransition;
exports.RuleTransition = RuleTransition;
exports.ActionTransition = ActionTransition;
exports.EpsilonTransition = EpsilonTransition;
exports.RangeTransition = RangeTransition;
exports.WildcardTransition = WildcardTransition;
exports.PredicateTransition = PredicateTransition;
exports.PrecedencePredicateTransition = PrecedencePredicateTransition;
exports.AbstractPredicateTransition = AbstractPredicateTransition;

/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

var Context = __webpack_require__(11).Context;

function Indenter() {
    this.value = "";
    this.indents = "";
    this.isStartOfLine = true;
    return this;
}

Indenter.prototype.appendTabsIfRequired = function(s) {
    if(this.isStartOfLine) {
        this.value += this.indents;
    }
    this.isStartOfLine = s.charAt(s.length-1)=='\n';
};

Indenter.prototype.append = function(s) {
    this.value += s;
};

Indenter.prototype.trimLast = function(count) {
    this.value = this.value.substring(0, this.value.length - count);
};

Indenter.prototype.indent = function() {
    this.indents += '\t';
};

Indenter.prototype.dedent = function() {
    if(this.indents.length==0) {
        throw new Error("Illegal dedent!");
    }
    this.indents = this.indents.slice(1);
};


function CodeWriter(dialect, context, indenter) {
    this.dialect = dialect;
    this.context = context || Context.newGlobalContext();
    this.indenter = indenter || new Indenter();
    return this;
}

CodeWriter.prototype.isGlobalContext = function() {
    return this.context.isGlobalContext();
};


CodeWriter.prototype.appendRaw = function(s) {
    this.indenter.append(s);
    return this;
};


CodeWriter.prototype.append = function(s) {
    if(typeof(s)!==typeof(""))
        console.error(s);
    this.indenter.appendTabsIfRequired(s);
    this.indenter.append(s);
    return this;
};

CodeWriter.prototype.trimLast = function(count) {
    this.indenter.trimLast(count);
    return this;
};

CodeWriter.prototype.indent = function() {
    this.indenter.indent();
    return this;
};

CodeWriter.prototype.dedent = function() {
    this.indenter.dedent();
    return this;
};

CodeWriter.prototype.newLine = function() {
    this.append('\n');
    return this;
};

CodeWriter.prototype.toString = function() {
    return this.indenter.value;
};

CodeWriter.prototype.newLocalWriter = function() {
    return new CodeWriter(this.dialect, this.context.newLocalContext(), this.indenter);
};

CodeWriter.prototype.newChildWriter = function() {
    return new CodeWriter(this.dialect, this.context.newChildContext(), this.indenter);
};

CodeWriter.prototype.newInstanceWriter = function(type) {
    return new CodeWriter(this.dialect, this.context.newInstanceContext(null, type), this.indenter);
};

CodeWriter.prototype.newDocumentWriter = function() {
    return new CodeWriter(this.dialect, this.context.newDocumentContext(null, false), this.indenter);
};

CodeWriter.prototype.newMemberWriter = function() {
    return new CodeWriter (this.dialect, this.context.newChildContext(), this.indenter);
};

CodeWriter.prototype.toDialect = function(o) {
    this.dialect.toDialect(this, o);
};

exports.CodeWriter = CodeWriter

/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

var IterableType = __webpack_require__(111).IterableType;
var BooleanType = __webpack_require__(5).BooleanType;
var Variable = __webpack_require__(10).Variable;

function ContainerType(id, itemType) {
    IterableType.call(this, id);
	this.itemType = itemType;
	return this;
}

ContainerType.prototype = Object.create(IterableType.prototype);
ContainerType.prototype.constructor = ContainerType;

ContainerType.prototype.checkContains = function(context, other) {
	if(other.isAssignableFrom(context, this.itemType)) {
		return BooleanType.instance;
	} else {
		return IterableType.prototype.checkContains.call(this, context, other);
	}
};


ContainerType.prototype.checkMember = function(context, section, name) {
    if ("count" == name) {
        var IntegerType = __webpack_require__(2).IntegerType;
        return IntegerType.instance;
    } else {
        return IterableType.prototype.checkMember.call(this, context, section, name);
    }
};


ContainerType.prototype.declareMember = function(transpiler, name) {
    if ("count" !== name) {
        return IterableType.prototype.declareMember.call(this, transpiler, name);
    }
};


ContainerType.prototype.transpileMember = function(transpiler, name) {
    if ("count" == name) {
        transpiler.append("length");
    } else {
        return IterableType.prototype.transpileMember.call(this, transpiler, name);
    }
};


ContainerType.prototype.declareSorted = function(transpiler, key) {
    // nothing to do
};

ContainerType.prototype.declareIterator = function(transpiler, name, expression) {
    transpiler = transpiler.newChildTranspiler();
    transpiler.context.registerValue(new Variable(name, this.itemType));
    expression.declare(transpiler);
};


ContainerType.prototype.transpileIterator = function(transpiler, name, expression) {
    transpiler.append(".iterate(function(").append(name).append(") { return ");
    transpiler = transpiler.newChildTranspiler();
    transpiler.context.registerValue(new Variable(name, this.itemType));
    expression.transpile(transpiler);
    transpiler.append("; }, this)");
    transpiler.flush();
};


exports.ContainerType = ContainerType;



/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

var SimpleStatement = __webpack_require__(28).SimpleStatement;
var MethodFinder = __webpack_require__(181).MethodFinder;
var MethodSelector = __webpack_require__(53).MethodSelector;
var ArgumentAssignmentList = __webpack_require__(39).ArgumentAssignmentList;
var AbstractMethodDeclaration = __webpack_require__(190).AbstractMethodDeclaration;
var ConcreteMethodDeclaration = __webpack_require__(78).ConcreteMethodDeclaration;
var DispatchMethodDeclaration = __webpack_require__(209).DispatchMethodDeclaration;
var MethodDeclarationMap = null;
var ClosureDeclaration = __webpack_require__(592).ClosureDeclaration;
var ClosureValue = __webpack_require__(97).ClosureValue;
var NotMutableError = __webpack_require__(118).NotMutableError;
var PromptoError = __webpack_require__(30).PromptoError;
var InstanceContext = null;
var ThisExpression = null;
var VoidType = __webpack_require__(4).VoidType;
var Section = __webpack_require__(19).Section;
var Dialect = __webpack_require__(8).Dialect;
var BooleanValue = __webpack_require__(20).BooleanValue;
var IntegerType = __webpack_require__(2).IntegerType;
var DecimalType = __webpack_require__(23).DecimalType;
var Identifier = __webpack_require__(0).Identifier;
var CodeArgument = __webpack_require__(116).CodeArgument;


exports.resolve = function() {
    InstanceContext = __webpack_require__(11).InstanceContext;
    ThisExpression = __webpack_require__(215).ThisExpression;
    MethodDeclarationMap = __webpack_require__(11).MethodDeclarationMap;
};


function MethodCall(selector, assignments) {
	SimpleStatement.call(this);
	this.selector = selector;
	this.assignments = assignments || null;
	return this;
}

MethodCall.prototype = Object.create(SimpleStatement.prototype);
MethodCall.prototype.constructor = MethodCall;

MethodCall.prototype.toDialect = function(writer) {
    if (this.requiresInvoke(writer))
        writer.append("invoke: ");
    this.selector.toDialect(writer);
    if (this.assignments != null)
        this.assignments.toDialect(writer);
    else if (writer.dialect!= Dialect.E)
        writer.append("()");
};

MethodCall.prototype.requiresInvoke = function(writer) {
    if (writer.dialect != Dialect.E || (this.assignments != null && this.assignments.length > 0))
        return false;
    try {
        finder = new MethodFinder(writer.context, this);
        var declaration = finder.findMethod(false);
        /* if method is a reference, need to prefix with invoke */
        return declaration instanceof AbstractMethodDeclaration || declaration.closureOf !== null;
    } catch(e) {
        // ok
    }
    return false;
}

MethodCall.prototype.toString = function() {
	return this.selector.toString() + " " + (this.assignments!==null ? this.assignments.toString() : "");
};


MethodCall.prototype.check = function(context, updateSelectorParent) {
	var finder = new MethodFinder(context, this);
	var declaration = finder.findMethod(false);
    if(!declaration) {
        context.problemListener.reportUnknownMethod(this.selector.id);
        return VoidType.instance;
    }
    if(updateSelectorParent && declaration.memberOf && !this.selector.parent)
        this.selector.parent = new ThisExpression();
    var local = this.isLocalClosure(context) ? context : this.selector.newLocalCheckContext(context, declaration);
    return this.checkDeclaration(declaration, context, local);
};


MethodCall.prototype.isLocalClosure = function(context) {
    if (this.selector.parent !== null) {
        return false;
    }
    var decl = context.getLocalDeclaration(this.selector.name)
    return decl instanceof MethodDeclarationMap;
};



MethodCall.prototype.checkDeclaration = function(declaration, parent, local) {
	if(declaration instanceof ConcreteMethodDeclaration && declaration.mustBeCheckedInCallContext(parent)) {
		return this.fullCheck(declaration, parent, local);
	} else {
		return this.lightCheck(declaration, local);
	}
};

MethodCall.prototype.lightCheck = function(declaration, local) {
	declaration.registerArguments(local);
	return declaration.check(local, false);
};

MethodCall.prototype.fullCheck = function(declaration, parent, local) {
	try {
		var assignments = this.makeAssignments(parent, declaration);
		declaration.registerArguments(local);
		assignments.forEach(function(assignment) {
			var expression = assignment.resolve(local, declaration, true);
			var value = assignment.argument.checkValue(parent, expression);
			local.setValue(assignment.id, value);
		});
		return declaration.check(local, false);
	} catch (e) {
		if(e instanceof PromptoError) {
			throw new SyntaxError(e.message);
		}
	}
};


MethodCall.prototype.declare = function(transpiler) {
    if (this.assignments != null)
        this.assignments.declare(transpiler);
    var finder = new MethodFinder(transpiler.context, this);
    var declarations = finder.findCompatibleMethods(false, true);
    var first = declarations.size===1 ? declarations.values().next().value : null;
    if(declarations.size===1 && first instanceof BuiltInMethodDeclaration) {
        if(first.declareCall)
            first.declareCall(transpiler);
    } else {
        if(!this.isLocalClosure(transpiler.context)) {
            declarations.forEach(function(declaration) {
                var local = this.selector.newLocalCheckContext(transpiler.context, declaration);
                this.declareDeclaration(transpiler, declaration, local);
            }, this);
        }
        if(declarations.size>1 && !this.dispatcher) {
            var declaration = finder.findMethod(false);
            var sorted = finder.sortMostSpecificFirst(declarations);
            this.dispatcher = new DispatchMethodDeclaration(transpiler.context, this, declaration, sorted);
            transpiler.declare(this.dispatcher);
        }
    }
};

MethodCall.prototype.declareDeclaration = function(transpiler, declaration, local) {
    if(declaration instanceof ConcreteMethodDeclaration && declaration.mustBeCheckedInCallContext(transpiler.context)) {
        this.fullDeclareDeclaration(declaration, transpiler, local);
    } else {
        this.lightDeclareDeclaration(declaration, transpiler, local);
    }
};

MethodCall.prototype.lightDeclareDeclaration = function(declaration, transpiler, local) {
    transpiler = transpiler.copyTranspiler(local);
    declaration.declare(transpiler);
};

var fullDeclareCounter = 0;

MethodCall.prototype.fullDeclareDeclaration = function(declaration, transpiler, local) {
    if(!this.fullSelector) {
        var assignments = this.makeAssignments(transpiler.context, declaration);
        declaration.registerArguments(local);
        assignments.forEach(function(assignment) {
            var expression = assignment.resolve(local, declaration, true);
            var value = assignment.argument.checkValue(transpiler.context, expression);
            local.setValue(assignment.id, value);
        });
        transpiler = transpiler.copyTranspiler(local);
        this.fullSelector = this.selector.newFullSelector(++fullDeclareCounter);
        declaration.fullDeclare(transpiler, this.fullSelector.id);
    }
};



MethodCall.prototype.transpile = function(transpiler) {
    var finder = new MethodFinder(transpiler.context, this);
    var declarations = finder.findCompatibleMethods(false, true);
    if (declarations.size === 1) {
        var first = declarations.values().next().value;
        this.transpileSingle(transpiler, first, false);
    } else
        this.transpileMultiple(transpiler, declarations);
};


MethodCall.prototype.transpileMultiple = function(transpiler, declarations) {
    var name = this.dispatcher.getTranspiledName(transpiler.context);
    var parent = this.selector.resolveParent(transpiler.context);
    var first = declarations.values().next().value;
    if(parent==null && first.memberOf && transpiler.context.parent instanceof InstanceContext)
        parent = new ThisExpression();
    var selector = new MethodSelector(parent, new Identifier(name));
    selector.transpile(transpiler);
    this.transpileAssignments(transpiler, this.dispatcher);
};

MethodCall.prototype.transpileSingle = function(transpiler, declaration, allowDerived) {
    if (declaration instanceof BuiltInMethodDeclaration)
        this.transpileBuiltin(transpiler, declaration);
    else {
        this.transpileSelector(transpiler, declaration);
        this.transpileAssignments(transpiler, declaration, allowDerived);
    }
};

MethodCall.prototype.transpileBuiltin = function(transpiler, declaration) {
    var parent = this.selector.resolveParent(transpiler.context);
    parent.transpile(transpiler);
    transpiler.append(".");
    declaration.transpileCall(transpiler, this.assignments);
};


MethodCall.prototype.transpileSelector = function(transpiler, declaration) {
    var selector = this.fullSelector || this.selector;
    var parent = selector.resolveParent(transpiler.context);
    if (parent == null && declaration.memberOf && transpiler.context.parent instanceof InstanceContext)
        parent = new ThisExpression();
    var name = null;
    if(this.variableName)
        name = this.variableName;
    else if(this.fullSelector)
        name = this.fullSelector.name;
    else
        name = declaration.getTranspiledName(transpiler.context);
    selector = new MethodSelector(parent, new Identifier(name));
    selector.transpile(transpiler);
};


MethodCall.prototype.transpileAssignments = function(transpiler, declaration, allowDerived) {
    var assignments = this.makeAssignments(transpiler.context, declaration);
    assignments = assignments.filter(function(assignment) {
        return !(assignment.argument instanceof CodeArgument);
    });
    if(assignments.length > 0) {
        transpiler.append("(");
        assignments.forEach(function (assignment) {
            var argument = assignment.argument;
            var expression = assignment.resolve(transpiler.context, declaration, false, allowDerived);
            argument.transpileCall(transpiler, expression);
            transpiler.append(", ");
        });
        transpiler.trimLast(2);
        transpiler.append(")");
    } else
        transpiler.append("()");
};



MethodCall.prototype.makeAssignments = function(context, declaration) {
	return (this.assignments || new ArgumentAssignmentList()).makeAssignments(context, declaration);
};

MethodCall.prototype.interpret = function(context) {
	var declaration = this.findDeclaration(context);
	var local = this.selector.newLocalContext(context, declaration);
	declaration.registerArguments(local);
	var assignments = this.makeAssignments(context, declaration);
	assignments.forEach(function(assignment) {
		var expression = assignment.resolve(local, declaration, true);
        var argument = assignment.argument;
		var value = argument.checkValue(context, expression);
        if(value!=null && argument.mutable && !value.mutable)
            throw new NotMutableError();
		local.setValue(assignment.id, value);
	});
	return declaration.interpret(local, true);
};

MethodCall.prototype.interpretAssert = function(context, testMethodDeclaration) {
    var value = this.interpret(context);
    if(value instanceof BooleanValue)
        return value.value;
    else {
        var expected = this.getExpected(context, this.dialect);
        throw new SyntaxError("Cannot test '" + expected + "'");
    }
};

MethodCall.prototype.getExpected = function(context, dialect, escapeMode) {
    var writer = new CodeWriter(this.dialect, context);
    writer.escapeMode = escapeMode;
    this.toDialect(writer);
    return writer.toString();
};


MethodCall.prototype.transpileFound = function(transpiler, dialect) {
    transpiler.append("'<unknown>'");
};


MethodCall.prototype.findDeclaration = function(context) {
	// look for method as value
	try {
		var o = context.getValue(this.selector.id);
		if(o instanceof ClosureValue) {
			return new ClosureDeclaration(o);
		}
	} catch (e) {
		if(!(e instanceof PromptoError)) {
			throw e;
		}
	}
	// look for declared method
	var finder = new MethodFinder(context,this);
	return finder.findMethod(true);
};

exports.MethodCall = MethodCall;

/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

var SelectorExpression = __webpack_require__(94).SelectorExpression;
var UnresolvedIdentifier = null;
var SymbolExpression = __webpack_require__(182).SymbolExpression;
var TypeExpression = __webpack_require__(183).TypeExpression;
var NullReferenceError = __webpack_require__(49).NullReferenceError;
var EnumeratedCategoryType = null;
var CategoryType = null;
var NullValue = __webpack_require__(21).NullValue;
var Value = __webpack_require__(1).Value;
var Text = __webpack_require__(17).Text;
var Dialect = __webpack_require__(8).Dialect;
var MethodType = __webpack_require__(38).MethodType;

exports.resolve = function() {
    UnresolvedIdentifier = __webpack_require__(27).UnresolvedIdentifier;
    EnumeratedCategoryType = __webpack_require__(112).EnumeratedCategoryType;
    CategoryType = __webpack_require__(7).CategoryType;

}

function MemberSelector(parent, id) {
	SelectorExpression.call(this, parent);
	this.id = id;
	return this;
}

MemberSelector.prototype = Object.create(SelectorExpression.prototype);
MemberSelector.prototype.constructor = MemberSelector;

Object.defineProperty(MemberSelector.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});


MemberSelector.prototype.toDialect = function(writer) {
    if (writer.dialect == Dialect.E) {
        var type = this.check(writer.context);
        if (type instanceof MethodType) {
            writer.append("Method: ");
        }
    }
    this.parentAndMemberToDialect(writer);
};


MemberSelector.prototype.parentAndMemberToDialect = function(writer) {
    // ensure singletons are not treated as constructors
    try {
        this.resolveParent(writer.context);
    } catch(e) {
        // ignore
    }
    this.parent.toDialect(writer);
    writer.append(".");
    writer.append(this.name);
};



MemberSelector.prototype.declareParent = function(transpiler) {
    // resolve parent to keep clarity
    var parent = this.resolveParent(transpiler.context);
    parent.declare(transpiler);
};


MemberSelector.prototype.declare = function(transpiler) {
    this.declareParent(transpiler);
    var parentType = this.checkParent(transpiler.context);
    return parentType.declareMember(transpiler, this.name);
};


MemberSelector.prototype.transpile = function(transpiler) {
    // resolve parent to keep clarity
    var parent = this.resolveParent(transpiler.context);
    // special case for singletons
    if(this.transpileSingleton(transpiler, parent))
        return;
    // special case for 'static' type members (like Enum.symbols, Type.name etc...)
    if(this.transpileTypeMember(transpiler, parent))
        return;
    // finally resolve instance member
    this.transpileInstanceMember(transpiler, parent);
};

MemberSelector.prototype.transpileSingleton = function(transpiler, parent) {
    if(parent instanceof TypeExpression && parent.value instanceof CategoryType && !(parent.value instanceof EnumeratedCategoryType)) {
        parent.value.transpileInstance(transpiler);
        transpiler.append(".").append(this.name);
        return true;
    } else
        return false;
};


MemberSelector.prototype.transpileTypeMember = function(transpiler, parent) {
    return false; // TODO
};

MemberSelector.prototype.transpileInstanceMember = function(transpiler, parent) {
    parent.transpile(transpiler);
    transpiler.append(".");
    var type = parent.check(transpiler.context);
    type.transpileMember(transpiler, this.name);
};


MemberSelector.prototype.toString = function() {
	return this.parent.toString() + "." + this.name;
};

MemberSelector.prototype.check = function(context) {
    var parentType = this.checkParent(context);
    return parentType.checkMember(context, this.id, this.name);
};

MemberSelector.prototype.interpret = function(context) {
    // resolve parent to keep clarity
    var parent = this.resolveParent(context);
    // special case for singletons
    var value = this.interpretSingleton(context, parent);
    if(value!=null)
        return value;
    // special case for 'static' type members (like Enum.symbols, Type.name etc...)
    value = this.interpretTypeMember(context, parent);
    if(value!=null)
        return value;
    // finally resolve instance member
    return this.interpretInstanceMember(context, parent);
};

MemberSelector.prototype.interpretInstanceMember = function(context, parent) {
    var instance = this.parent.interpret(context);
    if (instance == null || instance == NullValue.instance)
        throw new NullReferenceError();
    else
        return instance.getMemberValue(context, this.name, true);
};

MemberSelector.prototype.interpretTypeMember = function(context, parent) {
    if(parent instanceof TypeExpression)
        return parent.getMemberValue(context, this.name);
    else
        return null;
};

MemberSelector.prototype.interpretSingleton = function(context, parent) {
    if(parent instanceof TypeExpression && parent.value instanceof CategoryType && !(parent.value instanceof EnumeratedCategoryType)) {
        var instance = context.loadSingleton(parent.value);
        if(instance!=null)
            return instance.getMemberValue(context, this.name);
    }
    return null;
};

MemberSelector.prototype.resolveParent = function(context) {
    if(this.parent instanceof UnresolvedIdentifier) {
        this.parent.checkMember(context);
        return this.parent.resolved;
    } else
        return this.parent;
};

exports.MemberSelector = MemberSelector;



/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

var ExecutionError = __webpack_require__(48).ExecutionError;
var TextLiteral = __webpack_require__(74).TextLiteral;

function InvalidDataError(message) {
	ExecutionError.call(this, message);
	return this;
}

InvalidDataError.prototype = Object.create(ExecutionError.prototype);
InvalidDataError.prototype.constructor = InvalidDataError;

InvalidDataError.prototype.getExpression = function(context) {
	return new TextLiteral("'" + this.message + "'");
};

exports.InvalidDataError = InvalidDataError;


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

var ContainerType = __webpack_require__(61).ContainerType;
var ListType = __webpack_require__(26).ListType;
var IntegerType = __webpack_require__(2).IntegerType;
var BooleanType = __webpack_require__(5).BooleanType;
var Identifier = __webpack_require__(0).Identifier;

function SetType(itemType) {
	ContainerType.call(this, new Identifier(itemType.name+"<>"), itemType);
	this.itemType = itemType;
	return this;
}

SetType.prototype = Object.create(ContainerType.prototype);
SetType.prototype.constructor = SetType;

SetType.prototype.withItemType = function(itemType) {
    return new SetType(itemType);
};

SetType.prototype.getTranspiledName = function(context) {
    return this.itemType.getTranspiledName(context) + "_set";
};


SetType.prototype.equals = function(obj) {
	if(obj===this) {
		return true;
	}
	if(obj===null) {
		return false;
	}
	if(!(obj instanceof SetType)) {
		return false;
	}
	return this.itemType.equals(obj.itemType);
};

SetType.prototype.checkAdd = function(context, other, tryReverse) {
	if((other instanceof SetType || other instanceof ListType) && this.itemType.equals(other.itemType)) {
		return this;
	} else {
		return ContainerType.prototype.checkAdd.call(this, context, other, tryReverse);
	}
};


SetType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if((other instanceof SetType || other instanceof ListType) && this.itemType.equals(other.itemType)) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else {
        return ContainerType.prototype.declareAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};


SetType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if((other instanceof SetType || other instanceof ListType) && this.itemType.equals(other.itemType)) {
        left.transpile(transpiler);
        transpiler.append(".addAll(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else {
        return ContainerType.prototype.transpileAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};


SetType.prototype.checkSubtract = function(context, other) {
    if((other instanceof SetType || other instanceof ListType) && this.itemType.equals(other.itemType)) {
        return this;
    } else {
        return ContainerType.prototype.checkSubtract.call(this, context, other);
    }
};


SetType.prototype.declareSubtract = function(transpiler, other, left, right) {
    if((other instanceof SetType || other instanceof ListType) && this.itemType.equals(other.itemType)) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else {
        return ContainerType.prototype.declareSubtract.call(this, transpiler, other, left, right);
    }
};


SetType.prototype.transpileSubtract= function(transpiler, other, left, right) {
    if((other instanceof SetType || other instanceof ListType) && this.itemType.equals(other.itemType)) {
        left.transpile(transpiler);
        transpiler.append(".remove(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else {
        return ContainerType.prototype.transpileSubtract.call(this, transpiler, other, left, right);
    }
};


SetType.prototype.checkItem = function(context, other) {
	if(other==IntegerType.instance) {
		return this.itemType;
	} else {
		return ContainerType.prototype.checkItem.call(this, context, other);
	}
};

SetType.prototype.declareItem = function(transpiler, itemType, item) {
    // nothing to do
};


SetType.prototype.transpileItem = function(transpiler, itemType, item) {
    transpiler.append(".item(");
    item.transpile(transpiler);
    transpiler.append("-1)");
};

SetType.prototype.declareContains = function(transpiler, other, container, item) {
    container.declare(transpiler);
    item.declare(transpiler);
};


SetType.prototype.transpileContains = function(transpiler, other, container, item) {
    container.transpile(transpiler);
    transpiler.append(".has(");
    item.transpile(transpiler);
    transpiler.append(")");
};


SetType.prototype.checkContainsAllOrAny = function(context, other) {
	return BooleanType.instance;
}


SetType.prototype.declareContainsAllOrAny = function(transpiler, other, container, items) {
    var StrictSet = __webpack_require__(34).StrictSet;
    transpiler.require(StrictSet);
    container.declare(transpiler);
    items.declare(transpiler);
};


SetType.prototype.transpileContainsAll = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAll(");
    items.transpile(transpiler);
    transpiler.append(")");
};


SetType.prototype.transpileContainsAny = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAny(");
    items.transpile(transpiler);
    transpiler.append(")");
};


SetType.prototype.checkIterator = function(context, source) {
	return this.itemType;
}


SetType.prototype.isAssignableFrom = function(context, other) {
    return ContainerType.prototype.isAssignableFrom.call(this, context, other)
        || ((other instanceof SetType) && this.itemType.isAssignableFrom(context, other.itemType));
};


exports.SetType = SetType;


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

var NullValue = __webpack_require__(21).NullValue;
var Value = __webpack_require__(1).Value;
var TextValue = __webpack_require__(17).TextValue;
var DocumentType = __webpack_require__(55).DocumentType;
var Document = __webpack_require__(98).Document;

function DocumentValue(values) {
    Value.call(this, DocumentType.instance);
    this.mutable = true;
    this.values = values || new Document();
    return this;
}

DocumentValue.prototype = Object.create(Value.prototype);
DocumentValue.prototype.constructor = DocumentValue;


DocumentValue.prototype.getMemberNames = function() {
    return Object.getOwnPropertyNames(this.values);
};


DocumentValue.prototype.getStorableData = function() {
    return this.values;
};

DocumentValue.prototype.hasMember = function(name) {
    return this.values.hasOwnProperty(name);
}

DocumentValue.prototype.getMemberValue = function(context, name, autoCreate) {
    if(this.values.hasOwnProperty(name))
        return this.values[name] || null;
    else if("text" == name)
        return new TextValue(this.toString());
    else if(autoCreate) {
        result = new DocumentValue();
        this.values[name] = result;
        return result;
    } else
        return NullValue.instance;
};

DocumentValue.prototype.setMember = function(context, name, value) {
    this.values[name] = value;
};


DocumentValue.prototype.getItemInContext = function(context, index) {
    if (index instanceof TextValue) {
        // TODO autocreate
        return this.values[index.value] || NullValue.instance;
    } else {
        throw new SyntaxError("No such item:" + index.toString())
    }
};



DocumentValue.prototype.setItemInContext = function(context, index, value) {
    if (index instanceof TextValue) {
        this.values[index.value] = value
    } else {
        throw new SyntaxError("No such item:" + index.toString());
    }
};

DocumentValue.prototype.equals = function(other) {
    return other==this;
};


DocumentValue.prototype.toString = function() {
    var binaries = {};
    // create json type-aware object graph and collect binaries
    var values = {}; // need a temporary parent
    for (var key in this.values) {
        var value = this.values[key];
        if(typeof(value) === 'function')
            continue;
        if (value == null || value == undefined)
            values[key] = null;
        else {
            var id = this; // TODO create identifier
            value.toJson(null, values, id, key, false, binaries);
        }
    }
    return JSON.stringify(values);
};

DocumentValue.prototype.toJson = function(context, json, instanceId, fieldName, withType, binaries) {
    var values = {};
    Object.getOwnPropertyNames(this.values).forEach(function(key) {
        var value = this.values[key];
        if (value == null || value == undefined)
            values[key] = null;
        else {
            var id = this; // TODO create identifier
            value.toJson(context, values, id, key, withType, binaries);
        }
    }, this);
    var doc = withType ? { type: DocumentType.instance.name, value: values} : values;
    if(Array.isArray(json))
        json.push(doc);
    else
        json[fieldName] = doc;
};

DocumentValue.prototype.declare = function(transpiler) {
    transpiler.require(Document);
};

exports.DocumentValue = DocumentValue;




/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Buffer) {

exports.base64 = true;
exports.array = true;
exports.string = true;
exports.arraybuffer = typeof ArrayBuffer !== "undefined" && typeof Uint8Array !== "undefined";
exports.nodebuffer = typeof Buffer !== "undefined";
// contains true if JSZip can read/generate Uint8Array, false otherwise.
exports.uint8array = typeof Uint8Array !== "undefined";

if (typeof ArrayBuffer === "undefined") {
    exports.blob = false;
}
else {
    var buffer = new ArrayBuffer(0);
    try {
        exports.blob = new Blob([buffer], {
            type: "application/zip"
        }).size === 0;
    }
    catch (e) {
        try {
            var Builder = window.BlobBuilder || window.WebKitBlobBuilder || window.MozBlobBuilder || window.MSBlobBuilder;
            var builder = new Builder();
            builder.append(buffer);
            exports.blob = builder.getBlob('application/zip').size === 0;
        }
        catch (e) {
            exports.blob = false;
        }
    }
}

try {
    exports.nodestream = !!__webpack_require__(266).Readable;
} catch(e) {
    exports.nodestream = false;
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(102).Buffer))

/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";



var TYPED_OK =  (typeof Uint8Array !== 'undefined') &&
                (typeof Uint16Array !== 'undefined') &&
                (typeof Int32Array !== 'undefined');

function _has(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
}

exports.assign = function (obj /*from1, from2, from3, ...*/) {
  var sources = Array.prototype.slice.call(arguments, 1);
  while (sources.length) {
    var source = sources.shift();
    if (!source) { continue; }

    if (typeof source !== 'object') {
      throw new TypeError(source + 'must be non-object');
    }

    for (var p in source) {
      if (_has(source, p)) {
        obj[p] = source[p];
      }
    }
  }

  return obj;
};


// reduce buffer size, avoiding mem copy
exports.shrinkBuf = function (buf, size) {
  if (buf.length === size) { return buf; }
  if (buf.subarray) { return buf.subarray(0, size); }
  buf.length = size;
  return buf;
};


var fnTyped = {
  arraySet: function (dest, src, src_offs, len, dest_offs) {
    if (src.subarray && dest.subarray) {
      dest.set(src.subarray(src_offs, src_offs + len), dest_offs);
      return;
    }
    // Fallback to ordinary array
    for (var i = 0; i < len; i++) {
      dest[dest_offs + i] = src[src_offs + i];
    }
  },
  // Join array of chunks to single array.
  flattenChunks: function (chunks) {
    var i, l, len, pos, chunk, result;

    // calculate data length
    len = 0;
    for (i = 0, l = chunks.length; i < l; i++) {
      len += chunks[i].length;
    }

    // join chunks
    result = new Uint8Array(len);
    pos = 0;
    for (i = 0, l = chunks.length; i < l; i++) {
      chunk = chunks[i];
      result.set(chunk, pos);
      pos += chunk.length;
    }

    return result;
  }
};

var fnUntyped = {
  arraySet: function (dest, src, src_offs, len, dest_offs) {
    for (var i = 0; i < len; i++) {
      dest[dest_offs + i] = src[src_offs + i];
    }
  },
  // Join array of chunks to single array.
  flattenChunks: function (chunks) {
    return [].concat.apply([], chunks);
  }
};


// Enable/Disable typed arrays use, for testing
//
exports.setTyped = function (on) {
  if (on) {
    exports.Buf8  = Uint8Array;
    exports.Buf16 = Uint16Array;
    exports.Buf32 = Int32Array;
    exports.assign(exports, fnTyped);
  } else {
    exports.Buf8  = Array;
    exports.Buf16 = Array;
    exports.Buf32 = Array;
    exports.assign(exports, fnUntyped);
  }
};

exports.setTyped(TYPED_OK);


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

//
// Specialized {@link Set}{@code <}{@link ATNConfig}{@code >} that can track
// info about the set, with support for combining similar configurations using a
// graph-structured stack.
///

var ATN = __webpack_require__(58).ATN;
var Utils = __webpack_require__(13);
var Hash = Utils.Hash;
var Set = Utils.Set;
var SemanticContext = __webpack_require__(88).SemanticContext;
var merge = __webpack_require__(51).merge;

function hashATNConfig(c) {
	return c.hashCodeForConfigSet();
}

function equalATNConfigs(a, b) {
	if ( a===b ) {
		return true;
	} else if ( a===null || b===null ) {
		return false;
	} else
       return a.equalsForConfigSet(b);
 }


function ATNConfigSet(fullCtx) {
	//
	// The reason that we need this is because we don't want the hash map to use
	// the standard hash code and equals. We need all configurations with the
	// same
	// {@code (s,i,_,semctx)} to be equal. Unfortunately, this key effectively
	// doubles
	// the number of objects associated with ATNConfigs. The other solution is
	// to
	// use a hash table that lets us specify the equals/hashcode operation.
	// All configs but hashed by (s, i, _, pi) not including context. Wiped out
	// when we go readonly as this set becomes a DFA state.
	this.configLookup = new Set(hashATNConfig, equalATNConfigs);
	// Indicates that this configuration set is part of a full context
	// LL prediction. It will be used to determine how to merge $. With SLL
	// it's a wildcard whereas it is not for LL context merge.
	this.fullCtx = fullCtx === undefined ? true : fullCtx;
	// Indicates that the set of configurations is read-only. Do not
	// allow any code to manipulate the set; DFA states will point at
	// the sets and they must not change. This does not protect the other
	// fields; in particular, conflictingAlts is set after
	// we've made this readonly.
	this.readOnly = false;
	// Track the elements as they are added to the set; supports get(i)///
	this.configs = [];

	// TODO: these fields make me pretty uncomfortable but nice to pack up info
	// together, saves recomputation
	// TODO: can we track conflicts as they are added to save scanning configs
	// later?
	this.uniqueAlt = 0;
	this.conflictingAlts = null;

	// Used in parser and lexer. In lexer, it indicates we hit a pred
	// while computing a closure operation. Don't make a DFA state from this.
	this.hasSemanticContext = false;
	this.dipsIntoOuterContext = false;

	this.cachedHashCode = -1;

	return this;
}

// Adding a new config means merging contexts with existing configs for
// {@code (s, i, pi, _)}, where {@code s} is the
// {@link ATNConfig//state}, {@code i} is the {@link ATNConfig//alt}, and
// {@code pi} is the {@link ATNConfig//semanticContext}. We use
// {@code (s,i,pi)} as key.
//
// <p>This method updates {@link //dipsIntoOuterContext} and
// {@link //hasSemanticContext} when necessary.</p>
// /
ATNConfigSet.prototype.add = function(config, mergeCache) {
	if (mergeCache === undefined) {
		mergeCache = null;
	}
	if (this.readOnly) {
		throw "This set is readonly";
	}
	if (config.semanticContext !== SemanticContext.NONE) {
		this.hasSemanticContext = true;
	}
	if (config.reachesIntoOuterContext > 0) {
		this.dipsIntoOuterContext = true;
	}
	var existing = this.configLookup.add(config);
	if (existing === config) {
		this.cachedHashCode = -1;
		this.configs.push(config); // track order here
		return true;
	}
	// a previous (s,i,pi,_), merge with it and save result
	var rootIsWildcard = !this.fullCtx;
	var merged = merge(existing.context, config.context, rootIsWildcard, mergeCache);
	// no need to check for existing.context, config.context in cache
	// since only way to create new graphs is "call rule" and here. We
	// cache at both places.
	existing.reachesIntoOuterContext = Math.max( existing.reachesIntoOuterContext, config.reachesIntoOuterContext);
	// make sure to preserve the precedence filter suppression during the merge
	if (config.precedenceFilterSuppressed) {
		existing.precedenceFilterSuppressed = true;
	}
	existing.context = merged; // replace context; no need to alt mapping
	return true;
};

ATNConfigSet.prototype.getStates = function() {
	var states = new Set();
	for (var i = 0; i < this.configs.length; i++) {
		states.add(this.configs[i].state);
	}
	return states;
};

ATNConfigSet.prototype.getPredicates = function() {
	var preds = [];
	for (var i = 0; i < this.configs.length; i++) {
		var c = this.configs[i].semanticContext;
		if (c !== SemanticContext.NONE) {
			preds.push(c.semanticContext);
		}
	}
	return preds;
};

Object.defineProperty(ATNConfigSet.prototype, "items", {
	get : function() {
		return this.configs;
	}
});

ATNConfigSet.prototype.optimizeConfigs = function(interpreter) {
	if (this.readOnly) {
		throw "This set is readonly";
	}
	if (this.configLookup.length === 0) {
		return;
	}
	for (var i = 0; i < this.configs.length; i++) {
		var config = this.configs[i];
		config.context = interpreter.getCachedContext(config.context);
	}
};

ATNConfigSet.prototype.addAll = function(coll) {
	for (var i = 0; i < coll.length; i++) {
		this.add(coll[i]);
	}
	return false;
};

ATNConfigSet.prototype.equals = function(other) {
	return this === other ||
		(other instanceof ATNConfigSet &&
		Utils.equalArrays(this.configs, other.configs) &&
		this.fullCtx === other.fullCtx &&
		this.uniqueAlt === other.uniqueAlt &&
		this.conflictingAlts === other.conflictingAlts &&
		this.hasSemanticContext === other.hasSemanticContext &&
		this.dipsIntoOuterContext === other.dipsIntoOuterContext);
};

ATNConfigSet.prototype.hashCode = function() {
    var hash = new Hash();
    this.updateHashCode(hash);
    return hash.finish();
};


ATNConfigSet.prototype.updateHashCode = function(hash) {
	if (this.readOnly) {
		if (this.cachedHashCode === -1) {
            var hash = new Hash();
            hash.update(this.configs);
			this.cachedHashCode = hash.finish();
		}
        hash.update(this.cachedHashCode);
	} else {
        hash.update(this.configs);
	}
};


Object.defineProperty(ATNConfigSet.prototype, "length", {
	get : function() {
		return this.configs.length;
	}
});

ATNConfigSet.prototype.isEmpty = function() {
	return this.configs.length === 0;
};

ATNConfigSet.prototype.contains = function(item) {
	if (this.configLookup === null) {
		throw "This method is not implemented for readonly sets.";
	}
	return this.configLookup.contains(item);
};

ATNConfigSet.prototype.containsFast = function(item) {
	if (this.configLookup === null) {
		throw "This method is not implemented for readonly sets.";
	}
	return this.configLookup.containsFast(item);
};

ATNConfigSet.prototype.clear = function() {
	if (this.readOnly) {
		throw "This set is readonly";
	}
	this.configs = [];
	this.cachedHashCode = -1;
	this.configLookup = new Set();
};

ATNConfigSet.prototype.setReadonly = function(readOnly) {
	this.readOnly = readOnly;
	if (readOnly) {
		this.configLookup = null; // can't mod, no need for lookup cache
	}
};

ATNConfigSet.prototype.toString = function() {
	return Utils.arrayToString(this.configs) +
		(this.hasSemanticContext ? ",hasSemanticContext=" + this.hasSemanticContext : "") +
		(this.uniqueAlt !== ATN.INVALID_ALT_NUMBER ? ",uniqueAlt=" + this.uniqueAlt : "") +
		(this.conflictingAlts !== null ? ",conflictingAlts=" + this.conflictingAlts : "") +
		(this.dipsIntoOuterContext ? ",dipsIntoOuterContext" : "");
};

function OrderedATNConfigSet() {
	ATNConfigSet.call(this);
	this.configLookup = new Set();
	return this;
}

OrderedATNConfigSet.prototype = Object.create(ATNConfigSet.prototype);
OrderedATNConfigSet.prototype.constructor = OrderedATNConfigSet;

exports.ATNConfigSet = ATNConfigSet;
exports.OrderedATNConfigSet = OrderedATNConfigSet;


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

var BaseDeclaration = __webpack_require__(110).BaseDeclaration;
var InternalError = __webpack_require__(46).InternalError;
var ContainerType = __webpack_require__(61).ContainerType;
var AttributeInfo = __webpack_require__(159).AttributeInfo;
var Value = __webpack_require__(1).Value;

function AttributeDeclaration(id, type, constraint, indexTypes) {
	BaseDeclaration.call(this, id);
	this.type = type;
	this.constraint = constraint;
    this.indexTypes = indexTypes;
    this.storable = false;
    return this;
}

AttributeDeclaration.prototype = Object.create(BaseDeclaration.prototype);
AttributeDeclaration.prototype.constructor = AttributeDeclaration;

AttributeDeclaration.prototype.getDeclarationType = function() {
    return "Attribute";
};

AttributeDeclaration.prototype.getType = function() {
	return this.type;
};
	
AttributeDeclaration.prototype.toString = function() {
	return this.name + ':' + this.type.toString();
};

AttributeDeclaration.prototype.toDialect = function(writer) {
    writer.toDialect(this);
};

AttributeDeclaration.prototype.toEDialect = function(writer) {
    writer.append("define ");
    writer.append(this.name);
    writer.append(" as ");
    if(this.storable)
        writer.append("storable ");
    this.type.toDialect(writer);
    writer.append(" attribute");
    if (this.constraint != null)
        this.constraint.toDialect(writer);
    if (this.indexTypes != null) {
        writer.append(" with ");
        this.indexTypes.toDialect(writer, true);
        writer.append(" index");
    }
};

AttributeDeclaration.prototype.toODialect = function(writer) {
    if(this.storable)
        writer.append("storable ");
    writer.append("attribute ");
    writer.append(this.name);
    writer.append(" : ");
    this.type.toDialect(writer);
    if (this.constraint != null)
        this.constraint.toDialect(writer);
    if (this.indexTypes != null) {
        writer.append(" with index")
        if (this.indexTypes.length > 0) {
            writer.append(" (");
            this.indexTypes.toDialect(writer, false);
            writer.append(')');
        }
    }
    writer.append(';');
};

AttributeDeclaration.prototype.toMDialect = function(writer) {
    if(this.storable)
        writer.append("storable ");
    writer.append("attr ");
    writer.append(this.name);
    writer.append(" ( ");
    this.type.toDialect(writer);
    writer.append(" ):\n");
    writer.indent();
    if (this.constraint != null)
        this.constraint.toDialect(writer);
    if (this.indexTypes != null) {
        if (this.constraint != null)
            writer.newLine();
        writer.append("index (");
        this.indexTypes.toDialect(writer, false);
        writer.append(')');
    }
    if (this.constraint ==null && this.indexTypes ==null)
        writer.append("pass");
    writer.dedent();
};

AttributeDeclaration.prototype.register = function(context) {
	context.registerDeclaration(this);
};

AttributeDeclaration.prototype.check = function(context, isStart) {
	this.type.checkExists(context);
	return this.type;
};

AttributeDeclaration.prototype.checkValue = function(context, expression) {
    var value = expression.interpret(context);
	if(this.constraint==null) {
		return value;
	}
	this.constraint.checkValue(context, value);
	return value;
};

AttributeDeclaration.prototype.getAttributeInfo = function() {
    var collection = this.type instanceof ContainerType;
    var family = collection ? this.type.itemType.family : this.type.family;
    return new AttributeInfo(this.name, family, collection, this.indexTypes);
};

AttributeDeclaration.prototype.declare = function(transpiler) {
    this.type.declare(transpiler);
    if(this.constraint)
        this.constraint.declare(transpiler, this.name, this.type);
};

exports.AttributeDeclaration = AttributeDeclaration;

/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

var ContainerType = __webpack_require__(61).ContainerType;
var StrictSet = __webpack_require__(34).StrictSet;
var Identifier = __webpack_require__(0).Identifier;
var IntegerType = null;
var BooleanType = null;

exports.resolve = function() {
	IntegerType = __webpack_require__(2).IntegerType;
    BooleanType = __webpack_require__(5).BooleanType;
};

function RangeType(itemType) {
    ContainerType.call(this, new Identifier(itemType.name+"[..]"),itemType);
	return this;
}

RangeType.prototype = Object.create(ContainerType.prototype);
RangeType.prototype.constructor = RangeType;


RangeType.prototype.withItemType = function(itemType) {
    return new RangeType(itemType);
};



RangeType.prototype.checkItem = function(context, other) {
	if (other == IntegerType.instance) {
		return this.itemType;
	} else {
		return ContainerType.prototype.checkItem.call(this, context, other);
	}
};



RangeType.prototype.declareItem = function(transpiler, itemType, item) {
    // nothing to do
};


RangeType.prototype.transpileItem = function(transpiler, itemType, item) {
    transpiler.append(".item(");
    item.transpile(transpiler);
    transpiler.append(")");
};


RangeType.prototype.checkSlice = function(context) {
	return this;
};


RangeType.prototype.declareSlice = function(transpiler, first, last) {
    if(first) {
        first.declare(transpiler);
    }
    if(last) {
        last.declare(transpiler);
    }
};


RangeType.prototype.transpileSlice = function(transpiler, first, last) {
    transpiler.append(".slice1Based(");
    if(first) {
        first.transpile(transpiler);
    } else
        transpiler.append("null");
    if(last) {
        transpiler.append(",");
        last.transpile(transpiler);
    }
    transpiler.append(")");
};



RangeType.prototype.checkIterator = function(context, source) {
	return this.itemType;
};


RangeType.prototype.checkContainsAllOrAny = function(context, other) {
    return BooleanType.instance;
};


RangeType.prototype.declareContains = function(transpiler, other, container, item) {
    transpiler.require(StrictSet);
    container.declare(transpiler);
    item.declare(transpiler);
};


RangeType.prototype.transpileContains = function(transpiler, other, container, item) {
    container.transpile(transpiler);
    transpiler.append(".has(");
    item.transpile(transpiler);
    transpiler.append(")");
};


RangeType.prototype.declareContainsAllOrAny = function(transpiler, other, container, items) {
    transpiler.require(StrictSet);
    container.declare(transpiler);
    items.declare(transpiler);
};


RangeType.prototype.transpileContainsAll = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAll(");
    items.transpile(transpiler);
    transpiler.append(")");
};

RangeType.prototype.transpileContainsAny = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAny(");
    items.transpile(transpiler);
    transpiler.append(")");
};


exports.RangeType = RangeType;

/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

var Argument = __webpack_require__(114).Argument;

function AttributeArgument(id) {
	Argument.call(this, id);
	return this;
}

AttributeArgument.prototype = Object.create(Argument.prototype);
AttributeArgument.prototype.constructor = AttributeArgument;


AttributeArgument.prototype.toString = function() {
	return this.id.name;
};

AttributeArgument.prototype.getProto = function() {
	return this.id.name;
};

AttributeArgument.prototype.getTranspiledName =  function(context) {
    return this.id.name;
};


AttributeArgument.prototype.register = function(context) {
	context.registerValue(this, true);
    if(this.defaultExpression!=null) try {
        context.setValue(this.id, this.defaultExpression.interpret(context));
    } catch(error) {
        throw new SyntaxError("Unable to register default value: "+ this.defaultExpression.toString() + " for argument: " + this.name);
    }
};

AttributeArgument.prototype.check = function(context) {
	var actual = context.getRegisteredDeclaration(this.name);
	if(actual==null)
		throw new SyntaxError("Unknown attribute: \"" + this.name + "\"");
};

AttributeArgument.prototype.getType = function(context) {
	var named = context.getRegisteredDeclaration(this.name);
	return named.getType(context);
};

AttributeArgument.prototype.checkValue = function(context, value) {
	var actual = context.getRegisteredDeclaration(this.name);
	return actual.checkValue(context,value);
};

AttributeArgument.prototype.declare = function(transpiler) {
    var decl = transpiler.context.getRegisteredDeclaration(this.name);
    decl.declare(transpiler);
};

AttributeArgument.prototype.transpileCall = function(transpiler, expression) {
    var decl = transpiler.context.getRegisteredDeclaration(this.name);
    if(decl.constraint) {
        transpiler.append("$check_").append(this.name).append("(");
        Argument.prototype.transpileCall.call(this, transpiler, expression);
        transpiler.append(")");
    } else
        Argument.prototype.transpileCall.call(this, transpiler, expression);
};

AttributeArgument.prototype.equals = function(other) {
    return other === this || (other instanceof AttributeArgument && this.name === other.name);
};

exports.AttributeArgument = AttributeArgument;

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

var antlr4 = __webpack_require__(9);
var SyntaxError = __webpack_require__(32).SyntaxError;

function ProblemListener() {
    antlr4.error.ErrorListener.call(this);
    return this;
}

ProblemListener.prototype = Object.create(antlr4.error.ErrorListener.prototype);
ProblemListener.prototype.constructor = ProblemListener;

ProblemListener.prototype.syntaxError = function(recognizer, offendingSymbol, line, column, msg, e) {
    throw new SyntaxError(msg);
};

ProblemListener.prototype.reportDuplicate = function(name, declaration) {
    throw new SyntaxError("Duplicate name: " + name);
};

ProblemListener.prototype.reportUnknownAttribute = function(id) {
    throw new SyntaxError("Unknown attribute: " + id.name);
};

ProblemListener.prototype.reportUnknownCategory = function(id) {
    throw new SyntaxError("Unknown category: " + id.name);
};

ProblemListener.prototype.reportUnknownIdentifier = function(id) {
    throw new SyntaxError("Unknown identifier: " + id.name);
};

ProblemListener.prototype.reportUnknownMethod = function(id) {
    throw new SyntaxError("Unknown method: " + id.name);
};

ProblemListener.prototype.reportUnknownVariable = function(id) {
    throw new SyntaxError("Unknown variable: " + id.name);
};

ProblemListener.prototype.reportEmptyVariable = function(id) {
    throw new SyntaxError("Empty variable: " + id.name);
};

ProblemListener.prototype.reportNoMatchingPrototype = function(method) {
    throw new SyntaxError("No matching prototype for: " + method.toString());
};

ProblemListener.prototype.reportCannotIterate = function(source) {
    throw new SyntaxError("Cannot iterate over " + source.toString());
};

ProblemListener.prototype.reportNotAResource = function(method) {
    throw new SyntaxError("Not a resource");
};

ProblemListener.prototype.reportNotAResourceContext = function(method) {
    throw new SyntaxError("Not a resource context");
};

ProblemListener.prototype.reportInvalidCast = function(expression, target, actual) {
    throw new SyntaxError("Cannot cast " + actual.toString() + " to " + target.toString());
};

ProblemListener.prototype.reportExpectingBoolean = function(expression, type) {
    throw new SyntaxError("Cannot test " + expression.toString() + ", expected a Boolean got a " + type.toString());
};

ProblemListener.prototype.reportMissingClosingTag = function(opening) {
    throw new SyntaxError("Missing closing tag '&lt;/" + opening.id.name + ">'");
};

ProblemListener.prototype.reportInvalidClosingTag = function(closing, opening) {
    throw new SyntaxError("Invalid closing tag: </" + closing.name + ">, expected: </" + opening.name + ">");
};

ProblemListener.prototype.reportInvalidMember = function(section, name) {
    throw new SyntaxError("Invalid member '" + name + "' in " + this.name + " type");
};

ProblemListener.prototype.reportInvalidCopySource = function(section) {
    throw new SyntaxError("Invalid copy source");
};


ProblemListener.prototype.reportIncompatibleTypes = function(section, left, right) {
    throw new SyntaxError("Type " + left.name + " is not compatible with " + right.name);
};


exports.ProblemListener = ProblemListener;

/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

var Literal = __webpack_require__(24).Literal;
var TextValue = __webpack_require__(17).TextValue;
var TextType = __webpack_require__(6).TextType;

/*jshint evil:true*/
function unescape(text) {
	return eval(text);
}

function TextLiteral(text) {
	Literal.call(this, text, new TextValue(unescape(text)));
	return this;
}

TextLiteral.prototype = Object.create(Literal.prototype);
TextLiteral.prototype.constructor = TextLiteral;


TextLiteral.prototype.check = function(context) {
	return TextType.instance;
};


TextLiteral.prototype.declare = function(transpiler) {
    // nothing to do
};


TextLiteral.prototype.transpile = function(transpiler) {
    transpiler.append(this.text);
};

exports.TextLiteral = TextLiteral;


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

var BaseDeclaration = __webpack_require__(110).BaseDeclaration;
var ArgumentList = __webpack_require__(147).ArgumentList;
var CategoryType = null;
var ArgumentAssignmentList = __webpack_require__(39).ArgumentAssignmentList;
var ArgumentAssignment = __webpack_require__(40).ArgumentAssignment;
var ProblemListener = __webpack_require__(73).ProblemListener;


exports.resolve = function() {
	CategoryType = __webpack_require__(7).CategoryType;
}

function BaseMethodDeclaration(id, args, returnType) {
	BaseDeclaration.call(this, id);
    this.args = args || new ArgumentList();
	this.returnType = returnType || null;
    this.memberOf = null;
	this.closureOf = null;
    return this;
}

BaseMethodDeclaration.prototype  = Object.create(BaseDeclaration.prototype);
BaseMethodDeclaration.prototype.constructor = BaseMethodDeclaration;


BaseMethodDeclaration.prototype.getDeclarationType = function() {
    return "Method";
};

BaseMethodDeclaration.prototype.getSignature = function(context) {
	var s = [];
    this.args.map(function(arg) {
        s.push(arg.getProto());
    });
    return "(" + s.join(", ") + ")";
};

BaseMethodDeclaration.prototype.getProto = function(context) {
    return this.args.map(function(arg) {
        return arg.getProto(context);
    }).join("/");
};

BaseMethodDeclaration.prototype.getTranspiledName = function(context) {
    // if this is a template instance, name is already transpiled
    if(this.name.indexOf("$")>0)
    	return this.name;
    else
		return [this.name].concat(this.args.map(function(arg) { return arg.getTranspiledName(context); })).join("$");
};


BaseMethodDeclaration.prototype.transpileProlog = function(transpiler) {
    if (this.memberOf)
        transpiler.append(this.memberOf.name).append(".prototype.").append(this.getTranspiledName(transpiler.context)).append(" = function (");
    else
        transpiler.append("function ").append(this.getTranspiledName(transpiler.context)).append(" (");
    this.args.transpile(transpiler);
    transpiler.append(") {").indent();
};


BaseMethodDeclaration.prototype.transpileEpilog = function(transpiler) {
    transpiler.dedent().append("}");
    if(this.memberOf)
        transpiler.append(";");
    transpiler.newLine();
};


BaseMethodDeclaration.prototype.unregister = function(context) {
    context.unregisterMethodDeclaration (this, this.getProto(context));
};


BaseMethodDeclaration.prototype.register = function(context) {
	context.registerMethodDeclaration(this);
};


BaseMethodDeclaration.prototype.registerArguments = function(context) {
	if(this.args!=null) {
		this.args.register(context);
	}
};


BaseMethodDeclaration.prototype.declareArguments = function(transpiler) {
    if(this.args!=null) {
        this.args.declare(transpiler);
    }
};

BaseMethodDeclaration.prototype.isAssignableTo = function(context, assignments, checkInstance, allowDerived) {
	var listener = context.problemListener;
	try {
        context.problemListener = new ProblemListener();
		var local = context.newLocalContext();
		this.registerArguments(local);
		var assignmentsList = new ArgumentAssignmentList(assignments);
		for(var i=0;i<this.args.length;i++) {
			var argument = this.args[i];
			var idx = assignmentsList.findIndex(argument.id.name);
            var assignment = idx>=0 ? assignmentsList[idx] : null;
            if(assignment==null) { // missing argument
                if(argument.defaultExpression!=null)
                    assignment = new ArgumentAssignment(argument, argument.defaultExpression);
				else
                    return false;
			}
			if(!assignment.isAssignableToArgument(local, argument, this, checkInstance, allowDerived)) {
				return false;
			}
			if(idx>=0)
                assignmentsList.remove(idx);
		}
		return assignmentsList.length===0;
	} catch (e) {
		if(e instanceof SyntaxError) {
			return false;
		} else {
			throw e;
		}
	} finally {
        context.problemListener = listener;
	}
};



BaseMethodDeclaration.prototype.isEligibleAsMain = function() {
	return false;
};

exports.BaseMethodDeclaration = BaseMethodDeclaration;




/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;

function ExpressionValue(type, value) {
	Value.call(this, type);
	this.value = value;
    // make this sliceable
    this.sliceable = value.slice ? value : null;
	return this;
}

ExpressionValue.prototype = Object.create(Value.prototype);
ExpressionValue.prototype.constructor = ExpressionValue;

ExpressionValue.prototype.check = function(context) {
	return this.type;
};

ExpressionValue.prototype.interpret = function(context) {
	if(this.value.interpret) {
		return this.value.interpret(context);
	} else {
		return this.value;
	}
};

ExpressionValue.prototype.declare = function(transpiler) {
    if(this.value.declare) {
        return this.value.declare(transpiler);
    }
};

ExpressionValue.prototype.transpile = function(transpiler) {
    if (this.value.transpile) {
        return this.value.transpile(transpiler);
    }
    ;
};


ExpressionValue.prototype.toString = function() {
	return this.value.toString();
};

ExpressionValue.prototype.toDialect = function(dialect) {
	return this.value.toDialect(dialect);
};

exports.ExpressionValue = ExpressionValue;


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

var BaseDeclaration = __webpack_require__(110).BaseDeclaration;
var EnumeratedNativeType = __webpack_require__(247).EnumeratedNativeType;
var List = __webpack_require__(29).List;

function EnumeratedNativeDeclaration(id, derivedFrom, symbols) {
	BaseDeclaration.call(this, id);
	this.type = new EnumeratedNativeType(id, derivedFrom);
	this.symbols = symbols || [];
    this.symbols.forEach(function (symbol) {
        symbol.type = this.type;
    }, this);
	return this;
}

EnumeratedNativeDeclaration.prototype = Object.create(BaseDeclaration.prototype);
EnumeratedNativeDeclaration.prototype.constructor = EnumeratedNativeDeclaration;


EnumeratedNativeDeclaration.prototype.getDeclarationType = function() {
    return "Enumerated";
};


EnumeratedNativeDeclaration.prototype.unregister = function(context) {
    context.unregisterDeclaration (this);
    this.symbols.forEach(function(symbol) {
        symbol.unregister(context);
    });
};

EnumeratedNativeDeclaration.prototype.toDialect = function(writer) {
    writer.toDialect(this);
};


EnumeratedNativeDeclaration.prototype.toMDialect = function(writer) {
    writer.append("enum ");
    writer.append(this.name);
    writer.append('(');
    this.type.derivedFrom.toDialect(writer);
    writer.append("):\n");
    writer.indent();
    this.symbols.forEach(function(symbol) {
        symbol.toDialect(writer);
        writer.append("\n");
    });
    writer.dedent();
}

EnumeratedNativeDeclaration.prototype.toODialect = function(writer) {
    writer.append("enumerated ");
    writer.append(this.name);
    writer.append('(');
    this.type.derivedFrom.toDialect(writer);
    writer.append(") {\n");
    writer.indent();
    this.symbols.forEach(function(symbol) {
        symbol.toDialect(writer);
        writer.append(";\n");
    });
    writer.dedent();
    writer.append("}\n");
}

EnumeratedNativeDeclaration.prototype.toEDialect = function(writer) {
    writer.append("define ");
    writer.append(this.name);
    writer.append(" as enumerated ");
    this.type.derivedFrom.toDialect(writer);
    writer.append(" with symbols:\n");
    writer.indent();
    this.symbols.forEach(function(symbol) {
        symbol.toDialect(writer);
        writer.append("\n");
    });
    writer.dedent();
};

EnumeratedNativeDeclaration.prototype.register = function(context) {
	context.registerDeclaration(this);
    this.symbols.forEach(function(symbol) {
		symbol.register(context);
	});
};

EnumeratedNativeDeclaration.prototype.check = function(context, isStart) {
    this.symbols.forEach(function(symbol) {
		symbol.check(context);
	});
	return this.type;
};

EnumeratedNativeDeclaration.prototype.transpile = function(transpiler) {
    transpiler.append("function " + this.name + "(name, value) { this.name = name; this.value = value; return this; };");
    transpiler.newLine();
    transpiler.append(this.name).append(".prototype.toString = function() { return this.name; };");
    transpiler.newLine();
    this.symbols.forEach(function(symbol) {symbol.initialize(transpiler);});
    var names = this.symbols.map(function(symbol) { return symbol.name; });
    transpiler.append(this.name).append(".symbols = new List(false, [").append(names.join(", ")).append("]);");
};

EnumeratedNativeDeclaration.prototype.getType = function(context) {
	return this.type;
};

EnumeratedNativeDeclaration.prototype.declare = function(transpiler) {
    transpiler.require(List);
};


exports.EnumeratedNativeDeclaration = EnumeratedNativeDeclaration;


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

var BaseMethodDeclaration = __webpack_require__(75).BaseMethodDeclaration;
var VoidType = __webpack_require__(4).VoidType;
var DictionaryType = __webpack_require__(99).DictionaryType;
var TextType = __webpack_require__(6).TextType;
var CodeArgument = __webpack_require__(116).CodeArgument;
var CategoryArgument = __webpack_require__(95).CategoryArgument;
var StatementList = __webpack_require__(261).StatementList;
var DeclarationStatement = __webpack_require__(191).DeclarationStatement;

function ConcreteMethodDeclaration(id, args, returnType, statements) {
	BaseMethodDeclaration.call(this, id, args, returnType);
	this.statements = statements || new StatementList();
	this.declarationOf = null;
    this.statements.forEach(function(stmt) {
        if(stmt instanceof DeclarationStatement)
            stmt.declaration.closureOf = this;
    }, this);
	return this;
}

ConcreteMethodDeclaration.prototype = Object.create(BaseMethodDeclaration.prototype);
ConcreteMethodDeclaration.prototype.constructor = ConcreteMethodDeclaration;

ConcreteMethodDeclaration.prototype.checkMember = function(declaration, context) {
    context = context.newInstanceContext(null, declaration.getType(context), false)
    return this.checkChild(context);
};

ConcreteMethodDeclaration.prototype.check = function(context, isStart) {
	if(this.canBeChecked(context)) {
		return this.fullCheck(context, isStart);
	} else {
		return VoidType.instance;
	}
};

ConcreteMethodDeclaration.prototype.canBeChecked = function(context) {
	if(context.isGlobalContext()) {
		return !this.mustBeCheckedInCallContext(context);
	} else {
		return true;
	}
};

ConcreteMethodDeclaration.prototype.mustBeCheckedInCallContext = function(context) {
	// if at least one argument is 'Code'
	if(this.args===null) {
		return false;
	}
	for(var i=0;i<this.args.length;i++) {
		if(this.args[i] instanceof CodeArgument) {
			return true;
		}
	}
	return false;
};

ConcreteMethodDeclaration.prototype.fullCheck = function(context, isStart) {
	if(isStart) {
		context = context.newLocalContext();
		this.registerArguments(context);
	}
	if(this.args!==null) {
		this.args.check(context);
	}
	return this.statements.check(context, this.returnType);
};

ConcreteMethodDeclaration.prototype.checkChild = function(context) {
	if(this.args!=null) {
		this.args.check(context);
	}
	var child = context.newChildContext();
	this.registerArguments(child);
	return this.statements.check(child, this.returnType);
};

ConcreteMethodDeclaration.prototype.interpret = function(context) {
	context.enterMethod(this);
	try {
		return this.statements.interpret(context);
	} finally {
		context.leaveMethod(this);
	}
};

ConcreteMethodDeclaration.prototype.toDialect = function(writer) {
    if(writer.context.isGlobalContext())
        writer = writer.newLocalWriter();
    this.registerArguments(writer.context);
    writer.toDialect(this);
};


ConcreteMethodDeclaration.prototype.isEligibleAsMain = function () {
    if(this.args.length==0)
        return true;
    else if(this.args.length==1) {
        var arg = this.args[0];
        if( arg instanceof CategoryArgument
            && arg.type instanceof DictionaryType
            && arg.type.itemType==TextType.instance )
                return true;
    }
    return false;
};


ConcreteMethodDeclaration.prototype.toMDialect = function(writer) {
    writer.append("def ");
    writer.append(this.name);
    writer.append(" (");
    this.args.toDialect(writer);
    writer.append(")");
    if(this.returnType!=null && this.returnType!=VoidType.instance) {
        writer.append("->");
        this.returnType.toDialect(writer);
    }
    writer.append(":\n");
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
};

ConcreteMethodDeclaration.prototype.toEDialect = function(writer) {
    writer.append("define ");
    writer.append(this.name);
    writer.append(" as method ");
    this.args.toDialect(writer);
    if(this.returnType!=null && this.returnType!=VoidType.instance) {
        writer.append("returning ");
        this.returnType.toDialect(writer);
        writer.append(" ");
    }
    writer.append("doing:\n");
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
};

ConcreteMethodDeclaration.prototype.toODialect = function(writer) {
    if(this.returnType!=null && this.returnType!=VoidType.instance) {
        this.returnType.toDialect(writer);
        writer.append(" ");
    }
    writer.append("method ");
    writer.append(this.name);
    writer.append(" (");
    this.args.toDialect(writer);
    writer.append(") {\n");
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
    writer.append("}\n");
};

ConcreteMethodDeclaration.prototype.declare = function(transpiler) {
    if(this.declaring)
        return;
    this.declaring = true;
    try {
        if (!this.memberOf) {
            transpiler = transpiler.newLocalTranspiler();
            transpiler.declare(this);
            this.declareArguments(transpiler);
        }
        if(this.returnType)
            this.returnType.declare(transpiler);
        this.registerArguments(transpiler.context);
        this.statements.declare(transpiler);
    } finally {
        this.declaring = false;
    }
};


ConcreteMethodDeclaration.prototype.transpile = function(transpiler) {
    this.registerArguments(transpiler.context);
    this.registerCodeArguments(transpiler.context);
    this.transpileProlog(transpiler);
    this.statements.transpile(transpiler);
    this.transpileEpilog(transpiler);
};


ConcreteMethodDeclaration.prototype.declareChild = function(transpiler) {
    this.declareArguments(transpiler);
    transpiler = transpiler.newChildTranspiler();
    this.registerArguments(transpiler.context);
    return this.statements.declare(transpiler);
};



ConcreteMethodDeclaration.prototype.registerCodeArguments = function(context) {
    if(!this.codeArguments)
        return;
    Object.getOwnPropertyNames(this.codeArguments).forEach(function(name) {
        var arg = this.codeArguments[name];
        context.setValue(arg.id, arg.value);
    }, this);
};

ConcreteMethodDeclaration.prototype.fullDeclare = function(transpiler, id) {
    var declaration = new ConcreteMethodDeclaration(id, this.args, this.returnType, this.statements);
    declaration.memberOf = this.memberOf;
    transpiler.declare(declaration);
    this.statements.declare(transpiler);
    // remember code arguments
    declaration.codeArguments = {};
    this.args.filter(function(arg) {
        return arg instanceof CodeArgument;
    }).forEach(function(arg) {
        declaration.codeArguments[arg.name] = { id: arg.id, value: transpiler.context.getValue(arg.id) };
    });
};


exports.ConcreteMethodDeclaration = ConcreteMethodDeclaration;


/***/ }),
/* 79 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a duplex stream is just a stream that is both readable and writable.
// Since JS doesn't have multiple prototypal inheritance, this class
// prototypally inherits from Readable, and then parasitically from
// Writable.



/*<replacement>*/

var processNextTick = __webpack_require__(151);
/*</replacement>*/

/*<replacement>*/
var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) {
    keys.push(key);
  }return keys;
};
/*</replacement>*/

module.exports = Duplex;

/*<replacement>*/
var util = __webpack_require__(119);
util.inherits = __webpack_require__(103);
/*</replacement>*/

var Readable = __webpack_require__(267);
var Writable = __webpack_require__(197);

util.inherits(Duplex, Readable);

var keys = objectKeys(Writable.prototype);
for (var v = 0; v < keys.length; v++) {
  var method = keys[v];
  if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
}

function Duplex(options) {
  if (!(this instanceof Duplex)) return new Duplex(options);

  Readable.call(this, options);
  Writable.call(this, options);

  if (options && options.readable === false) this.readable = false;

  if (options && options.writable === false) this.writable = false;

  this.allowHalfOpen = true;
  if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;

  this.once('end', onend);
}

// the no-half-open enforcer
function onend() {
  // if we allow half-open state, or if the writable side ended,
  // then we're ok.
  if (this.allowHalfOpen || this._writableState.ended) return;

  // no more data can be written.
  // But allow more writes to happen in this tick.
  processNextTick(onEndNT, this);
}

function onEndNT(self) {
  self.end();
}

Object.defineProperty(Duplex.prototype, 'destroyed', {
  get: function () {
    if (this._readableState === undefined || this._writableState === undefined) {
      return false;
    }
    return this._readableState.destroyed && this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (this._readableState === undefined || this._writableState === undefined) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._readableState.destroyed = value;
    this._writableState.destroyed = value;
  }
});

Duplex.prototype._destroy = function (err, cb) {
  this.push(null);
  this.end();

  processNextTick(cb, err);
};

function forEach(xs, f) {
  for (var i = 0, l = xs.length; i < l; i++) {
    f(xs[i], i);
  }
}

/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* global Promise */


// load the global object first:
// - it should be better integrated in the system (unhandledRejection in node)
// - the environment may have a custom Promise implementation (see zone.js)
var ES6Promise = null;
if (typeof Promise !== "undefined") {
    ES6Promise = Promise;
} else {
    ES6Promise = __webpack_require__(399);
}
var delay = __webpack_require__(15).delay;

/**
 * Let the user use/change some implementations.
 */
module.exports = {
    Promise: ES6Promise,
    delay: delay
};


/***/ }),
/* 82 */
/***/ (function(module, exports) {

// borrowed from http://www.2ality.com/2011/11/improving-typeof.html
exports.getTypeName = function(value) {
    if (value === null) {
        return "null";
    }
    var t = typeof(value);
    switch(t) {
        case "function":
            if(value.name)
                return value.name;
            // don't break
        case "object":
            if (value.constructor) {
                if (value.constructor.name) {
                    return value.constructor.name;
                } else {
                    // Internet Explorer
                    // Anonymous functions are stringified as follows: 'function () {}'
                    // => the regex below does not match
                    var match = value.constructor.toString().match(/^function (.+)\(.*$/);
                    if (match) {
                        return match[1];
                    }
                }
            }
            // fallback, for nameless constructors etc.
            return Object.prototype.toString.call(value).match(/^\[object (.+)\]$/)[1];
        default:
            return t;
    }
}




/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

var MissingType = __webpack_require__(56).MissingType;
var NullValue = __webpack_require__(21).NullValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var DecimalValue = __webpack_require__(33).DecimalValue;
var TextValue = __webpack_require__(17).TextValue;

convertFromJavaScript = function(value) {
    if(value==null) {
        return NullValue.instance;
    } else if(typeof(value)=='string') {
        return new TextValue(value);
    } else if(typeof(value)=='number') {
        if(Number.isInteger(value))
            return new IntegerValue(value);
        else
            return new DecimalValue(value);
    } else {
        throw "Not implemented yet in convertFromJavaScript:" + typeof(value);
    }
};


inferExpressionsType = function(context, expressions) {
    if (expressions.length == 0)
        return MissingType.instance;
    var types = expressions.map(function(e) { return e.check(context); });
    return inferElementType(context, types);
}

inferElementType = function(context, types) {
    if (types.length == 0)
        return MissingType.instance;
    var lastType = null;
    for (var i = 0; i < types.length; i++) {
        var elemType = types[i];
        if (lastType == null) {
            lastType = elemType;
        } else if (!lastType.equals(elemType)) {
            if (lastType.isAssignableFrom(context, elemType)) {
                ; // lastType is less specific
            } else if (elemType.isAssignableFrom(context, lastType)) {
                lastType = elemType; // elemType is less specific
            } else {
                var common = inferCommonRootType(context, lastType, elemType);
                if(common!=null)
                    lastType = common;
                else
                    throw new SyntaxError("Incompatible types: " + elemType.toString() + " and " + lastType.toString());
            }
        }
    }
    return lastType;
};


function inferCommonRootType(context, type1, type2) {
    var CategoryType = __webpack_require__(7).CategoryType;
    if ((type1 instanceof CategoryType) && (type2 instanceof CategoryType))
        return inferCommonCategoryType(context, type1, type2, true);
    else
        return null;
}


function inferCommonCategoryType(context, type1, type2, trySwap) {
    var CategoryType = __webpack_require__(7).CategoryType;
    var CategoryDeclaration = __webpack_require__(45).CategoryDeclaration;
    var decl1 = context.getRegisteredDeclaration(type1.id.name);
    if (decl1.derivedFrom != null) {
        for (var i = 0; i < decl1.derivedFrom.length; i++) {
            var parentType = new CategoryType(decl1.derivedFrom[i]);
            if (parentType.isAssignableFrom(context, type2))
                return parentType;
        }
        // climb up the tree
        for (var i = 0; i < decl1.derivedFrom.length; i++) {
            var parentType = new CategoryType(decl1.derivedFrom[i]);
            var commonType = inferCommonCategoryType(context, parentType, type2, false)
            if (commonType != null)
                return commonType;
        }
    }
    if (trySwap)
        return inferCommonCategoryType(context, type2, type1, false);
    else
        return null;
}


exports.convertFromJavaScript = convertFromJavaScript;
exports.inferExpressionsType = inferExpressionsType;
exports.inferElementType = inferElementType;

/***/ }),
/* 84 */
/***/ (function(module, exports) {

function MatchOp(name) {
    this.name = name;
    return this;
};

MatchOp.prototype.toString = function() {
    return this.name;
};

MatchOp.prototype.toTranspiled = function() {
    return "new MatchOp('" + this.name + "')";
};

MatchOp.EQUALS = new MatchOp("EQUALS");
MatchOp.ROUGHLY = new MatchOp("ROUGHLY");
MatchOp.CONTAINS = new MatchOp("CONTAINS");
MatchOp.HAS = new MatchOp("HAS");
MatchOp.IN = new MatchOp("IN");
MatchOp.CONTAINED = new MatchOp("CONTAINED");
MatchOp.GREATER = new MatchOp("GREATER");
MatchOp.LESSER = new MatchOp("LESSER");

exports.MatchOp = MatchOp;

/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

var BaseValueList = __webpack_require__(186).BaseValueList;
var TupleType = null;
var SetValue = null;

exports.resolve = function() {
    TupleType = __webpack_require__(124).TupleType;
    SetValue = __webpack_require__(54).SetValue;
};

function TupleValue(items, item, mutable) {
	BaseValueList.call(this, TupleType.instance, items, item, mutable);
	return this;
}

TupleValue.prototype = Object.create(BaseValueList.prototype);
TupleValue.prototype.constructor = TupleValue;

TupleValue.prototype.toString = function() {
	return "(" + this.items.join(", ") + ")";
};

TupleValue.prototype.toDialect = function(writer) {
    writer.append('(');
    BaseValueList.prototype.toDialect.call(this, writer);
    writer.append(')');
};

/*

@Override
protected TupleValue newInstance(List<Object> items) {
	return new TupleValue(items);
}

*/

TupleValue.prototype.Add = function(context, value) {
	if (value instanceof BaseValueList) {
        var items = this.items.concat(value.items);
        return new TupleValue(items);
    } else if(value instanceof SetValue) {
        var items = Array.from(value.items.set.values());
        items = this.items.concat(items);
        return new TupleValue(items);
    } else {
		throw new SyntaxError("Illegal: Tuple + " + typeof(value));
	}
};

TupleValue.prototype.filter = function(context, itemId, filter) {
    var result = new TupleValue();
    var iter = this.getIterator(context);
    while(iter.hasNext()) {
        var o = iter.next();
        context.setValue(itemId, o);
        var test = filter.interpret(context);
        if(!(test instanceof Bool)) {
            throw new InternalError("Illegal test result: " + test);
        }
        if(test.value) {
            result.add(o);
        }
    }
    return result;
}

exports.TupleValue = TupleValue;

/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var IntegerType = __webpack_require__(2).IntegerType;
var Identifier = __webpack_require__(0).Identifier;
var Period = __webpack_require__(104).Period;
var PeriodValue = __webpack_require__(87).PeriodValue;

function PeriodType()  {
	NativeType.call(this, new Identifier("Period"));
	return this;
}

PeriodType.prototype = Object.create(NativeType.prototype);
PeriodType.prototype.constructor = PeriodType;

PeriodType.instance = new PeriodType();

PeriodType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
    if(value instanceof Period)
        return new PeriodValue(value);
    else
        return NativeType.prototype.convertJavaScriptValueToPromptoValue.call(this, context, value, returnType);
};


PeriodType.prototype.checkAdd = function(context, other, tryReverse) {
	if(other instanceof PeriodType) {
		return this;
	} else {
		return NativeType.prototype.checkAdd(this, context, other, tryReverse);
	}
};


PeriodType.prototype.declare = function(transpiler) {
    transpiler.register(Period);
};


PeriodType.prototype.transpile = function(transpiler) {
    transpiler.append('Period')
};


PeriodType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if(other === PeriodType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else {
        return NativeType.prototype.declareAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};


PeriodType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if(other === PeriodType.instance) {
        left.transpile(transpiler);
        transpiler.append(".add(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else {
        return NativeType.prototype.transpileAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};



PeriodType.prototype.checkSubtract = function(context, other) {
    if(other === PeriodType.instance) {
		return this;
	} else {
		return NativeType.prototype.checkSubtract(this, context, other);
	}
};


PeriodType.prototype.declareSubtract = function(transpiler, other, left, right) {
    if(other === PeriodType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareSubtract.call(this, transpiler, other, left, right);
};


PeriodType.prototype.transpileSubtract = function(transpiler, other, left, right) {
    if(other === PeriodType.instance) {
        left.transpile(transpiler);
        transpiler.append(".subtract(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileSubtract.call(this, transpiler, other, left, right);
};

PeriodType.prototype.checkMultiply = function(context, other, tryReverse) {
	if(other === IntegerType.instance) {
		return this;
	} else {
		return NativeType.prototype.checkMultiply(this, transpiler, other, tryReverse);
	}
};


PeriodType.prototype.declareMultiply = function(transpiler, other, tryReverse, left, right) {
    if(other === IntegerType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareMultiply.call(this, transpiler, other, tryReverse, left, right);
};



PeriodType.prototype.transpileMultiply = function(transpiler, other, tryReverse, left, right) {
    if(other === IntegerType.instance) {
        left.transpile(transpiler);
        transpiler.append(".multiply(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileMultiply.call(this, transpiler, other, tryReverse, left, right);
};

PeriodType.prototype.checkMinus = function(context) {
	return this;
};



PeriodType.prototype.declareMinus = function(transpiler, value) {
    // nothing to do
};

PeriodType.prototype.transpileMinus = function(transpiler, value) {
    value.transpile(transpiler);
    transpiler.append(".minus()");
};


exports.PeriodType = PeriodType;


/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var IntegerValue = __webpack_require__(3).IntegerValue;
var PeriodType = null;

exports.resolve = function() {
    PeriodType = __webpack_require__(86).PeriodType;
};


function PeriodValue(value) {
    Value.call(this, PeriodType.instance);
    this.value = value;
    ["years", "months", "weeks", "days", "hours", "minutes", "seconds", "millis"].forEach(function(name) {
        Object.defineProperty(this, name, {
            get: function () {
                return this.value[name];
            }
        });
    }, this)
    return this;
}

PeriodValue.prototype = Object.create(Value.prototype);
PeriodValue.prototype.constructor = PeriodValue;



PeriodValue.prototype.Add = function(context, value) {
    if (value instanceof PeriodValue) {
        return new PeriodValue(this.value.add(value.value));
    } else {
        throw new SyntaxError("Illegal: PeriodValue + " + typeof(value));
    }
};

PeriodValue.prototype.Minus = function(context) {
    return new PeriodValue(this.value.minus());
};

PeriodValue.prototype.Subtract = function(context, value) {
    if (value instanceof PeriodValue) {
        return new PeriodValue(this.value.subtract(value.value));
    } else {
        throw new SyntaxError("Illegal: PeriodValue + " + typeof(value));
    }
};


PeriodValue.prototype.Multiply = function(context, value) {
    if (value instanceof IntegerValue) {
        return new PeriodValue(this.value.multiply(value.value));
    } else {
        throw new SyntaxError("Illegal: PeriodValue * " + typeof(value));
    }
};

/*
 override
 public Object ConvertTo(Type type)
 {
 return this; // TODO convert to TimeSpan
 }

*/

PeriodValue.prototype.toString = function() {
    return this.value.toString();
};

PeriodValue.prototype.equals = function(obj) {
    if (obj instanceof PeriodValue) {
        return this.value.equals(obj.value);
    } else {
        return false;
    }
};

/*

 override
 public int GetHashCode()
 {
 return ToString().GetHashCode();
 }


 }
 }


 */
/*
 public static final PeriodValue ZERO = new PeriodValue(0, 0, 0, 0, 0, 0, 0, 0);

 org.joda.time.PeriodValue value;

 public PeriodValue(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis)
 {
 value = new org.joda.time.PeriodValue(years, months, weeks, days, hours, minutes, seconds, millis);
 }

 public PeriodValue(org.joda.time.PeriodValue value)
 {
 this.value = value;
 }

 public org.joda.time.PeriodValue getValue() {
 return value;
 }


 @Override
 public IValue Add(Context context, IValue value) throws PromptoError
 {
 if (value instanceof PeriodValue)
 return this.plus((PeriodValue)value);
 else
 throw new SyntaxError("Illegal: PeriodValue + " + value.getClass().getSimpleName());
 }

 @Override
 public IValue Subtract(Context context, IValue value) throws PromptoError
 {
 if (value instanceof PeriodValue)
 return this.minus((PeriodValue)value);
 else
 throw new SyntaxError("Illegal: PeriodValue - " + value.getClass().getSimpleName());
 }

 @Override
 public IValue Multiply(Context context, IValue value) throws PromptoError
 {
 if (value instanceof IntegerValue)
 {
 int count = (int)((IntegerValue)value).IntegerValue();
 if (count < 0)
 throw new SyntaxError("Negative repeat count:" + count);
 if (count == 0)
 return PeriodValue.ZERO;
 if (count == 1)
 return this;
 return this.times(count);
 }
 else
 throw new SyntaxError("Illegal: PeriodValue * " + value.getClass().getSimpleName());
 }

 @Override
 public Object ConvertTo(Class<?> type)
 {
 return value;
 }

 public PeriodValue minus(PeriodValue period)
 {
 return new PeriodValue( this.value.minus(period.value));
 }



 public PeriodValue plus(PeriodValue period)
 {
 return new PeriodValue(this.value.plus(period.value));
 }

 public PeriodValue times(int count)
 {
 return new PeriodValue(
 this.value.getYears() * count,
 this.value.getMonths() * count,
 this.value.getWeeks() * count,
 this.value.getDays() * count,
 this.value.getHours() * count,
 this.value.getMinutes() * count,
 this.value.getSeconds() * count,
 this.value.getMillis() * count);
 }

 @Override
 public String toString()
 {
 return value.toString();
 }

 @Override
 public boolean equals(Object obj)
 {
 if (obj instanceof PeriodValue)
 return this.value.equals(((PeriodValue)obj).value);
 else
 return false;
 }

 @Override
 public int hashCode()
 {
 return value.hashCode();
 }


 }
 */

exports.PeriodValue = PeriodValue;


/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
//

// A tree structure used to record the semantic context in which
//  an ATN configuration is valid.  It's either a single predicate,
//  a conjunction {@code p1&&p2}, or a sum of products {@code p1||p2}.
//
//  <p>I have scoped the {@link AND}, {@link OR}, and {@link Predicate} subclasses of
//  {@link SemanticContext} within the scope of this outer class.</p>
//

var Set = __webpack_require__(13).Set;
var Hash = __webpack_require__(13).Hash;

function SemanticContext() {
	return this;
}

SemanticContext.prototype.hashCode = function() {
    var hash = new Hash();
    this.updateHashCode(hash);
    return hash.finish();
};

// For context independent predicates, we evaluate them without a local
// context (i.e., null context). That way, we can evaluate them without
// having to create proper rule-specific context during prediction (as
// opposed to the parser, which creates them naturally). In a practical
// sense, this avoids a cast exception from RuleContext to myruleContext.
//
// <p>For context dependent predicates, we must pass in a local context so that
// references such as $arg evaluate properly as _localctx.arg. We only
// capture context dependent predicates in the context in which we begin
// prediction, so we passed in the outer context here in case of context
// dependent predicate evaluation.</p>
//
SemanticContext.prototype.evaluate = function(parser, outerContext) {
};

//
// Evaluate the precedence predicates for the context and reduce the result.
//
// @param parser The parser instance.
// @param outerContext The current parser context object.
// @return The simplified semantic context after precedence predicates are
// evaluated, which will be one of the following values.
// <ul>
// <li>{@link //NONE}: if the predicate simplifies to {@code true} after
// precedence predicates are evaluated.</li>
// <li>{@code null}: if the predicate simplifies to {@code false} after
// precedence predicates are evaluated.</li>
// <li>{@code this}: if the semantic context is not changed as a result of
// precedence predicate evaluation.</li>
// <li>A non-{@code null} {@link SemanticContext}: the new simplified
// semantic context after precedence predicates are evaluated.</li>
// </ul>
//
SemanticContext.prototype.evalPrecedence = function(parser, outerContext) {
	return this;
};

SemanticContext.andContext = function(a, b) {
	if (a === null || a === SemanticContext.NONE) {
		return b;
	}
	if (b === null || b === SemanticContext.NONE) {
		return a;
	}
	var result = new AND(a, b);
	if (result.opnds.length === 1) {
		return result.opnds[0];
	} else {
		return result;
	}
};

SemanticContext.orContext = function(a, b) {
	if (a === null) {
		return b;
	}
	if (b === null) {
		return a;
	}
	if (a === SemanticContext.NONE || b === SemanticContext.NONE) {
		return SemanticContext.NONE;
	}
	var result = new OR(a, b);
	if (result.opnds.length === 1) {
		return result.opnds[0];
	} else {
		return result;
	}
};

function Predicate(ruleIndex, predIndex, isCtxDependent) {
	SemanticContext.call(this);
	this.ruleIndex = ruleIndex === undefined ? -1 : ruleIndex;
	this.predIndex = predIndex === undefined ? -1 : predIndex;
	this.isCtxDependent = isCtxDependent === undefined ? false : isCtxDependent; // e.g., $i ref in pred
	return this;
}

Predicate.prototype = Object.create(SemanticContext.prototype);
Predicate.prototype.constructor = Predicate;

//The default {@link SemanticContext}, which is semantically equivalent to
//a predicate of the form {@code {true}?}.
//
SemanticContext.NONE = new Predicate();


Predicate.prototype.evaluate = function(parser, outerContext) {
	var localctx = this.isCtxDependent ? outerContext : null;
	return parser.sempred(localctx, this.ruleIndex, this.predIndex);
};

Predicate.prototype.updateHashCode = function(hash) {
	hash.update(this.ruleIndex, this.predIndex, this.isCtxDependent);
};

Predicate.prototype.equals = function(other) {
	if (this === other) {
		return true;
	} else if (!(other instanceof Predicate)) {
		return false;
	} else {
		return this.ruleIndex === other.ruleIndex &&
				this.predIndex === other.predIndex &&
				this.isCtxDependent === other.isCtxDependent;
	}
};

Predicate.prototype.toString = function() {
	return "{" + this.ruleIndex + ":" + this.predIndex + "}?";
};

function PrecedencePredicate(precedence) {
	SemanticContext.call(this);
	this.precedence = precedence === undefined ? 0 : precedence;
}

PrecedencePredicate.prototype = Object.create(SemanticContext.prototype);
PrecedencePredicate.prototype.constructor = PrecedencePredicate;

PrecedencePredicate.prototype.evaluate = function(parser, outerContext) {
	return parser.precpred(outerContext, this.precedence);
};

PrecedencePredicate.prototype.evalPrecedence = function(parser, outerContext) {
	if (parser.precpred(outerContext, this.precedence)) {
		return SemanticContext.NONE;
	} else {
		return null;
	}
};

PrecedencePredicate.prototype.compareTo = function(other) {
	return this.precedence - other.precedence;
};

PrecedencePredicate.prototype.updateHashCode = function(hash) {
    hash.update(31);
};

PrecedencePredicate.prototype.equals = function(other) {
	if (this === other) {
		return true;
	} else if (!(other instanceof PrecedencePredicate)) {
		return false;
	} else {
		return this.precedence === other.precedence;
	}
};

PrecedencePredicate.prototype.toString = function() {
	return "{"+this.precedence+">=prec}?";
};



PrecedencePredicate.filterPrecedencePredicates = function(set) {
	var result = [];
	set.values().map( function(context) {
		if (context instanceof PrecedencePredicate) {
			result.push(context);
		}
	});
	return result;
};


// A semantic context which is true whenever none of the contained contexts
// is false.
//
function AND(a, b) {
	SemanticContext.call(this);
	var operands = new Set();
	if (a instanceof AND) {
		a.opnds.map(function(o) {
			operands.add(o);
		});
	} else {
		operands.add(a);
	}
	if (b instanceof AND) {
		b.opnds.map(function(o) {
			operands.add(o);
		});
	} else {
		operands.add(b);
	}
	var precedencePredicates = PrecedencePredicate.filterPrecedencePredicates(operands);
	if (precedencePredicates.length > 0) {
		// interested in the transition with the lowest precedence
		var reduced = null;
		precedencePredicates.map( function(p) {
			if(reduced===null || p.precedence<reduced.precedence) {
				reduced = p;
			}
		});
		operands.add(reduced);
	}
	this.opnds = operands.values();
	return this;
}

AND.prototype = Object.create(SemanticContext.prototype);
AND.prototype.constructor = AND;

AND.prototype.equals = function(other) {
	if (this === other) {
		return true;
	} else if (!(other instanceof AND)) {
		return false;
	} else {
		return this.opnds === other.opnds;
	}
};

AND.prototype.updateHashCode = function(hash) {
    hash.update(this.opnds, "AND");
};
//
// {@inheritDoc}
//
// <p>
// The evaluation of predicates by this context is short-circuiting, but
// unordered.</p>
//
AND.prototype.evaluate = function(parser, outerContext) {
	for (var i = 0; i < this.opnds.length; i++) {
		if (!this.opnds[i].evaluate(parser, outerContext)) {
			return false;
		}
	}
	return true;
};

AND.prototype.evalPrecedence = function(parser, outerContext) {
	var differs = false;
	var operands = [];
	for (var i = 0; i < this.opnds.length; i++) {
		var context = this.opnds[i];
		var evaluated = context.evalPrecedence(parser, outerContext);
		differs |= (evaluated !== context);
		if (evaluated === null) {
			// The AND context is false if any element is false
			return null;
		} else if (evaluated !== SemanticContext.NONE) {
			// Reduce the result by skipping true elements
			operands.push(evaluated);
		}
	}
	if (!differs) {
		return this;
	}
	if (operands.length === 0) {
		// all elements were true, so the AND context is true
		return SemanticContext.NONE;
	}
	var result = null;
	operands.map(function(o) {
		result = result === null ? o : SemanticContext.andContext(result, o);
	});
	return result;
};

AND.prototype.toString = function() {
	var s = "";
	this.opnds.map(function(o) {
		s += "&& " + o.toString();
	});
	return s.length > 3 ? s.slice(3) : s;
};

//
// A semantic context which is true whenever at least one of the contained
// contexts is true.
//
function OR(a, b) {
	SemanticContext.call(this);
	var operands = new Set();
	if (a instanceof OR) {
		a.opnds.map(function(o) {
			operands.add(o);
		});
	} else {
		operands.add(a);
	}
	if (b instanceof OR) {
		b.opnds.map(function(o) {
			operands.add(o);
		});
	} else {
		operands.add(b);
	}

	var precedencePredicates = PrecedencePredicate.filterPrecedencePredicates(operands);
	if (precedencePredicates.length > 0) {
		// interested in the transition with the highest precedence
		var s = precedencePredicates.sort(function(a, b) {
			return a.compareTo(b);
		});
		var reduced = s[s.length-1];
		operands.add(reduced);
	}
	this.opnds = operands.values();
	return this;
}

OR.prototype = Object.create(SemanticContext.prototype);
OR.prototype.constructor = OR;

OR.prototype.constructor = function(other) {
	if (this === other) {
		return true;
	} else if (!(other instanceof OR)) {
		return false;
	} else {
		return this.opnds === other.opnds;
	}
};

OR.prototype.updateHashCode = function(hash) {
    hash.update(this.opnds, "OR");
};

// <p>
// The evaluation of predicates by this context is short-circuiting, but
// unordered.</p>
//
OR.prototype.evaluate = function(parser, outerContext) {
	for (var i = 0; i < this.opnds.length; i++) {
		if (this.opnds[i].evaluate(parser, outerContext)) {
			return true;
		}
	}
	return false;
};

OR.prototype.evalPrecedence = function(parser, outerContext) {
	var differs = false;
	var operands = [];
	for (var i = 0; i < this.opnds.length; i++) {
		var context = this.opnds[i];
		var evaluated = context.evalPrecedence(parser, outerContext);
		differs |= (evaluated !== context);
		if (evaluated === SemanticContext.NONE) {
			// The OR context is true if any element is true
			return SemanticContext.NONE;
		} else if (evaluated !== null) {
			// Reduce the result by skipping false elements
			operands.push(evaluated);
		}
	}
	if (!differs) {
		return this;
	}
	if (operands.length === 0) {
		// all elements were false, so the OR context is false
		return null;
	}
	var result = null;
	operands.map(function(o) {
		return result === null ? o : SemanticContext.orContext(result, o);
	});
	return result;
};

OR.prototype.toString = function() {
	var s = "";
	this.opnds.map(function(o) {
		s += "|| " + o.toString();
	});
	return s.length > 3 ? s.slice(3) : s;
};

exports.SemanticContext = SemanticContext;
exports.PrecedencePredicate = PrecedencePredicate;
exports.Predicate = Predicate;


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
///

var ATNConfigSet = __webpack_require__(69).ATNConfigSet;
var Utils = __webpack_require__(13);
var Hash = Utils.Hash;
var Set = Utils.Set;

// Map a predicate to a predicted alternative.///

function PredPrediction(pred, alt) {
	this.alt = alt;
	this.pred = pred;
	return this;
}

PredPrediction.prototype.toString = function() {
	return "(" + this.pred + ", " + this.alt + ")";
};

// A DFA state represents a set of possible ATN configurations.
// As Aho, Sethi, Ullman p. 117 says "The DFA uses its state
// to keep track of all possible states the ATN can be in after
// reading each input symbol. That is to say, after reading
// input a1a2..an, the DFA is in a state that represents the
// subset T of the states of the ATN that are reachable from the
// ATN's start state along some path labeled a1a2..an."
// In conventional NFA&rarr;DFA conversion, therefore, the subset T
// would be a bitset representing the set of states the
// ATN could be in. We need to track the alt predicted by each
// state as well, however. More importantly, we need to maintain
// a stack of states, tracking the closure operations as they
// jump from rule to rule, emulating rule invocations (method calls).
// I have to add a stack to simulate the proper lookahead sequences for
// the underlying LL grammar from which the ATN was derived.
//
// <p>I use a set of ATNConfig objects not simple states. An ATNConfig
// is both a state (ala normal conversion) and a RuleContext describing
// the chain of rules (if any) followed to arrive at that state.</p>
//
// <p>A DFA state may have multiple references to a particular state,
// but with different ATN contexts (with same or different alts)
// meaning that state was reached via a different set of rule invocations.</p>
// /

function DFAState(stateNumber, configs) {
	if (stateNumber === null) {
		stateNumber = -1;
	}
	if (configs === null) {
		configs = new ATNConfigSet();
	}
	this.stateNumber = stateNumber;
	this.configs = configs;
	// {@code edges[symbol]} points to target of symbol. Shift up by 1 so (-1)
	// {@link Token//EOF} maps to {@code edges[0]}.
	this.edges = null;
	this.isAcceptState = false;
	// if accept state, what ttype do we match or alt do we predict?
	// This is set to {@link ATN//INVALID_ALT_NUMBER} when {@link
	// //predicates}{@code !=null} or
	// {@link //requiresFullContext}.
	this.prediction = 0;
	this.lexerActionExecutor = null;
	// Indicates that this state was created during SLL prediction that
	// discovered a conflict between the configurations in the state. Future
	// {@link ParserATNSimulator//execATN} invocations immediately jumped doing
	// full context prediction if this field is true.
	this.requiresFullContext = false;
	// During SLL parsing, this is a list of predicates associated with the
	// ATN configurations of the DFA state. When we have predicates,
	// {@link //requiresFullContext} is {@code false} since full context
	// prediction evaluates predicates
	// on-the-fly. If this is not null, then {@link //prediction} is
	// {@link ATN//INVALID_ALT_NUMBER}.
	//
	// <p>We only use these for non-{@link //requiresFullContext} but
	// conflicting states. That
	// means we know from the context (it's $ or we don't dip into outer
	// context) that it's an ambiguity not a conflict.</p>
	//
	// <p>This list is computed by {@link
	// ParserATNSimulator//predicateDFAState}.</p>
	this.predicates = null;
	return this;
}

// Get the set of all alts mentioned by all ATN configurations in this
// DFA state.
DFAState.prototype.getAltSet = function() {
	var alts = new Set();
	if (this.configs !== null) {
		for (var i = 0; i < this.configs.length; i++) {
			var c = this.configs[i];
			alts.add(c.alt);
		}
	}
	if (alts.length === 0) {
		return null;
	} else {
		return alts;
	}
};

// Two {@link DFAState} instances are equal if their ATN configuration sets
// are the same. This method is used to see if a state already exists.
//
// <p>Because the number of alternatives and number of ATN configurations are
// finite, there is a finite number of DFA states that can be processed.
// This is necessary to show that the algorithm terminates.</p>
//
// <p>Cannot test the DFA state numbers here because in
// {@link ParserATNSimulator//addDFAState} we need to know if any other state
// exists that has this exact set of ATN configurations. The
// {@link //stateNumber} is irrelevant.</p>
DFAState.prototype.equals = function(other) {
	// compare set of ATN configurations in this set with other
	return this === other ||
			(other instanceof DFAState &&
				this.configs.equals(other.configs));
};

DFAState.prototype.toString = function() {
	var s = "" + this.stateNumber + ":" + this.configs;
	if(this.isAcceptState) {
        s = s + "=>";
        if (this.predicates !== null)
            s = s + this.predicates;
        else
            s = s + this.prediction;
    }
	return s;
};

DFAState.prototype.hashCode = function() {
	var hash = new Hash();
	hash.update(this.configs);
	if(this.isAcceptState) {
        if (this.predicates !== null)
            hash.update(this.predicates);
        else
            hash.update(this.prediction);
    }
    return hash.finish();
};

exports.DFAState = DFAState;
exports.PredPrediction = PredPrediction;


/***/ }),
/* 90 */
/***/ (function(module, exports) {



/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

exports.equalObjects = __webpack_require__(16).equalObjects;
exports.equalArrays = __webpack_require__(16).equalArrays;
exports.arrayContains = __webpack_require__(16).arrayContains;
exports.ObjectList = __webpack_require__(22).ObjectList;
exports.ExpressionList = __webpack_require__(139).ExpressionList;
exports.CodeWriter = __webpack_require__(60).CodeWriter;
exports.TypeUtils = __webpack_require__(83).TypeUtils;


/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

var ConcreteCategoryDeclaration = __webpack_require__(52).ConcreteCategoryDeclaration;
var EnumeratedCategoryType = __webpack_require__(112).EnumeratedCategoryType;
var IdentifierList = __webpack_require__(115).IdentifierList;
var Identifier = __webpack_require__(0).Identifier;
var List = __webpack_require__(29).List;


function EnumeratedCategoryDeclaration(id, attrs, derived, symbols) {
	ConcreteCategoryDeclaration.call(this, id, attrs, derived, null);
	this.setSymbols(symbols);
	return this;
}

EnumeratedCategoryDeclaration.prototype = Object.create(ConcreteCategoryDeclaration.prototype);
EnumeratedCategoryDeclaration.prototype.constructor = EnumeratedCategoryDeclaration;


EnumeratedCategoryDeclaration.prototype.getDeclarationType = function() {
    return "Enumerated";
};


EnumeratedCategoryDeclaration.prototype.unregister = function(context) {
    context.unregisterDeclaration (this);
    this.symbols.forEach(function(symbol) {
        symbol.unregister(context);
    });
};


EnumeratedCategoryDeclaration.prototype.getLocalAttributes = function() {
    var attributes = ConcreteCategoryDeclaration.prototype.getLocalAttributes.call(this);
    if(!attributes)
        attributes = new IdentifierList();
    if(!attributes.hasAttribute("name"))
        attributes.add(new Identifier("name"));
    return attributes;
};


EnumeratedCategoryDeclaration.prototype.hasAttribute = function(context, name) {
    if("name"==name)
        return true;
    else
        return ConcreteCategoryDeclaration.prototype.hasAttribute.call(this, context, name);
};


EnumeratedCategoryDeclaration.prototype.setSymbols = function(symbols) {
	this.symbols = symbols || [];
    var type = new EnumeratedCategoryType(this.id);
    this.symbols.forEach(function(symbol) {
        symbol.type = type;
    });
};

EnumeratedCategoryDeclaration.prototype.register = function(context) {
	context.registerDeclaration(this);
    this.symbols.forEach(function(symbol) {
        symbol.register(context);
	});
};

EnumeratedCategoryDeclaration.prototype.check = function(context, isStart) {
	ConcreteCategoryDeclaration.prototype.check.call(this, context, isStart);
    this.symbols.forEach(function(symbol) {
        symbol.check(context);
	});
	return this.getType(context);
};

EnumeratedCategoryDeclaration.prototype.getType = function(context) {
	return new EnumeratedCategoryType(this.id);
};

EnumeratedCategoryDeclaration.prototype.toODialect = function(writer) {
    writer.append("enumerated category ");
    writer.append(this.name);
    if(this.attributes!=null) {
        writer.append('(');
        this.attributes.toDialect(writer, true);
        writer.append(")");
    }
    if(this.derivedFrom!=null) {
        writer.append(" extends ");
        this.derivedFrom.toDialect(writer, true);
    }
    writer.append(" {\n");
    writer.indent();
    this.symbols.forEach(function(symbol) {
        symbol.toDialect(writer);
        writer.append(";\n");
    });
    writer.dedent();
    writer.append("}\n");
};

EnumeratedCategoryDeclaration.prototype.toEDialect = function(writer) {
    writer.append("define ");
    writer.append(this.name);
    writer.append(" as enumerated ");
    if(this.derivedFrom!=null)
        this.derivedFrom.toDialect(writer, true);
    else
        writer.append("category");
    if(this.attributes!=null && this.attributes.length>0) {
        if(this.attributes.length==1)
            writer.append(" with attribute ");
        else
            writer.append(" with attributes ");
        this.attributes.toDialect(writer, true);
        if(this.symbols!=null && this.symbols.length>0)
            writer.append(", and symbols:\n");
    } else
        writer.append(" with symbols:\n");
    writer.indent();
    this.symbols.forEach(function(symbol) {
        symbol.toDialect(writer);
        writer.append("\n");
    });
    writer.dedent();
};

EnumeratedCategoryDeclaration.prototype.toMDialect = function(writer) {
    writer.append("enum ");
    writer.append(this.name);
    writer.append("(");
    if(this.derivedFrom!=null) {
        this.derivedFrom.toDialect(writer, false);
        if(this.attributes!=null && this.attributes.length>0)
            writer.append(", ");
    }
    if(this.attributes!=null && this.attributes.length>0)
        this.attributes.toDialect(writer, false);
    writer.append("):\n");
    writer.indent();
    this.symbols.forEach(function(symbol) {
        symbol.toDialect(writer);
        writer.append("\n");
    });
    writer.dedent();
};

EnumeratedCategoryDeclaration.prototype.isUserError = function(context) {
    return this.derivedFrom && this.derivedFrom.length===1 && this.derivedFrom[0].name==="Error";
};

EnumeratedCategoryDeclaration.prototype.ensureDeclarationOrder = function(context, list, set) {
    if(set.has(this))
        return;
    if (this.isUserError(context)) {
        list.push(this);
        set.add(this);
        // don't declare inherited Error
    } else
        ConcreteCategoryDeclaration.prototype.ensureDeclarationOrder.call(this, context, list, set);
};


EnumeratedCategoryDeclaration.prototype.declare = function(transpiler) {
    if(this.name==="Error")
        return;
    ConcreteCategoryDeclaration.prototype.declare.call(this, transpiler);
    transpiler.require(List);
};

EnumeratedCategoryDeclaration.prototype.transpile = function(transpiler) {
    if (this.isUserError(transpiler.context))
        this.transpileUserError(transpiler);
    else
        this.transpileEnumerated(transpiler);
};


EnumeratedCategoryDeclaration.prototype.transpileUserError = function(transpiler) {
    transpiler.append("class ").append(this.name).append(" extends Error {").indent();
    transpiler.newLine();
    transpiler.append("constructor(values) {").indent();
    transpiler.append("super(values.text);").newLine();
    transpiler.append("this.name = '").append(this.name).append("';").newLine();
    transpiler.append("this.promptoName = values.name;").newLine();
    transpiler.append("return this;").dedent();
    transpiler.append("}").newLine();
    transpiler.append("toString() {").indent().append("return this.message;").dedent().append("}").newLine();
    transpiler.append("getText() {").indent().append("return this.message;").dedent().append("}").newLine();
    transpiler.dedent().append("}").newLine();
    this.symbols.forEach(function(symbol) { symbol.initializeError(transpiler); });
    this.transpileSymbols(transpiler);
};

EnumeratedCategoryDeclaration.prototype.transpileSymbols = function(transpiler) {
    var names = this.symbols.map(function (symbol) {
        return symbol.name;
    });
    transpiler.append(this.name).append(".symbols = new List(false, [").append(names.join(", ")).append("]);").newLine();
};

EnumeratedCategoryDeclaration.prototype.transpileEnumerated = function(transpiler) {
    ConcreteCategoryDeclaration.prototype.transpile.call(this, transpiler);
    transpiler.newLine();
    transpiler.append(this.name).append(".prototype.toString = function() { return this.name; };").newLine();
    if(this.hasAttribute(transpiler.context, "text"))
        transpiler.append(this.name).append(".prototype.getText = function() { return this.text; };").newLine();
    else
        transpiler.append(this.name).append(".prototype.getText = ").append(this.name).append(".prototype.toString;").newLine();
    this.symbols.forEach(function(symbol) { symbol.initialize(transpiler); });
    this.transpileSymbols(transpiler);
};

exports.EnumeratedCategoryDeclaration = EnumeratedCategoryDeclaration;

/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var IntegerValue = __webpack_require__(3).IntegerValue;
var CharacterType = __webpack_require__(31).CharacterType;
var TextValue = null; // circular dependency
var removeAccents = __webpack_require__(16).removeAccents;

exports.resolve = function() {
    TextValue = __webpack_require__(17).TextValue;
}

function CharacterValue(value) {
    Value.call(this, CharacterType.instance);
	this.value = value;
	return this;
}

CharacterValue.prototype = Object.create(Value.prototype);
CharacterValue.prototype.constructor = CharacterValue;

var whitespace = [];
whitespace[" ".charCodeAt(0)] = true;
whitespace["\t".charCodeAt(0)] = true;
whitespace["\r".charCodeAt(0)] = true;
whitespace["\n".charCodeAt(0)] = true;

CharacterValue.isWhitespace = function(c) {
	return !!whitespace[c.charCodeAt(0)];
};


CharacterValue.prototype.getMemberValue = function(context, name) {
    if ("codePoint"==name) {
        return new IntegerValue(this.value.charCodeAt(0));
    } else {
        return Value.prototype.getMemberValue.call(this, context, name);
    }
};


CharacterValue.prototype.Add = function(context, value) {
    return new TextValue(this.value + value.toString());
}

CharacterValue.prototype.Multiply = function(context, value) {
    if (value instanceof IntegerValue) {
        try {
            var text = this.value.repeat(value.value);
            return new TextValue(text);
        } catch(error) {
            throw new SyntaxError("Negative repeat count:" + count);
        }
    } else {
        throw new SyntaxError("Illegal: Chararacter * " + typeof(value));
    }
};

CharacterValue.prototype.cmp = function(obj) {
    return this.value > obj.value ? 1 : this.value == obj.value ? 0 : -1 ;
};

CharacterValue.prototype.CompareTo = function(context, value) {
    if(value instanceof TextValue || value instanceof CharacterValue) {
        return this.value > value.value ? 1 : this.value == value.value ? 0 : -1;
    } else {
        throw new SyntaxError("Illegal: Compare CharacterValue with " + typeof(value));
    }
};

CharacterValue.prototype.convertToJavaScript = function() {
    return this.value;
};

CharacterValue.prototype.toString = function() {
    return this.value;
};

CharacterValue.prototype.equals = function(obj) {
    if (obj instanceof CharacterValue) {
        return this.value == obj.value;
    } else {
        return false;
    }
};

CharacterValue.prototype.Roughly = function(context, obj) {
    if (obj instanceof TextValue || obj instanceof CharacterValue) {
        return removeAccents(this.value.toLowerCase()) == removeAccents(obj.value.toLowerCase());
    } else {
        return false;
    }
};

exports.CharacterValue = CharacterValue;




/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

var UnresolvedIdentifier;

exports.resolve = function() {
    UnresolvedIdentifier = __webpack_require__(27).UnresolvedIdentifier;
}

function SelectorExpression(parent) {
	this.parent = parent || null;
	return this;
}

SelectorExpression.prototype.checkParent = function(context) {
    if (this.parent instanceof UnresolvedIdentifier)
        return this.parent.checkMember(context);
    else
        return this.parent.check(context);
};


exports.SelectorExpression = SelectorExpression;

/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

var Argument = __webpack_require__(114).Argument;
var IdentifierList = __webpack_require__(115).IdentifierList;
var SyntaxError = __webpack_require__(32).SyntaxError;
var utils = __webpack_require__(91);

function CategoryArgument(type, id, defaultExpression) {
	Argument.call(this, id);
	this.type = type;
    this.defaultExpression = defaultExpression || null;
	return this;
}

CategoryArgument.prototype = Object.create(Argument.prototype);
CategoryArgument.prototype.constructor = CategoryArgument;

CategoryArgument.prototype.getProto = function() {
	return this.type.name;
};

CategoryArgument.prototype.getTranspiledName =  function(context) {
    return this.type.getTranspiledName(context);
};
	
CategoryArgument.prototype.equals = function(other) {
    return other === this || (other instanceof CategoryArgument && utils.equalObjects(this.type, other.type));
};


CategoryArgument.prototype.register = function(context) {
	var actual = context.getRegisteredValue(this.name);
	if(actual!==null) {
		throw new SyntaxError("Duplicate argument: \"" + this.name + "\"");
	}
	context.registerValue(this);
    if(this.defaultExpression!=null)
        context.setValue(this.id, this.defaultExpression.interpret(context));
};

CategoryArgument.prototype.check = function(context) {
	this.type.checkExists(context);
};

CategoryArgument.prototype.declare = function(transpiler) {
    this.type.declare(transpiler);
};


CategoryArgument.prototype.getType = function(context) {
	return this.type;
};

CategoryArgument.prototype.toEDialect = function(writer) {
    var anonymous = "any"==this.type.name;
    this.type.toDialect(writer);
    if(anonymous) {
        writer.append(' ');
        writer.append(this.name);
    }
    if(!anonymous) {
        writer.append(' ');
        writer.append(this.name);
    }
};

CategoryArgument.prototype.toODialect = function(writer) {
    this.type.toDialect(writer);
    writer.append(' ');
    writer.append(this.name);
};

CategoryArgument.prototype.toMDialect = function(writer) {
    writer.append(this.name);
    writer.append(':');
    this.type.toDialect(writer);
};

exports.CategoryArgument = CategoryArgument;


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var Identifier = __webpack_require__(0).Identifier;

function CodeType()  {
	NativeType.call(this, new Identifier("Code"));
	return this;
}

CodeType.prototype = Object.create(NativeType.prototype);
CodeType.prototype.constructor = CodeType;

CodeType.instance = new CodeType();

/*
@Override
public Class<?> toJavaClass() {
	return null;
}
*/

exports.CodeType = CodeType;


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

var MethodType = __webpack_require__(38).MethodType;
var Value = __webpack_require__(1).Value;

function ClosureValue(context, type) {
    Value.call(this, type);
    this.context = context;
    return this;
}

ClosureValue.prototype = Object.create(Value.prototype);
ClosureValue.prototype.constructor = ClosureValue;

ClosureValue.prototype.interpret = function(context) {
    var parentMost = this.context.getParentMostContext();
    parentMost.setParentContext(context);
    var result = this.type.method.interpret(this.context);
    parentMost.setParentContext(null);
    return result;
};

exports.ClosureValue = ClosureValue;


/***/ }),
/* 98 */
/***/ (function(module, exports) {

function Document(entries) {
    if(entries)
        Object.getOwnPropertyNames(entries).forEach(function(name) { this[name] = entries[name]; }, this);
    return this;
}

Document.prototype.toString = function() {
    return JSON.stringify(this);
};

Document.prototype.getText = function() {
    if(this.hasOwnProperty("text"))
        return this.text;
    else
        return this.toString();
};

Document.prototype.getMember = function(name, create) {
    if(this.hasOwnProperty(name))
        return this[name];
    else if(create) {
        this[name] = new Document();
        return this[name];
    } else
        return null;
};


Document.prototype.setMember = function(name, value) {
    this[name] = value;
};


Document.prototype.setItem = function(index, value) {
    this[index] = value;
};

Document.prototype.item = function(index) {
    return this[index];
};


Document.prototype.toJson = function(json, instanceId, fieldName, withType, binaries) {
    var values = {};
    Object.getOwnPropertyNames(this).forEach(function (key) {
        var value = this[key];
        if(!value || typeof(value)===typeof(true) || typeof(value)===typeof(1) || typeof(value)===typeof(1.0) || typeof(value)===typeof(""))
            values[key] = value;
        else {
            var id = this; // TODO create identifier
            value.toJson(values, id, key, withType, binaries);
        }
    }, this);
    var doc = withType ? {type: "Document", value: values} : values;
    if (Array.isArray(json))
        json.push(doc);
    else
        json[fieldName] = doc;
};

Document.prototype.fromJson = function(node, parts) {
    for (key in node) {
        this[key] = this.readJsonField(node[key], parts);
    }
};


Document.prototype.readJsonField = function(node, parts) {
    if(!node || typeof(node)===typeof(true) || typeof(node)===typeof(1) || typeof(node)===typeof(1.0) || typeof(node)===typeof(""))
        return node;
    else if(typeof(node)===typeof([]))
        throw new Error("list");
    else if(typeof(node)===typeof({}))
        throw new Error("dict/object");
    else
        throw new Error(typeof(node).toString());
};


exports.Document = Document;

/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

var Identifier = __webpack_require__(0).Identifier;
var ContainerType = __webpack_require__(61).ContainerType;
var BooleanType = __webpack_require__(5).BooleanType;
var IntegerType = __webpack_require__(2).IntegerType;
var TextType = __webpack_require__(6).TextType;
var SetType = __webpack_require__(65).SetType;
var ListType = __webpack_require__(26).ListType;
var EntryType = __webpack_require__(369).EntryType;
var List = __webpack_require__(29).List;
var StrictSet = __webpack_require__(34).StrictSet;
var Dictionary = __webpack_require__(150).Dictionary;

function DictionaryType(itemType) {
	ContainerType.call(this, new Identifier(itemType.name + "<:>"), itemType);
	this.itemType = itemType;
	return this;
}

DictionaryType.prototype = Object.create(ContainerType.prototype);
DictionaryType.prototype.constructor = DictionaryType;


DictionaryType.prototype.withItemType = function(itemType) {
    return new DictionaryType(itemType);
};


DictionaryType.prototype.getTranspiledName = function(context) {
    return this.itemType.getTranspiledName(context) + "_dict";
};


DictionaryType.prototype.declare = function(transpiler) {
    transpiler.require(Dictionary);
};

DictionaryType.prototype.isAssignableFrom = function(context, other) {
    return ContainerType.prototype.isAssignableFrom.call(this, context, other)
	    || ((other instanceof DictionaryType) && this.itemType.isAssignableFrom(context, other.itemType));
};


DictionaryType.prototype.equals = function(obj) {
	if (obj == null) {
		return false;
	} else if (obj == this) {
		return true;
	} else if (!(obj instanceof DictionaryType)) {
		return false;
	} else {
		return this.itemType.equals(obj.itemType);
	}
};



DictionaryType.prototype.checkAdd = function(context, other, tryReverse) {
	if(other instanceof DictionaryType && this.itemType.equals(other.itemType)) {
		return this;
	} else {
		return ContainerType.prototype.checkAdd.call(this, context, other, tryReverse);
	}
};


DictionaryType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if(other instanceof DictionaryType && this.itemType.equals(other.itemType)) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else {
        return ContainerType.prototype.declareAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};


DictionaryType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if(other instanceof DictionaryType && this.itemType.equals(other.itemType)) {
        left.transpile(transpiler);
        transpiler.append(".add(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else {
        return ContainerType.prototype.transpileAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};



DictionaryType.prototype.checkContains = function(context, other) {
    if(other==TextType.instance) {
        return BooleanType.instance;
    } else {
        return ContainerType.prototype.checkContains.call(this, context, other);
    }
};


DictionaryType.prototype.declareContains = function(transpiler, other, container, item) {
    transpiler.require(StrictSet);
    container.declare(transpiler);
    item.declare(transpiler);
};


DictionaryType.prototype.transpileContains = function(transpiler, other, container, item) {
    container.transpile(transpiler);
    transpiler.append(".has(");
    item.transpile(transpiler);
    transpiler.append(")");
};


DictionaryType.prototype.checkContainsAllOrAny = function(context, other) {
    return BooleanType.instance;
};


DictionaryType.prototype.declareContainsAllOrAny = function(transpiler, other, container, items) {
    transpiler.require(StrictSet);
    container.declare(transpiler);
    items.declare(transpiler);
};


DictionaryType.prototype.transpileContainsAll = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAll(");
    items.transpile(transpiler);
    transpiler.append(")");
};

DictionaryType.prototype.transpileContainsAny = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAny(");
    items.transpile(transpiler);
    transpiler.append(")");
};


DictionaryType.prototype.checkItem = function(context, other) {
	if(other==TextType.instance) {
		return this.itemType;
	} else {
		return ContainerType.prototype.checkItem.call(this, context, other);
	}
};

DictionaryType.prototype.declareItem = function(transpiler, itemType, item) {
    // nothing to do
};


DictionaryType.prototype.transpileItem = function(transpiler, itemType, item) {
    transpiler.append(".item(");
    item.transpile(transpiler);
    transpiler.append(")");
};


DictionaryType.prototype.transpileAssignItemValue = function(transpiler, item, expression) {
    transpiler.append(".setItem(");
    item.transpile(transpiler);
    transpiler.append(", ");
    expression.transpile(transpiler);
    transpiler.append(")");
};


DictionaryType.prototype.checkIterator = function(context, source) {
	return new EntryType(this.itemType);
};

DictionaryType.prototype.checkMember = function(context, section, name) {
	if ("count"==name) {
		return IntegerType.instance;
	} else if("keys"==name) {
		return new SetType(TextType.instance);
	} else if ("values"==name) {
		return new ListType(this.itemType);
	} else {
		return ContainerType.prototype.checkMember.call(this, context, section, name);
	}
};


DictionaryType.prototype.declareMember = function(transpiler, name) {
    if("keys"===name) {
        transpiler.require(StrictSet);
    } else if("values"==name) {
        transpiler.require(List);
    } else if ("count"!==name) {
        ContainerType.prototype.declareMember.call(this, transpiler, name);
    }
};


DictionaryType.prototype.transpileMember = function(transpiler, name) {
    if ("count"===name) {
        transpiler.append("length");
    } else if("keys"===name || "values"==name) {
        transpiler.append(name);
    } else {
        ContainerType.prototype.transpileMember.call(this, transpiler, name);
    }
};


exports.DictionaryType = DictionaryType;


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

var SimpleStatement = __webpack_require__(28).SimpleStatement;
var VoidType = __webpack_require__(4).VoidType;

function NativeCall() {
	SimpleStatement.call(this);
	return this;
}
	
NativeCall.prototype = Object.create(SimpleStatement.prototype);
NativeCall.prototype.constructor = NativeCall;

NativeCall.prototype.toString = function() {
	return this.statement.toString();
};

NativeCall.prototype.check = function(context) {
	return VoidType.instance;
};

NativeCall.prototype.transpile = function(transpiler) {
    return true;
};

NativeCall.prototype.declare = function(transpiler) {
};

exports.NativeCall = NativeCall;


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(15);
var support = __webpack_require__(67);
var nodejsUtils = __webpack_require__(152);
var GenericWorker = __webpack_require__(37);

/**
 * The following functions come from pako, from pako/lib/utils/strings
 * released under the MIT license, see pako https://github.com/nodeca/pako/
 */

// Table with utf8 lengths (calculated by first byte of sequence)
// Note, that 5 & 6-byte values and some 4-byte values can not be represented in JS,
// because max possible codepoint is 0x10ffff
var _utf8len = new Array(256);
for (var i=0; i<256; i++) {
  _utf8len[i] = (i >= 252 ? 6 : i >= 248 ? 5 : i >= 240 ? 4 : i >= 224 ? 3 : i >= 192 ? 2 : 1);
}
_utf8len[254]=_utf8len[254]=1; // Invalid sequence start

// convert string to array (typed, when possible)
var string2buf = function (str) {
    var buf, c, c2, m_pos, i, str_len = str.length, buf_len = 0;

    // count binary size
    for (m_pos = 0; m_pos < str_len; m_pos++) {
        c = str.charCodeAt(m_pos);
        if ((c & 0xfc00) === 0xd800 && (m_pos+1 < str_len)) {
            c2 = str.charCodeAt(m_pos+1);
            if ((c2 & 0xfc00) === 0xdc00) {
                c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);
                m_pos++;
            }
        }
        buf_len += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;
    }

    // allocate buffer
    if (support.uint8array) {
        buf = new Uint8Array(buf_len);
    } else {
        buf = new Array(buf_len);
    }

    // convert
    for (i=0, m_pos = 0; i < buf_len; m_pos++) {
        c = str.charCodeAt(m_pos);
        if ((c & 0xfc00) === 0xd800 && (m_pos+1 < str_len)) {
            c2 = str.charCodeAt(m_pos+1);
            if ((c2 & 0xfc00) === 0xdc00) {
                c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);
                m_pos++;
            }
        }
        if (c < 0x80) {
            /* one byte */
            buf[i++] = c;
        } else if (c < 0x800) {
            /* two bytes */
            buf[i++] = 0xC0 | (c >>> 6);
            buf[i++] = 0x80 | (c & 0x3f);
        } else if (c < 0x10000) {
            /* three bytes */
            buf[i++] = 0xE0 | (c >>> 12);
            buf[i++] = 0x80 | (c >>> 6 & 0x3f);
            buf[i++] = 0x80 | (c & 0x3f);
        } else {
            /* four bytes */
            buf[i++] = 0xf0 | (c >>> 18);
            buf[i++] = 0x80 | (c >>> 12 & 0x3f);
            buf[i++] = 0x80 | (c >>> 6 & 0x3f);
            buf[i++] = 0x80 | (c & 0x3f);
        }
    }

    return buf;
};

// Calculate max possible position in utf8 buffer,
// that will not break sequence. If that's not possible
// - (very small limits) return max size as is.
//
// buf[] - utf8 bytes array
// max   - length limit (mandatory);
var utf8border = function(buf, max) {
    var pos;

    max = max || buf.length;
    if (max > buf.length) { max = buf.length; }

    // go back from last position, until start of sequence found
    pos = max-1;
    while (pos >= 0 && (buf[pos] & 0xC0) === 0x80) { pos--; }

    // Fuckup - very small and broken sequence,
    // return max, because we should return something anyway.
    if (pos < 0) { return max; }

    // If we came to start of buffer - that means vuffer is too small,
    // return max too.
    if (pos === 0) { return max; }

    return (pos + _utf8len[buf[pos]] > max) ? pos : max;
};

// convert array to string
var buf2string = function (buf) {
    var str, i, out, c, c_len;
    var len = buf.length;

    // Reserve max possible length (2 words per char)
    // NB: by unknown reasons, Array is significantly faster for
    //     String.fromCharCode.apply than Uint16Array.
    var utf16buf = new Array(len*2);

    for (out=0, i=0; i<len;) {
        c = buf[i++];
        // quick process ascii
        if (c < 0x80) { utf16buf[out++] = c; continue; }

        c_len = _utf8len[c];
        // skip 5 & 6 byte codes
        if (c_len > 4) { utf16buf[out++] = 0xfffd; i += c_len-1; continue; }

        // apply mask on first byte
        c &= c_len === 2 ? 0x1f : c_len === 3 ? 0x0f : 0x07;
        // join the rest
        while (c_len > 1 && i < len) {
            c = (c << 6) | (buf[i++] & 0x3f);
            c_len--;
        }

        // terminated by end of string?
        if (c_len > 1) { utf16buf[out++] = 0xfffd; continue; }

        if (c < 0x10000) {
            utf16buf[out++] = c;
        } else {
            c -= 0x10000;
            utf16buf[out++] = 0xd800 | ((c >> 10) & 0x3ff);
            utf16buf[out++] = 0xdc00 | (c & 0x3ff);
        }
    }

    // shrinkBuf(utf16buf, out)
    if (utf16buf.length !== out) {
        if(utf16buf.subarray) {
            utf16buf = utf16buf.subarray(0, out);
        } else {
            utf16buf.length = out;
        }
    }

    // return String.fromCharCode.apply(null, utf16buf);
    return utils.applyFromCharCode(utf16buf);
};


// That's all for the pako functions.


/**
 * Transform a javascript string into an array (typed if possible) of bytes,
 * UTF-8 encoded.
 * @param {String} str the string to encode
 * @return {Array|Uint8Array|Buffer} the UTF-8 encoded string.
 */
exports.utf8encode = function utf8encode(str) {
    if (support.nodebuffer) {
        return nodejsUtils.newBuffer(str, "utf-8");
    }

    return string2buf(str);
};


/**
 * Transform a bytes array (or a representation) representing an UTF-8 encoded
 * string into a javascript string.
 * @param {Array|Uint8Array|Buffer} buf the data de decode
 * @return {String} the decoded string.
 */
exports.utf8decode = function utf8decode(buf) {
    if (support.nodebuffer) {
        return utils.transformTo("nodebuffer", buf).toString("utf-8");
    }

    buf = utils.transformTo(support.uint8array ? "uint8array" : "array", buf);

    return buf2string(buf);
};

/**
 * A worker to decode utf8 encoded binary chunks into string chunks.
 * @constructor
 */
function Utf8DecodeWorker() {
    GenericWorker.call(this, "utf-8 decode");
    // the last bytes if a chunk didn't end with a complete codepoint.
    this.leftOver = null;
}
utils.inherits(Utf8DecodeWorker, GenericWorker);

/**
 * @see GenericWorker.processChunk
 */
Utf8DecodeWorker.prototype.processChunk = function (chunk) {

    var data = utils.transformTo(support.uint8array ? "uint8array" : "array", chunk.data);

    // 1st step, re-use what's left of the previous chunk
    if (this.leftOver && this.leftOver.length) {
        if(support.uint8array) {
            var previousData = data;
            data = new Uint8Array(previousData.length + this.leftOver.length);
            data.set(this.leftOver, 0);
            data.set(previousData, this.leftOver.length);
        } else {
            data = this.leftOver.concat(data);
        }
        this.leftOver = null;
    }

    var nextBoundary = utf8border(data);
    var usableData = data;
    if (nextBoundary !== data.length) {
        if (support.uint8array) {
            usableData = data.subarray(0, nextBoundary);
            this.leftOver = data.subarray(nextBoundary, data.length);
        } else {
            usableData = data.slice(0, nextBoundary);
            this.leftOver = data.slice(nextBoundary, data.length);
        }
    }

    this.push({
        data : exports.utf8decode(usableData),
        meta : chunk.meta
    });
};

/**
 * @see GenericWorker.flush
 */
Utf8DecodeWorker.prototype.flush = function () {
    if(this.leftOver && this.leftOver.length) {
        this.push({
            data : exports.utf8decode(this.leftOver),
            meta : {}
        });
        this.leftOver = null;
    }
};
exports.Utf8DecodeWorker = Utf8DecodeWorker;

/**
 * A worker to endcode string chunks into utf8 encoded binary chunks.
 * @constructor
 */
function Utf8EncodeWorker() {
    GenericWorker.call(this, "utf-8 encode");
}
utils.inherits(Utf8EncodeWorker, GenericWorker);

/**
 * @see GenericWorker.processChunk
 */
Utf8EncodeWorker.prototype.processChunk = function (chunk) {
    this.push({
        data : exports.utf8encode(chunk.data),
        meta : chunk.meta
    });
};
exports.Utf8EncodeWorker = Utf8EncodeWorker;


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */



var base64 = __webpack_require__(372)
var ieee754 = __webpack_require__(373)
var isArray = __webpack_require__(265)

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
  ? global.TYPED_ARRAY_SUPPORT
  : typedArraySupport()

/*
 * Export kMaxLength after typed array support is determined.
 */
exports.kMaxLength = kMaxLength()

function typedArraySupport () {
  try {
    var arr = new Uint8Array(1)
    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
    return arr.foo() === 42 && // typed array instances can be augmented
        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
  } catch (e) {
    return false
  }
}

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length)
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length)
    }
    that.length = length
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype
  return arr
}

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
}

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype
  Buffer.__proto__ = Uint8Array
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) {
    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
    Object.defineProperty(Buffer, Symbol.species, {
      value: null,
      configurable: true
    })
  }
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
}

function allocUnsafe (that, size) {
  assertSize(size)
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
}

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0
  that = createBuffer(that, length)

  var actual = that.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual)
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  that = createBuffer(that, length)
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array)
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset)
  } else {
    array = new Uint8Array(array, byteOffset, length)
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array)
  }
  return that
}

function fromObject (that, obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    that = createBuffer(that, len)

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len)
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string
  }

  var len = string.length
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length | 0
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
    if (this.length > max) str += ' ... '
  }
  return '<Buffer ' + str + '>'
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!Buffer.isBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  // must be an even number of digits
  var strLen = string.length
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0
    if (isFinite(length)) {
      length = length | 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i])
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end)
    newBuf.__proto__ = Buffer.prototype
  } else {
    var sliceLen = end - start
    newBuf = new Buffer(sliceLen, undefined)
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start]
    }
  }

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  this[offset] = (value & 0xff)
  return offset + 1
}

function objectWriteUInt16 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
      (littleEndian ? i : 1 - i) * 8
  }
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

function objectWriteUInt32 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffffffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
  }
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset + 3] = (value >>> 24)
    this[offset + 2] = (value >>> 16)
    this[offset + 1] = (value >>> 8)
    this[offset] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
    this[offset + 2] = (value >>> 16)
    this[offset + 3] = (value >>> 24)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start
  var i

  if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start]
    }
  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
    // ascending copy from start
    for (i = 0; i < len; ++i) {
      target[i + targetStart] = this[i + start]
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, start + len),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if (code < 256) {
        val = code
      }
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
  } else if (typeof val === 'number') {
    val = val & 255
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : utf8ToBytes(new Buffer(val, encoding).toString())
    var len = bytes.length
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function stringtrim (str) {
  if (str.trim) return str.trim()
  return str.replace(/^\s+|\s+$/g, '')
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

function isnan (val) {
  return val !== val // eslint-disable-line no-self-compare
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(79)))

/***/ }),
/* 103 */
/***/ (function(module, exports) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}


/***/ }),
/* 104 */
/***/ (function(module, exports) {

function Period(data) {
    var names = ["years", "months", "weeks", "days", "hours", "minutes", "seconds", "millis"];
    for(var i=0;i<names.length; i++) {
        this[names[i]] = data[i] || null;
    }
    return this;
}

Period.parse = function (text) {
    var data = [];
    var steps = "YMWDHM.S";
    var value = null;
    var lastStep = -1;
    var isNeg = false;
    var inPeriod = false;
    var inTime = false;
    var inMillis = false;

    for(var i=0;i<text.length;i++) {
        var c = text[i];
        // leading 'P' is mandatory
        if (!inPeriod) {
            if (c == 'P') {
                inPeriod = true;
                continue;
            } else {
                throw new Exception();
            }
        }
        // check for time section
        if (c == 'T') {
            if (!inTime) {
                inTime = true;
                continue;
            } else {
                throw new Exception();
            }
        }
        // check for value type
        var step = inTime ? steps.indexOf(c, 4) : steps.indexOf(c);
        if (step >= 0) {
            if (step <= lastStep) {
                throw new Exception();
            } else if (step > 3 && !inTime) {
                throw new Exception();
            } else if (value == null) {
                throw new Exception();
            } else if (step == 6) { // millis '.'
                inMillis = true;
            } else if (step == 7 && !inMillis) {
                step = 6;
            }
            data[step] = value;
            lastStep = step;
            value = null;
            continue;
        }
        if (c == '-') {
            if (value!=null) {
                throw new Exception();
            }
            if (isNeg || inMillis) {
                throw new Exception();
            }
            isNeg = true;
        }
        if (c < '0' || c > '9') {
            throw new Exception();
        }
        if (value!=null) {
            value *= 10;
            value += c - '0';
        } else {
            value = c - '0';
            if (isNeg) {
                value = -value;
                isNeg = false;
            }
        }
    }
    // must terminate by a value type
    if (value != null) {
        throw new Error("Failed parsing period literal: " + text);
    }
    return new Period(data);
};


Period.prototype.equals = function(obj) {
    return this.years == obj.years &&
        this.months == obj.months &&
        this.weeks == obj.weeks &&
        this.days == obj.days &&
        this.hours == obj.hours &&
        this.minutes == obj.minutes &&
        this.seconds == obj.seconds &&
        this.millis == obj.millis;
};


Period.prototype.minus = function() {
    var data = [];
    data[0] = -this.years;
    data[1] = -this.months;
    data[2] = -this.weeks;
    data[3] = -this.days;
    data[4] = -this.hours;
    data[5] = -this.minutes;
    data[6] = -this.seconds;
    data[7] = -this.millis;
    return new Period(data);
};

Period.prototype.add = function(period) {
    var data = [];
    data[0] = this.years + period.years;
    data[1] = this.months + period.months;
    data[2] = this.weeks + period.weeks;
    data[3] = this.days + period.days;
    data[4] = this.hours + period.hours;
    data[5] = this.minutes + period.minutes;
    var seconds = (this.seconds + period.seconds) + ((this.millis + period.millis)/1000.0);
    data[6] = Math.floor(seconds);
    var millis = Math.round(( seconds * 1000 ) % 1000);
    data[7] = Math.floor(Math.abs(millis));
    return new Period(data);
};


Period.prototype.subtract = function(period) {
    var data = [];
    data[0] = this.years - period.years;
    data[1] = this.months - period.months;
    data[2] = this.weeks - period.weeks;
    data[3] = this.days - period.days;
    data[4] = this.hours - period.hours;
    data[5] = this.minutes - period.minutes;
    var seconds = (this.seconds + this.millis/1000.0) - (period.seconds + period.millis/1000.0);
    data[6] = Math.floor(seconds);
    var millis = Math.round(( seconds * 1000 ) % 1000);
    data[7] = Math.floor(Math.abs(millis));
    return new Period(data);
};


Period.prototype.multiply = function(value) {
    var count = value;
    if (count == 0) {
        return new Period([]);
    } else if (count == 1) {
        return this;
    } else {
        var data = [];
        data[0] = this.years * count;
        data[1] = this.months * count;
        data[2] = this.weeks * count;
        data[3] = this.days * count;
        data[4] = this.hours * count;
        data[5] = this.minutes * count;
        var seconds = (this.seconds + this.millis/1000.0) * count;
        data[6] = Math.floor(seconds);
        var millis = Math.round(( seconds * 1000 ) % 1000);
        data[7] = Math.floor(Math.abs(millis));
        return new Period(data);
    }
};

Period.prototype.toString = function() {
    var s = "P";
    if (this.years) {
        s += this.years;
        s += "Y";
    }
    if (this.months) {
        s += this.months;
        s += "M";
    }
    if (this.weeks) {
        s += this.weeks;
        s += "W";
    }
    if (this.days) {
        s += this.days;
        s += "D";
    }
    if (this.hours || this.minutes || this.seconds || this.millis) {
        s += "T";
        if (this.hours) {
            s += this.hours;
            s += "H";
        }
        if (this.minutes) {
            s += this.minutes;
            s += "M";
        }
        if (this.seconds || this.millis) {
            s += this.seconds;
            if (this.millis) {
                s += ".";
                s += ("000" + this.millis).slice(-3);
            }
            s += "S";
        }
    }
    return s;
};


Period.prototype.getText = Period.prototype.toString;


exports.Period = Period;

/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

var CategoryType = __webpack_require__(7).CategoryType;

function ResourceType(name) {
	CategoryType.call(this, name);
	return this;
}

ResourceType.prototype = Object.create(CategoryType.prototype);
ResourceType.prototype.constructor = ResourceType;

ResourceType.prototype.equals = function(obj) {
	if(obj==this) {
		return true;
	}
	if(!(obj instanceof ResourceType)) {
		return false;
	}
	return this.name==obj.name;
};


exports.ResourceType = ResourceType;


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

var Section = __webpack_require__(19).Section;
var CategoryType = null;
var Identifier = __webpack_require__(0).Identifier;
var DocumentType = __webpack_require__(55).DocumentType;
var NotMutableError = __webpack_require__(118).NotMutableError;
var AttributeArgument = __webpack_require__(72).AttributeArgument;
var ArgumentAssignment = __webpack_require__(40).ArgumentAssignment;
var ArgumentAssignmentList = __webpack_require__(39).ArgumentAssignmentList;
var UnresolvedIdentifier = __webpack_require__(27).UnresolvedIdentifier;
var InstanceExpression = __webpack_require__(41).InstanceExpression;
var NativeCategoryDeclaration = __webpack_require__(122).NativeCategoryDeclaration;
var ConcreteWidgetDeclaration = __webpack_require__(189).ConcreteWidgetDeclaration;
var NativeWidgetDeclaration = __webpack_require__(206).NativeWidgetDeclaration;
var getTypeName = __webpack_require__(82).getTypeName;

exports.resolve = function() {
	CategoryType = __webpack_require__(7).CategoryType;
};


function ConstructorExpression(type, copyFrom, assignments, checked) {
    Section.call(this);
	this.type = type;
	this.copyFrom = copyFrom;
	this.assignments = assignments;
	this.checked = checked;
	return this;
}

ConstructorExpression.prototype  = Object.create(Section.prototype);
ConstructorExpression.prototype.constructor = ConstructorExpression;


ConstructorExpression.prototype.checkFirstHomonym = function(context, decl) {
    if(this.checked)
        return;
    if(this.assignments && this.assignments.length>0) {
        var assign = this.assignments[0];
        if(!assign.argument) {
            var id = null;
            if (assign.expression instanceof UnresolvedIdentifier || assign.expression instanceof InstanceExpression)
                id = assign.expression.id;
            if (id && decl.hasAttribute(context, id.name)) {
                assign.argument = new AttributeArgument(id);
                assign._expression = null;
            }
        }
    }
    this.checked = true;

};

ConstructorExpression.prototype.toDialect = function(writer) {
    var cd = writer.context.getRegisteredDeclaration(this.type.name);
    if(cd==null)
        writer.context.problemListener.reportUnknownCategory(this.type.id);
    this.checkFirstHomonym(writer.context, cd);
    writer.toDialect(this);
};

ConstructorExpression.prototype.toMDialect = function(writer) {
    this.toODialect(writer);
};

ConstructorExpression.prototype.toODialect = function(writer) {
    this.type.toDialect(writer);
    var assignments = new ArgumentAssignmentList();
    if (this.copyFrom != null)
        assignments.add(new ArgumentAssignment(new AttributeArgument(new Identifier("from")), this.copyFrom));
    if(this.assignments!=null)
        assignments.addAll(this.assignments);
    assignments.toDialect(writer);
};

ConstructorExpression.prototype.toEDialect = function(writer) {
    this.type.toDialect(writer);
    if (this.copyFrom != null) {
        writer.append(" from ");
        writer.append(this.copyFrom.toString());
        if (this.assignments != null && this.assignments.length>0)
            writer.append(",");
    }
    if (this.assignments != null)
        this.assignments.toDialect(writer);
};

ConstructorExpression.prototype.check = function(context) {
	// need to update type, since it was arbitrarily set to CategoryType
	var cd = context.getRegisteredDeclaration(this.type.name);
	if(cd==null)
        context.problemListener.reportUnknownCategory(this.type.id);
	this.checkFirstHomonym(context, cd);
	cd.checkConstructorContext(context);
	if(this.copyFrom!=null) {
		var cft = this.copyFrom.check(context);
		if(!(cft instanceof CategoryType) && cft!=DocumentType.instance)
            context.problemListener.reportInvalidCopySource(this.copyFrom);
            // throw new SyntaxError("Cannot copy from " + cft.getName());
	}
	if(this.assignments!=null) {
        this.assignments.forEach(function(assignment) {
			if(!cd.hasAttribute(context, assignment.name))
                context.problemListener.reportUnknownAttribute(assignment.name);
                //	throw new SyntaxError("\"" + assignment.name + "\" is not an attribute of " + this.type.name);
			assignment.check(context);
		});
	}
	return cd.getType();
};

ConstructorExpression.prototype.interpret = function(context) {
    var cd = context.getRegisteredDeclaration(this.type.name);
    this.checkFirstHomonym(context, cd);
	var instance = this.type.newInstance(context);
    instance.mutable = true;
	if(this.copyFrom!=null) {
		var copyObj = this.copyFrom.interpret(context);
		if((copyObj.getMemberValue || null)!=null) {
			var names = copyObj.getMemberNames();
			names.forEach(function(name) {
                if(name !== "dbId" && cd.hasAttribute(context, name)) {
                    var value = copyObj.getMemberValue(context, name);
                    if(value!=null && value.mutable && !this.type.mutable)
                        throw new NotMutableError();
                    // TODO convert Document member to attribute type
					instance.setMember(context, name, value);
				}
			}, this);
		}
	}
	if(this.assignments!=null) {
        this.assignments.forEach(function(assignment) {
			var value = assignment.expression.interpret(context);
            if(value!=null && value.mutable && !this.type.mutable)
                throw new NotMutableError();
			instance.setMember(context, assignment.name, value);
		}, this);
	}
    instance.mutable = this.type.mutable;
	return instance;
};

ConstructorExpression.prototype.declare = function(transpiler) {
    var cd = transpiler.context.getRegisteredDeclaration(this.type.name);
    cd.declare(transpiler);
    if(this.copyFrom)
        this.copyFrom.declare(transpiler);
    if(this.assignments)
        this.assignments.declare(transpiler);
};

ConstructorExpression.prototype.transpile = function(transpiler) {
    var decl = transpiler.context.getRegisteredDeclaration(this.type.name);
    if (decl instanceof NativeWidgetDeclaration)
        this.transpileNativeWidget(transpiler, decl);
    else if (decl instanceof ConcreteWidgetDeclaration)
        this.transpileConcreteWidget(transpiler, decl);
    else if (decl instanceof NativeCategoryDeclaration)
        this.transpileNative(transpiler, decl);
    else
        this.transpileConcrete(transpiler);
};


ConstructorExpression.prototype.transpileNativeWidget = function(transpiler, decl) {
    var bound = decl.getBoundFunction(true);
    transpiler.append("new ").append(getTypeName(bound)).append("()");
};


ConstructorExpression.prototype.transpileConcreteWidget = function(transpiler, decl) {
    transpiler = transpiler.newInstanceTranspiler(this.type);
    transpiler.append("new ").append(this.type.name).append("()");
    transpiler.flush();
};



ConstructorExpression.prototype.transpileNative = function(transpiler, decl) {
    var bound = decl.getBoundFunction(true);
    transpiler.append("new_").append(getTypeName(bound)).append("(");
    this.transpileAssignments(transpiler);
    transpiler.append(")");
};


ConstructorExpression.prototype.transpileConcrete = function(transpiler) {
    transpiler = transpiler.newInstanceTranspiler(this.type);
    transpiler.append("new ").append(this.type.name).append("(");
    if(this.copyFrom!=null)
        this.copyFrom.transpile(transpiler);
    else
        transpiler.append("null");
    transpiler.append(", ");
    this.transpileAssignments(transpiler);
    transpiler.append(", ");
    transpiler.append(this.type.mutable);
    transpiler.append(")");
    transpiler.flush();
};

ConstructorExpression.prototype.transpileAssignments = function(transpiler) {
    if(this.assignments!=null) {
        transpiler.append("{");
        this.assignments.forEach(function(assignment) {
            transpiler.append(assignment.argument.name).append(":");
            assignment.expression.transpile(transpiler);
            transpiler.append(", ");
        }, this);
        transpiler.trimLast(2);
        transpiler.append("}");
    } else
        transpiler.append("null");
};

exports.ConstructorExpression = ConstructorExpression;


/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var PeriodValue = __webpack_require__(87).PeriodValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var LocalDate = __webpack_require__(120).LocalDate;
var DateType = null;

exports.resolve = function() {
    DateType = __webpack_require__(127).DateType;
};

function DateValue(value) {
    Value.call(this, DateType.instance);
	this.value = value;
	return this;
}

DateValue.prototype = Object.create(Value.prototype);
DateValue.prototype.constructor = DateValue;

DateValue.prototype.toString = function() {
    return this.value.toString();
};

DateValue.prototype.getValue = function() {
	return this.value; 
};

DateValue.prototype.Add = function(context, value) {
    if (value instanceof PeriodValue) {
        var date = this.value.addPeriod(value.value);
        return new DateValue(date);
    } else {
        throw new SyntaxError("Illegal: Date + " + typeof(value));
    }
};


DateValue.prototype.Subtract = function(context, value)  {
    if (value instanceof DateValue) {
        return this.value.subtractDate(value.value);
    } else if (value instanceof PeriodValue) {
        return this.value.subtractPeriod(value.value);
    } else {
        throw new SyntaxError("Illegal: Date - " + typeof(value));
    }
};



DateValue.prototype.CompareTo = function(context, value) {
    if (value instanceof DateValue || value instanceof DateTime) {
        return this.cmp(value);
    } else {
        throw new SyntaxError("Illegal comparison: Date and " + typeof(value));
    }
};



DateValue.prototype.cmp = function(value) {
    var a = this.value.valueOf();
    var b = value.value.valueOf();
    return a > b ? 1 : (a == b ? 0 : -1);
};



DateValue.prototype.getMemberValue = function(context, name) {
    if ("year"==name) {
        return new IntegerValue(this.value.getYear());
    } else if ("month"==name) {
        return new IntegerValue(this.value.getMonth());
    } else if ("dayOfMonth"==name) {
        return new IntegerValue(this.value.getUTCDate());
    } else if ("dayOfYear"==name) {
        return new IntegerValue(this.value.getDayOfYear());
    } else {
        return Value.prototype.getMemberValue.call(this, context, name);
    }
};




DateValue.prototype.equals = function(obj) {
    if (obj instanceof DateValue) {
        return this.value.equals(obj.value);
    } else {
        return false;
    }
};


exports.DateValue = DateValue;




/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var PeriodValue = __webpack_require__(87).PeriodValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var LocalTime = __webpack_require__(121).LocalTime;
var TimeType = null;

exports.resolve = function() {
    TimeType = __webpack_require__(128).TimeType;
};

function TimeValue(value) {
	Value.call(this, TimeType.instance);
	this.value = value;
	return this;
}

TimeValue.prototype = Object.create(Value.prototype);
TimeValue.prototype.constructor = TimeValue;

TimeValue.prototype.toString = function() {
    return this.value.toString();
};

TimeValue.prototype.getValue = function() {
	return this.value;
};

TimeValue.prototype.Add = function(context, value) {
	if (value instanceof PeriodValue) {
		return new TimeValue(this.value.addPeriod(value));
	} else {
		throw new SyntaxError("Illegal: TimeValue + " + typeof(value));
	}
};


TimeValue.prototype.Subtract = function(context, value) {
	if (value instanceof PeriodValue) {
		return new TimeValue(this.value.subtractPeriod(value.value));
	} else if (value instanceof TimeValue) {
        return new PeriodValue(this.value.subtractTime(value.value));
	} else {
		throw new SyntaxError("Illegal: TimeValue - " + typeof(value));
	}
};

TimeValue.prototype.CompareTo = function(context, value) {
	if (value instanceof TimeValue) {
		return this.cmp(value);
	} else {
		throw new SyntaxError("Illegal comparison: TimeValue and " + typeof(value));
	}
};

TimeValue.prototype.getMemberValue = function(context, name) {
	if ("hour"==name) {
		return new IntegerValue(this.value.getHour());
	} else if ("minute"==name) {
		return new IntegerValue(this.value.getMinute());
	} else if ("second"==name) {
		return new IntegerValue(this.value.getSecond());
	} else if ("millisecond"==name) {
		return new IntegerValue(this.value.getMillisecond());
	} else {
        return Value.prototype.getMemberValue.call(this, context, name);
	}
};

TimeValue.prototype.cmp = function(obj) {
	var a = this.value.valueOf();
	var b = obj.value.valueOf();
	return a > b ? 1 : (a == b ? 0 : -1) ;
};

TimeValue.prototype.equals = function(obj) {
	if (obj instanceof TimeValue) {
		return this.value.equals(obj.value);
	} else {
		return false;
	}
};

/*
@Override
public int hashCode() {
	return value.hashCode();
}

@Override
public String toString() {
	return value.toString();
}

*/

exports.TimeValue = TimeValue;


/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var Identifier = __webpack_require__(0).Identifier;

function JsxType () {
    NativeType.call(this, new Identifier("Jsx"));
    return this;
}

JsxType.prototype = Object.create(NativeType.prototype);
JsxType.prototype.constructor = JsxType;


JsxType.instance = new JsxType();

exports.JsxType = JsxType;

/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

var Section = __webpack_require__(19).Section;

function BaseDeclaration(id) {
	Section.call(this);
	this.id = id;
    this.comments = null;
    this.annotations = null;
    this.declaring = false;
	return this;
}

BaseDeclaration.prototype = Object.create(Section.prototype);
BaseDeclaration.prototype.constructor = BaseDeclaration;

Object.defineProperty(BaseDeclaration.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});

BaseDeclaration.prototype.unregister = function(context) {
    context.unregisterDeclaration (this);
};

BaseDeclaration.prototype.toDialect = function(writer) {
    writer.toDialect(this);
};

BaseDeclaration.prototype.fetchBody = function(parser) {
    var section = null;
    if(section==null && this.comments && this.comments.length > 0)
        section = this.comments[0];
    if(section==null && this.annotations && this.annotations.length > 0)
        section = this.annotations[0];
    if(section==null)
        section = this;
    return parser.getTokenStream().getText({ start: section.start.tokenIndex, stop: this.end.tokenIndex + 1 });
}


exports.BaseDeclaration = BaseDeclaration;


/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var BooleanType = __webpack_require__(5).BooleanType;

function IterableType(id, itemType) {
	NativeType.call(this, id);
	this.itemType = itemType;
	return this;
}

IterableType.prototype = Object.create(NativeType.prototype);
IterableType.prototype.constructor = IterableType;


IterableType.prototype.isMoreSpecificThan = function(context, other) {
    return (other instanceof IterableType &&
        this.itemType.isMoreSpecificThan(context, other.itemType));
};

exports.IterableType = IterableType;



/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

var CategoryType = __webpack_require__(7).CategoryType;
var ListType = __webpack_require__(26).ListType;
var TextType = __webpack_require__(6).TextType;
var SyntaxError = __webpack_require__(32).SyntaxError;



function EnumeratedCategoryType(id) {
	CategoryType.call(this, id);
	return this;
}

EnumeratedCategoryType.prototype = Object.create(CategoryType.prototype);
EnumeratedCategoryType.prototype.constructor =  EnumeratedCategoryType;

EnumeratedCategoryType.prototype.checkMember = function(context, section, name) {
    if ("symbols"==name) {
        return new ListType(this);
    } else if ("name"==name) {
        return TextType.instance;
    } else {
        return CategoryType.prototype.checkMember.call(this, context, section, name);
    }
};


EnumeratedCategoryType.prototype.getMemberValue = function(context, name) {
    var decl = context.getRegisteredDeclaration(this.name);
    if (!decl || !decl.symbols) {
        throw new SyntaxError(name + " is not an enumerated type!");
    }
    if ("symbols" == name) {
        return decl.symbols;
    } else {
        throw new SyntaxError("Unknown member:" + name);
    }
};

exports.EnumeratedCategoryType = EnumeratedCategoryType;

/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

var BaseType = __webpack_require__(47).BaseType;
var Identifier = __webpack_require__(0).Identifier;

function NullType() {
    BaseType.call(this, new Identifier("Null"));
    return this;
}

NullType.prototype = Object.create(BaseType.prototype);
NullType.prototype.constructor = NullType;

NullType.instance = new NullType();

NullType.prototype.checkUnique = function(context) {
    // ok
};

NullType.prototype.checkExists = function(context) {
    // ok
};

NullType.prototype.isAssignableFrom = function(context, other) {
    return true;
};

NullType.prototype.isMoreSpecificThan = function(context, other) {
    return false;
};


NullType.prototype.equals = function(other) {
    return other==this;
};

exports.NullType = NullType;


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

var IntegerValue = __webpack_require__(3).IntegerValue;
var DecimalValue = __webpack_require__(33).DecimalValue;
var IntegerType = __webpack_require__(2).IntegerType;
var DecimalType = __webpack_require__(23).DecimalType;

function Argument(id) {
	this.id = id;
    this.mutable = false;
    this.defaultExpression = null;
	return this;
}

Object.defineProperty(Argument.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});

Argument.prototype.checkValue = function(context, expression) {
    var value = expression.interpret(context);
    if (value instanceof IntegerValue && this.getType(context)==DecimalType.instance) {
        return new DecimalValue(value.DecimalValue());
    } else if (value instanceof DecimalValue && this.getType(context)==IntegerType.instance) {
        return new IntegerValue(value.IntegerValue());
    } else {
        return value;
    }
};

Argument.prototype.toDialect = function(writer) {
    if(this.mutable)
        writer.append("mutable ");
    writer.toDialect(this);
    if(this.defaultExpression!=null) {
        writer.append(" = ");
        this.defaultExpression.toDialect(writer);
    }
};

Argument.prototype.transpile = function(transpiler, expression) {
    transpiler.append(this.name);
};


Argument.prototype.transpileCall = function(transpiler, expression) {
    var expType = expression.check(transpiler.context);
    if (this.type === IntegerType.instance && expType === DecimalType.instance) {
        transpiler.append("Math.round(");
        expression.transpile(transpiler);
        transpiler.append(")");
    } else
        expression.transpile(transpiler);
};

exports.Argument = Argument;


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

var ObjectList = __webpack_require__(22).ObjectList;
var Dialect = __webpack_require__(8).Dialect;

function IdentifierList(item) {
    ObjectList.call(this);
	item = item || null;
	if(item!==null) {
		this.add(item);
	}
	return this;
}

IdentifierList.prototype = Object.create(ObjectList.prototype);
IdentifierList.prototype.constructor = IdentifierList;


IdentifierList.prototype.names = function() {
    return this.map(function(id) { return id.name; } );
};


IdentifierList.prototype.hasAttribute = function(name) {
    for(var i = 0; i < this.length; i++) {
        if(this[i].name===name)
            return true;
    }
    return false;
};

IdentifierList.prototype.toDialect = function(writer, finalAnd) {
    finalAnd = finalAnd || false;
    switch(writer.dialect) {
        case Dialect.E:
            this.toEDialect(writer, finalAnd);
            break;
        case Dialect.O:
            this.toODialect(writer);
            break;
        case Dialect.M:
            this.toMDialect(writer);
            break;
    }
};

IdentifierList.prototype.toEDialect = function(writer, finalAnd) {
    switch(this.length) {
        case 0:
            return;
        case 1:
            writer.append(this[0].name);
            break;
        default:
            for(var i=0;i<this.length;i++) {
                if(finalAnd && i==this.length-1)
                    break;
                writer.append(this[i].name);
                writer.append(", ");
            }
            writer.trimLast(2);
            if(finalAnd) {
                writer.append(" and ");
                writer.append(this[this.length-1].name);
            }
    }
};

IdentifierList.prototype.toODialect = function(writer) {
    if(this.length>0) {
        this.forEach(function(id) {
            writer.append(id.name);
            writer.append(", ");
        });
        writer.trimLast(2);
    }
};

IdentifierList.prototype.toMDialect = function(writer) {
    this.toODialect(writer);
};

exports.IdentifierList = IdentifierList;

/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

var CodeType = __webpack_require__(96).CodeType;
var Argument = __webpack_require__(114).Argument;

function CodeArgument(id) {
	Argument.call(this, id);
	return this;
}

CodeArgument.prototype = Object.create(Argument.prototype);
CodeArgument.prototype.constructor = CodeArgument;


CodeArgument.prototype.getProto = function() {
	return CodeType.instance.name;
};


CodeArgument.prototype.register = function(context) {
	var actual = context.getRegisteredValue(this.name);
	if(actual!=null) {
		throw new SyntaxError("Duplicate argument: \"" + this.name + "\"");
	}
	context.registerValue(this);
};

CodeArgument.prototype.check = function(context) {
	// nothing to do
};

CodeArgument.prototype.declare = function(transpiler) {
    // nothing to do
};

CodeArgument.prototype.getType = function(context) {
	return CodeType.instance;
};

CodeArgument.prototype.toDialect = function(writer) {
    writer.append(CodeType.instance.name);
    writer.append(" ");
    writer.append(this.name);
};


exports.CodeArgument = CodeArgument;

/***/ }),
/* 117 */
/***/ (function(module, exports) {

function Range(first, last) {
    this.first = first;
    this.last = last;
    return this;
}

Range.prototype.toString = function() {
    return "[" + this.first + ".." + this.last + "]";
};


Range.prototype.getText = Range.prototype.toString;


Range.prototype.iterator = function() {
    var self = this;
    return {
        idx: 1, // since we are calling item()
        length: self.length,
        hasNext: function() { return this.idx <= this.length },
        next : function() { return self.item(this.idx++); }
    };
};

Range.prototype.equals = function(obj) {
    if(Object.is(this, obj))
        return true;
    else if(Object.getPrototypeOf(this) === Object.getPrototypeOf(obj))
        return equalObjects(this.first, obj.first) && equalObjects(this.last, obj.last);
    else
        return false;
};

Range.prototype.hasAll = function(items) {
    if(typeof(StrictSet) !== 'undefined' && items instanceof StrictSet)
        items = Array.from(items.set.values());
    for (var i = 0; i < items.length; i++) {
        if (!this.has(items[i]))
            return false;
    }
    return true;
};


Range.prototype.slice1Based = function(start, end) {
    this.checkRange(start, end);
    var range = Object.create(this);
    range.first = start ? this.item(start) : this.first;
    range.last = end ? ( end > 0 ? this.item(end) : this.item(this.length + 1 + end) ) : this.last;
    return range;
};


Range.prototype.checkRange = function(start, end) {
    if(start && (start<1 || start>this.length))
        throw new RangeError();
    if(!start)
        start = 1;
    if(end) {
        if(end>=0 && (end<1 || end>this.length))
            throw new RangeError();
        else if(end<-this.length)
            throw new RangeError();
    }
};

Range.prototype.hasAny = function(items) {
    if(typeof(StrictSet) !== 'undefined' && items instanceof StrictSet)
        items = Array.from(items.set.values());
    for (var i = 0; i < items.length; i++) {
        if (this.has(items[i]))
            return true;
    }
    return false;
};


function IntegerRange(first, last) {
    Range.call(this, first, last);
    return this;
}

IntegerRange.prototype = Object.create(Range.prototype);
IntegerRange.prototype.constructor = IntegerRange;

Object.defineProperty(IntegerRange.prototype, "length", {
    get: function() {
        return 1 + this.last - this.first;
    }
});

IntegerRange.prototype.item = function(idx) {
    return this.first + idx - 1;
};

IntegerRange.prototype.has = function(value) {
    var int = Math.floor(value);
    return int==value && int>=this.first && int<=this.last;
};

function CharacterRange(first, last) {
    IntegerRange.call(this, first.charCodeAt(0), last.charCodeAt(0));
    return this;
}

CharacterRange.prototype = Object.create(IntegerRange.prototype);
CharacterRange.prototype.constructor = CharacterRange;

CharacterRange.prototype.has = function(value) {
    var int = value.charCodeAt(0);
    return int>=this.first && int<=this.last;
};


CharacterRange.prototype.item = function(idx) {
    return String.fromCharCode(this.first + idx - 1);
};


function DateRange(first, last) {
    Range.call(this, first, last);
    return this;
}

DateRange.prototype = Object.create(Range.prototype);
DateRange.prototype.constructor = DateRange;

Object.defineProperty(DateRange.prototype, "length", {
    get: function() {
        var h = this.last.valueOf();
        var l = this.first.valueOf();
        return 1 + ( (h-l)/(24*60*60*1000));
    }
});

DateRange.prototype.item = function(idx) {
    var millis = this.first.valueOf() + (idx-1)*(24*60*60*1000);
    if(millis > this.last.valueOf()) {
        throw new RangeError();
    } else {
        return new LocalDate(millis);
    }
};

DateRange.prototype.has = function(value) {
    var int = value.valueOf();
    return int>=this.first.valueOf() && int<=this.last.valueOf();
};

function TimeRange(first, last) {
    Range.call(this, first, last);
    return this;
}

TimeRange.prototype = Object.create(Range.prototype);
TimeRange.prototype.constructor = TimeRange;

Object.defineProperty(TimeRange.prototype, "length", {
    get: function() {
        return 1 + (this.last.valueOf() - this.first.valueOf())/1000;
    }
});

TimeRange.prototype.item = function(idx) {
    var result = this.first.valueOf() + (idx-1)*1000;
    if(result > this.last.valueOf()) {
        throw new RangeError();
    }
    return new LocalTime(result);
};

TimeRange.prototype.has = function(value) {
    var int = value.valueOf();
    return int >= this.first.valueOf() && int <= this.last.valueOf();
};


exports.Range = Range;
exports.IntegerRange = IntegerRange;
exports.CharacterRange = CharacterRange;
exports.DateRange = DateRange;
exports.TimeRange = TimeRange;

/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

var ExecutionError = __webpack_require__(48).ExecutionError;

function NotMutableError() {
	ExecutionError.call(this);
	return this;
}

NotMutableError.prototype = Object.create(ExecutionError.prototype);
NotMutableError.prototype.constructor = NotMutableError;

NotMutableError.prototype.getExpression = function(context) {
	return context.getRegisteredValue("NOT_MUTABLE");
};

exports.NotMutableError = NotMutableError;


/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(Buffer) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.

function isArray(arg) {
  if (Array.isArray) {
    return Array.isArray(arg);
  }
  return objectToString(arg) === '[object Array]';
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = Buffer.isBuffer;

function objectToString(o) {
  return Object.prototype.toString.call(o);
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(102).Buffer))

/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

var Period = __webpack_require__(104).Period;

function LocalDate(value) {
    var date = new Date(value);
    date.__proto__ = LocalDate.prototype;
    return date;
}

LocalDate.parse = function(value) {
    return new LocalDate(value);
};

LocalDate.prototype.__proto__ = Date.prototype;

LocalDate.prototype.toString = function() {
    return this.toISOString().substring(0, 10);
};

LocalDate.prototype.getText = LocalDate.prototype.toString;

LocalDate.prototype.equals = function(other) {
    return other instanceof LocalDate && this.valueOf() == other.valueOf();
};

LocalDate.prototype.gt = function(other) {
    return other instanceof LocalDate && this.valueOf() > other.valueOf();
};


LocalDate.prototype.gte = function(other) {
    return other instanceof LocalDate && this.valueOf() >= other.valueOf();
};


LocalDate.prototype.lt = function(other) {
    return other instanceof LocalDate && this.valueOf() < other.valueOf();
};


LocalDate.prototype.lte = function(other) {
    return other instanceof LocalDate && this.valueOf() <= other.valueOf();
};

LocalDate.prototype.addPeriod = function (period) {
    var result = new LocalDate();
    var year = this.getUTCFullYear() + (period.years || 0);
    result.setUTCFullYear(year);
    var month = this.getUTCMonth() + (period.months || 0);
    result.setUTCMonth(month);
    var day = this.getUTCDate() + ((period.weeks || 0) * 7) + (period.days || 0);
    result.setUTCDate(day);
    return result;
};


LocalDate.prototype.subtractDate = function(value) {
    var data = [];
    data[0] = this.getUTCFullYear() - value.getUTCFullYear();
    data[1] = this.getUTCMonth() - value.getUTCMonth();
    data[3] = this.getUTCDate() - value.getUTCDate();
    return new Period(data);
};



LocalDate.prototype.subtractPeriod = function(value) {
    var date = new LocalDate();
    var year = this.getUTCFullYear() - (value.years || 0);
    date.setUTCFullYear(year);
    var month = this.getUTCMonth() - (value.months || 0);
    date.setUTCMonth(month);
    var day = this.getUTCDate() - ((value.weeks || 0) * 7) - (value.days || 0);
    date.setUTCDate(day);
    return date;
};


LocalDate.prototype.getYear = function(value) {
    return this.getUTCFullYear();
};

LocalDate.prototype.getMonth = function(value) {
    return this.getUTCMonth() + 1;
};


LocalDate.prototype.getDayOfMonth = function(value) {
    return this.getUTCDate();
};


LocalDate.prototype.getDayOfYear = function() {
    var first = new Date(this.getUTCFullYear(), 0, 1, 0, 0, 0, 0);
    var numDays = (this - first) / (1000 * 60 * 60 * 24);
    return 1 + Math.floor(numDays);
};

exports.LocalDate = LocalDate;

/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

var Period = __webpack_require__(104).Period;

function LocalTime(value) {
    var time = value ? new Date(value) : new Date();
    time.__proto__ = LocalTime.prototype;
    return time;
}

LocalTime.parse = function(text) {
    var time = new LocalTime();
    time.setUTCHours(parseInt(text.substring(0,2)));
    time.setUTCMinutes(parseInt(text.substring(3,5)));
    time.setUTCSeconds(parseInt(text.length>6 ? text.substring(6,8) : 0));
    time.setUTCMilliseconds(text.length>9 ? parseInt(text.substring(9,13)) : 0);
    return time;
};

LocalTime.prototype.__proto__ = Date.prototype;

LocalTime.prototype.toString = function() {
    return this.toISOString().substring(11, 23)
};


LocalTime.prototype.getText = LocalTime.prototype.toString;

LocalTime.prototype.equals = function(obj) {
    return obj instanceof LocalTime && this.valueOf() == obj.valueOf();
};


LocalTime.prototype.gt = function(other) {
    return other instanceof LocalTime && this.valueOf() > other.valueOf();
};


LocalTime.prototype.gte = function(other) {
    return other instanceof LocalTime && this.valueOf() >= other.valueOf();
};

LocalTime.prototype.lt = function(other) {
    return other instanceof LocalTime && this.valueOf() < other.valueOf();
};


LocalTime.prototype.lte = function(other) {
    return other instanceof LocalTime && this.valueOf() <= other.valueOf();
};


LocalTime.prototype.addPeriod = function(period) {
    var time = new LocalTime();
    var hour = this.getUTCHours() + (period.hours || 0);
    time.setUTCHours(hour);
    var minute = this.getUTCMinutes() + (period.minutes || 0);
    time.setUTCMinutes(minute);
    var second = this.getUTCSeconds() + (period.seconds || 0);
    time.setUTCSeconds(second);
    var millis = this.getUTCMilliseconds() + (period.millis || 0);
    time.setUTCMilliseconds(millis);
    return time;
};

LocalTime.prototype.subtractTime = function(time) {
    var data = [];
    data[4] = this.getUTCHours() - time.getUTCHours();
    data[5] = this.getUTCMinutes() - time.getUTCMinutes();
    data[6] = this.getUTCSeconds() - time.getUTCSeconds();
    data[7] = this.getUTCMilliseconds() - time.getUTCMilliseconds();
    return new Period(data);
};


LocalTime.prototype.subtractPeriod = function(period) {
    var time = new LocalTime();
    var hour = this.getUTCHours() - (period.hours || 0);
    time.setUTCHours(hour);
    var minute = this.getUTCMinutes() - (period.minutes || 0);
    time.setUTCMinutes(minute);
    var second = this.getUTCSeconds() - (period.seconds || 0);
    time.setUTCSeconds(second);
    var millis = this.getUTCMilliseconds() - (period.millis || 0);
    time.setUTCMilliseconds(millis);
    return time;
};

LocalTime.prototype.getHour = function(value) {
    return this.getUTCHours();
};


LocalTime.prototype.getMinute = function(value) {
    return this.getUTCMinutes();
};


LocalTime.prototype.getSecond = function(value) {
    return this.getUTCSeconds();
};


LocalTime.prototype.getMillisecond = function(value) {
    return this.getUTCMilliseconds();
};


exports.LocalTime = LocalTime;

/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

var ConcreteCategoryDeclaration = __webpack_require__(52).ConcreteCategoryDeclaration;
var getTypeName = __webpack_require__(82).getTypeName;
var NativeInstance = __webpack_require__(123).NativeInstance;
var JavaScriptNativeCategoryBinding = __webpack_require__(297).JavaScriptNativeCategoryBinding;
var CategoryType = __webpack_require__(7).CategoryType;

function NativeCategoryDeclaration(id, attributes, categoryBindings, attributeBindings, methods) {
    ConcreteCategoryDeclaration.call(this, id, attributes, null, methods);
	this.categoryBindings = categoryBindings;
	this.attributeBindings = attributeBindings;
	this.bound = null;
	return this;
}

NativeCategoryDeclaration.prototype = Object.create(ConcreteCategoryDeclaration.prototype);
NativeCategoryDeclaration.prototype.constructor = NativeCategoryDeclaration;

NativeCategoryDeclaration.prototype.register = function(context) {
    ConcreteCategoryDeclaration.prototype.register.call(this, context);
    var bound = this.getBoundFunction(false);
    if(bound!=null) {
        var name = getTypeName(bound);
        context.registerNativeBinding(name, this);
    }
};

NativeCategoryDeclaration.prototype.toEDialect = function(writer) {
    this.protoToEDialect(writer, false, true);
    this.bindingsToEDialect(writer);
    if(this.methods!=null && this.methods.length>0) {
        writer.append("and methods:");
        writer.newLine();
        this.methodsToEDialect(writer, this.methods);
    }
};

NativeCategoryDeclaration.prototype.categoryTypeToEDialect = function(writer) {
    writer.append("native category");
};

NativeCategoryDeclaration.prototype.bindingsToEDialect = function(writer) {
    writer.indent();
    this.categoryBindings.toDialect(writer);
    writer.dedent();
    writer.newLine();
};

NativeCategoryDeclaration.prototype.toODialect = function(writer) {
    var hasBody = true; // always one
    this.allToODialect(writer, hasBody);
};

NativeCategoryDeclaration.prototype.categoryTypeToODialect = function(writer) {
    writer.append("native category");
};

NativeCategoryDeclaration.prototype.bodyToODialect = function(writer) {
    this.categoryBindings.toDialect(writer);
    if(this.methods!=null && this.methods.length>0) {
        writer.newLine();
        writer.newLine();
        this.methodsToODialect(writer, this.methods);
    }
};

NativeCategoryDeclaration.prototype.toMDialect = function(writer) {
    this.protoToMDialect(writer, null);
    writer.indent();
    writer.newLine();
    this.categoryBindings.toDialect(writer);
    if(this.methods!=null && this.methods.length>0) {
        this.methods.forEach(function(method) {
            var w = writer.newMemberWriter();
            method.toDialect(w);
            writer.newLine();
        });
    }
    writer.dedent();
    writer.newLine();
};

NativeCategoryDeclaration.prototype.categoryTypeToMDialect = function(writer) {
    writer.append("native category");
};

NativeCategoryDeclaration.prototype.newInstance = function(context) {
	return new NativeInstance(context, this);
};

NativeCategoryDeclaration.prototype.getBoundFunction = function(fail) {
	if(this.bound==null) {
		var binding = this.getBinding(fail);
        if(binding!=null) {
            this.bound = binding.resolve();
            if(fail && this.bound==null)
                throw new SyntaxError("No JavaScript function:" + binding.toString());
		}
	}
	return this.bound;
};

NativeCategoryDeclaration.prototype.getBinding = function(fail) {
	for(var i=0;i<this.categoryBindings.length;i++) {
		if(this.categoryBindings[i] instanceof JavaScriptNativeCategoryBinding) {
			return this.categoryBindings[i];
		}
	}
    if(fail)
	    throw new SyntaxError("Missing JavaScript binding for category: " + this.name);
    else
        return null;
};


NativeCategoryDeclaration.prototype.declare = function(transpiler) {
    transpiler.declare(this);
    if(this.name==="Any")
        transpiler.register(__webpack_require__(140).Any);
};

NativeCategoryDeclaration.prototype.transpile = function(transpiler) {
    var binding = this.getBinding(true);
    binding.transpile(transpiler);
    var bound = binding.resolve();
    var name = getTypeName(bound);
    transpiler.append("function ").append("new_").append(this.name).append("(values) {").indent();
    transpiler.append("values = values || {};").newLine();
    transpiler.append("var value = new ").append(name).append("();").newLine();
    if(this.attributes) {
        this.attributes.forEach(function (attr) {
            transpiler.append("value.").append(attr.name).append(" = values.hasOwnProperty('").append(attr.name).append("') ? values.").append(attr.name).append(" : null;").newLine();
        }, this);
    }
    transpiler.append("return value;").newLine();
    transpiler.dedent().append("}").newLine();
    transpiler = transpiler.newInstanceTranspiler(new CategoryType(this.id));
    this.transpileMethods(transpiler);
    this.transpileGetterSetters(transpiler);
    transpiler.flush();

};


exports.NativeCategoryDeclaration = NativeCategoryDeclaration;

/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

var CategoryType = __webpack_require__(7).CategoryType;
var TypeUtils = __webpack_require__(83);
var Instance = __webpack_require__(1).Instance;
var DataStore = __webpack_require__(50).DataStore;

function NativeInstance(context, declaration, instance) {
    Instance.call(this,new CategoryType(declaration.id));
	this.declaration = declaration;
    this.storable = false;
    if(declaration.storable && DataStore.instance) {
        var categories = declaration.collectCategories(context);
        this.storable = DataStore.instance.newStorableDocument(categories, null);
    }
	this.instance = instance || this.makeInstance();
	return this;
}

NativeInstance.prototype = Object.create(Instance.prototype);
NativeInstance.prototype.constructor = NativeInstance;

NativeInstance.prototype.makeInstance = function() {
	var bound = this.declaration.getBoundFunction(true);
	return new bound();
};

NativeInstance.prototype.getType = function() {
	return new CategoryType(this.declaration.id);
};

// don't call getters from getters, so register them
// TODO: thread local storage

var activeGetters = {};

function getActiveGetters() {
    return activeGetters;
}

NativeInstance.prototype.getMemberValue = function(context, attrName) {
    var stacked = getActiveGetters()[attrName] || null;
    var first = stacked==null;
    if(first)
        getActiveGetters()[attrName] = context;
    try {
        return this.doGetMember(context, attrName, first);
    } finally {
        if(first) {
            delete getActiveGetters()[attrName];
        }
    }
};

NativeInstance.prototype.doGetMember = function(context, attrName, allowGetter) {
    var getter = allowGetter ? this.declaration.findGetter(context,attrName) : null;
    if(getter!=null) {
        context = context.newInstanceContext(this, null).newChildContext();
        return getter.interpret(context);
    } else {
        var value = this.instance[attrName];
        return TypeUtils.convertFromJavaScript(value);
    }
};

// don't call setters from setters, so register them
var activeSetters = {};

function getActiveSetters() {
    return activeSetters;
}

NativeInstance.prototype.setMember = function(context, attrName, value) {
    if(!this.mutable)
        throw new NotMutableError();
    var stacked = getActiveSetters()[attrName] || null;
    var first = stacked==null;
    if(first)
        getActiveSetters()[attrName] = context;
    try {
        this.doSetMember(context, attrName, value, first);
    } finally {
        if(first) {
            delete getActiveSetters()[attrName];
        }
    }
};

NativeInstance.prototype.doSetMember = function(context, attrName, value, allowSetter) {
    var decl = context.getRegisteredDeclaration(attrName);
    var setter = allowSetter ? this.declaration.findSetter(context,attrName) : null;
    if(setter!=null) {
        // use attribute name as parameter name for incoming value
        context = context.newInstanceContext(this, null).newChildContext();
        context.registerValue(new Variable(attrName, decl.getType()));
        context.setValue(attrName, value);
        value = setter.interpret(context);
    }
    if (this.storable && decl.storable) // TODO convert object graph if(value instanceof IInstance)
        this.storable.setData(attrName, value.getStorableData(), null);
	this.instance[attrName] = value.convertToJavaScript();
};


exports.NativeInstance = NativeInstance;


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var BooleanType = __webpack_require__(5).BooleanType;
var SetType = __webpack_require__(65).SetType;
var ListType = __webpack_require__(26).ListType;
var IntegerType = __webpack_require__(2).IntegerType;
var AnyType = __webpack_require__(14).AnyType;
var Identifier = __webpack_require__(0).Identifier;

function TupleType()  {
	NativeType.call(this, new Identifier("Tuple"));
	return this;
}

TupleType.prototype = Object.create(NativeType.prototype);
TupleType.prototype.constructor = TupleType;

TupleType.instance = new TupleType();

TupleType.prototype.withItemType = function(itemType) {
    return this;
};

TupleType.prototype.isAssignableFrom = function(context, other) {
    return ContainerType.prototype.isAssignableFrom.call(this, context, other)
        || (other instanceof ListType) || (other instanceof SetType);
};

TupleType.prototype.checkItem = function(context, other) {
	if(other==IntegerType.instance) {
		return AnyType.instance;
	} else {
		return NativeType.prototype.checkItem.call(this, context, other);
	}
};


TupleType.prototype.declareItem = function(transpiler, itemType, item) {
    if(itemType===IntegerType.instance) {
        item.declare(transpiler);
    } else {
        return ContainerType.prototype.declareItem.call(this, transpiler, itemType, item);
    }
};


TupleType.prototype.transpileItem = function(transpiler, itemType, item) {
    if(itemType===IntegerType.instance) {
        transpiler.append("[");
        item.transpile(transpiler);
        transpiler.append("-1]");
    } else {
        return ContainerType.prototype.transpileItem.call(this, transpiler, itemType, item);
    }
};


TupleType.prototype.transpileAssignItemValue = function(transpiler, item, expression) {
    transpiler.append(".setItem(");
    item.transpile(transpiler);
    transpiler.append(", ");
    expression.transpile(transpiler);
    transpiler.append(")");
};


TupleType.prototype.checkMember = function(context, section, name) {
	if ("count"==name) {
		return IntegerType.instance;
	} else {
		return NativeType.prototype.checkMember.call(this, context, section, name);
	}
};


TupleType.prototype.declareMember = function(transpiler, name) {
    if ("count" !== name) {
        return NativeType.prototype.declareMember.call(this, transpiler, name);
    }
};

TupleType.prototype.transpileMember = function(transpiler, name) {
    if ("count" == name) {
        transpiler.append("length");
    } else {
        return NativeType.prototype.transpileMember.call(this, transpiler, name);
    }
};


TupleType.prototype.checkAdd = function(context, other, tryReverse) {
	if(other === TupleType.instance || other instanceof ListType || other instanceof SetType) {
		return this;
	} else {
		return NativeType.prototype.checkAdd.call(this, context, other, tryReverse);
	}
};


TupleType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if(other === TupleType.instance || other instanceof ListType || other instanceof SetType) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else {
        return NativeType.prototype.declareAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};


TupleType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if(other === TupleType.instance || other instanceof ListType || other instanceof SetType) {
        left.transpile(transpiler);
        transpiler.append(".add(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else {
        return NativeType.prototype.transpileAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};


TupleType.prototype.checkContains = function(context, other) {
	return BooleanType.instance;
};


TupleType.prototype.declareContains = function(transpiler, other, container, item) {
    container.declare(transpiler);
    item.declare(transpiler);
};


TupleType.prototype.transpileContains = function(transpiler, other, container, item) {
    container.transpile(transpiler);
    transpiler.append(".includes(");
    item.transpile(transpiler);
    transpiler.append(")");
};



TupleType.prototype.declareContainsAllOrAny = function(transpiler, other, container, items) {
    var StrictSet = __webpack_require__(34).StrictSet;
    transpiler.require(StrictSet);
    container.declare(transpiler);
    items.declare(transpiler);
};


TupleType.prototype.transpileContainsAll = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAll(");
    items.transpile(transpiler);
    transpiler.append(")");
};

TupleType.prototype.transpileContainsAny = function(transpiler, other, container, items) {
    container.transpile(transpiler);
    transpiler.append(".hasAny(");
    items.transpile(transpiler);
    transpiler.append(")");
};


TupleType.prototype.checkContainsAllOrAny = function(context, other) {
	return BooleanType.instance;
};

exports.TupleType = TupleType;


/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

exports.DocumentType = __webpack_require__(55).DocumentType;
exports.BlobType = __webpack_require__(210).BlobType;
exports.BooleanType = __webpack_require__(5).BooleanType;
exports.CharacterType = __webpack_require__(31).CharacterType;
exports.ImageType = __webpack_require__(311).ImageType;
exports.IntegerType = __webpack_require__(2).IntegerType;
exports.DecimalType = __webpack_require__(23).DecimalType;
exports.DateTimeType = __webpack_require__(126).DateTimeType;
exports.DateType = __webpack_require__(127).DateType;
exports.TimeType = __webpack_require__(128).TimeType;
exports.PeriodType = __webpack_require__(86).PeriodType;
exports.VersionType = __webpack_require__(217).VersionType;
exports.ListType = __webpack_require__(26).ListType;
exports.DictionaryType = __webpack_require__(99).DictionaryType;
exports.CategoryType = __webpack_require__(7).CategoryType;
exports.ResourceType = __webpack_require__(105).ResourceType;
exports.TextType = __webpack_require__(6).TextType;
exports.IteratorType = __webpack_require__(162).IteratorType;
exports.CursorType = __webpack_require__(160).CursorType;
exports.RangeType = __webpack_require__(71).RangeType;
exports.MissingType = __webpack_require__(56).MissingType;
exports.AnyType = __webpack_require__(14).AnyType;
exports.CodeType = __webpack_require__(96).CodeType;
exports.UUIDType = __webpack_require__(166).UUIDType;
exports.JsxType = __webpack_require__(109).JsxType;
exports.CssType = __webpack_require__(219).CssType;
exports.HtmlType = __webpack_require__(465).HtmlType;

__webpack_require__(47).resolve();
__webpack_require__(6).resolve();
__webpack_require__(5).resolve();
__webpack_require__(23).resolve();
__webpack_require__(2).resolve();
__webpack_require__(31).resolve();
__webpack_require__(26).resolve();
__webpack_require__(71).resolve();
__webpack_require__(7).resolve();
__webpack_require__(55).resolve();
__webpack_require__(166).resolve();


/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var BooleanType = __webpack_require__(5).BooleanType;
var PeriodType = __webpack_require__(86).PeriodType;
var IntegerType = __webpack_require__(2).IntegerType;
var TextType = __webpack_require__(6).TextType;
var DateType = __webpack_require__(127).DateType;
var TimeType = __webpack_require__(128).TimeType;
var AnyType = __webpack_require__(14).AnyType;
var DateTime = __webpack_require__(204).DateTime;
var DateTimeValue = __webpack_require__(164).DateTimeValue;
var Identifier = __webpack_require__(0).Identifier;
var getTypeName = __webpack_require__(82).getTypeName;

function DateTimeType()  {
	NativeType.call(this, new Identifier("DateTime"));
	return this;
}

DateTimeType.prototype = Object.create(NativeType.prototype);
DateTimeType.prototype.constructor = DateTimeType;

DateTimeType.instance = new DateTimeType();

DateTimeType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
	var typeName = getTypeName(value);
	if (typeName=='DateTime') {
        return new DateTimeValue(value);
    } else if (typeName=='Date') {
        return new DateTimeValue(new DateTime(value, 0));
    } else {
        return value; // TODO for now
    }
};

DateTimeType.prototype.checkAdd = function(context, other, tryReverse) {
	if (other === PeriodType.instance) {
		return this;
	} else {
		return NativeType.prototype.checkAdd.call(this, context, other, tryReverse);
	}
};

DateTimeType.prototype.declare = function(transpiler) {
    transpiler.register(DateTime);
};


DateTimeType.prototype.transpile = function(transpiler) {
    transpiler.append('DateTime');
};


DateTimeType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if (other === PeriodType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareAdd.call(this, transpiler, other, tryReverse, left, right);
};

DateTimeType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if (other === PeriodType.instance) {
        left.transpile(transpiler);
        transpiler.append(".addPeriod(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileAdd.call(this, transpiler, other, tryReverse, left, right);
};

DateTimeType.prototype.checkSubtract = function(context, other) {
	if (other === PeriodType.instance) {
		return this;
	} else if(other === DateTimeType.instance) {
		return PeriodType.instance;
	} else {
		return NativeType.prototype.checkSubtract.call(this, context, other);
	}
};

DateTimeType.prototype.declareSubtract = function(transpiler, other, left, right) {
    if (other === PeriodType.instance || other === DateTimeType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareSubtract.call(this, transpiler, other, left, right);
};

DateTimeType.prototype.transpileSubtract = function(transpiler, other, left, right) {
    if (other === PeriodType.instance) {
        left.transpile(transpiler);
        transpiler.append(".subtractPeriod(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else if (other === DateTimeType.instance) {
        left.transpile(transpiler);
        transpiler.append(".subtractDateTime(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileSubtract.call(this, transpiler, other, left, right);
};


DateTimeType.prototype.checkCompare = function(context, other) {
	if(other === DateTimeType.instance || other instanceof DateType) {
		return BooleanType.instance;
	} else {
		return NativeType.prototype.checkCompare.call(this, context, other);
	}
};

DateTimeType.prototype.declareCompare = function(context, other) {
    // nothing to do
};

DateTimeType.prototype.transpileCompare = function(transpiler, other, operator, left, right) {
    left.transpile(transpiler);
    transpiler.append(".");
    operator.transpile(transpiler);
    transpiler.append("(");
    right.transpile(transpiler);
    transpiler.append(")");
};

DateTimeType.prototype.checkMember = function(context, section, name) {
	if ("year"==name) {
		return IntegerType.instance;
	} else if ("month"==name) {
		return IntegerType.instance;
	} else if ("dayOfMonth"==name) {
		return IntegerType.instance;
	} else if ("dayOfYear"==name) {
		return IntegerType.instance;
	} else if ("hour"==name) {
		return IntegerType.instance;
	} else if ("minute"==name) {
		return IntegerType.instance;
	} else if ("second"==name) {
		return IntegerType.instance;
	} else if ("millisecond"==name) {
		return IntegerType.instance;
	} else if ("tzOffset"==name) {
		return IntegerType.instance;
	} else if ("tzName"==name) {
		return TextType.instance;
	} else {
		return NativeType.prototype.checkMember.call(this, context, section, name);
	}
};


DateTimeType.prototype.declareMember = function(transpiler, name) {
    if (!("year"==name || "month"==name || "dayOfMonth"==name || "dayOfYear"==name || "hour"==name || "minute"==name || "second"==name || "millisecond"==name || "tzOffset"==name || "tzName"==name)) {
        NativeType.prototype.declareMember.call(this, transpiler, name);
    }
};


DateTimeType.prototype.transpileMember = function(transpiler, name) {
    if ("year"==name) {
        transpiler.append("getYear()");
    } else if ("month"==name) {
        transpiler.append("getMonth()");
    } else if ("dayOfMonth"==name) {
        transpiler.append("getDayOfMonth()");
    } else if ("dayOfYear"==name) {
        transpiler.append("getDayOfYear()");
    } else if ("hour"==name) {
        transpiler.append("getHour()");
    } else if ("minute"==name) {
        transpiler.append("getMinute()");
    } else if ("second"==name) {
        transpiler.append("getSecond()");
    } else if ("millisecond"==name) {
        transpiler.append("getMillisecond()");
    } else if ("tzOffset"==name) {
        transpiler.append("getTzOffset()");
    } else if ("tzName"==name) {
        transpiler.append("getTzName()");
    } else {
        NativeType.prototype.transpileMember.call(this, transpiler, name);
    }
};



DateTimeType.prototype.sort = function(context, list, desc) {

    function cmp(o1, o2) {
        return o1.CompareTo(context, o2);
    }

    return this.doSort(context, list, cmp, desc);
};




exports.DateTimeType = DateTimeType;


/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var BooleanType = __webpack_require__(5).BooleanType;
var PeriodType = __webpack_require__(86).PeriodType;
var IntegerType = __webpack_require__(2).IntegerType;
var RangeType = __webpack_require__(71).RangeType;
var AnyType = __webpack_require__(14).AnyType;
var DateRange = __webpack_require__(312).DateRange;
var DateValue = __webpack_require__(107).DateValue;
var Identifier = __webpack_require__(0).Identifier;
var DateTimeType = __webpack_require__(126).DateTimeType;
var LocalDate = __webpack_require__(120).LocalDate;
var getTypeName = __webpack_require__(82).getTypeName;

function DateType()  {
	NativeType.call(this, new Identifier("Date"));
	return this;
}

DateType.prototype = Object.create(NativeType.prototype);
DateType.prototype.constructor = DateType;

DateType.instance = new DateType();

DateType.prototype.declare = function(transpiler) {
    transpiler.require(LocalDate);
};


DateType.prototype.isAssignableFrom = function(context, other) {
	return NativeType.prototype.isAssignableFrom.call(this, context, other)
        || (other == DateTimeType.instance);
};

DateType.prototype.checkAdd = function(context, other, tryReverse) {
	if (other === PeriodType.instance) {
		return this; // ignore time section
	} else {
		return NativeType.prototype.checkAdd.call(this, context, other, tryReverse);
	}
};


DateType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
    if (getTypeName(value)=='LocalDate') {
        return new DateValue(value);
    } else {
        return value; // TODO for now
    }
};


DateType.prototype.declare = function(transpiler) {
    transpiler.register(LocalDate);
};


DateType.prototype.transpile = function(transpiler) {
    transpiler.append('Date');
};


DateType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if (other === PeriodType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareAdd.call(this, transpiler, other, tryReverse, left, right);
};

DateType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if (other === PeriodType.instance) {
        left.transpile(transpiler);
        transpiler.append(".addPeriod(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileAdd.call(this, transpiler, other, tryReverse, left, right);
};

DateType.prototype.checkSubtract = function(context, other) {
	if (other === PeriodType.instance) {
		return this; // ignore time section
	} else if (other === DateType.instance) {
		return PeriodType.instance;
	} else {
		return NativeType.prototype.checkSubtract.call(this, context, other);
	}
};


DateType.prototype.declareSubtract = function(transpiler, other, left, right) {
    if (other === PeriodType.instance || other === DateType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareSubtract.call(this, transpiler, other, left, right);
};

DateType.prototype.transpileSubtract = function(transpiler, other, left, right) {
    if (other === PeriodType.instance) {
        left.transpile(transpiler);
        transpiler.append(".subtractPeriod(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else if (other === DateType.instance) {
        left.transpile(transpiler);
        transpiler.append(".subtractDate(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileSubtract.call(this, transpiler, other, left, right);
};

DateType.prototype.checkCompare = function(context, other) {
	if (other === DateType.instance || other instanceof DateTimeType) {
		return BooleanType.instance;
	} else {
		return NativeType.prototype.checkCompare.call(this, context, other);
	}
};


DateType.prototype.declareCompare = function(context, other) {
    // nothing to do
};

DateType.prototype.transpileCompare = function(transpiler, other, operator, left, right) {
    left.transpile(transpiler);
    transpiler.append(".");
    operator.transpile(transpiler);
    transpiler.append("(");
    right.transpile(transpiler);
    transpiler.append(")");
};

DateType.prototype.checkRange = function(context, other) {
    if(other instanceof CharacterType) {
        return new RangeType(this);
    } else {
        return NativeType.prototype.checkRange.call(this, context, other);
    }
};


DateType.prototype.checkRange = function(context, other) {
	if (other === DateType.instance) {
		return new RangeType(this);
	} else {
		return Nativetype.prototype.checkRange.call(this, context, other);
	}
};


DateType.prototype.declareRange = function(transpiler, other) {
    if(other === DateType.instance) {
        var module = __webpack_require__(117);
        transpiler.require(module.Range);
        transpiler.require(module.DateRange);
    } else {
        return NativeType.prototype.declareRange.call(this, transpiler, other);
    }
};


DateType.prototype.transpileRange = function(transpiler, first, last) {
    transpiler.append("new DateRange(");
    first.transpile(transpiler);
    transpiler.append(",");
    last.transpile(transpiler);
    transpiler.append(")");
};


DateType.prototype.checkMember = function(context, section, name) {
	if ("year"==name) {
		return IntegerType.instance;
	} else if ("month"==name) {
		return IntegerType.instance;
	} else if ("dayOfMonth"==name) {
		return IntegerType.instance;
	} else if ("dayOfYear"==name) {
		return IntegerType.instance;
	} else {
		return NativeType.prototype.checkMember.call(this, context, section, name);
	}
};


DateType.prototype.declareMember = function(transpiler, name) {
    if (!("year"==name || "month"==name || "dayOfMonth"==name || "dayOfYear"==name)) {
        NativeType.prototype.declareMember.call(this, transpiler, name);
    }
};


DateType.prototype.transpileMember = function(transpiler, name) {
    if ("year"==name) {
        transpiler.append("getYear()");
    } else if ("month"==name) {
        transpiler.append("getMonth()");
    } else if ("dayOfMonth"==name) {
        transpiler.append("getDayOfMonth()");
    } else if ("dayOfYear"==name) {
        transpiler.append("getDayOfYear()");
    } else {
        NativeType.prototype.transpileMember.call(this, transpiler, name);
    }
};

DateType.prototype.newRange = function(left, right) {
	if (left instanceof DateValue && right instanceof DateValue) {
		return new DateRange(left, right);
	} else {
		return NativeType.prototype.newRange.call(this, left, right);
	}
};


exports.DateType = DateType;


/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var BooleanType = __webpack_require__(5).BooleanType;
var PeriodType = __webpack_require__(86).PeriodType;
var IntegerType = __webpack_require__(2).IntegerType;
var RangeType = __webpack_require__(71).RangeType;
var TimeRange = __webpack_require__(313).TimeRange;
var TimeValue = __webpack_require__(108).TimeValue;
var Identifier = __webpack_require__(0).Identifier;
var DateTimeType = __webpack_require__(126).DateTimeType;
var LocalTime = __webpack_require__(121).LocalTime;
var getTypeName = __webpack_require__(82).getTypeName;

function TimeType()  {
	NativeType.call(this, new Identifier("TimeValue"));
	return this;
}

TimeType.prototype = Object.create(NativeType.prototype);
TimeType.prototype.constructor = TimeType;

TimeType.instance = new TimeType();

TimeType.prototype.declare = function(transpiler) {
    transpiler.require(LocalTime);
};


TimeType.prototype.isAssignableFrom = function(context, other) {
    return NativeType.prototype.isAssignableFrom.call(this, context, other)
        || (other == DateTimeType.instance);
};


TimeType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
    if (getTypeName(value)=='LocalTime') {
        return new TimeValue(value);
    } else {
        return value; // TODO for now
    }
};


TimeType.prototype.checkAdd = function(context, other, tryReverse) {
	if (other === PeriodType.instance) {
		return this; // ignore date section
	} else {
		return NativeType.prototype.checkAdd.call(this, context, other, tryReverse);
	}
};


TimeType.prototype.declare = function(transpiler) {
    transpiler.register(LocalTime);
};


TimeType.prototype.transpile = function(transpiler) {
    transpiler.append('Time');
};


TimeType.prototype.declareAdd = function(transpiler, other, tryReverse, left, right) {
    if (other === PeriodType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else {
        return NativeType.prototype.declareAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};


TimeType.prototype.transpileAdd = function(transpiler, other, tryReverse, left, right) {
    if (other === PeriodType.instance) {
        left.transpile(transpiler);
        transpiler.append(".addPeriod(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else {
        return NativeType.prototype.transpileAdd.call(this, transpiler, other, tryReverse, left, right);
    }
};


TimeType.prototype.checkSubtract = function(context, other) {
	if (other === TimeType.instance) {
		return PeriodType.instance; // ignore date section
	} else if (other === PeriodType.instance) {
		return this; // ignore date section
	} else {
		return NativeType.prototype.checkSubtract.call(this, context, other);
	}
};

TimeType.prototype.declareSubtract = function(transpiler, other, left, right) {
    if (other === TimeType.instance || other === PeriodType.instance) {
        left.declare(transpiler);
        right.declare(transpiler);
    } else
        return NativeType.prototype.declareSubtract.call(this, transpiler, other, left, right);
};

TimeType.prototype.transpileSubtract = function(transpiler, other, left, right) {
    if (other === TimeType.instance) {
        left.transpile(transpiler);
        transpiler.append(".subtractTime(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else if (other === PeriodType.instance) {
        left.transpile(transpiler);
        transpiler.append(".subtractPeriod(");
        right.transpile(transpiler);
        transpiler.append(")");
    } else
        return NativeType.prototype.transpileSubtract.call(this, transpiler, other, left, right);
};


TimeType.prototype.checkCompare = function(context, other) {
	if (other === TimeType.instance) {
		return BooleanType.instance;
	} else {
		return NativeType.prototype.checkCompare.call(this, context, other);
	}
};


TimeType.prototype.declareCompare = function(context, other) {
    // nothing to do
};

TimeType.prototype.transpileCompare = function(transpiler, other, operator, left, right) {
    left.transpile(transpiler);
    transpiler.append(".");
    operator.transpile(transpiler);
    transpiler.append("(");
    right.transpile(transpiler);
    transpiler.append(")");
};


TimeType.prototype.checkRange = function(context, other) {
	if (other === TimeType.instance) {
		return new RangeType(this);
	} else {
		return NativeType.prototype.checkRange.call(this, context, other);
	}
};


TimeType.prototype.declareRange = function(transpiler, other) {
    if(other === TimeType.instance) {
        var module = __webpack_require__(117);
        transpiler.require(module.Range);
        transpiler.require(module.TimeRange);
    } else {
        return NativeType.prototype.declareRange.call(this, transpiler, other);
    }
};


TimeType.prototype.transpileRange = function(transpiler, first, last) {
    transpiler.append("new TimeRange(");
    first.transpile(transpiler);
    transpiler.append(",");
    last.transpile(transpiler);
    transpiler.append(")");
};


TimeType.prototype.checkMember = function (context, section, name) {
	if ("hour" == name) {
		return IntegerType.instance;
	} else if ("minute" == name) {
		return IntegerType.instance;
	} else if ("second" == name) {
		return IntegerType.instance;
	} else if ("millisecond" == name) {
		return IntegerType.instance;
	} else {
		return NativeType.prototype.checkMember.call(this, context, section, name);
	}
};


TimeType.prototype.declareMember = function(transpiler, name) {
    if (!("hour"===name || "minute"===name || "second"===name || "millisecond"===name)) {
        NativeType.prototype.declareMember.call(this, transpiler, name);
    }
};


TimeType.prototype.transpileMember = function(transpiler, name) {
    if ("hour"==name) {
        transpiler.append("getHour()");
    } else if ("minute"==name) {
        transpiler.append("getMinute()");
    } else if ("second"==name) {
        transpiler.append("getSecond()");
    } else if ("millisecond"==name) {
        transpiler.append("getMillisecond()");
    } else {
        NativeType.prototype.transpileMember.call(this, transpiler, name);
    }
};


TimeType.prototype.newRange = function(left, right) {
	if (left instanceof TimeValue && right instanceof TimeValue) {
		return new TimeRange(left, right);
	} else {
		return NativeType.prototype.newRange.call(this, left, right);
	}
};


TimeType.prototype.toString = function(value) {
	return "'" + value.toString() + "'";
};


exports.TimeType = TimeType;

/***/ }),
/* 129 */
/***/ (function(module, exports) {

function JavaScriptExpression() {
}

exports.JavaScriptExpression = JavaScriptExpression;

/***/ }),
/* 130 */
/***/ (function(module, exports) {

function JavaScriptLiteral(text) {
    this.text = text;
    this.value = eval(text);
    return this;
}

JavaScriptLiteral.prototype.interpret = function(context) {
    return this.value;
};

JavaScriptLiteral.prototype.toString = function() {
    return this.text;
};

JavaScriptLiteral.prototype.toDialect = function(writer) {
    writer.append(this.text);
};


JavaScriptLiteral.prototype.transpile = function(transpiler) {
    transpiler.append(this.text);
};

exports.JavaScriptLiteral = JavaScriptLiteral;


/***/ }),
/* 131 */
/***/ (function(module, exports) {

JavaLiteral = function(text) {
    this.text = text;
    return this;
};

JavaLiteral.prototype.toString = function() {
    return this.text;
};

JavaLiteral.prototype.toDialect = function(writer) {
    writer.append(this.text);
};


exports.JavaLiteral = JavaLiteral

/***/ }),
/* 132 */
/***/ (function(module, exports) {

function CSharpLiteral(text) {
    this.text = text;
    return this;
}


CSharpLiteral.prototype.toDialect = function(writer) {
    return writer.append(this.text);
};


exports.CSharpLiteral = CSharpLiteral;


/***/ }),
/* 133 */
/***/ (function(module, exports) {

function PythonLiteral(text) {
    this.text = text;
    return this;
}

PythonLiteral.prototype.toString = function() {
    return this.text;
};

PythonLiteral.prototype.toDialect = function(writer) {
    writer.append(this.text);
};

exports.PythonLiteral = PythonLiteral;

/***/ }),
/* 134 */
/***/ (function(module, exports, __webpack_require__) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
///

// A tuple: (ATN state, predicted alt, syntactic, semantic context).
//  The syntactic context is a graph-structured stack node whose
//  path(s) to the root is the rule invocation(s)
//  chain used to arrive at the state.  The semantic context is
//  the tree of semantic predicates encountered before reaching
//  an ATN state.
///

var DecisionState = __webpack_require__(42).DecisionState;
var SemanticContext = __webpack_require__(88).SemanticContext;
var Hash = __webpack_require__(13).Hash;


function checkParams(params, isCfg) {
	if(params===null) {
		var result = { state:null, alt:null, context:null, semanticContext:null };
		if(isCfg) {
			result.reachesIntoOuterContext = 0;
		}
		return result;
	} else {
		var props = {};
		props.state = params.state || null;
		props.alt = (params.alt === undefined) ? null : params.alt;
		props.context = params.context || null;
		props.semanticContext = params.semanticContext || null;
		if(isCfg) {
			props.reachesIntoOuterContext = params.reachesIntoOuterContext || 0;
			props.precedenceFilterSuppressed = params.precedenceFilterSuppressed || false;
		}
		return props;
	}
}

function ATNConfig(params, config) {
	this.checkContext(params, config);
	params = checkParams(params);
	config = checkParams(config, true);
    // The ATN state associated with this configuration///
    this.state = params.state!==null ? params.state : config.state;
    // What alt (or lexer rule) is predicted by this configuration///
    this.alt = params.alt!==null ? params.alt : config.alt;
    // The stack of invoking states leading to the rule/states associated
    //  with this config.  We track only those contexts pushed during
    //  execution of the ATN simulator.
    this.context = params.context!==null ? params.context : config.context;
    this.semanticContext = params.semanticContext!==null ? params.semanticContext :
        (config.semanticContext!==null ? config.semanticContext : SemanticContext.NONE);
    // We cannot execute predicates dependent upon local context unless
    // we know for sure we are in the correct context. Because there is
    // no way to do this efficiently, we simply cannot evaluate
    // dependent predicates unless we are in the rule that initially
    // invokes the ATN simulator.
    //
    // closure() tracks the depth of how far we dip into the
    // outer context: depth &gt; 0.  Note that it may not be totally
    // accurate depth since I don't ever decrement. TODO: make it a boolean then
    this.reachesIntoOuterContext = config.reachesIntoOuterContext;
    this.precedenceFilterSuppressed = config.precedenceFilterSuppressed;
    return this;
}

ATNConfig.prototype.checkContext = function(params, config) {
	if((params.context===null || params.context===undefined) &&
			(config===null || config.context===null || config.context===undefined)) {
		this.context = null;
	}
};


ATNConfig.prototype.hashCode = function() {
    var hash = new Hash();
    this.updateHashCode(hash);
    return hash.finish();
};


ATNConfig.prototype.updateHashCode = function(hash) {
    hash.update(this.state.stateNumber, this.alt, this.context, this.semanticContext);
};

// An ATN configuration is equal to another if both have
//  the same state, they predict the same alternative, and
//  syntactic/semantic contexts are the same.

ATNConfig.prototype.equals = function(other) {
    if (this === other) {
        return true;
    } else if (! (other instanceof ATNConfig)) {
        return false;
    } else {
        return this.state.stateNumber===other.state.stateNumber &&
            this.alt===other.alt &&
            (this.context===null ? other.context===null : this.context.equals(other.context)) &&
            this.semanticContext.equals(other.semanticContext) &&
            this.precedenceFilterSuppressed===other.precedenceFilterSuppressed;
    }
};


ATNConfig.prototype.hashCodeForConfigSet = function() {
    var hash = new Hash();
    hash.update(this.state.stateNumber, this.alt, this.semanticContext);
    return hash.finish();
};


ATNConfig.prototype.equalsForConfigSet = function(other) {
    if (this === other) {
        return true;
    } else if (! (other instanceof ATNConfig)) {
        return false;
    } else {
        return this.state.stateNumber===other.state.stateNumber &&
            this.alt===other.alt &&
            this.semanticContext.equals(other.semanticContext);
    }
};


ATNConfig.prototype.toString = function() {
    return "(" + this.state + "," + this.alt +
        (this.context!==null ? ",[" + this.context.toString() + "]" : "") +
        (this.semanticContext !== SemanticContext.NONE ?
                ("," + this.semanticContext.toString())
                : "") +
        (this.reachesIntoOuterContext>0 ?
                (",up=" + this.reachesIntoOuterContext)
                : "") + ")";
};


function LexerATNConfig(params, config) {
	ATNConfig.call(this, params, config);

    // This is the backing field for {@link //getLexerActionExecutor}.
	var lexerActionExecutor = params.lexerActionExecutor || null;
    this.lexerActionExecutor = lexerActionExecutor || (config!==null ? config.lexerActionExecutor : null);
    this.passedThroughNonGreedyDecision = config!==null ? this.checkNonGreedyDecision(config, this.state) : false;
    return this;
}

LexerATNConfig.prototype = Object.create(ATNConfig.prototype);
LexerATNConfig.prototype.constructor = LexerATNConfig;

LexerATNConfig.prototype.updateHashCode = function(hash) {
    hash.update(this.state.stateNumber, this.alt, this.context, this.semanticContext, this.passedThroughNonGreedyDecision, this.lexerActionExecutor);
};

LexerATNConfig.prototype.equals = function(other) {
    return this === other ||
            (other instanceof LexerATNConfig &&
            this.passedThroughNonGreedyDecision == other.passedThroughNonGreedyDecision &&
            (this.lexerActionExecutor ? this.lexerActionExecutor.equals(other.lexerActionExecutor) : !other.lexerActionExecutor) &&
            ATNConfig.prototype.equals.call(this, other));
};

LexerATNConfig.prototype.hashCodeForConfigSet = LexerATNConfig.prototype.hashCode;

LexerATNConfig.prototype.equalsForConfigSet = LexerATNConfig.prototype.equals;


LexerATNConfig.prototype.checkNonGreedyDecision = function(source, target) {
    return source.passedThroughNonGreedyDecision ||
        (target instanceof DecisionState) && target.nonGreedy;
};

exports.ATNConfig = ATNConfig;
exports.LexerATNConfig = LexerATNConfig;

/***/ }),
/* 135 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
///

//  A rule context is a record of a single rule invocation. It knows
//  which context invoked it, if any. If there is no parent context, then
//  naturally the invoking state is not valid.  The parent link
//  provides a chain upwards from the current rule invocation to the root
//  of the invocation tree, forming a stack. We actually carry no
//  information about the rule associated with this context (except
//  when parsing). We keep only the state number of the invoking state from
//  the ATN submachine that invoked this. Contrast this with the s
//  pointer inside ParserRuleContext that tracks the current state
//  being "executed" for the current rule.
//
//  The parent contexts are useful for computing lookahead sets and
//  getting error information.
//
//  These objects are used during parsing and prediction.
//  For the special case of parsers, we use the subclass
//  ParserRuleContext.
//
//  @see ParserRuleContext
///

var RuleNode = __webpack_require__(43).RuleNode;
var INVALID_INTERVAL = __webpack_require__(43).INVALID_INTERVAL;
var INVALID_ALT_NUMBER = __webpack_require__(58).INVALID_ALT_NUMBER;

function RuleContext(parent, invokingState) {
	RuleNode.call(this);
	// What context invoked this rule?
	this.parentCtx = parent || null;
	// What state invoked the rule associated with this context?
	// The "return address" is the followState of invokingState
	// If parent is null, this should be -1.
	this.invokingState = invokingState || -1;
	return this;
}

RuleContext.prototype = Object.create(RuleNode.prototype);
RuleContext.prototype.constructor = RuleContext;

RuleContext.prototype.depth = function() {
	var n = 0;
	var p = this;
	while (p !== null) {
		p = p.parentCtx;
		n += 1;
	}
	return n;
};

// A context is empty if there is no invoking state; meaning nobody call
// current context.
RuleContext.prototype.isEmpty = function() {
	return this.invokingState === -1;
};

// satisfy the ParseTree / SyntaxTree interface

RuleContext.prototype.getSourceInterval = function() {
	return INVALID_INTERVAL;
};

RuleContext.prototype.getRuleContext = function() {
	return this;
};

RuleContext.prototype.getPayload = function() {
	return this;
};

// Return the combined text of all child nodes. This method only considers
// tokens which have been added to the parse tree.
// <p>
// Since tokens on hidden channels (e.g. whitespace or comments) are not
// added to the parse trees, they will not appear in the output of this
// method.
// /
RuleContext.prototype.getText = function() {
	if (this.getChildCount() === 0) {
		return "";
	} else {
		return this.children.map(function(child) {
			return child.getText();
		}).join("");
	}
};

// For rule associated with this parse tree internal node, return
// the outer alternative number used to match the input. Default
// implementation does not compute nor store this alt num. Create
// a subclass of ParserRuleContext with backing field and set
// option contextSuperClass.
// to set it.
RuleContext.prototype.getAltNumber = function() { return INVALID_ALT_NUMBER; }

// Set the outer alternative number for this context node. Default
// implementation does nothing to avoid backing field overhead for
// trees that don't need it.  Create
// a subclass of ParserRuleContext with backing field and set
// option contextSuperClass.
RuleContext.prototype.setAltNumber = function(altNumber) { }

RuleContext.prototype.getChild = function(i) {
	return null;
};

RuleContext.prototype.getChildCount = function() {
	return 0;
};

RuleContext.prototype.accept = function(visitor) {
	return visitor.visitChildren(this);
};

//need to manage circular dependencies, so export now
exports.RuleContext = RuleContext;
var Trees = __webpack_require__(237).Trees;


// Print out a whole tree, not just a node, in LISP format
// (root child1 .. childN). Print just a node if this is a leaf.
//

RuleContext.prototype.toStringTree = function(ruleNames, recog) {
	return Trees.toStringTree(this, ruleNames, recog);
};

RuleContext.prototype.toString = function(ruleNames, stop) {
	ruleNames = ruleNames || null;
	stop = stop || null;
	var p = this;
	var s = "[";
	while (p !== null && p !== stop) {
		if (ruleNames === null) {
			if (!p.isEmpty()) {
				s += p.invokingState;
			}
		} else {
			var ri = p.ruleIndex;
			var ruleName = (ri >= 0 && ri < ruleNames.length) ? ruleNames[ri]
					: "" + ri;
			s += ruleName;
		}
		if (p.parentCtx !== null && (ruleNames !== null || !p.parentCtx.isEmpty())) {
			s += " ";
		}
		p = p.parentCtx;
	}
	s += "]";
	return s;
};



/***/ }),
/* 136 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
///

// A lexer is recognizer that draws input symbols from a character stream.
//  lexer grammars result in a subclass of this object. A Lexer object
//  uses simplified match() and error recovery mechanisms in the interest of speed.

var Token = __webpack_require__(18).Token;
var Recognizer = __webpack_require__(241).Recognizer;
var CommonTokenFactory = __webpack_require__(344).CommonTokenFactory;
var RecognitionException  = __webpack_require__(44).RecognitionException;
var LexerNoViableAltException = __webpack_require__(44).LexerNoViableAltException;

function TokenSource() {
	return this;
}

function Lexer(input) {
	Recognizer.call(this);
	this._input = input;
	this._factory = CommonTokenFactory.DEFAULT;
	this._tokenFactorySourcePair = [ this, input ];

	this._interp = null; // child classes must populate this

	// The goal of all lexer rules/methods is to create a token object.
	// this is an instance variable as multiple rules may collaborate to
	// create a single token. nextToken will return this object after
	// matching lexer rule(s). If you subclass to allow multiple token
	// emissions, then set this to the last token to be matched or
	// something nonnull so that the auto token emit mechanism will not
	// emit another token.
	this._token = null;

	// What character index in the stream did the current token start at?
	// Needed, for example, to get the text for current token. Set at
	// the start of nextToken.
	this._tokenStartCharIndex = -1;

	// The line on which the first character of the token resides///
	this._tokenStartLine = -1;

	// The character position of first character within the line///
	this._tokenStartColumn = -1;

	// Once we see EOF on char stream, next token will be EOF.
	// If you have DONE : EOF ; then you see DONE EOF.
	this._hitEOF = false;

	// The channel number for the current token///
	this._channel = Token.DEFAULT_CHANNEL;

	// The token type for the current token///
	this._type = Token.INVALID_TYPE;

	this._modeStack = [];
	this._mode = Lexer.DEFAULT_MODE;

	// You can set the text for the current token to override what is in
	// the input char buffer. Use setText() or can set this instance var.
	// /
	this._text = null;

	return this;
}

Lexer.prototype = Object.create(Recognizer.prototype);
Lexer.prototype.constructor = Lexer;

Lexer.DEFAULT_MODE = 0;
Lexer.MORE = -2;
Lexer.SKIP = -3;

Lexer.DEFAULT_TOKEN_CHANNEL = Token.DEFAULT_CHANNEL;
Lexer.HIDDEN = Token.HIDDEN_CHANNEL;
Lexer.MIN_CHAR_VALUE = 0x0000;
Lexer.MAX_CHAR_VALUE = 0x10FFFF;

Lexer.prototype.reset = function() {
	// wack Lexer state variables
	if (this._input !== null) {
		this._input.seek(0); // rewind the input
	}
	this._token = null;
	this._type = Token.INVALID_TYPE;
	this._channel = Token.DEFAULT_CHANNEL;
	this._tokenStartCharIndex = -1;
	this._tokenStartColumn = -1;
	this._tokenStartLine = -1;
	this._text = null;

	this._hitEOF = false;
	this._mode = Lexer.DEFAULT_MODE;
	this._modeStack = [];

	this._interp.reset();
};

// Return a token from this source; i.e., match a token on the char stream.
Lexer.prototype.nextToken = function() {
	if (this._input === null) {
		throw "nextToken requires a non-null input stream.";
	}

	// Mark start location in char stream so unbuffered streams are
	// guaranteed at least have text of current token
	var tokenStartMarker = this._input.mark();
	try {
		while (true) {
			if (this._hitEOF) {
				this.emitEOF();
				return this._token;
			}
			this._token = null;
			this._channel = Token.DEFAULT_CHANNEL;
			this._tokenStartCharIndex = this._input.index;
			this._tokenStartColumn = this._interp.column;
			this._tokenStartLine = this._interp.line;
			this._text = null;
			var continueOuter = false;
			while (true) {
				this._type = Token.INVALID_TYPE;
				var ttype = Lexer.SKIP;
				try {
					ttype = this._interp.match(this._input, this._mode);
				} catch (e) {
				    if(e instanceof RecognitionException) {
                        this.notifyListeners(e); // report error
                        this.recover(e);
                    } else {
                        console.log(e.stack);
                        throw e;
                    }
				}
				if (this._input.LA(1) === Token.EOF) {
					this._hitEOF = true;
				}
				if (this._type === Token.INVALID_TYPE) {
					this._type = ttype;
				}
				if (this._type === Lexer.SKIP) {
					continueOuter = true;
					break;
				}
				if (this._type !== Lexer.MORE) {
					break;
				}
			}
			if (continueOuter) {
				continue;
			}
			if (this._token === null) {
				this.emit();
			}
			return this._token;
		}
	} finally {
		// make sure we release marker after match or
		// unbuffered char stream will keep buffering
		this._input.release(tokenStartMarker);
	}
};

// Instruct the lexer to skip creating a token for current lexer rule
// and look for another token. nextToken() knows to keep looking when
// a lexer rule finishes with token set to SKIP_TOKEN. Recall that
// if token==null at end of any token rule, it creates one for you
// and emits it.
// /
Lexer.prototype.skip = function() {
	this._type = Lexer.SKIP;
};

Lexer.prototype.more = function() {
	this._type = Lexer.MORE;
};

Lexer.prototype.mode = function(m) {
	this._mode = m;
};

Lexer.prototype.pushMode = function(m) {
	if (this._interp.debug) {
		console.log("pushMode " + m);
	}
	this._modeStack.push(this._mode);
	this.mode(m);
};

Lexer.prototype.popMode = function() {
	if (this._modeStack.length === 0) {
		throw "Empty Stack";
	}
	if (this._interp.debug) {
		console.log("popMode back to " + this._modeStack.slice(0, -1));
	}
	this.mode(this._modeStack.pop());
	return this._mode;
};

// Set the char stream and reset the lexer
Object.defineProperty(Lexer.prototype, "inputStream", {
	get : function() {
		return this._input;
	},
	set : function(input) {
		this._input = null;
		this._tokenFactorySourcePair = [ this, this._input ];
		this.reset();
		this._input = input;
		this._tokenFactorySourcePair = [ this, this._input ];
	}
});

Object.defineProperty(Lexer.prototype, "sourceName", {
	get : function sourceName() {
		return this._input.sourceName;
	}
});

// By default does not support multiple emits per nextToken invocation
// for efficiency reasons. Subclass and override this method, nextToken,
// and getToken (to push tokens into a list and pull from that list
// rather than a single variable as this implementation does).
// /
Lexer.prototype.emitToken = function(token) {
	this._token = token;
};

// The standard method called to automatically emit a token at the
// outermost lexical rule. The token object should point into the
// char buffer start..stop. If there is a text override in 'text',
// use that to set the token's text. Override this method to emit
// custom Token objects or provide a new factory.
// /
Lexer.prototype.emit = function() {
	var t = this._factory.create(this._tokenFactorySourcePair, this._type,
			this._text, this._channel, this._tokenStartCharIndex, this
					.getCharIndex() - 1, this._tokenStartLine,
			this._tokenStartColumn);
	this.emitToken(t);
	return t;
};

Lexer.prototype.emitEOF = function() {
	var cpos = this.column;
	var lpos = this.line;
	var eof = this._factory.create(this._tokenFactorySourcePair, Token.EOF,
			null, Token.DEFAULT_CHANNEL, this._input.index,
			this._input.index - 1, lpos, cpos);
	this.emitToken(eof);
	return eof;
};

Object.defineProperty(Lexer.prototype, "type", {
	get : function() {
		return this.type;
	},
	set : function(type) {
		this._type = type;
	}
});

Object.defineProperty(Lexer.prototype, "line", {
	get : function() {
		return this._interp.line;
	},
	set : function(line) {
		this._interp.line = line;
	}
});

Object.defineProperty(Lexer.prototype, "column", {
	get : function() {
		return this._interp.column;
	},
	set : function(column) {
		this._interp.column = column;
	}
});


// What is the index of the current character of lookahead?///
Lexer.prototype.getCharIndex = function() {
	return this._input.index;
};

// Return the text matched so far for the current token or any text override.
//Set the complete text of this token; it wipes any previous changes to the text.
Object.defineProperty(Lexer.prototype, "text", {
	get : function() {
		if (this._text !== null) {
			return this._text;
		} else {
			return this._interp.getText(this._input);
		}
	},
	set : function(text) {
		this._text = text;
	}
});
// Return a list of all Token objects in input char stream.
// Forces load of all tokens. Does not include EOF token.
// /
Lexer.prototype.getAllTokens = function() {
	var tokens = [];
	var t = this.nextToken();
	while (t.type !== Token.EOF) {
		tokens.push(t);
		t = this.nextToken();
	}
	return tokens;
};

Lexer.prototype.notifyListeners = function(e) {
	var start = this._tokenStartCharIndex;
	var stop = this._input.index;
	var text = this._input.getText(start, stop);
	var msg = "token recognition error at: '" + this.getErrorDisplay(text) + "'";
	var listener = this.getErrorListenerDispatch();
	listener.syntaxError(this, null, this._tokenStartLine,
			this._tokenStartColumn, msg, e);
};

Lexer.prototype.getErrorDisplay = function(s) {
	var d = [];
	for (var i = 0; i < s.length; i++) {
		d.push(s[i]);
	}
	return d.join('');
};

Lexer.prototype.getErrorDisplayForChar = function(c) {
	if (c.charCodeAt(0) === Token.EOF) {
		return "<EOF>";
	} else if (c === '\n') {
		return "\\n";
	} else if (c === '\t') {
		return "\\t";
	} else if (c === '\r') {
		return "\\r";
	} else {
		return c;
	}
};

Lexer.prototype.getCharErrorDisplay = function(c) {
	return "'" + this.getErrorDisplayForChar(c) + "'";
};

// Lexers can normally match any char in it's vocabulary after matching
// a token, so do the easy thing and just kill a character and hope
// it all works out. You can instead use the rule invocation stack
// to do sophisticated error recovery if you are in a fragment rule.
// /
Lexer.prototype.recover = function(re) {
	if (this._input.LA(1) !== Token.EOF) {
		if (re instanceof LexerNoViableAltException) {
			// skip a char and try again
			this._interp.consume(this._input);
		} else {
			// TODO: Do we lose character or line position information?
			this._input.consume();
		}
	}
};

exports.Lexer = Lexer;


/***/ }),
/* 137 */
/***/ (function(module, exports) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

// Provides an empty default implementation of {@link ANTLRErrorListener}. The
// default implementation of each method does nothing, but can be overridden as
// necessary.

function ErrorListener() {
	return this;
}

ErrorListener.prototype.syntaxError = function(recognizer, offendingSymbol, line, column, msg, e) {
};

ErrorListener.prototype.reportAmbiguity = function(recognizer, dfa, startIndex, stopIndex, exact, ambigAlts, configs) {
};

ErrorListener.prototype.reportAttemptingFullContext = function(recognizer, dfa, startIndex, stopIndex, conflictingAlts, configs) {
};

ErrorListener.prototype.reportContextSensitivity = function(recognizer, dfa, startIndex, stopIndex, prediction, configs) {
};

function ConsoleErrorListener() {
	ErrorListener.call(this);
	return this;
}

ConsoleErrorListener.prototype = Object.create(ErrorListener.prototype);
ConsoleErrorListener.prototype.constructor = ConsoleErrorListener;

//
// Provides a default instance of {@link ConsoleErrorListener}.
//
ConsoleErrorListener.INSTANCE = new ConsoleErrorListener();

//
// {@inheritDoc}
//
// <p>
// This implementation prints messages to {@link System//err} containing the
// values of {@code line}, {@code charPositionInLine}, and {@code msg} using
// the following format.</p>
//
// <pre>
// line <em>line</em>:<em>charPositionInLine</em> <em>msg</em>
// </pre>
//
ConsoleErrorListener.prototype.syntaxError = function(recognizer, offendingSymbol, line, column, msg, e) {
    console.error("line " + line + ":" + column + " " + msg);
};

function ProxyErrorListener(delegates) {
	ErrorListener.call(this);
    if (delegates===null) {
        throw "delegates";
    }
    this.delegates = delegates;
	return this;
}

ProxyErrorListener.prototype = Object.create(ErrorListener.prototype);
ProxyErrorListener.prototype.constructor = ProxyErrorListener;

ProxyErrorListener.prototype.syntaxError = function(recognizer, offendingSymbol, line, column, msg, e) {
    this.delegates.map(function(d) { d.syntaxError(recognizer, offendingSymbol, line, column, msg, e); });
};

ProxyErrorListener.prototype.reportAmbiguity = function(recognizer, dfa, startIndex, stopIndex, exact, ambigAlts, configs) {
    this.delegates.map(function(d) { d.reportAmbiguity(recognizer, dfa, startIndex, stopIndex, exact, ambigAlts, configs); });
};

ProxyErrorListener.prototype.reportAttemptingFullContext = function(recognizer, dfa, startIndex, stopIndex, conflictingAlts, configs) {
	this.delegates.map(function(d) { d.reportAttemptingFullContext(recognizer, dfa, startIndex, stopIndex, conflictingAlts, configs); });
};

ProxyErrorListener.prototype.reportContextSensitivity = function(recognizer, dfa, startIndex, stopIndex, prediction, configs) {
	this.delegates.map(function(d) { d.reportContextSensitivity(recognizer, dfa, startIndex, stopIndex, prediction, configs); });
};

exports.ErrorListener = ErrorListener;
exports.ConsoleErrorListener = ConsoleErrorListener;
exports.ProxyErrorListener = ProxyErrorListener;



/***/ }),
/* 138 */
/***/ (function(module, exports) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

// A DFA walker that knows how to dump them to serialized strings.#/


function DFASerializer(dfa, literalNames, symbolicNames) {
	this.dfa = dfa;
	this.literalNames = literalNames || [];
	this.symbolicNames = symbolicNames || [];
	return this;
}

DFASerializer.prototype.toString = function() {
   if(this.dfa.s0 === null) {
       return null;
   }
   var buf = "";
   var states = this.dfa.sortedStates();
   for(var i=0;i<states.length;i++) {
       var s = states[i];
       if(s.edges!==null) {
            var n = s.edges.length;
            for(var j=0;j<n;j++) {
                var t = s.edges[j] || null;
                if(t!==null && t.stateNumber !== 0x7FFFFFFF) {
                    buf = buf.concat(this.getStateString(s));
                    buf = buf.concat("-");
                    buf = buf.concat(this.getEdgeLabel(j));
                    buf = buf.concat("->");
                    buf = buf.concat(this.getStateString(t));
                    buf = buf.concat('\n');
                }
            }
       }
   }
   return buf.length===0 ? null : buf;
};

DFASerializer.prototype.getEdgeLabel = function(i) {
    if (i===0) {
        return "EOF";
    } else if(this.literalNames !==null || this.symbolicNames!==null) {
        return this.literalNames[i-1] || this.symbolicNames[i-1];
    } else {
        return String.fromCharCode(i-1);
    }
};

DFASerializer.prototype.getStateString = function(s) {
    var baseStateStr = ( s.isAcceptState ? ":" : "") + "s" + s.stateNumber + ( s.requiresFullContext ? "^" : "");
    if(s.isAcceptState) {
        if (s.predicates !== null) {
            return baseStateStr + "=>" + s.predicates.toString();
        } else {
            return baseStateStr + "=>" + s.prediction.toString();
        }
    } else {
        return baseStateStr;
    }
};

function LexerDFASerializer(dfa) {
	DFASerializer.call(this, dfa, null);
	return this;
}

LexerDFASerializer.prototype = Object.create(DFASerializer.prototype);
LexerDFASerializer.prototype.constructor = LexerDFASerializer;

LexerDFASerializer.prototype.getEdgeLabel = function(i) {
	return "'" + String.fromCharCode(i) + "'";
};

exports.DFASerializer = DFASerializer;
exports.LexerDFASerializer = LexerDFASerializer;



/***/ }),
/* 139 */
/***/ (function(module, exports, __webpack_require__) {

var ObjectList = __webpack_require__(22).ObjectList;

function ExpressionList(items, item) {
    ObjectList.call(this, items, item);
    return this;
}

ExpressionList.prototype = Object.create(ObjectList.prototype);
ExpressionList.prototype.constructor = ExpressionList;

ExpressionList.prototype.toDialect = function(writer) {
    if (this.length > 0) {
        for (var i = 0; i < this.length; i++) {
            this[i].toDialect(writer);
            writer.append(", ");
        }
        writer.trimLast(2);
    }
};

ExpressionList.prototype.declare = function(transpiler) {
    this.forEach(function(item){
        item.declare(transpiler);
    });
};


ExpressionList.prototype.transpile = function(transpiler) {
    if (this.length > 0) {
        for (var i = 0; i < this.length; i++) {
            this[i].transpile(transpiler);
            transpiler.append(", ");
        }
        transpiler.trimLast(2);
    }
};

exports.ExpressionList = ExpressionList;

/***/ }),
/* 140 */
/***/ (function(module, exports) {

function Any() {
    return this;
}

Any.prototype.getText = Any.prototype.toString;

exports.Any = Any;

/***/ }),
/* 141 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var IntegerValue = __webpack_require__(3).IntegerValue;
var IndexOutOfRangeError = __webpack_require__(179).IndexOutOfRangeError;
var BaseType = __webpack_require__(47).BaseType;
var RangeType = __webpack_require__(71).RangeType;

function RangeValue(itemType, left, right) {
    if(!(itemType instanceof BaseType))
        return;
	Value.call(this, new RangeType(itemType));
	var cmp = left.cmp(right);
	if(cmp<0) {
		this.low = left;
		this.high = right;
	} else {
		this.low = right;
		this.high = left;
	}
	return this;
}

RangeValue.prototype = Object.create(Value.prototype);
RangeValue.prototype.constructor = RangeValue;

RangeValue.prototype.toString = function() {
	return "[" + (this.low==null?"":this.low.toString()) + ".."
			+ (this.high==null?"":this.high.toString()) + "]";
};

RangeValue.prototype.equals = function(obj) {
	if(obj instanceof RangeValue) {
		return this.low.equals(obj.low) && this.high.equals(obj.high);
	} else {
		return false;
	}
};


RangeValue.prototype.hasItem = function(context, lval) {
	var a = lval.cmp(this.low);
	var b = this.high.cmp(lval);
	return a>=0 && b>=0;
};

RangeValue.prototype.getItemInContext = function(context, index) {
	if (index instanceof IntegerValue) {
		try {
			var value = this.getItem(index.IntegerValue());
			if (value instanceof Value) {
				return value;
			} else {
				throw new InternalError("Item not a value!");
			}
		} catch (e) {
			throw new IndexOutOfRangeError();
		}

	} else {
		throw new SyntaxError("No such item:" + index.toString());
	}
};

RangeValue.prototype.slice = function(fi, li) {
	var size = this.size();
	var first = this.checkFirst(fi, size);
	var last = this.checkLast(li, size);
	return this.newInstance(this.getItem(first),this.getItem(last));
}

RangeValue.prototype.checkFirst = function(fi, size) {
	var value = (fi == null) ? 1 : fi.IntegerValue();
	if (value < 1 || value > size) {
		throw new IndexOutOfRangeError();
	}
	return value;
};

RangeValue.prototype.checkLast = function(li, size) {
	var value = (li == null) ? size : li.IntegerValue();
	if (value < 0) {
		value = size + 1 + li.IntegerValue();
	}
	if (value < 1 || value > size) {
		throw new IndexOutOfRangeError();
	}
	return value;
};

RangeValue.prototype.getIterator = function(context) {
	return new RangeIterator(context, this);
};

function RangeIterator(context, range) {
	this.context = context;
	this.range = range;
	this.index = 0;
	return this;
}

RangeIterator.prototype.hasNext = function() {
	return this.index<this.range.size();
};

RangeIterator.prototype.next = function() {
	return this.range.getItemInContext(this.context, new IntegerValue(++this.index));
};


exports.RangeValue = RangeValue;

/***/ }),
/* 142 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;

function TypeValue(value) {
    Value.call(this, null); // TODO type of type
    this.value = value;
    return this;
};

TypeValue.prototype.toString = function() {
    return this.value.toString();
};

exports.TypeValue = TypeValue;

/***/ }),
/* 143 */
/***/ (function(module, exports, __webpack_require__) {

exports.AttributeArgument = __webpack_require__(72).AttributeArgument;
exports.CategoryArgument = __webpack_require__(95).CategoryArgument;
exports.ExtendedArgument = __webpack_require__(254).ExtendedArgument;
exports.CodeArgument = __webpack_require__(116).CodeArgument;
exports.UnresolvedArgument = __webpack_require__(144).UnresolvedArgument;

__webpack_require__(254).resolve();

/***/ }),
/* 144 */
/***/ (function(module, exports, __webpack_require__) {

var ProblemCollector = __webpack_require__(255).ProblemCollector;
var AttributeDeclaration = __webpack_require__(70).AttributeDeclaration;
var AttributeArgument = __webpack_require__(72).AttributeArgument;
var MethodDeclarationMap = __webpack_require__(11).MethodDeclarationMap;
var MethodArgument = __webpack_require__(256).MethodArgument;

function UnresolvedArgument(id) {
	this.id = id;
	this.resolved = null;
	return this;
}

Object.defineProperty(UnresolvedArgument.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});

UnresolvedArgument.prototype.getTranspiledName =  function(context) {
    this.resolveAndCheck(context);
    return this.resolved.getTranspiledName(context);
};


UnresolvedArgument.prototype.toDialect = function(writer) {
    writer.append(this.name);
    if(this.defaultExpression!=null) {
        writer.append(" = ");
        this.defaultExpression.toDialect(writer);
    }
};

UnresolvedArgument.prototype.check = function(context) {
	this.resolveAndCheck(context);
};

UnresolvedArgument.prototype.getProto = function() {
	return this.name;
};

UnresolvedArgument.prototype.getType = function(context) {
	this.resolveAndCheck(context);
	return this.resolved.getType(context);
};

UnresolvedArgument.prototype.register = function(context) {
	this.resolveAndCheck(context);
	this.resolved.register(context);
    if(this.defaultExpression!=null)
        context.setValue(this.id, this.defaultExpression.interpret(context));
};

UnresolvedArgument.prototype.checkValue = function(context, value) {
	this.resolveAndCheck(context);
	return this.resolved.checkValue(context, value);
};

UnresolvedArgument.prototype.resolveAndCheck = function(context) {
	if(this.resolved!=null)
		return;
    // ignore problems during resolution
    var listener = context.problemListener;
    context.problemListener = new ProblemCollector();
    // try out various solutions
	var named = context.getRegisteredDeclaration(this.name);
	if(named instanceof AttributeDeclaration) {
		this.resolved = new AttributeArgument(this.id);
	} else if(named instanceof MethodDeclarationMap) {
		this.resolved = new MethodArgument(this.id);
	}
    // restore listener
    context.problemListener = listener;
    if(this.resolved==null)
        context.problemListener.reportUnknownVariable(this.id);
};

UnresolvedArgument.prototype.declare = function(transpiler) {
    this.resolveAndCheck(transpiler.context);
    this.resolved.declare(transpiler);
};

UnresolvedArgument.prototype.transpile = function(transpiler) {
    this.resolveAndCheck(transpiler.context);
    this.resolved.transpile(transpiler);
};

UnresolvedArgument.prototype.transpileCall = function(transpiler, expression) {
    this.resolveAndCheck(transpiler.context);
    this.resolved.transpileCall(transpiler, expression);
};

UnresolvedArgument.prototype.equals = function(other) {
    return other === this || (other instanceof UnresolvedArgument && this.name === other.name);
};


exports.UnresolvedArgument = UnresolvedArgument;



/***/ }),
/* 145 */
/***/ (function(module, exports, __webpack_require__) {

exports.MatchingPatternConstraint = __webpack_require__(361).MatchingPatternConstraint;
exports.MatchingCollectionConstraint = __webpack_require__(363).MatchingCollectionConstraint;
exports.MatchingExpressionConstraint = __webpack_require__(364).MatchingExpressionConstraint;


/***/ }),
/* 146 */
/***/ (function(module, exports) {

function TypeFamily(name) {
    this.name = name;
    return this;
};

TypeFamily.prototype.toTranspiled = function() {
    return "new TypeFamily('" + this.name + "')";
};

// non storable
TypeFamily.BOOLEAN = new TypeFamily("BOOLEAN");
TypeFamily.CHARACTER = new TypeFamily("CHARACTER");
TypeFamily.INTEGER = new TypeFamily("INTEGER");
TypeFamily.DECIMAL = new TypeFamily("DECIMAL");
TypeFamily.TEXT = new TypeFamily("TEXT");
TypeFamily.UUID = new TypeFamily("UUID");
TypeFamily.DATE = new TypeFamily("DATE");
TypeFamily.TIME = new TypeFamily("TIME");
TypeFamily.DATETIME = new TypeFamily("DATETIME");
TypeFamily.PERIOD = new TypeFamily("PERIOD");
TypeFamily.LIST = new TypeFamily("LIST");
TypeFamily.SET = new TypeFamily("SET");
TypeFamily.TUPLE = new TypeFamily("TUPLE");
TypeFamily.RANGE = new TypeFamily("RANGE");
TypeFamily.BLOB = new TypeFamily("BLOB");
TypeFamily.IMAGE = new TypeFamily("IMAGE");
TypeFamily.DOCUMENT = new TypeFamily("DOCUMENT");
TypeFamily.CATEGORY = new TypeFamily("CATEGORY");
TypeFamily.RESOURCE = new TypeFamily("RESOURCE");
TypeFamily.DICTIONARY = new TypeFamily("DICTIONARY");
TypeFamily.ENUMERATED = new TypeFamily("ENUMERATED");
// non storable
TypeFamily.VOID = new TypeFamily("VOID");
TypeFamily.NULL = new TypeFamily("NULL");
TypeFamily.ANY = new TypeFamily("ANY");
TypeFamily.METHOD = new TypeFamily("METHOD");
TypeFamily.CURSOR = new TypeFamily("CURSOR");
TypeFamily.ITERATOR = new TypeFamily("ITERATOR");
TypeFamily.CLASS = new TypeFamily("CLASS");
TypeFamily.TYPE = new TypeFamily("TYPE");
TypeFamily.CODE = new TypeFamily("CODE");
TypeFamily.JSX = new TypeFamily("JSX");
TypeFamily.CSS = new TypeFamily("CSS");
TypeFamily.HTML = new TypeFamily("HTML");
// volatile
TypeFamily.MISSING = new TypeFamily("MISSING");

exports.TypeFamily = TypeFamily;

/***/ }),
/* 147 */
/***/ (function(module, exports, __webpack_require__) {

var ObjectList = __webpack_require__(22).ObjectList;
var CodeArgument = __webpack_require__(116).CodeArgument;

function ArgumentList() {
	ObjectList.call(this);
    for (var i=0; i < arguments.length; i++) {
		this.add(arguments[i]);
	}
	return this;
}

ArgumentList.prototype = Object.create(ObjectList.prototype);
ArgumentList.prototype.constructor = ArgumentList;

ArgumentList.prototype.register = function(context) {
    this.forEach(function(arg) {
        arg.register(context);
    });
};

ArgumentList.prototype.check = function(context) {
    this.forEach(function(arg) {
        arg.check(context);
    });
};

ArgumentList.prototype.declare = function(transpiler) {
    this.forEach(function(arg) {
        arg.declare(transpiler);
    });
};

ArgumentList.prototype.find = function(name) {
	for(var i=0;i<this.length;i++) {
		if(name===this[i].name) {
			return this[i];
		}
	}
	return null;
};

ArgumentList.prototype.toDialect = function(writer) {
    if(this.length==0)
        return;
    writer.toDialect(this);
};

ArgumentList.prototype.toEDialect = function(writer) {
    writer.append("receiving ");
    for(var i=0;i<this.length-1;i++) {
        this[i].toDialect(writer);
        writer.append(", ");
    }
    if(this.length>1) {
        writer.trimLast(2);
        writer.append(" and ");
    }
    this[this.length-1].toDialect(writer);
    writer.append(" ");
};

ArgumentList.prototype.toODialect = function(writer) {
    if(this.length>0) {
        this.forEach(function(arg) {
            arg.toDialect(writer);
            writer.append(", ");
        });
        writer.trimLast(2);
    }
};

ArgumentList.prototype.toMDialect = function(writer) {
    this.toODialect(writer);
};

ArgumentList.prototype.transpile = function(transpiler) {
    var args = this.filter(function(arg) {
        return !(arg instanceof CodeArgument);
    })
    if(args.length>0) {
        args.forEach(function (arg) {
            arg.transpile(transpiler);
            transpiler.append(", ");
        });
        transpiler.trimLast(2);
    }
};

exports.ArgumentList = ArgumentList;

/***/ }),
/* 148 */
/***/ (function(module, exports, __webpack_require__) {

exports.VariableInstance = __webpack_require__(365).VariableInstance;
exports.MemberInstance = __webpack_require__(366).MemberInstance;
exports.ItemInstance = __webpack_require__(367).ItemInstance;


/***/ }),
/* 149 */
/***/ (function(module, exports, __webpack_require__) {

exports.AttributeDeclaration = __webpack_require__(70).AttributeDeclaration;
exports.CategoryDeclaration = __webpack_require__(45).CategoryDeclaration;
exports.ConcreteCategoryDeclaration = __webpack_require__(52).ConcreteCategoryDeclaration;
exports.ConcreteWidgetDeclaration = __webpack_require__(189).ConcreteWidgetDeclaration;
exports.DeclarationList = __webpack_require__(368).DeclarationList;
exports.AbstractMethodDeclaration = __webpack_require__(190).AbstractMethodDeclaration;
exports.ConcreteMethodDeclaration = __webpack_require__(78).ConcreteMethodDeclaration;
exports.NativeMethodDeclaration = __webpack_require__(370).NativeMethodDeclaration;
exports.TestMethodDeclaration = __webpack_require__(260).TestMethodDeclaration;
exports.EnumeratedCategoryDeclaration = __webpack_require__(92).EnumeratedCategoryDeclaration;
exports.SingletonCategoryDeclaration = __webpack_require__(205).SingletonCategoryDeclaration;
exports.NativeCategoryDeclaration = __webpack_require__(122).NativeCategoryDeclaration;
exports.NativeResourceDeclaration = __webpack_require__(431).NativeResourceDeclaration;
exports.NativeWidgetDeclaration = __webpack_require__(206).NativeWidgetDeclaration;
exports.EnumeratedNativeDeclaration = __webpack_require__(77).EnumeratedNativeDeclaration;
exports.OperatorMethodDeclaration = __webpack_require__(433).OperatorMethodDeclaration;
exports.GetterMethodDeclaration = __webpack_require__(207).GetterMethodDeclaration;
exports.SetterMethodDeclaration = __webpack_require__(208).SetterMethodDeclaration;
exports.NativeGetterMethodDeclaration = __webpack_require__(434).NativeGetterMethodDeclaration;
exports.NativeSetterMethodDeclaration = __webpack_require__(435).NativeSetterMethodDeclaration;
exports.DispatchMethodDeclaration = __webpack_require__(209).DispatchMethodDeclaration;

__webpack_require__(75).resolve();
__webpack_require__(52).resolve();
__webpack_require__(209).resolve();


/***/ }),
/* 150 */
/***/ (function(module, exports, __webpack_require__) {

var List = __webpack_require__(29).List;
var StrictSet = __webpack_require__(34).StrictSet;

function Dictionary(mutable, entries) {
    if(entries)
        Object.getOwnPropertyNames(entries).forEach(function(name) { this[name] = entries[name]; }, this);
    this.mutable = mutable || false;
    return this;
}

Object.defineProperty(Dictionary.prototype, "$keys", {
    get : function() {
        return Object.getOwnPropertyNames(this).filter(function(name) { return name!=="mutable"; });
    }
});


Object.defineProperty(Dictionary.prototype, "length", {
    get : function() {
        return this.$keys.length;
    }
});

Object.defineProperty(Dictionary.prototype, "keys", {
    get : function() {
        return new StrictSet(this.$keys);
    }
});


Object.defineProperty(Dictionary.prototype, "values", {
    get : function() {
        var names = this.$keys.map(function(name) { return this[name]; }, this);
        return new List(false, names);
    }
});

Dictionary.prototype.iterator = function() {
    var self = this;
    var iter = this.keys.iterator();
    return {
        hasNext: iter.hasNext,
        next: function() { var key = iter.next(); return {key: key, value: self[key] }; }
    };
};

Dictionary.prototype.add = function(dict) {
    var result = Object.assign({}, this, dict);
    result.__proto__ = Dictionary.prototype;
    return result;
}


Dictionary.prototype.toString = function() {
    var vals = this.$keys.map(function (name) {
        return '"' + name + '":' + this[name];
    }, this);
    return "<" + (vals.length ? vals.join(", ") : ':') + ">";
};


Dictionary.prototype.getText = Dictionary.prototype.toString;


Dictionary.prototype.equals = function(dict) {
    var keys = this.$keys;
    if (this.length != dict.length)
        return false;
    for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var v1 = this[key] || null;
        var v2 = dict[key] || null;
        if (v1 === v2)
            continue;
        else if (v1 === null || v2 === null)
            return false;
        else if (v1.equals) {
            if (!v1.equals(v2)) {
                return false;
            }
        } else if (v2.equals) {
            if (!v2.equals(v1)) {
                return false;
            }
        } else
            return false;
    }
    return true;
};

Dictionary.prototype.has = function(item) {
    return this.hasOwnProperty(item);
};


Dictionary.prototype.hasAll = function(items) {
    return this.keys.hasAll(items, true);
};

Dictionary.prototype.hasAny = function(item) {
    return this.keys.hasAny(item, true);
};

Dictionary.prototype.item = function(item) {
    if(!item)
        throw new ReferenceError();
    if(!this.hasOwnProperty(item))
        throw new RangeError();
    return this[item];
};


Dictionary.prototype.setItem = function (item, value) {
    if(!this.mutable)
        throw new NotMutableError();
    else if(item==null)
        throw new ReferenceError();
    else
        this[item] = value;
};

exports.Dictionary = Dictionary;

/***/ }),
/* 151 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

if (!process.version ||
    process.version.indexOf('v0.') === 0 ||
    process.version.indexOf('v1.') === 0 && process.version.indexOf('v1.8.') !== 0) {
  module.exports = nextTick;
} else {
  module.exports = process.nextTick;
}

function nextTick(fn, arg1, arg2, arg3) {
  if (typeof fn !== 'function') {
    throw new TypeError('"callback" argument must be a function');
  }
  var len = arguments.length;
  var args, i;
  switch (len) {
  case 0:
  case 1:
    return process.nextTick(fn);
  case 2:
    return process.nextTick(function afterTickOne() {
      fn.call(null, arg1);
    });
  case 3:
    return process.nextTick(function afterTickTwo() {
      fn.call(null, arg1, arg2);
    });
  case 4:
    return process.nextTick(function afterTickThree() {
      fn.call(null, arg1, arg2, arg3);
    });
  default:
    args = new Array(len - 1);
    i = 0;
    while (i < args.length) {
      args[i++] = arguments[i];
    }
    return process.nextTick(function afterTick() {
      fn.apply(null, args);
    });
  }
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(57)))

/***/ }),
/* 152 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Buffer) {

module.exports = {
    /**
     * True if this is running in Nodejs, will be undefined in a browser.
     * In a browser, browserify won't include this file and the whole module
     * will be resolved an empty object.
     */
    isNode : typeof Buffer !== "undefined",
    /**
     * Create a new nodejs Buffer.
     * @param {Object} data the data to pass to the constructor.
     * @param {String} encoding the encoding to use.
     * @return {Buffer} a new Buffer.
     */
    newBuffer : function(data, encoding){
        return new Buffer(data, encoding);
    },
    /**
     * Find out if an object is a Buffer.
     * @param {Object} b the object to test.
     * @return {Boolean} true if the object is a Buffer, false otherwise.
     */
    isBuffer : function(b){
        return Buffer.isBuffer(b);
    },

    isStream : function (obj) {
        return obj &&
            typeof obj.on === "function" &&
            typeof obj.pause === "function" &&
            typeof obj.resume === "function";
    }
};

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(102).Buffer))

/***/ }),
/* 153 */
/***/ (function(module, exports) {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self : Function('return this')();
if(typeof __g == 'number')__g = global; // eslint-disable-line no-undef

/***/ }),
/* 154 */
/***/ (function(module, exports) {

/*
* UUID-js: A js library to generate and parse UUIDs, TimeUUIDs and generate
* TimeUUID based on dates for range selections.
* @see http://www.ietf.org/rfc/rfc4122.txt
**/

function UUID() {
}

UUID.maxFromBits = function(bits) {
    return Math.pow(2, bits);
};

UUID.limitUI04 = UUID.maxFromBits(4);
UUID.limitUI06 = UUID.maxFromBits(6);
UUID.limitUI08 = UUID.maxFromBits(8);
UUID.limitUI12 = UUID.maxFromBits(12);
UUID.limitUI14 = UUID.maxFromBits(14);
UUID.limitUI16 = UUID.maxFromBits(16);
UUID.limitUI32 = UUID.maxFromBits(32);
UUID.limitUI40 = UUID.maxFromBits(40);
UUID.limitUI48 = UUID.maxFromBits(48);

UUID.randomUI04 = function() {
    return Math.round(Math.random() * UUID.limitUI04);
};
UUID.randomUI06 = function() {
    return Math.round(Math.random() * UUID.limitUI06);
};
UUID.randomUI08 = function() {
    return Math.round(Math.random() * UUID.limitUI08);
};
UUID.randomUI12 = function() {
    return Math.round(Math.random() * UUID.limitUI12);
};
UUID.randomUI14 = function() {
    return Math.round(Math.random() * UUID.limitUI14);
};
UUID.randomUI16 = function() {
    return Math.round(Math.random() * UUID.limitUI16);
};
UUID.randomUI32 = function() {
    return Math.round(Math.random() * UUID.limitUI32);
};
UUID.randomUI40 = function() {
    return (0 | Math.random() * (1 << 30)) + (0 | Math.random() * (1 << 40 - 30)) * (1 << 30);
};
UUID.randomUI48 = function() {
    return (0 | Math.random() * (1 << 30)) + (0 | Math.random() * (1 << 48 - 30)) * (1 << 30);
};

UUID.paddedString = function(string, length, z) {
    string = String(string);
    z = (!z) ? '0' : z;
    var i = length - string.length;
    for (i; i > 0; i >>>= 1, z += z) {
        if (i & 1) {
            string = z + string;
        }
    }
    return string;
};

UUID.prototype.fromParts = function(timeLow, timeMid, timeHiAndVersion, clockSeqHiAndReserved, clockSeqLow, node) {
    this.version = (timeHiAndVersion >> 12) & 0xF;
    this.hex = UUID.paddedString(timeLow.toString(16), 8)
        + '-'
        + UUID.paddedString(timeMid.toString(16), 4)
        + '-'
        + UUID.paddedString(timeHiAndVersion.toString(16), 4)
        + '-'
        + UUID.paddedString(clockSeqHiAndReserved.toString(16), 2)
        + UUID.paddedString(clockSeqLow.toString(16), 2)
        + '-'
        + UUID.paddedString(node.toString(16), 12);
    return this;
};

UUID.prototype.toString = function() {
    return this.hex;
};

UUID.prototype.getText = UUID.prototype.toString;


UUID.prototype.toBytes = function() {
    var parts = this.hex.split('-');
    var ints = [];
    var intPos = 0;
    var i = 0;
    for (i; i < parts.length; i++) {
        var j = 0;
        for (j; j < parts[i].length; j+=2) {
            ints[intPos++] = parseInt(parts[i].substr(j, 2), 16);
        }
    }
    return ints;
};

UUID.prototype.equals = function(uuid) {
    if (!(uuid instanceof UUID)) {
        return false;
    }
    if (this.hex !== uuid.hex) {
        return false;
    }
    return true;
};

UUID.getTimeFieldValues = function(time) {
    var ts = time - Date.UTC(1582, 9, 15);
    var hm = ((ts / 0x100000000) * 10000) & 0xFFFFFFF;
    return { low: ((ts & 0xFFFFFFF) * 10000) % 0x100000000,
        mid: hm & 0xFFFF, hi: hm >>> 16, timestamp: ts };
};

UUID._create4 = function() {
    return new UUID().fromParts(
        UUID.randomUI32(),
        UUID.randomUI16(),
        0x4000 | UUID.randomUI12(),
        0x80   | UUID.randomUI06(),
        UUID.randomUI08(),
        UUID.randomUI48()
    );
};

UUID._create1 = function() {
    var now = new Date().getTime();
    var sequence = UUID.randomUI14();
    var node = (UUID.randomUI08() | 1) * 0x10000000000 + UUID.randomUI40();
    var tick = UUID.randomUI04();
    var timestamp = 0;
    var timestampRatio = 1/4;

    if (now !== timestamp) {
        if (now < timestamp) {
            sequence++;
        }
        timestamp = now;
        tick = UUID.randomUI04();
    } else if (Math.random() < timestampRatio && tick < 9984) {
        tick += 1 + UUID.randomUI04();
    } else {
        sequence++;
    }

    var tf = UUID.getTimeFieldValues(timestamp);
    var tl = tf.low + tick;
    var thav = (tf.hi & 0xFFF) | 0x1000;

    sequence &= 0x3FFF;
    var cshar = (sequence >>> 8) | 0x80;
    var csl = sequence & 0xFF;

    return new UUID().fromParts(tl, tf.mid, thav, cshar, csl, node);
};

UUID.create = function(version) {
    version = version || 4;
    return this['_create' + version]();
};

UUID.fromTime = function(time, last) {
    last = (!last) ? false : last;
    var tf = UUID.getTimeFieldValues(time);
    var tl = tf.low;
    var thav = (tf.hi & 0xFFF) | 0x1000;  // set version '0001'
    if (last === false) {
        return new UUID().fromParts(tl, tf.mid, thav, 0, 0, 0);
    }
    return new UUID().fromParts(tl, tf.mid, thav, 0x80 | UUID.limitUI06, UUID.limitUI08 - 1, UUID.limitUI48 - 1);

};

UUID.firstFromTime = function(time) {
    return UUID.fromTime(time, false);
};
UUID.lastFromTime = function(time) {
    return UUID.fromTime(time, true);
};

UUID.fromString = function(strId) {
    var p = new RegExp("([0-9a-f]{8})-([0-9a-f]{4})-([0-9a-f]{4})-([0-9a-f]{2})([0-9a-f]{2})-([0-9a-f]{12})");
    var r = p.exec(strId);
    if (r.length==7) {
        r.splice(0, 1);
        var ints = r.map(function (s) {
            return parseInt(s, 16);
        });
        var uuid = new UUID();
        return uuid.fromParts.apply(uuid, ints);
    } else
        throw new Error("Not a valid uuid: " + strId);
};

UUID.fromBytes = function(ints) {
    var str = '';
    var pos = 0;
    var parts = [4, 2, 2, 2, 6];
    var i = 0;

    if (ints.length < 5) {
        return null;
    }
    for (i; i < parts.length; i++) {
        var j = 0;
        for (j; j < parts[i]; j++) {
            var octet = ints[pos++].toString(16);
            if (octet.length === 1) {
                octet = '0' + octet;
            }
            str += octet;
        }
        if (parts[i] !== 6) {
            str += '-';
        }
    }
    return UUID.fromURN(str);
};

UUID.fromBinary = function(binary) {
    var ints = [];
    var i = 0;
    for (i; i < binary.length; i++) {
        ints[i] = binary.charCodeAt(i);
        if (ints[i] > 255 || ints[i] < 0) {
            throw new Error('Unexpected byte in binary data.');
        }
    }
    return UUID.fromBytes(ints);
};

exports.UUID = UUID;

/***/ }),
/* 155 */
/***/ (function(module, exports) {

function Version(major, minor, fix) {
    this.major = major;
    this.minor = minor;
    this.fix = fix;
    return this;
}

Version.Parse = function(text) {
    if(text.startsWith("v"))
        text = text.substring(1);
    var d1 = text.indexOf('.');
    var major = parseInt(text.substring(0, d1));
    var d2 = text.indexOf('.', d1 + 1);
    var minor = parseInt(text.substring(d1 + 1, d2));
    var fix = parseInt(text.substring(d2 + 1));
    return new Version(major, minor, fix);
};


Version.prototype.equals = function(obj) {
    return obj instanceof Version && this.asInt() == obj.asInt();
};


Version.prototype.toString = function() {
    return "" + this.major + "." + this.minor + "." + this.fix;
};

Version.prototype.getText = Version.prototype.toString;


Version.prototype.asInt = function() {
    return (this.major << 24) | (this.minor << 16) | this.fix;
};

Version.prototype.gt = function(other) {
    return other instanceof Version && this.asInt() > other.asInt();
};


Version.prototype.gte = function(other) {
    return other instanceof Version && this.asInt() >= other.asInt();
};

Version.prototype.lt = function(other) {
    return other instanceof Version && this.asInt() < other.asInt();
};

Version.prototype.lte = function(other) {
    return other instanceof Version && this.asInt() <= other.asInt();
};


Version.prototype.cmp = function(value) {
    var a = this.asInt();
    var b = value.asInt();
    return a > b ? 1 : (a == b ? 0 : -1);
};

exports.Version = Version;

/***/ }),
/* 156 */
/***/ (function(module, exports) {


function Store() {
    return this;
}

Store.prototype.newQueryBuilder = function() {
    throw new Error("Must override newQueryBuilder!");
};

Store.prototype.newStorableDocument = function() {
    throw new Error("Must override newStorableDocument!");
};


Store.prototype.store = function(add, del) {
    throw new Error("Must override store!");
};


Store.prototype.fetchUnique = function(dbId) {
    throw new Error("Must override fetchUnique!");
};


Store.prototype.fetchOne = function(query) {
    throw new Error("Must override fetchOne!");
};


Store.prototype.fetchMany = function(query) {
    throw new Error("Must override fetchMany!");
};

function QueryBuilder() {
    return this;
};

QueryBuilder.prototype.verify = function(fieldName, matchOp, value) {
    throw new Error("Must override verify!");
};

QueryBuilder.prototype.and = function() {
    throw new Error("Must override and!");
};

QueryBuilder.prototype.or = function() {
    throw new Error("Must override or!");
};

QueryBuilder.prototype.not = function() {
    throw new Error("Must override not!");
};

QueryBuilder.prototype.build = function() {
    throw new Error("Must override build!");
};

QueryBuilder.prototype.setFirst = function(value) {
    throw new Error("Must override setFirst!");
};

QueryBuilder.prototype.setLast = function(value) {
    throw new Error("Must override setLast!");
};

QueryBuilder.prototype.addOrderByClause = function(field, descending) {
    throw new Error("Must override addOrderByClause!");
};

exports.Store = Store;
exports.QueryBuilder = QueryBuilder;



/***/ }),
/* 157 */
/***/ (function(module, exports) {

function NativeCategoryBinding() {
    return this;
}


exports.NativeCategoryBinding = NativeCategoryBinding;

/***/ }),
/* 158 */
/***/ (function(module, exports, __webpack_require__) {

exports.UnresolvedIdentifier = __webpack_require__(27).UnresolvedIdentifier;
exports.ItemSelector = __webpack_require__(436).ItemSelector;
exports.SliceSelector = __webpack_require__(437).SliceSelector;
exports.MemberSelector = __webpack_require__(63).MemberSelector;
exports.MethodSelector = __webpack_require__(53).MethodSelector;
exports.SelectorExpression = __webpack_require__(94).SelectorExpression;
exports.PlusExpression = __webpack_require__(438).PlusExpression;
exports.SubtractExpression = __webpack_require__(439).SubtractExpression;
exports.EqualsExpression = __webpack_require__(298).EqualsExpression;
exports.FetchOneExpression = __webpack_require__(301).FetchOneExpression;
exports.FetchManyExpression = __webpack_require__(302).FetchManyExpression;
exports.ContainsExpression = __webpack_require__(440).ContainsExpression;
exports.DivideExpression = __webpack_require__(441).DivideExpression;
exports.IntDivideExpression = __webpack_require__(442).IntDivideExpression;
exports.ModuloExpression = __webpack_require__(443).ModuloExpression;
exports.MinusExpression = __webpack_require__(444).MinusExpression;
exports.MultiplyExpression = __webpack_require__(445).MultiplyExpression;
exports.AndExpression = __webpack_require__(259).AndExpression;
exports.OrExpression = __webpack_require__(446).OrExpression;
exports.NotExpression = __webpack_require__(447).NotExpression;
exports.CompareExpression = __webpack_require__(448).CompareExpression;
exports.MethodExpression = __webpack_require__(161).MethodExpression;
exports.SymbolExpression = __webpack_require__(182).SymbolExpression;
exports.FilteredExpression = __webpack_require__(449).FilteredExpression;
exports.CodeExpression = __webpack_require__(450).CodeExpression;
exports.ExecuteExpression = __webpack_require__(451).ExecuteExpression;
exports.InstanceExpression = __webpack_require__(41).InstanceExpression;
exports.BlobExpression = __webpack_require__(452).BlobExpression;
exports.DocumentExpression = __webpack_require__(453).DocumentExpression;
exports.ConstructorExpression = __webpack_require__(106).ConstructorExpression;
exports.ParenthesisExpression = __webpack_require__(309).ParenthesisExpression;
exports.IteratorExpression = __webpack_require__(454).IteratorExpression;
exports.SortedExpression = __webpack_require__(456).SortedExpression;
exports.TernaryExpression = __webpack_require__(457).TernaryExpression;
exports.ReadAllExpression = __webpack_require__(458).ReadAllExpression;
exports.ReadOneExpression = __webpack_require__(459).ReadOneExpression;
exports.TypeExpression = __webpack_require__(183).TypeExpression;
exports.CastExpression = __webpack_require__(460).CastExpression;
exports.ThisExpression = __webpack_require__(215).ThisExpression;
exports.NativeSymbol = __webpack_require__(461).NativeSymbol;
exports.CategorySymbol = __webpack_require__(462).CategorySymbol;
exports.UnresolvedSelector = __webpack_require__(213).UnresolvedSelector;

__webpack_require__(53).resolve();
__webpack_require__(63).resolve();
__webpack_require__(161).resolve();
__webpack_require__(41).resolve();
__webpack_require__(94).resolve();
__webpack_require__(106).resolve();
__webpack_require__(27).resolve();
__webpack_require__(213).resolve();


/***/ }),
/* 159 */
/***/ (function(module, exports) {


function AttributeInfo(name, family, collection, indexTypes) {
    this.name = name
    this.family = family
    this.collection = collection
    this.key = indexTypes == null ? false : indexTypes.indexOf("key")>=0;
    this.value = indexTypes == null ? false : indexTypes.indexOf("value")>=0;
    this.words = indexTypes == null ? false : indexTypes.indexOf("words")>=0;
    return this;
};

AttributeInfo.prototype.toTranspiled = function() {
    return "new AttributeInfo('" + this.name + "', TypeFamily." + this.family.name + ", " + this.collection + ", null)";
};

exports.AttributeInfo = AttributeInfo;

/***/ }),
/* 160 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var IterableType = __webpack_require__(111).IterableType;
var IntegerType = __webpack_require__(2).IntegerType;
var ListType = __webpack_require__(26).ListType;
var Identifier = __webpack_require__(0).Identifier;
var Variable = __webpack_require__(10).Variable;
var BuiltInMethodDeclaration = __webpack_require__(187).BuiltInMethodDeclaration;

function CursorType(itemType) {
    IterableType.call(this, new Identifier("Cursor<" + itemType.name + ">"), itemType);
    return this;
}

CursorType.prototype = Object.create(IterableType.prototype);
CursorType.prototype.constructor = CursorType;


CursorType.prototype.withItemType = function(itemType) {
    return new CursorType(itemType);
};


CursorType.prototype.isAssignableFrom = function(context, other) {
    return IterableType.prototype.isAssignableFrom.call(this, context, other)
        || ((other instanceof CursorType) && this.itemType.isAssignableFrom(context, other.itemType));
};

CursorType.prototype.equals = function(obj) {
    if(obj==this)
        return true;
    if(!(obj instanceof CursorType))
        return false;
    return this.itemType.equals(other.itemType);
};

CursorType.prototype.checkIterator = function(context, source) {
    return this.itemType;
};


CursorType.prototype.declareIterator = function(transpiler, name, expression) {
    transpiler = transpiler.newChildTranspiler(null);
    transpiler.context.registerValue(new Variable(name, this.itemType));
    expression.declare(transpiler);
};


CursorType.prototype.transpileIterator = function(transpiler, name, expression) {
    transpiler.append(".iterate(function(").append(name.name).append(") { return ");
    transpiler = transpiler.newChildTranspiler(null);
    transpiler.context.registerValue(new Variable(name, this.itemType));
    expression.transpile(transpiler);
    transpiler.append("; }, this)");
    transpiler.flush();
};


CursorType.prototype.checkMember = function(context, section, name) {
    if ("count"===name)
        return IntegerType.instance;
    else if ("totalCount"===name)
        return IntegerType.instance;
    else
        return IterableType.prototype.checkMember.call(this, context, section, name);
};

CursorType.prototype.declareMember = function(transpiler, name) {
    if("count"!==name && "totalCount"!==name)
        IterableType.prototype.declareMember.call(this, transpiler, name);
};

CursorType.prototype.transpileMember = function(transpiler, name) {
    if("count"===name || "totalCount"===name) {
        transpiler.append(name);
    } else
        IterableType.prototype.transpileMember.call(this, transpiler, name);
};


CursorType.prototype.getMemberMethods = function(context, name) {
    switch (name) {
        case "toList":
            return [new ToListMethodDeclaration(this.itemType)];
        default:
            return NativeType.prototype.getMemberMethods.call(context, name);
    }
};

function ToListMethodDeclaration(itemType) {
    BuiltInMethodDeclaration.call(this, "toList");
    this.itemType = itemType;
    return this;
}

ToListMethodDeclaration.prototype = Object.create(BuiltInMethodDeclaration.prototype);
ToListMethodDeclaration.prototype.constructor = ToListMethodDeclaration;

ToListMethodDeclaration.prototype.interpret = function(context) {
    var value = this.getValue(context);
    return value.toListValue(context);
};

ToListMethodDeclaration.prototype.check = function(context) {
    return new ListType(this.itemType);
};

ToListMethodDeclaration.prototype.declareCall = function(transpiler) {
    var List = __webpack_require__(29).List;
    transpiler.require(List);
};

ToListMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
    transpiler.append("toList()");
};

exports.CursorType = CursorType;


/***/ }),
/* 161 */
/***/ (function(module, exports, __webpack_require__) {

var MethodType = __webpack_require__(38).MethodType;
var MethodDeclarationMap = null; // circular dependency
var Dialect = __webpack_require__(8).Dialect;
var ClosureValue = __webpack_require__(97).ClosureValue;
var InstanceContext = null;

exports.resolve = function() {
    MethodDeclarationMap = __webpack_require__(11).MethodDeclarationMap;
    InstanceContext = __webpack_require__(11).InstanceContext;
};

function MethodExpression(id) {
	this.id = id;
	return this;
}

Object.defineProperty(MethodExpression.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});

MethodExpression.prototype.toString = function() {
	return "Method: " + this.name;
};

MethodExpression.prototype.toDialect = function(writer) {
    if(writer.dialect==Dialect.E)
        writer.append("Method: ");
    writer.append(this.name);
};

MethodExpression.prototype.check = function(context) {
    var decl = this.getDeclaration(context);
    if (decl != null) {
        return new MethodType(decl);
    } else {
        context.problemListener.reportUnknownMethod(this.id);
    }
};

MethodExpression.prototype.getDeclaration = function(context) {
    var methods = context.getRegistered(this.id);
	if(methods instanceof MethodDeclarationMap)
        return methods.getFirst();
    else
        return null;
};

MethodExpression.prototype.interpret = function(context, asMethod) {
	if(context.hasValue(this.id)) {
        return context.getValue(this.id);
    } else {
        var named = context.getRegistered(this.id);
        if (named instanceof MethodDeclarationMap) {
            var decl = named.getFirst();
            return new ClosureValue(context, new MethodType(decl))
        } else {
            context.problemListener.reportUnknownMethod(this.id);
        }
    }
};

MethodExpression.prototype.declare = function(transpiler) {
    var named = transpiler.context.getRegistered(this.name);
    var decl = named.getFirst();
    // don't declare closures
    if(!decl.declarationStatement)
        decl.declare(transpiler);
};

MethodExpression.prototype.transpile = function(transpiler) {
    var named = transpiler.context.getRegistered(this.name);
    if(named instanceof MethodDeclarationMap) {
        var decl = named.getFirst();
        var context = transpiler.context.contextForValue(this.name);
        if (context instanceof InstanceContext) {
            context.instanceType.transpileInstance(transpiler);
            transpiler.append(".");
        }
        transpiler.append(decl.getTranspiledName(transpiler.context));
        // need to bind instance methods
        if (context instanceof InstanceContext) {
            transpiler.append(".bind(");
            context.instanceType.transpileInstance(transpiler);
            transpiler.append(")");
        }
    }
};

	
exports.MethodExpression = MethodExpression;


/***/ }),
/* 162 */
/***/ (function(module, exports, __webpack_require__) {

var IterableType = __webpack_require__(111).IterableType;
var IntegerType = __webpack_require__(2).IntegerType;
var Identifier = __webpack_require__(0).Identifier;

function IteratorType(itemType) {
    IterableType.call(this, new Identifier("Iterator<" + itemType.name + ">"), itemType);
    return this;
}

IteratorType.prototype = Object.create(IterableType.prototype);
IteratorType.prototype.constructor = IteratorType;


IteratorType.prototype.withItemType = function(itemType) {
    return new IteratorType(itemType);
};


IteratorType.prototype.isAssignableFrom = function(context, other) {
    return IterableType.prototype.isAssignableFrom.call(this, context, other)
        || ((other instanceof IteratorType) && this.itemType.isAssignableFrom(context, other.itemType));
};

IteratorType.prototype.equals = function(other) {
    if(other==this)
        return true;
    if(!(other instanceof IteratorType))
        return false;
    return this.itemType.equals(other.itemType);
};

IteratorType.prototype.checkIterator = function(context, source) {
    return this.itemType;
};

IteratorType.prototype.checkMember = function(context, section, name) {
    if ("count"===name)
        return IntegerType.instance;
    else
        return IterableType.prototype.checkMember.call(this, context, section, name);
};

IteratorType.prototype.declare = function(transpiler) {
    this.itemType.declare(transpiler);
};


exports.IteratorType = IteratorType;


/***/ }),
/* 163 */
/***/ (function(module, exports, __webpack_require__) {

var BaseStatement = __webpack_require__(35).BaseStatement;
var UnresolvedIdentifier = __webpack_require__(27).UnresolvedIdentifier;
var MethodCall = __webpack_require__(62).MethodCall;
var MemberSelector = __webpack_require__(63).MemberSelector;
var MethodSelector = __webpack_require__(53).MethodSelector;
var UnresolvedSelector = __webpack_require__(213).UnresolvedSelector;
var MethodExpression = __webpack_require__(161).MethodExpression;
var MethodArgument = __webpack_require__(256).MethodArgument;
var CategoryDeclaration = __webpack_require__(45).CategoryDeclaration;
var ConstructorExpression = __webpack_require__(106).ConstructorExpression;
var CategoryType = __webpack_require__(7).CategoryType;
var MethodType = __webpack_require__(38).MethodType;
var CodeWriter = __webpack_require__(60).CodeWriter;
var InstanceContext = __webpack_require__(11).InstanceContext;


function UnresolvedCall(callable, assignments) {
    BaseStatement.call(this);
	this.resolved = null;
	this.callable = callable;
	this.assignments = assignments || null;
	return this;
}

UnresolvedCall.prototype  = Object.create(BaseStatement.prototype);
UnresolvedCall.prototype.constructor = UnresolvedCall;


UnresolvedCall.prototype.isSimple = function() {
    return true;
};


UnresolvedCall.prototype.toDialect = function(writer) {
    try {
        this.resolve(writer.context);
        this.resolved.toDialect(writer);
    } catch(error) {
        this.callable.toDialect(writer);
        if(this.assignments!=null)
           this.assignments.toDialect(writer);
    }
};


UnresolvedCall.prototype.toString = function() {
    return this.callable.toString() + (this.assignments!=null ? this.assignments.toString() : "");
};
	
UnresolvedCall.prototype.check = function(context) {
    return this.resolveAndCheck(context);
};


UnresolvedCall.prototype.resolveAndCheck = function(context) {
	this.resolve(context);
	return this.resolved.check(context);
};

UnresolvedCall.prototype.interpret = function(context) {
	this.resolve(context);
	return this.resolved.interpret(context);
};

UnresolvedCall.prototype.interpretAssert = function(context, testMethodDeclaration) {
    this.resolve(context);
    if (this.resolved.interpretAssert)
        return this.resolved.interpretAssert(context, testMethodDeclaration);
    else {
        var expected = this.getExpected(context, this.dialect);
        throw new SyntaxError("Cannot test '" + expected + "'");
    }
};

UnresolvedCall.prototype.getExpected = function(context, dialect, escapeMode) {
    var writer = new CodeWriter(this.dialect, context);
    writer.escapeMode = escapeMode;
    this.toDialect(writer);
    return writer.toString();
};


UnresolvedCall.prototype.transpileFound = function(transpiler, dialect) {
    transpiler.append("'<unknown>'");
};


UnresolvedCall.prototype.resolve = function(context) {
	if(this.resolved===null) {
		if(this.callable instanceof UnresolvedIdentifier) {
            this.resolved = this.resolveUnresolvedIdentifier(context);
        } else if(this.callable instanceof UnresolvedSelector) {
            this.resolved = this.resolveUnresolvedSelector(context);
		} else if (this.callable instanceof MemberSelector) {
            this.resolved = this.resolveMember(context);
		}
	}
};


UnresolvedCall.prototype.resolveUnresolvedSelector = function(context) {
    this.callable.resolveMethod(context, this.assignments);
    return this.callable.resolved;
};


UnresolvedCall.prototype.resolveUnresolvedIdentifier = function(context) {
	var id = this.callable.id;
    var call, decl = null;
    // if this happens in the context of a member method, then we need to check for category members first
    var instance = context.getClosestInstanceContext();
    if(instance!=null) {
        decl = this.resolveUnresolvedMember(instance, id.name);
        if(decl!=null)
            call = new MethodCall(new MethodSelector(null, id), this.assignments);
    }
    if(call==null) {
        var named = context.getRegisteredValue(id.name);
        if(named !== null) {
            var type = named.getType(context);
            if(type instanceof MethodType) {
                call = new MethodCall(new MethodSelector(null, id), this.assignments);
                call.variableName = id.name;
            }
        }
    }
    if(call==null) {
        decl = context.getRegisteredDeclaration(id.name);
        if (decl === null) {
            if (context.problemListener)
                context.problemListener.reportUnknownMethod(id);
            else
                throw new SyntaxError("Unknown name:" + id.name);
        }
        if (decl instanceof CategoryDeclaration) {
            call = new ConstructorExpression(new CategoryType(id), null, this.assignments, false);
        } else {
            call = new MethodCall(new MethodSelector(null, id), this.assignments);
        }
    }
    call.copySectionFrom(this);
    return call;
};

UnresolvedCall.prototype.resolveUnresolvedMember = function(context, name) {
    var decl = context.getRegisteredDeclaration(context.instanceType.name);
    var methods = decl.getMemberMethodsMap(context, name);
    if(methods!=null && !methods.isEmpty())
        return methods;
    else
        return null;
};


UnresolvedCall.prototype.resolveMember = function(context) {
	var call = new MethodCall(new MethodSelector(this.callable.parent, this.callable.id), this.assignments);
    call.copySectionFrom(this);
    return call;
};


UnresolvedCall.prototype.declare = function(transpiler) {
    this.resolve(transpiler.context);
    this.resolved.declare(transpiler);
};


UnresolvedCall.prototype.transpile = function(transpiler) {
    this.resolve(transpiler.context);
    this.resolved.transpile(transpiler);
};


exports.UnresolvedCall = UnresolvedCall;

/***/ }),
/* 164 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var PeriodValue = __webpack_require__(87).PeriodValue;
var DateValue = __webpack_require__(107).DateValue;
var TimeValue = __webpack_require__(108).TimeValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var TextValue = __webpack_require__(17).TextValue;
var DateTimeType = null;

exports.resolve = function() {
    DateTimeType = __webpack_require__(126).DateTimeType;
};

function DateTimeValue(value) {
	Value.call(this, DateTimeType.instance);
	this.value = value;
	return this;
}

DateTimeValue.prototype = Object.create(Value.prototype);
DateTimeValue.prototype.constructor = DateTimeValue;

DateTimeValue.prototype.getStorableData = function() {
    return this.value;
};


DateTimeValue.prototype.toString = function() {
    return this.value.toString();
};

DateTimeValue.prototype.Add = function(context, value) {
	if (value instanceof PeriodValue) {
        var result = this.value.addPeriod(value.value);
        return new DateTimeValue(result);
	} else {
		throw new SyntaxError("Illegal: DateTimeValue + " + typeof(value));
	}
};


DateTimeValue.prototype.Subtract = function(context, value) {
	if (value instanceof DateTimeValue) {
		return new PeriodValue(this.value.subtractDateTime(value.value));
	} /* else if (value instanceof DateValue) {
		return new PeriodValue(this.value.subtractDate(value.value));
	} else if (value instanceof TimeValue) {
		return new PeriodValue(this.value.subtractTime(value.value));
	} */ else if (value instanceof PeriodValue) {
		return new DateTimeValue(this.value.subtractPeriod(value.value));
	} else {
		throw new SyntaxError("Illegal: DateTimeValue - " + typeof(value));
	}
};

DateTimeValue.prototype.CompareTo = function(context, value) {
    if (value instanceof DateTimeValue) {
        return this.value.compareTo(value.value.date, value.value.tzOffset);
    } else if (value instanceof DateValue) {
        return this.value.compareTo(value.value.date, 0);
    } else {
        throw new SyntaxError("Illegal comparison: DateTimeValue and " + typeof(value));
    }
};


DateTimeValue.prototype.getMemberValue = function(context, name) {
    try {
    	var value = null;
        if ("year" == name) {
            value = this.value.getYear();
        } else if ("month" == name) {
            value = this.value.getMonth();
        } else if ("dayOfMonth" == name) {
            value = this.value.getDayOfMonth();
        } else if ("dayOfYear" == name) {
            value = this.value.getDayOfYear();
        } else if ("hour" == name) {
            value = this.value.getHour();
        } else if ("minute" == name) {
            value = this.value.getMinute();
        } else if ("second" == name) {
            value = this.value.getSecond();
        } else if ("millisecond" == name) {
            value = this.value.getMillisecond();
        } else if ("tzOffset" == name) {
            value = this.value.getTzOffset();
        } else if ("tzName" == name) {
            value = this.value.getTzName();
        }
        if(typeof(value) === typeof(0))
            return new IntegerValue(value);
        else if(typeof(value) === typeof("z"))
            return new TextValue(value);
    } catch (error) {
        // don't do anything
    }
    return Value.prototype.getMemberValue.call(this, context, name);
};



DateTimeValue.prototype.equals = function(obj) {
	if (obj instanceof DateTimeValue) {
		return this.value.equals(obj.value);
	} else {
		return false;
	}
};

exports.DateTimeValue = DateTimeValue;


/***/ }),
/* 165 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var Version = __webpack_require__(155).Version;
var VersionType = null;

exports.resolve = function() {
    VersionType = __webpack_require__(217).VersionType;
};

function VersionValue(version) {
    Value.call(this, VersionType.instance);
    this.version = version;
	return this;
}

VersionValue.prototype = Object.create(Value.prototype);
VersionValue.prototype.constructor = VersionValue;

Object.defineProperty(VersionValue.prototype, "major", {
    get: function() { return this.version.major; }
});

Object.defineProperty(VersionValue.prototype, "minor", {
    get: function() { return this.version.major; }
});

Object.defineProperty(VersionValue.prototype, "fix", {
    get: function() { return this.version.major; }
});

VersionValue.prototype.toString = function() {
    return this.version.toString();
};



VersionValue.prototype.CompareTo = function(context, value) {
    if (value instanceof VersionValue) {
        return this.version.cmp(value.version);
    } else {
        throw new SyntaxError("Illegal comparison: VersionValue and " + typeof(value));
    }
};


VersionValue.prototype.equals = function(obj) {
    if (obj instanceof VersionValue) {
        return this.version.equals(obj.version);
    } else {
        return false;
    }
};


exports.VersionValue = VersionValue;




/***/ }),
/* 166 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var AnyType = __webpack_require__(14).AnyType;
var Identifier = __webpack_require__(0).Identifier;
var UUIDValue = null;
var UUID = __webpack_require__(154).UUID;

exports.resolve = function() {
    UUIDValue = __webpack_require__(218).UUIDValue;
}


function UUIDType()  {
	NativeType.call(this, new Identifier("Uuid"));
	return this;
}

UUIDType.prototype = Object.create(NativeType.prototype);
UUIDType.prototype.constructor = UUIDType;

UUIDType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
    if(value instanceof UUID || typeof(value) == 'string') {
        return new UUIDValue(value);
    } else {
        return value; // TODO for now
    }
};

UUIDType.prototype.declare = function(transpiler) {
    transpiler.register(UUID);
};

UUIDType.prototype.transpile = function(transpiler) {
    transpiler.append("Uuid");
};

UUIDType.instance = new UUIDType();

exports.UUIDType = UUIDType;

/***/ }),
/* 167 */
/***/ (function(module, exports, __webpack_require__) {

exports.BaseStatement = __webpack_require__(35).BaseStatement;
exports.SimpleStatement = __webpack_require__(28).SimpleStatement;
exports.CommentStatement = __webpack_require__(481).CommentStatement;
exports.StatementList = __webpack_require__(261).StatementList;
exports.MethodCall = __webpack_require__(62).MethodCall;
exports.NativeCall = __webpack_require__(100).NativeCall;
exports.BreakStatement = __webpack_require__(482).BreakStatement;
exports.ReturnStatement = __webpack_require__(483).ReturnStatement;
exports.IfStatement = __webpack_require__(221).IfStatement;
exports.IfElement = __webpack_require__(221).IfElement;
exports.IfElementList = __webpack_require__(221).IfElementList;
exports.SwitchCase = __webpack_require__(222).SwitchCase;
exports.SwitchCaseList = __webpack_require__(223).SwitchCaseList;
exports.AtomicSwitchCase = __webpack_require__(484).AtomicSwitchCase;
exports.CollectionSwitchCase = __webpack_require__(485).CollectionSwitchCase;
exports.SwitchStatement = __webpack_require__(486).SwitchStatement;
exports.SwitchErrorStatement = __webpack_require__(487).SwitchErrorStatement;
exports.RaiseStatement = __webpack_require__(488).RaiseStatement;
exports.FlushStatement = __webpack_require__(490).FlushStatement;
exports.StoreStatement = __webpack_require__(491).StoreStatement;
exports.ForEachStatement = __webpack_require__(492).ForEachStatement;
exports.DoWhileStatement = __webpack_require__(493).DoWhileStatement;
exports.WhileStatement = __webpack_require__(494).WhileStatement;
exports.AssignVariableStatement = __webpack_require__(495).AssignVariableStatement;
exports.AssignInstanceStatement = __webpack_require__(496).AssignInstanceStatement;
exports.AssignTupleStatement = __webpack_require__(497).AssignTupleStatement;
exports.DeclarationStatement = __webpack_require__(191).DeclarationStatement;
exports.WithResourceStatement = __webpack_require__(498).WithResourceStatement;
exports.WithSingletonStatement = __webpack_require__(499).WithSingletonStatement;
exports.WriteStatement = __webpack_require__(500).WriteStatement;
exports.UnresolvedCall = __webpack_require__(163).UnresolvedCall;
exports.RemoteCall = __webpack_require__(501).RemoteCall;
exports.FetchOneStatement = __webpack_require__(503).FetchOneStatement;
exports.FetchManyStatement = __webpack_require__(504).FetchManyStatement;

__webpack_require__(62).resolve();
__webpack_require__(191).resolve();

/***/ }),
/* 168 */
/***/ (function(module, exports) {

function BreakResult() {
    return this;
}

BreakResult.instance = new BreakResult();

exports.BreakResult = BreakResult;

/***/ }),
/* 169 */
/***/ (function(module, exports, __webpack_require__) {

exports.NullLiteral = __webpack_require__(505).NullLiteral;
exports.BooleanLiteral = __webpack_require__(506).BooleanLiteral;
exports.CharacterLiteral = __webpack_require__(507).CharacterLiteral;
var ilm = __webpack_require__(508);
exports.IntegerLiteral = ilm.IntegerLiteral;
exports.MinIntegerLiteral = ilm.MinIntegerLiteral;
exports.MaxIntegerLiteral = ilm.MaxIntegerLiteral;
exports.HexaLiteral = __webpack_require__(509).HexaLiteral;
exports.DecimalLiteral = __webpack_require__(510).DecimalLiteral;
exports.TextLiteral = __webpack_require__(74).TextLiteral;
exports.TupleLiteral = __webpack_require__(511).TupleLiteral;
exports.ListLiteral = __webpack_require__(512).ListLiteral;
exports.SetLiteral = __webpack_require__(513).SetLiteral;
exports.RangeLiteral = __webpack_require__(514).RangeLiteral;
exports.DocumentLiteral = __webpack_require__(515).DocumentLiteral;
exports.DocEntryList = __webpack_require__(317).DocEntryList;
exports.DictLiteral = __webpack_require__(318).DictLiteral;
exports.DictEntry = __webpack_require__(516).DictEntry;
exports.DictTextKey = __webpack_require__(517).DictTextKey;
exports.DictIdentifierKey = __webpack_require__(518).DictIdentifierKey;
exports.DictEntryList = __webpack_require__(319).DictEntryList;
exports.DateLiteral = __webpack_require__(519).DateLiteral;
exports.TimeLiteral = __webpack_require__(520).TimeLiteral;
exports.DateTimeLiteral = __webpack_require__(521).DateTimeLiteral;
exports.PeriodLiteral = __webpack_require__(522).PeriodLiteral;
exports.VersionLiteral = __webpack_require__(523).VersionLiteral;
exports.UUIDLiteral = __webpack_require__(524).UUIDLiteral;


/***/ }),
/* 170 */
/***/ (function(module, exports, __webpack_require__) {

exports.IdentifierList = __webpack_require__(115).IdentifierList;
exports.Identifier = __webpack_require__(0).Identifier;
exports.MethodDeclarationList = __webpack_require__(525).MethodDeclarationList;
exports.Annotation = __webpack_require__(526).Annotation;
exports.ArgumentList = __webpack_require__(147).ArgumentList;
exports.ContOp = __webpack_require__(304).ContOp;
exports.CmpOp = __webpack_require__(305).CmpOp;
exports.EqOp = __webpack_require__(300).EqOp;
exports.OrderByClause = __webpack_require__(527).OrderByClause;
exports.OrderByClauseList = __webpack_require__(528).OrderByClauseList;
exports.Operator = __webpack_require__(226).Operator;
exports.ArgumentAssignment = __webpack_require__(40).ArgumentAssignment;
exports.ArgumentAssignmentList = __webpack_require__(39).ArgumentAssignmentList;
exports.NativeSymbolList = __webpack_require__(529).NativeSymbolList;
exports.CategorySymbolList = __webpack_require__(530).CategorySymbolList;
exports.NativeCategoryBindingList = __webpack_require__(531).NativeCategoryBindingList;

__webpack_require__(40).resolve();
__webpack_require__(39).resolve();


/***/ }),
/* 171 */
/***/ (function(module, exports, __webpack_require__) {

exports.Value = __webpack_require__(1).Value;
exports.NullValue = __webpack_require__(21).NullValue;
exports.AnyValue = __webpack_require__(532).AnyValue;
exports.BooleanValue = __webpack_require__(20).BooleanValue;
exports.BlobValue = __webpack_require__(211).BlobValue;
exports.ImageValue = __webpack_require__(533).ImageValue;
exports.IntegerValue = __webpack_require__(3).IntegerValue;
exports.DecimalValue = __webpack_require__(33).DecimalValue;
exports.CharacterValue = __webpack_require__(93).CharacterValue;
exports.TextValue = __webpack_require__(17).TextValue;
exports.TupleValue = __webpack_require__(85).TupleValue;
exports.ListValue = __webpack_require__(36).ListValue;
exports.SetValue = __webpack_require__(54).SetValue;
exports.DictionaryValue = __webpack_require__(225).DictionaryValue;
exports.DateTimeValue = __webpack_require__(164).DateTimeValue;
exports.DateValue = __webpack_require__(107).DateValue;
exports.TimeValue = __webpack_require__(108).TimeValue;
exports.PeriodValue = __webpack_require__(87).PeriodValue;
exports.VersionValue = __webpack_require__(165).VersionValue;
exports.CursorValue = __webpack_require__(303).CursorValue;
exports.DocumentValue = __webpack_require__(66).DocumentValue;
exports.TypeValue = __webpack_require__(142).TypeValue;
exports.ClosureValue = __webpack_require__(97).ClosureValue;
exports.IteratorValue = __webpack_require__(314).IteratorValue;
exports.UUIDValue = __webpack_require__(218).UUIDValue;
exports.JsxValue = __webpack_require__(321).JsxValue;

__webpack_require__(172).resolve();
__webpack_require__(257).resolve();
__webpack_require__(248).resolve();
__webpack_require__(312).resolve();
__webpack_require__(313).resolve();
__webpack_require__(93).resolve();
__webpack_require__(3).resolve();
__webpack_require__(33).resolve();
__webpack_require__(165).resolve();
__webpack_require__(164).resolve();
__webpack_require__(108).resolve();
__webpack_require__(87).resolve();
__webpack_require__(36).resolve();
__webpack_require__(54).resolve();
__webpack_require__(85).resolve();
__webpack_require__(107).resolve();
__webpack_require__(1).resolve();


/***/ }),
/* 172 */
/***/ (function(module, exports, __webpack_require__) {

var CategoryType = null;
var ContextualExpression = __webpack_require__(188).ContextualExpression;
var NotStorableError = __webpack_require__(224).NotStorableError;
var NotMutableError = __webpack_require__(118).NotMutableError;
var StorableDocument = __webpack_require__(296).StorableDocument;
var ExpressionValue = __webpack_require__(76).ExpressionValue;
var DecimalType = __webpack_require__(23).DecimalType;
var Variable = __webpack_require__(10).Variable;
var Identifier = __webpack_require__(0).Identifier;
var Operator = __webpack_require__(226).Operator;
var NullValue = __webpack_require__(21).NullValue;
var DecimalValue = __webpack_require__(33).DecimalValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var TextValue = __webpack_require__(17).TextValue;
var Instance = __webpack_require__(1).Instance;
var DataStore = __webpack_require__(50).DataStore;
var TypeUtils = __webpack_require__(83);
var EnumeratedNativeDeclaration = null;
var EnumeratedCategoryDeclaration = null;

exports.resolve = function() {
	CategoryType = __webpack_require__(7).CategoryType;
    EnumeratedNativeDeclaration = __webpack_require__(77).EnumeratedNativeDeclaration;
    EnumeratedCategoryDeclaration = __webpack_require__(92).EnumeratedCategoryDeclaration;
};

function ConcreteInstance(context, declaration) {
    Instance.call(this, new CategoryType(declaration.id));
	this.declaration = declaration;
    this.storable = null;
    if(declaration.storable) {
        var categories = declaration.collectCategories(context);
        this.storable = DataStore.instance.newStorableDocument(categories);
    }
    this.mutable = false;
	this.values = {};
	return this;
}

ConcreteInstance.prototype = Object.create(Instance.prototype);
ConcreteInstance.prototype.constructor = ConcreteInstance;

ConcreteInstance.prototype.getType = function() {
	return this.type;
};

ConcreteInstance.prototype.convertToJavaScript = function() {
    return this; // TODO, until we have a translator
};

ConcreteInstance.prototype.getDbId = function() {
    var dbId = this.values["dbId"] || null;
    return dbId == null ? null : dbId.getStorableData();
};


ConcreteInstance.prototype.getOrCreateDbId = function() {
    var dbId = this.getDbId();
    if(dbId==null) {
        dbId = this.storable.getOrCreateDbId();
        var value = TypeUtils.convertFromJavaScript(dbId);
        this.values["dbId"] = value;
    }
    return dbId;
};


ConcreteInstance.prototype.getStorableData = function() {
    // this is called when storing the instance as a field value
    // if this is an enum then we simply store the symbol name
    if(this.declaration instanceof EnumeratedNativeDeclaration || this.declaration instanceof EnumeratedCategoryDeclaration)
        return this.values["name"].getStorableData()
    // otherwise we just return the dbId, the instance data itself will be collected as part of collectStorables
    if (this.storable == null)
        throw new NotStorableError();
    else
        return this.getOrCreateDbId();
};

ConcreteInstance.prototype.getMemberNames = function() {
	return Object.getOwnPropertyNames(this.values);
};

ConcreteInstance.prototype.collectStorables = function(set) {
    if(this.declaration instanceof EnumeratedNativeDeclaration || this.declaration instanceof EnumeratedCategoryDeclaration)
        return;
    if (this.storable==null)
        throw new NotStorableError();
    if (this.storable.isDirty()) {
        this.getOrCreateDbId();
        set.add(this.storable);
    }
    for(var field in this.values) {
        this.values[field].collectStorables(set);
    }
};

// don't call getters from getters, so register them
// TODO: thread local storage

var activeGetters = {};

function getActiveGetters() {
	return activeGetters;
}

ConcreteInstance.prototype.getMemberValue = function(context, attrName) {
    /* if(typeof(attrName) != typeof(""))
        throw "What?"; */
	var stacked = getActiveGetters()[attrName] || null;
    var first = stacked==null;
    if(first)
        getActiveGetters()[attrName] = context;
	try {
		return this.doGetMember(context, attrName, first);
	} finally {
		if(first) {
			delete getActiveGetters()[attrName];
		}
	}
};

ConcreteInstance.prototype.doGetMember = function(context, attrName, allowGetter) {
    var getter = allowGetter ? this.declaration.findGetter(context, attrName) : null;
    if (getter != null) {
        context = context.newInstanceContext(this, null).newChildContext();
        return getter.interpret(context);
    } else if (this.declaration.hasAttribute(context, attrName) || "dbId" == attrName) {
        return this.values[attrName] || NullValue.instance;
    } else if ("text" == attrName) {
        return new TextValue(this.toString());
    } else
        return NullValue.instance;
};


// don't call setters from setters, so register them

var activeSetters = {};

function getActiveSetters() {
	return activeSetters;
}

ConcreteInstance.prototype.setMember = function(context, attrName, value) {
    /* if(typeof(attrName) != typeof(""))
        throw "What?"; */
    if(!this.mutable)
        throw new NotMutableError();
	var stacked = getActiveSetters()[attrName] || null;
    var first = stacked==null;
    if(first)
        getActiveSetters()[attrName] = context;
	try {
		this.doSetMember(context, attrName, value, first);
	} finally {
		if(first) {
			delete getActiveSetters()[attrName];
		}
	}
};

ConcreteInstance.prototype.doSetMember = function(context, attrName, value, allowSetter) {
    var decl = context.getRegisteredDeclaration(attrName);
	var setter = allowSetter ? this.declaration.findSetter(context,attrName) : null;
	if(setter!=null) {
		// use attribute name as parameter name for incoming value
		context = context.newInstanceContext(this, null).newChildContext();
        var id = new Identifier(attrName);
		context.registerValue(new Variable(id, decl.getType()));
		context.setValue(id, value);
		value = setter.interpret(context);
	}
    value = this.autocast(decl, value);
	this.values[attrName] = value;
    if (this.storable && decl.storable) // TODO convert object graph if(value instanceof IInstance)
        this.storable.setData(attrName, value.getStorableData(), this.getDbId());
};

ConcreteInstance.prototype.autocast = function(decl, value) {
    if(value instanceof IntegerValue && decl.getType()==DecimalType.instance)
        value = new DecimalValue(value.DecimalValue());
    return value;
};

ConcreteInstance.prototype.equals = function(obj) {
	if(obj==this) {
		return true;
	} else if(!(obj instanceof ConcreteInstance)) {
        return false;
    } else if(this.declaration!==obj.declaration) {
	    return false;
	} else {
		var names = Object.getOwnPropertyNames(this.values);
		var otherNames = Object.getOwnPropertyNames(obj.values);
		if(names.length!=otherNames.length) {
			return false;
		}
		for(var i=0;i<names.length;i++) {
			var v1 = this.values[names[i]] || null;
			var v2 = obj.values[names[i]];
			if(v1==v2) {
				continue;
			} else if(v1==null || v2==null) {
				return false;
			} else {
				if(v1.equals) {
					if(!v1.equals(v2)) {
						return false;
					}
				} else if(v2.equals) {
					if(!v2.equals(v1)) {
						return false;
					}
				} else {
					return false;
				}
			}
		}
		return true;
	}
};

ConcreteInstance.prototype.toString = function() {
	var props = [];
	for(p in this.values) {
        if("dbId"!=p)
		    props.push(p + ":" + this.values[p].toString())
	}
	return "{" + props.join(", ") + "}";
};



ConcreteInstance.prototype.Multiply = function(context, value) {
    try {
        return this.interpretOperator(context, value, Operator.MULTIPLY);
    } catch(e) {
        return Value.prototype.Multiply.call(this, context, value);
    }
};


ConcreteInstance.prototype.Divide = function(context, value) {
    try {
        return this.interpretOperator(context, value, Operator.DIVIDE);
    } catch(e) {
        return Value.prototype.Divide.call(this, context, value);
    }
};


ConcreteInstance.prototype.IntDivide = function(context, value) {
    try {
        return this.interpretOperator(context, value, Operator.IDIVIDE);
    } catch(e) {
        return Value.prototype.IntDivide.call(this, context, value);
    }
};


ConcreteInstance.prototype.Modulo = function(context, value) {
    try {
        return this.interpretOperator(context, value, Operator.MODULO);
    } catch(e) {
        return Value.prototype.Modulo.call(this, context, value);
    }
};


ConcreteInstance.prototype.Add = function(context, value) {
    try {
        return this.interpretOperator(context, value, Operator.PLUS);
    } catch(e) {
        return Value.prototype.Add.call(this, context, value);
    }
};


ConcreteInstance.prototype.Subtract = function(context, value) {
    try {
        return this.interpretOperator(context, value, Operator.MINUS);
    } catch(e) {
        return Value.prototype.Subtract.call(this, context, value);
    }
};


ConcreteInstance.prototype.interpretOperator = function(context, value, operator) {
    var decl = this.declaration.getOperatorMethod(context, operator, value.type);
    context = context.newInstanceContext(this);
    var local = context.newChildContext();
    decl.registerArguments(local);
    var arg = decl.args[0];
    local.setValue(arg.id, value);
    return decl.interpret(local);
};

exports.ConcreteInstance = ConcreteInstance;



/***/ }),
/* 173 */
/***/ (function(module, exports, __webpack_require__) {

exports.EParserListener = __webpack_require__(252).EParserListener;
exports.OParserListener = __webpack_require__(322).OParserListener;
exports.MParserListener = __webpack_require__(323).MParserListener;
exports.EParser = __webpack_require__(251).EParser;
exports.OParser = __webpack_require__(324).OParser;
exports.MParser = __webpack_require__(325).MParser;
exports.ECleverParser = __webpack_require__(184).ECleverParser;
exports.OCleverParser = __webpack_require__(326).OCleverParser;
exports.MCleverParser = __webpack_require__(334).MCleverParser;
exports.EPromptoBuilder = __webpack_require__(253).EPromptoBuilder;
exports.OPromptoBuilder = __webpack_require__(327).OPromptoBuilder;
exports.MPromptoBuilder = __webpack_require__(336).MPromptoBuilder;
exports.ParserUtils = __webpack_require__(589);
exports.Dialect = __webpack_require__(8).Dialect;
exports.Section = __webpack_require__(19).Section;

__webpack_require__(227).resolve();
__webpack_require__(8).resolve();

/***/ }),
/* 174 */
/***/ (function(module, exports, __webpack_require__) {

var JsxValue = __webpack_require__(321).JsxValue;

function IJsxExpression() {
    return this;
}


IJsxExpression.prototype.interpret = function(context) {
    return new JsxValue(this);
};

exports.IJsxExpression = IJsxExpression;


/***/ }),
/* 175 */
/***/ (function(module, exports, __webpack_require__) {

exports.JavaStatement = __webpack_require__(548).JavaStatement;
exports.JavaNativeCall = __webpack_require__(549).JavaNativeCall;
exports.JavaItemExpression = __webpack_require__(550).JavaItemExpression;
exports.JavaIdentifierExpression = __webpack_require__(551).JavaIdentifierExpression;
exports.JavaBooleanLiteral = __webpack_require__(552).JavaBooleanLiteral;
exports.JavaCharacterLiteral = __webpack_require__(553).JavaCharacterLiteral;
exports.JavaTextLiteral = __webpack_require__(554).JavaTextLiteral;
exports.JavaIntegerLiteral = __webpack_require__(555).JavaIntegerLiteral;
exports.JavaDecimalLiteral = __webpack_require__(556).JavaDecimalLiteral;
exports.JavaExpressionList = __webpack_require__(330).JavaExpressionList;
exports.JavaThisExpression = __webpack_require__(557).JavaThisExpression;
exports.JavaMethodExpression = __webpack_require__(558).JavaMethodExpression;
exports.JavaNativeCategoryBinding = __webpack_require__(559).JavaNativeCategoryBinding;



/***/ }),
/* 176 */
/***/ (function(module, exports, __webpack_require__) {

exports.CSharpStatement = __webpack_require__(560).CSharpStatement;
exports.CSharpNativeCall = __webpack_require__(561).CSharpNativeCall;
exports.CSharpBooleanLiteral = __webpack_require__(562).CSharpBooleanLiteral;
exports.CSharpIntegerLiteral = __webpack_require__(563).CSharpIntegerLiteral;
exports.CSharpDecimalLiteral = __webpack_require__(564).CSharpDecimalLiteral;
exports.CSharpCharacterLiteral = __webpack_require__(565).CSharpCharacterLiteral;
exports.CSharpTextLiteral = __webpack_require__(566).CSharpTextLiteral;
exports.CSharpMethodExpression = __webpack_require__(567).CSharpMethodExpression;
exports.CSharpSelectorExpression = __webpack_require__(331).CSharpSelectorExpression;
exports.CSharpExpressionList = __webpack_require__(332).CSharpExpressionList;
exports.CSharpThisExpression = __webpack_require__(568).CSharpThisExpression;
exports.CSharpIdentifierExpression  = __webpack_require__(569).CSharpIdentifierExpression;
exports.CSharpNativeCategoryBinding = __webpack_require__(570).CSharpNativeCategoryBinding;


/***/ }),
/* 177 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

//* A rule invocation record for parsing.
//
//  Contains all of the information about the current rule not stored in the
//  RuleContext. It handles parse tree children list, Any ATN state
//  tracing, and the default values available for rule indications:
//  start, stop, rule index, current alt number, current
//  ATN state.
//
//  Subclasses made for each rule and grammar track the parameters,
//  return values, locals, and labels specific to that rule. These
//  are the objects that are returned from rules.
//
//  Note text is not an actual field of a rule return value; it is computed
//  from start and stop using the input stream's toString() method.  I
//  could add a ctor to this so that we can pass in and store the input
//  stream, but I'm not sure we want to do that.  It would seem to be undefined
//  to get the .text property anyway if the rule matches tokens from multiple
//  input streams.
//
//  I do not use getters for fields of objects that are used simply to
//  group values such as this aggregate.  The getters/setters are there to
//  satisfy the superclass interface.

var RuleContext = __webpack_require__(135).RuleContext;
var Tree = __webpack_require__(43);
var INVALID_INTERVAL = Tree.INVALID_INTERVAL;
var TerminalNode = Tree.TerminalNode;
var TerminalNodeImpl = Tree.TerminalNodeImpl;
var ErrorNodeImpl = Tree.ErrorNodeImpl;
var Interval = __webpack_require__(25).Interval;

function ParserRuleContext(parent, invokingStateNumber) {
	parent = parent || null;
	invokingStateNumber = invokingStateNumber || null;
	RuleContext.call(this, parent, invokingStateNumber);
	this.ruleIndex = -1;
    // * If we are debugging or building a parse tree for a visitor,
    // we need to track all of the tokens and rule invocations associated
    // with this rule's context. This is empty for parsing w/o tree constr.
    // operation because we don't the need to track the details about
    // how we parse this rule.
    // /
    this.children = null;
    this.start = null;
    this.stop = null;
    // The exception that forced this rule to return. If the rule successfully
    // completed, this is {@code null}.
    this.exception = null;
}

ParserRuleContext.prototype = Object.create(RuleContext.prototype);
ParserRuleContext.prototype.constructor = ParserRuleContext;

// * COPY a ctx (I'm deliberately not using copy constructor)///
ParserRuleContext.prototype.copyFrom = function(ctx) {
    // from RuleContext
    this.parentCtx = ctx.parentCtx;
    this.invokingState = ctx.invokingState;
    this.children = null;
    this.start = ctx.start;
    this.stop = ctx.stop;
    // copy any error nodes to alt label node
    if(ctx.children) {
        this.children = [];
        // reset parent pointer for any error nodes
    	ctx.children.map(function(child) {
    		if (child instanceof ErrorNodeImpl) {
                this.children.push(child);
                child.parentCtx = this;
            }
		}, this);
	}
};

// Double dispatch methods for listeners
ParserRuleContext.prototype.enterRule = function(listener) {
};

ParserRuleContext.prototype.exitRule = function(listener) {
};

// * Does not set parent link; other add methods do that///
ParserRuleContext.prototype.addChild = function(child) {
    if (this.children === null) {
        this.children = [];
    }
    this.children.push(child);
    return child;
};

// * Used by enterOuterAlt to toss out a RuleContext previously added as
// we entered a rule. If we have // label, we will need to remove
// generic ruleContext object.
// /
ParserRuleContext.prototype.removeLastChild = function() {
    if (this.children !== null) {
        this.children.pop();
    }
};

ParserRuleContext.prototype.addTokenNode = function(token) {
    var node = new TerminalNodeImpl(token);
    this.addChild(node);
    node.parentCtx = this;
    return node;
};

ParserRuleContext.prototype.addErrorNode = function(badToken) {
    var node = new ErrorNodeImpl(badToken);
    this.addChild(node);
    node.parentCtx = this;
    return node;
};

ParserRuleContext.prototype.getChild = function(i, type) {
	type = type || null;
	if (this.children === null || i < 0 || i >= this.children.length) {
		return null;
	}
	if (type === null) {
		return this.children[i];
	} else {
		for(var j=0; j<this.children.length; j++) {
			var child = this.children[j];
			if(child instanceof type) {
				if(i===0) {
					return child;
				} else {
					i -= 1;
				}
			}
		}
		return null;
    }
};


ParserRuleContext.prototype.getToken = function(ttype, i) {
	if (this.children === null || i < 0 || i >= this.children.length) {
		return null;
	}
	for(var j=0; j<this.children.length; j++) {
		var child = this.children[j];
		if (child instanceof TerminalNode) {
			if (child.symbol.type === ttype) {
				if(i===0) {
					return child;
				} else {
					i -= 1;
				}
			}
        }
	}
    return null;
};

ParserRuleContext.prototype.getTokens = function(ttype ) {
    if (this.children=== null) {
        return [];
    } else {
		var tokens = [];
		for(var j=0; j<this.children.length; j++) {
			var child = this.children[j];
			if (child instanceof TerminalNode) {
				if (child.symbol.type === ttype) {
					tokens.push(child);
				}
			}
		}
		return tokens;
    }
};

ParserRuleContext.prototype.getTypedRuleContext = function(ctxType, i) {
    return this.getChild(i, ctxType);
};

ParserRuleContext.prototype.getTypedRuleContexts = function(ctxType) {
    if (this.children=== null) {
        return [];
    } else {
		var contexts = [];
		for(var j=0; j<this.children.length; j++) {
			var child = this.children[j];
			if (child instanceof ctxType) {
				contexts.push(child);
			}
		}
		return contexts;
	}
};

ParserRuleContext.prototype.getChildCount = function() {
	if (this.children=== null) {
		return 0;
	} else {
		return this.children.length;
	}
};

ParserRuleContext.prototype.getSourceInterval = function() {
    if( this.start === null || this.stop === null) {
        return INVALID_INTERVAL;
    } else {
        return new Interval(this.start.tokenIndex, this.stop.tokenIndex);
    }
};

RuleContext.EMPTY = new ParserRuleContext();

function InterpreterRuleContext(parent, invokingStateNumber, ruleIndex) {
	ParserRuleContext.call(parent, invokingStateNumber);
    this.ruleIndex = ruleIndex;
    return this;
}

InterpreterRuleContext.prototype = Object.create(ParserRuleContext.prototype);
InterpreterRuleContext.prototype.constructor = InterpreterRuleContext;

exports.ParserRuleContext = ParserRuleContext;

/***/ }),
/* 178 */
/***/ (function(module, exports, __webpack_require__) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
//

var Token = __webpack_require__(18).Token;
__webpack_require__(244);
__webpack_require__(245);

// Vacuum all input from a string and then treat it like a buffer.

function _loadString(stream, decodeToUnicodeCodePoints) {
	stream._index = 0;
	stream.data = [];
	if (stream.decodeToUnicodeCodePoints) {
		for (var i = 0; i < stream.strdata.length; ) {
			var codePoint = stream.strdata.codePointAt(i);
			stream.data.push(codePoint);
			i += codePoint <= 0xFFFF ? 1 : 2;
		}
	} else {
		for (var i = 0; i < stream.strdata.length; i++) {
			var codeUnit = stream.strdata.charCodeAt(i);
			stream.data.push(codeUnit);
		}
	}
	stream._size = stream.data.length;
}

// If decodeToUnicodeCodePoints is true, the input is treated
// as a series of Unicode code points.
//
// Otherwise, the input is treated as a series of 16-bit UTF-16 code
// units.
function InputStream(data, decodeToUnicodeCodePoints) {
	this.name = "<empty>";
	this.strdata = data;
	this.decodeToUnicodeCodePoints = decodeToUnicodeCodePoints || false;
	_loadString(this);
	return this;
}

Object.defineProperty(InputStream.prototype, "index", {
	get : function() {
		return this._index;
	}
});

Object.defineProperty(InputStream.prototype, "size", {
	get : function() {
		return this._size;
	}
});

// Reset the stream so that it's in the same state it was
// when the object was created *except* the data array is not
// touched.
//
InputStream.prototype.reset = function() {
	this._index = 0;
};

InputStream.prototype.consume = function() {
	if (this._index >= this._size) {
		// assert this.LA(1) == Token.EOF
		throw ("cannot consume EOF");
	}
	this._index += 1;
};

InputStream.prototype.LA = function(offset) {
	if (offset === 0) {
		return 0; // undefined
	}
	if (offset < 0) {
		offset += 1; // e.g., translate LA(-1) to use offset=0
	}
	var pos = this._index + offset - 1;
	if (pos < 0 || pos >= this._size) { // invalid
		return Token.EOF;
	}
	return this.data[pos];
};

InputStream.prototype.LT = function(offset) {
	return this.LA(offset);
};

// mark/release do nothing; we have entire buffer
InputStream.prototype.mark = function() {
	return -1;
};

InputStream.prototype.release = function(marker) {
};

// consume() ahead until p==_index; can't just set p=_index as we must
// update line and column. If we seek backwards, just set p
//
InputStream.prototype.seek = function(_index) {
	if (_index <= this._index) {
		this._index = _index; // just jump; don't update stream state (line,
								// ...)
		return;
	}
	// seek forward
	this._index = Math.min(_index, this._size);
};

InputStream.prototype.getText = function(start, stop) {
	if (stop >= this._size) {
		stop = this._size - 1;
	}
	if (start >= this._size) {
		return "";
	} else {
		if (this.decodeToUnicodeCodePoints) {
			var result = "";
			for (var i = start; i <= stop; i++) {
				result += String.fromCodePoint(this.data[i]);
			}
			return result;
		} else {
			return this.strdata.slice(start, stop + 1);
		}
	}
};

InputStream.prototype.toString = function() {
	return this.strdata;
};

exports.InputStream = InputStream;


/***/ }),
/* 179 */
/***/ (function(module, exports, __webpack_require__) {

var ExecutionError = __webpack_require__(48).ExecutionError;

function IndexOutOfRangeError() {
	ExecutionError.call(this);
	return this;
}

IndexOutOfRangeError.prototype = Object.create(ExecutionError.prototype);
IndexOutOfRangeError.prototype.constructor = IndexOutOfRangeError;

IndexOutOfRangeError.prototype.getExpression = function(context) {
	return context.getRegisteredValue("INDEX_OUT_OF_RANGE");
};

exports.IndexOutOfRangeError = IndexOutOfRangeError;


/***/ }),
/* 180 */
/***/ (function(module, exports, __webpack_require__) {

var Variable = __webpack_require__(10).Variable;
var Identifier = __webpack_require__(0).Identifier;
var EnumeratedCategoryType = null;

exports.resolve = function() {
    EnumeratedCategoryType = __webpack_require__(112).EnumeratedCategoryType;
};

function ErrorVariable(id) {
	Variable.call(this, id, new EnumeratedCategoryType(new Identifier("Error")));
	return this;
}

ErrorVariable.prototype = Object.create(Variable.prototype);
ErrorVariable.prototype.constructor = ErrorVariable;

ErrorVariable.prototype.toString = function() {
	return this.name;
};

ErrorVariable.prototype.getType = function(context) {
	return new EnumeratedCategoryType(new Identifier("Error"));
};

exports.ErrorVariable = ErrorVariable;


/***/ }),
/* 181 */
/***/ (function(module, exports, __webpack_require__) {

var PromptoError = __webpack_require__(30).PromptoError;
var CategoryType = null;
var Score = __webpack_require__(249).Score;

exports.resolve = function() {
	CategoryType = __webpack_require__(7).CategoryType;
}

function MethodFinder(context, methodCall) {
	this.context = context;
	this.methodCall = methodCall;
	return this;
}

MethodFinder.prototype.findCompatibleMethods = function(checkInstance, allowDerived) {
    var candidates = this.methodCall.selector.getCandidates(this.context, checkInstance);
    if(candidates.size==0)
        this.context.problemListener.reportUnknownMethod(this.methodCall.selector.id);
    return this.filterCompatible(candidates, checkInstance, allowDerived);
};

MethodFinder.prototype.findMethod = function(checkInstance) {
	var compatibles = this.findCompatibleMethods(checkInstance, false);
	switch(compatibles.size) {
	case 0:
		this.context.problemListener.reportNoMatchingPrototype(this.methodCall);
		return null;
	case 1:
		return compatibles.values().next().value;
	default:
		return this.findMostSpecific(compatibles, checkInstance);
	}
};

MethodFinder.prototype.findMostSpecific = function(candidates, checkInstance) {
	var candidate = null;
	var ambiguous = [];
	candidates.forEach(function(c) {
		if(candidate==null)
			candidate = c;
		else {
			var score = this.scoreMostSpecific(candidate, c, checkInstance);
			switch(score) {
			case Score.WORSE:
				candidate = c;
				ambiguous = [];
				break;
			case Score.BETTER:
				break;
			case Score.SIMILAR:
				ambiguous.push(c);
				break;
			}
		}
	}, this);
	if(ambiguous.length>0) {
		throw new SyntaxError("Too many prototypes!"); // TODO refine
	}
	return candidate;
}

MethodFinder.prototype.sortMostSpecificFirst = function(declarations) {
    var self = this;
    declarations = Array.from(declarations);
    // console.error("sorting:"+ declarations.map(function(decl) { return decl.getProto(); }).join(","));
    declarations.sort(function(d1, d2) {
        // console.error( d1.getProto() + "/" + d2.getProto() );
        var score = self.scoreMostSpecific(d2, d1, false, true);
        // console.error( "-> " + score.name );
        return score.value;
    });
    // console.error("sorted:"+ declarations.map(function(decl) { return decl.getProto(); }).join(","));
    return declarations;
};

MethodFinder.prototype.scoreMostSpecific = function(decl1, decl2, checkInstance, allowDerived) {
	try {
        var ctx1 = this.context.newLocalContext();
		decl1.registerArguments(ctx1);
		var ctx2 = this.context.newLocalContext();
		decl2.registerArguments(ctx2);
		var ass1 = this.methodCall.makeAssignments(this.context, decl1);
		var ass2 = this.methodCall.makeAssignments(this.context, decl2);
		for(var i=0;i<ass1.length && i<ass2.length;i++) {
			var as1 = ass1[i];
			var as2 = ass2[i];
			var arg1 = decl1.args.find(as1.name);
			var arg2 = decl2.args.find(as2.name);
			if(as1.name===as2.name) {
				// the general case with named arguments
				var typ1 = arg1.getType(ctx1);
				var typ2 = arg2.getType(ctx2);
				// try resolving runtime type
				if(checkInstance && typ1 instanceof CategoryType && typ2 instanceof CategoryType) {
					var value = as1.expression.interpret(this.context); // in the named case as1==as2, so only evaluate 1
					if(value.getType) {
						var actual = value.getType();
						var score = actual.scoreMostSpecific(this.context, typ1, typ2);
						if(score!==Score.SIMILAR) {
							return score;
						}
					}
				}
				if(typ1.isMoreSpecificThan(ctx2, typ2)) {
                    // console.error(typ1.name + " is more specific than " + typ2.name);
					return Score.BETTER;
				}
				if(typ2.isMoreSpecificThan(ctx1, typ1)) {
                    // console.error(typ2.name + " is more specific than " + typ1.name);
                    return Score.WORSE;
				}
			} else {
				// specific case for single anonymous argument
				var sp1 = as1.computeSpecificity(ctx1, arg1, decl1, checkInstance, allowDerived);
				var sp2 = as2.computeSpecificity(ctx2, arg2, decl2, checkInstance, allowDerived);
				if(sp1.moreSpecificThan(sp2)) {
					return Score.BETTER;
				}
				if(sp2.moreSpecificThan(sp1)) {
					return Score.WORSE;
				}
			}
		}
	} catch(error) {
		if(!(error instanceof PromptoError)) {
			throw error;
		}
	}
	return Score.SIMILAR;
}

MethodFinder.prototype.filterCompatible = function(candidates, checkInstance, allowDerived) {
	var compatibles = new Set();
	candidates.forEach(function(declaration) {
        try {
			var assignments = this.methodCall.makeAssignments(this.context, declaration);
			if(declaration.isAssignableTo(this.context, assignments, checkInstance, allowDerived)) {
				compatibles.add(declaration);
			}
		} catch(e) {
			if(!(e instanceof SyntaxError)) {
				throw e;
			}
			// else OK
		}
	}, this);
	return compatibles;
};


exports.MethodFinder = MethodFinder;

/***/ }),
/* 182 */
/***/ (function(module, exports, __webpack_require__) {

var SyntaxError = __webpack_require__(32).SyntaxError;

function SymbolExpression(id) {
    this.id = id;
	return this;
}

Object.defineProperty(SymbolExpression.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});

SymbolExpression.prototype.toDialect = function(writer) {
    writer.append(this.name);
};

SymbolExpression.prototype.check = function(context) {
	var symbol = context.getRegisteredValue(this.name);
	if(symbol==null) {
		throw new SyntaxError("Unknown symbol:" + this.name);
	}
	return symbol.check(context);
};

SymbolExpression.prototype.interpret = function(context) {
	var symbol = context.getRegisteredValue(this.name);
	if(symbol==null) {
		throw new SyntaxError("Unknown symbol:" + this.name);
	}
	return symbol.interpret(context);
};

SymbolExpression.prototype.declare = function(transpiler) {
    var symbol = transpiler.context.getRegisteredValue(this.name);
    symbol.declare(transpiler);
};


SymbolExpression.prototype.transpile = function(transpiler) {
    var symbol = transpiler.context.getRegisteredValue(this.name);
    symbol.transpile(transpiler);
};


exports.SymbolExpression = SymbolExpression;

/***/ }),
/* 183 */
/***/ (function(module, exports, __webpack_require__) {

var TypeValue = __webpack_require__(142).TypeValue;

function TypeExpression(value) {
	this.value = value;
	return this;
}

TypeExpression.prototype.toDialect = function(writer) {
    writer.append(this.value.toString());
};

TypeExpression.prototype.check = function(context) {
	return this.value;
};

TypeExpression.prototype.toString = function() {
    return this.value.toString();
};

TypeExpression.prototype.interpret = function(context) {
	return new TypeValue(this.value);
};


TypeExpression.prototype.declare = function(transpiler) {
    this.value.declare(transpiler);
};


TypeExpression.prototype.transpile = function(transpiler) {
    this.value.transpile(transpiler);
};


TypeExpression.prototype.getMemberValue = function(context, name) {
	return this.value.getMemberValue(context, name);
};

exports.TypeExpression = TypeExpression;

/***/ }),
/* 184 */
/***/ (function(module, exports, __webpack_require__) {

var isNodeJs = typeof window === 'undefined' && typeof importScripts === 'undefined';
var fs = isNodeJs ? __webpack_require__(90) : {}; // nodejs only
var antlr4 = __webpack_require__(9);
var EIndentingLexer = __webpack_require__(250).EIndentingLexer;
var EParser = __webpack_require__(251).EParser;
var EPromptoBuilder = __webpack_require__(253).EPromptoBuilder;

function createInput(input) {
	if(typeof(input)==='string' || input instanceof String) {
		if(isNodeJs && fs.existsSync(input)) {
			input = new antlr4.FileStream(input);
		} else {
			input = new antlr4.InputStream(input);
		}
	}
	if(input instanceof antlr4.InputStream) {
		input = new EIndentingLexer(input);
	}
	if(input instanceof antlr4.Lexer) {
		input = new antlr4.CommonTokenStream(input);
	}
	return input;
}

function ECleverParser(input) {
	EParser.call(this,createInput(input));
	this.path = "";
	return this;
}

ECleverParser.prototype = Object.create(EParser.prototype);
ECleverParser.prototype.constructor = ECleverParser;

ECleverParser.prototype.parse = function() {
	return this.parse_declaration_list();
};
	
ECleverParser.prototype.parse_declaration_list = function() {
	return this.doParse(this.declaration_list, true);
};

ECleverParser.prototype.parse_standalone_type = function() {
    return this.doParse(this.category_or_any_type, false);
};

ECleverParser.prototype.doParse = function(rule, addLF) {
    this.getTokenStream().tokenSource.addLF = addLF;
    var tree = rule.bind(this)();
    var builder = new EPromptoBuilder(this);
    var walker = new antlr4.tree.ParseTreeWalker();
    walker.walk(builder, tree);
    return builder.getNodeValue(tree);
};

exports.ECleverParser = ECleverParser;

/***/ }),
/* 185 */
/***/ (function(module, exports, __webpack_require__) {

var Parser = __webpack_require__(9).Parser;

function AbstractParser(input) {
	Parser.call(this, input);
	return this;
}

AbstractParser.prototype = Object.create(Parser.prototype);
AbstractParser.prototype.constructor = AbstractParser;

AbstractParser.prototype.isText = function(token, text) {
	return text === token.text;
};

AbstractParser.prototype.was = function(type) {
	return this.lastHiddenTokenType()===type;
};

AbstractParser.prototype.wasNot = function(type) {
	return this.lastHiddenTokenType()!==type;
};

AbstractParser.prototype.wasNotWhiteSpace = function() {
    return this.lastHiddenTokenType()!==this["WS"];
};

AbstractParser.prototype.willBe = function(type) {
	return this.getTokenStream().LA(1)===type;
};

AbstractParser.prototype.willNotBe = function(type) {
	return this.getTokenStream().LA(1)!==type;
};

AbstractParser.prototype.nextHiddenTokenType = function() {
	var bts = this.getTokenStream();
	var hidden = bts.getHiddenTokensToRight(bts.index-1);
	if(hidden===null || hidden.length===0) {
		return 0;
	} else {
		return hidden[0].type;
	}
};

AbstractParser.prototype.willBeAOrAn = function() {
    return this.willBeText("a") || this.willBeText("an");
};

AbstractParser.prototype.willBeText = function(text) {
    return text===this.getTokenStream().LT(1).text;
};

AbstractParser.prototype.lastHiddenTokenType = function() {
	var bts = this.getTokenStream();
	var hidden = bts.getHiddenTokensToLeft(bts.index);
	if(hidden===null || hidden.length===0) {
		return 0;
	} else {
		return hidden[hidden.length-1].type;
	}
};

AbstractParser.prototype.removeErrorListeners = function() {
    Parser.prototype.removeErrorListeners.call(this);
    this._input.tokenSource.removeErrorListeners(); // lexer
};

AbstractParser.prototype.addErrorListener = function(listener) {
    Parser.prototype.addErrorListener.call(this, listener);
    this._input.tokenSource.addErrorListener(listener); // lexer
};

exports.AbstractParser = AbstractParser;

/***/ }),
/* 186 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var Container = __webpack_require__(1).Container;
var IntegerValue = __webpack_require__(3).IntegerValue;
var PromptoError = __webpack_require__(30).PromptoError;
var InternalError = __webpack_require__(46).InternalError;
var IndexOutOfRangeError = __webpack_require__(179).IndexOutOfRangeError;

/* an abstract list of values, common to ListValue and TupleValue */
function BaseValueList(type, items, item, mutable) {
    Container.call(this, type);
	this.items = items || [];
    item = item || null;
    if(item!==null) {
        this.add(item);
    }
    this.mutable = mutable || false;
    return this;
}

BaseValueList.prototype = Object.create(Container.prototype);
BaseValueList.prototype.constructor = BaseValueList;

BaseValueList.prototype.toString = function() {
	return "[" + this.items.join(", ") + "]";
};

BaseValueList.prototype.add = function(o) {
	this.items.push(o);
};


BaseValueList.prototype.setItem = function(index, value) {
    this.items[index] = value;
};


BaseValueList.prototype.setItemInContext = function(context, index, value) {
    if (index instanceof IntegerValue) {
        var idx = index.IntegerValue() - 1;
        if (idx > this.items.length) {
            throw new IndexOutOfRangeError();
        }
        this.items[idx] = value;
    } else
        throw new SyntaxError("No such item:" + index.toString())
};


BaseValueList.prototype.get = function(index) {
	return this.items[index];
};

BaseValueList.prototype.size = function() {
	return this.items.length;
};


BaseValueList.prototype.isEmpty = function() {
	return this.items.length===0;
};

BaseValueList.prototype.slice = function(fi, li) {
	var first = this.checkFirst(fi);
	var last = this.checkLast(li);
	var items = this.items.slice(first-1,last);
	return this.newInstance(items);
};

BaseValueList.prototype.checkFirst = function(fi) {
	var value = (fi == null) ? 1 : fi.IntegerValue();
	if (value < 1 || value > this.items.length) {
		throw new IndexOutOfRangeError();
	}
	return value;
};

BaseValueList.prototype.checkLast = function(li) {
	var value = (li == null) ? this.items.length : li.IntegerValue();
	if (value < 0) {
		value = this.items.length + 1 + li.IntegerValue();
	}
	if (value < 1 || value > this.items.length) {
		throw new IndexOutOfRangeError();
	}
	return value;
};

BaseValueList.prototype.hasItem = function(context, lval) {
	for (var i=0;i<this.items.length;i++) {
		if (this.items[i].equals(lval))
			return true;
	}
	return false;
};

BaseValueList.prototype.getItemInContext = function(context, index) {
	if (index instanceof IntegerValue) {
		try {
			var idx = index.IntegerValue() - 1;
			if(idx>this.items.length) {
				throw new IndexOutOfRangeError();
			}
			var value = this.items[idx] || null;
			if(value==null) {
				return null;
			}
			if (value instanceof Value) {
				return value;
			} else {
				throw new InternalError("Item not a value!");
			}
		} catch (e) {
			if(e instanceof PromptoError) {
				throw e;
			} else {
				throw new InternalError(e.toString());
			}
		}
	} else
		throw new SyntaxError("No such item:" + index.toString());
};

BaseValueList.prototype.equals = function(obj) {
	if(obj instanceof BaseValueList) {
		if(this.items.length!=obj.items.length) {
			return false;
		} else {
			for(var i=0;i<this.items.length;i++) {
				var v1 = this.items[i] || null;
				var v2 = obj.items[i] || null;
				if(v1==v2) {
					continue;
				} else if(v1==null || v2==null) {
					return false;
				} else {
					if(v1.equals) {
						if(!v1.equals(v2)) {
							return false;
						}
					} else if(v2.equals) {
						if(!v2.equals(v1)) {
							return false;
						}
					} else {
						return false;
					}
				}
			}
			return true;
		}
	} else {
		return false;
	}
};


BaseValueList.prototype.getMemberValue = function(context, name) {
	if ("count"==name) {
		return new IntegerValue(this.items.length);
	} else {
		return Container.prototype.getMemberValue.call(this, context, name);
	}
};

BaseValueList.prototype.getIterator = function(context) {
	return new ListIterator(this.items, context);
};

function ListIterator(items, context) {
	this.items = items;
	this.context = context;
	this.index = -1;
	return this;
}

ListIterator.prototype.hasNext = function () {
	return this.index < this.items.length - 1;
}

ListIterator.prototype.next = function() {
	return this.items[++this.index];
};

BaseValueList.prototype.toDialect = function(writer) {
    if(this.items.length>0) {
        this.items.forEach(function(o) {
            if(o.toDialect)
                o.toDialect(writer);
            else
                writer.append(o.toString());
            writer.append(", ");
        });
        writer.trimLast(2);
    }
};

BaseValueList.prototype.toJson = function(context, json, instanceId, fieldName, withType, binaries) {
    var values = [];
    this.items.map(function(item) {
        item.toJson(context, values, instanceId, fieldName, withType, binaries);
    });
    if(Array.isArray(json))
        json.push(values);
    else
        json[fieldName] = values;

};



exports.BaseValueList = BaseValueList;

/***/ }),
/* 187 */
/***/ (function(module, exports, __webpack_require__) {

var BaseMethodDeclaration = __webpack_require__(75).BaseMethodDeclaration;
var ArgumentList = __webpack_require__(147).ArgumentList;
var BuiltInContext = __webpack_require__(11).BuiltInContext;

function BuiltInMethodDeclaration(name) {
    var args = null;
    if ( arguments.length > 1 ) {
        args = new ArgumentList();
        for(var i = 1;i<arguments.length; i++) {
            args.add(arguments[i]);
        }
    }
    BaseMethodDeclaration.call(this, name, args);
    return this;
}

BuiltInMethodDeclaration.prototype = Object.create(BaseMethodDeclaration.prototype);
BuiltInMethodDeclaration.prototype.constructor = BuiltInMethodDeclaration;

BuiltInMethodDeclaration.prototype.getValue = function(context) {
    while (context) {
        if (context instanceof BuiltInContext)
            return context.value;
        context = context.getParentContext();
    }
    throw new InternalError("Could not locate context for built-in value!");
};

BuiltInMethodDeclaration.prototype.transpileCall = function(transpiler, assignments) {
    throw new Error("Need to override transpileCall in " + this.constructor.name);
};

exports.BuiltInMethodDeclaration = BuiltInMethodDeclaration;


/***/ }),
/* 188 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;

function ContextualExpression(calling, expression) {
	Value.call(this, null); // TODO check that this is not a problem
	this.calling = calling;
	this.expression = expression;
	return this;
}

ContextualExpression.prototype = Object.create(Value.prototype);
ContextualExpression.prototype.constructor = ContextualExpression;

ContextualExpression.prototype.toDialect = function(dialect) {
	return this.expression.toDialect(dialect);
};

ContextualExpression.prototype.check = function(context) {
	return this.expression.check(this.calling);
};

ContextualExpression.prototype.interpret = function(context) {
	return this.expression.interpret(this.calling);
};

ContextualExpression.prototype.transpile = function(transpiler) {
    transpiler = transpiler.newChildTranspiler(this.calling);
    this.expression.transpile(transpiler);
    transpiler.flush();
};

exports.ContextualExpression = ContextualExpression;

/***/ }),
/* 189 */
/***/ (function(module, exports, __webpack_require__) {

var ConcreteCategoryDeclaration = __webpack_require__(52).ConcreteCategoryDeclaration;
var CategoryType = __webpack_require__(7).CategoryType;
var IdentifierList = __webpack_require__(115).IdentifierList;


function ConcreteWidgetDeclaration(name, derivedFrom, methods) {
    derivedFrom = derivedFrom==null ? null : new IdentifierList(derivedFrom);
    ConcreteCategoryDeclaration.call(this, name, null, derivedFrom, methods);
    return this;
}

ConcreteWidgetDeclaration.prototype = Object.create(ConcreteCategoryDeclaration.prototype);
ConcreteWidgetDeclaration.prototype.constructor = ConcreteWidgetDeclaration;


ConcreteWidgetDeclaration.prototype.isWidget = function(context) {
    return true;
};


ConcreteWidgetDeclaration.prototype.getDeclarationType = function() {
    return "Widget";
};


ConcreteWidgetDeclaration.prototype.categoryTypeToEDialect = function(writer) {
    if(this.derivedFrom==null)
        writer.append("widget");
    else
        this.derivedFrom.toDialect(writer, true);
};


ConcreteWidgetDeclaration.prototype.categoryTypeToODialect = function(writer) {
    writer.append("widget");
};


ConcreteWidgetDeclaration.prototype.categoryTypeToMDialect = function(writer) {
    writer.append("widget");
};


ConcreteWidgetDeclaration.prototype.declareRoot = function(transpiler) {
    // nothing to do
};


ConcreteWidgetDeclaration.prototype.transpile = function(transpiler) {
    var parent = this.derivedFrom!=null && this.derivedFrom.length>0 ? this.derivedFrom[0] : null;
    transpiler.append("function ").append(this.name).append("() {");
    transpiler.indent();
    this.transpileGetterSetterAttributes(transpiler);
    this.transpileSuperConstructor(transpiler);
    this.transpileLocalAttributes(transpiler);
    transpiler.append("return this;");
    transpiler.dedent();
    transpiler.append("}");
    transpiler.newLine();
    if(parent!=null)
        transpiler.append(this.name).append(".prototype = Object.create(").append(parent.toString()).append(".prototype);").newLine();
    else
        transpiler.append(this.name).append(".prototype = Object.create(React.Component.prototype);").newLine();
    transpiler.append(this.name).append(".prototype.constructor = ").append(this.name).append(";").newLine();
    transpiler = transpiler.newInstanceTranspiler(new CategoryType(this.id));
    this.transpileLoaders(transpiler);
    this.transpileMethods(transpiler);
    this.transpileGetterSetters(transpiler);
    transpiler.flush();
    return true;
};


ConcreteWidgetDeclaration.prototype.transpileRootConstructor = function(transpiler) {
    return transpiler.append("React.Component.call(this);");
};

exports.ConcreteWidgetDeclaration = ConcreteWidgetDeclaration;


/***/ }),
/* 190 */
/***/ (function(module, exports, __webpack_require__) {

var BaseMethodDeclaration = __webpack_require__(75).BaseMethodDeclaration;
var VoidType = __webpack_require__(4).VoidType;
var CodeArgument = __webpack_require__(116).CodeArgument;

function AbstractMethodDeclaration(id, args, returnType) {
	BaseMethodDeclaration.call(this, id, args, returnType);
    this.returnType = returnType || VoidType.instance;
	return this;
}

AbstractMethodDeclaration.prototype = Object.create(BaseMethodDeclaration.prototype);
AbstractMethodDeclaration.prototype.constructor = AbstractMethodDeclaration;

AbstractMethodDeclaration.prototype.memberCheck = function(declaration, context) {
    // TODO Auto-generated method stub
};

AbstractMethodDeclaration.prototype.check = function(context, isStart) {
	if(this.args!=null) {
		this.args.check(context);
	}
	if(isStart) {
	    var local = context.newLocalContext();
        this.registerArguments(local);
    }
	return this.returnType;
};

AbstractMethodDeclaration.prototype.declare = function(transpiler) {
    this.declareArguments(transpiler);
};

AbstractMethodDeclaration.prototype.transpile = function(transpiler) {
    // nothing to do
};

AbstractMethodDeclaration.prototype.toMDialect = function(writer) {
    writer.append("abstract def ");
    writer.append(this.name);
    writer.append(" (");
    this.args.toDialect(writer);
    writer.append(")");
    if(this.returnType!=null && this.returnType!=VoidType.instance) {
        writer.append("->");
        this.returnType.toDialect(writer);
    }
}

AbstractMethodDeclaration.prototype.toEDialect = function(writer) {
    writer.append("define ");
    writer.append(this.name);
    writer.append(" as abstract method ");
    this.args.toDialect(writer);
    if(this.returnType!=null && this.returnType!=VoidType.instance) {
        writer.append("returning ");
        this.returnType.toDialect(writer);
    }
};

AbstractMethodDeclaration.prototype.toODialect = function(writer) {
    writer.append("abstract ");
    if(this.returnType!=null && this.returnType!=VoidType.instance) {
        this.returnType.toDialect(writer);
        writer.append(" ");
    }
    writer.append("method ");
    writer.append(this.name);
    writer.append(" (");
    this.args.toDialect(writer);
    writer.append(");");
}

exports.AbstractMethodDeclaration = AbstractMethodDeclaration;


/***/ }),
/* 191 */
/***/ (function(module, exports, __webpack_require__) {

var ConcreteMethodDeclaration = null;
var ExpressionValue = __webpack_require__(76).ExpressionValue;
var ClosureValue = __webpack_require__(97).ClosureValue;
var BaseStatement = __webpack_require__(35).BaseStatement;
var MethodType = __webpack_require__(38).MethodType;
var VoidType = __webpack_require__(4).VoidType;
var Variable = __webpack_require__(10).Variable;
var InstanceContext = __webpack_require__(11).InstanceContext;

exports.resolve = function() {
    ConcreteMethodDeclaration = __webpack_require__(78).ConcreteMethodDeclaration;
};

function DeclarationStatement(declaration) {
	BaseStatement.call(this);
	this.declaration = declaration;
    this.declaration.declarationStatement = this;
    if(declaration instanceof ConcreteMethodDeclaration)
        declaration.declarationOf = this;
	return this;
}

DeclarationStatement.prototype = Object.create(BaseStatement.prototype);
DeclarationStatement.prototype.constructor = DeclarationStatement;

DeclarationStatement.prototype.toDialect = function(writer) {
    if(this.declaration instanceof ConcreteMethodDeclaration) try {
        writer.context.registerMethodDeclaration(this.declaration);
     } catch(e) {
        // ok
     }
    this.declaration.toDialect(writer);
};


DeclarationStatement.prototype.check = function(context) {
	if(this.declaration instanceof ConcreteMethodDeclaration) {
		this.declaration.checkChild(context);
		context.registerMethodDeclaration(this.declaration);
	} else {
		throw new SyntaxError("Unsupported:" + typeof(declaration));
	}
	return VoidType.instance;
};

DeclarationStatement.prototype.interpret = function(context) {
	if(this.declaration instanceof ConcreteMethodDeclaration) {
		var method = this.declaration;
		context.registerMethodDeclaration(method);
		var type = new MethodType(method);
		context.registerValue(new Variable(method.id, type));
		context.setValue(method.id, new ClosureValue(context, type));
		return null;
	} else {
		throw new SyntaxError("Unsupported:" + typeof(this.declaration));
	}
};

DeclarationStatement.prototype.declare = function(transpiler) {
	this.declaration.declareChild(transpiler);
    transpiler.context.registerMethodDeclaration(this.declaration);
};

DeclarationStatement.prototype.transpile = function(transpiler) {
    this.declaration.transpile(transpiler);
    transpiler.context.registerMethodDeclaration(this.declaration);
    var instance = transpiler.context.getClosestInstanceContext();
    if(instance!=null) {
        var name = this.declaration.getTranspiledName(transpiler.context);
        transpiler.append(name).append(" = ").append(name).append(".bind(this);").newLine();
    }
    return true;
};

exports.DeclarationStatement = DeclarationStatement;


/***/ }),
/* 192 */
/***/ (function(module, exports, __webpack_require__) {

exports.Any = __webpack_require__(140).Any;
exports.Blob = __webpack_require__(193).Blob;
exports.Cursor = __webpack_require__(203).Cursor;
exports.DateTime = __webpack_require__(204).DateTime;
exports.Dictionary = __webpack_require__(150).Dictionary;
exports.Document = __webpack_require__(98).Document;
exports.List = __webpack_require__(29).List;
exports.LocalDate = __webpack_require__(120).LocalDate;
exports.LocalTime = __webpack_require__(121).LocalTime;
exports.Period = __webpack_require__(104).Period;
exports.Range = __webpack_require__(117).Range;
exports.StrictSet = __webpack_require__(34).StrictSet;
exports.Tuple = __webpack_require__(294).Tuple;
exports.UUID = __webpack_require__(154).UUID;
exports.Version = __webpack_require__(155).Version;


/***/ }),
/* 193 */
/***/ (function(module, exports, __webpack_require__) {

var utf8BufferToString = __webpack_require__(16).utf8BufferToString;

function Blob(data) {
    this.data = data;
    return this;
}

Blob.ofValue = function(value) {
    var binaries = {};
    // create json type-aware object graph and collect binaries
    var values = {}; // need a temporary parent
    value.toJson(values, null, "value", true, binaries);
    var json = JSON.stringify(values["value"]);
    // add it
    binaries["value.json"] = stringToUtf8Buffer(json);
    // zip binaries
    var zipped = Blob.zipDatas(binaries)
    // done
    return new Blob(zipped);
};

Blob.zipDatas = function(datas) {
    var JSZip = __webpack_require__(264);
    var zip = new JSZip();
    return zip.sync(function() {
        for (var key in datas)
            zip.file(key, datas[key]);
        var result = null;
        zip.generateAsync({type: "arraybuffer", compression: "DEFLATE"}).
        then(function(value) {
            result = value;
        });
        return result;
    });
};


Blob.readParts = function(data) {
    var JSZip = __webpack_require__(264);
    var zip = new JSZip();
    return zip.sync(function() {
        var parts = {};
        zip.loadAsync(data);
        zip.forEach(function (entry) {
            zip.file(entry)
                .async("arraybuffer")
                .then(function(value) {
                    parts[entry] = value;
                });
        });
        return parts;
    });
};

Blob.readValue = function(parts) {
    var data = parts["value.json"] || null;
    if (data == null)
        throw new Error("Expecting a 'value.json' part!");
    var json = utf8BufferToString(data);
    return JSON.parse(json);
};



Blob.prototype.toDocument = function() {
    var parts = Blob.readParts(this.data);
    var value = Blob.readValue(parts);
    var typeName = value["type"] || null;
    if (typeName == null)
        throw new Error("Expecting a 'type' field!");
    var type = eval(typeName)
    if (type != Document)
        throw new Error("Expecting a Document type!");
    value = value["value"] || null;
    if (value == null)
        throw new Error("Expecting a 'value' field!");
    var instance = new type();
    instance.fromJson(value, parts);
    return instance;
};


exports.Blob = Blob;

/***/ }),
/* 194 */
/***/ (function(module, exports) {

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

function EventEmitter() {
  this._events = this._events || {};
  this._maxListeners = this._maxListeners || undefined;
}
module.exports = EventEmitter;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;

EventEmitter.prototype._events = undefined;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
EventEmitter.defaultMaxListeners = 10;

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function(n) {
  if (!isNumber(n) || n < 0 || isNaN(n))
    throw TypeError('n must be a positive number');
  this._maxListeners = n;
  return this;
};

EventEmitter.prototype.emit = function(type) {
  var er, handler, len, args, i, listeners;

  if (!this._events)
    this._events = {};

  // If there is no 'error' event listener then throw.
  if (type === 'error') {
    if (!this._events.error ||
        (isObject(this._events.error) && !this._events.error.length)) {
      er = arguments[1];
      if (er instanceof Error) {
        throw er; // Unhandled 'error' event
      } else {
        // At least give some kind of context to the user
        var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
        err.context = er;
        throw err;
      }
    }
  }

  handler = this._events[type];

  if (isUndefined(handler))
    return false;

  if (isFunction(handler)) {
    switch (arguments.length) {
      // fast cases
      case 1:
        handler.call(this);
        break;
      case 2:
        handler.call(this, arguments[1]);
        break;
      case 3:
        handler.call(this, arguments[1], arguments[2]);
        break;
      // slower
      default:
        args = Array.prototype.slice.call(arguments, 1);
        handler.apply(this, args);
    }
  } else if (isObject(handler)) {
    args = Array.prototype.slice.call(arguments, 1);
    listeners = handler.slice();
    len = listeners.length;
    for (i = 0; i < len; i++)
      listeners[i].apply(this, args);
  }

  return true;
};

EventEmitter.prototype.addListener = function(type, listener) {
  var m;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events)
    this._events = {};

  // To avoid recursion in the case that type === "newListener"! Before
  // adding it to the listeners, first emit "newListener".
  if (this._events.newListener)
    this.emit('newListener', type,
              isFunction(listener.listener) ?
              listener.listener : listener);

  if (!this._events[type])
    // Optimize the case of one listener. Don't need the extra array object.
    this._events[type] = listener;
  else if (isObject(this._events[type]))
    // If we've already got an array, just append.
    this._events[type].push(listener);
  else
    // Adding the second element, need to change to array.
    this._events[type] = [this._events[type], listener];

  // Check for listener leak
  if (isObject(this._events[type]) && !this._events[type].warned) {
    if (!isUndefined(this._maxListeners)) {
      m = this._maxListeners;
    } else {
      m = EventEmitter.defaultMaxListeners;
    }

    if (m && m > 0 && this._events[type].length > m) {
      this._events[type].warned = true;
      console.error('(node) warning: possible EventEmitter memory ' +
                    'leak detected. %d listeners added. ' +
                    'Use emitter.setMaxListeners() to increase limit.',
                    this._events[type].length);
      if (typeof console.trace === 'function') {
        // not supported in IE 10
        console.trace();
      }
    }
  }

  return this;
};

EventEmitter.prototype.on = EventEmitter.prototype.addListener;

EventEmitter.prototype.once = function(type, listener) {
  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  var fired = false;

  function g() {
    this.removeListener(type, g);

    if (!fired) {
      fired = true;
      listener.apply(this, arguments);
    }
  }

  g.listener = listener;
  this.on(type, g);

  return this;
};

// emits a 'removeListener' event iff the listener was removed
EventEmitter.prototype.removeListener = function(type, listener) {
  var list, position, length, i;

  if (!isFunction(listener))
    throw TypeError('listener must be a function');

  if (!this._events || !this._events[type])
    return this;

  list = this._events[type];
  length = list.length;
  position = -1;

  if (list === listener ||
      (isFunction(list.listener) && list.listener === listener)) {
    delete this._events[type];
    if (this._events.removeListener)
      this.emit('removeListener', type, listener);

  } else if (isObject(list)) {
    for (i = length; i-- > 0;) {
      if (list[i] === listener ||
          (list[i].listener && list[i].listener === listener)) {
        position = i;
        break;
      }
    }

    if (position < 0)
      return this;

    if (list.length === 1) {
      list.length = 0;
      delete this._events[type];
    } else {
      list.splice(position, 1);
    }

    if (this._events.removeListener)
      this.emit('removeListener', type, listener);
  }

  return this;
};

EventEmitter.prototype.removeAllListeners = function(type) {
  var key, listeners;

  if (!this._events)
    return this;

  // not listening for removeListener, no need to emit
  if (!this._events.removeListener) {
    if (arguments.length === 0)
      this._events = {};
    else if (this._events[type])
      delete this._events[type];
    return this;
  }

  // emit removeListener for all listeners on all events
  if (arguments.length === 0) {
    for (key in this._events) {
      if (key === 'removeListener') continue;
      this.removeAllListeners(key);
    }
    this.removeAllListeners('removeListener');
    this._events = {};
    return this;
  }

  listeners = this._events[type];

  if (isFunction(listeners)) {
    this.removeListener(type, listeners);
  } else if (listeners) {
    // LIFO order
    while (listeners.length)
      this.removeListener(type, listeners[listeners.length - 1]);
  }
  delete this._events[type];

  return this;
};

EventEmitter.prototype.listeners = function(type) {
  var ret;
  if (!this._events || !this._events[type])
    ret = [];
  else if (isFunction(this._events[type]))
    ret = [this._events[type]];
  else
    ret = this._events[type].slice();
  return ret;
};

EventEmitter.prototype.listenerCount = function(type) {
  if (this._events) {
    var evlistener = this._events[type];

    if (isFunction(evlistener))
      return 1;
    else if (evlistener)
      return evlistener.length;
  }
  return 0;
};

EventEmitter.listenerCount = function(emitter, type) {
  return emitter.listenerCount(type);
};

function isFunction(arg) {
  return typeof arg === 'function';
}

function isNumber(arg) {
  return typeof arg === 'number';
}

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}

function isUndefined(arg) {
  return arg === void 0;
}


/***/ }),
/* 195 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(267);
exports.Stream = exports;
exports.Readable = exports;
exports.Writable = __webpack_require__(197);
exports.Duplex = __webpack_require__(80);
exports.Transform = __webpack_require__(271);
exports.PassThrough = __webpack_require__(380);


/***/ }),
/* 196 */
/***/ (function(module, exports, __webpack_require__) {

/* eslint-disable node/no-deprecated-api */
var buffer = __webpack_require__(102)
var Buffer = buffer.Buffer

// alternative to using Object.keys for old browsers
function copyProps (src, dst) {
  for (var key in src) {
    dst[key] = src[key]
  }
}
if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
  module.exports = buffer
} else {
  // Copy properties from require('buffer')
  copyProps(buffer, exports)
  exports.Buffer = SafeBuffer
}

function SafeBuffer (arg, encodingOrOffset, length) {
  return Buffer(arg, encodingOrOffset, length)
}

// Copy static methods from Buffer
copyProps(Buffer, SafeBuffer)

SafeBuffer.from = function (arg, encodingOrOffset, length) {
  if (typeof arg === 'number') {
    throw new TypeError('Argument must not be a number')
  }
  return Buffer(arg, encodingOrOffset, length)
}

SafeBuffer.alloc = function (size, fill, encoding) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  var buf = Buffer(size)
  if (fill !== undefined) {
    if (typeof encoding === 'string') {
      buf.fill(fill, encoding)
    } else {
      buf.fill(fill)
    }
  } else {
    buf.fill(0)
  }
  return buf
}

SafeBuffer.allocUnsafe = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return Buffer(size)
}

SafeBuffer.allocUnsafeSlow = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number')
  }
  return buffer.SlowBuffer(size)
}


/***/ }),
/* 197 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process, setImmediate, global) {// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// A bit simpler than readable streams.
// Implement an async ._write(chunk, encoding, cb), and it'll handle all
// the drain event emission and buffering.



/*<replacement>*/

var processNextTick = __webpack_require__(151);
/*</replacement>*/

module.exports = Writable;

/* <replacement> */
function WriteReq(chunk, encoding, cb) {
  this.chunk = chunk;
  this.encoding = encoding;
  this.callback = cb;
  this.next = null;
}

// It seems a linked list but it is not
// there will be only 2 of these for each stream
function CorkedRequest(state) {
  var _this = this;

  this.next = null;
  this.entry = null;
  this.finish = function () {
    onCorkedFinish(_this, state);
  };
}
/* </replacement> */

/*<replacement>*/
var asyncWrite = !process.browser && ['v0.10', 'v0.9.'].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : processNextTick;
/*</replacement>*/

/*<replacement>*/
var Duplex;
/*</replacement>*/

Writable.WritableState = WritableState;

/*<replacement>*/
var util = __webpack_require__(119);
util.inherits = __webpack_require__(103);
/*</replacement>*/

/*<replacement>*/
var internalUtil = {
  deprecate: __webpack_require__(379)
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__(268);
/*</replacement>*/

/*<replacement>*/
var Buffer = __webpack_require__(196).Buffer;
var OurUint8Array = global.Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}
/*</replacement>*/

var destroyImpl = __webpack_require__(269);

util.inherits(Writable, Stream);

function nop() {}

function WritableState(options, stream) {
  Duplex = Duplex || __webpack_require__(80);

  options = options || {};

  // object stream flag to indicate whether or not this stream
  // contains buffers or objects.
  this.objectMode = !!options.objectMode;

  if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

  // the point at which write() starts returning false
  // Note: 0 is a valid value, means that we always return false if
  // the entire buffer is not flushed immediately on write()
  var hwm = options.highWaterMark;
  var defaultHwm = this.objectMode ? 16 : 16 * 1024;
  this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;

  // cast to ints.
  this.highWaterMark = Math.floor(this.highWaterMark);

  // if _final has been called
  this.finalCalled = false;

  // drain event flag.
  this.needDrain = false;
  // at the start of calling end()
  this.ending = false;
  // when end() has been called, and returned
  this.ended = false;
  // when 'finish' is emitted
  this.finished = false;

  // has it been destroyed
  this.destroyed = false;

  // should we decode strings into buffers before passing to _write?
  // this is here so that some node-core streams can optimize string
  // handling at a lower level.
  var noDecode = options.decodeStrings === false;
  this.decodeStrings = !noDecode;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // not an actual buffer we keep track of, but a measurement
  // of how much we're waiting to get pushed to some underlying
  // socket or file.
  this.length = 0;

  // a flag to see when we're in the middle of a write.
  this.writing = false;

  // when true all writes will be buffered until .uncork() call
  this.corked = 0;

  // a flag to be able to tell if the onwrite cb is called immediately,
  // or on a later tick.  We set this to true at first, because any
  // actions that shouldn't happen until "later" should generally also
  // not happen before the first write call.
  this.sync = true;

  // a flag to know if we're processing previously buffered items, which
  // may call the _write() callback in the same tick, so that we don't
  // end up in an overlapped onwrite situation.
  this.bufferProcessing = false;

  // the callback that's passed to _write(chunk,cb)
  this.onwrite = function (er) {
    onwrite(stream, er);
  };

  // the callback that the user supplies to write(chunk,encoding,cb)
  this.writecb = null;

  // the amount that is being written when _write is called.
  this.writelen = 0;

  this.bufferedRequest = null;
  this.lastBufferedRequest = null;

  // number of pending user-supplied write callbacks
  // this must be 0 before 'finish' can be emitted
  this.pendingcb = 0;

  // emit prefinish if the only thing we're waiting for is _write cbs
  // This is relevant for synchronous Transform streams
  this.prefinished = false;

  // True if the error was already emitted and should not be thrown again
  this.errorEmitted = false;

  // count buffered requests
  this.bufferedRequestCount = 0;

  // allocate the first CorkedRequest, there is always
  // one allocated and free to use, and we maintain at most two
  this.corkedRequestsFree = new CorkedRequest(this);
}

WritableState.prototype.getBuffer = function getBuffer() {
  var current = this.bufferedRequest;
  var out = [];
  while (current) {
    out.push(current);
    current = current.next;
  }
  return out;
};

(function () {
  try {
    Object.defineProperty(WritableState.prototype, 'buffer', {
      get: internalUtil.deprecate(function () {
        return this.getBuffer();
      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
    });
  } catch (_) {}
})();

// Test _writableState for inheritance to account for Duplex streams,
// whose prototype chain only points to Readable.
var realHasInstance;
if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
  realHasInstance = Function.prototype[Symbol.hasInstance];
  Object.defineProperty(Writable, Symbol.hasInstance, {
    value: function (object) {
      if (realHasInstance.call(this, object)) return true;

      return object && object._writableState instanceof WritableState;
    }
  });
} else {
  realHasInstance = function (object) {
    return object instanceof this;
  };
}

function Writable(options) {
  Duplex = Duplex || __webpack_require__(80);

  // Writable ctor is applied to Duplexes, too.
  // `realHasInstance` is necessary because using plain `instanceof`
  // would return false, as no `_writableState` property is attached.

  // Trying to use the custom `instanceof` for Writable here will also break the
  // Node.js LazyTransform implementation, which has a non-trivial getter for
  // `_writableState` that would lead to infinite recursion.
  if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
    return new Writable(options);
  }

  this._writableState = new WritableState(options, this);

  // legacy.
  this.writable = true;

  if (options) {
    if (typeof options.write === 'function') this._write = options.write;

    if (typeof options.writev === 'function') this._writev = options.writev;

    if (typeof options.destroy === 'function') this._destroy = options.destroy;

    if (typeof options.final === 'function') this._final = options.final;
  }

  Stream.call(this);
}

// Otherwise people can pipe Writable streams, which is just wrong.
Writable.prototype.pipe = function () {
  this.emit('error', new Error('Cannot pipe, not readable'));
};

function writeAfterEnd(stream, cb) {
  var er = new Error('write after end');
  // TODO: defer error events consistently everywhere, not just the cb
  stream.emit('error', er);
  processNextTick(cb, er);
}

// Checks that a user-supplied chunk is valid, especially for the particular
// mode the stream is in. Currently this means that `null` is never accepted
// and undefined/non-string values are only allowed in object mode.
function validChunk(stream, state, chunk, cb) {
  var valid = true;
  var er = false;

  if (chunk === null) {
    er = new TypeError('May not write null values to stream');
  } else if (typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
    er = new TypeError('Invalid non-string/buffer chunk');
  }
  if (er) {
    stream.emit('error', er);
    processNextTick(cb, er);
    valid = false;
  }
  return valid;
}

Writable.prototype.write = function (chunk, encoding, cb) {
  var state = this._writableState;
  var ret = false;
  var isBuf = _isUint8Array(chunk) && !state.objectMode;

  if (isBuf && !Buffer.isBuffer(chunk)) {
    chunk = _uint8ArrayToBuffer(chunk);
  }

  if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

  if (typeof cb !== 'function') cb = nop;

  if (state.ended) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
    state.pendingcb++;
    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
  }

  return ret;
};

Writable.prototype.cork = function () {
  var state = this._writableState;

  state.corked++;
};

Writable.prototype.uncork = function () {
  var state = this._writableState;

  if (state.corked) {
    state.corked--;

    if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
  }
};

Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
  // node::ParseEncoding() requires lower case.
  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
  this._writableState.defaultEncoding = encoding;
  return this;
};

function decodeChunk(state, chunk, encoding) {
  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
    chunk = Buffer.from(chunk, encoding);
  }
  return chunk;
}

// if we're already writing something, then just put this
// in the queue, and wait our turn.  Otherwise, call _write
// If we return false, then we need a drain event, so set that flag.
function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
  if (!isBuf) {
    var newChunk = decodeChunk(state, chunk, encoding);
    if (chunk !== newChunk) {
      isBuf = true;
      encoding = 'buffer';
      chunk = newChunk;
    }
  }
  var len = state.objectMode ? 1 : chunk.length;

  state.length += len;

  var ret = state.length < state.highWaterMark;
  // we must ensure that previous needDrain will not be reset to false.
  if (!ret) state.needDrain = true;

  if (state.writing || state.corked) {
    var last = state.lastBufferedRequest;
    state.lastBufferedRequest = {
      chunk: chunk,
      encoding: encoding,
      isBuf: isBuf,
      callback: cb,
      next: null
    };
    if (last) {
      last.next = state.lastBufferedRequest;
    } else {
      state.bufferedRequest = state.lastBufferedRequest;
    }
    state.bufferedRequestCount += 1;
  } else {
    doWrite(stream, state, false, len, chunk, encoding, cb);
  }

  return ret;
}

function doWrite(stream, state, writev, len, chunk, encoding, cb) {
  state.writelen = len;
  state.writecb = cb;
  state.writing = true;
  state.sync = true;
  if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
  state.sync = false;
}

function onwriteError(stream, state, sync, er, cb) {
  --state.pendingcb;

  if (sync) {
    // defer the callback if we are being called synchronously
    // to avoid piling up things on the stack
    processNextTick(cb, er);
    // this can emit finish, and it will always happen
    // after error
    processNextTick(finishMaybe, stream, state);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
  } else {
    // the caller expect this to happen before if
    // it is async
    cb(er);
    stream._writableState.errorEmitted = true;
    stream.emit('error', er);
    // this can emit finish, but finish must
    // always follow error
    finishMaybe(stream, state);
  }
}

function onwriteStateUpdate(state) {
  state.writing = false;
  state.writecb = null;
  state.length -= state.writelen;
  state.writelen = 0;
}

function onwrite(stream, er) {
  var state = stream._writableState;
  var sync = state.sync;
  var cb = state.writecb;

  onwriteStateUpdate(state);

  if (er) onwriteError(stream, state, sync, er, cb);else {
    // Check if we're actually ready to finish, but don't emit yet
    var finished = needFinish(state);

    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
      clearBuffer(stream, state);
    }

    if (sync) {
      /*<replacement>*/
      asyncWrite(afterWrite, stream, state, finished, cb);
      /*</replacement>*/
    } else {
      afterWrite(stream, state, finished, cb);
    }
  }
}

function afterWrite(stream, state, finished, cb) {
  if (!finished) onwriteDrain(stream, state);
  state.pendingcb--;
  cb();
  finishMaybe(stream, state);
}

// Must force callback to be called on nextTick, so that we don't
// emit 'drain' before the write() consumer gets the 'false' return
// value, and has a chance to attach a 'drain' listener.
function onwriteDrain(stream, state) {
  if (state.length === 0 && state.needDrain) {
    state.needDrain = false;
    stream.emit('drain');
  }
}

// if there's something in the buffer waiting, then process it
function clearBuffer(stream, state) {
  state.bufferProcessing = true;
  var entry = state.bufferedRequest;

  if (stream._writev && entry && entry.next) {
    // Fast case, write everything using _writev()
    var l = state.bufferedRequestCount;
    var buffer = new Array(l);
    var holder = state.corkedRequestsFree;
    holder.entry = entry;

    var count = 0;
    var allBuffers = true;
    while (entry) {
      buffer[count] = entry;
      if (!entry.isBuf) allBuffers = false;
      entry = entry.next;
      count += 1;
    }
    buffer.allBuffers = allBuffers;

    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

    // doWrite is almost always async, defer these to save a bit of time
    // as the hot path ends with doWrite
    state.pendingcb++;
    state.lastBufferedRequest = null;
    if (holder.next) {
      state.corkedRequestsFree = holder.next;
      holder.next = null;
    } else {
      state.corkedRequestsFree = new CorkedRequest(state);
    }
  } else {
    // Slow case, write chunks one-by-one
    while (entry) {
      var chunk = entry.chunk;
      var encoding = entry.encoding;
      var cb = entry.callback;
      var len = state.objectMode ? 1 : chunk.length;

      doWrite(stream, state, false, len, chunk, encoding, cb);
      entry = entry.next;
      // if we didn't call the onwrite immediately, then
      // it means that we need to wait until it does.
      // also, that means that the chunk and cb are currently
      // being processed, so move the buffer counter past them.
      if (state.writing) {
        break;
      }
    }

    if (entry === null) state.lastBufferedRequest = null;
  }

  state.bufferedRequestCount = 0;
  state.bufferedRequest = entry;
  state.bufferProcessing = false;
}

Writable.prototype._write = function (chunk, encoding, cb) {
  cb(new Error('_write() is not implemented'));
};

Writable.prototype._writev = null;

Writable.prototype.end = function (chunk, encoding, cb) {
  var state = this._writableState;

  if (typeof chunk === 'function') {
    cb = chunk;
    chunk = null;
    encoding = null;
  } else if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }

  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

  // .end() fully uncorks
  if (state.corked) {
    state.corked = 1;
    this.uncork();
  }

  // ignore unnecessary end() calls.
  if (!state.ending && !state.finished) endWritable(this, state, cb);
};

function needFinish(state) {
  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
}
function callFinal(stream, state) {
  stream._final(function (err) {
    state.pendingcb--;
    if (err) {
      stream.emit('error', err);
    }
    state.prefinished = true;
    stream.emit('prefinish');
    finishMaybe(stream, state);
  });
}
function prefinish(stream, state) {
  if (!state.prefinished && !state.finalCalled) {
    if (typeof stream._final === 'function') {
      state.pendingcb++;
      state.finalCalled = true;
      processNextTick(callFinal, stream, state);
    } else {
      state.prefinished = true;
      stream.emit('prefinish');
    }
  }
}

function finishMaybe(stream, state) {
  var need = needFinish(state);
  if (need) {
    prefinish(stream, state);
    if (state.pendingcb === 0) {
      state.finished = true;
      stream.emit('finish');
    }
  }
  return need;
}

function endWritable(stream, state, cb) {
  state.ending = true;
  finishMaybe(stream, state);
  if (cb) {
    if (state.finished) processNextTick(cb);else stream.once('finish', cb);
  }
  state.ended = true;
  stream.writable = false;
}

function onCorkedFinish(corkReq, state, err) {
  var entry = corkReq.entry;
  corkReq.entry = null;
  while (entry) {
    var cb = entry.callback;
    state.pendingcb--;
    cb(err);
    entry = entry.next;
  }
  if (state.corkedRequestsFree) {
    state.corkedRequestsFree.next = corkReq;
  } else {
    state.corkedRequestsFree = corkReq;
  }
}

Object.defineProperty(Writable.prototype, 'destroyed', {
  get: function () {
    if (this._writableState === undefined) {
      return false;
    }
    return this._writableState.destroyed;
  },
  set: function (value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._writableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._writableState.destroyed = value;
  }
});

Writable.prototype.destroy = destroyImpl.destroy;
Writable.prototype._undestroy = destroyImpl.undestroy;
Writable.prototype._destroy = function (err, cb) {
  this.end();
  cb(err);
};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(57), __webpack_require__(377).setImmediate, __webpack_require__(79)))

/***/ }),
/* 198 */
/***/ (function(module, exports) {

module.exports = function(it){
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};

/***/ }),
/* 199 */
/***/ (function(module, exports, __webpack_require__) {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(275)(function(){
  return Object.defineProperty({}, 'a', {get: function(){ return 7; }}).a != 7;
});

/***/ }),
/* 200 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var external = __webpack_require__(81);
var DataWorker = __webpack_require__(280);
var DataLengthProbe = __webpack_require__(281);
var Crc32Probe = __webpack_require__(282);
var DataLengthProbe = __webpack_require__(281);

/**
 * Represent a compressed object, with everything needed to decompress it.
 * @constructor
 * @param {number} compressedSize the size of the data compressed.
 * @param {number} uncompressedSize the size of the data after decompression.
 * @param {number} crc32 the crc32 of the decompressed file.
 * @param {object} compression the type of compression, see lib/compressions.js.
 * @param {String|ArrayBuffer|Uint8Array|Buffer} data the compressed data.
 */
function CompressedObject(compressedSize, uncompressedSize, crc32, compression, data) {
    this.compressedSize = compressedSize;
    this.uncompressedSize = uncompressedSize;
    this.crc32 = crc32;
    this.compression = compression;
    this.compressedContent = data;
}

CompressedObject.prototype = {
    /**
     * Create a worker to get the uncompressed content.
     * @return {GenericWorker} the worker.
     */
    getContentWorker : function () {
        var worker = new DataWorker(external.Promise.resolve(this.compressedContent))
        .pipe(this.compression.uncompressWorker())
        .pipe(new DataLengthProbe("data_length"));

        var that = this;
        worker.on("end", function () {
            if(this.streamInfo['data_length'] !== that.uncompressedSize) {
                throw new Error("Bug : uncompressed data size mismatch");
            }
        });
        return worker;
    },
    /**
     * Create a worker to get the compressed content.
     * @return {GenericWorker} the worker.
     */
    getCompressedWorker : function () {
        return new DataWorker(external.Promise.resolve(this.compressedContent))
        .withStreamInfo("compressedSize", this.compressedSize)
        .withStreamInfo("uncompressedSize", this.uncompressedSize)
        .withStreamInfo("crc32", this.crc32)
        .withStreamInfo("compression", this.compression)
        ;
    }
};

/**
 * Chain the given worker with other workers to compress the content with the
 * given compresion.
 * @param {GenericWorker} uncompressedWorker the worker to pipe.
 * @param {Object} compression the compression object.
 * @param {Object} compressionOptions the options to use when compressing.
 * @return {GenericWorker} the new worker compressing the content.
 */
CompressedObject.createWorkerFrom = function (uncompressedWorker, compression, compressionOptions) {
    return uncompressedWorker
    .pipe(new Crc32Probe())
    .pipe(new DataLengthProbe("uncompressedSize"))
    .pipe(compression.compressWorker(compressionOptions))
    .pipe(new DataLengthProbe("compressedSize"))
    .withStreamInfo("compression", compression);
};

module.exports = CompressedObject;


/***/ }),
/* 201 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var utils = __webpack_require__(15);

/**
 * The following functions come from pako, from pako/lib/zlib/crc32.js
 * released under the MIT license, see pako https://github.com/nodeca/pako/
 */

// Use ordinary array, since untyped makes no boost here
function makeTable() {
    var c, table = [];

    for(var n =0; n < 256; n++){
        c = n;
        for(var k =0; k < 8; k++){
            c = ((c&1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));
        }
        table[n] = c;
    }

    return table;
}

// Create table on load. Just 255 signed longs. Not a problem.
var crcTable = makeTable();


function crc32(crc, buf, len, pos) {
    var t = crcTable, end = pos + len;

    crc = crc ^ (-1);

    for (var i = pos; i < end; i++ ) {
        crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xFF];
    }

    return (crc ^ (-1)); // >>> 0;
}

// That's all for the pako functions.

/**
 * Compute the crc32 of a string.
 * This is almost the same as the function crc32, but for strings. Using the
 * same function for the two use cases leads to horrible performances.
 * @param {Number} crc the starting value of the crc.
 * @param {String} str the string to use.
 * @param {Number} len the length of the string.
 * @param {Number} pos the starting position for the crc32 computation.
 * @return {Number} the computed crc32.
 */
function crc32str(crc, str, len, pos) {
    var t = crcTable, end = pos + len;

    crc = crc ^ (-1);

    for (var i = pos; i < end; i++ ) {
        crc = (crc >>> 8) ^ t[(crc ^ str.charCodeAt(i)) & 0xFF];
    }

    return (crc ^ (-1)); // >>> 0;
}

module.exports = function crc32wrapper(input, crc) {
    if (typeof input === "undefined" || !input.length) {
        return 0;
    }

    var isArray = utils.getTypeOf(input) !== "string";

    if(isArray) {
        return crc32(crc|0, input, input.length, 0);
    } else {
        return crc32str(crc|0, input, input.length, 0);
    }
};
// vim: set shiftwidth=4 softtabstop=4:


/***/ }),
/* 202 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// (C) 1995-2013 Jean-loup Gailly and Mark Adler
// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you must not
//   claim that you wrote the original software. If you use this software
//   in a product, an acknowledgment in the product documentation would be
//   appreciated but is not required.
// 2. Altered source versions must be plainly marked as such, and must not be
//   misrepresented as being the original software.
// 3. This notice may not be removed or altered from any source distribution.

module.exports = {
  2:      'need dictionary',     /* Z_NEED_DICT       2  */
  1:      'stream end',          /* Z_STREAM_END      1  */
  0:      '',                    /* Z_OK              0  */
  '-1':   'file error',          /* Z_ERRNO         (-1) */
  '-2':   'stream error',        /* Z_STREAM_ERROR  (-2) */
  '-3':   'data error',          /* Z_DATA_ERROR    (-3) */
  '-4':   'insufficient memory', /* Z_MEM_ERROR     (-4) */
  '-5':   'buffer error',        /* Z_BUF_ERROR     (-5) */
  '-6':   'incompatible version' /* Z_VERSION_ERROR (-6) */
};


/***/ }),
/* 203 */
/***/ (function(module, exports, __webpack_require__) {

var List = __webpack_require__(29).List;

function Cursor(mutable, iterable) {
    this.mutable = mutable || false;
    this.iterable = iterable;
    return this;
}

Object.defineProperty(Cursor.prototype, "count", {
    get: function() { return this.iterable.count(); }
});

Object.defineProperty(Cursor.prototype, "totalCount", {
    get: function() { return this.iterable.totalCount(); }
});

Cursor.prototype.iterate = function (fn, instance) {
    if(instance)
        fn = fn.bind(instance);
    var self = this;
    return {
        length: self.count,
        iterator: function() {
            var iterator = self.iterator();
            return {
                hasNext: function() { return iterator.hasNext(); },
                next: function() { return fn(iterator.next()); }
            };
        },
        toArray: function() {
            var array = [];
            var iterator = this.iterator();
            while(iterator.hasNext())
                array.push(iterator.next());
            return array;
        },
        getText: function() {
            return this.toArray().join(", ");
        }
    };
};

Cursor.prototype.toList = function() {
    var list = new List(false);
    var iterator = this.iterator();
    while(iterator.hasNext())
        list.push(iterator.next());
    return list;
};

Cursor.prototype.iterator = function() {
    var Iterator = function(cursor) {
        this.iterable = cursor.iterable;
        this.hasNext = function() { return this.iterable.hasNext(); };
        this.next = function() {
            var stored = this.iterable.next();
            if(!stored)
                return null;
            var name = stored.getData('category').slice(-1)[0];
            var type = eval(name);
            var result = new type(null, {}, cursor.mutable);
            result.fromStored(stored); // call loaders
            return result;
        };
        return this;
    };
    return new Iterator(this);
};

Cursor.prototype.filtered = function(fn) {
    var Iterator = function(cursor) {
        this.iterator = cursor.iterator();
        this.current = null;
        this.hasNext = function () {
            if (this.current)
                return true;
            while (this.iterator.hasNext()) {
                var current = this.iterator.next();
                if (fn(current)) {
                    this.current = current;
                    return true;
                }
            }
            return false;
        };
        this.next = function () {
            var current = this.current;
            this.current = null;
            return current;
        };
        return this;
    };
    var self = this;
    var cursor = new Cursor(this.mutable);
    cursor.iterator = function() { return new Iterator(self); };
    return cursor;
};

Cursor.prototype.toString = function () {
    var list = [];
    var iterator = this.iterator();
    while (iterator.hasNext())
        list.push(iterator.next().toString());
    return '[' + list.join(", ") + ']';
};

exports.Cursor = Cursor;


/***/ }),
/* 204 */
/***/ (function(module, exports, __webpack_require__) {

var Period = __webpack_require__(104).Period;

function DateTime(date, tzOffset) {
    this.date = date;
    // can't just use native Date since it's tzOffset is bound to the running location
    this.tzOffset = tzOffset;
    return this;
}

DateTime.now = function() {
    var now = new Date();
    return new DateTime(now, now.getTimezoneOffset());
};

DateTime.parse = function(text) {
    var year = parseInt(text.substring(0,4));
    text = text.substring(4);
    var month = 1;
    var day = 1;
    if(text[0]=='-') {
        text = text.substring(1); // skip "-"
        month = parseInt(text.substring(0,2));
        text = text.substring(2);
        if(text[0]=='-') {
            text = text.substring(1); // skip "-"
            day = parseInt(text.substring(0,2));
            text = text.substring(2);
        }
    }
    var hour = 0;
    var minute = 0;
    var second = 0;
    var milli = 0;
    if(text[0]=='T') {
        text = text.substring(1); // skip "T"
        hour = parseInt(text.substring(0,2));
        text = text.substring(2);
        if(text[0]==':') {
            text = text.substring(1); // skip ":"
            minute = parseInt(text.substring(0,2));
            text = text.substring(2);
            if(text[0]==':') {
                text = text.substring(1); // skip ":"
                second = parseInt(text.substring(0, 2));
                text = text.substring(2);
                if (text[0] == '.') {
                    text = text.substring(1); // skip "."
                    milli = parseInt(text.substring(0, 3));
                    text = text.substring(3);
                }
            }
        }
    }
    var date = new Date(Date.UTC(year, month-1, day, hour, minute, second, milli));
    var tzOffset = 0; // in seconds
    if(text[0]=='+' || text[0]=='-') {
        tzOffset = text[0]=='+' ? 1 : -1;
        text = text.substring(1); // skip "+/-"
        tzOffset *= parseInt(text.substring(0, 2)) * 3600;
        text.substring(2);
        if (text[0] == ':') {
            text = text.substring(1); // skip ":"
            tzOffset *= parseInt(text.substring(0, 2)) * 60;
        }
   }
    return new DateTime(date, tzOffset);
};

DateTime.prototype.addPeriod = function (period) {
    var date = new Date();
    var year = this.date.getUTCFullYear() + (period.years || 0);
    date.setUTCFullYear(year);
    var month = this.date.getUTCMonth() + (period.months || 0);
    date.setUTCMonth(month);
    var day = this.date.getUTCDate() + ((period.weeks || 0) * 7) + (period.days || 0);
    date.setUTCDate(day);
    var hour = this.date.getUTCHours() + (period.hours || 0);
    date.setUTCHours(hour);
    var minute = this.date.getUTCMinutes() + (period.minutes || 0);
    date.setUTCMinutes(minute);
    var second = this.date.getUTCSeconds() + (period.seconds || 0);
    date.setUTCSeconds(second);
    var millis = this.date.getUTCMilliseconds() + (period.millis || 0);
    date.setUTCMilliseconds(millis);
    return new DateTime(date, this.tzOffset);
};


DateTime.prototype.subtractDateTime = function(other) {
    var thisValue = this.date.valueOf() + this.tzOffset*1000;
    var otherValue = other.date.valueOf() + other.tzOffset*1000;
    var numDays = ( thisValue - otherValue)/(24*60*60*1000);
    var data = [];
    data[3] = Math.floor(numDays);
    data[4] = this.date.getUTCHours() - other.date.getUTCHours();
    data[5] = this.date.getUTCMinutes() - other.date.getUTCMinutes();
    data[6] = this.date.getUTCSeconds() - other.date.getUTCSeconds();
    data[7] = this.date.getUTCMilliseconds() - other.date.getUTCMilliseconds();
    return new Period(data);
};


DateTime.prototype.subtractPeriod = function(value) {
    var date = new Date();
    var year = this.date.getUTCFullYear() - (value.years || 0);
    date.setUTCFullYear(year);
    var month = this.date.getUTCMonth() - (value.months || 0);
    date.setUTCMonth(month);
    var day = this.date.getUTCDate() - ((value.weeks || 0) * 7) - (value.days || 0);
    date.setUTCDate(day);
    var hour = this.date.getUTCHours() - (value.hours || 0);
    date.setUTCHours(hour);
    var minute = this.date.getUTCMinutes() - (value.minutes || 0);
    date.setUTCMinutes(minute);
    var second = this.date.getUTCSeconds() - (value.seconds || 0);
    date.setUTCSeconds(second);
    var millis = this.date.getUTCMilliseconds() - (value.millis || 0);
    date.setUTCMilliseconds(millis);
    return new DateTime(date, this.tzOffset);
};



DateTime.prototype.toString = function() {
    var s = ("0000" + this.date.getUTCFullYear()).slice(-4);
    s += "-";
    s += ("00" + (this.date.getUTCMonth() + 1)).slice(-2);
    s += "-";
    s += ("00" + this.date.getUTCDate()).slice(-2);
    s += "T";
    s += ("00" + this.date.getUTCHours()).slice(-2);
    s += ":";
    s += ("00" + this.date.getUTCMinutes()).slice(-2);
    s += ":";
    s += ("00" + this.date.getUTCSeconds()).slice(-2);
    s += ".";
    s += ("000" + this.date.getUTCMilliseconds()).slice(-3);
    if(this.tzOffset == 0)
        return s + "Z";
    var offset = this.tzOffset;
    if (offset > 0)
        s += "+";
    else {
        offset = -offset;
        s += "-";
    }
    s += ("00" + Math.floor(offset / 3600)).slice(-2);
    s += ":";
    s += ("00" + Math.floor((offset % 3600) / 60)).slice(-2);
    return s;
};


DateTime.prototype.getText = DateTime.prototype.toString;


DateTime.prototype.equals = function(value) {
    return value instanceof DateTime && this.date.valueOf() == value.date.valueOf() && this.tzOffset == value.tzOffset;
};

DateTime.prototype.gt = function(other) {
    return other instanceof DateTime && this.compareTo(other.date, other.tzOffset) > 0;
};


DateTime.prototype.gte = function(other) {
    return other instanceof DateTime && this.compareTo(other.date, other.tzOffset) >= 0;
};


DateTime.prototype.lt = function(other) {
    return other instanceof DateTime && this.compareTo(other.date, other.tzOffset) < 0;
};


DateTime.prototype.lte = function(other) {
    return other instanceof DateTime && this.compareTo(other.date, other.tzOffset) <= 0;
};


DateTime.prototype.compareTo = function(date, tzOffset) {
    var a = this.date.valueOf() + this.tzOffset*60000;
    var b = date.valueOf() + tzOffset*60000;
    return a > b ? 1 : (a == b ? 0 : -1);
};


DateTime.prototype.getYear = function(value) {
    return this.date.getUTCFullYear();
};

DateTime.prototype.getMonth = function(value) {
    return this.date.getUTCMonth() + 1;
};


DateTime.prototype.getDayOfMonth = function(value) {
    return this.date.getUTCDate();
};


DateTime.prototype.getDayOfYear = function() {
    var first = new Date(this.date.getUTCFullYear(), 0, 1, 0, 0, 0, 0);
    var numDays = (this - first) / (1000 * 60 * 60 * 24);
    return 1 + Math.floor(numDays);
};

DateTime.prototype.getHour = function(value) {
    return this.date.getUTCHours();
};


DateTime.prototype.getMinute = function(value) {
    return this.date.getUTCMinutes();
};


DateTime.prototype.getSecond = function(value) {
    return this.date.getUTCSeconds();
};


DateTime.prototype.getMillisecond = function(value) {
    return this.date.getUTCMilliseconds();
};

DateTime.prototype.getTzOffset = function(value) {
    return this.date.tzOffset;
};

DateTime.prototype.getTzName = function(value) {
    return "Z";
};


exports.DateTime = DateTime;

/***/ }),
/* 205 */
/***/ (function(module, exports, __webpack_require__) {

var ConcreteCategoryDeclaration = __webpack_require__(52).ConcreteCategoryDeclaration;
var CategoryType = __webpack_require__(7).CategoryType;

function SingletonCategoryDeclaration(id, attributes, methods) {
    ConcreteCategoryDeclaration.call(this, id, attributes, null, methods);
    return this;
}

SingletonCategoryDeclaration.prototype = Object.create(ConcreteCategoryDeclaration.prototype);
SingletonCategoryDeclaration.prototype.constructor = SingletonCategoryDeclaration;

SingletonCategoryDeclaration.prototype.categoryTypeToEDialect = function(writer) {
    writer.append("singleton");
};

SingletonCategoryDeclaration.prototype.categoryTypeToODialect = function(writer) {
    writer.append("singleton");
};

SingletonCategoryDeclaration.prototype.categoryTypeToMDialect = function(writer) {
    writer.append("singleton");
};


SingletonCategoryDeclaration.prototype.transpile = function(transpiler) {
    transpiler.append("function ").append(this.name).append("() {").indent();
    transpiler.append("$Root.call(this);").newLine();
    transpiler.append("this.mutable = true;").newLine();
    transpiler.append("return this;").dedent();
    transpiler.append("};").newLine();
    transpiler.append(this.name).append(".prototype = Object.create($Root.prototype);").newLine();
    transpiler.append(this.name).append(".prototype.constructor = ").append(this.name).append(";").newLine();
    transpiler.append(this.name).append(".instance = new ").append(this.name).append("();").newLine();
    if(this.attributes) {
        this.attributes.forEach(function (attr) {
            transpiler.append(this.name).append(".instance.").append(attr.name).append(" = null;").newLine();
        }, this);
    }
    var type = new CategoryType(this.id);
    this.methods.forEach(function(method) {
        var m = transpiler.newMemberTranspiler(type);
        method.transpile(m);
        m.flush();
    }, this);
    transpiler.flush();
};

exports.SingletonCategoryDeclaration = SingletonCategoryDeclaration;

/***/ }),
/* 206 */
/***/ (function(module, exports, __webpack_require__) {

var NativeCategoryDeclaration = __webpack_require__(122).NativeCategoryDeclaration;

function NativeWidgetDeclaration(name, categoryBindings, methods) {
    NativeCategoryDeclaration.call(this, name, null, categoryBindings, null, methods);
    return this;
}


NativeWidgetDeclaration.prototype = Object.create(NativeCategoryDeclaration.prototype);
NativeWidgetDeclaration.prototype.constructor = NativeCategoryDeclaration;

NativeWidgetDeclaration.prototype.isWidget = function(context) {
    return true;
};

NativeWidgetDeclaration.prototype.getDeclarationType = function() {
    return "Widget";
};


NativeWidgetDeclaration.prototype.getBoundFunction = function(fail) {
    if(this.bound==null) {
        var binding = this.getBinding(fail);
        if(binding!=null) {
            this.bound = binding.resolveWidget();
            if(fail && this.bound==null)
                throw new SyntaxError("No JavaScript function:" + binding.toString());
        }
    }
    return this.bound;
};

NativeWidgetDeclaration.prototype.categoryTypeToEDialect = function(writer) {
    writer.append("native widget");
};

NativeWidgetDeclaration.prototype.categoryTypeToODialect = function(writer) {
    writer.append("native widget");
};

NativeWidgetDeclaration.prototype.categoryTypeToMDialect = function(writer) {
    writer.append("native widget");
};

NativeWidgetDeclaration.prototype.transpile = function(transpiler) {
    var binding = this.getBinding();
    binding.transpileWidget(transpiler);
    return true;
};


exports.NativeWidgetDeclaration = NativeWidgetDeclaration;


/***/ }),
/* 207 */
/***/ (function(module, exports, __webpack_require__) {

var ConcreteMethodDeclaration = __webpack_require__(78).ConcreteMethodDeclaration;

function GetterMethodDeclaration(id, statements) {
    ConcreteMethodDeclaration.call(this, id, null, null, statements);
	return this;
}

GetterMethodDeclaration.prototype = Object.create(ConcreteMethodDeclaration.prototype);
GetterMethodDeclaration.prototype.contructor = GetterMethodDeclaration;

GetterMethodDeclaration.prototype.toODialect = function(writer) {
    writer.append("getter ");
    writer.append(this.name);
    writer.append(" {\n");
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
    writer.append("}\n");
};

GetterMethodDeclaration.prototype.toEDialect = function(writer) {
    writer.append("define ");
    writer.append(this.name);
    writer.append(" as getter doing:\n");
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
};

GetterMethodDeclaration.prototype.toMDialect = function(writer) {
    writer.append("def ");
    writer.append(this.name);
    writer.append(" getter():\n");
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
};

GetterMethodDeclaration.prototype.transpile = function(transpiler) {
    this.statements.transpile(transpiler);
};

exports.GetterMethodDeclaration = GetterMethodDeclaration;


/***/ }),
/* 208 */
/***/ (function(module, exports, __webpack_require__) {

var ConcreteMethodDeclaration = __webpack_require__(78).ConcreteMethodDeclaration;
var AttributeArgument = __webpack_require__(72).AttributeArgument;

function SetterMethodDeclaration(id, statements) {
    ConcreteMethodDeclaration.call(this, id, null, null, statements);
	return this;
}

SetterMethodDeclaration.prototype = Object.create(ConcreteMethodDeclaration.prototype);
SetterMethodDeclaration.prototype.contructor = SetterMethodDeclaration;

SetterMethodDeclaration.prototype.toODialect = function(writer) {
    writer.append("setter ");
    writer.append(this.name);
    writer.append(" {\n");
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
    writer.append("}\n");
};

SetterMethodDeclaration.prototype.toEDialect = function(writer) {
    writer.append("define ");
    writer.append(this.name);
    writer.append(" as setter doing:\n");
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
};

SetterMethodDeclaration.prototype.toMDialect = function(writer) {
    writer.append("def ");
    writer.append(this.name);
    writer.append(" setter():\n");
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
};

SetterMethodDeclaration.prototype.transpile = function(transpiler) {
    var arg = new AttributeArgument(this.id);
    arg.register(transpiler.context);
    this.statements.transpile(transpiler);
};

exports.SetterMethodDeclaration = SetterMethodDeclaration;


/***/ }),
/* 209 */
/***/ (function(module, exports, __webpack_require__) {

var BaseMethodDeclaration = __webpack_require__(75).BaseMethodDeclaration;
var StrictSet = __webpack_require__(34).StrictSet;
var ContextualExpression = __webpack_require__(188).ContextualExpression;
var ArgumentAssignmentList = __webpack_require__(39).ArgumentAssignmentList;
var ArgumentAssignment = __webpack_require__(40).ArgumentAssignment;
var UnresolvedIdentifier = null;
var UnresolvedArgument = null;
var CategoryArgument = null;
var AttributeArgument = null;
var Variable = __webpack_require__(10).Variable;
var AnyType = __webpack_require__(14).AnyType;

exports.resolve = function() {
    UnresolvedIdentifier = __webpack_require__(27).UnresolvedIdentifier;
    UnresolvedArgument = __webpack_require__(144).UnresolvedArgument;
    CategoryArgument = __webpack_require__(95).CategoryArgument;
    AttributeArgument = __webpack_require__(72).AttributeArgument;
};


function DispatchMethodDeclaration(context, call,  declaration, declarations) {
    BaseMethodDeclaration.call(this, declaration.id, declaration.args, declaration.returnType);
    this.context = context;
    this.call = call;
    this.declaration = declaration;
    this.declarations = declarations;
    return this;
}

DispatchMethodDeclaration.prototype = Object.create(BaseMethodDeclaration.prototype);
DispatchMethodDeclaration.prototype.constructor = DispatchMethodDeclaration;


DispatchMethodDeclaration.prototype.getTranspiledName = function(context) {
    return "$dispatch$" + this.declaration.getTranspiledName(context);
};

DispatchMethodDeclaration.prototype.replaceLocalsWithArguments = function(assignments) {
    var items = assignments.map(function(assignment) {
        var arg = assignment.argument;
        var exp = assignment.expression;
        if(exp instanceof ContextualExpression)
            exp = exp.expression;
        if(exp && exp.name) {
            exp = new UnresolvedIdentifier(arg.id);
            return new ArgumentAssignment(arg, exp);
        } else
            return assignment;
    });
    return new ArgumentAssignmentList(items);
};

DispatchMethodDeclaration.prototype.transpile = function(transpiler) {
    this.registerArguments(transpiler.context);
    this.transpileProlog(transpiler);
    this.transpileDispatch(transpiler);
    this.transpileEpilog(transpiler);
};

DispatchMethodDeclaration.prototype.transpileDispatch = function(transpiler) {
    var common = this.collectCommonArgs();
    for(var i=0; i<this.declarations.length; i++) {
        if(i>0)
            transpiler.append("else ");
        if(i<this.declarations.length-1) {
            transpiler.append("if(");
            this.transpileTest(transpiler, common, this.declarations[i]);
            transpiler.append(")");
        }
        transpiler.indent();
        this.transpileCall(transpiler, this.declarations[i]);
        transpiler.dedent();
    }
};

DispatchMethodDeclaration.prototype.collectCommonArgs = function() {
    var common = null;
    for(var i=0; i<this.declarations.length; i++) {
        var declaration = this.declarations[i];
        if(i==0)
            common = new StrictSet(declaration.args);
        else {
            var current = new StrictSet(declaration.args);
            common = common.intersect(current);
            if(common.length===0)
                break;
        }
    }
    return common;
};

DispatchMethodDeclaration.prototype.transpileCall = function(transpiler, declaration) {
    this.call.transpileSelector(transpiler, declaration);
    transpiler.append("(");
    this.args.forEach(function (arg) {
        transpiler.append(arg.name);
        transpiler.append(", ");
    }, this);
    transpiler.trimLast(2);
    transpiler.append(")");
};

DispatchMethodDeclaration.prototype.transpileTest = function(transpiler, common, declaration) {
    for(var i = 0, count = 0;i<this.call.assignments.length; i++) {
        var incoming = this.call.assignments[i].argument;
        if(common.has(incoming))
            continue;
        if(count++)
            transpiler.append(" && ");
        if(incoming instanceof UnresolvedArgument)
            incoming = incoming.resolved;
        var outgoing = incoming==null ? declaration.args[0] : this.findCorrespondingArg(transpiler.context, declaration.args, common, incoming);
        if(outgoing instanceof UnresolvedArgument)
            outgoing = outgoing.resolved;
        if(incoming==null)
            incoming = this.declaration.args[0];
        if(incoming instanceof UnresolvedArgument)
            incoming = incoming.resolved;
        if(incoming instanceof CategoryArgument && outgoing instanceof CategoryArgument) {
            transpiler.append(incoming.name).append(".instanceOf(").append(outgoing.type.name).append(")");
        } else if(incoming instanceof CategoryArgument && outgoing instanceof AttributeArgument) {
            transpiler.append(incoming.name).append(".hasOwnProperty('").append(outgoing.name).append("')");
        } else
            throw new Error("Unsupported: " + typeof(incoming) + " and " + typeof(outgoing));
    }
};

DispatchMethodDeclaration.prototype.findCorrespondingArg = function(context, arguments, common, incoming) {
    for(var i=0;i<arguments.length;i++) {
        var outgoing = arguments[i];
        if (common.has(outgoing))
            continue;
        if (outgoing.equals(incoming))
            return outgoing;
        if (incoming instanceof CategoryArgument && outgoing instanceof CategoryArgument) {
            if(incoming.type.isAssignableFrom(context, outgoing.type) || outgoing.type.isAssignableFrom(context, incoming.type))
                return outgoing;
        }
    }
    throw new Error("Could not find matching argument for: " + incoming + " in " + arguments);
};


exports.DispatchMethodDeclaration = DispatchMethodDeclaration;

/***/ }),
/* 210 */
/***/ (function(module, exports, __webpack_require__) {

var BinaryType = __webpack_require__(307).BinaryType;
var Identifier = __webpack_require__(0).Identifier;

function BlobType() {
    BinaryType.call(this, new Identifier("Blob"));
    return this;
}

BlobType.prototype = Object.create(BinaryType.prototype);
BlobType.prototype.constructor = BlobType;

BlobType.instance = new BlobType();

exports.BlobType = BlobType;

/***/ }),
/* 211 */
/***/ (function(module, exports, __webpack_require__) {

var BinaryValue = __webpack_require__(308).BinaryValue;
var BlobType = __webpack_require__(210).BlobType;

function BlobValue(mimeType, data) {
    BinaryValue.call(this, BlobType.instance, mimeType, data);
    return this;
}

BlobValue.prototype = Object.create(BinaryValue.prototype);
BlobValue.prototype.constructor = BlobValue;

exports.BlobValue = BlobValue;

/***/ }),
/* 212 */
/***/ (function(module, exports, __webpack_require__) {

var ExecutionError = __webpack_require__(48).ExecutionError;

function ReadWriteError(message) {
    ExecutionError.call(this, message);
    return this;
}

ReadWriteError.prototype = Object.create(ExecutionError.prototype);
ReadWriteError.prototype.constructor = ReadWriteError;

ReadWriteError.prototype.getExpression = function(context) {
    return context.getRegisteredValue("READ_WRITE");
};

exports.ReadWriteError = ReadWriteError;


/***/ }),
/* 213 */
/***/ (function(module, exports, __webpack_require__) {

var SyntaxError = __webpack_require__(32).SyntaxError;
var SelectorExpression = __webpack_require__(94).SelectorExpression;
var MemberSelector = null;
var MethodSelector = null;
var MethodCall = null;
var UnresolvedCall = null;
var UnresolvedIdentifier = null;
var AnyType = __webpack_require__(14).AnyType;
var ProblemListener = __webpack_require__(73).ProblemListener;

exports.resolve = function() {
    MemberSelector = __webpack_require__(63).MemberSelector;
    MethodSelector = __webpack_require__(53).MethodSelector;
    MethodCall = __webpack_require__(62).MethodCall;
    UnresolvedCall = __webpack_require__(163).UnresolvedCall;
    UnresolvedIdentifier = __webpack_require__(27).UnresolvedIdentifier;
}


function UnresolvedSelector(parent, id) {
    SelectorExpression.call(this, parent);
    this.id = id;
    this.resolved = null;
    return this;
}

UnresolvedSelector.prototype = Object.create(SelectorExpression.prototype);
UnresolvedSelector.prototype.constructor = UnresolvedSelector;

Object.defineProperty(UnresolvedSelector.prototype, "name", {
    get : function() {
        return this.id.name;
    }
});

UnresolvedSelector.prototype.toString = function() {
    return this.parent ? this.parent.toString() + '.' + this.name : this.name;
};


UnresolvedSelector.prototype.toDialect = function(writer) {
    try {
        this.resolve(writer.context, false);
    } catch (e) {
        // pass
    }
    if (this.resolved)
        this.resolved.toDialect(writer);
    else {
        if (this.parent)
            this.parent.toDialect(writer);
        writer.append('.');
        writer.append(this.name);
    }
};


UnresolvedSelector.prototype.check = function(context) {
    return this.resolveAndCheck(context, false);
};



UnresolvedSelector.prototype.checkMember = function(context) {
    return this.resolveAndCheck(context, false);
};


UnresolvedSelector.prototype.interpret = function(context) {
    this.resolveAndCheck(context, false);
    return this.resolved.interpret(context);
};


UnresolvedSelector.prototype.resolveAndCheck = function(context, forMember) {
    this.resolve(context, forMember);
    return this.resolved ? this.resolved.check(context) : AnyType.instance;
};


UnresolvedSelector.prototype.resolve = function(context, forMember) {
    if (!this.resolved)
        this.resolved = this.tryResolveMethod(context, null);
    if (!this.resolved)
        this.resolved = this.tryResolveMember(context);
    if (!this.resolved)
        throw new SyntaxError("Unknown identifier:" + this.name);
    return this.resolved;
};


UnresolvedSelector.prototype.resolveMethod = function(context, assignments) {
    if (!this.resolved)
        this.resolved = this.tryResolveMethod(context, assignments);
};


UnresolvedSelector.prototype.tryResolveMember = function(context) {
    var listener = context.problemListener;
    context.problemListener = new ProblemListener();
    try {
        var member = new MemberSelector(this.parent, this.id);
        member.check(context);
        return member;
    } catch (e) {
        if(e instanceof SyntaxError)
            return null;
        else
            throw e;
    } finally {
        context.problemListener = listener;
    }
};


UnresolvedSelector.prototype.tryResolveMethod = function(context, assignments) {
    var listener = context.problemListener;
    context.problemListener = new ProblemListener();
    try {
        var resolvedParent = this.parent;
        if (resolvedParent instanceof UnresolvedIdentifier) {
            resolvedParent.checkMember(context);
            resolvedParent = resolvedParent.resolved;
        }
        var method = new UnresolvedCall(new MethodSelector(resolvedParent, this.id), assignments);
        method.check(context);
        return method;
    } catch (e) {
        if(e instanceof SyntaxError)
            return null;
        else
            throw e;
    } finally {
        context.problemListener = listener;
    }
};


UnresolvedSelector.prototype.declare = function(transpiler) {
    if(this.resolved==null)
        this.resolve(transpiler.context, false);
    this.resolved.declare(transpiler);
};


UnresolvedSelector.prototype.transpile = function(transpiler) {
    if(this.resolved==null)
        this.resolve(transpiler.context, false);
    this.resolved.transpile(transpiler);
};


exports.UnresolvedSelector = UnresolvedSelector;



/***/ }),
/* 214 */
/***/ (function(module, exports, __webpack_require__) {

var ExecutionError = __webpack_require__(48).ExecutionError;
var TextLiteral = __webpack_require__(74).TextLiteral;

function InvalidResourceError(message) {
	ExecutionError.call(this, message);
	return this;
}

InvalidResourceError.prototype = Object.create(ExecutionError.prototype);
InvalidResourceError.prototype.constructor = InvalidResourceError;

InvalidResourceError.prototype.getExpression = function(context) {
	return new TextLiteral(this.message);
};

exports.InvalidResourceError = InvalidResourceError;


/***/ }),
/* 215 */
/***/ (function(module, exports, __webpack_require__) {

var InstanceContext = __webpack_require__(11).InstanceContext;
var DocumentContext = __webpack_require__(11).DocumentContext;
var DocumentType = __webpack_require__(55).DocumentType;

function ThisExpression() {
    return this;
}

ThisExpression.prototype.check = function(context) {
    if (context instanceof DocumentContext)
        return DocumentType.instance;
    if (context != null && !(context instanceof InstanceContext))
        context = context.getClosestInstanceContext ();
    if (context instanceof InstanceContext)
        return context.instanceType;
    else
        throw new SyntaxError ("Not in an instance context!");
};


ThisExpression.prototype.interpret = function(context) {
    if (context instanceof DocumentContext)
        return context.document;
    if (context != null && !(context instanceof InstanceContext))
        context = context.getClosestInstanceContext ();
    if (context instanceof InstanceContext)
        return context.instance;
    else
        throw new SyntaxError ("Not in an instance context!");
};

ThisExpression.prototype.toDialect = function(writer) {
    writer.toDialect(this);
};

ThisExpression.prototype.toEDialect = function(writer) {
    writer.append("self");
};

ThisExpression.prototype.toODialect = function(writer) {
    writer.append("this");
};

ThisExpression.prototype.toMDialect = function(writer) {
    writer.append("self");
};

ThisExpression.prototype.toString = function() {
    return "this";
};

ThisExpression.prototype.declare = function(transpiler) {
    // nothing to do
};

ThisExpression.prototype.transpile = function(transpiler) {
    transpiler.append("this");
};

exports.ThisExpression = ThisExpression;


/***/ }),
/* 216 */
/***/ (function(module, exports, __webpack_require__) {

exports.JavaScriptStatement = __webpack_require__(463).JavaScriptStatement;
exports.JavaScriptNativeCall = __webpack_require__(263).JavaScriptNativeCall;
exports.JavaScriptItemExpression = __webpack_require__(467).JavaScriptItemExpression;
exports.JavaScriptIdentifierExpression = __webpack_require__(468).JavaScriptIdentifierExpression;
exports.JavaScriptBooleanLiteral = __webpack_require__(469).JavaScriptBooleanLiteral;
exports.JavaScriptCharacterLiteral = __webpack_require__(470).JavaScriptCharacterLiteral;
exports.JavaScriptTextLiteral = __webpack_require__(471).JavaScriptTextLiteral;
exports.JavaScriptIntegerLiteral = __webpack_require__(472).JavaScriptIntegerLiteral;
exports.JavaScriptDecimalLiteral = __webpack_require__(473).JavaScriptDecimalLiteral;
exports.JavaScriptExpressionList = __webpack_require__(315).JavaScriptExpressionList;
exports.JavaScriptMethodExpression = __webpack_require__(474).JavaScriptMethodExpression;
exports.JavaScriptMemberExpression = __webpack_require__(475).JavaScriptMemberExpression;
exports.JavaScriptNewExpression = __webpack_require__(476).JavaScriptNewExpression;
exports.JavaScriptThisExpression = __webpack_require__(477).JavaScriptThisExpression;
exports.JavaScriptNativeCategoryBinding = __webpack_require__(297).JavaScriptNativeCategoryBinding;
exports.JavaScriptModule = __webpack_require__(478).JavaScriptModule;


/***/ }),
/* 217 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var BooleanType = __webpack_require__(5).BooleanType;
var Identifier = __webpack_require__(0).Identifier;
var Version = __webpack_require__(155).Version;
var VersionValue = __webpack_require__(165).VersionValue;

function VersionType()  {
	NativeType.call(this, new Identifier("Version"));
	return this;
}

VersionType.prototype = Object.create(NativeType.prototype);
VersionType.prototype.constructor = VersionType;

VersionType.instance = new VersionType();

VersionType.prototype.convertJavaScriptValueToPromptoValue = function(context, value, returnType) {
    if(value instanceof Version)
        return new VersionValue(value);
    else
        return NativeType.prototype.convertJavaScriptValueToPromptoValue.call(this, context, value, returnType);
};

VersionType.prototype.checkCompare = function(context, other) {
	if (other instanceof VersionType) {
		return BooleanType.instance;
	} else {
		return NativeType.prototype.checkCompare.call(this, context, other);
	}
};


VersionType.prototype.declare = function(transpiler) {
    transpiler.register(Version);
};


VersionType.prototype.transpile = function(transpiler) {
    transpiler.append('Version')
};

VersionType.prototype.declareCompare = function(context, other) {
    // nothing to do
};

VersionType.prototype.transpileCompare = function(transpiler, other, operator, left, right) {
    left.transpile(transpiler);
    transpiler.append(".");
    operator.transpile(transpiler);
    transpiler.append("(");
    right.transpile(transpiler);
    transpiler.append(")");
};

exports.VersionType = VersionType;


/***/ }),
/* 218 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var UUIDType = __webpack_require__(166).UUIDType;
var UUID = __webpack_require__(154).UUID;
var InvalidDataError = __webpack_require__(64).InvalidDataError;

function UUIDValue(value) {
    if(typeof(value) == 'string') {
        value = UUID.fromString(value);
    }
    if(!(value instanceof UUID))
        throw new InvalidDataError("Not a UUID: " + typeof(value));
    Value.call(this, UUIDType.instance);
	this.value = value;
	return this;
}

UUIDValue.prototype = Object.create(Value.prototype);
UUIDValue.prototype.constructor = UUIDValue;

UUIDValue.prototype.toString = function() {
    return this.value.toString();
};


UUIDValue.prototype.getStorableData = function() {
    return this.value.toString();
};


UUIDValue.prototype.equals = function(obj) {
    if (obj instanceof UUIDValue) {
        return this.value.equals(obj.value);
    } else {
        return false;
    }
};

exports.UUIDValue = UUIDValue;




/***/ }),
/* 219 */
/***/ (function(module, exports, __webpack_require__) {

var NativeType = __webpack_require__(12).NativeType;
var Identifier = __webpack_require__(0).Identifier;

function CssType () {
    NativeType.call(this, new Identifier("Css"));
    return this;
}

CssType.prototype = Object.create(NativeType.prototype);
CssType.prototype.constructor = CssType;


CssType.instance = new CssType();

exports.CssType = CssType;

/***/ }),
/* 220 */
/***/ (function(module, exports, __webpack_require__) {

var JavaScriptExpression = __webpack_require__(129).JavaScriptExpression;

function JavaScriptSelectorExpression(parent) {
	JavaScriptExpression.call(this);
	this.parent = parent || null;
	return this;
}
JavaScriptSelectorExpression.prototype = Object.create(JavaScriptExpression.prototype);
JavaScriptSelectorExpression.prototype.constructor = JavaScriptSelectorExpression;

exports.JavaScriptSelectorExpression = JavaScriptSelectorExpression;


/***/ }),
/* 221 */
/***/ (function(module, exports, __webpack_require__) {

var BaseStatement = __webpack_require__(35).BaseStatement;
var ObjectList = __webpack_require__(22).ObjectList;
var BooleanType = __webpack_require__(5).BooleanType;
var EqualsExpression = __webpack_require__(298).EqualsExpression;
var BooleanValue = __webpack_require__(20).BooleanValue;

function IfStatement(condition, statements, elseIfs, elseStmts) {
	BaseStatement.call(this);
	this.elements = new IfElementList();
	this.elements.add(new IfElement(condition, statements));
	elseIfs = elseIfs || null;
	if(elseIfs!=null) {
		this.elements.addAll(elseIfs);
	}
	elseStmts = elseStmts || null;
	if(elseStmts!=null) {
		this.elements.add(new IfElement(null, elseStmts));
	}
	return this;
}

IfStatement.prototype = Object.create(BaseStatement.prototype);
IfStatement.prototype.constructor = IfStatement;


IfStatement.prototype.addAdditional = function(condition, statements) {
	this.elements.add(new IfElement(condition, statements));
};

IfStatement.prototype.setFinal = function(statements) {
	this.elements.add(new IfElement(null, statements));
};

IfStatement.prototype.check = function(context) {
	return this.elements[0].check(context);
	// TODO check consistency with additional elements
}

IfStatement.prototype.interpret = function(context) {
	for(var i=0;i<this.elements.length;i++) {
		var element = this.elements[i];
		var condition = element.condition || null;
		var test = condition==null ? BooleanValue.TRUE : condition.interpret(context);
		if(test instanceof BooleanValue && BooleanValue.TRUE.equals(test)) {
			return element.interpret(context);
		}
	}
	return null;
};


IfStatement.prototype.declare = function(transpiler) {
    this.elements.forEach(function(element) {
        element.declare(transpiler);
    });
};



IfStatement.prototype.transpile = function(transpiler) {
    for(var i=0;i<this.elements.length;i++) {
        var element = this.elements[i];
        if (i > 0)
            transpiler.append(" else ");
        if (element.condition) {
            transpiler.append("if (");
            element.condition.transpile(transpiler);
            transpiler.append(") ");
        }
        transpiler.append("{");
        transpiler.indent();
        element.transpile(transpiler);
        transpiler.dedent();
        transpiler.append("}");
    }
    transpiler.newLine();
    return true;
};



IfStatement.prototype.toDialect = function(writer) {
    writer.toDialect(this);
}


IfStatement.prototype.toMDialect = function(writer) {
    this.toEDialect(writer);
};


IfStatement.prototype.toODialect = function(writer) {
    var curly = false;
    for(var i=0;i<this.elements.length; i++) {
        if(i>0) {
            if (curly)
                writer.append(" ");
            writer.append("else ");
        }
        this.elements[i].toODialect(writer);
        curly = this.elements[i].statements.length>1;
    }
    if(curly)
        writer.newLine();
};


IfStatement.prototype.toEDialect = function(writer) {
    for(var i=0;i<this.elements.length; i++) {
        if(i>0)
            writer.append("else ");
        this.elements[i].toEDialect(writer);
    }
};


IfStatement.prototype.canReturn = function() {
    return true;
};

exports.IfStatement = IfStatement;

function IfElementList(item) {
	ObjectList.call(this);
	item = item || null;
	if (item != null) {
		this.add(item);
	}
	return this;
}

IfElementList.prototype = Object.create(ObjectList.prototype);
IfElementList.prototype.constructor = IfElementList;

exports.IfElementList = IfElementList;

function IfElement(condition, statements) {
	BaseStatement.call(this);
	this.condition = condition;
	this.statements = statements;
	return this;
}

IfElement.prototype = Object.create(BaseStatement.prototype);
IfElement.prototype.constructor = IfElement;


IfElement.prototype.check = function(context) {
	var type = this.condition.check(context);
	if(type!=BooleanType.instance) {
		throw new SyntaxError("Expected a boolean condition!");
	}
    context = this.downCast(context, false);
	return this.statements.check(context, null);
};


IfElement.prototype.declare = function(transpiler) {
    if(this.condition)
        this.condition.declare(transpiler);
    var context = transpiler.context;
    if(this.condition instanceof EqualsExpression)
        context = this.condition.downCast(transpiler.context, false);
    if(context!=transpiler.context)
        transpiler = transpiler.newChildTranspiler(context);
    else
        transpiler = transpiler.newChildTranspiler();
    this.statements.declare(transpiler);
};


IfElement.prototype.transpile = function(transpiler) {
    var context = transpiler.context;
    if(this.condition instanceof EqualsExpression)
        context = this.condition.downCast(context, false);
    if(context!=transpiler.context)
        transpiler = transpiler.newChildTranspiler(context);
    else
        transpiler = transpiler.newChildTranspiler();
    this.statements.transpile(transpiler);
    transpiler.flush();
};



IfElement.prototype.downCast = function(context, setValue) {
    var parent = context;
    if(this.condition instanceof EqualsExpression)
        context = this.condition.downCast(context, setValue);
    context = parent!=context ? context : context.newChildContext();
    return context;
};

IfElement.prototype.interpret = function(context) {
    context = this.downCast(context, true);
    return this.statements.interpret(context);
};

IfElement.prototype.toMDialect = function(writer) {
    this.toEDialect(writer);
}

IfElement.prototype.toEDialect = function(writer) {
    if(this.condition!=null) {
        writer.append("if ");
        this.condition.toDialect(writer);
    }
    writer.append(":\n");
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
};

IfElement.prototype.toODialect = function(writer) {
    if(this.condition!=null)
    {
        writer.append("if (");
        this.condition.toDialect(writer);
        writer.append(") ");
    }
    var curly = this.statements!=null && this.statements.length>1;
    if(curly)
        writer.append("{\n");
    else
        writer.newLine();
    writer.indent();
    this.statements.toDialect(writer);
    writer.dedent();
    if(curly)
        writer.append("}");
};

exports.IfElement = IfElement;


/***/ }),
/* 222 */
/***/ (function(module, exports, __webpack_require__) {

var Section = __webpack_require__(19).Section;

function SwitchCase(expression, statements) {
	Section.call(this);
	this.expression = expression;
	this.statements = statements;
	return this;
}


SwitchCase.prototype  = Object.create(Section.prototype);
SwitchCase.prototype.constructor = SwitchCase;

SwitchCase.prototype.checkReturnType = function(context) {
	return this.statements.check(context, null);
};

SwitchCase.prototype.interpret = function(context) {
	return this.statements.interpret(context);
};

SwitchCase.prototype.declare = function(transpiler) {
    if(this.expression)
        this.expression.declare(transpiler);
    this.statements.declare(transpiler);
};


exports.SwitchCase = SwitchCase;

/***/ }),
/* 223 */
/***/ (function(module, exports, __webpack_require__) {

var BaseStatement = __webpack_require__(35).BaseStatement;
var ObjectList = __webpack_require__(22).ObjectList;
var TypeMap = __webpack_require__(262).TypeMap;
var VoidType = __webpack_require__(4).VoidType;

function BaseSwitchStatement(switchCases, defaultCase) {
	BaseStatement.call(this);
	this.switchCases = switchCases || new SwitchCaseList();
	this.defaultCase = defaultCase || null;
	return this;
}

BaseSwitchStatement.prototype = Object.create(BaseStatement.prototype);
BaseSwitchStatement.prototype.constructor = BaseSwitchStatement;


/*

public void addSwitchCase(SwitchCase switchCase) {
	switchCases.add(switchCase);
}

public void setDefaultCase(StatementList defaultCase) {
	this.defaultCase = defaultCase;
}

*/

BaseSwitchStatement.prototype.check = function(context) {
	this.checkSwitchCasesType(context);
	return this.checkReturnType(context);
};

BaseSwitchStatement.prototype.checkSwitchCasesType = function(context) {
	var type = this.checkSwitchType(context);
	this.switchCases.forEach(function(switchCase) {
        switchCase.checkSwitchType(context, type);
	});
};

BaseSwitchStatement.prototype.checkReturnType = function(context) {
	var types = new TypeMap();
	this.collectReturnTypes(context, types);
	return types.inferType(context);
};

BaseSwitchStatement.prototype.collectReturnTypes = function(context, types) {
    this.switchCases.forEach(function(switchCase) {
		var type = switchCase.checkReturnType(context);
		if(type!=VoidType.instance) {
			types[type.name] = type;
		}
	});
	if(this.defaultCase!=null) {
		var type = this.defaultCase.check(context, null);
		if(type!=VoidType.instance) {
			types[type.name] = type;
		}
	}
};

BaseSwitchStatement.prototype.interpretSwitch = function(context, switchValue, toThrow) {
	for(var i=0;i<this.switchCases.length;i++) {
		var sc = this.switchCases[i];
		if(sc.matches(context, switchValue)) {
			return sc.interpret(context);
		}
	}
	if(this.defaultCase!=null) {
		return this.defaultCase.interpret(context);
	}
	if(toThrow!=null) {
		throw toThrow;
	}
	return null;
}

BaseSwitchStatement.prototype.declareSwitch = function(transpiler) {
    this.switchCases.forEach(function(kase) {
        kase.declare(transpiler);
    });
    if(this.defaultCase!=null) {
        this.defaultCase.declare(transpiler);
    }
}


BaseSwitchStatement.prototype.toDialect = function(writer) {
    writer.toDialect(this);
};


BaseSwitchStatement.prototype.canReturn = function() {
    return true;
};

exports.BaseSwitchStatement = BaseSwitchStatement;

function SwitchCaseList(item) {
	ObjectList.call(this);
	item = item || null;
	if(item!=null) {
		this.add(item);
	}
	return this;
}

SwitchCaseList.prototype = Object.create(ObjectList.prototype);
SwitchCaseList.prototype.constructor = SwitchCaseList;

exports.SwitchCaseList = SwitchCaseList;


/***/ }),
/* 224 */
/***/ (function(module, exports, __webpack_require__) {

var ExecutionError = __webpack_require__(48).ExecutionError;

function NotStorableError() {
	ExecutionError.call(this);
	return this;
}

NotStorableError.prototype = Object.create(ExecutionError.prototype);
NotStorableError.prototype.constructor = NotStorableError;

NotStorableError.prototype.getExpression = function(context) {
	return context.getRegisteredValue("NOT_STORABLE");
};

exports.NotStorableError = NotStorableError;


/***/ }),
/* 225 */
/***/ (function(module, exports, __webpack_require__) {

var Value = __webpack_require__(1).Value;
var Dictionary = __webpack_require__(150).Dictionary;
var StrictSet = __webpack_require__(34).StrictSet;
var NullValue = __webpack_require__(21).NullValue;
var SetValue = __webpack_require__(54).SetValue;
var ListValue = __webpack_require__(36).ListValue;
var TextValue = __webpack_require__(17).TextValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var InternalError = __webpack_require__(46).InternalError;
var BaseType = __webpack_require__(47).BaseType;
var DictionaryType = __webpack_require__(99).DictionaryType;
var TextType = __webpack_require__(6).TextType;

function DictionaryValue(itemType, dict, mutable) {
    Value.call(this, new DictionaryType(itemType));
    this.mutable = mutable || false;
	this.dict = dict || new Dictionary(this.mutable);
	return this;
}

DictionaryValue.prototype = Object.create(Value.prototype);
DictionaryValue.prototype.constructor = DictionaryValue;

DictionaryValue.prototype.toString = function() {
    return this.dict.toString();
};


DictionaryValue.prototype.isEmpty = function() {
    return this.dict.isEmpty();
};

DictionaryValue.prototype.Add = function(context, value) {
    if (value instanceof DictionaryValue) {
        return new DictionaryValue(this.type.itemType, this.dict.add(value.dict));
    } else {
        throw new SyntaxError("Illegal: Dict + " + typeof(value));
    }
};

DictionaryValue.prototype.hasItem = function(context, value) {
    if (value instanceof TextValue) {
        return value.value in this.dict;
    } else {
        throw new SyntaxError("Only TextValue key type supported by DictionaryValue");
    }
};


DictionaryValue.prototype.getMemberValue = function(context, name) {
    if ("count"==name) {
        return new IntegerValue(this.dict.length);
    } else if ("keys"==name) {
        var keys = new StrictSet();
        var iter = this.dict.keys.iterator();
        while(iter.hasNext()) {
            keys.add(new TextValue(iter.next()));
        }
        return new SetValue(TextType.instance, keys);
    } else if ("values"==name) {
        var list = this.dict.$keys.map(function(name) {
            return this.dict[name];
        }, this);
        return new ListValue(this.type.itemType, list);
    } else {
        return Value.prototype.getMemberValue.call(this, context, name);
    }
};


DictionaryValue.prototype.setItemInContext = function(context, index, value) {
    if (index instanceof TextValue) {
        this.dict[index] = value;
    } else
        throw new SyntaxError("No such item:" + index.toString())
};

DictionaryValue.prototype.getItemInContext = function(context, index) {
    if (index instanceof TextValue)
    {
        var value = this.dict[index] || NullValue.instance;
        if (value instanceof Value) {
            return value;
        } else {
            throw new InternalError("Item not a value!");
        }
    } else {
        throw new SyntaxError("No such item:" + index.toString());
    }
};

DictionaryValue.prototype.convertToJavaScript = function() {
    var dict = {};
    this.dict.$keys.forEach(function(key) {
        dict[key] = this.dict[key].convertToJavaScript();
    }, this);
    return dict;
};

DictionaryValue.prototype.equals = function(obj) {
    if(obj instanceof DictionaryValue) {
        return this.dict.equals(obj.dict);
    } else {
        return false;
    }
};

DictionaryValue.prototype.getIterator = function(context) {
    return new KVPIterator(context, this.dict);
}

function KVPIterator(context, dict) {
    this.context = context;
    this.dict = dict;
    this.keys = this.dict.$keys;
    this.index = 0;
    return this;
}

KVPIterator.prototype.hasNext = function() {
    return this.index < this.keys.length;
};


KVPIterator.prototype.next = function() {
    var key = this.keys[this.index++];
    return new KVPValue(key, this.dict[key]);
};


function KVPValue(key, value) {
    Value.call(this, null); // TODO check that this is safe
    this.key = key;
    this.value = value;
    return this;
}

KVPValue.prototype = Object.create(Value.prototype);
KVPValue.prototype.constructor = KVPValue;

KVPValue.prototype.getMemberValue = function(context, name) {
    if ("key"==name) {
        return new TextValue(this.key);
    } else if ("value"==name) {
        if (this.value.interpret) {
            this.value = this.value.interpret(context);
        }
        return this.value;
    } else {
        throw new SyntaxError("No such member:" + name);
    }
};

exports.DictionaryValue = DictionaryValue;


/***/ }),
/* 226 */
/***/ (function(module, exports) {

function Operator(name, token) {
    this.name = name;
    this.token = token;
    return this;
}

Operator.prototype.toString = function() {
    return this.token;
};

Operator.prototype.toDialect = function(writer) {
    writer.append(this.token);
};

Operator.PLUS = new Operator("PLUS", "+");
Operator.MINUS = new Operator("MINUS", "-");
Operator.MULTIPLY = new Operator("MULTIPLY", "*");
Operator.DIVIDE = new Operator("DIVIDE", "/");
Operator.IDIVIDE = new Operator("IDIVIDE", "\\");
Operator.MODULO = new Operator("MODULO", "%");

exports.Operator = Operator;


/***/ }),
/* 227 */
/***/ (function(module, exports, __webpack_require__) {

var antlr4 = __webpack_require__(9);
var OLexer = __webpack_require__(534).OLexer;
var Dialect = null;

exports.resolve = function() {
	Dialect = __webpack_require__(8).Dialect;
}

function ONamingLexer(input) {
	OLexer.call(this, input);
	this.dialect = Dialect.O;
	return this;
}

ONamingLexer.prototype = Object.create(OLexer.prototype);
ONamingLexer.prototype.constructor = ONamingLexer;

exports.ONamingLexer = ONamingLexer

/***/ }),
/* 228 */
/***/ (function(module, exports, __webpack_require__) {

exports.JsxSelfClosing = __webpack_require__(535).JsxSelfClosing;
exports.JsxExpression = __webpack_require__(536).JsxExpression;
exports.JsxElement = __webpack_require__(537).JsxElement;
exports.JsxClosing = __webpack_require__(538).JsxClosing;
exports.JsxAttribute = __webpack_require__(539).JsxAttribute;
exports.JsxLiteral = __webpack_require__(540).JsxLiteral;
exports.JsxCode = __webpack_require__(541).JsxCode;
exports.JsxText = __webpack_require__(542).JsxText;


/***/ }),
/* 229 */
/***/ (function(module, exports, __webpack_require__) {

exports.CssCode = __webpack_require__(543).CssCode;
exports.CssText = __webpack_require__(544).CssText;
exports.CssField = __webpack_require__(545).CssField;
exports.CssExpression = __webpack_require__(546).CssExpression;


/***/ }),
/* 230 */
/***/ (function(module, exports) {

function JavaExpression() {
}

exports.JavaExpression = JavaExpression;

/***/ }),
/* 231 */
/***/ (function(module, exports) {

function CSharpExpression() {
	
}

exports.CSharpExpression = CSharpExpression;

/***/ }),
/* 232 */
/***/ (function(module, exports, __webpack_require__) {

exports.PythonStatement = __webpack_require__(571).PythonStatement;
exports.PythonNativeCall = __webpack_require__(233).PythonNativeCall;
exports.Python2NativeCall = __webpack_require__(572).Python2NativeCall;
exports.Python3NativeCall = __webpack_require__(573).Python3NativeCall;
exports.PythonSelfExpression = __webpack_require__(574).PythonSelfExpression;
exports.PythonIdentifierExpression = __webpack_require__(575).PythonIdentifierExpression;
exports.PythonBooleanLiteral = __webpack_require__(576).PythonBooleanLiteral;
exports.PythonCharacterLiteral = __webpack_require__(577).PythonCharacterLiteral;
exports.PythonIntegerLiteral = __webpack_require__(578).PythonIntegerLiteral;
exports.PythonDecimalLiteral = __webpack_require__(579).PythonDecimalLiteral;
//exports.PythonExpressionList = require('./PythonExpressionList').PythonExpressionList;
exports.PythonMethodExpression = __webpack_require__(580).PythonMethodExpression;
exports.PythonTextLiteral = __webpack_require__(582).PythonTextLiteral;
exports.PythonModule = __webpack_require__(583).PythonModule;
exports.PythonNamedArgument = __webpack_require__(584).PythonNamedArgument;
exports.PythonOrdinalArgument = __webpack_require__(585).PythonOrdinalArgument;
exports.PythonArgumentList = __webpack_require__(333).PythonArgumentList;
exports.PythonNativeCategoryBinding = __webpack_require__(235).PythonNativeCategoryBinding;
exports.Python2NativeCategoryBinding = __webpack_require__(586).Python2NativeCategoryBinding;
exports.Python3NativeCategoryBinding = __webpack_require__(587).Python3NativeCategoryBinding;



/***/ }),
/* 233 */
/***/ (function(module, exports, __webpack_require__) {

var NativeCall = __webpack_require__(100).NativeCall;

function PythonNativeCall(statement) {
	NativeCall.call(this);
	this.statement = statement;
	return this;
}

PythonNativeCall.prototype = Object.create(NativeCall.prototype);
PythonNativeCall.prototype.constructor = PythonNativeCall;

PythonNativeCall.prototype.toDialect = function(writer) {
    this.statement.toDialect(writer);
}

exports.PythonNativeCall = PythonNativeCall;


/***/ }),
/* 234 */
/***/ (function(module, exports) {

function PythonExpression() {
	
}


exports.PythonExpression = PythonExpression;

/***/ }),
/* 235 */
/***/ (function(module, exports, __webpack_require__) {

var NativeCategoryBinding = __webpack_require__(157).NativeCategoryBinding;

function PythonNativeCategoryBinding(identifier, module) {
	NativeCategoryBinding.call(this);
	this.identifier = identifier;
	this.module = module;
	return this;
}

PythonNativeCategoryBinding.prototype = Object.create(NativeCategoryBinding.prototype);
PythonNativeCategoryBinding.prototype.constructor = PythonNativeCategoryBinding;

exports.PythonNativeCategoryBinding = PythonNativeCategoryBinding;



/***/ }),
/* 236 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(process) {var isNodeJs = typeof window === 'undefined' && typeof importScripts === 'undefined';

if(isNodeJs) {
    var net = __webpack_require__(90);
    exports.writer = net.Socket;
    exports.stdout = process.stdout;
    exports.stderr = process.stderr;
} else {
    // need a named wrapper around console for situations where console is anonymous (such as in ace.js)
    function writer(m) {
        this.write = m || console.log;
    };

    exports.writer = new writer();
    exports.stdout = new writer(function(t) {
        console.log(t);
    });
    exports.stderr = new writer(function(t) {
        console.error(t);
    });
}

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(57)))

/***/ }),
/* 237 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

var Utils = __webpack_require__(13);
var Token = __webpack_require__(18).Token;
var RuleNode = __webpack_require__(43).RuleNode;
var ErrorNode = __webpack_require__(43).ErrorNode;
var TerminalNode = __webpack_require__(43).TerminalNode;
var ParserRuleContext = __webpack_require__(177).ParserRuleContext;
var RuleContext = __webpack_require__(135).RuleContext;
var INVALID_ALT_NUMBER = __webpack_require__(58).INVALID_ALT_NUMBER;


/** A set of utility routines useful for all kinds of ANTLR trees. */
function Trees() {
}

// Print out a whole tree in LISP form. {@link //getNodeText} is used on the
//  node payloads to get the text for the nodes.  Detect
//  parse trees and extract data appropriately.
Trees.toStringTree = function(tree, ruleNames, recog) {
	ruleNames = ruleNames || null;
	recog = recog || null;
    if(recog!==null) {
       ruleNames = recog.ruleNames;
    }
    var s = Trees.getNodeText(tree, ruleNames);
    s = Utils.escapeWhitespace(s, false);
    var c = tree.getChildCount();
    if(c===0) {
        return s;
    }
    var res = "(" + s + ' ';
    if(c>0) {
        s = Trees.toStringTree(tree.getChild(0), ruleNames);
        res = res.concat(s);
    }
    for(var i=1;i<c;i++) {
        s = Trees.toStringTree(tree.getChild(i), ruleNames);
        res = res.concat(' ' + s);
    }
    res = res.concat(")");
    return res;
};

Trees.getNodeText = function(t, ruleNames, recog) {
	ruleNames = ruleNames || null;
	recog = recog || null;
    if(recog!==null) {
        ruleNames = recog.ruleNames;
    }
    if(ruleNames!==null) {
       if (t instanceof RuleContext) {
           var altNumber = t.getAltNumber();
           if ( altNumber!=INVALID_ALT_NUMBER ) {
               return ruleNames[t.ruleIndex]+":"+altNumber;
           }
           return ruleNames[t.ruleIndex];
       } else if ( t instanceof ErrorNode) {
           return t.toString();
       } else if(t instanceof TerminalNode) {
           if(t.symbol!==null) {
               return t.symbol.text;
           }
       }
    }
    // no recog for rule names
    var payload = t.getPayload();
    if (payload instanceof Token ) {
       return payload.text;
    }
    return t.getPayload().toString();
};


// Return ordered list of all children of this node
Trees.getChildren = function(t) {
	var list = [];
	for(var i=0;i<t.getChildCount();i++) {
		list.push(t.getChild(i));
	}
	return list;
};

// Return a list of all ancestors of this node.  The first node of
//  list is the root and the last is the parent of this node.
//
Trees.getAncestors = function(t) {
    var ancestors = [];
    t = t.getParent();
    while(t!==null) {
        ancestors = [t].concat(ancestors);
        t = t.getParent();
    }
    return ancestors;
};

Trees.findAllTokenNodes = function(t, ttype) {
    return Trees.findAllNodes(t, ttype, true);
};

Trees.findAllRuleNodes = function(t, ruleIndex) {
	return Trees.findAllNodes(t, ruleIndex, false);
};

Trees.findAllNodes = function(t, index, findTokens) {
	var nodes = [];
	Trees._findAllNodes(t, index, findTokens, nodes);
	return nodes;
};

Trees._findAllNodes = function(t, index, findTokens, nodes) {
	// check this node (the root) first
	if(findTokens && (t instanceof TerminalNode)) {
		if(t.symbol.type===index) {
			nodes.push(t);
		}
	} else if(!findTokens && (t instanceof ParserRuleContext)) {
		if(t.ruleIndex===index) {
			nodes.push(t);
		}
	}
	// check children
	for(var i=0;i<t.getChildCount();i++) {
		Trees._findAllNodes(t.getChild(i), index, findTokens, nodes);
	}
};

Trees.descendants = function(t) {
	var nodes = [t];
    for(var i=0;i<t.getChildCount();i++) {
        nodes = nodes.concat(Trees.descendants(t.getChild(i)));
    }
    return nodes;
};


exports.Trees = Trees;

/***/ }),
/* 238 */
/***/ (function(module, exports, __webpack_require__) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

var Token = __webpack_require__(18).Token;
var ATN = __webpack_require__(58).ATN;
var ATNType = __webpack_require__(342).ATNType;
var ATNStates = __webpack_require__(42);
var ATNState = ATNStates.ATNState;
var BasicState = ATNStates.BasicState;
var DecisionState = ATNStates.DecisionState;
var BlockStartState = ATNStates.BlockStartState;
var BlockEndState = ATNStates.BlockEndState;
var LoopEndState = ATNStates.LoopEndState;
var RuleStartState = ATNStates.RuleStartState;
var RuleStopState = ATNStates.RuleStopState;
var TokensStartState = ATNStates.TokensStartState;
var PlusLoopbackState = ATNStates.PlusLoopbackState;
var StarLoopbackState = ATNStates.StarLoopbackState;
var StarLoopEntryState = ATNStates.StarLoopEntryState;
var PlusBlockStartState = ATNStates.PlusBlockStartState;
var StarBlockStartState = ATNStates.StarBlockStartState;
var BasicBlockStartState = ATNStates.BasicBlockStartState;
var Transitions = __webpack_require__(59);
var Transition = Transitions.Transition;
var AtomTransition = Transitions.AtomTransition;
var SetTransition = Transitions.SetTransition;
var NotSetTransition = Transitions.NotSetTransition;
var RuleTransition = Transitions.RuleTransition;
var RangeTransition = Transitions.RangeTransition;
var ActionTransition = Transitions.ActionTransition;
var EpsilonTransition = Transitions.EpsilonTransition;
var WildcardTransition = Transitions.WildcardTransition;
var PredicateTransition = Transitions.PredicateTransition;
var PrecedencePredicateTransition = Transitions.PrecedencePredicateTransition;
var IntervalSet = __webpack_require__(25).IntervalSet;
var Interval = __webpack_require__(25).Interval;
var ATNDeserializationOptions = __webpack_require__(239).ATNDeserializationOptions;
var LexerActions = __webpack_require__(240);
var LexerActionType = LexerActions.LexerActionType;
var LexerSkipAction = LexerActions.LexerSkipAction;
var LexerChannelAction = LexerActions.LexerChannelAction;
var LexerCustomAction = LexerActions.LexerCustomAction;
var LexerMoreAction = LexerActions.LexerMoreAction;
var LexerTypeAction = LexerActions.LexerTypeAction;
var LexerPushModeAction = LexerActions.LexerPushModeAction;
var LexerPopModeAction = LexerActions.LexerPopModeAction;
var LexerModeAction = LexerActions.LexerModeAction;
// This is the earliest supported serialized UUID.
// stick to serialized version for now, we don't need a UUID instance
var BASE_SERIALIZED_UUID = "AADB8D7E-AEEF-4415-AD2B-8204D6CF042E";

//
// This UUID indicates the serialized ATN contains two sets of
// IntervalSets, where the second set's values are encoded as
// 32-bit integers to support the full Unicode SMP range up to U+10FFFF.
//
var ADDED_UNICODE_SMP = "59627784-3BE5-417A-B9EB-8131A7286089";

// This list contains all of the currently supported UUIDs, ordered by when
// the feature first appeared in this branch.
var SUPPORTED_UUIDS = [ BASE_SERIALIZED_UUID, ADDED_UNICODE_SMP ];

var SERIALIZED_VERSION = 3;

// This is the current serialized UUID.
var SERIALIZED_UUID = ADDED_UNICODE_SMP;

function initArray( length, value) {
	var tmp = [];
	tmp[length-1] = value;
	return tmp.map(function(i) {return value;});
}

function ATNDeserializer (options) {

    if ( options=== undefined || options === null ) {
        options = ATNDeserializationOptions.defaultOptions;
    }
    this.deserializationOptions = options;
    this.stateFactories = null;
    this.actionFactories = null;

    return this;
}

// Determines if a particular serialized representation of an ATN supports
// a particular feature, identified by the {@link UUID} used for serializing
// the ATN at the time the feature was first introduced.
//
// @param feature The {@link UUID} marking the first time the feature was
// supported in the serialized ATN.
// @param actualUuid The {@link UUID} of the actual serialized ATN which is
// currently being deserialized.
// @return {@code true} if the {@code actualUuid} value represents a
// serialized ATN at or after the feature identified by {@code feature} was
// introduced; otherwise, {@code false}.

ATNDeserializer.prototype.isFeatureSupported = function(feature, actualUuid) {
    var idx1 = SUPPORTED_UUIDS.indexOf(feature);
    if (idx1<0) {
        return false;
    }
    var idx2 = SUPPORTED_UUIDS.indexOf(actualUuid);
    return idx2 >= idx1;
};

ATNDeserializer.prototype.deserialize = function(data) {
    this.reset(data);
    this.checkVersion();
    this.checkUUID();
    var atn = this.readATN();
    this.readStates(atn);
    this.readRules(atn);
    this.readModes(atn);
    var sets = [];
    // First, deserialize sets with 16-bit arguments <= U+FFFF.
    this.readSets(atn, sets, this.readInt.bind(this));
    // Next, if the ATN was serialized with the Unicode SMP feature,
    // deserialize sets with 32-bit arguments <= U+10FFFF.
    if (this.isFeatureSupported(ADDED_UNICODE_SMP, this.uuid)) {
        this.readSets(atn, sets, this.readInt32.bind(this));
    }
    this.readEdges(atn, sets);
    this.readDecisions(atn);
    this.readLexerActions(atn);
    this.markPrecedenceDecisions(atn);
    this.verifyATN(atn);
    if (this.deserializationOptions.generateRuleBypassTransitions && atn.grammarType === ATNType.PARSER ) {
        this.generateRuleBypassTransitions(atn);
        // re-verify after modification
        this.verifyATN(atn);
    }
    return atn;
};

ATNDeserializer.prototype.reset = function(data) {
	var adjust = function(c) {
        var v = c.charCodeAt(0);
        return v>1  ? v-2 : v + 65533;
	};
    var temp = data.split("").map(adjust);
    // don't adjust the first value since that's the version number
    temp[0] = data.charCodeAt(0);
    this.data = temp;
    this.pos = 0;
};

ATNDeserializer.prototype.checkVersion = function() {
    var version = this.readInt();
    if ( version !== SERIALIZED_VERSION ) {
        throw ("Could not deserialize ATN with version " + version + " (expected " + SERIALIZED_VERSION + ").");
    }
};

ATNDeserializer.prototype.checkUUID = function() {
    var uuid = this.readUUID();
    if (SUPPORTED_UUIDS.indexOf(uuid)<0) {
        throw ("Could not deserialize ATN with UUID: " + uuid +
                        " (expected " + SERIALIZED_UUID + " or a legacy UUID).", uuid, SERIALIZED_UUID);
    }
    this.uuid = uuid;
};

ATNDeserializer.prototype.readATN = function() {
    var grammarType = this.readInt();
    var maxTokenType = this.readInt();
    return new ATN(grammarType, maxTokenType);
};

ATNDeserializer.prototype.readStates = function(atn) {
	var j, pair, stateNumber;
    var loopBackStateNumbers = [];
    var endStateNumbers = [];
    var nstates = this.readInt();
    for(var i=0; i<nstates; i++) {
        var stype = this.readInt();
        // ignore bad type of states
        if (stype===ATNState.INVALID_TYPE) {
            atn.addState(null);
            continue;
        }
        var ruleIndex = this.readInt();
        if (ruleIndex === 0xFFFF) {
            ruleIndex = -1;
        }
        var s = this.stateFactory(stype, ruleIndex);
        if (stype === ATNState.LOOP_END) { // special case
            var loopBackStateNumber = this.readInt();
            loopBackStateNumbers.push([s, loopBackStateNumber]);
        } else if(s instanceof BlockStartState) {
            var endStateNumber = this.readInt();
            endStateNumbers.push([s, endStateNumber]);
        }
        atn.addState(s);
    }
    // delay the assignment of loop back and end states until we know all the
	// state instances have been initialized
    for (j=0; j<loopBackStateNumbers.length; j++) {
        pair = loopBackStateNumbers[j];
        pair[0].loopBackState = atn.states[pair[1]];
    }

    for (j=0; j<endStateNumbers.length; j++) {
        pair = endStateNumbers[j];
        pair[0].endState = atn.states[pair[1]];
    }

    var numNonGreedyStates = this.readInt();
    for (j=0; j<numNonGreedyStates; j++) {
        stateNumber = this.readInt();
        atn.states[stateNumber].nonGreedy = true;
    }

    var numPrecedenceStates = this.readInt();
    for (j=0; j<numPrecedenceStates; j++) {
        stateNumber = this.readInt();
        atn.states[stateNumber].isPrecedenceRule = true;
    }
};

ATNDeserializer.prototype.readRules = function(atn) {
    var i;
    var nrules = this.readInt();
    if (atn.grammarType === ATNType.LEXER ) {
        atn.ruleToTokenType = initArray(nrules, 0);
    }
    atn.ruleToStartState = initArray(nrules, 0);
    for (i=0; i<nrules; i++) {
        var s = this.readInt();
        var startState = atn.states[s];
        atn.ruleToStartState[i] = startState;
        if ( atn.grammarType === ATNType.LEXER ) {
            var tokenType = this.readInt();
            if (tokenType === 0xFFFF) {
                tokenType = Token.EOF;
            }
            atn.ruleToTokenType[i] = tokenType;
        }
    }
    atn.ruleToStopState = initArray(nrules, 0);
    for (i=0; i<atn.states.length; i++) {
        var state = atn.states[i];
        if (!(state instanceof RuleStopState)) {
            continue;
        }
        atn.ruleToStopState[state.ruleIndex] = state;
        atn.ruleToStartState[state.ruleIndex].stopState = state;
    }
};

ATNDeserializer.prototype.readModes = function(atn) {
    var nmodes = this.readInt();
    for (var i=0; i<nmodes; i++) {
        var s = this.readInt();
        atn.modeToStartState.push(atn.states[s]);
    }
};

ATNDeserializer.prototype.readSets = function(atn, sets, readUnicode) {
    var m = this.readInt();
    for (var i=0; i<m; i++) {
        var iset = new IntervalSet();
        sets.push(iset);
        var n = this.readInt();
        var containsEof = this.readInt();
        if (containsEof!==0) {
            iset.addOne(-1);
        }
        for (var j=0; j<n; j++) {
            var i1 = readUnicode();
            var i2 = readUnicode();
            iset.addRange(i1, i2);
        }
    }
};

ATNDeserializer.prototype.readEdges = function(atn, sets) {
	var i, j, state, trans, target;
    var nedges = this.readInt();
    for (i=0; i<nedges; i++) {
        var src = this.readInt();
        var trg = this.readInt();
        var ttype = this.readInt();
        var arg1 = this.readInt();
        var arg2 = this.readInt();
        var arg3 = this.readInt();
        trans = this.edgeFactory(atn, ttype, src, trg, arg1, arg2, arg3, sets);
        var srcState = atn.states[src];
        srcState.addTransition(trans);
    }
    // edges for rule stop states can be derived, so they aren't serialized
    for (i=0; i<atn.states.length; i++) {
        state = atn.states[i];
        for (j=0; j<state.transitions.length; j++) {
            var t = state.transitions[j];
            if (!(t instanceof RuleTransition)) {
                continue;
            }
			var outermostPrecedenceReturn = -1;
			if (atn.ruleToStartState[t.target.ruleIndex].isPrecedenceRule) {
				if (t.precedence === 0) {
					outermostPrecedenceReturn = t.target.ruleIndex;
				}
			}

			trans = new EpsilonTransition(t.followState, outermostPrecedenceReturn);
            atn.ruleToStopState[t.target.ruleIndex].addTransition(trans);
        }
    }

    for (i=0; i<atn.states.length; i++) {
        state = atn.states[i];
        if (state instanceof BlockStartState) {
            // we need to know the end state to set its start state
            if (state.endState === null) {
                throw ("IllegalState");
            }
            // block end states can only be associated to a single block start
			// state
            if ( state.endState.startState !== null) {
                throw ("IllegalState");
            }
            state.endState.startState = state;
        }
        if (state instanceof PlusLoopbackState) {
            for (j=0; j<state.transitions.length; j++) {
                target = state.transitions[j].target;
                if (target instanceof PlusBlockStartState) {
                    target.loopBackState = state;
                }
            }
        } else if (state instanceof StarLoopbackState) {
            for (j=0; j<state.transitions.length; j++) {
                target = state.transitions[j].target;
                if (target instanceof StarLoopEntryState) {
                    target.loopBackState = state;
                }
            }
        }
    }
};

ATNDeserializer.prototype.readDecisions = function(atn) {
    var ndecisions = this.readInt();
    for (var i=0; i<ndecisions; i++) {
        var s = this.readInt();
        var decState = atn.states[s];
        atn.decisionToState.push(decState);
        decState.decision = i;
    }
};

ATNDeserializer.prototype.readLexerActions = function(atn) {
    if (atn.grammarType === ATNType.LEXER) {
        var count = this.readInt();
        atn.lexerActions = initArray(count, null);
        for (var i=0; i<count; i++) {
            var actionType = this.readInt();
            var data1 = this.readInt();
            if (data1 === 0xFFFF) {
                data1 = -1;
            }
            var data2 = this.readInt();
            if (data2 === 0xFFFF) {
                data2 = -1;
            }
            var lexerAction = this.lexerActionFactory(actionType, data1, data2);
            atn.lexerActions[i] = lexerAction;
        }
    }
};

ATNDeserializer.prototype.generateRuleBypassTransitions = function(atn) {
	var i;
    var count = atn.ruleToStartState.length;
    for(i=0; i<count; i++) {
        atn.ruleToTokenType[i] = atn.maxTokenType + i + 1;
    }
    for(i=0; i<count; i++) {
        this.generateRuleBypassTransition(atn, i);
    }
};

ATNDeserializer.prototype.generateRuleBypassTransition = function(atn, idx) {
	var i, state;
    var bypassStart = new BasicBlockStartState();
    bypassStart.ruleIndex = idx;
    atn.addState(bypassStart);

    var bypassStop = new BlockEndState();
    bypassStop.ruleIndex = idx;
    atn.addState(bypassStop);

    bypassStart.endState = bypassStop;
    atn.defineDecisionState(bypassStart);

    bypassStop.startState = bypassStart;

    var excludeTransition = null;
    var endState = null;

    if (atn.ruleToStartState[idx].isPrecedenceRule) {
        // wrap from the beginning of the rule to the StarLoopEntryState
        endState = null;
        for(i=0; i<atn.states.length; i++) {
            state = atn.states[i];
            if (this.stateIsEndStateFor(state, idx)) {
                endState = state;
                excludeTransition = state.loopBackState.transitions[0];
                break;
            }
        }
        if (excludeTransition === null) {
            throw ("Couldn't identify final state of the precedence rule prefix section.");
        }
    } else {
        endState = atn.ruleToStopState[idx];
    }

    // all non-excluded transitions that currently target end state need to
	// target blockEnd instead
    for(i=0; i<atn.states.length; i++) {
        state = atn.states[i];
        for(var j=0; j<state.transitions.length; j++) {
            var transition = state.transitions[j];
            if (transition === excludeTransition) {
                continue;
            }
            if (transition.target === endState) {
                transition.target = bypassStop;
            }
        }
    }

    // all transitions leaving the rule start state need to leave blockStart
	// instead
    var ruleToStartState = atn.ruleToStartState[idx];
    var count = ruleToStartState.transitions.length;
    while ( count > 0) {
        bypassStart.addTransition(ruleToStartState.transitions[count-1]);
        ruleToStartState.transitions = ruleToStartState.transitions.slice(-1);
    }
    // link the new states
    atn.ruleToStartState[idx].addTransition(new EpsilonTransition(bypassStart));
    bypassStop.addTransition(new EpsilonTransition(endState));

    var matchState = new BasicState();
    atn.addState(matchState);
    matchState.addTransition(new AtomTransition(bypassStop, atn.ruleToTokenType[idx]));
    bypassStart.addTransition(new EpsilonTransition(matchState));
};

ATNDeserializer.prototype.stateIsEndStateFor = function(state, idx) {
    if ( state.ruleIndex !== idx) {
        return null;
    }
    if (!( state instanceof StarLoopEntryState)) {
        return null;
    }
    var maybeLoopEndState = state.transitions[state.transitions.length - 1].target;
    if (!( maybeLoopEndState instanceof LoopEndState)) {
        return null;
    }
    if (maybeLoopEndState.epsilonOnlyTransitions &&
        (maybeLoopEndState.transitions[0].target instanceof RuleStopState)) {
        return state;
    } else {
        return null;
    }
};

//
// Analyze the {@link StarLoopEntryState} states in the specified ATN to set
// the {@link StarLoopEntryState//isPrecedenceDecision} field to the
// correct value.
//
// @param atn The ATN.
//
ATNDeserializer.prototype.markPrecedenceDecisions = function(atn) {
	for(var i=0; i<atn.states.length; i++) {
		var state = atn.states[i];
		if (!( state instanceof StarLoopEntryState)) {
            continue;
        }
        // We analyze the ATN to determine if this ATN decision state is the
        // decision for the closure block that determines whether a
        // precedence rule should continue or complete.
        //
        if ( atn.ruleToStartState[state.ruleIndex].isPrecedenceRule) {
            var maybeLoopEndState = state.transitions[state.transitions.length - 1].target;
            if (maybeLoopEndState instanceof LoopEndState) {
                if ( maybeLoopEndState.epsilonOnlyTransitions &&
                        (maybeLoopEndState.transitions[0].target instanceof RuleStopState)) {
                    state.isPrecedenceDecision = true;
                }
            }
        }
	}
};

ATNDeserializer.prototype.verifyATN = function(atn) {
    if (!this.deserializationOptions.verifyATN) {
        return;
    }
    // verify assumptions
	for(var i=0; i<atn.states.length; i++) {
        var state = atn.states[i];
        if (state === null) {
            continue;
        }
        this.checkCondition(state.epsilonOnlyTransitions || state.transitions.length <= 1);
        if (state instanceof PlusBlockStartState) {
            this.checkCondition(state.loopBackState !== null);
        } else  if (state instanceof StarLoopEntryState) {
            this.checkCondition(state.loopBackState !== null);
            this.checkCondition(state.transitions.length === 2);
            if (state.transitions[0].target instanceof StarBlockStartState) {
                this.checkCondition(state.transitions[1].target instanceof LoopEndState);
                this.checkCondition(!state.nonGreedy);
            } else if (state.transitions[0].target instanceof LoopEndState) {
                this.checkCondition(state.transitions[1].target instanceof StarBlockStartState);
                this.checkCondition(state.nonGreedy);
            } else {
                throw("IllegalState");
            }
        } else if (state instanceof StarLoopbackState) {
            this.checkCondition(state.transitions.length === 1);
            this.checkCondition(state.transitions[0].target instanceof StarLoopEntryState);
        } else if (state instanceof LoopEndState) {
            this.checkCondition(state.loopBackState !== null);
        } else if (state instanceof RuleStartState) {
            this.checkCondition(state.stopState !== null);
        } else if (state instanceof BlockStartState) {
            this.checkCondition(state.endState !== null);
        } else if (state instanceof BlockEndState) {
            this.checkCondition(state.startState !== null);
        } else if (state instanceof DecisionState) {
            this.checkCondition(state.transitions.length <= 1 || state.decision >= 0);
        } else {
            this.checkCondition(state.transitions.length <= 1 || (state instanceof RuleStopState));
        }
	}
};

ATNDeserializer.prototype.checkCondition = function(condition, message) {
    if (!condition) {
        if (message === undefined || message===null) {
            message = "IllegalState";
        }
        throw (message);
    }
};

ATNDeserializer.prototype.readInt = function() {
    return this.data[this.pos++];
};

ATNDeserializer.prototype.readInt32 = function() {
    var low = this.readInt();
    var high = this.readInt();
    return low | (high << 16);
};

ATNDeserializer.prototype.readLong = function() {
    var low = this.readInt32();
    var high = this.readInt32();
    return (low & 0x00000000FFFFFFFF) | (high << 32);
};

function createByteToHex() {
	var bth = [];
	for (var i = 0; i < 256; i++) {
		bth[i] = (i + 0x100).toString(16).substr(1).toUpperCase();
	}
	return bth;
}

var byteToHex = createByteToHex();

ATNDeserializer.prototype.readUUID = function() {
	var bb = [];
	for(var i=7;i>=0;i--) {
		var int = this.readInt();
		/* jshint bitwise: false */
		bb[(2*i)+1] = int & 0xFF;
		bb[2*i] = (int >> 8) & 0xFF;
	}
    return byteToHex[bb[0]] + byteToHex[bb[1]] +
    byteToHex[bb[2]] + byteToHex[bb[3]] + '-' +
    byteToHex[bb[4]] + byteToHex[bb[5]] + '-' +
    byteToHex[bb[6]] + byteToHex[bb[7]] + '-' +
    byteToHex[bb[8]] + byteToHex[bb[9]] + '-' +
    byteToHex[bb[10]] + byteToHex[bb[11]] +
    byteToHex[bb[12]] + byteToHex[bb[13]] +
    byteToHex[bb[14]] + byteToHex[bb[15]];
};

ATNDeserializer.prototype.edgeFactory = function(atn, type, src, trg, arg1, arg2, arg3, sets) {
    var target = atn.states[trg];
    switch(type) {
    case Transition.EPSILON:
        return new EpsilonTransition(target);
    case Transition.RANGE:
        return arg3 !== 0 ? new RangeTransition(target, Token.EOF, arg2) : new RangeTransition(target, arg1, arg2);
    case Transition.RULE:
        return new RuleTransition(atn.states[arg1], arg2, arg3, target);
    case Transition.PREDICATE:
        return new PredicateTransition(target, arg1, arg2, arg3 !== 0);
    case Transition.PRECEDENCE:
        return new PrecedencePredicateTransition(target, arg1);
    case Transition.ATOM:
        return arg3 !== 0 ? new AtomTransition(target, Token.EOF) : new AtomTransition(target, arg1);
    case Transition.ACTION:
        return new ActionTransition(target, arg1, arg2, arg3 !== 0);
    case Transition.SET:
        return new SetTransition(target, sets[arg1]);
    case Transition.NOT_SET:
        return new NotSetTransition(target, sets[arg1]);
    case Transition.WILDCARD:
        return new WildcardTransition(target);
    default:
        throw "The specified transition type: " + type + " is not valid.";
    }
};

ATNDeserializer.prototype.stateFactory = function(type, ruleIndex) {
    if (this.stateFactories === null) {
        var sf = [];
        sf[ATNState.INVALID_TYPE] = null;
        sf[ATNState.BASIC] = function() { return new BasicState(); };
        sf[ATNState.RULE_START] = function() { return new RuleStartState(); };
        sf[ATNState.BLOCK_START] = function() { return new BasicBlockStartState(); };
        sf[ATNState.PLUS_BLOCK_START] = function() { return new PlusBlockStartState(); };
        sf[ATNState.STAR_BLOCK_START] = function() { return new StarBlockStartState(); };
        sf[ATNState.TOKEN_START] = function() { return new TokensStartState(); };
        sf[ATNState.RULE_STOP] = function() { return new RuleStopState(); };
        sf[ATNState.BLOCK_END] = function() { return new BlockEndState(); };
        sf[ATNState.STAR_LOOP_BACK] = function() { return new StarLoopbackState(); };
        sf[ATNState.STAR_LOOP_ENTRY] = function() { return new StarLoopEntryState(); };
        sf[ATNState.PLUS_LOOP_BACK] = function() { return new PlusLoopbackState(); };
        sf[ATNState.LOOP_END] = function() { return new LoopEndState(); };
        this.stateFactories = sf;
    }
    if (type>this.stateFactories.length || this.stateFactories[type] === null) {
        throw("The specified state type " + type + " is not valid.");
    } else {
        var s = this.stateFactories[type]();
        if (s!==null) {
            s.ruleIndex = ruleIndex;
            return s;
        }
    }
};

ATNDeserializer.prototype.lexerActionFactory = function(type, data1, data2) {
    if (this.actionFactories === null) {
        var af = [];
        af[LexerActionType.CHANNEL] = function(data1, data2) { return new LexerChannelAction(data1); };
        af[LexerActionType.CUSTOM] = function(data1, data2) { return new LexerCustomAction(data1, data2); };
        af[LexerActionType.MODE] = function(data1, data2) { return new LexerModeAction(data1); };
        af[LexerActionType.MORE] = function(data1, data2) { return LexerMoreAction.INSTANCE; };
        af[LexerActionType.POP_MODE] = function(data1, data2) { return LexerPopModeAction.INSTANCE; };
        af[LexerActionType.PUSH_MODE] = function(data1, data2) { return new LexerPushModeAction(data1); };
        af[LexerActionType.SKIP] = function(data1, data2) { return LexerSkipAction.INSTANCE; };
        af[LexerActionType.TYPE] = function(data1, data2) { return new LexerTypeAction(data1); };
        this.actionFactories = af;
    }
    if (type>this.actionFactories.length || this.actionFactories[type] === null) {
        throw("The specified lexer action type " + type + " is not valid.");
    } else {
        return this.actionFactories[type](data1, data2);
    }
};


exports.ATNDeserializer = ATNDeserializer;

/***/ }),
/* 239 */
/***/ (function(module, exports) {

/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */

function ATNDeserializationOptions(copyFrom) {
	if(copyFrom===undefined) {
		copyFrom = null;
	}
	this.readOnly = false;
    this.verifyATN = copyFrom===null ? true : copyFrom.verifyATN;
    this.generateRuleBypassTransitions = copyFrom===null ? false : copyFrom.generateRuleBypassTransitions;

    return this;
}

ATNDeserializationOptions.defaultOptions = new ATNDeserializationOptions();
ATNDeserializationOptions.defaultOptions.readOnly = true;

//    def __setattr__(self, key, value):
//        if key!="readOnly" and self.readOnly:
//            raise Exception("The object is read only.")
//        super(type(self), self).__setattr__(key,value)

exports.ATNDeserializationOptions = ATNDeserializationOptions;


/***/ }),
/* 240 */
/***/ (function(module, exports) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
 //

function LexerActionType() {
}

LexerActionType.CHANNEL = 0;     //The type of a {@link LexerChannelAction} action.
LexerActionType.CUSTOM = 1;      //The type of a {@link LexerCustomAction} action.
LexerActionType.MODE = 2;        //The type of a {@link LexerModeAction} action.
LexerActionType.MORE = 3;        //The type of a {@link LexerMoreAction} action.
LexerActionType.POP_MODE = 4;    //The type of a {@link LexerPopModeAction} action.
LexerActionType.PUSH_MODE = 5;   //The type of a {@link LexerPushModeAction} action.
LexerActionType.SKIP = 6;        //The type of a {@link LexerSkipAction} action.
LexerActionType.TYPE = 7;        //The type of a {@link LexerTypeAction} action.

function LexerAction(action) {
    this.actionType = action;
    this.isPositionDependent = false;
    return this;
}

LexerAction.prototype.hashCode = function() {
    var hash = new Hash();
    this.updateHashCode(hash);
    return hash.finish()
};

LexerAction.prototype.updateHashCode = function(hash) {
    hash.update(this.actionType);
};

LexerAction.prototype.equals = function(other) {
    return this === other;
};



//
// Implements the {@code skip} lexer action by calling {@link Lexer//skip}.
//
// <p>The {@code skip} command does not have any parameters, so this action is
// implemented as a singleton instance exposed by {@link //INSTANCE}.</p>
function LexerSkipAction() {
	LexerAction.call(this, LexerActionType.SKIP);
	return this;
}

LexerSkipAction.prototype = Object.create(LexerAction.prototype);
LexerSkipAction.prototype.constructor = LexerSkipAction;

// Provides a singleton instance of this parameterless lexer action.
LexerSkipAction.INSTANCE = new LexerSkipAction();

LexerSkipAction.prototype.execute = function(lexer) {
    lexer.skip();
};

LexerSkipAction.prototype.toString = function() {
	return "skip";
};

//  Implements the {@code type} lexer action by calling {@link Lexer//setType}
// with the assigned type.
function LexerTypeAction(type) {
	LexerAction.call(this, LexerActionType.TYPE);
	this.type = type;
	return this;
}

LexerTypeAction.prototype = Object.create(LexerAction.prototype);
LexerTypeAction.prototype.constructor = LexerTypeAction;

LexerTypeAction.prototype.execute = function(lexer) {
    lexer.type = this.type;
};

LexerTypeAction.prototype.updateHashCode = function(hash) {
    hash.update(this.actionType, this.type);
};


LexerTypeAction.prototype.equals = function(other) {
    if(this === other) {
        return true;
    } else if (! (other instanceof LexerTypeAction)) {
        return false;
    } else {
        return this.type === other.type;
    }
};

LexerTypeAction.prototype.toString = function() {
    return "type(" + this.type + ")";
};

// Implements the {@code pushMode} lexer action by calling
// {@link Lexer//pushMode} with the assigned mode.
function LexerPushModeAction(mode) {
	LexerAction.call(this, LexerActionType.PUSH_MODE);
    this.mode = mode;
    return this;
}

LexerPushModeAction.prototype = Object.create(LexerAction.prototype);
LexerPushModeAction.prototype.constructor = LexerPushModeAction;

// <p>This action is implemented by calling {@link Lexer//pushMode} with the
// value provided by {@link //getMode}.</p>
LexerPushModeAction.prototype.execute = function(lexer) {
    lexer.pushMode(this.mode);
};

LexerPushModeAction.prototype.updateHashCode = function(hash) {
    hash.update(this.actionType, this.mode);
};

LexerPushModeAction.prototype.equals = function(other) {
    if (this === other) {
        return true;
    } else if (! (other instanceof LexerPushModeAction)) {
        return false;
    } else {
        return this.mode === other.mode;
    }
};

LexerPushModeAction.prototype.toString = function() {
	return "pushMode(" + this.mode + ")";
};


// Implements the {@code popMode} lexer action by calling {@link Lexer//popMode}.
//
// <p>The {@code popMode} command does not have any parameters, so this action is
// implemented as a singleton instance exposed by {@link //INSTANCE}.</p>
function LexerPopModeAction() {
	LexerAction.call(this,LexerActionType.POP_MODE);
	return this;
}

LexerPopModeAction.prototype = Object.create(LexerAction.prototype);
LexerPopModeAction.prototype.constructor = LexerPopModeAction;

LexerPopModeAction.INSTANCE = new LexerPopModeAction();

// <p>This action is implemented by calling {@link Lexer//popMode}.</p>
LexerPopModeAction.prototype.execute = function(lexer) {
    lexer.popMode();
};

LexerPopModeAction.prototype.toString = function() {
	return "popMode";
};

// Implements the {@code more} lexer action by calling {@link Lexer//more}.
//
// <p>The {@code more} command does not have any parameters, so this action is
// implemented as a singleton instance exposed by {@link //INSTANCE}.</p>
function LexerMoreAction() {
	LexerAction.call(this, LexerActionType.MORE);
	return this;
}

LexerMoreAction.prototype = Object.create(LexerAction.prototype);
LexerMoreAction.prototype.constructor = LexerMoreAction;

LexerMoreAction.INSTANCE = new LexerMoreAction();

// <p>This action is implemented by calling {@link Lexer//popMode}.</p>
LexerMoreAction.prototype.execute = function(lexer) {
    lexer.more();
};

LexerMoreAction.prototype.toString = function() {
    return "more";
};


// Implements the {@code mode} lexer action by calling {@link Lexer//mode} with
// the assigned mode.
function LexerModeAction(mode) {
	LexerAction.call(this, LexerActionType.MODE);
    this.mode = mode;
    return this;
}

LexerModeAction.prototype = Object.create(LexerAction.prototype);
LexerModeAction.prototype.constructor = LexerModeAction;

// <p>This action is implemented by calling {@link Lexer//mode} with the
// value provided by {@link //getMode}.</p>
LexerModeAction.prototype.execute = function(lexer) {
    lexer.mode(this.mode);
};

LexerModeAction.prototype.updateHashCode = function(hash) {
    hash.update(this.actionType, this.mode);
};

LexerModeAction.prototype.equals = function(other) {
    if (this === other) {
        return true;
    } else if (! (other instanceof LexerModeAction)) {
        return false;
    } else {
        return this.mode === other.mode;
    }
};

LexerModeAction.prototype.toString = function() {
    return "mode(" + this.mode + ")";
};

// Executes a custom lexer action by calling {@link Recognizer//action} with the
// rule and action indexes assigned to the custom action. The implementation of
// a custom action is added to the generated code for the lexer in an override
// of {@link Recognizer//action} when the grammar is compiled.
//
// <p>This class may represent embedded actions created with the <code>{...}</code>
// syntax in ANTLR 4, as well as actions created for lexer commands where the
// command argument could not be evaluated when the grammar was compiled.</p>


    // Constructs a custom lexer action with the specified rule and action
    // indexes.
    //
    // @param ruleIndex The rule index to use for calls to
    // {@link Recognizer//action}.
    // @param actionIndex The action index to use for calls to
    // {@link Recognizer//action}.

function LexerCustomAction(ruleIndex, actionIndex) {
	LexerAction.call(this, LexerActionType.CUSTOM);
    this.ruleIndex = ruleIndex;
    this.actionIndex = actionIndex;
    this.isPositionDependent = true;
    return this;
}

LexerCustomAction.prototype = Object.create(LexerAction.prototype);
LexerCustomAction.prototype.constructor = LexerCustomAction;

// <p>Custom actions are implemented by calling {@link Lexer//action} with the
// appropriate rule and action indexes.</p>
LexerCustomAction.prototype.execute = function(lexer) {
    lexer.action(null, this.ruleIndex, this.actionIndex);
};

LexerCustomAction.prototype.updateHashCode = function(hash) {
    hash.update(this.actionType, this.ruleIndex, this.actionIndex);
};

LexerCustomAction.prototype.equals = function(other) {
    if (this === other) {
        return true;
    } else if (! (other instanceof LexerCustomAction)) {
        return false;
    } else {
        return this.ruleIndex === other.ruleIndex && this.actionIndex === other.actionIndex;
    }
};

// Implements the {@code channel} lexer action by calling
// {@link Lexer//setChannel} with the assigned channel.
// Constructs a new {@code channel} action with the specified channel value.
// @param channel The channel value to pass to {@link Lexer//setChannel}.
function LexerChannelAction(channel) {
	LexerAction.call(this, LexerActionType.CHANNEL);
    this.channel = channel;
    return this;
}

LexerChannelAction.prototype = Object.create(LexerAction.prototype);
LexerChannelAction.prototype.constructor = LexerChannelAction;

// <p>This action is implemented by calling {@link Lexer//setChannel} with the
// value provided by {@link //getChannel}.</p>
LexerChannelAction.prototype.execute = function(lexer) {
    lexer._channel = this.channel;
};

LexerChannelAction.prototype.updateHashCode = function(hash) {
    hash.update(this.actionType, this.channel);
};

LexerChannelAction.prototype.equals = function(other) {
    if (this === other) {
        return true;
    } else if (! (other instanceof LexerChannelAction)) {
        return false;
    } else {
        return this.channel === other.channel;
    }
};

LexerChannelAction.prototype.toString = function() {
    return "channel(" + this.channel + ")";
};

// This implementation of {@link LexerAction} is used for tracking input offsets
// for position-dependent actions within a {@link LexerActionExecutor}.
//
// <p>This action is not serialized as part of the ATN, and is only required for
// position-dependent lexer actions which appear at a location other than the
// end of a rule. For more information about DFA optimizations employed for
// lexer actions, see {@link LexerActionExecutor//append} and
// {@link LexerActionExecutor//fixOffsetBeforeMatch}.</p>

// Constructs a new indexed custom action by associating a character offset
// with a {@link LexerAction}.
//
// <p>Note: This class is only required for lexer actions for which
// {@link LexerAction//isPositionDependent} returns {@code true}.</p>
//
// @param offset The offset into the input {@link CharStream}, relative to
// the token start index, at which the specified lexer action should be
// executed.
// @param action The lexer action to execute at a particular offset in the
// input {@link CharStream}.
function LexerIndexedCustomAction(offset, action) {
	LexerAction.call(this, action.actionType);
    this.offset = offset;
    this.action = action;
    this.isPositionDependent = true;
    return this;
}

LexerIndexedCustomAction.prototype = Object.create(LexerAction.prototype);
LexerIndexedCustomAction.prototype.constructor = LexerIndexedCustomAction;

// <p>This method calls {@link //execute} on the result of {@link //getAction}
// using the provided {@code lexer}.</p>
LexerIndexedCustomAction.prototype.execute = function(lexer) {
    // assume the input stream position was properly set by the calling code
    this.action.execute(lexer);
};

LexerIndexedCustomAction.prototype.updateHashCode = function(hash) {
    hash.update(this.actionType, this.offset, this.action);
};

LexerIndexedCustomAction.prototype.equals = function(other) {
    if (this === other) {
        return true;
    } else if (! (other instanceof LexerIndexedCustomAction)) {
        return false;
    } else {
        return this.offset === other.offset && this.action === other.action;
    }
};


exports.LexerActionType = LexerActionType;
exports.LexerSkipAction = LexerSkipAction;
exports.LexerChannelAction = LexerChannelAction;
exports.LexerCustomAction = LexerCustomAction;
exports.LexerIndexedCustomAction = LexerIndexedCustomAction;
exports.LexerMoreAction = LexerMoreAction;
exports.LexerTypeAction = LexerTypeAction;
exports.LexerPushModeAction = LexerPushModeAction;
exports.LexerPopModeAction = LexerPopModeAction;
exports.LexerModeAction = LexerModeAction;

/***/ }),
/* 241 */
/***/ (function(module, exports, __webpack_require__) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
//

var Token = __webpack_require__(18).Token;
var ConsoleErrorListener = __webpack_require__(137).ConsoleErrorListener;
var ProxyErrorListener = __webpack_require__(137).ProxyErrorListener;

function Recognizer() {
    this._listeners = [ ConsoleErrorListener.INSTANCE ];
    this._interp = null;
    this._stateNumber = -1;
    return this;
}

Recognizer.tokenTypeMapCache = {};
Recognizer.ruleIndexMapCache = {};


Recognizer.prototype.checkVersion = function(toolVersion) {
    var runtimeVersion = "4.7.1";
    if (runtimeVersion!==toolVersion) {
        console.log("ANTLR runtime and generated code versions disagree: "+runtimeVersion+"!="+toolVersion);
    }
};

Recognizer.prototype.addErrorListener = function(listener) {
    this._listeners.push(listener);
};

Recognizer.prototype.removeErrorListeners = function() {
    this._listeners = [];
};

Recognizer.prototype.getTokenTypeMap = function() {
    var tokenNames = this.getTokenNames();
    if (tokenNames===null) {
        throw("The current recognizer does not provide a list of token names.");
    }
    var result = this.tokenTypeMapCache[tokenNames];
    if(result===undefined) {
        result = tokenNames.reduce(function(o, k, i) { o[k] = i; });
        result.EOF = Token.EOF;
        this.tokenTypeMapCache[tokenNames] = result;
    }
    return result;
};

// Get a map from rule names to rule indexes.
//
// <p>Used for XPath and tree pattern compilation.</p>
//
Recognizer.prototype.getRuleIndexMap = function() {
    var ruleNames = this.ruleNames;
    if (ruleNames===null) {
        throw("The current recognizer does not provide a list of rule names.");
    }
    var result = this.ruleIndexMapCache[ruleNames];
    if(result===undefined) {
        result = ruleNames.reduce(function(o, k, i) { o[k] = i; });
        this.ruleIndexMapCache[ruleNames] = result;
    }
    return result;
};

Recognizer.prototype.getTokenType = function(tokenName) {
    var ttype = this.getTokenTypeMap()[tokenName];
    if (ttype !==undefined) {
        return ttype;
    } else {
        return Token.INVALID_TYPE;
    }
};


// What is the error header, normally line/character position information?//
Recognizer.prototype.getErrorHeader = function(e) {
    var line = e.getOffendingToken().line;
    var column = e.getOffendingToken().column;
    return "line " + line + ":" + column;
};


// How should a token be displayed in an error message? The default
//  is to display just the text, but during development you might
//  want to have a lot of information spit out.  Override in that case
//  to use t.toString() (which, for CommonToken, dumps everything about
//  the token). This is better than forcing you to override a method in
//  your token objects because you don't have to go modify your lexer
//  so that it creates a new Java type.
//
// @deprecated This method is not called by the ANTLR 4 Runtime. Specific
// implementations of {@link ANTLRErrorStrategy} may provide a similar
// feature when necessary. For example, see
// {@link DefaultErrorStrategy//getTokenErrorDisplay}.
//
Recognizer.prototype.getTokenErrorDisplay = function(t) {
    if (t===null) {
        return "<no token>";
    }
    var s = t.text;
    if (s===null) {
        if (t.type===Token.EOF) {
            s = "<EOF>";
        } else {
            s = "<" + t.type + ">";
        }
    }
    s = s.replace("\n","\\n").replace("\r","\\r").replace("\t","\\t");
    return "'" + s + "'";
};

Recognizer.prototype.getErrorListenerDispatch = function() {
    return new ProxyErrorListener(this._listeners);
};

// subclass needs to override these if there are sempreds or actions
// that the ATN interp needs to execute
Recognizer.prototype.sempred = function(localctx, ruleIndex, actionIndex) {
    return true;
};

Recognizer.prototype.precpred = function(localctx , precedence) {
    return true;
};

//Indicate that the recognizer has changed internal state that is
//consistent with the ATN state passed in.  This way we always know
//where we are in the ATN as the parser goes along. The rule
//context objects form a stack that lets us see the stack of
//invoking rules. Combine this and we have complete ATN
//configuration information.

Object.defineProperty(Recognizer.prototype, "state", {
	get : function() {
		return this._stateNumber;
	},
	set : function(state) {
		this._stateNumber = state;
	}
});


exports.Recognizer = Recognizer;


/***/ }),
/* 242 */
/***/ (function(module, exports, __webpack_require__) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
///

var DFAState = __webpack_require__(89).DFAState;
var ATNConfigSet = __webpack_require__(69).ATNConfigSet;
var getCachedPredictionContext = __webpack_require__(51).getCachedPredictionContext;

function ATNSimulator(atn, sharedContextCache) {

    // The context cache maps all PredictionContext objects that are ==
    //  to a single cached copy. This cache is shared across all contexts
    //  in all ATNConfigs in all DFA states.  We rebuild each ATNConfigSet
    //  to use only cached nodes/graphs in addDFAState(). We don't want to
    //  fill this during closure() since there are lots of contexts that
    //  pop up but are not used ever again. It also greatly slows down closure().
    //
    //  <p>This cache makes a huge difference in memory and a little bit in speed.
    //  For the Java grammar on java.*, it dropped the memory requirements
    //  at the end from 25M to 16M. We don't store any of the full context
    //  graphs in the DFA because they are limited to local context only,
    //  but apparently there's a lot of repetition there as well. We optimize
    //  the config contexts before storing the config set in the DFA states
    //  by literally rebuilding them with cached subgraphs only.</p>
    //
    //  <p>I tried a cache for use during closure operations, that was
    //  whacked after each adaptivePredict(). It cost a little bit
    //  more time I think and doesn't save on the overall footprint
    //  so it's not worth the complexity.</p>
    ///
    this.atn = atn;
    this.sharedContextCache = sharedContextCache;
    return this;
}

// Must distinguish between missing edge and edge we know leads nowhere///
ATNSimulator.ERROR = new DFAState(0x7FFFFFFF, new ATNConfigSet());


ATNSimulator.prototype.getCachedContext = function(context) {
    if (this.sharedContextCache ===null) {
        return context;
    }
    var visited = {};
    return getCachedPredictionContext(context, this.sharedContextCache, visited);
};

exports.ATNSimulator = ATNSimulator;


/***/ }),
/* 243 */
/***/ (function(module, exports, __webpack_require__) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
//
//
// This enumeration defines the prediction modes available in ANTLR 4 along with
// utility methods for analyzing configuration sets for conflicts and/or
// ambiguities.

var Set = __webpack_require__(13).Set;
var Map = __webpack_require__(13).Map;
var BitSet = __webpack_require__(13).BitSet;
var AltDict = __webpack_require__(13).AltDict;
var ATN = __webpack_require__(58).ATN;
var RuleStopState = __webpack_require__(42).RuleStopState;
var ATNConfigSet = __webpack_require__(69).ATNConfigSet;
var ATNConfig = __webpack_require__(134).ATNConfig;
var SemanticContext = __webpack_require__(88).SemanticContext;
var Hash = __webpack_require__(13).Hash;
var hashStuff = __webpack_require__(13).hashStuff;
var equalArrays = __webpack_require__(13).equalArrays;

function PredictionMode() {
	return this;
}

//
// The SLL(*) prediction mode. This prediction mode ignores the current
// parser context when making predictions. This is the fastest prediction
// mode, and provides correct results for many grammars. This prediction
// mode is more powerful than the prediction mode provided by ANTLR 3, but
// may result in syntax errors for grammar and input combinations which are
// not SLL.
//
// <p>
// When using this prediction mode, the parser will either return a correct
// parse tree (i.e. the same parse tree that would be returned with the
// {@link //LL} prediction mode), or it will report a syntax error. If a
// syntax error is encountered when using the {@link //SLL} prediction mode,
// it may be due to either an actual syntax error in the input or indicate
// that the particular combination of grammar and input requires the more
// powerful {@link //LL} prediction abilities to complete successfully.</p>
//
// <p>
// This prediction mode does not provide any guarantees for prediction
// behavior for syntactically-incorrect inputs.</p>
//
PredictionMode.SLL = 0;
//
// The LL(*) prediction mode. This prediction mode allows the current parser
// context to be used for resolving SLL conflicts that occur during
// prediction. This is the fastest prediction mode that guarantees correct
// parse results for all combinations of grammars with syntactically correct
// inputs.
//
// <p>
// When using this prediction mode, the parser will make correct decisions
// for all syntactically-correct grammar and input combinations. However, in
// cases where the grammar is truly ambiguous this prediction mode might not
// report a precise answer for <em>exactly which</em> alternatives are
// ambiguous.</p>
//
// <p>
// This prediction mode does not provide any guarantees for prediction
// behavior for syntactically-incorrect inputs.</p>
//
PredictionMode.LL = 1;
//
// The LL(*) prediction mode with exact ambiguity detection. In addition to
// the correctness guarantees provided by the {@link //LL} prediction mode,
// this prediction mode instructs the prediction algorithm to determine the
// complete and exact set of ambiguous alternatives for every ambiguous
// decision encountered while parsing.
//
// <p>
// This prediction mode may be used for diagnosing ambiguities during
// grammar development. Due to the performance overhead of calculating sets
// of ambiguous alternatives, this prediction mode should be avoided when
// the exact results are not necessary.</p>
//
// <p>
// This prediction mode does not provide any guarantees for prediction
// behavior for syntactically-incorrect inputs.</p>
//
PredictionMode.LL_EXACT_AMBIG_DETECTION = 2;


//
// Computes the SLL prediction termination condition.
//
// <p>
// This method computes the SLL prediction termination condition for both of
// the following cases.</p>
//
// <ul>
// <li>The usual SLL+LL fallback upon SLL conflict</li>
// <li>Pure SLL without LL fallback</li>
// </ul>
//
// <p><strong>COMBINED SLL+LL PARSING</strong></p>
//
// <p>When LL-fallback is enabled upon SLL conflict, correct predictions are
// ensured regardless of how the termination condition is computed by this
// method. Due to the substantially higher cost of LL prediction, the
// prediction should only fall back to LL when the additional lookahead
// cannot lead to a unique SLL prediction.</p>
//
// <p>Assuming combined SLL+LL parsing, an SLL configuration set with only
// conflicting subsets should fall back to full LL, even if the
// configuration sets don't resolve to the same alternative (e.g.
// {@code {1,2}} and {@code {3,4}}. If there is at least one non-conflicting
// configuration, SLL could continue with the hopes that more lookahead will
// resolve via one of those non-conflicting configurations.</p>
//
// <p>Here's the prediction termination rule them: SLL (for SLL+LL parsing)
// stops when it sees only conflicting configuration subsets. In contrast,
// full LL keeps going when there is uncertainty.</p>
//
// <p><strong>HEURISTIC</strong></p>
//
// <p>As a heuristic, we stop prediction when we see any conflicting subset
// unless we see a state that only has one alternative associated with it.
// The single-alt-state thing lets prediction continue upon rules like
// (otherwise, it would admit defeat too soon):</p>
//
// <p>{@code [12|1|[], 6|2|[], 12|2|[]]. s : (ID | ID ID?) ';' ;}</p>
//
// <p>When the ATN simulation reaches the state before {@code ';'}, it has a
// DFA state that looks like: {@code [12|1|[], 6|2|[], 12|2|[]]}. Naturally
// {@code 12|1|[]} and {@code 12|2|[]} conflict, but we cannot stop
// processing this node because alternative to has another way to continue,
// via {@code [6|2|[]]}.</p>
//
// <p>It also let's us continue for this rule:</p>
//
// <p>{@code [1|1|[], 1|2|[], 8|3|[]] a : A | A | A B ;}</p>
//
// <p>After matching input A, we reach the stop state for rule A, state 1.
// State 8 is the state right before B. Clearly alternatives 1 and 2
// conflict and no amount of further lookahead will separate the two.
// However, alternative 3 will be able to continue and so we do not stop
// working on this state. In the previous example, we're concerned with
// states associated with the conflicting alternatives. Here alt 3 is not
// associated with the conflicting configs, but since we can continue
// looking for input reasonably, don't declare the state done.</p>
//
// <p><strong>PURE SLL PARSING</strong></p>
//
// <p>To handle pure SLL parsing, all we have to do is make sure that we
// combine stack contexts for configurations that differ only by semantic
// predicate. From there, we can do the usual SLL termination heuristic.</p>
//
// <p><strong>PREDICATES IN SLL+LL PARSING</strong></p>
//
// <p>SLL decisions don't evaluate predicates until after they reach DFA stop
// states because they need to create the DFA cache that works in all
// semantic situations. In contrast, full LL evaluates predicates collected
// during start state computation so it can ignore predicates thereafter.
// This means that SLL termination detection can totally ignore semantic
// predicates.</p>
//
// <p>Implementation-wise, {@link ATNConfigSet} combines stack contexts but not
// semantic predicate contexts so we might see two configurations like the
// following.</p>
//
// <p>{@code (s, 1, x, {}), (s, 1, x', {p})}</p>
//
// <p>Before testing these configurations against others, we have to merge
// {@code x} and {@code x'} (without modifying the existing configurations).
// For example, we test {@code (x+x')==x''} when looking for conflicts in
// the following configurations.</p>
//
// <p>{@code (s, 1, x, {}), (s, 1, x', {p}), (s, 2, x'', {})}</p>
//
// <p>If the configuration set has predicates (as indicated by
// {@link ATNConfigSet//hasSemanticContext}), this algorithm makes a copy of
// the configurations to strip out all of the predicates so that a standard
// {@link ATNConfigSet} will merge everything ignoring predicates.</p>
//
PredictionMode.hasSLLConflictTerminatingPrediction = function( mode, configs) {
    // Configs in rule stop states indicate reaching the end of the decision
    // rule (local context) or end of start rule (full context). If all
    // configs meet this condition, then none of the configurations is able
    // to match additional input so we terminate prediction.
    //
    if (PredictionMode.allConfigsInRuleStopStates(configs)) {
        return true;
    }
    // pure SLL mode parsing
    if (mode === PredictionMode.SLL) {
        // Don't bother with combining configs from different semantic
        // contexts if we can fail over to full LL; costs more time
        // since we'll often fail over anyway.
        if (configs.hasSemanticContext) {
            // dup configs, tossing out semantic predicates
            var dup = new ATNConfigSet();
            for(var i=0;i<configs.items.length;i++) {
            	var c = configs.items[i];
                c = new ATNConfig({semanticContext:SemanticContext.NONE}, c);
                dup.add(c);
            }
            configs = dup;
        }
        // now we have combined contexts for configs with dissimilar preds
    }
    // pure SLL or combined SLL+LL mode parsing
    var altsets = PredictionMode.getConflictingAltSubsets(configs);
    return PredictionMode.hasConflictingAltSet(altsets) && !PredictionMode.hasStateAssociatedWithOneAlt(configs);
};

// Checks if any configuration in {@code configs} is in a
// {@link RuleStopState}. Configurations meeting this condition have reached
// the end of the decision rule (local context) or end of start rule (full
// context).
//
// @param configs the configuration set to test
// @return {@code true} if any configuration in {@code configs} is in a
// {@link RuleStopState}, otherwise {@code false}
PredictionMode.hasConfigInRuleStopState = function(configs) {
	for(var i=0;i<configs.items.length;i++) {
		var c = configs.items[i];
        if (c.state instanceof RuleStopState) {
            return true;
        }
	}
    return false;
};

// Checks if all configurations in {@code configs} are in a
// {@link RuleStopState}. Configurations meeting this condition have reached
// the end of the decision rule (local context) or end of start rule (full
// context).
//
// @param configs the configuration set to test
// @return {@code true} if all configurations in {@code configs} are in a
// {@link RuleStopState}, otherwise {@code false}
PredictionMode.allConfigsInRuleStopStates = function(configs) {
	for(var i=0;i<configs.items.length;i++) {
		var c = configs.items[i];
        if (!(c.state instanceof RuleStopState)) {
            return false;
        }
	}
    return true;
};

//
// Full LL prediction termination.
//
// <p>Can we stop looking ahead during ATN simulation or is there some
// uncertainty as to which alternative we will ultimately pick, after
// consuming more input? Even if there are partial conflicts, we might know
// that everything is going to resolve to the same minimum alternative. That
// means we can stop since no more lookahead will change that fact. On the
// other hand, there might be multiple conflicts that resolve to different
// minimums. That means we need more look ahead to decide which of those
// alternatives we should predict.</p>
//
// <p>The basic idea is to split the set of configurations {@code C}, into
// conflicting subsets {@code (s, _, ctx, _)} and singleton subsets with
// non-conflicting configurations. Two configurations conflict if they have
// identical {@link ATNConfig//state} and {@link ATNConfig//context} values
// but different {@link ATNConfig//alt} value, e.g. {@code (s, i, ctx, _)}
// and {@code (s, j, ctx, _)} for {@code i!=j}.</p>
//
// <p>Reduce these configuration subsets to the set of possible alternatives.
// You can compute the alternative subsets in one pass as follows:</p>
//
// <p>{@code A_s,ctx = {i | (s, i, ctx, _)}} for each configuration in
// {@code C} holding {@code s} and {@code ctx} fixed.</p>
//
// <p>Or in pseudo-code, for each configuration {@code c} in {@code C}:</p>
//
// <pre>
// map[c] U= c.{@link ATNConfig//alt alt} // map hash/equals uses s and x, not
// alt and not pred
// </pre>
//
// <p>The values in {@code map} are the set of {@code A_s,ctx} sets.</p>
//
// <p>If {@code |A_s,ctx|=1} then there is no conflict associated with
// {@code s} and {@code ctx}.</p>
//
// <p>Reduce the subsets to singletons by choosing a minimum of each subset. If
// the union of these alternative subsets is a singleton, then no amount of
// more lookahead will help us. We will always pick that alternative. If,
// however, there is more than one alternative, then we are uncertain which
// alternative to predict and must continue looking for resolution. We may
// or may not discover an ambiguity in the future, even if there are no
// conflicting subsets this round.</p>
//
// <p>The biggest sin is to terminate early because it means we've made a
// decision but were uncertain as to the eventual outcome. We haven't used
// enough lookahead. On the other hand, announcing a conflict too late is no
// big deal; you will still have the conflict. It's just inefficient. It
// might even look until the end of file.</p>
//
// <p>No special consideration for semantic predicates is required because
// predicates are evaluated on-the-fly for full LL prediction, ensuring that
// no configuration contains a semantic context during the termination
// check.</p>
//
// <p><strong>CONFLICTING CONFIGS</strong></p>
//
// <p>Two configurations {@code (s, i, x)} and {@code (s, j, x')}, conflict
// when {@code i!=j} but {@code x=x'}. Because we merge all
// {@code (s, i, _)} configurations together, that means that there are at
// most {@code n} configurations associated with state {@code s} for
// {@code n} possible alternatives in the decision. The merged stacks
// complicate the comparison of configuration contexts {@code x} and
// {@code x'}. Sam checks to see if one is a subset of the other by calling
// merge and checking to see if the merged result is either {@code x} or
// {@code x'}. If the {@code x} associated with lowest alternative {@code i}
// is the superset, then {@code i} is the only possible prediction since the
// others resolve to {@code min(i)} as well. However, if {@code x} is
// associated with {@code j>i} then at least one stack configuration for
// {@code j} is not in conflict with alternative {@code i}. The algorithm
// should keep going, looking for more lookahead due to the uncertainty.</p>
//
// <p>For simplicity, I'm doing a equality check between {@code x} and
// {@code x'} that lets the algorithm continue to consume lookahead longer
// than necessary. The reason I like the equality is of course the
// simplicity but also because that is the test you need to detect the
// alternatives that are actually in conflict.</p>
//
// <p><strong>CONTINUE/STOP RULE</strong></p>
//
// <p>Continue if union of resolved alternative sets from non-conflicting and
// conflicting alternative subsets has more than one alternative. We are
// uncertain about which alternative to predict.</p>
//
// <p>The complete set of alternatives, {@code [i for (_,i,_)]}, tells us which
// alternatives are still in the running for the amount of input we've
// consumed at this point. The conflicting sets let us to strip away
// configurations that won't lead to more states because we resolve
// conflicts to the configuration with a minimum alternate for the
// conflicting set.</p>
//
// <p><strong>CASES</strong></p>
//
// <ul>
//
// <li>no conflicts and more than 1 alternative in set =&gt; continue</li>
//
// <li> {@code (s, 1, x)}, {@code (s, 2, x)}, {@code (s, 3, z)},
// {@code (s', 1, y)}, {@code (s', 2, y)} yields non-conflicting set
// {@code {3}} U conflicting sets {@code min({1,2})} U {@code min({1,2})} =
// {@code {1,3}} =&gt; continue
// </li>
//
// <li>{@code (s, 1, x)}, {@code (s, 2, x)}, {@code (s', 1, y)},
// {@code (s', 2, y)}, {@code (s'', 1, z)} yields non-conflicting set
// {@code {1}} U conflicting sets {@code min({1,2})} U {@code min({1,2})} =
// {@code {1}} =&gt; stop and predict 1</li>
//
// <li>{@code (s, 1, x)}, {@code (s, 2, x)}, {@code (s', 1, y)},
// {@code (s', 2, y)} yields conflicting, reduced sets {@code {1}} U
// {@code {1}} = {@code {1}} =&gt; stop and predict 1, can announce
// ambiguity {@code {1,2}}</li>
//
// <li>{@code (s, 1, x)}, {@code (s, 2, x)}, {@code (s', 2, y)},
// {@code (s', 3, y)} yields conflicting, reduced sets {@code {1}} U
// {@code {2}} = {@code {1,2}} =&gt; continue</li>
//
// <li>{@code (s, 1, x)}, {@code (s, 2, x)}, {@code (s', 3, y)},
// {@code (s', 4, y)} yields conflicting, reduced sets {@code {1}} U
// {@code {3}} = {@code {1,3}} =&gt; continue</li>
//
// </ul>
//
// <p><strong>EXACT AMBIGUITY DETECTION</strong></p>
//
// <p>If all states report the same conflicting set of alternatives, then we
// know we have the exact ambiguity set.</p>
//
// <p><code>|A_<em>i</em>|&gt;1</code> and
// <code>A_<em>i</em> = A_<em>j</em></code> for all <em>i</em>, <em>j</em>.</p>
//
// <p>In other words, we continue examining lookahead until all {@code A_i}
// have more than one alternative and all {@code A_i} are the same. If
// {@code A={{1,2}, {1,3}}}, then regular LL prediction would terminate
// because the resolved set is {@code {1}}. To determine what the real
// ambiguity is, we have to know whether the ambiguity is between one and
// two or one and three so we keep going. We can only stop prediction when
// we need exact ambiguity detection when the sets look like
// {@code A={{1,2}}} or {@code {{1,2},{1,2}}}, etc...</p>
//
PredictionMode.resolvesToJustOneViableAlt = function(altsets) {
    return PredictionMode.getSingleViableAlt(altsets);
};

//
// Determines if every alternative subset in {@code altsets} contains more
// than one alternative.
//
// @param altsets a collection of alternative subsets
// @return {@code true} if every {@link BitSet} in {@code altsets} has
// {@link BitSet//cardinality cardinality} &gt; 1, otherwise {@code false}
//
PredictionMode.allSubsetsConflict = function(altsets) {
    return ! PredictionMode.hasNonConflictingAltSet(altsets);
};
//
// Determines if any single alternative subset in {@code altsets} contains
// exactly one alternative.
//
// @param altsets a collection of alternative subsets
// @return {@code true} if {@code altsets} contains a {@link BitSet} with
// {@link BitSet//cardinality cardinality} 1, otherwise {@code false}
//
PredictionMode.hasNonConflictingAltSet = function(altsets) {
	for(var i=0;i<altsets.length;i++) {
		var alts = altsets[i];
        if (alts.length===1) {
            return true;
        }
	}
    return false;
};

//
// Determines if any single alternative subset in {@code altsets} contains
// more than one alternative.
//
// @param altsets a collection of alternative subsets
// @return {@code true} if {@code altsets} contains a {@link BitSet} with
// {@link BitSet//cardinality cardinality} &gt; 1, otherwise {@code false}
//
PredictionMode.hasConflictingAltSet = function(altsets) {
	for(var i=0;i<altsets.length;i++) {
		var alts = altsets[i];
        if (alts.length>1) {
            return true;
        }
	}
    return false;
};

//
// Determines if every alternative subset in {@code altsets} is equivalent.
//
// @param altsets a collection of alternative subsets
// @return {@code true} if every member of {@code altsets} is equal to the
// others, otherwise {@code false}
//
PredictionMode.allSubsetsEqual = function(altsets) {
    var first = null;
	for(var i=0;i<altsets.length;i++) {
		var alts = altsets[i];
        if (first === null) {
            first = alts;
        } else if (alts!==first) {
            return false;
        }
	}
    return true;
};

//
// Returns the unique alternative predicted by all alternative subsets in
// {@code altsets}. If no such alternative exists, this method returns
// {@link ATN//INVALID_ALT_NUMBER}.
//
// @param altsets a collection of alternative subsets
//
PredictionMode.getUniqueAlt = function(altsets) {
    var all = PredictionMode.getAlts(altsets);
    if (all.length===1) {
        return all.minValue();
    } else {
        return ATN.INVALID_ALT_NUMBER;
    }
};

// Gets the complete set of represented alternatives for a collection of
// alternative subsets. This method returns the union of each {@link BitSet}
// in {@code altsets}.
//
// @param altsets a collection of alternative subsets
// @return the set of represented alternatives in {@code altsets}
//
PredictionMode.getAlts = function(altsets) {
    var all = new BitSet();
    altsets.map( function(alts) { all.or(alts); });
    return all;
};

//
// This function gets the conflicting alt subsets from a configuration set.
// For each configuration {@code c} in {@code configs}:
//
// <pre>
// map[c] U= c.{@link ATNConfig//alt alt} // map hash/equals uses s and x, not
// alt and not pred
// </pre>

PredictionMode.getConflictingAltSubsets = function(configs) {
    var configToAlts = new Map();
    configToAlts.hashFunction = function(cfg) { hashStuff(cfg.state.stateNumber, cfg.context); };
    configToAlts.equalsFunction = function(c1, c2) { return c1.state.stateNumber==c2.state.stateNumber && c1.context.equals(c2.context);}
    configs.items.map(function(cfg) {
        var alts = configToAlts.get(cfg);
        if (alts === null) {
            alts = new BitSet();
            configToAlts.put(cfg, alts);
        }
        alts.add(cfg.alt);
	});
    return configToAlts.getValues();
};

//
// Get a map from state to alt subset from a configuration set. For each
// configuration {@code c} in {@code configs}:
//
// <pre>
// map[c.{@link ATNConfig//state state}] U= c.{@link ATNConfig//alt alt}
// </pre>
//
PredictionMode.getStateToAltMap = function(configs) {
    var m = new AltDict();
    configs.items.map(function(c) {
        var alts = m.get(c.state);
        if (alts === null) {
            alts = new BitSet();
            m.put(c.state, alts);
        }
        alts.add(c.alt);
    });
    return m;
};

PredictionMode.hasStateAssociatedWithOneAlt = function(configs) {
    var values = PredictionMode.getStateToAltMap(configs).values();
    for(var i=0;i<values.length;i++) {
        if (values[i].length===1) {
            return true;
        }
    }
    return false;
};

PredictionMode.getSingleViableAlt = function(altsets) {
    var result = null;
	for(var i=0;i<altsets.length;i++) {
		var alts = altsets[i];
        var minAlt = alts.minValue();
        if(result===null) {
            result = minAlt;
        } else if(result!==minAlt) { // more than 1 viable alt
            return ATN.INVALID_ALT_NUMBER;
        }
	}
    return result;
};

exports.PredictionMode = PredictionMode;


/***/ }),
/* 244 */
/***/ (function(module, exports) {

/*! https://mths.be/codepointat v0.2.0 by @mathias */
if (!String.prototype.codePointAt) {
	(function() {
		'use strict'; // needed to support `apply`/`call` with `undefined`/`null`
		var defineProperty = (function() {
			// IE 8 only supports `Object.defineProperty` on DOM elements
			try {
				var object = {};
				var $defineProperty = Object.defineProperty;
				var result = $defineProperty(object, object, object) && $defineProperty;
			} catch(error) {}
			return result;
		}());
		var codePointAt = function(position) {
			if (this == null) {
				throw TypeError();
			}
			var string = String(this);
			var size = string.length;
			// `ToInteger`
			var index = position ? Number(position) : 0;
			if (index != index) { // better `isNaN`
				index = 0;
			}
			// Account for out-of-bounds indices:
			if (index < 0 || index >= size) {
				return undefined;
			}
			// Get the first code unit
			var first = string.charCodeAt(index);
			var second;
			if ( // check if it’s the start of a surrogate pair
				first >= 0xD800 && first <= 0xDBFF && // high surrogate
				size > index + 1 // there is a next code unit
			) {
				second = string.charCodeAt(index + 1);
				if (second >= 0xDC00 && second <= 0xDFFF) { // low surrogate
					// https://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
					return (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;
				}
			}
			return first;
		};
		if (defineProperty) {
			defineProperty(String.prototype, 'codePointAt', {
				'value': codePointAt,
				'configurable': true,
				'writable': true
			});
		} else {
			String.prototype.codePointAt = codePointAt;
		}
	}());
}


/***/ }),
/* 245 */
/***/ (function(module, exports) {

/*! https://mths.be/fromcodepoint v0.2.1 by @mathias */
if (!String.fromCodePoint) {
	(function() {
		var defineProperty = (function() {
			// IE 8 only supports `Object.defineProperty` on DOM elements
			try {
				var object = {};
				var $defineProperty = Object.defineProperty;
				var result = $defineProperty(object, object, object) && $defineProperty;
			} catch(error) {}
			return result;
		}());
		var stringFromCharCode = String.fromCharCode;
		var floor = Math.floor;
		var fromCodePoint = function(_) {
			var MAX_SIZE = 0x4000;
			var codeUnits = [];
			var highSurrogate;
			var lowSurrogate;
			var index = -1;
			var length = arguments.length;
			if (!length) {
				return '';
			}
			var result = '';
			while (++index < length) {
				var codePoint = Number(arguments[index]);
				if (
					!isFinite(codePoint) || // `NaN`, `+Infinity`, or `-Infinity`
					codePoint < 0 || // not a valid Unicode code point
					codePoint > 0x10FFFF || // not a valid Unicode code point
					floor(codePoint) != codePoint // not an integer
				) {
					throw RangeError('Invalid code point: ' + codePoint);
				}
				if (codePoint <= 0xFFFF) { // BMP code point
					codeUnits.push(codePoint);
				} else { // Astral code point; split in surrogate halves
					// https://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
					codePoint -= 0x10000;
					highSurrogate = (codePoint >> 10) + 0xD800;
					lowSurrogate = (codePoint % 0x400) + 0xDC00;
					codeUnits.push(highSurrogate, lowSurrogate);
				}
				if (index + 1 == length || codeUnits.length > MAX_SIZE) {
					result += stringFromCharCode.apply(null, codeUnits);
					codeUnits.length = 0;
				}
			}
			return result;
		};
		if (defineProperty) {
			defineProperty(String, 'fromCodePoint', {
				'value': fromCodePoint,
				'configurable': true,
				'writable': true
			});
		} else {
			String.fromCodePoint = fromCodePoint;
		}
	}());
}


/***/ }),
/* 246 */
/***/ (function(module, exports, __webpack_require__) {

//
/* Copyright (c) 2012-2017 The ANTLR Project. All rights reserved.
 * Use of this file is governed by the BSD 3-clause license that
 * can be found in the LICENSE.txt file in the project root.
 */
//

var Token = __webpack_require__(18).Token;
var Errors = __webpack_require__(44);
var NoViableAltException = Errors.NoViableAltException;
var InputMismatchException = Errors.InputMismatchException;
var FailedPredicateException = Errors.FailedPredicateException;
var ParseCancellationException = Errors.ParseCancellationException;
var ATNState = __webpack_require__(42).ATNState;
var Interval = __webpack_require__(25).Interval;
var IntervalSet = __webpack_require__(25).IntervalSet;

function ErrorStrategy() {

}

ErrorStrategy.prototype.reset = function(recognizer){
};

ErrorStrategy.prototype.recoverInline = function(recognizer){
};

ErrorStrategy.prototype.recover = function(recognizer, e){
};

ErrorStrategy.prototype.sync = function(recognizer){
};

ErrorStrategy.prototype.inErrorRecoveryMode = function(recognizer){
};

ErrorStrategy.prototype.reportError = function(recognizer){
};



// This is the default implementation of {@link ANTLRErrorStrategy} used for
// error reporting and recovery in ANTLR parsers.
//
function DefaultErrorStrategy() {
	ErrorStrategy.call(this);
    // Indicates whether the error strategy is currently "recovering from an
    // error". This is used to suppress reporting multiple error messages while
    // attempting to recover from a detected syntax error.
    //
    // @see //inErrorRecoveryMode
    //
    this.errorRecoveryMode = false;

    // The index into the input stream where the last error occurred.
    // This is used to prevent infinite loops where an error is found
    // but no token is consumed during recovery...another error is found,
    // ad nauseum. This is a failsafe mechanism to guarantee that at least
    // one token/tree node is consumed for two errors.
    //
    this.lastErrorIndex = -1;
    this.lastErrorStates = null;
    return this;
}

DefaultErrorStrategy.prototype = Object.create(ErrorStrategy.prototype);
DefaultErrorStrategy.prototype.constructor = DefaultErrorStrategy;

// <p>The default implementation simply calls {@link //endErrorCondition} to
// ensure that the handler is not in error recovery mode.</p>
DefaultErrorStrategy.prototype.reset = function(recognizer) {
    this.endErrorCondition(recognizer);
};

//
// This method is called to enter error recovery mode when a recognition
// exception is reported.
//
// @param recognizer the parser instance
//
DefaultErrorStrategy.prototype.beginErrorCondition = function(recognizer) {
    this.errorRecoveryMode = true;
};

DefaultErrorStrategy.prototype.inErrorRecoveryMode = function(recognizer) {
    return this.errorRecoveryMode;
};

//
// This method is called to leave error recovery mode after recovering from
// a recognition exception.
//
// @param recognizer
//
DefaultErrorStrategy.prototype.endErrorCondition = function(recognizer) {
    this.errorRecoveryMode = false;
    this.lastErrorStates = null;
    this.lastErrorIndex = -1;
};

//
// {@inheritDoc}
//
// <p>The default implementation simply calls {@link //endErrorCondition}.</p>
//
DefaultErrorStrategy.prototype.reportMatch = function(recognizer) {
    this.endErrorCondition(recognizer);
};

//
// {@inheritDoc}
//
// <p>The default implementation returns immediately if the handler is already
// in error recovery mode. Otherwise, it calls {@link //beginErrorCondition}
// and dispatches the reporting task based on the runtime type of {@code e}
// according to the following table.</p>
//
// <ul>
// <li>{@link NoViableAltException}: Dispatches the call to
// {@link //reportNoViableAlternative}</li>
// <li>{@link InputMismatchException}: Dispatches the call to
// {@link //reportInputMismatch}</li>
// <li>{@link FailedPredicateException}: Dispatches the call to
// {@link //reportFailedPredicate}</li>
// <li>All other types: calls {@link Parser//notifyErrorListeners} to report
// the exception</li>
// </ul>
//
DefaultErrorStrategy.prototype.reportError = function(recognizer, e) {
   // if we've already reported an error and have not matched a token
   // yet successfully, don't report any errors.
    if(this.inErrorRecoveryMode(recognizer)) {
        return; // don't report spurious errors
    }
    this.beginErrorCondition(recognizer);
    if ( e instanceof NoViableAltException ) {
        this.reportNoViableAlternative(recognizer, e);
    } else if ( e instanceof InputMismatchException ) {
        this.reportInputMismatch(recognizer, e);
    } else if ( e instanceof FailedPredicateException ) {
        this.reportFailedPredicate(recognizer, e);
    } else {
        console.log("unknown recognition error type: " + e.constructor.name);
        console.log(e.stack);
        recognizer.notifyErrorListeners(e.getOffendingToken(), e.getMessage(), e);
    }
};
//
// {@inheritDoc}
//
// <p>The default implementation resynchronizes the parser by consuming tokens
// until we find one in the resynchronization set--loosely the set of tokens
// that can follow the current rule.</p>
//
DefaultErrorStrategy.prototype.recover = function(recognizer, e) {
    if (this.lastErrorIndex===recognizer.getInputStream().index &&
        this.lastErrorStates !== null && this.lastErrorStates.indexOf(recognizer.state)>=0) {
		// uh oh, another error at same token index and previously-visited
		// state in ATN; must be a case where LT(1) is in the recovery
		// token set so nothing got consumed. Consume a single token
		// at least to prevent an infinite loop; this is a failsafe.
		recognizer.consume();
    }
    this.lastErrorIndex = recognizer._input.index;
    if (this.lastErrorStates === null) {
        this.lastErrorStates = [];
    }
    this.lastErrorStates.push(recognizer.state);
    var followSet = this.getErrorRecoverySet(recognizer);
    this.consumeUntil(recognizer, followSet);
};

// The default implementation of {@link ANTLRErrorStrategy//sync} makes sure
// that the current lookahead symbol is consistent with what were expecting
// at this point in the ATN. You can call this anytime but ANTLR only
// generates code to check before subrules/loops and each iteration.
//
// <p>Implements Jim Idle's magic sync mechanism in closures and optional
// subrules. E.g.,</p>
//
// <pre>
// a : sync ( stuff sync )* ;
// sync : {consume to what can follow sync} ;
// </pre>
//
// At the start of a sub rule upon error, {@link //sync} performs single
// token deletion, if possible. If it can't do that, it bails on the current
// rule and uses the default error recovery, which consumes until the
// resynchronization set of the current rule.
//
// <p>If the sub rule is optional ({@code (...)?}, {@code (...)*}, or block
// with an empty alternative), then the expected set includes what follows
// the subrule.</p>
//
// <p>During loop iteration, it consumes until it sees a token that can start a
// sub rule or what follows loop. Yes, that is pretty aggressive. We opt to
// stay in the loop as long as possible.</p>
//
// <p><strong>ORIGINS</strong></p>
//
// <p>Previous versions of ANTLR did a poor job of their recovery within loops.
// A single mismatch token or missing token would force the parser to bail
// out of the entire rules surrounding the loop. So, for rule</p>
//
// <pre>
// classDef : 'class' ID '{' member* '}'
// </pre>
//
// input with an extra token between members would force the parser to
// consume until it found the next class definition rather than the next
// member definition of the current class.
//
// <p>This functionality cost a little bit of effort because the parser has to
// compare token set at the start of the loop and at each iteration. If for
// some reason speed is suffering for you, you can turn off this
// functionality by simply overriding this method as a blank { }.</p>
//
DefaultErrorStrategy.prototype.sync = function(recognizer) {
    // If already recovering, don't try to sync
    if (this.inErrorRecoveryMode(recognizer)) {
        return;
    }
    var s = recognizer._interp.atn.states[recognizer.state];
    var la = recognizer.getTokenStream().LA(1);
    // try cheaper subset first; might get lucky. seems to shave a wee bit off
    var nextTokens = recognizer.atn.nextTokens(s);
    if (nextTokens.contains(Token.EPSILON) || nextTokens.contains(la)) {
        return;
    }
    switch (s.stateType) {
    case ATNState.BLOCK_START:
    case ATNState.STAR_BLOCK_START:
    case ATNState.PLUS_BLOCK_START:
    case ATNState.STAR_LOOP_ENTRY:
       // report error and recover if possible
        if( this.singleTokenDeletion(recognizer) !== null) {
            return;
        } else {
            throw new InputMismatchException(recognizer);
        }
        break;
    case ATNState.PLUS_LOOP_BACK:
    case ATNState.STAR_LOOP_BACK:
        this.reportUnwantedToken(recognizer);
        var expecting = new IntervalSet();
        expecting.addSet(recognizer.getExpectedTokens());
        var whatFollowsLoopIterationOrRule = expecting.addSet(this.getErrorRecoverySet(recognizer));
        this.consumeUntil(recognizer, whatFollowsLoopIterationOrRule);
        break;
    default:
        // do nothing if we can't identify the exact kind of ATN state
    }
};

// This is called by {@link //reportError} when the exception is a
// {@link NoViableAltException}.
//
// @see //reportError
//
// @param recognizer the parser instance
// @param e the recognition exception
//
DefaultErrorStrategy.prototype.reportNoViableAlternative = function(recognizer, e) {
    var tokens = recognizer.getTokenStream();
    var input;
    if(tokens !== null) {
        if (e.startToken.type===Token.EOF) {
            input = "<EOF>";
        } else {
            input = tokens.getText(new Interval(e.startToken.tokenIndex, e.offendingToken.tokenIndex));
        }
    } else {
        input = "<unknown input>";
    }
    var msg = "no viable alternative at input " + this.escapeWSAndQuote(input);
    recognizer.notifyErrorListeners(msg, e.offendingToken, e);
};

//
// This is called by {@link //reportError} when the exception is an
// {@link InputMismatchException}.
//
// @see //reportError
//
// @param recognizer the parser instance
// @param e the recognition exception
//
DefaultErrorStrategy.prototype.reportInputMismatch = function(recognizer, e) {
    var msg = "mismatched input " + this.getTokenErrorDisplay(e.offendingToken) +
          " expecting " + e.getExpectedTokens().toString(recognizer.literalNames, recognizer.symbolicNames);
    recognizer.notifyErrorListeners(msg, e.offendingToken, e);
};

//
// This is called by {@link //reportError} when the exception is a
// {@link FailedPredicateException}.
//
// @see //reportError
//
// @param recognizer the parser instance
// @param e the recognition exception
//
DefaultErrorStrategy.prototype.reportFailedPredicate = function(recognizer, e) {
    var ruleName = recognizer.ruleNames[recognizer._ctx.ruleIndex];
    var msg = "rule " + ruleName + " " + e.message;
    recognizer.notifyErrorListeners(msg, e.offendingToken, e);
};

// This method is called to report a syntax error which requires the removal
// of a token from the input stream. At the time this method is called, the
// erroneous symbol is current {@code LT(1)} symbol and has not yet been
// removed from the input stream. When this method returns,
// {@code recognizer} is in error recovery mode.
//
// <p>This method is called when {@link //singleTokenDeletion} identifies
// single-token deletion as a viable recovery strategy for a mismatched
// input error.</p>
//
// <p>The default implementation simply returns if the handler is already in
// error recovery mode. Otherwise, it calls {@link //beginErrorCondition} to
// enter error recovery mode, followed by calling
// {@link Parser//notifyErrorListeners}.</p>
//
// @param recognizer the parser instance
//
DefaultErrorStrategy.prototype.reportUnwantedToken = function(recognizer) {
    if (this.inErrorRecoveryMode(recognizer)) {
        return;
    }
    this.beginErrorCondition(recognizer);
    var t = recognizer.getCurrentToken();
    var tokenName = this.getTokenErrorDisplay(t);
    var expecting = this.getExpectedTokens(recognizer);
    var msg = "extraneous input " + tokenName + " expecting " +
        expecting.toString(recognizer.literalNames, recognizer.symbolicNames);
    recognizer.notifyErrorListeners(msg, t, null);
};
// This method is called to report a syntax error which requires the
// insertion of a missing token into the input stream. At the time this
// method is called, the missing token has not yet been inserted. When this
// method returns, {@code recognizer} is in error recovery mode.
//
// <p>This method is called when {@link //singleTokenInsertion} identifies
// single-token insertion as a viable recovery strategy for a mismatched
// input error.</p>
//
// <p>The default implementation simply returns if the handler is already in
// error recovery mode. Otherwise, it calls {@link //beginErrorCondition} to
// enter error recovery mode, followed by calling
// {@link Parser//notifyErrorListeners}.</p>
//
// @param recognizer the parser instance
//
DefaultErrorStrategy.prototype.reportMissingToken = function(recognizer) {
    if ( this.inErrorRecoveryMode(recognizer)) {
        return;
    }
    this.beginErrorCondition(recognizer);
    var t = recognizer.getCurrentToken();
    var expecting = this.getExpectedTokens(recognizer);
    var msg = "missing " + expecting.toString(recognizer.literalNames, recognizer.symbolicNames) +
          " at " + this.getTokenErrorDisplay(t);
    recognizer.notifyErrorListeners(msg, t, null);
};

// <p>The default implementation attempts to recover from the mismatched input
// by using single token insertion and deletion as described below. If the
// recovery attempt fails, this method throws an
// {@link InputMismatchException}.</p>
//
// <p><strong>EXTRA TOKEN</strong> (single token deletion)</p>
//
// <p>{@code LA(1)} is not what we are looking for. If {@code LA(2)} has the
// right token, however, then assume {@code LA(1)} is some extra spurious
// token and delete it. Then consume and return the next token (which was
// the {@code LA(2)} token) as the successful result of the match operation.</p>
//
// <p>This recovery strategy is implemented by {@link
// //singleTokenDeletion}.</p>
//
// <p><strong>MISSING TOKEN</strong> (single token insertion)</p>
//
// <p>If current token (at {@code LA(1)}) is consistent with what could come
// after the expected {@code LA(1)} token, then assume the token is missing
// and use the parser's {@link TokenFactory} to create it on the fly. The
// "insertion" is performed by returning the created token as the successful
// result of the match operation.</p>
//
// <p>This recovery strategy is implemented by {@link
// //singleTokenInsertion}.</p>
//
// <p><strong>EXAMPLE</strong></p>
//
// <p>For example, Input {@code i=(3;} is clearly missing the {@code ')'}. When
// the parser returns from the nested call to {@code expr}, it will have
// call chain:</p>
//
// <pre>
// stat &rarr; expr &rarr; atom
// </pre>
//
// and it will be trying to match the {@code ')'} at this point in the
// derivation:
//
// <pre>
// =&gt; ID '=' '(' INT ')' ('+' atom)* ';'
// ^
// </pre>
//
// The attempt to match {@code ')'} will fail when it sees {@code ';'} and
// call {@link //recoverInline}. To recover, it sees that {@code LA(1)==';'}
// is in the set of tokens that can follow the {@code ')'} token reference
// in rule {@code atom}. It can assume that you forgot the {@code ')'}.
//
DefaultErrorStrategy.prototype.recoverInline = function(recognizer) {
    // SINGLE TOKEN DELETION
    var matchedSymbol = this.singleTokenDeletion(recognizer);
    if (matchedSymbol !== null) {
        // we have deleted the extra token.
        // now, move past ttype token as if all were ok
        recognizer.consume();
        return matchedSymbol;
    }
    // SINGLE TOKEN INSERTION
    if (this.singleTokenInsertion(recognizer)) {
        return this.getMissingSymbol(recognizer);
    }
    // even that didn't work; must throw the exception
    throw new InputMismatchException(recognizer);
};

//
// This method implements the single-token insertion inline error recovery
// strategy. It is called by {@link //recoverInline} if the single-token
// deletion strategy fails to recover from the mismatched input. If this
// method returns {@code true}, {@code recognizer} will be in error recovery
// mode.
//
// <p>This method determines whether or not single-token insertion is viable by
// checking if the {@code LA(1)} input symbol could be successfully matched
// if it were instead the {@code LA(2)} symbol. If this method returns
// {@code true}, the caller is responsible for creating and inserting a
// token with the correct type to produce this behavior.</p>
//
// @param recognizer the parser instance
// @return {@code true} if single-token insertion is a viable recovery
// strategy for the current mismatched input, otherwise {@code false}
//
DefaultErrorStrategy.prototype.singleTokenInsertion = function(recognizer) {
    var currentSymbolType = recognizer.getTokenStream().LA(1);
    // if current token is consistent with what could come after current
    // ATN state, then we know we're missing a token; error recovery
    // is free to conjure up and insert the missing token
    var atn = recognizer._interp.atn;
    var currentState = atn.states[recognizer.state];
    var next = currentState.transitions[0].target;
    var expectingAtLL2 = atn.nextTokens(next, recognizer._ctx);
    if (expectingAtLL2.contains(currentSymbolType) ){
        this.reportMissingToken(recognizer);
        return true;
    } else {
        return false;
    }
};

// This method implements the single-token deletion inline error recovery
// strategy. It is called by {@link //recoverInline} to attempt to recover
// from mismatched input. If this method returns null, the parser and error
// handler state will not have changed. If this method returns non-null,
// {@code recognizer} will <em>not</em> be in error recovery mode since the
// returned token was a successful match.
//
// <p>If the single-token deletion is successful, this method calls
// {@link //reportUnwantedToken} to report the error, followed by
// {@link Parser//consume} to actually "delete" the extraneous token. Then,
// before returning {@link //reportMatch} is called to signal a successful
// match.</p>
//
// @param recognizer the parser instance
// @return the successfully matched {@link Token} instance if single-token
// deletion successfully recovers from the mismatched input, otherwise
// {@code null}
//
DefaultErrorStrategy.prototype.singleTokenDeletion = function(recognizer) {
    var nextTokenType = recognizer.getTokenStream().LA(2);
    var expecting = this.getExpectedTokens(recognizer);
    if (expecting.contains(nextTokenType)) {
        this.reportUnwantedToken(recognizer);
        // print("recoverFromMismatchedToken deleting " \
        // + str(recognizer.getTokenStream().LT(1)) \
        // + " since " + str(recognizer.getTokenStream().LT(2)) \
        // + " is what we want", file=sys.stderr)
        recognizer.consume(); // simply delete extra token
        // we want to return the token we're actually matching
        var matchedSymbol = recognizer.getCurrentToken();
        this.reportMatch(recognizer); // we know current token is correct
        return matchedSymbol;
    } else {
        return null;
    }
};

// Conjure up a missing token during error recovery.
//
// The recognizer attempts to recover from single missing
// symbols. But, actions might refer to that missing symbol.
// For example, x=ID {f($x);}. The action clearly assumes
// that there has been an identifier matched previously and that
// $x points at that token. If that token is missing, but
// the next token in the stream is what we want we assume that
// this token is missing and we keep going. Because we
// have to return some token to replace the missing token,
// we have to conjure one up. This method gives the user control
// over the tokens returned for missing tokens. Mostly,
// you will want to create something special for identifier
// tokens. For literals such as '{' and ',', the default
// action in the parser or tree parser works. It simply creates
// a CommonToken of the appropriate type. The text will be the token.
// If you change what tokens must be created by the lexer,
// override this method to create the appropriate tokens.
//
DefaultErrorStrategy.prototype.getMissingSymbol = function(recognizer) {
    var currentSymbol = recognizer.getCurrentToken();
    var expecting = this.getExpectedTokens(recognizer);
    var expectedTokenType = expecting.first(); // get any element
    var tokenText;
    if (expectedTokenType===Token.EOF) {
        tokenText = "<missing EOF>";
    } else {
        tokenText = "<missing " + recognizer.literalNames[expectedTokenType] + ">";
    }
    var current = currentSymbol;
    var lookback = recognizer.getTokenStream().LT(-1);
    if (current.type===Token.EOF && lookback !== null) {
        current = lookback;
    }
    return recognizer.getTokenFactory().create(current.source,
        expectedTokenType, tokenText, Token.DEFAULT_CHANNEL,
        -1, -1, current.line, current.column);
};

DefaultErrorStrategy.prototype.getExpectedTokens = function(recognizer) {
    return recognizer.getExpectedTokens();
};

// How should a token be displayed in an error message? The default
// is to display just the text, but during development you might
// want to have a lot of information spit out. Override in that case
// to use t.toString() (which, for CommonToken, dumps everything about
// the token). This is better than forcing you to override a method in
// your token objects because you don't have to go modify your lexer
// so that it creates a new Java type.
//
DefaultErrorStrategy.prototype.getTokenErrorDisplay = function(t) {
    if (t === null) {
        return "<no token>";
    }
    var s = t.text;
    if (s === null) {
        if (t.type===Token.EOF) {
            s = "<EOF>";
        } else {
            s = "<" + t.type + ">";
        }
    }
    return this.escapeWSAndQuote(s);
};

DefaultErrorStrategy.prototype.escapeWSAndQuote = function(s) {
    s = s.replace(/\n/g,"\\n");
    s = s.replace(/\r/g,"\\r");
    s = s.replace(/\t/g,"\\t");
    return "'" + s + "'";
};

// Compute the error recovery set for the current rule. During
// rule invocation, the parser pushes the set of tokens that can
// follow that rule reference on the stack; this amounts to
// computing FIRST of what follows the rule reference in the
// enclosing rule. See LinearApproximator.FIRST().
// This local follow set only includes tokens
// from within the rule; i.e., the FIRST computation done by
// ANTLR stops at the end of a rule.
//
// EXAMPLE
//
// When you find a "no viable alt exception", the input is not
// consistent with any of the alternatives for rule r. The best
// thing to do is to consume tokens until you see something that
// can legally follow a call to r//or* any rule that called r.
// You don't want the exact set of viable next tokens because the
// input might just be missing a token--you might consume the
// rest of the input looking for one of the missing tokens.
//
// Consider grammar:
//
// a : '[' b ']'
// | '(' b ')'
// ;
// b : c '^' INT ;
// c : ID
// | INT
// ;
//
// At each rule invocation, the set of tokens that could follow
// that rule is pushed on a stack. Here are the various
// context-sensitive follow sets:
//
// FOLLOW(b1_in_a) = FIRST(']') = ']'
// FOLLOW(b2_in_a) = FIRST(')') = ')'
// FOLLOW(c_in_b) = FIRST('^') = '^'
//
// Upon erroneous input "[]", the call chain is
//
// a -> b -> c
//
// and, hence, the follow context stack is:
//
// depth follow set start of rule execution
// 0 <EOF> a (from main())
// 1 ']' b
// 2 '^' c
//
// Notice that ')' is not included, because b would have to have
// been called from a different context in rule a for ')' to be
// included.
//
// For error recovery, we cannot consider FOLLOW(c)
// (context-sensitive or otherwise). We need the combined set of
// all context-sensitive FOLLOW sets--the set of all tokens that
// could follow any reference in the call chain. We need to
// resync to one of those tokens. Note that FOLLOW(c)='^' and if
// we resync'd to that token, we'd consume until EOF. We need to
// sync to context-sensitive FOLLOWs for a, b, and c: {']','^'}.
// In this case, for input "[]", LA(1) is ']' and in the set, so we would
// not consume anything. After printing an error, rule c would
// return normally. Rule b would not find the required '^' though.
// At this point, it gets a mismatched token error and throws an
// exception (since LA(1) is not in the viable following token
// set). The rule exception handler tries to recover, but finds
// the same recovery set and doesn't consume anything. Rule b
// exits normally returning to rule a. Now it finds the ']' (and
// with the successful match exits errorRecovery mode).
//
// So, you can see that the parser walks up the call chain looking
// for the token that was a member of the recovery set.
//
// Errors are not generated in errorRecovery mode.
//
// ANTLR's error recovery mechanism is based upon original ideas:
//
// "Algorithms + Data Structures = Programs" by Niklaus Wirth
//
// and
//
// "A note on error recovery in recursive descent parsers":
// http://portal.acm.org/citation.cfm?id=947902.947905
//
// Later, Josef Grosch had some good ideas:
//
// "Efficient and Comfortable Error Recovery in Recursive Descent
// Parsers":
// ftp://www.cocolab.com/products/cocktail/doca4.ps/ell.ps.zip
//
// Like Grosch I implement context-sensitive FOLLOW sets that are combined
// at run-time upon error to avoid overhead during parsing.
//
DefaultErrorStrategy.prototype.getErrorRecoverySet = function(recognizer) {
    var atn = recognizer._interp.atn;
    var ctx = recognizer._ctx;
    var recoverSet = new IntervalSet();
    while (ctx !== null && ctx.invokingState>=0) {
        // compute what follows who invoked us
        var invokingState = atn.states[ctx.invokingState];
        var rt = invokingState.transitions[0];
        var follow = atn.nextTokens(rt.followState);
        recoverSet.addSet(follow);
        ctx = ctx.parentCtx;
    }
    recoverSet.removeOne(Token.EPSILON);
    return recoverSet;
};

// Consume tokens until one matches the given token set.//
DefaultErrorStrategy.prototype.consumeUntil = function(recognizer, set) {
    var ttype = recognizer.getTokenStream().LA(1);
    while( ttype !== Token.EOF && !set.contains(ttype)) {
        recognizer.consume();
        ttype = recognizer.getTokenStream().LA(1);
    }
};

//
// This implementation of {@link ANTLRErrorStrategy} responds to syntax errors
// by immediately canceling the parse operation with a
// {@link ParseCancellationException}. The implementation ensures that the
// {@link ParserRuleContext//exception} field is set for all parse tree nodes
// that were not completed prior to encountering the error.
//
// <p>
// This error strategy is useful in the following scenarios.</p>
//
// <ul>
// <li><strong>Two-stage parsing:</strong> This error strategy allows the first
// stage of two-stage parsing to immediately terminate if an error is
// encountered, and immediately fall back to the second stage. In addition to
// avoiding wasted work by attempting to recover from errors here, the empty
// implementation of {@link BailErrorStrategy//sync} improves the performance of
// the first stage.</li>
// <li><strong>Silent validation:</strong> When syntax errors are not being
// reported or logged, and the parse result is simply ignored if errors occur,
// the {@link BailErrorStrategy} avoids wasting work on recovering from errors
// when the result will be ignored either way.</li>
// </ul>
//
// <p>
// {@code myparser.setErrorHandler(new BailErrorStrategy());}</p>
//
// @see Parser//setErrorHandler(ANTLRErrorStrategy)
//
function BailErrorStrategy() {
	DefaultErrorStrategy.call(this);
	return this;
}

BailErrorStrategy.prototype = Object.create(DefaultErrorStrategy.prototype);
BailErrorStrategy.prototype.constructor = BailErrorStrategy;

// Instead of recovering from exception {@code e}, re-throw it wrapped
// in a {@link ParseCancellationException} so it is not caught by the
// rule function catches. Use {@link Exception//getCause()} to get the
// original {@link RecognitionException}.
//
BailErrorStrategy.prototype.recover = function(recognizer, e) {
    var context = recognizer._ctx;
    while (context !== null) {
        context.exception = e;
        context = context.parentCtx;
    }
    throw new ParseCancellationException(e);
};

// Make sure we don't attempt to recover inline; if the parser
// successfully recovers, it won't throw an exception.
//
BailErrorStrategy.prototype.recoverInline = function(recognizer) {
    this.recover(recognizer, new InputMismatchException(recognizer));
};

// Make sure we don't attempt to recover from problems in subrules.//
BailErrorStrategy.prototype.sync = function(recognizer) {
    // pass
};

exports.BailErrorStrategy = BailErrorStrategy;
exports.DefaultErrorStrategy = DefaultErrorStrategy;


/***/ }),
/* 247 */
/***/ (function(module, exports, __webpack_require__) {

var BaseType = __webpack_require__(47).BaseType;
var ListType = __webpack_require__(26).ListType;
var TextType = __webpack_require__(6).TextType;
var SyntaxError = __webpack_require__(32).SyntaxError;
var List = __webpack_require__(29).List;

function EnumeratedNativeType(name, derivedFrom) {
	BaseType.call(this, name);
	this.derivedFrom = derivedFrom;
	return this;
}

EnumeratedNativeType.prototype = Object.create(BaseType.prototype);
EnumeratedNativeType.prototype.constructor = EnumeratedNativeType;

EnumeratedNativeType.prototype.checkMember = function(context, section, name) {
	if ("symbols"==name) {
		return new ListType(this);
	} else if ("value"==name) {
		return this.derivedFrom;
	} else if ("name"==name) {
		return TextType.instance;
	} else {
		return BaseType.prototype.checkMember.call(this, context, section, name);
	}
};

EnumeratedNativeType.prototype.declare = function(transpiler) {
    var decl = transpiler.context.getRegisteredDeclaration(this.name);
    transpiler.declare(decl);
    transpiler.require(List);
};


EnumeratedNativeType.prototype.transpile = function(transpiler) {
    transpiler.append(this.name);
};

EnumeratedNativeType.prototype.declareMember = function(transpiler, name) {
    if("symbols"==name || "value"==name || "name"==name) {
        var decl = transpiler.context.getRegisteredDeclaration(this.name);
        transpiler.declare(decl);
    } else
        BaseType.prototype.declareMember.call(this, transpiler, name);
};

EnumeratedNativeType.prototype.transpileMember = function(transpiler, name) {
    if ("symbols"==name || "value"==name || "name"==name) {
        transpiler.append(name);
    } else {
        return BaseType.prototype.transpileMember.call(this, transpiler, name);
    }
};


EnumeratedNativeType.prototype.getMemberValue = function(context, name) {
	var decl = context.getRegisteredDeclaration(this.name);
	if(!decl || !decl.symbols) {
		throw new SyntaxError(name + " is not an enumerated type!");
	}
	if ("symbols"==name) {
		return decl.symbols;
	} else {
		throw new SyntaxError("Unknown member:" + name);
	}
};


EnumeratedNativeType.prototype.isAssignableFrom = function(context, other) {
	return this.id.name === other.id.name;
};

exports.EnumeratedNativeType = EnumeratedNativeType;


/***/ }),
/* 248 */
/***/ (function(module, exports, __webpack_require__) {

var RangeValue = __webpack_require__(141).RangeValue;
var IntegerValue = __webpack_require__(3).IntegerValue;
var IntegerType = null;

exports.resolve =function() {
    IntegerType = __webpack_require__(2).IntegerType;
};

function IntegerRange(left, right) {
	RangeValue.call(this, IntegerType.instance, left, right);
	return this;
}

IntegerRange.prototype = Object.create(RangeValue.prototype);
IntegerRange.prototype.constructor = IntegerRange;

IntegerRange.prototype.size = function() {
	return 1 + this.high.IntegerValue() - this.low.IntegerValue();
};


IntegerRange.prototype.getItem = function(index) {
	var result = this.low.IntegerValue() + index - 1;
	if(result>this.high.IntegerValue()) {
		throw new IndexOutOfBoundsException();
	}
	return new IntegerValue(result);
};

IntegerRange.prototype.newInstance = function(left, right) {
	return new IntegerRange(left, right);
};


exports.IntegerRange = IntegerRange;

/***/ }),
/* 249 */
/***/ (function(module, exports) {

function Score(value, name) {
	this.value = value;
	this.name = name;
	return this;
}

Score.BETTER = new Score(1, "BETTER");
Score.WORSE = new Score(-1, "WORSE");
Score.SIMILAR = new Score(0, "SIMILAR");

exports.Score = Score;


/***/ }),
/* 250 */
/***/ (function(module, exports, __webpack_require__) {

var antlr4 = __webpack_require__(9);
var ELexer = __webpack_require__(360).ELexer;
var Dialect = __webpack_require__(8).Dialect;

function EIndentingLexer(input) {
	ELexer.call(this, input);
	this.tokens = [];
	this.indents = [0];
	this.wasLF = false;
	this.addLF = true;
	this.dialect = Dialect.BOA;
	this.nextLexerToken = this.nextToken;
	this.nextToken = this.indentedNextToken;
	return this;
}

EIndentingLexer.prototype = Object.create(ELexer.prototype);
EIndentingLexer.prototype.constructor = EIndentingLexer;

EIndentingLexer.prototype.indentedNextToken = function() {
	var t = this.getNextToken();
	this.wasLF = t.type===ELexer.LF;
	return t;
};

EIndentingLexer.prototype.getNextToken = function() {
	if(this.tokens.length>0) {
		return this.tokens.shift();
	}
	this.interpret(this.nextLexerToken());
	return this.nextToken();
};

EIndentingLexer.prototype.interpret = function(token) {
	switch(token.type) {
	case ELexer.EOF:
		this.interpretEOF(token);
		break;
	case ELexer.LF_TAB:
		this.interpretLFTAB(token);
		break;			
	default:
		this.interpretAnyToken(token);
	}
};

EIndentingLexer.prototype.interpretEOF = function(eof) {
	// gracefully handle missing dedents
	while(this.indents.length>1) {
		this.tokens.push(this.deriveToken(eof, ELexer.DEDENT));
		this.tokens.push(this.deriveToken(eof, ELexer.LF));
		this.wasLF = true;
		this.indents.pop();
	}
	// gracefully handle missing lf
	if(!this.wasLF && this.addLF) {
		this.tokens.push(this.deriveToken(eof, ELexer.LF));
	}
	this.tokens.push(eof);
};
  
EIndentingLexer.prototype.interpretLFTAB = function(lftab) {
	// count TABs following LF
	var indentCount = this.countIndents(lftab.text);
	var next = this.nextLexerToken();
	// if this was an empty line, simply skip it
	if(next.type===ELexer.EOF || next.type===ELexer.LF_TAB) {
		this.tokens.push(this.deriveToken(lftab, ELexer.LF));
		this.interpret(next);
	} else if(indentCount===this.indents[this.indents.length-1]) {
		this.tokens.push(this.deriveToken(lftab, ELexer.LF));
		this.interpret(next);
	} else if(indentCount>this.indents[this.indents.length-1]) {
		this.tokens.push(this.deriveToken(lftab, ELexer.LF));
		this.tokens.push(this.deriveToken(lftab, ELexer.INDENT));
		this.indents.push(indentCount);
		this.interpret(next);
	} else {
		while(this.indents.length>1 && indentCount<this.indents[this.indents.length-1]) {
			this.tokens.push(this.deriveToken(lftab, ELexer.DEDENT));
			this.tokens.push(this.deriveToken(lftab, ELexer.LF));
			this.indents.pop();
		}
		/*jshint noempty:false*/
		if(indentCount>this.indents[this.indents.length-1]) {
			// TODO, fire an error through token
		}
		this.interpret(next);
		/*jshint noempty:true*/
	}
};

EIndentingLexer.prototype.deriveToken = function(token, type) {
	var res = token.clone();
	res.type = type;
	if(token.type === ELexer.EOF)
		res._text = ""
	return res;
};

EIndentingLexer.prototype.countIndents = function(text) {
	var count = 0;
	for(var i=0;i<text.length;i++) {
		switch(text[i]) {
		case ' ':
			count += 1;
			break;
		case '\t':
			count += 4;
			break;
		}
	}
	return Math.floor(count/4);
};

EIndentingLexer.prototype.interpretAnyToken = function(token) {
	this.tokens.push(token);
};

exports.EIndentingLexer = EIndentingLexer;



/***/ }),
/* 251 */
/***/ (function(module, exports, __webpack_require__) {

// Generated from EParser.g4 by ANTLR 4.7.1
// jshint ignore: start
var antlr4 = __webpack_require__(9);
var EParserListener = __webpack_require__(252).EParserListener;
var AbstractParser = __webpack_require__(185).AbstractParser;

var grammarFileName = "EParser.g4";

var serializedATN = ["\u0003\u608b\ua72a\u8133\ub9ed\u417c\u3be7\u7786\u5964",
    "\u0003\u00b7\u0ad6\u0004\u0002\t\u0002\u0004\u0003\t\u0003\u0004\u0004",
    "\t\u0004\u0004\u0005\t\u0005\u0004\u0006\t\u0006\u0004\u0007\t\u0007",
    "\u0004\b\t\b\u0004\t\t\t\u0004\n\t\n\u0004\u000b\t\u000b\u0004\f\t\f",
    "\u0004\r\t\r\u0004\u000e\t\u000e\u0004\u000f\t\u000f\u0004\u0010\t\u0010",
    "\u0004\u0011\t\u0011\u0004\u0012\t\u0012\u0004\u0013\t\u0013\u0004\u0014",
    "\t\u0014\u0004\u0015\t\u0015\u0004\u0016\t\u0016\u0004\u0017\t\u0017",
    "\u0004\u0018\t\u0018\u0004\u0019\t\u0019\u0004\u001a\t\u001a\u0004\u001b",
    "\t\u001b\u0004\u001c\t\u001c\u0004\u001d\t\u001d\u0004\u001e\t\u001e",
    "\u0004\u001f\t\u001f\u0004 \t \u0004!\t!\u0004\"\t\"\u0004#\t#\u0004",
    "$\t$\u0004%\t%\u0004&\t&\u0004\'\t\'\u0004(\t(\u0004)\t)\u0004*\t*\u0004",
    "+\t+\u0004,\t,\u0004-\t-\u0004.\t.\u0004/\t/\u00040\t0\u00041\t1\u0004",
    "2\t2\u00043\t3\u00044\t4\u00045\t5\u00046\t6\u00047\t7\u00048\t8\u0004",
    "9\t9\u0004:\t:\u0004;\t;\u0004<\t<\u0004=\t=\u0004>\t>\u0004?\t?\u0004",
    "@\t@\u0004A\tA\u0004B\tB\u0004C\tC\u0004D\tD\u0004E\tE\u0004F\tF\u0004",
    "G\tG\u0004H\tH\u0004I\tI\u0004J\tJ\u0004K\tK\u0004L\tL\u0004M\tM\u0004",
    "N\tN\u0004O\tO\u0004P\tP\u0004Q\tQ\u0004R\tR\u0004S\tS\u0004T\tT\u0004",
    "U\tU\u0004V\tV\u0004W\tW\u0004X\tX\u0004Y\tY\u0004Z\tZ\u0004[\t[\u0004",
    "\\\t\\\u0004]\t]\u0004^\t^\u0004_\t_\u0004`\t`\u0004a\ta\u0004b\tb\u0004",
    "c\tc\u0004d\td\u0004e\te\u0004f\tf\u0004g\tg\u0004h\th\u0004i\ti\u0004",
    "j\tj\u0004k\tk\u0004l\tl\u0004m\tm\u0004n\tn\u0004o\to\u0004p\tp\u0004",
    "q\tq\u0004r\tr\u0004s\ts\u0004t\tt\u0004u\tu\u0004v\tv\u0004w\tw\u0004",
    "x\tx\u0004y\ty\u0004z\tz\u0004{\t{\u0004|\t|\u0004}\t}\u0004~\t~\u0004",
    "\u007f\t\u007f\u0004\u0080\t\u0080\u0004\u0081\t\u0081\u0004\u0082\t",
    "\u0082\u0004\u0083\t\u0083\u0004\u0084\t\u0084\u0004\u0085\t\u0085\u0004",
    "\u0086\t\u0086\u0004\u0087\t\u0087\u0004\u0088\t\u0088\u0004\u0089\t",
    "\u0089\u0004\u008a\t\u008a\u0004\u008b\t\u008b\u0004\u008c\t\u008c\u0004",
    "\u008d\t\u008d\u0004\u008e\t\u008e\u0004\u008f\t\u008f\u0004\u0090\t",
    "\u0090\u0004\u0091\t\u0091\u0004\u0092\t\u0092\u0004\u0093\t\u0093\u0004",
    "\u0094\t\u0094\u0004\u0095\t\u0095\u0004\u0096\t\u0096\u0004\u0097\t",
    "\u0097\u0004\u0098\t\u0098\u0004\u0099\t\u0099\u0004\u009a\t\u009a\u0004",
    "\u009b\t\u009b\u0004\u009c\t\u009c\u0004\u009d\t\u009d\u0004\u009e\t",
    "\u009e\u0004\u009f\t\u009f\u0004\u00a0\t\u00a0\u0004\u00a1\t\u00a1\u0004",
    "\u00a2\t\u00a2\u0004\u00a3\t\u00a3\u0004\u00a4\t\u00a4\u0004\u00a5\t",
    "\u00a5\u0004\u00a6\t\u00a6\u0004\u00a7\t\u00a7\u0004\u00a8\t\u00a8\u0004",
    "\u00a9\t\u00a9\u0004\u00aa\t\u00aa\u0004\u00ab\t\u00ab\u0004\u00ac\t",
    "\u00ac\u0004\u00ad\t\u00ad\u0004\u00ae\t\u00ae\u0004\u00af\t\u00af\u0004",
    "\u00b0\t\u00b0\u0004\u00b1\t\u00b1\u0004\u00b2\t\u00b2\u0004\u00b3\t",
    "\u00b3\u0004\u00b4\t\u00b4\u0004\u00b5\t\u00b5\u0004\u00b6\t\u00b6\u0004",
    "\u00b7\t\u00b7\u0004\u00b8\t\u00b8\u0004\u00b9\t\u00b9\u0004\u00ba\t",
    "\u00ba\u0004\u00bb\t\u00bb\u0004\u00bc\t\u00bc\u0004\u00bd\t\u00bd\u0004",
    "\u00be\t\u00be\u0004\u00bf\t\u00bf\u0004\u00c0\t\u00c0\u0004\u00c1\t",
    "\u00c1\u0004\u00c2\t\u00c2\u0004\u00c3\t\u00c3\u0004\u00c4\t\u00c4\u0004",
    "\u00c5\t\u00c5\u0004\u00c6\t\u00c6\u0004\u00c7\t\u00c7\u0004\u00c8\t",
    "\u00c8\u0004\u00c9\t\u00c9\u0004\u00ca\t\u00ca\u0004\u00cb\t\u00cb\u0004",
    "\u00cc\t\u00cc\u0004\u00cd\t\u00cd\u0004\u00ce\t\u00ce\u0004\u00cf\t",
    "\u00cf\u0004\u00d0\t\u00d0\u0004\u00d1\t\u00d1\u0004\u00d2\t\u00d2\u0004",
    "\u00d3\t\u00d3\u0004\u00d4\t\u00d4\u0004\u00d5\t\u00d5\u0004\u00d6\t",
    "\u00d6\u0004\u00d7\t\u00d7\u0004\u00d8\t\u00d8\u0004\u00d9\t\u00d9\u0004",
    "\u00da\t\u00da\u0004\u00db\t\u00db\u0004\u00dc\t\u00dc\u0004\u00dd\t",
    "\u00dd\u0004\u00de\t\u00de\u0004\u00df\t\u00df\u0004\u00e0\t\u00e0\u0004",
    "\u00e1\t\u00e1\u0004\u00e2\t\u00e2\u0004\u00e3\t\u00e3\u0004\u00e4\t",
    "\u00e4\u0004\u00e5\t\u00e5\u0004\u00e6\t\u00e6\u0004\u00e7\t\u00e7\u0004",
    "\u00e8\t\u00e8\u0004\u00e9\t\u00e9\u0004\u00ea\t\u00ea\u0004\u00eb\t",
    "\u00eb\u0004\u00ec\t\u00ec\u0004\u00ed\t\u00ed\u0004\u00ee\t\u00ee\u0004",
    "\u00ef\t\u00ef\u0004\u00f0\t\u00f0\u0004\u00f1\t\u00f1\u0004\u00f2\t",
    "\u00f2\u0004\u00f3\t\u00f3\u0004\u00f4\t\u00f4\u0003\u0002\u0003\u0002",
    "\u0003\u0002\u0003\u0002\u0003\u0002\u0003\u0002\u0005\u0002\u01ef\n",
    "\u0002\u0003\u0002\u0003\u0002\u0003\u0002\u0003\u0002\u0003\u0002\u0005",
    "\u0002\u01f6\n\u0002\u0003\u0002\u0003\u0002\u0003\u0002\u0003\u0002",
    "\u0003\u0002\u0003\u0002\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003",
    "\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003",
    "\u0003\u0003\u0003\u0003\u0003\u0004\u0003\u0004\u0003\u0004\u0003\u0004",
    "\u0003\u0004\u0003\u0004\u0003\u0005\u0003\u0005\u0003\u0005\u0003\u0005",
    "\u0005\u0005\u0214\n\u0005\u0003\u0006\u0003\u0006\u0003\u0006\u0003",
    "\u0006\u0005\u0006\u021a\n\u0006\u0003\u0006\u0003\u0006\u0003\u0006",
    "\u0005\u0006\u021f\n\u0006\u0003\u0006\u0003\u0006\u0003\u0006\u0003",
    "\u0006\u0005\u0006\u0225\n\u0006\u0005\u0006\u0227\n\u0006\u0003\u0006",
    "\u0005\u0006\u022a\n\u0006\u0003\u0007\u0003\u0007\u0003\u0007\u0003",
    "\u0007\u0003\u0007\u0005\u0007\u0231\n\u0007\u0003\u0007\u0003\u0007",
    "\u0003\u0007\u0003\u0007\u0003\u0007\u0003\u0007\u0003\u0007\u0005\u0007",
    "\u023a\n\u0007\u0003\b\u0003\b\u0003\b\u0003\b\u0003\b\u0003\b\u0003",
    "\b\u0003\b\u0003\b\u0003\b\u0003\b\u0003\b\u0003\b\u0003\b\u0003\b\u0003",
    "\b\u0003\b\u0003\b\u0003\b\u0003\t\u0003\t\u0003\t\u0003\t\u0005\t\u0253",
    "\n\t\u0003\t\u0003\t\u0005\t\u0257\n\t\u0003\t\u0003\t\u0003\t\u0003",
    "\t\u0003\t\u0003\t\u0003\t\u0003\t\u0003\t\u0005\t\u0262\n\t\u0003\t",
    "\u0003\t\u0003\t\u0003\t\u0003\t\u0003\t\u0003\t\u0005\t\u026b\n\t\u0003",
    "\n\u0003\n\u0003\n\u0003\n\u0003\n\u0003\n\u0003\n\u0003\n\u0003\n\u0003",
    "\n\u0003\n\u0003\n\u0003\n\u0005\n\u027a\n\n\u0003\n\u0003\n\u0003\n",
    "\u0003\n\u0003\n\u0003\n\u0003\n\u0005\n\u0283\n\n\u0003\u000b\u0003",
    "\u000b\u0003\u000b\u0003\u000b\u0003\u000b\u0005\u000b\u028a\n\u000b",
    "\u0003\f\u0003\f\u0003\f\u0003\f\u0003\f\u0003\f\u0003\f\u0003\f\u0005",
    "\f\u0294\n\f\u0003\f\u0003\f\u0003\f\u0003\f\u0003\f\u0003\f\u0003\r",
    "\u0003\r\u0003\r\u0003\r\u0003\r\u0003\r\u0003\r\u0003\r\u0003\r\u0003",
    "\r\u0003\u000e\u0003\u000e\u0003\u000e\u0003\u000e\u0005\u000e\u02aa",
    "\n\u000e\u0003\u000e\u0003\u000e\u0003\u000e\u0003\u000e\u0003\u000e",
    "\u0003\u000e\u0003\u000e\u0003\u000f\u0003\u000f\u0003\u000f\u0003\u000f",
    "\u0003\u000f\u0003\u000f\u0003\u000f\u0003\u000f\u0003\u000f\u0003\u000f",
    "\u0003\u0010\u0003\u0010\u0003\u0010\u0003\u0010\u0005\u0010\u02c1\n",
    "\u0010\u0003\u0010\u0003\u0010\u0003\u0010\u0003\u0010\u0003\u0010\u0003",
    "\u0010\u0003\u0010\u0003\u0011\u0003\u0011\u0003\u0011\u0003\u0011\u0005",
    "\u0011\u02ce\n\u0011\u0003\u0011\u0003\u0011\u0003\u0011\u0003\u0011",
    "\u0003\u0011\u0003\u0011\u0003\u0011\u0003\u0011\u0003\u0011\u0005\u0011",
    "\u02d9\n\u0011\u0003\u0011\u0003\u0011\u0003\u0011\u0003\u0011\u0003",
    "\u0011\u0003\u0011\u0003\u0011\u0003\u0011\u0003\u0011\u0003\u0011\u0003",
    "\u0011\u0003\u0011\u0005\u0011\u02e7\n\u0011\u0003\u0012\u0003\u0012",
    "\u0003\u0012\u0003\u0012\u0005\u0012\u02ed\n\u0012\u0003\u0012\u0003",
    "\u0012\u0003\u0012\u0003\u0012\u0003\u0012\u0003\u0012\u0003\u0012\u0003",
    "\u0012\u0003\u0012\u0005\u0012\u02f8\n\u0012\u0003\u0012\u0003\u0012",
    "\u0003\u0012\u0003\u0012\u0003\u0012\u0003\u0012\u0003\u0012\u0003\u0012",
    "\u0003\u0012\u0003\u0012\u0003\u0012\u0003\u0012\u0005\u0012\u0306\n",
    "\u0012\u0003\u0013\u0003\u0013\u0003\u0013\u0003\u0013\u0003\u0013\u0003",
    "\u0013\u0003\u0013\u0003\u0013\u0003\u0013\u0003\u0014\u0003\u0014\u0003",
    "\u0014\u0003\u0014\u0003\u0014\u0003\u0014\u0003\u0014\u0007\u0014\u0318",
    "\n\u0014\f\u0014\u000e\u0014\u031b\u000b\u0014\u0003\u0015\u0003\u0015",
    "\u0003\u0015\u0003\u0015\u0003\u0015\u0003\u0015\u0003\u0015\u0003\u0015",
    "\u0005\u0015\u0325\n\u0015\u0005\u0015\u0327\n\u0015\u0003\u0016\u0003",
    "\u0016\u0003\u0016\u0003\u0016\u0003\u0016\u0003\u0016\u0003\u0016\u0005",
    "\u0016\u0330\n\u0016\u0003\u0016\u0003\u0016\u0005\u0016\u0334\n\u0016",
    "\u0003\u0017\u0003\u0017\u0003\u0017\u0003\u0017\u0003\u0017\u0003\u0017",
    "\u0005\u0017\u033c\n\u0017\u0003\u0017\u0003\u0017\u0005\u0017\u0340",
    "\n\u0017\u0003\u0017\u0003\u0017\u0003\u0017\u0003\u0017\u0003\u0017",
    "\u0005\u0017\u0347\n\u0017\u0003\u0017\u0003\u0017\u0003\u0018\u0003",
    "\u0018\u0003\u0018\u0003\u0018\u0005\u0018\u034f\n\u0018\u0003\u0018",
    "\u0003\u0018\u0003\u0018\u0005\u0018\u0354\n\u0018\u0003\u0018\u0003",
    "\u0018\u0005\u0018\u0358\n\u0018\u0003\u0018\u0003\u0018\u0003\u0018",
    "\u0003\u0018\u0003\u0018\u0003\u0018\u0003\u0019\u0003\u0019\u0003\u0019",
    "\u0003\u0019\u0003\u0019\u0003\u0019\u0003\u0019\u0003\u0019\u0003\u0019",
    "\u0003\u0019\u0003\u0019\u0003\u0019\u0003\u0019\u0003\u0019\u0003\u0019",
    "\u0003\u0019\u0003\u0019\u0003\u0019\u0003\u0019\u0005\u0019\u0373\n",
    "\u0019\u0003\u001a\u0003\u001a\u0003\u001b\u0003\u001b\u0003\u001b\u0005",
    "\u001b\u037a\n\u001b\u0003\u001c\u0003\u001c\u0003\u001c\u0005\u001c",
    "\u037f\n\u001c\u0003\u001c\u0003\u001c\u0005\u001c\u0383\n\u001c\u0003",
    "\u001d\u0003\u001d\u0003\u001d\u0003\u001d\u0003\u001d\u0003\u001d\u0003",
    "\u001d\u0003\u001d\u0003\u001d\u0003\u001d\u0003\u001d\u0003\u001d\u0003",
    "\u001d\u0003\u001d\u0003\u001d\u0003\u001d\u0003\u001d\u0003\u001d\u0003",
    "\u001d\u0003\u001d\u0005\u001d\u0399\n\u001d\u0003\u001e\u0003\u001e",
    "\u0003\u001f\u0003\u001f\u0003\u001f\u0003\u001f\u0003\u001f\u0005\u001f",
    "\u03a2\n\u001f\u0003\u001f\u0003\u001f\u0005\u001f\u03a6\n\u001f\u0003",
    "\u001f\u0003\u001f\u0003\u001f\u0003\u001f\u0003\u001f\u0003\u001f\u0005",
    "\u001f\u03ae\n\u001f\u0003 \u0003 \u0005 \u03b2\n \u0003 \u0003 \u0003",
    " \u0005 \u03b7\n \u0003 \u0003 \u0003 \u0003 \u0003 \u0005 \u03be\n",
    " \u0003 \u0005 \u03c1\n \u0003!\u0003!\u0003!\u0003!\u0003!\u0003!\u0003",
    "!\u0003!\u0003!\u0003\"\u0003\"\u0003\"\u0003\"\u0003\"\u0003\"\u0003",
    "\"\u0003\"\u0003\"\u0003#\u0003#\u0003#\u0003#\u0003#\u0003#\u0003#",
    "\u0003#\u0003#\u0003#\u0003#\u0003#\u0003#\u0005#\u03e2\n#\u0003#\u0003",
    "#\u0003$\u0003$\u0003$\u0003$\u0003$\u0003$\u0003$\u0003$\u0003$\u0003",
    "$\u0003$\u0003$\u0003$\u0003$\u0003$\u0005$\u03f5\n$\u0003%\u0003%\u0003",
    "%\u0003%\u0003%\u0005%\u03fc\n%\u0003%\u0003%\u0003%\u0003%\u0003%\u0003",
    "%\u0003%\u0003&\u0003&\u0003&\u0003&\u0003&\u0003&\u0003&\u0003&\u0003",
    "&\u0003\'\u0003\'\u0003\'\u0003\'\u0003\'\u0003\'\u0003\'\u0003(\u0003",
    "(\u0003(\u0003(\u0003(\u0003(\u0003(\u0003(\u0003(\u0005(\u041e\n(\u0003",
    "(\u0003(\u0003(\u0003(\u0003(\u0003(\u0003(\u0005(\u0427\n(\u0003)\u0003",
    ")\u0003)\u0003)\u0003)\u0003)\u0003)\u0003)\u0003)\u0003)\u0003)\u0003",
    ")\u0003)\u0003)\u0003)\u0003)\u0003)\u0003)\u0003)\u0007)\u043c\n)\f",
    ")\u000e)\u043f\u000b)\u0003*\u0003*\u0003*\u0003+\u0003+\u0003+\u0003",
    "+\u0003+\u0003+\u0003+\u0003+\u0003+\u0003+\u0005+\u044e\n+\u0003+\u0003",
    "+\u0003+\u0005+\u0453\n+\u0003+\u0003+\u0003+\u0003+\u0003+\u0003+\u0005",
    "+\u045b\n+\u0003+\u0003+\u0003+\u0003+\u0003+\u0003+\u0003+\u0005+\u0464",
    "\n+\u0003+\u0003+\u0003,\u0003,\u0003,\u0003,\u0003,\u0003,\u0003,\u0003",
    ",\u0003,\u0003,\u0003,\u0003,\u0003,\u0003,\u0003,\u0003,\u0003,\u0003",
    ",\u0003,\u0005,\u047b\n,\u0003-\u0003-\u0003.\u0003.\u0005.\u0481\n",
    ".\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0005/\u048a\n/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0005/\u04a4\n/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003/\u0003",
    "/\u0003/\u0003/\u0003/\u0003/\u0003/\u0007/\u0514\n/\f/\u000e/\u0517",
    "\u000b/\u00030\u00030\u00030\u00030\u00030\u00070\u051e\n0\f0\u000e",
    "0\u0521\u000b0\u00031\u00031\u00031\u00031\u00032\u00032\u00032\u0003",
    "2\u00032\u00033\u00033\u00034\u00034\u00034\u00034\u00034\u00074\u0533",
    "\n4\f4\u000e4\u0536\u000b4\u00035\u00035\u00035\u00035\u00035\u0003",
    "5\u00035\u00035\u00035\u00035\u00035\u00035\u00035\u00055\u0545\n5\u0003",
    "6\u00036\u00036\u00056\u054a\n6\u00037\u00037\u00037\u00037\u00038\u0003",
    "8\u00038\u00038\u00058\u0554\n8\u00038\u00038\u00038\u00058\u0559\n",
    "8\u00058\u055b\n8\u00038\u00038\u00038\u00038\u00058\u0561\n8\u0005",
    "8\u0563\n8\u00058\u0565\n8\u00039\u00039\u00039\u00039\u00039\u0003",
    ":\u0003:\u0003:\u0003:\u0003;\u0003;\u0003;\u0003;\u0003;\u0003;\u0003",
    "<\u0003<\u0003<\u0005<\u0579\n<\u0003<\u0003<\u0003<\u0003<\u0003<\u0005",
    "<\u0580\n<\u0003<\u0003<\u0005<\u0584\n<\u0003<\u0003<\u0003<\u0003",
    "<\u0003<\u0003<\u0003<\u0003<\u0003<\u0005<\u058f\n<\u0003<\u0003<\u0005",
    "<\u0593\n<\u0003<\u0003<\u0003<\u0005<\u0598\n<\u0005<\u059a\n<\u0003",
    "=\u0003=\u0003=\u0005=\u059f\n=\u0003=\u0003=\u0003=\u0003=\u0003=\u0003",
    "=\u0003=\u0003=\u0003=\u0003=\u0003=\u0003=\u0003=\u0005=\u05ae\n=\u0003",
    "=\u0003=\u0005=\u05b2\n=\u0003=\u0003=\u0003=\u0003=\u0003=\u0003=\u0003",
    "=\u0003=\u0003=\u0005=\u05bd\n=\u0003=\u0003=\u0005=\u05c1\n=\u0003",
    "=\u0003=\u0003=\u0005=\u05c6\n=\u0003=\u0003=\u0003=\u0003=\u0003=\u0003",
    "=\u0003=\u0003=\u0005=\u05d0\n=\u0003>\u0003>\u0005>\u05d4\n>\u0003",
    ">\u0003>\u0003>\u0003>\u0003>\u0003>\u0005>\u05dc\n>\u0003?\u0003?\u0003",
    "?\u0003?\u0003?\u0005?\u05e3\n?\u0005?\u05e5\n?\u0003?\u0003?\u0003",
    "?\u0005?\u05ea\n?\u0005?\u05ec\n?\u0003@\u0003@\u0003@\u0003@\u0003",
    "@\u0003@\u0003@\u0007@\u05f5\n@\f@\u000e@\u05f8\u000b@\u0003A\u0003",
    "A\u0003A\u0005A\u05fd\nA\u0003A\u0003A\u0003B\u0003B\u0003B\u0003B\u0003",
    "C\u0003C\u0003C\u0003C\u0003C\u0003C\u0003C\u0003C\u0005C\u060d\nC\u0003",
    "D\u0003D\u0003D\u0003D\u0003E\u0007E\u0614\nE\fE\u000eE\u0617\u000b",
    "E\u0003F\u0006F\u061a\nF\rF\u000eF\u061b\u0003G\u0007G\u061f\nG\fG\u000e",
    "G\u0622\u000bG\u0003H\u0006H\u0625\nH\rH\u000eH\u0626\u0003H\u0003H",
    "\u0003I\u0007I\u062c\nI\fI\u000eI\u062f\u000bI\u0003I\u0003I\u0003J",
    "\u0003J\u0003K\u0005K\u0636\nK\u0003K\u0003K\u0003K\u0003L\u0003L\u0003",
    "L\u0003L\u0007L\u063f\nL\fL\u000eL\u0642\u000bL\u0003M\u0003M\u0003",
    "M\u0007M\u0647\nM\fM\u000eM\u064a\u000bM\u0003M\u0003M\u0003M\u0007",
    "M\u064f\nM\fM\u000eM\u0652\u000bM\u0003M\u0003M\u0003M\u0003M\u0003",
    "M\u0003M\u0005M\u065a\nM\u0003N\u0003N\u0003N\u0003N\u0003N\u0005N\u0661",
    "\nN\u0003O\u0003O\u0003P\u0003P\u0003Q\u0003Q\u0005Q\u0669\nQ\u0003",
    "R\u0003R\u0003R\u0003R\u0007R\u066f\nR\fR\u000eR\u0672\u000bR\u0003",
    "S\u0003S\u0003S\u0003S\u0007S\u0678\nS\fS\u000eS\u067b\u000bS\u0003",
    "T\u0003T\u0003T\u0007T\u0680\nT\fT\u000eT\u0683\u000bT\u0003U\u0003",
    "U\u0003U\u0003U\u0003U\u0003U\u0003U\u0003U\u0003U\u0003U\u0005U\u068f",
    "\nU\u0003V\u0005V\u0692\nV\u0003V\u0003V\u0005V\u0696\nV\u0003V\u0003",
    "V\u0003W\u0005W\u069b\nW\u0003W\u0003W\u0005W\u069f\nW\u0003W\u0003",
    "W\u0003X\u0003X\u0003X\u0007X\u06a6\nX\fX\u000eX\u06a9\u000bX\u0003",
    "Y\u0003Y\u0003Y\u0003Y\u0003Y\u0003Y\u0003Z\u0003Z\u0003Z\u0003Z\u0003",
    "Z\u0003Z\u0003Z\u0003Z\u0003Z\u0003Z\u0003Z\u0003Z\u0005Z\u06bd\nZ\u0003",
    "Z\u0003Z\u0003Z\u0003Z\u0003Z\u0003Z\u0003Z\u0007Z\u06c6\nZ\fZ\u000e",
    "Z\u06c9\u000bZ\u0003[\u0003[\u0005[\u06cd\n[\u0003\\\u0003\\\u0003\\",
    "\u0003\\\u0003\\\u0003\\\u0003\\\u0003\\\u0003\\\u0003\\\u0003\\\u0003",
    "\\\u0003\\\u0003\\\u0003\\\u0003\\\u0005\\\u06df\n\\\u0003]\u0003]\u0003",
    "^\u0005^\u06e4\n^\u0003^\u0003^\u0003_\u0003_\u0003`\u0003`\u0003`\u0005",
    "`\u06ed\n`\u0003a\u0003a\u0005a\u06f1\na\u0003b\u0003b\u0003b\u0007",
    "b\u06f6\nb\fb\u000eb\u06f9\u000bb\u0003c\u0003c\u0005c\u06fd\nc\u0003",
    "d\u0003d\u0005d\u0701\nd\u0003e\u0003e\u0003e\u0003e\u0003f\u0003f\u0003",
    "f\u0003g\u0003g\u0003g\u0005g\u070d\ng\u0003h\u0003h\u0003i\u0003i\u0003",
    "j\u0003