/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.ModuleType;
import prompto.config.IDebugConfiguration;
import prompto.config.IDebugEventAdapterConfiguration;
import prompto.config.IDebugRequestListenerConfiguration;
import prompto.config.IServerConfiguration;
import prompto.debug.DebugRequestClient;
import prompto.debug.HttpDebugRequestClient;
import prompto.debug.HttpServletDebugRequestListenerFactory;
import prompto.debug.IDebugEventListener;
import prompto.debug.OnlyRemoteThread;
import prompto.debug.ProcessDebugger;
import prompto.debug.ResumeReason;
import prompto.debug.SuspendReason;
import prompto.debug.TestDebuggerBase;
import prompto.debug.WebSocketDebugEventAdapterFactory;
import prompto.debug.WebSocketDebugEventListener;
import prompto.debug.WorkerStatus;
import prompto.debug.event.ConnectedDebugEvent;
import prompto.debug.worker.IWorker;
import prompto.intrinsic.PromptoVersion;
import prompto.runtime.ApplicationContext;
import prompto.server.AppServer;
import prompto.server.BaseServerTest;
import prompto.utils.Instance;
import prompto.utils.ManualTests;
import prompto.utils.StreamUtils;

@Category(value={ManualTests.class})
public class TestHttpDebugger
extends TestDebuggerBase
implements IDebugEventListener {
    DebuggingServer server = new DebuggingServer();
    WebSocketDebugEventListener eventListener;
    Instance<String> output = new Instance();
    Instance<String> response = new Instance();
    final Object lock = new Object();

    @Before
    public void before() throws Throwable {
        ProcessDebugger.reset();
        new Thread(() -> {
            try {
                this.server.__before__();
            }
            catch (Throwable t) {
                Assert.fail();
            }
        }).start();
        do {
            Thread.sleep(10L);
        } while (AppServer.getHttpPort() < 0L);
        ApplicationContext.reset();
    }

    @After
    public void after() throws Exception {
        this.eventListener.stopListening();
        this.eventListener = null;
        this.server.__after__();
    }

    protected String readOut() throws IOException {
        String result = (String)this.output.get();
        if (result == null) {
            return "";
        }
        String[] lines = result.split("\n");
        return lines.length > 0 ? lines[lines.length - 1] : "";
    }

    protected void waitWorkerSuspendedOrTerminated() throws Exception {
        WorkerStatus status = this.debugger.getWorkerStatus(this.getDebuggedThread());
        while (status != WorkerStatus.WORKER_SUSPENDED && status != WorkerStatus.WORKER_COMPLETED) {
            Thread.sleep(100L);
            status = this.debugger.getWorkerStatus(this.getDebuggedThread());
        }
    }

    protected void start() throws Exception {
        this.debugger = new HttpDebugRequestClient("localhost", this.server.getPort(), () -> this.server.isAlive());
        this.eventListener = new WebSocketDebugEventListener("localhost", this.server.getPort(), this);
        this.eventListener.startListening();
        this.waitConnected();
        this.callMainMethod();
    }

    protected IWorker getDebuggedThread() {
        return new OnlyRemoteThread();
    }

    private void callMainMethod() throws Exception {
        URL url = new URL("http://localhost:" + this.server.getPort() + "/ws/run/main");
        new Thread(() -> {
            PrintStream oldOut = System.out;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            try (InputStream input = url.openStream();){
                this.response.set((Object)StreamUtils.readString((InputStream)input));
            }
            catch (Exception e) {
                this.response.set((Object)e.getMessage());
            }
            finally {
                this.output.set((Object)bytes.toString());
                System.setOut(oldOut);
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void join() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    protected void setDebuggedResource(String resourceName) throws Exception {
        URL codeResourceURL = this.getResourceAsURL(resourceName);
        ImmutableCodeStore codeResource = new ImmutableCodeStore(null, ModuleType.LIBRARY, codeResourceURL, PromptoVersion.LATEST);
        this.server.getTail().setNext((ICodeStore)codeResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitConnected() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    public void onConnectedEvent(ConnectedDebugEvent event) {
        ((DebugRequestClient)this.debugger).setConnected(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProcessReadyEvent() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void onWorkerStartedEvent(IWorker thread) {
    }

    public void onWorkerSuspendedEvent(IWorker thread, SuspendReason reason) {
    }

    public void onWorkerResumedEvent(IWorker thread, ResumeReason reason) {
    }

    public void onWorkerCompletedEvent(IWorker thread) {
    }

    public void onProcessTerminatedEvent() {
    }

    static class DebuggingServer
    extends BaseServerTest {
        DebuggingServer() {
        }

        @Override
        protected IServerConfiguration getServerConfig() {
            return (IServerConfiguration)super.getServerConfig().withDebugConfiguration(new IDebugConfiguration.Inline().withEventAdapterConfiguration(new IDebugEventAdapterConfiguration.Inline().withFactory(WebSocketDebugEventAdapterFactory.class.getName())).withRequestListenerConfiguration(new IDebugRequestListenerConfiguration.Inline().withFactory(HttpServletDebugRequestListenerFactory.class.getName())));
        }
    }
}

