/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import prompto.code.BaseCodeStore;
import prompto.code.ICodeStore;
import prompto.config.IConfigurationReader;
import prompto.config.IServerConfiguration;
import prompto.config.ServerConfiguration;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.runtime.Mode;
import prompto.runtime.Standalone;
import prompto.server.AppServer;
import prompto.server.BaseWebTest;
import prompto.utils.CmdLineParser;

public abstract class BaseUITest
extends BaseWebTest {
    protected static int HTTP_PORT;
    protected BaseCodeStore tail;

    @BeforeClass
    public static void startAppServer() throws Throwable {
        String[] args = new String[]{"-yamlConfigFile", "configs/test-local.yml"};
        TestServer.main(args);
        HTTP_PORT = (int)AppServer.getHttpPort();
    }

    @AfterClass
    public static void stopAppServer() throws Exception {
        AppServer.stop();
    }

    @Before
    public void __before__() throws Throwable {
        this.tail = this.getCodeStoreTail();
    }

    @After
    public void __after__() throws Exception {
        if (this.tail != null) {
            this.tail.setNext(null);
        }
    }

    private BaseCodeStore getCodeStoreTail() {
        ICodeStore store = ICodeStore.getInstance();
        while (store instanceof BaseCodeStore) {
            ICodeStore next = ((BaseCodeStore)store).getNext();
            if (next == null) {
                return (BaseCodeStore)store;
            }
            store = next;
        }
        return null;
    }

    static abstract class TestServer {
        TestServer() {
        }

        public static void main(String[] args) throws Throwable {
            IServerConfiguration config = TestServer.loadConfiguration(args);
            config = (IServerConfiguration)config.withApplicationName("test").withApplicationVersion(PromptoVersion.parse((String)"1.0.0")).withRuntimeMode(Mode.UNITTEST);
            AppServer.main((IServerConfiguration)config, null, null, null, null);
        }

        public static IServerConfiguration loadConfiguration(String[] args) throws Exception {
            Map argsMap = CmdLineParser.read((String[])args);
            IConfigurationReader reader = Standalone.readerFromArgs((Map)argsMap);
            ServerConfiguration config = new ServerConfiguration(reader, argsMap);
            return (IServerConfiguration)config.withRuntimeLibs(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class}));
        }
    }
}

