/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.config.HttpConfiguration;
import prompto.config.IKeyStoreConfiguration;
import prompto.config.IKeyStoreFactoryConfiguration;
import prompto.config.ISecretKeyConfiguration;
import prompto.config.TempDirectories;
import prompto.config.YamlConfigurationReader;
import prompto.config.auth.IAuthenticationConfiguration;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;
import prompto.runtime.Mode;
import prompto.security.IKeyStoreFactory;
import prompto.security.auth.source.IAuthenticationSource;
import prompto.security.auth.source.IAuthenticationSourceFactory;

public class TestConfig {
    @Before
    public final void __before__() throws IOException {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
    }

    @Test
    public void testFullYamlConfig() throws IOException {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("configs/test-config.yml");){
            Assert.assertNotNull((Object)input);
            YamlConfigurationReader reader = new YamlConfigurationReader(input);
            HttpConfiguration httpConfig = new HttpConfiguration(reader.getObject("http"));
            Assert.assertEquals((Object)"https", (Object)httpConfig.getProtocol());
            Assert.assertEquals((long)443L, (long)httpConfig.getPort());
            Assert.assertEquals((Object)"somewhere", (Object)httpConfig.getAllowedOrigins());
            IKeyStoreConfiguration keyStoreConfig = httpConfig.getKeyStoreConfiguration();
            this.checkKeyStoreConfiguration(keyStoreConfig);
            keyStoreConfig = httpConfig.getTrustStoreConfiguration();
            this.checkKeyStoreConfiguration(keyStoreConfig);
            IAuthenticationConfiguration authConfig = httpConfig.getAuthenticationConfiguration();
            IAuthenticationSourceConfiguration sourceConfig = authConfig.getAuthenticationSourceConfiguration();
            IAuthenticationSourceFactory factory = sourceConfig.getAuthenticationSourceFactory();
            IAuthenticationSource source = factory.newAuthenticationSource();
            Assert.assertNotNull((Object)source);
        }
    }

    private void checkKeyStoreConfiguration(IKeyStoreConfiguration ksc) {
        Assert.assertNotNull((Object)ksc);
        SslContextFactory ssl = new SslContextFactory();
        IKeyStoreFactoryConfiguration ksfc = ksc.getKeyStoreFactoryConfiguration();
        Assert.assertNotNull((Object)ksfc);
        IKeyStoreFactory ksf = ksfc.getKeyStoreFactory();
        Assert.assertNotNull((Object)ksf);
        ssl.setKeyStore(ksf.newInstance(ksfc));
        ISecretKeyConfiguration skf = ksc.getSecretKeyConfiguration();
        Assert.assertNotNull((Object)skf);
        char[] secretKey = skf.getSecret();
        ssl.setKeyStorePassword(new String(secretKey));
    }
}

