/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.config.IHttpConfiguration;
import prompto.config.IServerConfiguration;
import prompto.config.TempDirectories;
import prompto.declaration.DeclarationList;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.parser.ECleverParser;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.runtime.Mode;
import prompto.server.AppServer;
import prompto.server.JettyServer;
import prompto.utils.Instance;
import prompto.utils.Out;
import prompto.utils.SocketUtils;

public class TestCustomHandler {
    @Before
    public void before() throws IOException {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
    }

    @Test
    public void testParseAndCheck() throws Throwable {
        int port = SocketUtils.findAvailablePortInRange((int)8000, (int)9000);
        IServerConfiguration config = this.newServerConfiguration(port);
        AppServer.initialize((IServerConfiguration)config);
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("prompto/customHandler.pec");){
            ECleverParser parser = new ECleverParser(input);
            DeclarationList decls = parser.parse_declaration_list();
            Context context = ApplicationContext.get();
            decls.register(context);
            decls.check(context);
        }
    }

    private IServerConfiguration newServerConfiguration(int port) {
        return (IServerConfiguration)new IServerConfiguration.Inline().withHttpConfiguration(new IHttpConfiguration.Inline().withProtocol("http").withPort(port)).withRuntimeLibs(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class})).withApplicationName("test").withApplicationVersion(PromptoVersion.parse((String)"1.0.0")).withRuntimeMode(Mode.UNITTEST);
    }

    @Test
    public void testInterpret_GET() throws Throwable {
        Instance result = new Instance();
        this.testInterpret(port -> {
            URL url = new URL("http://localhost:" + port + "/ec2/stuff?data=abc&doto=i-efg");
            try (InputStream data = url.openStream();){
                InputStreamReader reader = new InputStreamReader(data);
                BufferedReader buffered = new BufferedReader(reader);
                result.set((Object)buffered.readLine());
            }
        });
        Assert.assertTrue((boolean)((String)result.get()).startsWith("received!"));
        String out = Out.read();
        Assert.assertTrue((boolean)out.contains("abc"));
        Assert.assertTrue((boolean)out.contains("i-efg"));
    }

    @Test
    public void testInterpret_POST_JSON() throws Throwable {
        this.testInterpret(port -> {
            URL url = new URL("http://localhost:" + port + "/git/stuff");
            HttpURLConnection cnx = (HttpURLConnection)url.openConnection();
            cnx.setRequestMethod("POST");
            cnx.setDoInput(true);
            cnx.setDoOutput(true);
            cnx.addRequestProperty("Accept", "application/json");
            cnx.addRequestProperty("Content-type", "application/json");
            byte[] bytes = "{\"data\":123}".getBytes();
            cnx.addRequestProperty("Content-Length", String.valueOf(bytes.length));
            try (OutputStream output = cnx.getOutputStream();){
                output.write(bytes);
            }
            InputStream data = cnx.getInputStream();
            var5_5 = null;
            if (data != null) {
                if (var5_5 != null) {
                    try {
                        data.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    data.close();
                }
            }
        });
        Assert.assertTrue((boolean)Out.read().endsWith("received!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterpret(Consumer<Integer> consumer) throws Throwable {
        Out.init();
        try {
            int port = SocketUtils.findAvailablePortInRange((int)8000, (int)9000);
            IServerConfiguration config = this.newServerConfiguration(port).withServerAboutToStartMethod("serverAboutToStart").withUseConsole(true);
            AppServer.initialize((IServerConfiguration)config);
            try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("prompto/customHandler.pec");){
                ECleverParser parser = new ECleverParser(input);
                DeclarationList decls = parser.parse_declaration_list();
                Context context = ApplicationContext.get();
                decls.register(context);
            }
            AppServer.startServer((IServerConfiguration)config, this::prepareHandlers, null, null, null);
            consumer.accept(port);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            Out.restore();
            AppServer.stop();
        }
    }

    void prepareHandlers(JettyServer server, HandlerList list) {
        try {
            list.addHandler((Handler)server.newWebSiteHandler());
            list.addHandler((Handler)server.newWebApiHandler());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface Consumer<T> {
        public void accept(T var1) throws Exception;
    }
}

