/*
 * Decompiled with CFR 0.152.
 */
package prompto.config.auth;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlElement;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import com.esotericsoftware.yamlbeans.document.YamlSequence;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.config.IConfigurationReader;
import prompto.config.auth.IAuthenticationConfiguration;
import prompto.config.auth.method.AuthenticationMethodConfiguration;
import prompto.config.auth.method.IAuthenticationMethodConfiguration;
import prompto.config.auth.source.AuthenticationSourceConfiguration;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;
import prompto.security.auth.method.BasicAuthenticationMethodFactory;
import prompto.security.auth.source.IAuthenticationSourceFactory;

public class AuthenticationConfiguration
extends IAuthenticationConfiguration.Inline {
    IConfigurationReader reader;

    public AuthenticationConfiguration(IConfigurationReader reader) {
        this.reader = reader;
        this.authenticationSourceConfiguration = () -> this.readAuthenticationSourceConfiguration();
        this.authenticationMethodConfiguration = () -> this.readAuthenticationMethodConfiguration();
        this.whiteList = () -> this.readWhiteList();
    }

    private Collection<String> readWhiteList() {
        Collection list = this.reader.getArray("whiteList");
        if (list == null) {
            return DEFAULT_WHITE_LIST;
        }
        boolean useDefaultWhiteList = this.reader.getBooleanOrDefault("useDefaultWhiteList", true);
        if (useDefaultWhiteList) {
            return Stream.concat(list.stream(), DEFAULT_WHITE_LIST.stream()).collect(Collectors.toList());
        }
        return list;
    }

    private IAuthenticationSourceConfiguration readAuthenticationSourceConfiguration() {
        IConfigurationReader child = this.reader.getObject("source");
        return child == null ? null : this.readAuthenticationSourceConfiguration(child);
    }

    private IAuthenticationSourceConfiguration readAuthenticationSourceConfiguration(IConfigurationReader reader) {
        String className = reader.getString("factory");
        if (className == null) {
            return new AuthenticationSourceConfiguration(reader);
        }
        try {
            return IAuthenticationSourceFactory.newFactory(className).newConfiguration(reader);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private IAuthenticationMethodConfiguration readAuthenticationMethodConfiguration() {
        IConfigurationReader child = this.reader.getObject("method");
        if (child == null) {
            return () -> new BasicAuthenticationMethodFactory();
        }
        return new AuthenticationMethodConfiguration(child);
    }

    @Override
    public YamlMapping toYaml() throws YamlException {
        Collection whiteList;
        IAuthenticationMethodConfiguration method;
        YamlMapping yaml = new YamlMapping();
        IAuthenticationSourceConfiguration source = (IAuthenticationSourceConfiguration)this.authenticationSourceConfiguration.get();
        if (source != null) {
            yaml.setEntry("source", (YamlElement)source.getAuthenticationSourceFactory().toYaml());
        }
        if ((method = (IAuthenticationMethodConfiguration)this.authenticationMethodConfiguration.get()) != null) {
            yaml.setEntry("method", (YamlElement)method.getAuthenticationMethodFactory().toYaml());
        }
        if ((whiteList = this.reader.getArray("whiteList")) != null) {
            YamlSequence sequence = new YamlSequence();
            for (String entry : whiteList) {
                sequence.addElement(entry);
            }
            yaml.setEntry("whiteList", (YamlElement)sequence);
        }
        return yaml;
    }
}

