/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;
import prompto.debug.DebugEventAdapterBase;
import prompto.debug.DebugEventServlet;
import prompto.debug.Serializer;
import prompto.debug.ack.Acknowledged;
import prompto.debug.ack.IAcknowledgement;
import prompto.debug.event.ConnectedDebugEvent;
import prompto.debug.event.IDebugEvent;
import prompto.server.AppServer;
import prompto.utils.Logger;

public class WebSocketDebugEventAdapter
extends DebugEventAdapterBase {
    static Logger logger = new Logger();
    Session session;

    public synchronized Session getSession() {
        return this.session;
    }

    public synchronized void setSession(Session session) {
        this.session = session;
        ((Object)((Object)this)).notify();
    }

    public synchronized void waitSession() {
        logger.info(() -> "Waiting for debugger client to connect...");
        while (this.session == null) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info(() -> "Debugger client connected.");
    }

    public void onConnectedEvent(ConnectedDebugEvent event) {
        logger.debug(() -> "Skipping " + event.getClass().getName());
    }

    protected IAcknowledgement send(IDebugEvent event) {
        logger.debug(() -> "Sending " + event.getClass().getName());
        Session session = this.getSession();
        if (session != null) {
            try {
                String message = Serializer.writeMessage((Object)event);
                Future action = session.getRemote().sendStringByFuture(message);
                action.get(5L, TimeUnit.SECONDS);
                return new Acknowledged();
            }
            catch (Throwable t) {
                logger.error(() -> "While sending: " + event, t);
            }
        } else {
            logger.error(() -> "No session for sending: " + event);
        }
        return null;
    }

    public void wire() {
        DebugEventServlet servlet = AppServer.getDebugEventServlet();
        if (servlet != null) {
            servlet.setAdapter(this);
        }
    }
}

