/*
 * Decompiled with CFR 0.152.
 */
package prompto.graphql;

import graphql.Scalars;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoDateTime;
import prompto.intrinsic.PromptoPeriod;
import prompto.intrinsic.PromptoTime;
import prompto.type.BooleanType;
import prompto.type.DateTimeType;
import prompto.type.DateType;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.ImageType;
import prompto.type.IntegerType;
import prompto.type.PeriodType;
import prompto.type.TextType;
import prompto.type.TimeType;
import prompto.type.UuidType;
import prompto.value.DateTimeValue;
import prompto.value.DateValue;
import prompto.value.ImageValue;
import prompto.value.PeriodValue;
import prompto.value.TimeValue;
import prompto.value.UuidValue;

public abstract class GraphQLScalars {
    static final Map<IType, GraphQLScalarType> ALL = GraphQLScalars.buildAll();

    static Map<IType, GraphQLScalarType> buildAll() {
        return Arrays.asList(new AbstractMap.SimpleEntry<BooleanType, GraphQLScalarType>(BooleanType.instance(), Scalars.GraphQLBoolean), new AbstractMap.SimpleEntry<IntegerType, GraphQLScalarType>(IntegerType.instance(), Scalars.GraphQLLong), new AbstractMap.SimpleEntry<DecimalType, GraphQLScalarType>(DecimalType.instance(), Scalars.GraphQLFloat), new AbstractMap.SimpleEntry<TextType, GraphQLScalarType>(TextType.instance(), Scalars.GraphQLString), new AbstractMap.SimpleEntry<DateType, GraphQLScalarType>(DateType.instance(), GraphQLScalars.dateScalar()), new AbstractMap.SimpleEntry<TimeType, GraphQLScalarType>(TimeType.instance(), GraphQLScalars.timeScalar()), new AbstractMap.SimpleEntry<DateTimeType, GraphQLScalarType>(DateTimeType.instance(), GraphQLScalars.dateTimeScalar()), new AbstractMap.SimpleEntry<PeriodType, GraphQLScalarType>(PeriodType.instance(), GraphQLScalars.periodScalar()), new AbstractMap.SimpleEntry<ImageType, GraphQLScalarType>(ImageType.instance(), GraphQLScalars.imageScalar()), new AbstractMap.SimpleEntry<UuidType, GraphQLScalarType>(UuidType.instance(), GraphQLScalars.uuidScalar())).stream().collect(Collectors.toMap(e -> (IType)e.getKey(), e -> (GraphQLScalarType)e.getValue()));
    }

    private static GraphQLScalarType imageScalar() {
        return GraphQLScalarType.newScalar().name(ImageType.instance().getTypeName()).coercing((Coercing)new Coercing<ImageValue, String>(){

            public String serialize(Object value) throws CoercingSerializeException {
                if (value instanceof ImageValue) {
                    return ((ImageValue)value).getSourceUrl();
                }
                return null;
            }

            public ImageValue parseValue(Object input) throws CoercingParseValueException {
                return null;
            }

            public ImageValue parseLiteral(Object input) throws CoercingParseLiteralException {
                return null;
            }
        }).build();
    }

    private static GraphQLScalarType uuidScalar() {
        return GraphQLScalarType.newScalar().name(UuidType.instance().getTypeName()).coercing((Coercing)new Coercing<UuidValue, String>(){

            public String serialize(Object value) throws CoercingSerializeException {
                if (value instanceof UuidValue) {
                    return value.toString();
                }
                return null;
            }

            public UuidValue parseValue(Object input) throws CoercingParseValueException {
                return new UuidValue(UUID.fromString(String.valueOf(input)));
            }

            public UuidValue parseLiteral(Object input) throws CoercingParseLiteralException {
                return new UuidValue(UUID.fromString(String.valueOf(input)));
            }
        }).build();
    }

    private static GraphQLScalarType periodScalar() {
        return GraphQLScalarType.newScalar().name(PeriodType.instance().getTypeName()).coercing((Coercing)new Coercing<PeriodValue, String>(){

            public String serialize(Object value) throws CoercingSerializeException {
                if (value instanceof PeriodValue) {
                    return value.toString();
                }
                return null;
            }

            public PeriodValue parseValue(Object input) throws CoercingParseValueException {
                return new PeriodValue(PromptoPeriod.parse((String)String.valueOf(input)));
            }

            public PeriodValue parseLiteral(Object input) throws CoercingParseLiteralException {
                return new PeriodValue(PromptoPeriod.parse((String)String.valueOf(input)));
            }
        }).build();
    }

    private static GraphQLScalarType dateTimeScalar() {
        return GraphQLScalarType.newScalar().name(DateTimeType.instance().getTypeName()).coercing((Coercing)new Coercing<DateTimeValue, String>(){

            public String serialize(Object value) throws CoercingSerializeException {
                if (value instanceof DateTimeValue) {
                    return value.toString();
                }
                return null;
            }

            public DateTimeValue parseValue(Object input) throws CoercingParseValueException {
                return new DateTimeValue(PromptoDateTime.parse((String)String.valueOf(input)));
            }

            public DateTimeValue parseLiteral(Object input) throws CoercingParseLiteralException {
                return new DateTimeValue(PromptoDateTime.parse((String)String.valueOf(input)));
            }
        }).build();
    }

    private static GraphQLScalarType timeScalar() {
        return GraphQLScalarType.newScalar().name(TimeType.instance().getTypeName()).coercing((Coercing)new Coercing<TimeValue, String>(){

            public String serialize(Object value) throws CoercingSerializeException {
                if (value instanceof TimeValue) {
                    return value.toString();
                }
                return null;
            }

            public TimeValue parseValue(Object input) throws CoercingParseValueException {
                return new TimeValue(PromptoTime.parse((String)String.valueOf(input)));
            }

            public TimeValue parseLiteral(Object input) throws CoercingParseLiteralException {
                return new TimeValue(PromptoTime.parse((String)String.valueOf(input)));
            }
        }).build();
    }

    private static GraphQLScalarType dateScalar() {
        return GraphQLScalarType.newScalar().name(DateType.instance().getTypeName()).coercing((Coercing)new Coercing<DateValue, String>(){

            public String serialize(Object value) throws CoercingSerializeException {
                if (value instanceof DateValue) {
                    return value.toString();
                }
                return null;
            }

            public DateValue parseValue(Object input) throws CoercingParseValueException {
                return new DateValue(PromptoDate.parse((String)String.valueOf(input)));
            }

            public DateValue parseLiteral(Object input) throws CoercingParseLiteralException {
                return new DateValue(PromptoDate.parse((String)String.valueOf(input)));
            }
        }).build();
    }

    public static boolean isScalar(IType type) {
        return ALL.containsKey(type);
    }

    public static GraphQLScalarType get(IType type) {
        return ALL.get(type);
    }
}

