/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import prompto.server.ConstraintSecurityHandler;
import prompto.utils.Logger;

final class ConstraintSecurityHandlerWithXAuthorization
extends ConstraintSecurityHandler {
    static final Logger logger = new Logger();

    ConstraintSecurityHandlerWithXAuthorization() {
    }

    protected boolean checkSecurity(Request request) {
        boolean test = super.checkSecurity(request) && !"OPTIONS".equals(request.getMethod());
        logger.debug(() -> "ConstraintSecurityHandler, checking security: " + String.valueOf(test));
        return test;
    }

    public void handle(String pathInContext, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        logger.debug(() -> "ConstraintSecurityHandler: " + request.toString());
        logger.debug(() -> "Origin: " + request.getHeader("Origin"));
        logger.debug(() -> "Authorization: " + request.getHeader("Authorization"));
        logger.debug(() -> "X-Authorization: " + request.getHeader("X-Authorization"));
        super.handle(pathInContext, baseRequest, request, response);
    }
}

