/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import prompto.debug.ProcessDebugger;
import prompto.declaration.IMethodDeclaration;
import prompto.expression.IExpression;
import prompto.expression.MethodSelector;
import prompto.expression.ValueExpression;
import prompto.grammar.ArgumentList;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoDocument;
import prompto.reader.JSONReader;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Context;
import prompto.runtime.Interpreter;
import prompto.runtime.Standalone;
import prompto.runtime.VoidResult;
import prompto.server.CleverServlet;
import prompto.statement.MethodCall;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.type.TextType;
import prompto.utils.Logger;
import prompto.value.BinaryValue;
import prompto.value.DocumentValue;
import prompto.value.IValue;
import prompto.value.ListValue;
import prompto.value.TextValue;
import prompto.value.TupleValue;

public class UserServlet
extends CleverServlet {
    static final Logger logger = new Logger();
    IMethodDeclaration method;

    public UserServlet(IMethodDeclaration method) {
        this.method = method;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setMultipartConfig(new MultipartConfigElement(System.getProperty("java.io.tmpdir")));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            Thread.currentThread().setName(((Object)((Object)this)).getClass().getSimpleName());
            logger.info(() -> "Processing GET " + req.getRequestURI());
            Context local = this.getWorkerContext();
            DocumentValue document = this.paramsToDocument(local, req.getParameterMap());
            IValue value = this.interpret(local, document);
            if (value != null) {
                this.sendValue(req, resp, value);
            }
        }
        catch (Throwable t) {
            logger.error(() -> "While processing GET " + req.getRequestURI(), t);
            resp.setStatus(500);
        }
    }

    private Context getWorkerContext() {
        Context context = ApplicationContext.get().newLocalContext();
        ProcessDebugger processDebugger = ProcessDebugger.getInstance();
        if (processDebugger != null) {
            Standalone.startWorkerDebugger((Thread)Thread.currentThread(), (Context)context);
        }
        return context;
    }

    private IValue interpret(Context context, DocumentValue document) {
        ValueExpression args = new ValueExpression((IType)DocumentType.instance(), (IValue)document);
        ArgumentList arguments = Interpreter.buildArguments((IMethodDeclaration)this.method, (IExpression)args);
        MethodCall call = new MethodCall(new MethodSelector(this.method.getId()), arguments);
        return call.interpret(context);
    }

    private DocumentValue paramsToDocument(Context context, Map<String, String[]> params) {
        DocumentValue document = new DocumentValue();
        params.forEach((n, l) -> {
            TextValue name = new TextValue(n);
            if (((String[])l).length == 1) {
                document.setItem(context, (IValue)name, (IValue)new TextValue(l[0]));
            } else {
                ListValue list = new ListValue((IType)TextType.instance());
                for (String value : l) {
                    list.addItem((IValue)new TextValue(value));
                }
                document.setItem(context, (IValue)name, (IValue)list);
            }
        });
        return document;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            logger.info(() -> "Processing POST " + req.getRequestURI());
            IValue value = null;
            String contentType = req.getContentType();
            if (contentType == null) {
                contentType = "application/x-www-form-urlencoded";
            }
            if (contentType.startsWith("application/json")) {
                value = this.doPostJson(req, resp);
            } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
                value = this.doPostUrlEncoded(req, resp);
            } else if (contentType.startsWith("multipart/form-data")) {
                value = this.doPostMultipart(req, resp);
            } else {
                resp.sendError(415);
            }
            if (value != null) {
                this.sendValue(req, resp, value);
            }
        }
        catch (Throwable t) {
            logger.error(() -> "While processing POST " + req.getRequestURI(), t);
            resp.setStatus(500);
        }
    }

    private void sendValue(HttpServletRequest req, HttpServletResponse resp, IValue value) throws IOException {
        TupleValue tuple;
        if (value == null || value == VoidResult.instance()) {
            return;
        }
        if (value instanceof TextValue) {
            resp.setContentType("text/plain");
            resp.getWriter().write(((TextValue)value).getStorableData());
            return;
        }
        if (value instanceof BinaryValue) {
            PromptoBinary binary = ((BinaryValue)value).getData();
            resp.setContentType(binary.getMimeType());
            resp.getOutputStream().write(binary.getBytes());
            return;
        }
        if (value instanceof TupleValue && (tuple = (TupleValue)value).getLength() >= 2L) {
            IValue content = tuple.getItem(0);
            IValue mimeType = tuple.getItem(1);
            if (content.getType() == TextType.instance() && mimeType.getType() == TextType.instance()) {
                resp.setContentType(((TextValue)mimeType).getStorableData());
                resp.getWriter().write(((TextValue)content).getStorableData());
                return;
            }
        }
        resp.getWriter().write("Unsupported result: " + value.getType().getTypeName());
    }

    private IValue doPostMultipart(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        Map<String, Object> parts = this.readPartsAsObjects(req);
        PromptoDocument document = new PromptoDocument(parts);
        Context context = this.getWorkerContext();
        DocumentValue documentValue = new DocumentValue(context, document, true);
        return this.interpret(context, documentValue);
    }

    private IValue doPostUrlEncoded(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Context context = this.getWorkerContext();
        DocumentValue document = this.paramsToDocument(context, req.getParameterMap());
        return this.interpret(context, document);
    }

    private IValue doPostJson(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Object object = JSONReader.read((InputStream)req.getInputStream());
        if (object instanceof PromptoDocument) {
            Context context = this.getWorkerContext();
            DocumentValue document = new DocumentValue(context, (PromptoDocument)object, true);
            return this.interpret(context, document);
        }
        resp.sendError(415);
        return null;
    }
}

