/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import prompto.server.ResourceServlet;

public class WebSiteServlet
extends ResourceServlet {
    Resource base;

    public WebSiteServlet(String root, String welcomePage) throws IOException {
        super(welcomePage, "sitemap.xml");
        this.base = this.getResourceBase(root);
    }

    private Resource getResourceBase(String webSite) throws IOException {
        File file = new File(webSite);
        logger.info(() -> "Serving web site at: " + file.getAbsolutePath());
        if (!file.exists()) {
            throw new FileNotFoundException(webSite);
        }
        return Resource.newResource((File)file.getCanonicalFile());
    }

    @Override
    protected Resource getResource(HttpServletRequest request, String path) {
        String realPath = URIUtil.canonicalPath((String)path);
        try {
            Resource resource = this.base.addPath(realPath);
            if (resource != null && resource.exists()) {
                return resource;
            }
            return null;
        }
        catch (Throwable t) {
            logger.error(() -> "While looking for resource: " + realPath, t);
            return null;
        }
    }
}

