/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.util.function.Supplier;
import prompto.config.IHttpConfiguration;
import prompto.config.IRuntimeConfiguration;

public interface IServerConfiguration
extends IRuntimeConfiguration {
    public IHttpConfiguration getHttpConfiguration();

    public String getServerAboutToStartMethod();

    public String getWebSiteRoot();

    public boolean useConsole();

    public <T extends IServerConfiguration> T withServerAboutToStartMethod(String var1);

    public <T extends IServerConfiguration> T withHttpConfiguration(IHttpConfiguration var1);

    public <T extends IServerConfiguration> T withUseConsole(boolean var1);

    public static class Inline
    extends IRuntimeConfiguration.Inline
    implements IServerConfiguration {
        Supplier<IHttpConfiguration> httpConfiguration = () -> null;
        Supplier<String> serverAboutToStartMethod = () -> null;
        Supplier<String> webSiteRoot = () -> null;
        Supplier<Boolean> useConsole = () -> false;

        @Override
        public IHttpConfiguration getHttpConfiguration() {
            return this.httpConfiguration.get();
        }

        @Override
        public String getServerAboutToStartMethod() {
            return this.serverAboutToStartMethod.get();
        }

        @Override
        public String getWebSiteRoot() {
            return this.webSiteRoot.get();
        }

        @Override
        public boolean useConsole() {
            return this.useConsole.get();
        }

        @Override
        public <T extends IServerConfiguration> T withServerAboutToStartMethod(String method) {
            this.serverAboutToStartMethod = () -> method;
            return (T)this;
        }

        @Override
        public <T extends IServerConfiguration> T withHttpConfiguration(IHttpConfiguration config) {
            this.httpConfiguration = () -> config;
            return (T)this;
        }

        @Override
        public <T extends IServerConfiguration> T withUseConsole(boolean set) {
            this.useConsole = () -> set;
            return (T)this;
        }
    }
}

