/*
 * Decompiled with CFR 0.152.
 */
package prompto.config.auth;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import prompto.config.auth.method.IAuthenticationMethodConfiguration;
import prompto.config.auth.source.IAuthenticationSourceConfiguration;

public interface IAuthenticationConfiguration {
    public static final Collection<String> DEFAULT_WHITE_LIST = Arrays.asList("jpg", "jpeg", "ico", "png", "tif", "tiff", "js", "jsx", "css", "svg", "gif").stream().map(s -> "*." + s).collect(Collectors.toList());

    public IAuthenticationMethodConfiguration getAuthenticationMethodConfiguration();

    public IAuthenticationSourceConfiguration getAuthenticationSourceConfiguration();

    public Collection<String> getWhiteList();

    public IAuthenticationConfiguration withAuthenticationMethodConfiguration(IAuthenticationMethodConfiguration var1);

    public IAuthenticationConfiguration withAuthenticationSourceConfiguration(IAuthenticationSourceConfiguration var1);

    public IAuthenticationConfiguration withWhiteList(Collection<String> var1);

    public YamlMapping toYaml() throws YamlException;

    public static class Inline
    implements IAuthenticationConfiguration {
        Supplier<IAuthenticationMethodConfiguration> authenticationMethodConfiguration = () -> null;
        Supplier<IAuthenticationSourceConfiguration> authenticationSourceConfiguration = () -> null;
        Supplier<Collection<String>> whiteList = () -> DEFAULT_WHITE_LIST;

        @Override
        public IAuthenticationMethodConfiguration getAuthenticationMethodConfiguration() {
            return this.authenticationMethodConfiguration.get();
        }

        @Override
        public IAuthenticationSourceConfiguration getAuthenticationSourceConfiguration() {
            return this.authenticationSourceConfiguration.get();
        }

        @Override
        public Collection<String> getWhiteList() {
            return this.whiteList.get();
        }

        @Override
        public IAuthenticationConfiguration withAuthenticationMethodConfiguration(IAuthenticationMethodConfiguration config) {
            this.authenticationMethodConfiguration = () -> config;
            return this;
        }

        @Override
        public IAuthenticationConfiguration withAuthenticationSourceConfiguration(IAuthenticationSourceConfiguration config) {
            this.authenticationSourceConfiguration = () -> config;
            return this;
        }

        @Override
        public IAuthenticationConfiguration withWhiteList(Collection<String> list) {
            this.whiteList = () -> list;
            return this;
        }

        @Override
        public YamlMapping toYaml() throws YamlException {
            return null;
        }
    }
}

