/*
 * Decompiled with CFR 0.152.
 */
package prompto.security.auth.method;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import org.eclipse.jetty.security.Authenticator;
import prompto.config.IConfigurationReader;
import prompto.config.auth.method.IAuthenticationMethodConfiguration;

public interface IAuthenticationMethodFactory {
    public static IAuthenticationMethodFactory newFactory(String factoryName) throws Throwable {
        Class<?> klass = Class.forName(factoryName, true, Thread.currentThread().getContextClassLoader());
        if (!IAuthenticationMethodFactory.class.isAssignableFrom(klass)) {
            throw new RuntimeException("Not an authentication method factory: " + factoryName);
        }
        return (IAuthenticationMethodFactory)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public IAuthenticationMethodConfiguration newConfiguration(IConfigurationReader var1);

    public void setConfiguration(IAuthenticationMethodConfiguration var1);

    public Authenticator newAuthenticator(boolean var1);

    default public YamlMapping toYaml() throws YamlException {
        YamlMapping yaml = new YamlMapping();
        yaml.setEntry("factory", this.getClass().getName());
        return yaml;
    }
}

