/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.jetty.servlet.ServletHolder;
import prompto.intrinsic.PromptoBinary;
import prompto.server.AppServer;
import prompto.server.HttpUserReader;
import prompto.utils.Logger;
import prompto.value.DocumentValue;

public class CleverServlet
extends HttpServlet {
    static final Logger logger = new Logger();
    public static ThreadLocal<String> REGISTERED_ORIGINS = ThreadLocal.withInitial(() -> null);
    public static ThreadLocal<HttpServletRequest> CURRENT_REQUEST = ThreadLocal.withInitial(() -> null);
    public static ThreadLocal<HttpServletResponse> CURRENT_RESPONSE = ThreadLocal.withInitial(() -> null);
    ServletHolder holder;

    public String getServletName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Thread.currentThread().setName(((Object)((Object)this)).getClass().getSimpleName());
        HttpUserReader.readAndSet(req);
        this.readSession(req);
        CURRENT_REQUEST.set(req);
        CURRENT_RESPONSE.set(resp);
        REGISTERED_ORIGINS.set(this.readRegisteredOrigins(req));
        try {
            super.service(req, resp);
        }
        finally {
            REGISTERED_ORIGINS.set(null);
            CURRENT_REQUEST.set(null);
            CURRENT_RESPONSE.set(null);
        }
    }

    private void readSession(HttpServletRequest req) {
        DocumentValue doc = (DocumentValue)req.getSession(true).getAttribute("__prompto_http_session__");
        if (doc == null) {
            doc = new DocumentValue();
            req.getSession(true).setAttribute("__prompto_http_session__", (Object)doc);
        }
        AppServer.setHttpSession(doc);
    }

    private String readRegisteredOrigins(HttpServletRequest req) {
        return String.join((CharSequence)",", this.readRegisteredOrigin(req, false), this.readRegisteredOrigin(req, true));
    }

    private String readRegisteredOrigin(HttpServletRequest req, boolean withPort) {
        StringBuilder sb = new StringBuilder().append(req.getScheme()).append("://").append(req.getServerName());
        if (withPort) {
            sb.append(":").append(req.getServerPort());
        }
        return sb.toString();
    }

    public void setHolder(ServletHolder holder) {
        this.holder = holder;
    }

    public void setMultipartConfig(MultipartConfigElement config) {
        this.holder.getRegistration().setMultipartConfig(config);
    }

    protected void writeJSONError(String message, ServletOutputStream output) throws IOException {
        JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)output);
        generator.writeStartObject();
        generator.writeStringField("error", message);
        generator.writeNullField("data");
        generator.writeEndObject();
        generator.flush();
        generator.close();
    }

    protected void writeJSONResult(Object result, ServletOutputStream output) throws IOException {
        JsonGenerator generator = new JsonFactory().createGenerator((OutputStream)output);
        generator.setCodec((ObjectCodec)new ObjectMapper());
        generator.writeStartObject();
        generator.writeNullField("error");
        generator.writeObjectField("data", result);
        generator.writeEndObject();
        generator.flush();
        generator.close();
    }

    protected Map<String, Object> readPartsAsObjects(HttpServletRequest req) throws ServletException, IOException {
        HashMap<String, Object> parts = new HashMap<String, Object>();
        for (Part part : req.getParts()) {
            parts.put(part.getName(), this.readPartAsObject(part));
        }
        return parts;
    }

    protected Map<String, byte[]> readPartsAsBytes(HttpServletRequest req) throws ServletException, IOException {
        HashMap<String, byte[]> parts = new HashMap<String, byte[]>();
        for (Part part : req.getParts()) {
            parts.put(part.getName(), this.readPartAsBytes(part));
        }
        return parts;
    }

    private Object readPartAsObject(Part part) throws IOException {
        byte[] data = this.readPartAsBytes(part);
        if (part.getSubmittedFileName() != null) {
            String mimeType = part.getContentType();
            return new PromptoBinary(mimeType, data);
        }
        return new String(data);
    }

    private byte[] readPartAsBytes(Part part) throws IOException {
        try (InputStream input = part.getInputStream();){
            byte[] byArray;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int read;
                byte[] buffer = new byte[4096];
                while ((read = input.read(buffer)) >= 0) {
                    if (read <= 0) continue;
                    output.write(buffer, 0, read);
                }
                output.flush();
                byArray = output.toByteArray();
            }
            return byArray;
        }
    }

    protected void writeJsonResponseError(String error, OutputStream output) throws IOException {
        logger.warn(() -> error);
        JsonGenerator generator = new JsonFactory().createGenerator(output);
        generator.writeStartObject();
        generator.writeStringField("error", error);
        generator.writeNullField("data");
        generator.writeEndObject();
        generator.flush();
        generator.close();
    }
}

