/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import prompto.libraries.Libraries;
import prompto.server.AppServer;
import prompto.server.CleverServlet;
import prompto.server.MimeTypeProvider;
import prompto.server.TranspilerServlet;
import prompto.utils.Logger;
import prompto.utils.ObjectUtils;

public abstract class ResourceServlet
extends CleverServlet {
    static final Logger logger = new Logger();
    static final MimeTypes mimeTypes = new MimeTypes();
    int minMemoryMappedContentLength = 1024;
    int minAsyncContentLength = 0;
    Resource builtIns = this.getBuiltInsResource();
    String welcomePage;
    String siteMap;

    public ResourceServlet(String welcomePage, String siteMap) {
        this.welcomePage = welcomePage != null ? welcomePage : "/index.html";
        this.siteMap = siteMap != null ? siteMap : "GENERATED";
    }

    protected abstract Resource getResource(HttpServletRequest var1, String var2);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Thread.currentThread().setName(((Object)((Object)this)).getClass().getSimpleName());
        boolean writeBody = false;
        switch (request.getMethod().toUpperCase()) {
            case "GET": 
            case "POST": {
                writeBody = true;
            }
            case "HEAD": {
                break;
            }
            default: {
                super.service(request, response);
                return;
            }
        }
        boolean tryGzip = writeBody && this.acceptsGzip(request);
        Resource resource = this.getResource(request, tryGzip);
        if (resource == null || !resource.exists()) {
            response.setStatus(404);
            return;
        }
        response.setStatus(200);
        this.writeHeaders(response, resource);
        if (writeBody) {
            this.writeBody(request, response, resource);
        }
    }

    private boolean acceptsGzip(HttpServletRequest request) {
        String accept = request.getHeader(HttpHeader.ACCEPT_ENCODING.asString());
        return accept != null && accept.contains("gzip");
    }

    protected Resource getResource(HttpServletRequest request, boolean tryGzip) {
        String pathInContext;
        String pathInfo;
        String servletPath;
        Boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
        if (included != null && included.booleanValue()) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null && pathInfo == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        if ((pathInContext = URIUtil.addPaths((String)servletPath, (String)pathInfo)) == "/" && this.welcomePage != null) {
            if (this.welcomePage.endsWith(".page")) {
                return new TranspilerServlet().getResource(request, this.welcomePage);
            }
            pathInContext = this.welcomePage;
        }
        Resource resource = null;
        if (tryGzip) {
            resource = this.getClassPathResource(pathInContext + ".gz");
        }
        if (resource != null) {
            return resource;
        }
        resource = this.getClassPathResource(pathInContext);
        if (resource != null) {
            return resource;
        }
        return this.getResource(request, pathInContext);
    }

    private void writeBody(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        if (out instanceof HttpOutput) {
            this.writeBody(request, response, (HttpOutput)out, resource);
        } else {
            resource.writeTo((OutputStream)out, 0L, resource.length());
            out.close();
        }
    }

    private void writeBody(HttpServletRequest request, HttpServletResponse response, HttpOutput out, Resource resource) throws IOException {
        int minAsyncSize;
        int n = minAsyncSize = this.minAsyncContentLength == 0 ? response.getBufferSize() : this.minAsyncContentLength;
        if (request.isAsyncSupported() && minAsyncSize > 0 && resource.length() >= (long)minAsyncSize) {
            this.writeBodyAsync(request, out, resource, minAsyncSize);
        } else {
            this.writeBodySync(request, out, resource);
            out.close();
        }
    }

    private void writeBodyAsync(HttpServletRequest request, HttpOutput out, Resource resource, int minAsyncSize) throws IOException {
        final AsyncContext async = request.startAsync();
        async.setTimeout(0L);
        Callback callback = new Callback(){

            public void succeeded() {
                async.complete();
            }

            public void failed(Throwable x) {
                logger.warn(() -> x.toString());
                logger.debug(() -> x.toString(), x);
                async.complete();
            }
        };
        if (this.canUseMemoryMappedFile(resource, true)) {
            ByteBuffer buffer = BufferUtil.toMappedBuffer((File)resource.getFile());
            out.sendContent(buffer, callback);
        } else {
            ReadableByteChannel channel = resource.getReadableByteChannel();
            if (channel != null) {
                out.sendContent(channel, callback);
            } else {
                out.sendContent(resource.getInputStream(), callback);
            }
        }
    }

    private boolean canUseMemoryMappedFile(Resource resource, boolean limitToMaxInt) {
        long length = resource.length();
        return this.minMemoryMappedContentLength > 0 && length > (long)this.minMemoryMappedContentLength && resource instanceof PathResource && (!limitToMaxInt || length < Integer.MAX_VALUE);
    }

    private void writeBodySync(HttpServletRequest request, HttpOutput out, Resource resource) throws IOException {
        if (this.canUseMemoryMappedFile(resource, false)) {
            ByteBuffer buffer = BufferUtil.toMappedBuffer((File)resource.getFile());
            out.sendContent(buffer);
        } else {
            ReadableByteChannel channel = resource.getReadableByteChannel();
            if (channel != null) {
                out.sendContent(channel);
            } else {
                out.sendContent(resource.getInputStream());
            }
        }
    }

    protected void writeHeaders(HttpServletResponse response, Resource resource) {
        this.writeContentType(response, resource);
        this.writeContentLength(response, resource);
        this.writeContentEncoding(response, resource);
        this.writeCacheControl(response, resource);
        this.writeEtags(response, resource);
    }

    private void writeContentEncoding(HttpServletResponse response, Resource resource) {
        if (resource.getName().endsWith(".gz")) {
            response.setHeader(HttpHeader.CONTENT_ENCODING.asString(), "gzip");
            if (resource.getName().endsWith(".js.gz")) {
                response.setContentType("application/javascript");
            }
        }
    }

    private void writeContentType(HttpServletResponse response, Resource resource) {
        if (resource instanceof MimeTypeProvider) {
            String mimeType = ((MimeTypeProvider)resource).getMimeType();
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
        } else {
            String mimeType = mimeTypes.getMimeByExtension(resource.toString());
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
        }
    }

    private void writeContentLength(HttpServletResponse response, Resource resource) {
        long length = resource.length();
        if (length > Integer.MAX_VALUE) {
            response.setHeader(HttpHeader.CONTENT_LENGTH.asString(), Long.toString(length));
        } else if (length > 0L) {
            response.setContentLength((int)length);
        }
    }

    private void writeCacheControl(HttpServletResponse response, Resource resource) {
    }

    private void writeEtags(HttpServletResponse response, Resource resource) {
    }

    private Resource getClassPathResource(String path) {
        String realPath = URIUtil.canonicalPath((String)path);
        try {
            Resource resource = this.builtIns.addPath(realPath);
            if (resource != null && resource.exists()) {
                return resource;
            }
            return null;
        }
        catch (Throwable t) {
            logger.error(() -> "While looking for resource: " + realPath, t);
            return null;
        }
    }

    private Resource getBuiltInsResource() {
        Stream<Class> classes = Stream.concat(ObjectUtils.getClassesInCallStack().stream(), Stream.of(AppServer.class, Libraries.class));
        Set<Resource> resources = classes.filter(c -> c.getName().startsWith("prompto")).map(this::getClassResource).collect(Collectors.toSet());
        resources.forEach(res -> logger.info(() -> "Adding resource root: " + res.toString()));
        return new ResourceCollection(resources.toArray(new Resource[resources.size()]));
    }

    private Resource getClassResource(Class<?> klass) {
        try {
            URL root = this.getClassResourceURL(klass);
            return Resource.newResource((URL)root);
        }
        catch (Exception e) {
            logger.error(() -> "Unable to load resources from " + klass.getName(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private URL getClassResourceURL(Class<?> klass) throws MalformedURLException {
        URL root = klass.getProtectionDomain().getCodeSource().getLocation();
        if (root.toExternalForm().endsWith(".jar")) {
            root = new URL("jar:" + root.toExternalForm() + "!/");
        }
        return root;
    }
}

