/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.time.ZonedDateTime;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jetty.util.resource.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import prompto.code.ICodeStore;

public class SiteMapResource
extends Resource {
    public static final String SITEMAPS_URI = "http://www.sitemaps.org/schemas/sitemap/0.9";
    byte[] data;
    InputStream stream;

    public static SiteMapResource fromWebSitePages(String urlPrefix) {
        Iterable pages = ICodeStore.getInstance().fetchResourcesWithMimeTypes(new String[]{"text/html", "text/page"});
        return SiteMapResource.fromWebSitePages(urlPrefix, pages);
    }

    private static SiteMapResource fromWebSitePages(String urlPrefix, Iterable<prompto.code.Resource> pages) {
        Document doc = SiteMapResource.documentFromWebSitePages(urlPrefix, pages);
        return SiteMapResource.fromSiteMap(doc);
    }

    private static SiteMapResource fromSiteMap(Document doc) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(output);
            transformer.transform(source, result);
            return new SiteMapResource(output.toByteArray());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Document documentFromWebSitePages(String urlPrefix, Iterable<prompto.code.Resource> pages) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document doc = factory.newDocumentBuilder().newDocument();
            Element root = doc.createElementNS(SITEMAPS_URI, "urlset");
            pages.forEach(page -> {
                Element elem = SiteMapResource.elementFromWebSitePage(doc, urlPrefix, page);
                root.appendChild(elem);
            });
            doc.appendChild(root);
            return doc;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Element elementFromWebSitePage(Document doc, String urlPrefix, prompto.code.Resource page) {
        Element elem = doc.createElementNS(SITEMAPS_URI, "url");
        Element child = doc.createElementNS(SITEMAPS_URI, "loc");
        child.setTextContent(urlPrefix + page.getName());
        elem.appendChild(child);
        if (page.getLastModified() != null) {
            child = doc.createElementNS(SITEMAPS_URI, "lastmod");
            child.setTextContent(page.getLastModified().toString());
            elem.appendChild(child);
        }
        return elem;
    }

    public SiteMapResource(byte[] data) {
        this.data = data;
    }

    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }

    public boolean exists() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public long lastModified() {
        return ZonedDateTime.now().toEpochSecond();
    }

    public URL getURL() {
        try {
            return new URL("/sitemap.xml");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public File getFile() throws IOException {
        return null;
    }

    public String getName() {
        return "sitemap.xml";
    }

    public InputStream getInputStream() throws IOException {
        if (this.stream == null) {
            return new ByteArrayInputStream(this.data);
        }
        throw new IllegalStateException("InputStream is already open!");
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (IOException iOException) {}
        } else {
            throw new IllegalStateException("InputStream is not open!");
        }
    }

    public long length() {
        return this.data.length;
    }

    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return null;
    }

    public boolean delete() throws SecurityException {
        return false;
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        return false;
    }

    public String[] list() {
        return null;
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        return null;
    }
}

