/*
 * Decompiled with CFR 0.152.
 */
package prompto.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ServerSocketFactory;

public abstract class SocketUtils {
    public static int findAvailablePortInRange(int min, int max) throws IOException {
        HashSet<Integer> alreadyTried = new HashSet<Integer>();
        while (true) {
            int port;
            if (!alreadyTried.add(port = ThreadLocalRandom.current().nextInt(min, max + 1))) {
                continue;
            }
            if (SocketUtils.isAvailablePort(port)) {
                return port;
            }
            if (alreadyTried.size() >= 1 + max - min) break;
        }
        throw new IOException("No available port!");
    }

    public static boolean isAvailablePort(int port) {
        boolean bl;
        block8: {
            ServerSocket s = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            try {
                s.setReuseAddress(false);
                bl = true;
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            s.close();
        }
        return bl;
    }
}

