/*
 * Decompiled with CFR 0.152.
 */
package prompto.code;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.code.BaseCodeStore;
import prompto.code.ICodeStore;
import prompto.config.IRuntimeConfiguration;
import prompto.config.TempDirectories;
import prompto.declaration.DeclarationList;
import prompto.grammar.INamed;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.parser.Dialect;
import prompto.parser.ECleverParser;
import prompto.runtime.Context;
import prompto.runtime.Mode;
import prompto.runtime.Standalone;
import prompto.store.IStore;
import prompto.store.memory.MemStore;
import prompto.store.mongo.BaseMongoTest;

public class TestCodeStore
extends BaseMongoTest {
    @Before
    public void before() throws Exception {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
        this.createStore("APPS");
    }

    @Test
    public void fetchesDeclarationsWithAnnotationsFromResource() throws Exception {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
        Standalone.bootstrapCodeStore((IStore)new MemStore(), (IRuntimeConfiguration)this.newRuntimeConfig("prompto/graphQLMethods.pec"));
        Context context = Context.newGlobalsContext();
        Iterable decls = context.getRegisteredDeclarationsWithAnnotations(new String[]{"@GraphQLQuery", "@GraphQLMutation"});
        Set names = StreamSupport.stream(decls.spliterator(), false).map(INamed::getName).collect(Collectors.toSet());
        HashSet<String> expected = new HashSet<String>(Arrays.asList("someGraphQLQuery", "someGraphQLMutation"));
        Assert.assertEquals(expected, names);
    }

    @Test
    public void fetchesDeclarationsWithAnnotationsFromMemStore() throws Exception {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
        ICodeStore codeStore = Standalone.bootstrapCodeStore((IStore)new MemStore(), (IRuntimeConfiguration)this.newRuntimeConfig(null));
        DeclarationList read = this.parseEResource("prompto/graphQLMethods.pec");
        codeStore.storeDeclarations((Iterable)read, Dialect.E, (Object)"ModuleId");
        Context context = Context.newGlobalsContext();
        Iterable decls = context.getRegisteredDeclarationsWithAnnotations(new String[]{"@GraphQLQuery", "@GraphQLMutation"});
        Set names = StreamSupport.stream(decls.spliterator(), false).map(INamed::getName).collect(Collectors.toSet());
        HashSet<String> expected = new HashSet<String>(Arrays.asList("someGraphQLQuery", "someGraphQLMutation"));
        Assert.assertEquals(expected, names);
    }

    @Test
    public void fetchesDeclarationsWithAnnotationsFromMongoStore() throws Exception {
        TempDirectories.create();
        Mode.set((Mode)Mode.UNITTEST);
        ICodeStore codeStore = Standalone.bootstrapCodeStore((IStore)this.store, (IRuntimeConfiguration)this.newRuntimeConfig(null));
        DeclarationList read = this.parseEResource("prompto/graphQLMethods.pec");
        codeStore.storeDeclarations((Iterable)read, Dialect.E, (Object)"ModuleId");
        Context context = Context.newGlobalsContext();
        Iterable decls = context.getRegisteredDeclarationsWithAnnotations(new String[]{"@GraphQLQuery", "@GraphQLMutation"});
        Set names = StreamSupport.stream(decls.spliterator(), false).map(INamed::getName).collect(Collectors.toSet());
        HashSet<String> expected = new HashSet<String>(Arrays.asList("someGraphQLQuery", "someGraphQLMutation"));
        Assert.assertEquals(expected, names);
    }

    public DeclarationList parseEResource(String resourceName) throws Exception {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);){
            Assert.assertNotNull((String)("resource not found:" + resourceName), (Object)input);
            ECleverParser parser = new ECleverParser(input);
            DeclarationList declarationList = parser.parse_declaration_list();
            return declarationList;
        }
    }

    private IRuntimeConfiguration newRuntimeConfig(String testResourcePath) {
        ArrayList<URL> runtimeLibs = new ArrayList<URL>();
        runtimeLibs.addAll(Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, BaseCodeStore.class}));
        if (testResourcePath != null) {
            runtimeLibs.add(Thread.currentThread().getContextClassLoader().getResource(testResourcePath));
        }
        return new IRuntimeConfiguration.Inline().withApplicationName("TestCodeStore").withApplicationVersion(PromptoVersion.parseInt((int)1)).withRuntimeLibs(() -> runtimeLibs);
    }
}

