/*
 * Decompiled with CFR 0.152.
 */
package prompto.config;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import prompto.config.IConfigurationReader;
import prompto.config.ServerConfiguration;
import prompto.config.YamlConfigurationReader;
import prompto.intrinsic.PromptoDocument;
import prompto.runtime.Standalone;

public class TestApplicationConfigurationAsDocument {
    @Test
    public void convertsConfigToDocument() throws IOException {
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("configs/full-config.yml");){
            YamlConfigurationReader reader = new YamlConfigurationReader(input);
            Standalone.configuration = new ServerConfiguration((IConfigurationReader)reader, null);
            PromptoDocument config = Standalone.getApplicationConfiguration();
            Assert.assertNotNull((Object)config);
            PromptoDocument http = (PromptoDocument)config.get((Object)"http");
            Assert.assertNotNull((Object)http);
            PromptoDocument auth = (PromptoDocument)http.get((Object)"authentication");
            Assert.assertNotNull((Object)auth);
            PromptoDocument method = (PromptoDocument)auth.get((Object)"method");
            Assert.assertNotNull((Object)method);
            Assert.assertEquals((Object)"/auth/errorPage.html", (Object)method.get((Object)"errorPage"));
        }
    }
}

