/*
 * Decompiled with CFR 0.152.
 */
package prompto.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.function.Consumer;
import java.util.function.Supplier;
import prompto.debug.DebugRequestClient;
import prompto.debug.IDebugEventListener;
import prompto.debug.ProcessStatus;
import prompto.debug.Serializer;
import prompto.debug.request.IDebugRequest;
import prompto.debug.response.IDebugResponse;

public class HttpDebugRequestClient
extends DebugRequestClient {
    Supplier<Boolean> remoteAlive;

    public HttpDebugRequestClient(String host, int port, Supplier<Boolean> remoteAlive) {
        this.remoteHost = host;
        this.remotePort = port;
        this.remoteAlive = remoteAlive;
    }

    protected boolean isRemoteAlive() {
        return this.remoteAlive.get();
    }

    public void setListener(IDebugEventListener listener) {
    }

    public boolean isTerminated() {
        return false;
    }

    public void terminate() {
    }

    public void notifyTerminated() {
    }

    public ProcessStatus getProcessStatus() {
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected IDebugResponse sendRequest(IDebugRequest request, Consumer<Exception> errorHandler) {
        try {
            URL url = new URL("http://" + this.remoteHost + ":" + this.remotePort + "/ws/debug-request");
            HttpURLConnection cnx = (HttpURLConnection)url.openConnection();
            cnx.setRequestMethod("POST");
            cnx.setDoOutput(true);
            cnx.setRequestProperty("Content-Type", "application/json");
            cnx.setRequestProperty("charset", "utf-8");
            try (OutputStream output = cnx.getOutputStream();){
                IDebugResponse iDebugResponse;
                block17: {
                    Serializer.writeMessage((OutputStream)output, (Object)request);
                    if (cnx.getResponseCode() != 200) {
                        throw new IOException("Http error " + cnx.getResponseCode());
                    }
                    InputStream input = cnx.getInputStream();
                    try {
                        iDebugResponse = Serializer.readDebugResponse((InputStream)input);
                        if (input == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    input.close();
                }
                return iDebugResponse;
            }
        }
        catch (Exception e) {
            if (errorHandler != null) {
                errorHandler.accept(e);
            } else {
                e.printStackTrace(System.err);
            }
            return null;
        }
    }
}

