/*
 * Decompiled with CFR 0.152.
 */
package prompto.security.auth.source;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import prompto.security.auth.StoredUserInfoCache;
import prompto.security.auth.source.IAuthenticationSource;
import prompto.security.auth.source.StoredPasswordDigestAuthenticationSource;
import prompto.store.IStore;
import prompto.store.mongo.BaseMongoTest;

public class TestStoreLoginSource_Mongo
extends BaseMongoTest {
    IAuthenticationSource source;

    @Before
    public void before() {
        this.createStore("LOGIN_" + System.currentTimeMillis());
        StoredUserInfoCache cache = new StoredUserInfoCache((IStore)this.store);
        this.source = new StoredPasswordDigestAuthenticationSource(cache);
    }

    @Test
    public void doesNotHaveLogin() {
        Assert.assertFalse((boolean)this.source.hasLogin("john"));
    }

    @Test
    public void createsLogin() {
        this.source.createLogin("john", "password");
        Assert.assertTrue((boolean)this.source.hasLogin("john"));
    }

    @Test
    public void checksLogin() {
        this.source.createLogin("john", "password");
        Assert.assertTrue((boolean)this.source.checkLogin("john", "password"));
    }

    @Test
    public void doesNotCheckLogin() {
        this.source.createLogin("john", "password");
        Assert.assertFalse((boolean)this.source.checkLogin("john", "password2"));
    }

    @Test
    public void updatesLogin() {
        this.source.createLogin("john", "password");
        Assert.assertTrue((boolean)this.source.checkLogin("john", "password"));
        this.source.updateLogin("john", "password2");
        Assert.assertFalse((boolean)this.source.checkLogin("john", "password"));
        Assert.assertTrue((boolean)this.source.checkLogin("john", "password2"));
    }
}

