/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.document.YamlMapping;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import prompto.code.BaseCodeStore;
import prompto.code.ICodeStore;
import prompto.config.IConfigurationReader;
import prompto.config.IHttpConfiguration;
import prompto.config.IKeyStoreConfiguration;
import prompto.config.IKeyStoreFactoryConfiguration;
import prompto.config.IRuntimeConfiguration;
import prompto.config.ISecretKeyConfiguration;
import prompto.config.IServerConfiguration;
import prompto.config.TempDirectories;
import prompto.intrinsic.PromptoVersion;
import prompto.libraries.Libraries;
import prompto.runtime.Mode;
import prompto.runtime.Standalone;
import prompto.security.IKeyStoreFactory;
import prompto.security.PlainSecretKeyFactory;
import prompto.server.AppServer;
import prompto.server.JettyServer;
import prompto.store.IStore;
import prompto.store.memory.MemStore;
import prompto.utils.SocketUtils;

public abstract class BaseServerTest {
    protected BaseCodeStore tail;
    protected int port = -1;
    boolean ssl = false;

    @Before
    public void __before__() throws Throwable {
        TempDirectories.create();
        this.port = SocketUtils.findAvailablePortInRange((int)8000, (int)9000);
        IServerConfiguration config = this.getServerConfig();
        AppServer.initialize((IServerConfiguration)config);
        this.tail = this.findCodeStoreTail();
        AppServer.startServer((IServerConfiguration)config, this::prepareHandlers, null, null, null);
        Assert.assertTrue((boolean)AppServer.isStarted());
    }

    @After
    public void __after__() throws Exception {
        if (this.tail != null) {
            this.tail.setNext(null);
        }
        this.port = -1;
        if (AppServer.isStarted()) {
            AppServer.stop();
            Thread.sleep(100L);
        }
    }

    public boolean isAlive() {
        return AppServer.isStarted();
    }

    public BaseCodeStore getTail() {
        return this.tail;
    }

    public int getPort() {
        return this.port;
    }

    private BaseCodeStore findCodeStoreTail() {
        ICodeStore store = ICodeStore.getInstance();
        while (store instanceof BaseCodeStore) {
            ICodeStore next = ((BaseCodeStore)store).getNext();
            if (next == null) {
                return (BaseCodeStore)store;
            }
            store = next;
        }
        return null;
    }

    protected IServerConfiguration getServerConfig() {
        return (IServerConfiguration)new IServerConfiguration.Inline().withHttpConfiguration(this.ssl ? this.getHttpsConfiguration() : this.getHttpConfiguration()).withApplicationVersion(PromptoVersion.parse((String)"1.0.0")).withApplicationName("test").withRuntimeLibs(() -> Libraries.getPromptoLibraries((Class[])new Class[]{Libraries.class, AppServer.class})).withLoadRuntime(false).withRuntimeMode(Mode.UNITTEST);
    }

    protected IHttpConfiguration getHttpsConfiguration() {
        return new IHttpConfiguration.Inline().withProtocol("https").withPort(this.port).withKeyStoreConfiguration(new IKeyStoreConfiguration(){

            public IKeyStoreFactoryConfiguration getKeyStoreFactoryConfiguration() {
                return new IKeyStoreFactoryConfiguration(){

                    public IKeyStoreFactory getKeyStoreFactory() {
                        return new IKeyStoreFactory(){

                            public KeyStore newInstance(IKeyStoreFactoryConfiguration config) {
                                KeyStore keyStore;
                                block8: {
                                    URL url = Thread.currentThread().getContextClassLoader().getResource("security/keystore_test.jks");
                                    Resource resource = URLResource.newResource((URL)url);
                                    KeyStore ks = KeyStore.getInstance("JKS");
                                    InputStream stream = resource.getInputStream();
                                    try {
                                        ks.load(stream, null);
                                        keyStore = ks;
                                        if (stream == null) break block8;
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            if (stream != null) {
                                                try {
                                                    stream.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        catch (Exception e) {
                                            throw new RuntimeException(e);
                                        }
                                    }
                                    stream.close();
                                }
                                return keyStore;
                            }

                            public IKeyStoreFactoryConfiguration newConfiguration(IConfigurationReader reader) {
                                return null;
                            }
                        };
                    }

                    public YamlMapping toYaml() throws YamlException {
                        return null;
                    }
                };
            }

            public ISecretKeyConfiguration getSecretKeyConfiguration() {
                return new ISecretKeyConfiguration(){

                    public String getFactory() {
                        return PlainSecretKeyFactory.class.getName();
                    }

                    public char[] getSecret() {
                        return "password".toCharArray();
                    }
                };
            }

            public YamlMapping toYaml() throws YamlException {
                return null;
            }
        }).withTrustStoreConfiguration(new IKeyStoreConfiguration(){

            public IKeyStoreFactoryConfiguration getKeyStoreFactoryConfiguration() {
                return new IKeyStoreFactoryConfiguration(){

                    public IKeyStoreFactory getKeyStoreFactory() {
                        return new IKeyStoreFactory(){

                            public KeyStore newInstance(IKeyStoreFactoryConfiguration config) {
                                KeyStore keyStore;
                                block8: {
                                    URL url = Thread.currentThread().getContextClassLoader().getResource("security/truststore_test.jks");
                                    Resource resource = URLResource.newResource((URL)url);
                                    KeyStore ks = KeyStore.getInstance("JKS");
                                    InputStream stream = resource.getInputStream();
                                    try {
                                        ks.load(stream, null);
                                        keyStore = ks;
                                        if (stream == null) break block8;
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            if (stream != null) {
                                                try {
                                                    stream.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        catch (Exception e) {
                                            throw new RuntimeException(e);
                                        }
                                    }
                                    stream.close();
                                }
                                return keyStore;
                            }

                            public IKeyStoreFactoryConfiguration newConfiguration(IConfigurationReader reader) {
                                return null;
                            }
                        };
                    }

                    public YamlMapping toYaml() {
                        return null;
                    }
                };
            }

            public ISecretKeyConfiguration getSecretKeyConfiguration() {
                return new ISecretKeyConfiguration(){

                    public String getFactory() {
                        return PlainSecretKeyFactory.class.getName();
                    }

                    public char[] getSecret() {
                        return "password".toCharArray();
                    }
                };
            }

            public YamlMapping toYaml() throws YamlException {
                return null;
            }
        });
    }

    protected IHttpConfiguration getHttpConfiguration() {
        return new IHttpConfiguration.Inline().withProtocol("http").withPort(this.port);
    }

    public void prepareHandlers(JettyServer jetty, HandlerList list) {
        try {
            if (this.ssl) {
                list.addHandler((Handler)new SecuredRedirectHandler());
            }
            list.addHandler((Handler)jetty.newWebSiteHandler());
            list.addHandler((Handler)jetty.newWebApiHandler());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void bootstrapCodeStore(IServerConfiguration config) throws Exception {
        Standalone.bootstrapCodeStore((IStore)new MemStore(), (IRuntimeConfiguration)config);
    }
}

