/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import java.net.URI;
import java.net.http.HttpRequest;
import org.junit.Assert;
import org.junit.Test;
import prompto.server.AppServer;
import prompto.server.BaseServerTest;
import prompto.utils.SSLUtils;

public class TestConnectSSL
extends BaseServerTest {
    public TestConnectSSL() {
        this.ssl = true;
    }

    @Test
    public void testStartAndStop() throws Throwable {
        AppServer.stop();
        Assert.assertFalse((boolean)AppServer.isStarted());
        AppServer.start(null);
        Assert.assertTrue((boolean)AppServer.isStarted());
        AppServer.stop();
        Assert.assertFalse((boolean)AppServer.isStarted());
    }

    @Test
    public void testResource() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(new URI("https://localhost:" + this.port + "/ws/control/version")).build();
        Assert.assertTrue((boolean)((Boolean)SSLUtils.trustingAllCertificates((HttpRequest)request, s -> "1.0.0".equals(s))));
    }
}

