/*
 * Decompiled with CFR 0.152.
 */
package prompto.server;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.esotericsoftware.yamlbeans.document.YamlDocument;
import com.esotericsoftware.yamlbeans.document.YamlDocumentReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.ModuleType;
import prompto.intrinsic.PromptoVersion;
import prompto.parser.Dialect;
import prompto.runtime.ApplicationContext;
import prompto.runtime.Standalone;
import prompto.server.BaseUITest;
import prompto.server.HeadlessTests;
import prompto.store.DataStore;
import prompto.store.IStore;
import prompto.store.memory.MemStore;

@Category(value={HeadlessTests.class})
public class TestScheduler
extends BaseUITest {
    Path tempDir;

    @Before
    public void before() throws Exception {
        ApplicationContext.reset();
        DataStore.setGlobal((IStore)new MemStore());
        DataStore.useGlobal();
        Standalone.synchronizeSchema((ICodeStore)ICodeStore.getInstance(), (IStore)DataStore.getInstance());
    }

    @Test
    public void schedulerJobIsExecuted() throws Exception {
        this.linkResourcesAndLoadPage("SchedulerJobIsExecuted", Dialect.O);
        Thread.sleep(3000L);
        WebElement root = this.waitElement(By.id((String)"body"), 3);
        Assert.assertEquals((Object)"EXECUTED", (Object)root.getText());
    }

    @Test
    public void schedulerJobIsRepeated() throws Exception {
        this.linkResourcesAndLoadPage("SchedulerJobIsRepeated", Dialect.O);
        Thread.sleep(5000L);
        WebElement root = this.waitElement(By.id((String)"body"), 3);
        Assert.assertEquals((Object)"/ONCE/ONCE/ONCE", (Object)root.getText());
    }

    @Test
    public void schedulerJobIsCancelled() throws Exception {
        this.linkResourcesAndLoadPage("SchedulerJobIsCancelled", Dialect.O);
        Thread.sleep(3000L);
        WebElement root = this.waitElement(By.id((String)"body"), 3);
        Assert.assertEquals((Object)"CANCELLED", (Object)root.getText());
    }

    private void linkResourcesAndLoadPage(String resourceName, Dialect dialect) throws Exception {
        URL codeResourceURL = Thread.currentThread().getContextClassLoader().getResource("scheduler-tests/" + resourceName + ".p" + dialect.name().toLowerCase() + "c");
        ImmutableCodeStore codeResource = new ImmutableCodeStore(null, ModuleType.LIBRARY, codeResourceURL, PromptoVersion.LATEST);
        URL pageResourceURL = Thread.currentThread().getContextClassLoader().getResource("scheduler-tests/" + resourceName + ".page");
        if (pageResourceURL == null) {
            pageResourceURL = this.createTempPage(resourceName);
        }
        ImmutableCodeStore pageResource = new ImmutableCodeStore((ICodeStore)codeResource, ModuleType.LIBRARY, pageResourceURL, PromptoVersion.LATEST);
        this.tail.setNext((ICodeStore)pageResource);
        String url = "http://localhost:" + HTTP_PORT + "/" + resourceName + ".page";
        webDriver.get(url);
    }

    private URL createTempPage(String resourceName) throws Exception {
        YamlDocument template;
        try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("scheduler-tests/generic.page");){
            template = new YamlDocumentReader((Reader)new InputStreamReader(input)).read();
        }
        YamlDocument body = (YamlDocument)template.getEntry("body").getValue();
        body.getEntry("widget").setValue(resourceName + "Page");
        if (this.tempDir == null) {
            this.tempDir = Files.createTempDirectory("prompto_pages_", new FileAttribute[0]);
        }
        File pageFile = new File(this.tempDir.toFile(), resourceName + ".page");
        try (FileWriter writer = new FileWriter(pageFile);){
            YamlConfig config = new YamlConfig();
            config.writeConfig.setWriteClassname(YamlConfig.WriteClassName.NEVER);
            config.writeConfig.setAutoAnchor(false);
            new YamlWriter((Writer)writer, config).write((Object)template);
        }
        return pageFile.toURI().toURL();
    }
}

